//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import (
	"encoding/json"
	"reflect"
	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// AccessProfile - Profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// Base64-encoded Kubernetes configuration file.
	KubeConfig []byte `json:"kubeConfig,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AccessProfile.
func (a AccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateByteArray(objectMap, "kubeConfig", a.KubeConfig, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessProfile.
func (a *AccessProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubeConfig":
			err = runtime.DecodeByteArray(string(val), &a.KubeConfig, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// AgentPool - Agent Pool.
type AgentPool struct {
	SubResource
	// Properties of an agent pool.
	Properties *ManagedClusterAgentPoolProfileProperties `json:"properties,omitempty"`
}

// AgentPoolAvailableVersions - The list of available versions for an agent pool.
type AgentPoolAvailableVersions struct {
	// REQUIRED; Properties of agent pool available versions.
	Properties *AgentPoolAvailableVersionsProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the agent pool version list.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the agent pool version list.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Type of the agent pool version list.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolAvailableVersionsProperties - The list of available agent pool versions.
type AgentPoolAvailableVersionsProperties struct {
	// List of versions available for agent pool.
	AgentPoolVersions []*AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem `json:"agentPoolVersions,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolAvailableVersionsProperties.
func (a AgentPoolAvailableVersionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentPoolVersions", a.AgentPoolVersions)
	return json.Marshal(objectMap)
}

type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem struct {
	// Whether this version is the default agent pool version.
	Default *bool `json:"default,omitempty"`

	// Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolListResult - The response from the List Agent Pools operation.
type AgentPoolListResult struct {
	// The list of agent pools.
	Value []*AgentPool `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of agent pool results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolListResult.
func (a AgentPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// AgentPoolUpgradeProfile - The list of available upgrades for an agent pool.
type AgentPoolUpgradeProfile struct {
	// REQUIRED; The properties of the agent pool upgrade profile.
	Properties *AgentPoolUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the agent pool upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the agent pool upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the agent pool upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentPoolUpgradeProfileProperties - The list of available upgrade versions.
type AgentPoolUpgradeProfileProperties struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// The latest AKS supported node image version.
	LatestNodeImageVersion *string `json:"latestNodeImageVersion,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*AgentPoolUpgradeProfilePropertiesUpgradesItem `json:"upgrades,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeProfileProperties.
func (a AgentPoolUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	populate(objectMap, "latestNodeImageVersion", a.LatestNodeImageVersion)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "upgrades", a.Upgrades)
	return json.Marshal(objectMap)
}

type AgentPoolUpgradeProfilePropertiesUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// AgentPoolUpgradeSettings - Settings for upgrading an agentpool
type AgentPoolUpgradeSettings struct {
	// This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool
	// size at the time of the upgrade. For
	// percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see:
	// https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
	MaxSurge *string `json:"maxSurge,omitempty"`
}

// AgentPoolsBeginCreateOrUpdateOptions contains the optional parameters for the AgentPools.BeginCreateOrUpdate method.
type AgentPoolsBeginCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsBeginDeleteOptions contains the optional parameters for the AgentPools.BeginDelete method.
type AgentPoolsBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsBeginUpgradeNodeImageVersionOptions contains the optional parameters for the AgentPools.BeginUpgradeNodeImageVersion method.
type AgentPoolsBeginUpgradeNodeImageVersionOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsGetAvailableAgentPoolVersionsOptions contains the optional parameters for the AgentPools.GetAvailableAgentPoolVersions method.
type AgentPoolsGetAvailableAgentPoolVersionsOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsGetOptions contains the optional parameters for the AgentPools.Get method.
type AgentPoolsGetOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsGetUpgradeProfileOptions contains the optional parameters for the AgentPools.GetUpgradeProfile method.
type AgentPoolsGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// AgentPoolsListOptions contains the optional parameters for the AgentPools.List method.
type AgentPoolsListOptions struct {
	// placeholder for future optional parameters
}

// CloudError - An error response from the Container service.
// Implements the error and azcore.HTTPResponse interfaces.
type CloudError struct {
	raw string
	// Details about the error.
	InnerError *CloudErrorBody `json:"error,omitempty"`
}

// Error implements the error interface for type CloudError.
// The contents of the error text are not contractual and subject to change.
func (e CloudError) Error() string {
	return e.raw
}

// CloudErrorBody - An error response from the Container service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type CloudErrorBody.
func (c CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// CommandResultProperties - The results of a run command
type CommandResultProperties struct {
	// READ-ONLY; The exit code of the command
	ExitCode *int32 `json:"exitCode,omitempty" azure:"ro"`

	// READ-ONLY; The time when the command finished.
	FinishedAt *time.Time `json:"finishedAt,omitempty" azure:"ro"`

	// READ-ONLY; The command output.
	Logs *string `json:"logs,omitempty" azure:"ro"`

	// READ-ONLY; provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; An explanation of why provisioningState is set to failed (if so).
	Reason *string `json:"reason,omitempty" azure:"ro"`

	// READ-ONLY; The time when the command started.
	StartedAt *time.Time `json:"startedAt,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type CommandResultProperties.
func (c CommandResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "exitCode", c.ExitCode)
	populate(objectMap, "finishedAt", (*timeRFC3339)(c.FinishedAt))
	populate(objectMap, "logs", c.Logs)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "reason", c.Reason)
	populate(objectMap, "startedAt", (*timeRFC3339)(c.StartedAt))
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommandResultProperties.
func (c *CommandResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exitCode":
			err = unpopulate(val, &c.ExitCode)
			delete(rawMsg, key)
		case "finishedAt":
			var aux timeRFC3339
			err = unpopulate(val, &aux)
			c.FinishedAt = (*time.Time)(&aux)
			delete(rawMsg, key)
		case "logs":
			err = unpopulate(val, &c.Logs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, &c.ProvisioningState)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, &c.Reason)
			delete(rawMsg, key)
		case "startedAt":
			var aux timeRFC3339
			err = unpopulate(val, &aux)
			c.StartedAt = (*time.Time)(&aux)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// ContainerServiceDiagnosticsProfile - Profile for diagnostics on the container service cluster.
type ContainerServiceDiagnosticsProfile struct {
	// REQUIRED; Profile for diagnostics on the container service VMs.
	VMDiagnostics *ContainerServiceVMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// ContainerServiceLinuxProfile - Profile for Linux VMs in the container service cluster.
type ContainerServiceLinuxProfile struct {
	// REQUIRED; The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`

	// REQUIRED; The SSH configuration for Linux-based VMs running on Azure.
	SSH *ContainerServiceSSHConfiguration `json:"ssh,omitempty"`
}

// ContainerServiceMasterProfile - Profile for the container service master.
type ContainerServiceMasterProfile struct {
	// REQUIRED; DNS prefix to be used to create the FQDN for the master pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// REQUIRED; Size of agent VMs.
	VMSize *ContainerServiceVMSizeTypes `json:"vmSize,omitempty"`

	// Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
	Count *Count `json:"count,omitempty"`

	// FirstConsecutiveStaticIP used to specify the first static ip of masters.
	FirstConsecutiveStaticIP *string `json:"firstConsecutiveStaticIP,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk
	// size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
	// orchestrator choice.
	StorageProfile *ContainerServiceStorageProfileTypes `json:"storageProfile,omitempty"`

	// VNet SubnetID specifies the VNet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// READ-ONLY; FQDN for the master pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// ContainerServiceNetworkProfile - Profile of network configuration.
type ContainerServiceNetworkProfile struct {
	// An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`

	// A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`

	// Profile of the cluster load balancer.
	LoadBalancerProfile *ManagedClusterLoadBalancerProfile `json:"loadBalancerProfile,omitempty"`

	// The default is 'standard'. See Azure Load Balancer SKUs [https://docs.microsoft.com/azure/load-balancer/skus] for more information about the differences
	// between load balancer SKUs.
	LoadBalancerSKU *LoadBalancerSKU `json:"loadBalancerSku,omitempty"`

	// Profile of the cluster NAT gateway.
	NatGatewayProfile *ManagedClusterNATGatewayProfile `json:"natGatewayProfile,omitempty"`

	// This cannot be specified if networkPlugin is anything other than 'azure'.
	NetworkMode *NetworkMode `json:"networkMode,omitempty"`

	// Network plugin used for building the Kubernetes network.
	NetworkPlugin *NetworkPlugin `json:"networkPlugin,omitempty"`

	// Network policy used for building the Kubernetes network.
	NetworkPolicy *NetworkPolicy `json:"networkPolicy,omitempty"`

	// This can only be set at cluster creation time and cannot be changed later. For more information see egress outbound type [https://docs.microsoft.com/azure/aks/egress-outboundtype].
	OutboundType *OutboundType `json:"outboundType,omitempty"`

	// A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`

	// A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
}

// ContainerServiceSSHConfiguration - SSH configuration for Linux-based VMs running on Azure.
type ContainerServiceSSHConfiguration struct {
	// REQUIRED; The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
	PublicKeys []*ContainerServiceSSHPublicKey `json:"publicKeys,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceSSHConfiguration.
func (c ContainerServiceSSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicKeys", c.PublicKeys)
	return json.Marshal(objectMap)
}

// ContainerServiceSSHPublicKey - Contains information about SSH certificate public key data.
type ContainerServiceSSHPublicKey struct {
	// REQUIRED; Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// ContainerServiceVMDiagnostics - Profile for diagnostics on the container service VMs.
type ContainerServiceVMDiagnostics struct {
	// REQUIRED; Whether the VM diagnostic agent is provisioned on the VM.
	Enabled *bool `json:"enabled,omitempty"`

	// READ-ONLY; The URI of the storage account where diagnostics are stored.
	StorageURI *string `json:"storageUri,omitempty" azure:"ro"`
}

// CreationData - Data used when creating a target resource from a source resource.
type CreationData struct {
	// This is the ARM ID of the source object to be used to create the target object.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// CredentialResult - The credential result response.
type CredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type CredentialResult.
func (c CredentialResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", c.Name)
	populateByteArray(objectMap, "value", c.Value, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialResult.
func (c *CredentialResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, &c.Name)
			delete(rawMsg, key)
		case "value":
			err = runtime.DecodeByteArray(string(val), &c.Value, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// CredentialResults - The list credential result response.
type CredentialResults struct {
	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs []*CredentialResult `json:"kubeconfigs,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type CredentialResults.
func (c CredentialResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "kubeconfigs", c.Kubeconfigs)
	return json.Marshal(objectMap)
}

// EndpointDependency - A domain name that AKS agent nodes are reaching at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`

	// The Ports and Protocols used when connecting to domainName.
	EndpointDetails []*EndpointDetail `json:"endpointDetails,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDependency.
func (e EndpointDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "domainName", e.DomainName)
	populate(objectMap, "endpointDetails", e.EndpointDetails)
	return json.Marshal(objectMap)
}

// EndpointDetail - connect information from the AKS agent nodes to a single endpoint.
type EndpointDetail struct {
	// Description of the detail
	Description *string `json:"description,omitempty"`

	// An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`

	// The protocol used for connection
	Protocol *string `json:"protocol,omitempty"`
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

// KubeletConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for more details.
type KubeletConfig struct {
	// Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in *).
	AllowedUnsafeSysctls []*string `json:"allowedUnsafeSysctls,omitempty"`

	// The default is true.
	CPUCfsQuota *bool `json:"cpuCfsQuota,omitempty"`

	// The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported
	// units are 'ns', 'us', 'ms', 's', 'm', and
	// 'h'.
	CPUCfsQuotaPeriod *string `json:"cpuCfsQuotaPeriod,omitempty"`

	// The default is 'none'. See Kubernetes CPU management policies [https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies]
	// for more information. Allowed
	// values are 'none' and 'static'.
	CPUManagerPolicy *string `json:"cpuManagerPolicy,omitempty"`

	// The maximum number of container log files that can be present for a container. The number must be ≥ 2.
	ContainerLogMaxFiles *int32 `json:"containerLogMaxFiles,omitempty"`

	// The maximum size (e.g. 10Mi) of container log file before it is rotated.
	ContainerLogMaxSizeMB *int32 `json:"containerLogMaxSizeMB,omitempty"`

	// If set to true it will make the Kubelet fail to start if swap is enabled on the node.
	FailSwapOn *bool `json:"failSwapOn,omitempty"`

	// To disable image garbage collection, set to 100. The default is 85%
	ImageGcHighThreshold *int32 `json:"imageGcHighThreshold,omitempty"`

	// This cannot be set higher than imageGcHighThreshold. The default is 80%
	ImageGcLowThreshold *int32 `json:"imageGcLowThreshold,omitempty"`

	// The maximum number of processes per pod.
	PodMaxPids *int32 `json:"podMaxPids,omitempty"`

	// For more information see Kubernetes Topology Manager [https://kubernetes.io/docs/tasks/administer-cluster/topology-manager]. The default is 'none'. Allowed
	// values are 'none', 'best-effort',
	// 'restricted', and 'single-numa-node'.
	TopologyManagerPolicy *string `json:"topologyManagerPolicy,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type KubeletConfig.
func (k KubeletConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedUnsafeSysctls", k.AllowedUnsafeSysctls)
	populate(objectMap, "cpuCfsQuota", k.CPUCfsQuota)
	populate(objectMap, "cpuCfsQuotaPeriod", k.CPUCfsQuotaPeriod)
	populate(objectMap, "cpuManagerPolicy", k.CPUManagerPolicy)
	populate(objectMap, "containerLogMaxFiles", k.ContainerLogMaxFiles)
	populate(objectMap, "containerLogMaxSizeMB", k.ContainerLogMaxSizeMB)
	populate(objectMap, "failSwapOn", k.FailSwapOn)
	populate(objectMap, "imageGcHighThreshold", k.ImageGcHighThreshold)
	populate(objectMap, "imageGcLowThreshold", k.ImageGcLowThreshold)
	populate(objectMap, "podMaxPids", k.PodMaxPids)
	populate(objectMap, "topologyManagerPolicy", k.TopologyManagerPolicy)
	return json.Marshal(objectMap)
}

// LinuxOSConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for more details.
type LinuxOSConfig struct {
	// The size in MB of a swap file that will be created on each node.
	SwapFileSizeMB *int32 `json:"swapFileSizeMB,omitempty"`

	// Sysctl settings for Linux agent nodes.
	Sysctls *SysctlConfig `json:"sysctls,omitempty"`

	// Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageDefrag *string `json:"transparentHugePageDefrag,omitempty"`

	// Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageEnabled *string `json:"transparentHugePageEnabled,omitempty"`
}

// MaintenanceConfiguration - See planned maintenance [https://docs.microsoft.com/azure/aks/planned-maintenance] for more information about planned maintenance.
type MaintenanceConfiguration struct {
	SubResource
	// Properties of a default maintenance configuration.
	Properties *MaintenanceConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// MaintenanceConfigurationListResult - The response from the List maintenance configurations operation.
type MaintenanceConfigurationListResult struct {
	// The list of maintenance configurations.
	Value []*MaintenanceConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of maintenance configuration results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceConfigurationListResult.
func (m MaintenanceConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// MaintenanceConfigurationProperties - Properties used to configure planned maintenance for a Managed Cluster.
type MaintenanceConfigurationProperties struct {
	// Time slots on which upgrade is not allowed.
	NotAllowedTime []*TimeSpan `json:"notAllowedTime,omitempty"`

	// If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
	TimeInWeek []*TimeInWeek `json:"timeInWeek,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceConfigurationProperties.
func (m MaintenanceConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "notAllowedTime", m.NotAllowedTime)
	populate(objectMap, "timeInWeek", m.TimeInWeek)
	return json.Marshal(objectMap)
}

// MaintenanceConfigurationsCreateOrUpdateOptions contains the optional parameters for the MaintenanceConfigurations.CreateOrUpdate method.
type MaintenanceConfigurationsCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsDeleteOptions contains the optional parameters for the MaintenanceConfigurations.Delete method.
type MaintenanceConfigurationsDeleteOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsGetOptions contains the optional parameters for the MaintenanceConfigurations.Get method.
type MaintenanceConfigurationsGetOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceConfigurationsListByManagedClusterOptions contains the optional parameters for the MaintenanceConfigurations.ListByManagedCluster method.
type MaintenanceConfigurationsListByManagedClusterOptions struct {
	// placeholder for future optional parameters
}

// ManagedCluster - Managed cluster.
type ManagedCluster struct {
	Resource
	// The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity `json:"identity,omitempty"`

	// Properties of a managed cluster.
	Properties *ManagedClusterProperties `json:"properties,omitempty"`

	// The managed cluster SKU.
	SKU *ManagedClusterSKU `json:"sku,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCluster.
func (m ManagedCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	m.Resource.marshalInternal(objectMap)
	populate(objectMap, "extendedLocation", m.ExtendedLocation)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	return json.Marshal(objectMap)
}

// ManagedClusterAADProfile - For more details see managed AAD on AKS [https://docs.microsoft.com/azure/aks/managed-aad].
type ManagedClusterAADProfile struct {
	// The list of AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs []*string `json:"adminGroupObjectIDs,omitempty"`

	// The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`

	// Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRBAC *bool `json:"enableAzureRBAC,omitempty"`

	// Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`

	// The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`

	// The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`

	// The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAADProfile.
func (m ManagedClusterAADProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminGroupObjectIDs", m.AdminGroupObjectIDs)
	populate(objectMap, "clientAppID", m.ClientAppID)
	populate(objectMap, "enableAzureRBAC", m.EnableAzureRBAC)
	populate(objectMap, "managed", m.Managed)
	populate(objectMap, "serverAppID", m.ServerAppID)
	populate(objectMap, "serverAppSecret", m.ServerAppSecret)
	populate(objectMap, "tenantID", m.TenantID)
	return json.Marshal(objectMap)
}

// ManagedClusterAPIServerAccessProfile - Access profile for managed cluster API server.
type ManagedClusterAPIServerAccessProfile struct {
	// IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters
	// that are using a Basic Load Balancer. For more
	// information see API server authorized IP ranges [https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges].
	AuthorizedIPRanges []*string `json:"authorizedIPRanges,omitempty"`

	// Whether to disable run command for the cluster or not.
	DisableRunCommand *bool `json:"disableRunCommand,omitempty"`

	// For more details, see Creating a private AKS cluster [https://docs.microsoft.com/azure/aks/private-clusters].
	EnablePrivateCluster *bool `json:"enablePrivateCluster,omitempty"`

	// Whether to create additional public FQDN for private cluster or not.
	EnablePrivateClusterPublicFQDN *bool `json:"enablePrivateClusterPublicFQDN,omitempty"`

	// The default is System. For more details see configure private DNS zone [https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone].
	// Allowed values are 'system' and 'none'.
	PrivateDNSZone *string `json:"privateDNSZone,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAPIServerAccessProfile.
func (m ManagedClusterAPIServerAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorizedIPRanges", m.AuthorizedIPRanges)
	populate(objectMap, "disableRunCommand", m.DisableRunCommand)
	populate(objectMap, "enablePrivateCluster", m.EnablePrivateCluster)
	populate(objectMap, "enablePrivateClusterPublicFQDN", m.EnablePrivateClusterPublicFQDN)
	populate(objectMap, "privateDNSZone", m.PrivateDNSZone)
	return json.Marshal(objectMap)
}

// ManagedClusterAccessProfile - Managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	Resource
	// AccessProfile of a managed cluster.
	Properties *AccessProfile `json:"properties,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAccessProfile.
func (m ManagedClusterAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	m.Resource.marshalInternal(objectMap)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// ManagedClusterAddonProfile - A Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// REQUIRED; Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config,omitempty"`

	// READ-ONLY; Information of user assigned identity used by this add-on.
	Identity *ManagedClusterAddonProfileIdentity `json:"identity,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAddonProfile.
func (m ManagedClusterAddonProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "config", m.Config)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "identity", m.Identity)
	return json.Marshal(objectMap)
}

// ManagedClusterAddonProfileIdentity - Information of user assigned identity used by this add-on.
type ManagedClusterAddonProfileIdentity struct {
	UserAssignedIdentity
}

// ManagedClusterAgentPoolProfile - Profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	ManagedClusterAgentPoolProfileProperties
	// REQUIRED; Windows agent pool names must be 6 characters or less.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAgentPoolProfile.
func (m ManagedClusterAgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	m.ManagedClusterAgentPoolProfileProperties.marshalInternal(objectMap)
	populate(objectMap, "name", m.Name)
	return json.Marshal(objectMap)
}

// ManagedClusterAgentPoolProfileProperties - Properties for the container service agent pool profile.
type ManagedClusterAgentPoolProfileProperties struct {
	// The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones []*string `json:"availabilityZones,omitempty"`

	// Desired Number of agents (VMs) specified to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in
	// the range of 1 to 1000 (inclusive) for system
	// pools. The default value is 1.
	Count *int32 `json:"count,omitempty"`

	// CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`

	// This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`

	// See Add a FIPS-enabled node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview] for more details.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`

	// Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where
	// a console needs to make a direct connection to a
	// cloud virtual machine to minimize hops. For more information see assigning a public IP per node
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools]. The default is false.
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`

	// Whether to enable UltraSSD
	EnableUltraSSD *bool `json:"enableUltraSSD,omitempty"`

	// GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
	GpuInstanceProfile *GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`

	// The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`

	// Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
	KubeletDiskType *KubeletDiskType `json:"kubeletDiskType,omitempty"`

	// The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`

	// The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`

	// The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`

	// The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`

	// A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
	Mode *AgentPoolMode `json:"mode,omitempty"`

	// The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels,omitempty"`

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`

	// The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string `json:"nodeTaints,omitempty"`

	// OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk
	// size according to the vmSize specified.
	OSDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`

	// The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not
	// be changed after creation. For more information
	// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
	OSDiskType *OSDiskType `json:"osDiskType,omitempty"`

	// Specifies an OS SKU. This value must not be specified if OSType is Windows.
	OSSKU *OSSKU `json:"osSKU,omitempty"`

	// The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major
	// version as the control plane. The node pool minor
	// version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more
	// information see upgrading a node pool
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool].
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`

	// If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string `json:"podSubnetID,omitempty"`

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`

	// This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
	ScaleDownMode *ScaleDownMode `json:"scaleDownMode,omitempty"`

	// This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`

	// The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
	ScaleSetPriority *ScaleSetPriority `json:"scaleSetPriority,omitempty"`

	// Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing,
	// see spot VMs pricing
	// [https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing]
	SpotMaxPrice *float32 `json:"spotMaxPrice,omitempty"`

	// The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags,omitempty"`

	// The type of Agent Pool.
	Type *AgentPoolType `json:"type,omitempty"`

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`

	// VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more
	// details on restricted VM sizes, see:
	// https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize *string `json:"vmSize,omitempty"`

	// If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it
	// applies to just nodes. This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`

	// Determines the type of workload a node can run.
	WorkloadRuntime *WorkloadRuntime `json:"workloadRuntime,omitempty"`

	// READ-ONLY; The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty" azure:"ro"`

	// READ-ONLY; Describes whether the Agent Pool is Running or Stopped
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAgentPoolProfileProperties.
func (m ManagedClusterAgentPoolProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	m.marshalInternal(objectMap)
	return json.Marshal(objectMap)
}

func (m ManagedClusterAgentPoolProfileProperties) marshalInternal(objectMap map[string]interface{}) {
	populate(objectMap, "availabilityZones", m.AvailabilityZones)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "creationData", m.CreationData)
	populate(objectMap, "enableAutoScaling", m.EnableAutoScaling)
	populate(objectMap, "enableEncryptionAtHost", m.EnableEncryptionAtHost)
	populate(objectMap, "enableFIPS", m.EnableFIPS)
	populate(objectMap, "enableNodePublicIP", m.EnableNodePublicIP)
	populate(objectMap, "enableUltraSSD", m.EnableUltraSSD)
	populate(objectMap, "gpuInstanceProfile", m.GpuInstanceProfile)
	populate(objectMap, "kubeletConfig", m.KubeletConfig)
	populate(objectMap, "kubeletDiskType", m.KubeletDiskType)
	populate(objectMap, "linuxOSConfig", m.LinuxOSConfig)
	populate(objectMap, "maxCount", m.MaxCount)
	populate(objectMap, "maxPods", m.MaxPods)
	populate(objectMap, "minCount", m.MinCount)
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "nodeImageVersion", m.NodeImageVersion)
	populate(objectMap, "nodeLabels", m.NodeLabels)
	populate(objectMap, "nodePublicIPPrefixID", m.NodePublicIPPrefixID)
	populate(objectMap, "nodeTaints", m.NodeTaints)
	populate(objectMap, "osDiskSizeGB", m.OSDiskSizeGB)
	populate(objectMap, "osDiskType", m.OSDiskType)
	populate(objectMap, "osSKU", m.OSSKU)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "orchestratorVersion", m.OrchestratorVersion)
	populate(objectMap, "podSubnetID", m.PodSubnetID)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "proximityPlacementGroupID", m.ProximityPlacementGroupID)
	populate(objectMap, "scaleDownMode", m.ScaleDownMode)
	populate(objectMap, "scaleSetEvictionPolicy", m.ScaleSetEvictionPolicy)
	populate(objectMap, "scaleSetPriority", m.ScaleSetPriority)
	populate(objectMap, "spotMaxPrice", m.SpotMaxPrice)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "upgradeSettings", m.UpgradeSettings)
	populate(objectMap, "vmSize", m.VMSize)
	populate(objectMap, "vnetSubnetID", m.VnetSubnetID)
	populate(objectMap, "workloadRuntime", m.WorkloadRuntime)
}

// ManagedClusterAutoUpgradeProfile - Auto upgrade profile for a managed cluster.
type ManagedClusterAutoUpgradeProfile struct {
	// For more information see setting the AKS cluster auto-upgrade channel [https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel].
	UpgradeChannel *UpgradeChannel `json:"upgradeChannel,omitempty"`
}

// ManagedClusterHTTPProxyConfig - Cluster HTTP proxy configuration.
type ManagedClusterHTTPProxyConfig struct {
	// The HTTP proxy server endpoint to use.
	HTTPProxy *string `json:"httpProxy,omitempty"`

	// The HTTPS proxy server endpoint to use.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`

	// The endpoints that should not go through proxy.
	NoProxy []*string `json:"noProxy,omitempty"`

	// Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string `json:"trustedCa,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterHTTPProxyConfig.
func (m ManagedClusterHTTPProxyConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "httpProxy", m.HTTPProxy)
	populate(objectMap, "httpsProxy", m.HTTPSProxy)
	populate(objectMap, "noProxy", m.NoProxy)
	populate(objectMap, "trustedCa", m.TrustedCa)
	return json.Marshal(objectMap)
}

// ManagedClusterIdentity - Identity for the managed cluster.
type ManagedClusterIdentity struct {
	// For more information see use managed identities in AKS [https://docs.microsoft.com/azure/aks/use-managed-identity].
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedServiceIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the system assigned identity which is used by master components.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the system assigned identity which is used by master components.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterIdentity.
func (m ManagedClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// ManagedClusterListResult - The response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	// The list of managed clusters.
	Value []*ManagedCluster `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterListResult.
func (m ManagedClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// ManagedClusterLoadBalancerProfile - Profile of the managed cluster load balancer.
type ManagedClusterLoadBalancerProfile struct {
	// The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in
	// Azure dynamically allocating ports.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`

	// The effective outbound IP resources of the cluster load balancer.
	EffectiveOutboundIPs []*ResourceReference `json:"effectiveOutboundIPs,omitempty"`

	// Enable multiple standard load balancers per AKS cluster or not.
	EnableMultipleStandardLoadBalancers *bool `json:"enableMultipleStandardLoadBalancers,omitempty"`

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Desired managed outbound IPs for the cluster load balancer.
	ManagedOutboundIPs *ManagedClusterLoadBalancerProfileManagedOutboundIPs `json:"managedOutboundIPs,omitempty"`

	// Desired outbound IP Prefix resources for the cluster load balancer.
	OutboundIPPrefixes *ManagedClusterLoadBalancerProfileOutboundIPPrefixes `json:"outboundIPPrefixes,omitempty"`

	// Desired outbound IP resources for the cluster load balancer.
	OutboundIPs *ManagedClusterLoadBalancerProfileOutboundIPs `json:"outboundIPs,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfile.
func (m ManagedClusterLoadBalancerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allocatedOutboundPorts", m.AllocatedOutboundPorts)
	populate(objectMap, "effectiveOutboundIPs", m.EffectiveOutboundIPs)
	populate(objectMap, "enableMultipleStandardLoadBalancers", m.EnableMultipleStandardLoadBalancers)
	populate(objectMap, "idleTimeoutInMinutes", m.IdleTimeoutInMinutes)
	populate(objectMap, "managedOutboundIPs", m.ManagedOutboundIPs)
	populate(objectMap, "outboundIPPrefixes", m.OutboundIPPrefixes)
	populate(objectMap, "outboundIPs", m.OutboundIPs)
	return json.Marshal(objectMap)
}

// ManagedClusterLoadBalancerProfileManagedOutboundIPs - Desired managed outbound IPs for the cluster load balancer.
type ManagedClusterLoadBalancerProfileManagedOutboundIPs struct {
	// The desired number of outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive).
	// The default value is 1.
	Count *int32 `json:"count,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPPrefixes - Desired outbound IP Prefix resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPPrefixes struct {
	// A list of public IP prefix resources.
	PublicIPPrefixes []*ResourceReference `json:"publicIPPrefixes,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPPrefixes.
func (m ManagedClusterLoadBalancerProfileOutboundIPPrefixes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicIPPrefixes", m.PublicIPPrefixes)
	return json.Marshal(objectMap)
}

// ManagedClusterLoadBalancerProfileOutboundIPs - Desired outbound IP resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPs struct {
	// A list of public IP resources.
	PublicIPs []*ResourceReference `json:"publicIPs,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPs.
func (m ManagedClusterLoadBalancerProfileOutboundIPs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "publicIPs", m.PublicIPs)
	return json.Marshal(objectMap)
}

// ManagedClusterManagedOutboundIPProfile - Profile of the managed outbound IP resources of the managed cluster.
type ManagedClusterManagedOutboundIPProfile struct {
	// The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
}

// ManagedClusterNATGatewayProfile - Profile of the managed cluster NAT gateway.
type ManagedClusterNATGatewayProfile struct {
	// The effective outbound IP resources of the cluster NAT gateway.
	EffectiveOutboundIPs []*ResourceReference `json:"effectiveOutboundIPs,omitempty"`

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Profile of the managed outbound IP resources of the cluster NAT gateway.
	ManagedOutboundIPProfile *ManagedClusterManagedOutboundIPProfile `json:"managedOutboundIPProfile,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterNATGatewayProfile.
func (m ManagedClusterNATGatewayProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "effectiveOutboundIPs", m.EffectiveOutboundIPs)
	populate(objectMap, "idleTimeoutInMinutes", m.IdleTimeoutInMinutes)
	populate(objectMap, "managedOutboundIPProfile", m.ManagedOutboundIPProfile)
	return json.Marshal(objectMap)
}

// ManagedClusterPodIdentity - Details about the pod identity assigned to the Managed Cluster.
type ManagedClusterPodIdentity struct {
	// REQUIRED; The user assigned identity details.
	Identity *UserAssignedIdentity `json:"identity,omitempty"`

	// REQUIRED; The name of the pod identity.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The namespace of the pod identity.
	Namespace *string `json:"namespace,omitempty"`

	// The binding selector to use for the AzureIdentityBinding resource.
	BindingSelector *string `json:"bindingSelector,omitempty"`

	// READ-ONLY
	ProvisioningInfo *ManagedClusterPodIdentityProvisioningInfo `json:"provisioningInfo,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state of the pod identity.
	ProvisioningState *ManagedClusterPodIdentityProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedClusterPodIdentityException - See disable AAD Pod Identity for a specific Pod/Application [https://azure.github.io/aad-pod-identity/docs/configure/application_exception/]
// for more details.
type ManagedClusterPodIdentityException struct {
	// REQUIRED; The name of the pod identity exception.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The namespace of the pod identity exception.
	Namespace *string `json:"namespace,omitempty"`

	// REQUIRED; The pod labels to match.
	PodLabels map[string]*string `json:"podLabels,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityException.
func (m ManagedClusterPodIdentityException) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", m.Name)
	populate(objectMap, "namespace", m.Namespace)
	populate(objectMap, "podLabels", m.PodLabels)
	return json.Marshal(objectMap)
}

// ManagedClusterPodIdentityProfile - See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity] for more details on pod
// identity integration.
type ManagedClusterPodIdentityProfile struct {
	// Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See using Kubenet network
	// plugin with AAD Pod Identity
	// [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities] for
	// more information.
	AllowNetworkPluginKubenet *bool `json:"allowNetworkPluginKubenet,omitempty"`

	// Whether the pod identity addon is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// The pod identities to use in the cluster.
	UserAssignedIdentities []*ManagedClusterPodIdentity `json:"userAssignedIdentities,omitempty"`

	// The pod identity exceptions to allow.
	UserAssignedIdentityExceptions []*ManagedClusterPodIdentityException `json:"userAssignedIdentityExceptions,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProfile.
func (m ManagedClusterPodIdentityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowNetworkPluginKubenet", m.AllowNetworkPluginKubenet)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	populate(objectMap, "userAssignedIdentityExceptions", m.UserAssignedIdentityExceptions)
	return json.Marshal(objectMap)
}

// ManagedClusterPodIdentityProvisioningError - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningError struct {
	// Details about the error.
	Error *ManagedClusterPodIdentityProvisioningErrorBody `json:"error,omitempty"`
}

// ManagedClusterPodIdentityProvisioningErrorBody - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*ManagedClusterPodIdentityProvisioningErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProvisioningErrorBody.
func (m ManagedClusterPodIdentityProvisioningErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", m.Code)
	populate(objectMap, "details", m.Details)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "target", m.Target)
	return json.Marshal(objectMap)
}

type ManagedClusterPodIdentityProvisioningInfo struct {
	// Pod identity assignment error (if any).
	Error *ManagedClusterPodIdentityProvisioningError `json:"error,omitempty"`
}

// ManagedClusterPoolUpgradeProfile - The list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType `json:"osType,omitempty"`

	// The Agent Pool name.
	Name *string `json:"name,omitempty"`

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*ManagedClusterPoolUpgradeProfileUpgradesItem `json:"upgrades,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPoolUpgradeProfile.
func (m ManagedClusterPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "upgrades", m.Upgrades)
	return json.Marshal(objectMap)
}

type ManagedClusterPoolUpgradeProfileUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
}

// ManagedClusterProperties - Properties of the managed cluster.
type ManagedClusterProperties struct {
	// The Azure Active Directory configuration.
	AADProfile *ManagedClusterAADProfile `json:"aadProfile,omitempty"`

	// The access profile for managed cluster API server.
	APIServerAccessProfile *ManagedClusterAPIServerAccessProfile `json:"apiServerAccessProfile,omitempty"`

	// The profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile `json:"addonProfiles,omitempty"`

	// The agent pool properties.
	AgentPoolProfiles []*ManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`

	// Parameters to be applied to the cluster-autoscaler when enabled
	AutoScalerProfile *ManagedClusterPropertiesAutoScalerProfile `json:"autoScalerProfile,omitempty"`

	// The auto upgrade configuration.
	AutoUpgradeProfile *ManagedClusterAutoUpgradeProfile `json:"autoUpgradeProfile,omitempty"`

	// This cannot be updated once the Managed Cluster has been created.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`

	// If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more
	// details see disable local accounts
	// [https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview].
	DisableLocalAccounts *bool `json:"disableLocalAccounts,omitempty"`

	// This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
	DiskEncryptionSetID *string `json:"diskEncryptionSetID,omitempty"`

	// (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
	EnablePodSecurityPolicy *bool `json:"enablePodSecurityPolicy,omitempty"`

	// Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool `json:"enableRBAC,omitempty"`

	// This cannot be updated once the Managed Cluster has been created.
	FqdnSubdomain *string `json:"fqdnSubdomain,omitempty"`

	// Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *ManagedClusterHTTPProxyConfig `json:"httpProxyConfig,omitempty"`

	// Identities associated with the cluster.
	IdentityProfile map[string]*UserAssignedIdentity `json:"identityProfile,omitempty"`

	// When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number.
	// For example, upgrades between 1.14.x ->
	// 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See upgrading an AKS cluster [https://docs.microsoft.com/azure/aks/upgrade-cluster]
	// for more details.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`

	// The profile for Linux VMs in the Managed Cluster.
	LinuxProfile *ContainerServiceLinuxProfile `json:"linuxProfile,omitempty"`

	// The network configuration profile.
	NetworkProfile *ContainerServiceNetworkProfile `json:"networkProfile,omitempty"`

	// The name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`

	// See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity] for more details on AAD pod identity integration.
	PodIdentityProfile *ManagedClusterPodIdentityProfile `json:"podIdentityProfile,omitempty"`

	// Private link resources associated with the cluster.
	PrivateLinkResources []*PrivateLinkResource `json:"privateLinkResources,omitempty"`

	// Default value is 'Enabled' (case insensitive). Could be set to 'Disabled' to enable private cluster
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Security profile for the managed cluster.
	SecurityProfile *ManagedClusterSecurityProfile `json:"securityProfile,omitempty"`

	// Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`

	// The profile for Windows VMs in the Managed Cluster.
	WindowsProfile *ManagedClusterWindowsProfile `json:"windowsProfile,omitempty"`

	// READ-ONLY; The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses, which Kubernetes APIServer doesn't
	// handle by default. This special FQDN supports CORS,
	// allowing the Azure Portal to function properly.
	AzurePortalFQDN *string `json:"azurePortalFQDN,omitempty" azure:"ro"`

	// READ-ONLY; The FQDN of the master pool.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; The max number of agent pools for the managed cluster.
	MaxAgentPools *int32 `json:"maxAgentPools,omitempty" azure:"ro"`

	// READ-ONLY; The Power State of the cluster.
	PowerState *PowerState `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; The FQDN of private cluster.
	PrivateFQDN *string `json:"privateFQDN,omitempty" azure:"ro"`

	// READ-ONLY; The current provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterProperties.
func (m ManagedClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "aadProfile", m.AADProfile)
	populate(objectMap, "apiServerAccessProfile", m.APIServerAccessProfile)
	populate(objectMap, "addonProfiles", m.AddonProfiles)
	populate(objectMap, "agentPoolProfiles", m.AgentPoolProfiles)
	populate(objectMap, "autoScalerProfile", m.AutoScalerProfile)
	populate(objectMap, "autoUpgradeProfile", m.AutoUpgradeProfile)
	populate(objectMap, "azurePortalFQDN", m.AzurePortalFQDN)
	populate(objectMap, "dnsPrefix", m.DNSPrefix)
	populate(objectMap, "disableLocalAccounts", m.DisableLocalAccounts)
	populate(objectMap, "diskEncryptionSetID", m.DiskEncryptionSetID)
	populate(objectMap, "enablePodSecurityPolicy", m.EnablePodSecurityPolicy)
	populate(objectMap, "enableRBAC", m.EnableRBAC)
	populate(objectMap, "fqdn", m.Fqdn)
	populate(objectMap, "fqdnSubdomain", m.FqdnSubdomain)
	populate(objectMap, "httpProxyConfig", m.HTTPProxyConfig)
	populate(objectMap, "identityProfile", m.IdentityProfile)
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	populate(objectMap, "linuxProfile", m.LinuxProfile)
	populate(objectMap, "maxAgentPools", m.MaxAgentPools)
	populate(objectMap, "networkProfile", m.NetworkProfile)
	populate(objectMap, "nodeResourceGroup", m.NodeResourceGroup)
	populate(objectMap, "podIdentityProfile", m.PodIdentityProfile)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "privateFQDN", m.PrivateFQDN)
	populate(objectMap, "privateLinkResources", m.PrivateLinkResources)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", m.PublicNetworkAccess)
	populate(objectMap, "securityProfile", m.SecurityProfile)
	populate(objectMap, "servicePrincipalProfile", m.ServicePrincipalProfile)
	populate(objectMap, "windowsProfile", m.WindowsProfile)
	return json.Marshal(objectMap)
}

// ManagedClusterPropertiesAutoScalerProfile - Parameters to be applied to the cluster-autoscaler when enabled
type ManagedClusterPropertiesAutoScalerProfile struct {
	// Valid values are 'true' and 'false'
	BalanceSimilarNodeGroups *string `json:"balance-similar-node-groups,omitempty"`

	// If not specified, the default is 'random'. See expanders [https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders]
	// for more information.
	Expander *Expander `json:"expander,omitempty"`

	// The default is 10.
	MaxEmptyBulkDelete *string `json:"max-empty-bulk-delete,omitempty"`

	// The default is 600.
	MaxGracefulTerminationSec *string `json:"max-graceful-termination-sec,omitempty"`

	// The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	MaxNodeProvisionTime *string `json:"max-node-provision-time,omitempty"`

	// The default is 45. The maximum is 100 and the minimum is 0.
	MaxTotalUnreadyPercentage *string `json:"max-total-unready-percentage,omitempty"`

	// For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore
	// unscheduled pods before they're a certain
	// age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
	NewPodScaleUpDelay *string `json:"new-pod-scale-up-delay,omitempty"`

	// This must be an integer. The default is 3.
	OkTotalUnreadyCount *string `json:"ok-total-unready-count,omitempty"`

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterAdd *string `json:"scale-down-delay-after-add,omitempty"`

	// The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterDelete *string `json:"scale-down-delay-after-delete,omitempty"`

	// The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterFailure *string `json:"scale-down-delay-after-failure,omitempty"`

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnneededTime *string `json:"scale-down-unneeded-time,omitempty"`

	// The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnreadyTime *string `json:"scale-down-unready-time,omitempty"`

	// The default is '0.5'.
	ScaleDownUtilizationThreshold *string `json:"scale-down-utilization-threshold,omitempty"`

	// The default is '10'. Values must be an integer number of seconds.
	ScanInterval *string `json:"scan-interval,omitempty"`

	// The default is true.
	SkipNodesWithLocalStorage *string `json:"skip-nodes-with-local-storage,omitempty"`

	// The default is true.
	SkipNodesWithSystemPods *string `json:"skip-nodes-with-system-pods,omitempty"`
}

// ManagedClusterSKU - The SKU of a Managed Cluster.
type ManagedClusterSKU struct {
	// The name of a managed cluster SKU.
	Name *ManagedClusterSKUName `json:"name,omitempty"`

	// If not specified, the default is 'Free'. See uptime SLA [https://docs.microsoft.com/azure/aks/uptime-sla] for more details.
	Tier *ManagedClusterSKUTier `json:"tier,omitempty"`
}

// ManagedClusterSecurityProfile - Security profile for the container service cluster.
type ManagedClusterSecurityProfile struct {
	// Azure Defender settings for the security profile.
	AzureDefender *ManagedClusterSecurityProfileAzureDefender `json:"azureDefender,omitempty"`
}

// ManagedClusterSecurityProfileAzureDefender - Azure Defender settings for the security profile.
type ManagedClusterSecurityProfileAzureDefender struct {
	// Whether to enable Azure Defender
	Enabled *bool `json:"enabled,omitempty"`

	// Resource ID of the Log Analytics workspace to be associated with Azure Defender. When Azure Defender is enabled, this field is required and must be a
	// valid workspace resource ID. When Azure Defender
	// is disabled, leave the field empty.
	LogAnalyticsWorkspaceResourceID *string `json:"logAnalyticsWorkspaceResourceId,omitempty"`
}

// ManagedClusterServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// REQUIRED; The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`

	// The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// ManagedClusterUpgradeProfile - The list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	// REQUIRED; The properties of the upgrade profile.
	Properties *ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the upgrade profile.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the upgrade profile.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the upgrade profile.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedClusterUpgradeProfileProperties - Control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// REQUIRED; The list of available upgrade versions for agent pools.
	AgentPoolProfiles []*ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`

	// REQUIRED; The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterUpgradeProfileProperties.
func (m ManagedClusterUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentPoolProfiles", m.AgentPoolProfiles)
	populate(objectMap, "controlPlaneProfile", m.ControlPlaneProfile)
	return json.Marshal(objectMap)
}

// ManagedClusterWindowsProfile - Profile for Windows VMs in the managed cluster.
type ManagedClusterWindowsProfile struct {
	// REQUIRED; Specifies the name of the administrator account.
	// Restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
	// "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length: 1 character
	// Max-length: 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`

	// Specifies the password of the administrator account.
	// Minimum-length: 8 characters
	// Max-length: 123 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
	AdminPassword *string `json:"adminPassword,omitempty"`

	// For more details on CSI proxy, see the CSI proxy GitHub repo [https://github.com/kubernetes-csi/csi-proxy].
	EnableCSIProxy *bool `json:"enableCSIProxy,omitempty"`

	// The license type to use for Windows VMs. See Azure Hybrid User Benefits [https://azure.microsoft.com/pricing/hybrid-benefit/faq/] for more details.
	LicenseType *LicenseType `json:"licenseType,omitempty"`
}

// ManagedClustersBeginCreateOrUpdateOptions contains the optional parameters for the ManagedClusters.BeginCreateOrUpdate method.
type ManagedClustersBeginCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginDeleteOptions contains the optional parameters for the ManagedClusters.BeginDelete method.
type ManagedClustersBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginResetAADProfileOptions contains the optional parameters for the ManagedClusters.BeginResetAADProfile method.
type ManagedClustersBeginResetAADProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginResetServicePrincipalProfileOptions contains the optional parameters for the ManagedClusters.BeginResetServicePrincipalProfile method.
type ManagedClustersBeginResetServicePrincipalProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginRotateClusterCertificatesOptions contains the optional parameters for the ManagedClusters.BeginRotateClusterCertificates method.
type ManagedClustersBeginRotateClusterCertificatesOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginRunCommandOptions contains the optional parameters for the ManagedClusters.BeginRunCommand method.
type ManagedClustersBeginRunCommandOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginStartOptions contains the optional parameters for the ManagedClusters.BeginStart method.
type ManagedClustersBeginStartOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginStopOptions contains the optional parameters for the ManagedClusters.BeginStop method.
type ManagedClustersBeginStopOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersBeginUpdateTagsOptions contains the optional parameters for the ManagedClusters.BeginUpdateTags method.
type ManagedClustersBeginUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersGetAccessProfileOptions contains the optional parameters for the ManagedClusters.GetAccessProfile method.
type ManagedClustersGetAccessProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersGetCommandResultOptions contains the optional parameters for the ManagedClusters.GetCommandResult method.
type ManagedClustersGetCommandResultOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersGetOSOptionsOptions contains the optional parameters for the ManagedClusters.GetOSOptions method.
type ManagedClustersGetOSOptionsOptions struct {
	// The resource type for which the OS options needs to be returned
	ResourceType *string
}

// ManagedClustersGetOptions contains the optional parameters for the ManagedClusters.Get method.
type ManagedClustersGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersGetUpgradeProfileOptions contains the optional parameters for the ManagedClusters.GetUpgradeProfile method.
type ManagedClustersGetUpgradeProfileOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersListByResourceGroupOptions contains the optional parameters for the ManagedClusters.ListByResourceGroup method.
type ManagedClustersListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersListClusterAdminCredentialsOptions contains the optional parameters for the ManagedClusters.ListClusterAdminCredentials method.
type ManagedClustersListClusterAdminCredentialsOptions struct {
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersListClusterMonitoringUserCredentialsOptions contains the optional parameters for the ManagedClusters.ListClusterMonitoringUserCredentials
// method.
type ManagedClustersListClusterMonitoringUserCredentialsOptions struct {
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersListClusterUserCredentialsOptions contains the optional parameters for the ManagedClusters.ListClusterUserCredentials method.
type ManagedClustersListClusterUserCredentialsOptions struct {
	// server fqdn type for credentials to be returned
	ServerFqdn *string
}

// ManagedClustersListOptions contains the optional parameters for the ManagedClusters.List method.
type ManagedClustersListOptions struct {
	// placeholder for future optional parameters
}

// ManagedClustersListOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the ManagedClusters.ListOutboundNetworkDependenciesEndpoints
// method.
type ManagedClustersListOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

type ManagedServiceIdentityUserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// OSOptionProfile - The OS option profile.
type OSOptionProfile struct {
	// REQUIRED; The list of OS options.
	Properties *OSOptionPropertyList `json:"properties,omitempty"`

	// READ-ONLY; The ID of the OS option resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the OS option resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the OS option resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OSOptionProperty - OS option property.
type OSOptionProperty struct {
	// REQUIRED; Whether the image is FIPS-enabled.
	EnableFipsImage *bool `json:"enable-fips-image,omitempty"`

	// REQUIRED; The OS type.
	OSType *string `json:"os-type,omitempty"`
}

// OSOptionPropertyList - The list of OS option properties.
type OSOptionPropertyList struct {
	// REQUIRED; The list of OS options.
	OSOptionPropertyList []*OSOptionProperty `json:"osOptionPropertyList,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type OSOptionPropertyList.
func (o OSOptionPropertyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "osOptionPropertyList", o.OSOptionPropertyList)
	return json.Marshal(objectMap)
}

// OperationListResult - The List Operation response.
type OperationListResult struct {
	// READ-ONLY; The list of operations
	Value []*OperationValue `json:"value,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// OperationValue - Describes the properties of a Operation value.
type OperationValue struct {
	// Describes the properties of a Operation Value Display.
	Display *OperationValueDisplay `json:"display,omitempty"`

	// READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationValueDisplay - Describes the properties of a Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationsListOptions contains the optional parameters for the Operations.List method.
type OperationsListOptions struct {
	// placeholder for future optional parameters
}

// OutboundEnvironmentEndpoint - Egress endpoints which AKS agent nodes connect to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// The category of endpoints accessed by the AKS agent node, e.g. azure-resource-management, apiserver, etc.
	Category *string `json:"category,omitempty"`

	// The endpoints that AKS agent nodes connect to
	Endpoints []*EndpointDependency `json:"endpoints,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpoint.
func (o OutboundEnvironmentEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "category", o.Category)
	populate(objectMap, "endpoints", o.Endpoints)
	return json.Marshal(objectMap)
}

// OutboundEnvironmentEndpointCollection - Collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpointCollection.
func (o OutboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// PowerState - Describes the Power State of the cluster
type PowerState struct {
	// Tells whether the cluster is Running or Stopped
	Code *Code `json:"code,omitempty"`
}

// PrivateEndpoint - Private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// The resource ID of the private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// The properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the private endpoint connection.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the private endpoint connection.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// The collection value.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The current provisioning state.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnections.BeginDelete method.
type PrivateEndpointConnectionsBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsGetOptions contains the optional parameters for the PrivateEndpointConnections.Get method.
type PrivateEndpointConnectionsGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsListOptions contains the optional parameters for the PrivateEndpointConnections.List method.
type PrivateEndpointConnectionsListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsUpdateOptions contains the optional parameters for the PrivateEndpointConnections.Update method.
type PrivateEndpointConnectionsUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// The group ID of the resource.
	GroupID *string `json:"groupId,omitempty"`

	// The ID of the private link resource.
	ID *string `json:"id,omitempty"`

	// The name of the private link resource.
	Name *string `json:"name,omitempty"`

	// The RequiredMembers of the resource
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The private link service ID of the resource, this field is exposed only to NRP internally.
	PrivateLinkServiceID *string `json:"privateLinkServiceID,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "privateLinkServiceID", p.PrivateLinkServiceID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// PrivateLinkResourcesListOptions contains the optional parameters for the PrivateLinkResources.List method.
type PrivateLinkResourcesListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - A list of private link resources
type PrivateLinkResourcesListResult struct {
	// The collection value.
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourcesListResult.
func (p PrivateLinkResourcesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState - The state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// The private link service connection description.
	Description *string `json:"description,omitempty"`

	// The private link service connection status.
	Status *ConnectionStatus `json:"status,omitempty"`
}

// ResolvePrivateLinkServiceIDPOSTOptions contains the optional parameters for the ResolvePrivateLinkServiceID.POST method.
type ResolvePrivateLinkServiceIDPOSTOptions struct {
	// placeholder for future optional parameters
}

// Resource - The Resource model definition.
type Resource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	r.marshalInternal(objectMap)
	return json.Marshal(objectMap)
}

func (r Resource) marshalInternal(objectMap map[string]interface{}) {
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
}

// ResourceReference - A reference to an Azure resource.
type ResourceReference struct {
	// The fully qualified Azure resource id.
	ID *string `json:"id,omitempty"`
}

// RunCommandRequest - A run command request
type RunCommandRequest struct {
	// REQUIRED; The command to run.
	Command *string `json:"command,omitempty"`

	// AuthToken issued for AKS AAD Server App.
	ClusterToken *string `json:"clusterToken,omitempty"`

	// A base64 encoded zip file containing the files required by the command.
	Context *string `json:"context,omitempty"`
}

// RunCommandResult - run command result.
type RunCommandResult struct {
	// Properties of command result.
	Properties *CommandResultProperties `json:"properties,omitempty"`

	// READ-ONLY; The command id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// Snapshot - A node pool snapshot resource.
type Snapshot struct {
	Resource
	// Properties of a snapshot.
	Properties *SnapshotProperties `json:"properties,omitempty"`

	// READ-ONLY; The system metadata relating to this snapshot.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	s.Resource.marshalInternal(objectMap)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	return json.Marshal(objectMap)
}

// SnapshotListResult - The response from the List Snapshots operation.
type SnapshotListResult struct {
	// The list of snapshots.
	Value []*Snapshot `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of snapshot results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotListResult.
func (s SnapshotListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// SnapshotProperties - Properties used to configure a node pool snapshot.
type SnapshotProperties struct {
	// CreationData to be used to specify the source agent pool resource ID to create this snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`

	// The type of a snapshot. The default is NodePool.
	SnapshotType *SnapshotType `json:"snapshotType,omitempty"`
}

// SnapshotsCreateOrUpdateOptions contains the optional parameters for the Snapshots.CreateOrUpdate method.
type SnapshotsCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsDeleteOptions contains the optional parameters for the Snapshots.Delete method.
type SnapshotsDeleteOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsGetOptions contains the optional parameters for the Snapshots.Get method.
type SnapshotsGetOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsListByResourceGroupOptions contains the optional parameters for the Snapshots.ListByResourceGroup method.
type SnapshotsListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsListOptions contains the optional parameters for the Snapshots.List method.
type SnapshotsListOptions struct {
	// placeholder for future optional parameters
}

// SnapshotsUpdateTagsOptions contains the optional parameters for the Snapshots.UpdateTags method.
type SnapshotsUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SysctlConfig - Sysctl settings for Linux agent nodes.
type SysctlConfig struct {
	// Sysctl setting fs.aio-max-nr.
	FsAioMaxNr *int32 `json:"fsAioMaxNr,omitempty"`

	// Sysctl setting fs.file-max.
	FsFileMax *int32 `json:"fsFileMax,omitempty"`

	// Sysctl setting fs.inotify.maxuserwatches.
	FsInotifyMaxUserWatches *int32 `json:"fsInotifyMaxUserWatches,omitempty"`

	// Sysctl setting fs.nr_open.
	FsNrOpen *int32 `json:"fsNrOpen,omitempty"`

	// Sysctl setting kernel.threads-max.
	KernelThreadsMax *int32 `json:"kernelThreadsMax,omitempty"`

	// Sysctl setting net.core.netdevmaxbacklog.
	NetCoreNetdevMaxBacklog *int32 `json:"netCoreNetdevMaxBacklog,omitempty"`

	// Sysctl setting net.core.optmem_max.
	NetCoreOptmemMax *int32 `json:"netCoreOptmemMax,omitempty"`

	// Sysctl setting net.core.rmem_default.
	NetCoreRmemDefault *int32 `json:"netCoreRmemDefault,omitempty"`

	// Sysctl setting net.core.rmem_max.
	NetCoreRmemMax *int32 `json:"netCoreRmemMax,omitempty"`

	// Sysctl setting net.core.somaxconn.
	NetCoreSomaxconn *int32 `json:"netCoreSomaxconn,omitempty"`

	// Sysctl setting net.core.wmem_default.
	NetCoreWmemDefault *int32 `json:"netCoreWmemDefault,omitempty"`

	// Sysctl setting net.core.wmem_max.
	NetCoreWmemMax *int32 `json:"netCoreWmemMax,omitempty"`

	// Sysctl setting net.ipv4.iplocalport_range.
	NetIPv4IPLocalPortRange *string `json:"netIpv4IpLocalPortRange,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh1.
	NetIPv4NeighDefaultGcThresh1 *int32 `json:"netIpv4NeighDefaultGcThresh1,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh2.
	NetIPv4NeighDefaultGcThresh2 *int32 `json:"netIpv4NeighDefaultGcThresh2,omitempty"`

	// Sysctl setting net.ipv4.neigh.default.gc_thresh3.
	NetIPv4NeighDefaultGcThresh3 *int32 `json:"netIpv4NeighDefaultGcThresh3,omitempty"`

	// Sysctl setting net.ipv4.tcpfintimeout.
	NetIPv4TCPFinTimeout *int32 `json:"netIpv4TcpFinTimeout,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveprobes.
	NetIPv4TCPKeepaliveProbes *int32 `json:"netIpv4TcpKeepaliveProbes,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepalivetime.
	NetIPv4TCPKeepaliveTime *int32 `json:"netIpv4TcpKeepaliveTime,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxsyn_backlog.
	NetIPv4TCPMaxSynBacklog *int32 `json:"netIpv4TcpMaxSynBacklog,omitempty"`

	// Sysctl setting net.ipv4.tcpmaxtw_buckets.
	NetIPv4TCPMaxTwBuckets *int32 `json:"netIpv4TcpMaxTwBuckets,omitempty"`

	// Sysctl setting net.ipv4.tcptwreuse.
	NetIPv4TCPTwReuse *bool `json:"netIpv4TcpTwReuse,omitempty"`

	// Sysctl setting net.ipv4.tcpkeepaliveintvl.
	NetIPv4TcpkeepaliveIntvl *int32 `json:"netIpv4TcpkeepaliveIntvl,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackbuckets.
	NetNetfilterNfConntrackBuckets *int32 `json:"netNetfilterNfConntrackBuckets,omitempty"`

	// Sysctl setting net.netfilter.nfconntrackmax.
	NetNetfilterNfConntrackMax *int32 `json:"netNetfilterNfConntrackMax,omitempty"`

	// Sysctl setting vm.maxmapcount.
	VMMaxMapCount *int32 `json:"vmMaxMapCount,omitempty"`

	// Sysctl setting vm.swappiness.
	VMSwappiness *int32 `json:"vmSwappiness,omitempty"`

	// Sysctl setting vm.vfscachepressure.
	VMVfsCachePressure *int32 `json:"vmVfsCachePressure,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The UTC timestamp of resource creation.
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "createdAt", (*timeRFC3339)(s.CreatedAt))
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populate(objectMap, "lastModifiedAt", (*timeRFC3339)(s.LastModifiedAt))
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			var aux timeRFC3339
			err = unpopulate(val, &aux)
			s.CreatedAt = (*time.Time)(&aux)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			var aux timeRFC3339
			err = unpopulate(val, &aux)
			s.LastModifiedAt = (*time.Time)(&aux)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// TimeInWeek - Time in a week.
type TimeInWeek struct {
	// The day of the week.
	Day *WeekDay `json:"day,omitempty"`

	// Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds
	// to 23:00 UTC. Specifying [0, 1] means the
	// 00:00 - 02:00 UTC time range.
	HourSlots []*int32 `json:"hourSlots,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TimeInWeek.
func (t TimeInWeek) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "day", t.Day)
	populate(objectMap, "hourSlots", t.HourSlots)
	return json.Marshal(objectMap)
}

// TimeSpan - For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
type TimeSpan struct {
	// The end of a time span
	End *time.Time `json:"end,omitempty"`

	// The start of a time span
	Start *time.Time `json:"start,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TimeSpan.
func (t TimeSpan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "end", (*timeRFC3339)(t.End))
	populate(objectMap, "start", (*timeRFC3339)(t.Start))
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeSpan.
func (t *TimeSpan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			var aux timeRFC3339
			err = unpopulate(val, &aux)
			t.End = (*time.Time)(&aux)
			delete(rawMsg, key)
		case "start":
			var aux timeRFC3339
			err = unpopulate(val, &aux)
			t.Start = (*time.Time)(&aux)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// UserAssignedIdentity - Details about a user assigned identity.
type UserAssignedIdentity struct {
	// The client ID of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`

	// The object ID of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`

	// The resource ID of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]interface{}, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, v interface{}) error {
	if data == nil {
		return nil
	}
	return json.Unmarshal(data, v)
}
