//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import (
	"context"
	"errors"
	"fmt"
	"net/http"
	"net/url"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// ManagedClustersClient contains the methods for the ManagedClusters group.
// Don't use this type directly, use NewManagedClustersClient() instead.
type ManagedClustersClient struct {
	ep             string
	pl             runtime.Pipeline
	subscriptionID string
}

// NewManagedClustersClient creates a new instance of ManagedClustersClient with the specified values.
func NewManagedClustersClient(con *arm.Connection, subscriptionID string) *ManagedClustersClient {
	return &ManagedClustersClient{ep: con.Endpoint(), pl: con.NewPipeline(module, version), subscriptionID: subscriptionID}
}

// BeginCreateOrUpdate - Creates or updates a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedCluster, options *ManagedClustersBeginCreateOrUpdateOptions) (ManagedClustersCreateOrUpdatePollerResponse, error) {
	resp, err := client.createOrUpdate(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return ManagedClustersCreateOrUpdatePollerResponse{}, err
	}
	result := ManagedClustersCreateOrUpdatePollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.CreateOrUpdate", "", resp, client.pl, client.createOrUpdateHandleError)
	if err != nil {
		return ManagedClustersCreateOrUpdatePollerResponse{}, err
	}
	result.Poller = &ManagedClustersCreateOrUpdatePoller{
		pt: pt,
	}
	return result, nil
}

// CreateOrUpdate - Creates or updates a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) createOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedCluster, options *ManagedClustersBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, client.createOrUpdateHandleError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ManagedClustersClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedCluster, options *ManagedClustersBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleError handles the CreateOrUpdate error response.
func (client *ManagedClustersClient) createOrUpdateHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginDelete - Deletes a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginDelete(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginDeleteOptions) (ManagedClustersDeletePollerResponse, error) {
	resp, err := client.deleteOperation(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersDeletePollerResponse{}, err
	}
	result := ManagedClustersDeletePollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.Delete", "", resp, client.pl, client.deleteHandleError)
	if err != nil {
		return ManagedClustersDeletePollerResponse{}, err
	}
	result.Poller = &ManagedClustersDeletePoller{
		pt: pt,
	}
	return result, nil
}

// Delete - Deletes a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) deleteOperation(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, client.deleteHandleError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ManagedClustersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// deleteHandleError handles the Delete error response.
func (client *ManagedClustersClient) deleteHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// Get - Gets a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) Get(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersGetOptions) (ManagedClustersGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedClustersGetResponse{}, client.getHandleError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ManagedClustersClient) getCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ManagedClustersClient) getHandleResponse(resp *http.Response) (ManagedClustersGetResponse, error) {
	result := ManagedClustersGetResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedCluster); err != nil {
		return ManagedClustersGetResponse{}, err
	}
	return result, nil
}

// getHandleError handles the Get error response.
func (client *ManagedClustersClient) getHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// GetAccessProfile - WARNING: This API will be deprecated. Instead use ListClusterUserCredentials [https://docs.microsoft.com/rest/api/aks/managedclusters/listclusterusercredentials]
// or ListClusterAdminCredentials
// [https://docs.microsoft.com/rest/api/aks/managedclusters/listclusteradmincredentials] .
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) GetAccessProfile(ctx context.Context, resourceGroupName string, resourceName string, roleName string, options *ManagedClustersGetAccessProfileOptions) (ManagedClustersGetAccessProfileResponse, error) {
	req, err := client.getAccessProfileCreateRequest(ctx, resourceGroupName, resourceName, roleName, options)
	if err != nil {
		return ManagedClustersGetAccessProfileResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersGetAccessProfileResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedClustersGetAccessProfileResponse{}, client.getAccessProfileHandleError(resp)
	}
	return client.getAccessProfileHandleResponse(resp)
}

// getAccessProfileCreateRequest creates the GetAccessProfile request.
func (client *ManagedClustersClient) getAccessProfileCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, roleName string, options *ManagedClustersGetAccessProfileOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/accessProfiles/{roleName}/listCredential"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if roleName == "" {
		return nil, errors.New("parameter roleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleName}", url.PathEscape(roleName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getAccessProfileHandleResponse handles the GetAccessProfile response.
func (client *ManagedClustersClient) getAccessProfileHandleResponse(resp *http.Response) (ManagedClustersGetAccessProfileResponse, error) {
	result := ManagedClustersGetAccessProfileResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedClusterAccessProfile); err != nil {
		return ManagedClustersGetAccessProfileResponse{}, err
	}
	return result, nil
}

// getAccessProfileHandleError handles the GetAccessProfile error response.
func (client *ManagedClustersClient) getAccessProfileHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// GetCommandResult - Gets the results of a command which has been run on the Managed Cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) GetCommandResult(ctx context.Context, resourceGroupName string, resourceName string, commandID string, options *ManagedClustersGetCommandResultOptions) (ManagedClustersGetCommandResultResponse, error) {
	req, err := client.getCommandResultCreateRequest(ctx, resourceGroupName, resourceName, commandID, options)
	if err != nil {
		return ManagedClustersGetCommandResultResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersGetCommandResultResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return ManagedClustersGetCommandResultResponse{}, client.getCommandResultHandleError(resp)
	}
	return client.getCommandResultHandleResponse(resp)
}

// getCommandResultCreateRequest creates the GetCommandResult request.
func (client *ManagedClustersClient) getCommandResultCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, commandID string, options *ManagedClustersGetCommandResultOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/commandResults/{commandId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if commandID == "" {
		return nil, errors.New("parameter commandID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{commandId}", url.PathEscape(commandID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getCommandResultHandleResponse handles the GetCommandResult response.
func (client *ManagedClustersClient) getCommandResultHandleResponse(resp *http.Response) (ManagedClustersGetCommandResultResponse, error) {
	result := ManagedClustersGetCommandResultResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.RunCommandResult); err != nil {
		return ManagedClustersGetCommandResultResponse{}, err
	}
	return result, nil
}

// getCommandResultHandleError handles the GetCommandResult error response.
func (client *ManagedClustersClient) getCommandResultHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// GetOSOptions - Gets supported OS options in the specified subscription.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) GetOSOptions(ctx context.Context, location string, options *ManagedClustersGetOSOptionsOptions) (ManagedClustersGetOSOptionsResponse, error) {
	req, err := client.getOSOptionsCreateRequest(ctx, location, options)
	if err != nil {
		return ManagedClustersGetOSOptionsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersGetOSOptionsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedClustersGetOSOptionsResponse{}, client.getOSOptionsHandleError(resp)
	}
	return client.getOSOptionsHandleResponse(resp)
}

// getOSOptionsCreateRequest creates the GetOSOptions request.
func (client *ManagedClustersClient) getOSOptionsCreateRequest(ctx context.Context, location string, options *ManagedClustersGetOSOptionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/locations/{location}/osOptions/default"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	if options != nil && options.ResourceType != nil {
		reqQP.Set("resource-type", *options.ResourceType)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getOSOptionsHandleResponse handles the GetOSOptions response.
func (client *ManagedClustersClient) getOSOptionsHandleResponse(resp *http.Response) (ManagedClustersGetOSOptionsResponse, error) {
	result := ManagedClustersGetOSOptionsResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.OSOptionProfile); err != nil {
		return ManagedClustersGetOSOptionsResponse{}, err
	}
	return result, nil
}

// getOSOptionsHandleError handles the GetOSOptions error response.
func (client *ManagedClustersClient) getOSOptionsHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// GetUpgradeProfile - Gets the upgrade profile of a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) GetUpgradeProfile(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersGetUpgradeProfileOptions) (ManagedClustersGetUpgradeProfileResponse, error) {
	req, err := client.getUpgradeProfileCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersGetUpgradeProfileResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersGetUpgradeProfileResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedClustersGetUpgradeProfileResponse{}, client.getUpgradeProfileHandleError(resp)
	}
	return client.getUpgradeProfileHandleResponse(resp)
}

// getUpgradeProfileCreateRequest creates the GetUpgradeProfile request.
func (client *ManagedClustersClient) getUpgradeProfileCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersGetUpgradeProfileOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/upgradeProfiles/default"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// getUpgradeProfileHandleResponse handles the GetUpgradeProfile response.
func (client *ManagedClustersClient) getUpgradeProfileHandleResponse(resp *http.Response) (ManagedClustersGetUpgradeProfileResponse, error) {
	result := ManagedClustersGetUpgradeProfileResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedClusterUpgradeProfile); err != nil {
		return ManagedClustersGetUpgradeProfileResponse{}, err
	}
	return result, nil
}

// getUpgradeProfileHandleError handles the GetUpgradeProfile error response.
func (client *ManagedClustersClient) getUpgradeProfileHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// List - Gets a list of managed clusters in the specified subscription.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) List(options *ManagedClustersListOptions) *ManagedClustersListPager {
	return &ManagedClustersListPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.listCreateRequest(ctx, options)
		},
		advancer: func(ctx context.Context, resp ManagedClustersListResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.ManagedClusterListResult.NextLink)
		},
	}
}

// listCreateRequest creates the List request.
func (client *ManagedClustersClient) listCreateRequest(ctx context.Context, options *ManagedClustersListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/managedClusters"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ManagedClustersClient) listHandleResponse(resp *http.Response) (ManagedClustersListResponse, error) {
	result := ManagedClustersListResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedClusterListResult); err != nil {
		return ManagedClustersListResponse{}, err
	}
	return result, nil
}

// listHandleError handles the List error response.
func (client *ManagedClustersClient) listHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// ListByResourceGroup - Lists managed clusters in the specified subscription and resource group.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) ListByResourceGroup(resourceGroupName string, options *ManagedClustersListByResourceGroupOptions) *ManagedClustersListByResourceGroupPager {
	return &ManagedClustersListByResourceGroupPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
		},
		advancer: func(ctx context.Context, resp ManagedClustersListByResourceGroupResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.ManagedClusterListResult.NextLink)
		},
	}
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *ManagedClustersClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ManagedClustersListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *ManagedClustersClient) listByResourceGroupHandleResponse(resp *http.Response) (ManagedClustersListByResourceGroupResponse, error) {
	result := ManagedClustersListByResourceGroupResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagedClusterListResult); err != nil {
		return ManagedClustersListByResourceGroupResponse{}, err
	}
	return result, nil
}

// listByResourceGroupHandleError handles the ListByResourceGroup error response.
func (client *ManagedClustersClient) listByResourceGroupHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// ListClusterAdminCredentials - Lists the admin credentials of a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) ListClusterAdminCredentials(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersListClusterAdminCredentialsOptions) (ManagedClustersListClusterAdminCredentialsResponse, error) {
	req, err := client.listClusterAdminCredentialsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersListClusterAdminCredentialsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersListClusterAdminCredentialsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedClustersListClusterAdminCredentialsResponse{}, client.listClusterAdminCredentialsHandleError(resp)
	}
	return client.listClusterAdminCredentialsHandleResponse(resp)
}

// listClusterAdminCredentialsCreateRequest creates the ListClusterAdminCredentials request.
func (client *ManagedClustersClient) listClusterAdminCredentialsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersListClusterAdminCredentialsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/listClusterAdminCredential"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	if options != nil && options.ServerFqdn != nil {
		reqQP.Set("server-fqdn", *options.ServerFqdn)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listClusterAdminCredentialsHandleResponse handles the ListClusterAdminCredentials response.
func (client *ManagedClustersClient) listClusterAdminCredentialsHandleResponse(resp *http.Response) (ManagedClustersListClusterAdminCredentialsResponse, error) {
	result := ManagedClustersListClusterAdminCredentialsResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.CredentialResults); err != nil {
		return ManagedClustersListClusterAdminCredentialsResponse{}, err
	}
	return result, nil
}

// listClusterAdminCredentialsHandleError handles the ListClusterAdminCredentials error response.
func (client *ManagedClustersClient) listClusterAdminCredentialsHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// ListClusterMonitoringUserCredentials - Lists the cluster monitoring user credentials of a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) ListClusterMonitoringUserCredentials(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersListClusterMonitoringUserCredentialsOptions) (ManagedClustersListClusterMonitoringUserCredentialsResponse, error) {
	req, err := client.listClusterMonitoringUserCredentialsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersListClusterMonitoringUserCredentialsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersListClusterMonitoringUserCredentialsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedClustersListClusterMonitoringUserCredentialsResponse{}, client.listClusterMonitoringUserCredentialsHandleError(resp)
	}
	return client.listClusterMonitoringUserCredentialsHandleResponse(resp)
}

// listClusterMonitoringUserCredentialsCreateRequest creates the ListClusterMonitoringUserCredentials request.
func (client *ManagedClustersClient) listClusterMonitoringUserCredentialsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersListClusterMonitoringUserCredentialsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/listClusterMonitoringUserCredential"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	if options != nil && options.ServerFqdn != nil {
		reqQP.Set("server-fqdn", *options.ServerFqdn)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listClusterMonitoringUserCredentialsHandleResponse handles the ListClusterMonitoringUserCredentials response.
func (client *ManagedClustersClient) listClusterMonitoringUserCredentialsHandleResponse(resp *http.Response) (ManagedClustersListClusterMonitoringUserCredentialsResponse, error) {
	result := ManagedClustersListClusterMonitoringUserCredentialsResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.CredentialResults); err != nil {
		return ManagedClustersListClusterMonitoringUserCredentialsResponse{}, err
	}
	return result, nil
}

// listClusterMonitoringUserCredentialsHandleError handles the ListClusterMonitoringUserCredentials error response.
func (client *ManagedClustersClient) listClusterMonitoringUserCredentialsHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// ListClusterUserCredentials - Lists the user credentials of a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) ListClusterUserCredentials(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersListClusterUserCredentialsOptions) (ManagedClustersListClusterUserCredentialsResponse, error) {
	req, err := client.listClusterUserCredentialsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersListClusterUserCredentialsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedClustersListClusterUserCredentialsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedClustersListClusterUserCredentialsResponse{}, client.listClusterUserCredentialsHandleError(resp)
	}
	return client.listClusterUserCredentialsHandleResponse(resp)
}

// listClusterUserCredentialsCreateRequest creates the ListClusterUserCredentials request.
func (client *ManagedClustersClient) listClusterUserCredentialsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersListClusterUserCredentialsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/listClusterUserCredential"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	if options != nil && options.ServerFqdn != nil {
		reqQP.Set("server-fqdn", *options.ServerFqdn)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listClusterUserCredentialsHandleResponse handles the ListClusterUserCredentials response.
func (client *ManagedClustersClient) listClusterUserCredentialsHandleResponse(resp *http.Response) (ManagedClustersListClusterUserCredentialsResponse, error) {
	result := ManagedClustersListClusterUserCredentialsResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.CredentialResults); err != nil {
		return ManagedClustersListClusterUserCredentialsResponse{}, err
	}
	return result, nil
}

// listClusterUserCredentialsHandleError handles the ListClusterUserCredentials error response.
func (client *ManagedClustersClient) listClusterUserCredentialsHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// ListOutboundNetworkDependenciesEndpoints - Gets a list of egress endpoints (network endpoints of all outbound dependencies) in the specified managed
// cluster. The operation returns properties of each egress endpoint.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) ListOutboundNetworkDependenciesEndpoints(resourceGroupName string, resourceName string, options *ManagedClustersListOutboundNetworkDependenciesEndpointsOptions) *ManagedClustersListOutboundNetworkDependenciesEndpointsPager {
	return &ManagedClustersListOutboundNetworkDependenciesEndpointsPager{
		client: client,
		requester: func(ctx context.Context) (*policy.Request, error) {
			return client.listOutboundNetworkDependenciesEndpointsCreateRequest(ctx, resourceGroupName, resourceName, options)
		},
		advancer: func(ctx context.Context, resp ManagedClustersListOutboundNetworkDependenciesEndpointsResponse) (*policy.Request, error) {
			return runtime.NewRequest(ctx, http.MethodGet, *resp.OutboundEnvironmentEndpointCollection.NextLink)
		},
	}
}

// listOutboundNetworkDependenciesEndpointsCreateRequest creates the ListOutboundNetworkDependenciesEndpoints request.
func (client *ManagedClustersClient) listOutboundNetworkDependenciesEndpointsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersListOutboundNetworkDependenciesEndpointsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/outboundNetworkDependenciesEndpoints"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// listOutboundNetworkDependenciesEndpointsHandleResponse handles the ListOutboundNetworkDependenciesEndpoints response.
func (client *ManagedClustersClient) listOutboundNetworkDependenciesEndpointsHandleResponse(resp *http.Response) (ManagedClustersListOutboundNetworkDependenciesEndpointsResponse, error) {
	result := ManagedClustersListOutboundNetworkDependenciesEndpointsResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.OutboundEnvironmentEndpointCollection); err != nil {
		return ManagedClustersListOutboundNetworkDependenciesEndpointsResponse{}, err
	}
	return result, nil
}

// listOutboundNetworkDependenciesEndpointsHandleError handles the ListOutboundNetworkDependenciesEndpoints error response.
func (client *ManagedClustersClient) listOutboundNetworkDependenciesEndpointsHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginResetAADProfile - Reset the AAD Profile of a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginResetAADProfile(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedClusterAADProfile, options *ManagedClustersBeginResetAADProfileOptions) (ManagedClustersResetAADProfilePollerResponse, error) {
	resp, err := client.resetAADProfile(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return ManagedClustersResetAADProfilePollerResponse{}, err
	}
	result := ManagedClustersResetAADProfilePollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.ResetAADProfile", "", resp, client.pl, client.resetAADProfileHandleError)
	if err != nil {
		return ManagedClustersResetAADProfilePollerResponse{}, err
	}
	result.Poller = &ManagedClustersResetAADProfilePoller{
		pt: pt,
	}
	return result, nil
}

// ResetAADProfile - Reset the AAD Profile of a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) resetAADProfile(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedClusterAADProfile, options *ManagedClustersBeginResetAADProfileOptions) (*http.Response, error) {
	req, err := client.resetAADProfileCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, client.resetAADProfileHandleError(resp)
	}
	return resp, nil
}

// resetAADProfileCreateRequest creates the ResetAADProfile request.
func (client *ManagedClustersClient) resetAADProfileCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedClusterAADProfile, options *ManagedClustersBeginResetAADProfileOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resetAADProfile"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// resetAADProfileHandleError handles the ResetAADProfile error response.
func (client *ManagedClustersClient) resetAADProfileHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginResetServicePrincipalProfile - This action cannot be performed on a cluster that is not using a service principal
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginResetServicePrincipalProfile(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedClusterServicePrincipalProfile, options *ManagedClustersBeginResetServicePrincipalProfileOptions) (ManagedClustersResetServicePrincipalProfilePollerResponse, error) {
	resp, err := client.resetServicePrincipalProfile(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return ManagedClustersResetServicePrincipalProfilePollerResponse{}, err
	}
	result := ManagedClustersResetServicePrincipalProfilePollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.ResetServicePrincipalProfile", "", resp, client.pl, client.resetServicePrincipalProfileHandleError)
	if err != nil {
		return ManagedClustersResetServicePrincipalProfilePollerResponse{}, err
	}
	result.Poller = &ManagedClustersResetServicePrincipalProfilePoller{
		pt: pt,
	}
	return result, nil
}

// ResetServicePrincipalProfile - This action cannot be performed on a cluster that is not using a service principal
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) resetServicePrincipalProfile(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedClusterServicePrincipalProfile, options *ManagedClustersBeginResetServicePrincipalProfileOptions) (*http.Response, error) {
	req, err := client.resetServicePrincipalProfileCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, client.resetServicePrincipalProfileHandleError(resp)
	}
	return resp, nil
}

// resetServicePrincipalProfileCreateRequest creates the ResetServicePrincipalProfile request.
func (client *ManagedClustersClient) resetServicePrincipalProfileCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters ManagedClusterServicePrincipalProfile, options *ManagedClustersBeginResetServicePrincipalProfileOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resetServicePrincipalProfile"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// resetServicePrincipalProfileHandleError handles the ResetServicePrincipalProfile error response.
func (client *ManagedClustersClient) resetServicePrincipalProfileHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginRotateClusterCertificates - See Certificate rotation [https://docs.microsoft.com/azure/aks/certificate-rotation] for more details about rotating
// managed cluster certificates.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginRotateClusterCertificates(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginRotateClusterCertificatesOptions) (ManagedClustersRotateClusterCertificatesPollerResponse, error) {
	resp, err := client.rotateClusterCertificates(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersRotateClusterCertificatesPollerResponse{}, err
	}
	result := ManagedClustersRotateClusterCertificatesPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.RotateClusterCertificates", "", resp, client.pl, client.rotateClusterCertificatesHandleError)
	if err != nil {
		return ManagedClustersRotateClusterCertificatesPollerResponse{}, err
	}
	result.Poller = &ManagedClustersRotateClusterCertificatesPoller{
		pt: pt,
	}
	return result, nil
}

// RotateClusterCertificates - See Certificate rotation [https://docs.microsoft.com/azure/aks/certificate-rotation] for more details about rotating managed
// cluster certificates.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) rotateClusterCertificates(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginRotateClusterCertificatesOptions) (*http.Response, error) {
	req, err := client.rotateClusterCertificatesCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, client.rotateClusterCertificatesHandleError(resp)
	}
	return resp, nil
}

// rotateClusterCertificatesCreateRequest creates the RotateClusterCertificates request.
func (client *ManagedClustersClient) rotateClusterCertificatesCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginRotateClusterCertificatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/rotateClusterCertificates"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// rotateClusterCertificatesHandleError handles the RotateClusterCertificates error response.
func (client *ManagedClustersClient) rotateClusterCertificatesHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginRunCommand - AKS will create a pod to run the command. This is primarily useful for private clusters. For more information see AKS Run Command
// [https://docs.microsoft.com/azure/aks/private-clusters#aks-run-command-preview].
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginRunCommand(ctx context.Context, resourceGroupName string, resourceName string, requestPayload RunCommandRequest, options *ManagedClustersBeginRunCommandOptions) (ManagedClustersRunCommandPollerResponse, error) {
	resp, err := client.runCommand(ctx, resourceGroupName, resourceName, requestPayload, options)
	if err != nil {
		return ManagedClustersRunCommandPollerResponse{}, err
	}
	result := ManagedClustersRunCommandPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.RunCommand", "", resp, client.pl, client.runCommandHandleError)
	if err != nil {
		return ManagedClustersRunCommandPollerResponse{}, err
	}
	result.Poller = &ManagedClustersRunCommandPoller{
		pt: pt,
	}
	return result, nil
}

// RunCommand - AKS will create a pod to run the command. This is primarily useful for private clusters. For more information see AKS Run Command
// [https://docs.microsoft.com/azure/aks/private-clusters#aks-run-command-preview].
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) runCommand(ctx context.Context, resourceGroupName string, resourceName string, requestPayload RunCommandRequest, options *ManagedClustersBeginRunCommandOptions) (*http.Response, error) {
	req, err := client.runCommandCreateRequest(ctx, resourceGroupName, resourceName, requestPayload, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, client.runCommandHandleError(resp)
	}
	return resp, nil
}

// runCommandCreateRequest creates the RunCommand request.
func (client *ManagedClustersClient) runCommandCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, requestPayload RunCommandRequest, options *ManagedClustersBeginRunCommandOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/runCommand"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, requestPayload)
}

// runCommandHandleError handles the RunCommand error response.
func (client *ManagedClustersClient) runCommandHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginStart - See starting a cluster [https://docs.microsoft.com/azure/aks/start-stop-cluster] for more details about starting a cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginStart(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginStartOptions) (ManagedClustersStartPollerResponse, error) {
	resp, err := client.start(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersStartPollerResponse{}, err
	}
	result := ManagedClustersStartPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.Start", "", resp, client.pl, client.startHandleError)
	if err != nil {
		return ManagedClustersStartPollerResponse{}, err
	}
	result.Poller = &ManagedClustersStartPoller{
		pt: pt,
	}
	return result, nil
}

// Start - See starting a cluster [https://docs.microsoft.com/azure/aks/start-stop-cluster] for more details about starting a cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) start(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginStartOptions) (*http.Response, error) {
	req, err := client.startCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, client.startHandleError(resp)
	}
	return resp, nil
}

// startCreateRequest creates the Start request.
func (client *ManagedClustersClient) startCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginStartOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/start"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// startHandleError handles the Start error response.
func (client *ManagedClustersClient) startHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginStop - This can only be performed on Azure Virtual Machine Scale set backed clusters. Stopping a cluster stops the control plane and agent nodes
// entirely, while maintaining all object and cluster state. A
// cluster does not accrue charges while it is stopped. See stopping a cluster [https://docs.microsoft.com/azure/aks/start-stop-cluster] for more details
// about stopping a cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginStop(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginStopOptions) (ManagedClustersStopPollerResponse, error) {
	resp, err := client.stop(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ManagedClustersStopPollerResponse{}, err
	}
	result := ManagedClustersStopPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.Stop", "", resp, client.pl, client.stopHandleError)
	if err != nil {
		return ManagedClustersStopPollerResponse{}, err
	}
	result.Poller = &ManagedClustersStopPoller{
		pt: pt,
	}
	return result, nil
}

// Stop - This can only be performed on Azure Virtual Machine Scale set backed clusters. Stopping a cluster stops the control plane and agent nodes entirely,
// while maintaining all object and cluster state. A
// cluster does not accrue charges while it is stopped. See stopping a cluster [https://docs.microsoft.com/azure/aks/start-stop-cluster] for more details
// about stopping a cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) stop(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginStopOptions) (*http.Response, error) {
	req, err := client.stopCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted, http.StatusNoContent) {
		return nil, client.stopHandleError(resp)
	}
	return resp, nil
}

// stopCreateRequest creates the Stop request.
func (client *ManagedClustersClient) stopCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ManagedClustersBeginStopOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/stop"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, nil
}

// stopHandleError handles the Stop error response.
func (client *ManagedClustersClient) stopHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}

// BeginUpdateTags - Updates tags on a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) BeginUpdateTags(ctx context.Context, resourceGroupName string, resourceName string, parameters TagsObject, options *ManagedClustersBeginUpdateTagsOptions) (ManagedClustersUpdateTagsPollerResponse, error) {
	resp, err := client.updateTags(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return ManagedClustersUpdateTagsPollerResponse{}, err
	}
	result := ManagedClustersUpdateTagsPollerResponse{
		RawResponse: resp,
	}
	pt, err := armruntime.NewPoller("ManagedClustersClient.UpdateTags", "", resp, client.pl, client.updateTagsHandleError)
	if err != nil {
		return ManagedClustersUpdateTagsPollerResponse{}, err
	}
	result.Poller = &ManagedClustersUpdateTagsPoller{
		pt: pt,
	}
	return result, nil
}

// UpdateTags - Updates tags on a managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ManagedClustersClient) updateTags(ctx context.Context, resourceGroupName string, resourceName string, parameters TagsObject, options *ManagedClustersBeginUpdateTagsOptions) (*http.Response, error) {
	req, err := client.updateTagsCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return nil, client.updateTagsHandleError(resp)
	}
	return resp, nil
}

// updateTagsCreateRequest creates the UpdateTags request.
func (client *ManagedClustersClient) updateTagsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters TagsObject, options *ManagedClustersBeginUpdateTagsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateTagsHandleError handles the UpdateTags error response.
func (client *ManagedClustersClient) updateTagsHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}
