// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/gateway.proto

// `Gateway` describes a load balancer operating at the edge of the mesh
// receiving incoming or outgoing HTTP/TCP connections. The specification
// describes a set of ports that should be exposed, the type of protocol to
// use, SNI configuration for the load balancer, etc.
//
// For example, the following Gateway configuration sets up a proxy to act
// as a load balancer exposing port 80 and 9080 (http), 443 (https),
// 9443(https) and port 2379 (TCP) for ingress.  The gateway will be
// applied to the proxy running on a pod with labels `app:
// my-gateway-controller`. While Istio will configure the proxy to listen
// on these ports, it is the responsibility of the user to ensure that
// external traffic to these ports are allowed into the mesh.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       httpsRedirect: true # sends 301 redirect for http requests
//   - port:
//       number: 443
//       name: https-443
//       protocol: HTTPS
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       serverCertificate: /etc/certs/servercert.pem
//       privateKey: /etc/certs/privatekey.pem
//   - port:
//       number: 9443
//       name: https-9443
//       protocol: HTTPS
//     hosts:
//     - "bookinfo-namespace/*.bookinfo.com"
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       credentialName: bookinfo-secret # fetches certs from Kubernetes secret
//   - port:
//       number: 9080
//       name: http-wildcard
//       protocol: HTTP
//     hosts:
//     - "*"
//   - port:
//       number: 2379 # to expose internal service via external port 2379
//       name: mongo
//       protocol: MONGO
//     hosts:
//     - "*"
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       httpsRedirect: true # sends 301 redirect for http requests
//   - port:
//       number: 443
//       name: https-443
//       protocol: HTTPS
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       serverCertificate: /etc/certs/servercert.pem
//       privateKey: /etc/certs/privatekey.pem
//   - port:
//       number: 9443
//       name: https-9443
//       protocol: HTTPS
//     hosts:
//     - "bookinfo-namespace/*.bookinfo.com"
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       credentialName: bookinfo-secret # fetches certs from Kubernetes secret
//   - port:
//       number: 9080
//       name: http-wildcard
//       protocol: HTTP
//     hosts:
//     - "*"
//   - port:
//       number: 2379 # to expose internal service via external port 2379
//       name: mongo
//       protocol: MONGO
//     hosts:
//     - "*"
// ```
// {{</tab>}}
// {{</tabset>}}
//
// The Gateway specification above describes the L4-L6 properties of a load
// balancer. A `VirtualService` can then be bound to a gateway to control
// the forwarding of traffic arriving at a particular host or gateway port.
//
// For example, the following VirtualService splits traffic for
// `https://uk.bookinfo.com/reviews`, `https://eu.bookinfo.com/reviews`,
// `http://uk.bookinfo.com:9080/reviews`,
// `http://eu.bookinfo.com:9080/reviews` into two versions (prod and qa) of
// an internal reviews service on port 9080. In addition, requests
// containing the cookie "user: dev-123" will be sent to special port 7777
// in the qa version. The same rule is also applicable inside the mesh for
// requests to the "reviews.prod.svc.cluster.local" service. This rule is
// applicable across ports 443, 9080. Note that `http://uk.bookinfo.com`
// gets redirected to `https://uk.bookinfo.com` (i.e. 80 redirects to 443).
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: bookinfo-rule
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   - uk.bookinfo.com
//   - eu.bookinfo.com
//   gateways:
//   - some-config-namespace/my-gateway
//   - mesh # applies to all the sidecars in the mesh
//   http:
//   - match:
//     - headers:
//         cookie:
//           exact: "user=dev-123"
//     route:
//     - destination:
//         port:
//           number: 7777
//         host: reviews.qa.svc.cluster.local
//   - match:
//     - uri:
//         prefix: /reviews/
//     route:
//     - destination:
//         port:
//           number: 9080 # can be omitted if it's the only port for reviews
//         host: reviews.prod.svc.cluster.local
//       weight: 80
//     - destination:
//         host: reviews.qa.svc.cluster.local
//       weight: 20
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: VirtualService
// metadata:
//   name: bookinfo-rule
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   - uk.bookinfo.com
//   - eu.bookinfo.com
//   gateways:
//   - some-config-namespace/my-gateway
//   - mesh # applies to all the sidecars in the mesh
//   http:
//   - match:
//     - headers:
//         cookie:
//           exact: "user=dev-123"
//     route:
//     - destination:
//         port:
//           number: 7777
//         host: reviews.qa.svc.cluster.local
//   - match:
//     - uri:
//         prefix: /reviews/
//     route:
//     - destination:
//         port:
//           number: 9080 # can be omitted if it's the only port for reviews
//         host: reviews.prod.svc.cluster.local
//       weight: 80
//     - destination:
//         host: reviews.qa.svc.cluster.local
//       weight: 20
// ```
// {{</tab>}}
// {{</tabset>}}
//
// The following VirtualService forwards traffic arriving at (external)
// port 27017 to internal Mongo server on port 5555. This rule is not
// applicable internally in the mesh as the gateway list omits the
// reserved name `mesh`.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: bookinfo-mongo
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - mongosvr.prod.svc.cluster.local # name of internal Mongo service
//   gateways:
//   - some-config-namespace/my-gateway # can omit the namespace if gateway is in same namespace as virtual service.
//   tcp:
//   - match:
//     - port: 27017
//     route:
//     - destination:
//         host: mongo.prod.svc.cluster.local
//         port:
//           number: 5555
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: VirtualService
// metadata:
//   name: bookinfo-mongo
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - mongosvr.prod.svc.cluster.local # name of internal Mongo service
//   gateways:
//   - some-config-namespace/my-gateway # can omit the namespace if gateway is in same namespace as virtual service.
//   tcp:
//   - match:
//     - port: 27017
//     route:
//     - destination:
//         host: mongo.prod.svc.cluster.local
//         port:
//           number: 5555
// ```
// {{</tab>}}
// {{</tabset>}}
//
// It is possible to restrict the set of virtual services that can bind to
// a gateway server using the namespace/hostname syntax in the hosts field.
// For example, the following Gateway allows any virtual service in the ns1
// namespace to bind to it, while restricting only the virtual service with
// foo.bar.com host in the ns2 namespace to bind to it.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - "ns1/*"
//     - "ns2/foo.bar.com"
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - "ns1/*"
//     - "ns2/foo.bar.com"
// ```
// {{</tab>}}
// {{</tabset>}}
//

package v1alpha3

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// TLS modes enforced by the proxy
type ServerTLSSettings_TLSmode int32

const (
	// The SNI string presented by the client will be used as the
	// match criterion in a VirtualService TLS route to determine
	// the destination service from the service registry.
	ServerTLSSettings_PASSTHROUGH ServerTLSSettings_TLSmode = 0
	// Secure connections with standard TLS semantics.
	ServerTLSSettings_SIMPLE ServerTLSSettings_TLSmode = 1
	// Secure connections to the downstream using mutual TLS by
	// presenting server certificates for authentication.
	ServerTLSSettings_MUTUAL ServerTLSSettings_TLSmode = 2
	// Similar to the passthrough mode, except servers with this TLS
	// mode do not require an associated VirtualService to map from
	// the SNI value to service in the registry. The destination
	// details such as the service/subset/port are encoded in the
	// SNI value. The proxy will forward to the upstream (Envoy)
	// cluster (a group of endpoints) specified by the SNI
	// value. This server is typically used to provide connectivity
	// between services in disparate L3 networks that otherwise do
	// not have direct connectivity between their respective
	// endpoints. Use of this mode assumes that both the source and
	// the destination are using Istio mTLS to secure traffic.
	ServerTLSSettings_AUTO_PASSTHROUGH ServerTLSSettings_TLSmode = 3
	// Secure connections from the downstream using mutual TLS by
	// presenting server certificates for authentication.  Compared
	// to Mutual mode, this mode uses certificates, representing
	// gateway workload identity, generated automatically by Istio
	// for mTLS authentication. When this mode is used, all other
	// fields in `TLSOptions` should be empty.
	ServerTLSSettings_ISTIO_MUTUAL ServerTLSSettings_TLSmode = 4
)

var ServerTLSSettings_TLSmode_name = map[int32]string{
	0: "PASSTHROUGH",
	1: "SIMPLE",
	2: "MUTUAL",
	3: "AUTO_PASSTHROUGH",
	4: "ISTIO_MUTUAL",
}

var ServerTLSSettings_TLSmode_value = map[string]int32{
	"PASSTHROUGH":      0,
	"SIMPLE":           1,
	"MUTUAL":           2,
	"AUTO_PASSTHROUGH": 3,
	"ISTIO_MUTUAL":     4,
}

func (x ServerTLSSettings_TLSmode) String() string {
	return proto.EnumName(ServerTLSSettings_TLSmode_name, int32(x))
}

func (ServerTLSSettings_TLSmode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{3, 0}
}

// TLS protocol versions.
type ServerTLSSettings_TLSProtocol int32

const (
	// Automatically choose the optimal TLS version.
	ServerTLSSettings_TLS_AUTO ServerTLSSettings_TLSProtocol = 0
	// TLS version 1.0
	ServerTLSSettings_TLSV1_0 ServerTLSSettings_TLSProtocol = 1
	// TLS version 1.1
	ServerTLSSettings_TLSV1_1 ServerTLSSettings_TLSProtocol = 2
	// TLS version 1.2
	ServerTLSSettings_TLSV1_2 ServerTLSSettings_TLSProtocol = 3
	// TLS version 1.3
	ServerTLSSettings_TLSV1_3 ServerTLSSettings_TLSProtocol = 4
)

var ServerTLSSettings_TLSProtocol_name = map[int32]string{
	0: "TLS_AUTO",
	1: "TLSV1_0",
	2: "TLSV1_1",
	3: "TLSV1_2",
	4: "TLSV1_3",
}

var ServerTLSSettings_TLSProtocol_value = map[string]int32{
	"TLS_AUTO": 0,
	"TLSV1_0":  1,
	"TLSV1_1":  2,
	"TLSV1_2":  3,
	"TLSV1_3":  4,
}

func (x ServerTLSSettings_TLSProtocol) String() string {
	return proto.EnumName(ServerTLSSettings_TLSProtocol_name, int32(x))
}

func (ServerTLSSettings_TLSProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{3, 1}
}

// Gateway describes a load balancer operating at the edge of the mesh
// receiving incoming or outgoing HTTP/TCP connections.
//
// <!-- crd generation tags
// +cue-gen:Gateway:groupName:networking.istio.io
// +cue-gen:Gateway:version:v1alpha3
// +cue-gen:Gateway:storageVersion
// +cue-gen:Gateway:annotations:helm.sh/resource-policy=keep
// +cue-gen:Gateway:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:Gateway:subresource:status
// +cue-gen:Gateway:scope:Namespaced
// +cue-gen:Gateway:resource:categories=istio-io,networking-istio-io,shortNames=gw
// +cue-gen:Gateway:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
// <!-- istio code generation tags
// +istio.io/sync-start
// -->
type Gateway struct {
	// A list of server specifications.
	Servers []*Server `protobuf:"bytes,1,rep,name=servers,proto3" json:"servers,omitempty"`
	// One or more labels that indicate a specific set of pods/VMs
	// on which this gateway configuration should be applied.
	// By default workloads are searched across all namespaces based on label selectors.
	// This implies that a gateway resource in the namespace "foo" can select pods in
	// the namespace "bar" based on labels.
	// This behavior can be controlled via the `PILOT_SCOPE_GATEWAY_TO_NAMESPACE`
	// environment variable in istiod. If this variable is set
	// to true, the scope of label search is restricted to the configuration
	// namespace in which the the resource is present. In other words, the Gateway
	// resource must reside in the same namespace as the gateway workload
	// instance.
	// If selector is nil, the Gateway will be applied to all workloads.
	Selector             map[string]string `protobuf:"bytes,2,rep,name=selector,proto3" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Gateway) Reset()         { *m = Gateway{} }
func (m *Gateway) String() string { return proto.CompactTextString(m) }
func (*Gateway) ProtoMessage()    {}
func (*Gateway) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{0}
}
func (m *Gateway) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Gateway) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Gateway.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Gateway) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Gateway.Merge(m, src)
}
func (m *Gateway) XXX_Size() int {
	return m.Size()
}
func (m *Gateway) XXX_DiscardUnknown() {
	xxx_messageInfo_Gateway.DiscardUnknown(m)
}

var xxx_messageInfo_Gateway proto.InternalMessageInfo

func (m *Gateway) GetServers() []*Server {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *Gateway) GetSelector() map[string]string {
	if m != nil {
		return m.Selector
	}
	return nil
}

// `Server` describes the properties of the proxy on a given load balancer
// port. For example,
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-ingress
// spec:
//   selector:
//     app: my-ingressgateway
//   servers:
//   - port:
//       number: 80
//       name: http2
//       protocol: HTTP2
//     hosts:
//     - "*"
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: Gateway
// metadata:
//   name: my-ingress
// spec:
//   selector:
//     app: my-ingressgateway
//   servers:
//   - port:
//       number: 80
//       name: http2
//       protocol: HTTP2
//     hosts:
//     - "*"
// ```
// {{</tab>}}
// {{</tabset>}}
//
// Another example
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-tcp-ingress
// spec:
//   selector:
//     app: my-tcp-ingressgateway
//   servers:
//   - port:
//       number: 27018
//       name: mongo
//       protocol: MONGO
//     hosts:
//     - "*"
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: Gateway
// metadata:
//   name: my-tcp-ingress
// spec:
//   selector:
//     app: my-tcp-ingressgateway
//   servers:
//   - port:
//       number: 27018
//       name: mongo
//       protocol: MONGO
//     hosts:
//     - "*"
// ```
// {{</tab>}}
// {{</tabset>}}
//
// The following is an example of TLS configuration for port 443
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: Gateway
// metadata:
//   name: my-tls-ingress
// spec:
//   selector:
//     app: my-tls-ingressgateway
//   servers:
//   - port:
//       number: 443
//       name: https
//       protocol: HTTPS
//     hosts:
//     - "*"
//     tls:
//       mode: SIMPLE
//       serverCertificate: /etc/certs/server.pem
//       privateKey: /etc/certs/privatekey.pem
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: Gateway
// metadata:
//   name: my-tls-ingress
// spec:
//   selector:
//     app: my-tls-ingressgateway
//   servers:
//   - port:
//       number: 443
//       name: https
//       protocol: HTTPS
//     hosts:
//     - "*"
//     tls:
//       mode: SIMPLE
//       serverCertificate: /etc/certs/server.pem
//       privateKey: /etc/certs/privatekey.pem
// ```
// {{</tab>}}
// {{</tabset>}}
//
type Server struct {
	// The Port on which the proxy should listen for incoming
	// connections.
	Port *Port `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	// The ip or the Unix domain socket to which the listener should be bound
	// to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://@foobar`
	// (Linux abstract namespace). When using Unix domain sockets, the port
	// number should be 0.
	// This can be used to restrict the reachability of this server to be gateway internal only.
	// This is typically used when a gateway needs to communicate to another mesh service
	// e.g. publishing metrics. In such case, the server created with the
	// specified bind will not be available to external gateway clients.
	Bind string `protobuf:"bytes,4,opt,name=bind,proto3" json:"bind,omitempty"`
	// One or more hosts exposed by this gateway.
	// While typically applicable to
	// HTTP services, it can also be used for TCP services using TLS with SNI.
	// A host is specified as a `dnsName` with an optional `namespace/` prefix.
	// The `dnsName` should be specified using FQDN format, optionally including
	// a wildcard character in the left-most component (e.g., `prod/*.example.com`).
	// Set the `dnsName` to `*` to select all `VirtualService` hosts from the
	// specified namespace (e.g.,`prod/*`).
	//
	// The `namespace` can be set to `*` or `.`, representing any or the current
	// namespace, respectively. For example, `*/foo.example.com` selects the
	// service from any available namespace while `./foo.example.com` only selects
	// the service from the namespace of the sidecar. The default, if no `namespace/`
	// is specified, is `*/`, that is, select services from any namespace.
	// Any associated `DestinationRule` in the selected namespace will also be used.
	//
	// A `VirtualService` must be bound to the gateway and must have one or
	// more hosts that match the hosts specified in a server. The match
	// could be an exact match or a suffix match with the server's hosts. For
	// example, if the server's hosts specifies `*.example.com`, a
	// `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
	// match. However, a `VirtualService` with host `example.com` or
	// `newexample.com` will not match.
	//
	// NOTE: Only virtual services exported to the gateway's namespace
	// (e.g., `exportTo` value of `*`) can be referenced.
	// Private configurations (e.g., `exportTo` set to `.`) will not be
	// available. Refer to the `exportTo` setting in `VirtualService`,
	// `DestinationRule`, and `ServiceEntry` configurations for details.
	Hosts []string `protobuf:"bytes,2,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// Set of TLS related options that govern the server's behavior. Use
	// these options to control if all http requests should be redirected to
	// https, and the TLS modes to use.
	Tls *ServerTLSSettings `protobuf:"bytes,3,opt,name=tls,proto3" json:"tls,omitempty"`
	// The loopback IP endpoint or Unix domain socket to which traffic should
	// be forwarded to by default. Format should be `127.0.0.1:PORT` or
	// `unix:///path/to/socket` or `unix://@foobar` (Linux abstract namespace).
	// NOT IMPLEMENTED.
	// $hide_from_docs
	DefaultEndpoint string `protobuf:"bytes,5,opt,name=default_endpoint,json=defaultEndpoint,proto3" json:"default_endpoint,omitempty"`
	// An optional name of the server, when set must be unique across all servers.
	// This will be used for variety of purposes like prefixing stats generated with
	// this name etc.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Server) Reset()         { *m = Server{} }
func (m *Server) String() string { return proto.CompactTextString(m) }
func (*Server) ProtoMessage()    {}
func (*Server) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{1}
}
func (m *Server) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Server) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Server.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Server) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Server.Merge(m, src)
}
func (m *Server) XXX_Size() int {
	return m.Size()
}
func (m *Server) XXX_DiscardUnknown() {
	xxx_messageInfo_Server.DiscardUnknown(m)
}

var xxx_messageInfo_Server proto.InternalMessageInfo

func (m *Server) GetPort() *Port {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *Server) GetBind() string {
	if m != nil {
		return m.Bind
	}
	return ""
}

func (m *Server) GetHosts() []string {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *Server) GetTls() *ServerTLSSettings {
	if m != nil {
		return m.Tls
	}
	return nil
}

func (m *Server) GetDefaultEndpoint() string {
	if m != nil {
		return m.DefaultEndpoint
	}
	return ""
}

func (m *Server) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Port describes the properties of a specific port of a service.
type Port struct {
	// A valid non-negative integer port number.
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// The protocol exposed on the port.
	// MUST BE one of HTTP|HTTPS|GRPC|HTTP2|MONGO|TCP|TLS.
	// TLS implies the connection will be routed based on the SNI header to
	// the destination without terminating the TLS connection.
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Label assigned to the port.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The port number on the endpoint where the traffic will be
	// received. Applicable only when used with ServiceEntries.
	TargetPort           uint32   `protobuf:"varint,4,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Port) Reset()         { *m = Port{} }
func (m *Port) String() string { return proto.CompactTextString(m) }
func (*Port) ProtoMessage()    {}
func (*Port) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{2}
}
func (m *Port) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Port) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Port.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Port) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Port.Merge(m, src)
}
func (m *Port) XXX_Size() int {
	return m.Size()
}
func (m *Port) XXX_DiscardUnknown() {
	xxx_messageInfo_Port.DiscardUnknown(m)
}

var xxx_messageInfo_Port proto.InternalMessageInfo

func (m *Port) GetNumber() uint32 {
	if m != nil {
		return m.Number
	}
	return 0
}

func (m *Port) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *Port) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Port) GetTargetPort() uint32 {
	if m != nil {
		return m.TargetPort
	}
	return 0
}

type ServerTLSSettings struct {
	// If set to true, the load balancer will send a 301 redirect for
	// all http connections, asking the clients to use HTTPS.
	HttpsRedirect bool `protobuf:"varint,1,opt,name=https_redirect,json=httpsRedirect,proto3" json:"https_redirect,omitempty"`
	// Optional: Indicates whether connections to this port should be
	// secured using TLS. The value of this field determines how TLS is
	// enforced.
	Mode ServerTLSSettings_TLSmode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.networking.v1alpha3.ServerTLSSettings_TLSmode" json:"mode,omitempty"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server-side TLS certificate to use.
	ServerCertificate string `protobuf:"bytes,3,opt,name=server_certificate,json=serverCertificate,proto3" json:"server_certificate,omitempty"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server's private key.
	PrivateKey string `protobuf:"bytes,4,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to a file containing
	// certificate authority certificates to use in verifying a presented
	// client side certificate.
	CaCertificates string `protobuf:"bytes,5,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// For gateways running on Kubernetes, the name of the secret that
	// holds the TLS certs including the CA certificates. Applicable
	// only on Kubernetes. The secret (of type `generic`) should
	// contain the following keys and values: `key:
	// <privateKey>` and `cert: <serverCert>`. For mutual TLS,
	// `cacert: <CACertificate>` can be provided in the same secret or
	// a separate secret named `<secret>-cacert`.
	// Secret of type tls for server certificates along with
	// ca.crt key for CA certificates is also supported.
	// Only one of server certificates and CA certificate
	// or credentialName can be specified.
	CredentialName string `protobuf:"bytes,10,opt,name=credential_name,json=credentialName,proto3" json:"credential_name,omitempty"`
	// A list of alternate names to verify the subject identity in the
	// certificate presented by the client.
	SubjectAltNames []string `protobuf:"bytes,6,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
	// An optional list of base64-encoded SHA-256 hashes of the SKPIs of
	// authorized client certificates.
	// Note: When both verify_certificate_hash and verify_certificate_spki
	// are specified, a hash matching either value will result in the
	// certificate being accepted.
	VerifyCertificateSpki []string `protobuf:"bytes,11,rep,name=verify_certificate_spki,json=verifyCertificateSpki,proto3" json:"verify_certificate_spki,omitempty"`
	// An optional list of hex-encoded SHA-256 hashes of the
	// authorized client certificates. Both simple and colon separated
	// formats are acceptable.
	// Note: When both verify_certificate_hash and verify_certificate_spki
	// are specified, a hash matching either value will result in the
	// certificate being accepted.
	VerifyCertificateHash []string `protobuf:"bytes,12,rep,name=verify_certificate_hash,json=verifyCertificateHash,proto3" json:"verify_certificate_hash,omitempty"`
	// Optional: Minimum TLS protocol version.
	MinProtocolVersion ServerTLSSettings_TLSProtocol `protobuf:"varint,7,opt,name=min_protocol_version,json=minProtocolVersion,proto3,enum=istio.networking.v1alpha3.ServerTLSSettings_TLSProtocol" json:"min_protocol_version,omitempty"`
	// Optional: Maximum TLS protocol version.
	MaxProtocolVersion ServerTLSSettings_TLSProtocol `protobuf:"varint,8,opt,name=max_protocol_version,json=maxProtocolVersion,proto3,enum=istio.networking.v1alpha3.ServerTLSSettings_TLSProtocol" json:"max_protocol_version,omitempty"`
	// Optional: If specified, only support the specified cipher list.
	// Otherwise default to the default cipher list supported by Envoy.
	CipherSuites         []string `protobuf:"bytes,9,rep,name=cipher_suites,json=cipherSuites,proto3" json:"cipher_suites,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerTLSSettings) Reset()         { *m = ServerTLSSettings{} }
func (m *ServerTLSSettings) String() string { return proto.CompactTextString(m) }
func (*ServerTLSSettings) ProtoMessage()    {}
func (*ServerTLSSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_067d98d02f84cc0b, []int{3}
}
func (m *ServerTLSSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServerTLSSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServerTLSSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServerTLSSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerTLSSettings.Merge(m, src)
}
func (m *ServerTLSSettings) XXX_Size() int {
	return m.Size()
}
func (m *ServerTLSSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerTLSSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ServerTLSSettings proto.InternalMessageInfo

func (m *ServerTLSSettings) GetHttpsRedirect() bool {
	if m != nil {
		return m.HttpsRedirect
	}
	return false
}

func (m *ServerTLSSettings) GetMode() ServerTLSSettings_TLSmode {
	if m != nil {
		return m.Mode
	}
	return ServerTLSSettings_PASSTHROUGH
}

func (m *ServerTLSSettings) GetServerCertificate() string {
	if m != nil {
		return m.ServerCertificate
	}
	return ""
}

func (m *ServerTLSSettings) GetPrivateKey() string {
	if m != nil {
		return m.PrivateKey
	}
	return ""
}

func (m *ServerTLSSettings) GetCaCertificates() string {
	if m != nil {
		return m.CaCertificates
	}
	return ""
}

func (m *ServerTLSSettings) GetCredentialName() string {
	if m != nil {
		return m.CredentialName
	}
	return ""
}

func (m *ServerTLSSettings) GetSubjectAltNames() []string {
	if m != nil {
		return m.SubjectAltNames
	}
	return nil
}

func (m *ServerTLSSettings) GetVerifyCertificateSpki() []string {
	if m != nil {
		return m.VerifyCertificateSpki
	}
	return nil
}

func (m *ServerTLSSettings) GetVerifyCertificateHash() []string {
	if m != nil {
		return m.VerifyCertificateHash
	}
	return nil
}

func (m *ServerTLSSettings) GetMinProtocolVersion() ServerTLSSettings_TLSProtocol {
	if m != nil {
		return m.MinProtocolVersion
	}
	return ServerTLSSettings_TLS_AUTO
}

func (m *ServerTLSSettings) GetMaxProtocolVersion() ServerTLSSettings_TLSProtocol {
	if m != nil {
		return m.MaxProtocolVersion
	}
	return ServerTLSSettings_TLS_AUTO
}

func (m *ServerTLSSettings) GetCipherSuites() []string {
	if m != nil {
		return m.CipherSuites
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.networking.v1alpha3.ServerTLSSettings_TLSmode", ServerTLSSettings_TLSmode_name, ServerTLSSettings_TLSmode_value)
	proto.RegisterEnum("istio.networking.v1alpha3.ServerTLSSettings_TLSProtocol", ServerTLSSettings_TLSProtocol_name, ServerTLSSettings_TLSProtocol_value)
	proto.RegisterType((*Gateway)(nil), "istio.networking.v1alpha3.Gateway")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.Gateway.SelectorEntry")
	proto.RegisterType((*Server)(nil), "istio.networking.v1alpha3.Server")
	proto.RegisterType((*Port)(nil), "istio.networking.v1alpha3.Port")
	proto.RegisterType((*ServerTLSSettings)(nil), "istio.networking.v1alpha3.ServerTLSSettings")
}

func init() { proto.RegisterFile("networking/v1alpha3/gateway.proto", fileDescriptor_067d98d02f84cc0b) }

var fileDescriptor_067d98d02f84cc0b = []byte{
	// 790 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x5d, 0x6f, 0x1b, 0x45,
	0x14, 0xed, 0xda, 0x1b, 0xc7, 0xb9, 0x8e, 0x93, 0xcd, 0x28, 0x88, 0x25, 0x42, 0x49, 0x6a, 0x84,
	0x28, 0x08, 0x36, 0x4d, 0x82, 0x50, 0x01, 0x09, 0xc9, 0x45, 0x51, 0x13, 0xe1, 0x12, 0x6b, 0xd7,
	0xee, 0x43, 0x5f, 0x46, 0xe3, 0xf5, 0xd8, 0x3b, 0xf5, 0x7a, 0x67, 0x35, 0x33, 0x76, 0xeb, 0x47,
	0xfe, 0x1d, 0x8f, 0xfc, 0x01, 0x24, 0xe4, 0x67, 0x9e, 0xf8, 0x05, 0x68, 0x3e, 0x5c, 0x1b, 0x4a,
	0x8a, 0xaa, 0xbe, 0xcd, 0x9c, 0xb9, 0xe7, 0xdc, 0x7b, 0xcf, 0xbd, 0xf6, 0xc2, 0xfd, 0x82, 0xaa,
	0x97, 0x5c, 0x4c, 0x58, 0x31, 0x3e, 0x9b, 0x9f, 0x93, 0xbc, 0xcc, 0xc8, 0xe5, 0xd9, 0x98, 0x28,
	0xfa, 0x92, 0x2c, 0xa2, 0x52, 0x70, 0xc5, 0xd1, 0x47, 0x4c, 0x2a, 0xc6, 0xa3, 0x75, 0x60, 0xb4,
	0x0a, 0x3c, 0x3a, 0x19, 0x73, 0x3e, 0xce, 0xe9, 0x19, 0x29, 0xd9, 0xd9, 0x88, 0xd1, 0x7c, 0x88,
	0x07, 0x34, 0x23, 0x73, 0xc6, 0x85, 0xe5, 0xb6, 0x7e, 0xf7, 0x60, 0xfb, 0x89, 0x55, 0x43, 0x6d,
	0xd8, 0x96, 0x54, 0xcc, 0xa9, 0x90, 0xa1, 0x77, 0x5a, 0x7d, 0xd0, 0xb8, 0xb8, 0x1f, 0xdd, 0xa9,
	0x1c, 0x25, 0x26, 0xf2, 0xb1, 0xbf, 0x6c, 0x7b, 0x95, 0x78, 0xc5, 0x43, 0x31, 0xd4, 0x25, 0xcd,
	0x69, 0xaa, 0xb8, 0x08, 0x2b, 0x46, 0xe3, 0xe1, 0x5b, 0x34, 0x5c, 0xe2, 0x28, 0x71, 0x94, 0xab,
	0x42, 0x89, 0x85, 0x93, 0x7c, 0xad, 0x73, 0xf4, 0x3d, 0x34, 0xff, 0x11, 0x80, 0x02, 0xa8, 0x4e,
	0xe8, 0x22, 0xf4, 0x4e, 0xbd, 0x07, 0x3b, 0xb1, 0x3e, 0xa2, 0x43, 0xd8, 0x9a, 0x93, 0x7c, 0x46,
	0xc3, 0x8a, 0xc1, 0xec, 0xe5, 0xbb, 0xca, 0x23, 0xaf, 0xf5, 0x97, 0x07, 0x35, 0x5b, 0x2a, 0xfa,
	0x16, 0xfc, 0x92, 0x0b, 0x65, 0x78, 0x8d, 0x8b, 0x93, 0xb7, 0xd4, 0xd5, 0xe5, 0x42, 0xb9, 0x32,
	0x0c, 0x05, 0x21, 0xf0, 0x07, 0xac, 0x18, 0x86, 0xbe, 0x91, 0x37, 0x67, 0x74, 0x04, 0x5b, 0x19,
	0x97, 0x4a, 0x9a, 0x3e, 0x77, 0x5c, 0xb8, 0x85, 0xd0, 0x0f, 0x50, 0x55, 0xb9, 0x0c, 0xab, 0x26,
	0xd3, 0x97, 0xff, 0xeb, 0x62, 0xaf, 0x93, 0x24, 0x54, 0x29, 0x56, 0x8c, 0x65, 0xac, 0x89, 0xe8,
	0x73, 0x08, 0x86, 0x74, 0x44, 0x66, 0xb9, 0xc2, 0xb4, 0x18, 0x96, 0x9c, 0x15, 0x2a, 0xdc, 0x32,
	0xb9, 0xf7, 0x1d, 0x7e, 0xe5, 0x60, 0x5d, 0x5a, 0x41, 0xa6, 0x34, 0xac, 0xd9, 0xd2, 0xf4, 0xb9,
	0xf5, 0x8b, 0x07, 0xbe, 0xee, 0x01, 0x7d, 0x0c, 0xb5, 0x62, 0x36, 0x1d, 0x50, 0x61, 0x9a, 0x6e,
	0xba, 0x22, 0x1d, 0x86, 0x4e, 0xa1, 0x6e, 0x96, 0x20, 0xe5, 0xb9, 0x35, 0x6e, 0x65, 0xfd, 0x0a,
	0x45, 0xa1, 0x13, 0xaf, 0x6e, 0xbc, 0x1a, 0x04, 0x9d, 0x40, 0x43, 0x11, 0x31, 0xa6, 0x0a, 0x1b,
	0x4f, 0xb5, 0x31, 0xcd, 0x18, 0x2c, 0xa4, 0x53, 0xb7, 0xfe, 0xac, 0xc1, 0xc1, 0x1b, 0xdd, 0xa1,
	0x4f, 0x61, 0x2f, 0x53, 0xaa, 0x94, 0x58, 0xd0, 0x21, 0x13, 0x34, 0xb5, 0xd3, 0xa8, 0xc7, 0x4d,
	0x83, 0xc6, 0x0e, 0x44, 0xd7, 0xe0, 0x4f, 0xf9, 0xd0, 0x8e, 0x73, 0xef, 0xe2, 0xeb, 0x77, 0x31,
	0x30, 0xea, 0x75, 0x12, 0xcd, 0x8d, 0x8d, 0x02, 0xfa, 0x0a, 0x90, 0xdd, 0x4d, 0x9c, 0x52, 0xa1,
	0xd8, 0x88, 0xa5, 0x44, 0xb9, 0x7e, 0xe2, 0x03, 0xfb, 0xf2, 0xe3, 0xfa, 0x41, 0xb7, 0x55, 0x0a,
	0x36, 0x27, 0x8a, 0x62, 0xbd, 0x62, 0x76, 0xde, 0xe0, 0xa0, 0x9f, 0xe8, 0x02, 0x7d, 0x06, 0xfb,
	0x29, 0xd9, 0xd4, 0x92, 0x6e, 0x30, 0x7b, 0x29, 0xd9, 0x10, 0x92, 0x26, 0x50, 0xd0, 0x21, 0x2d,
	0x14, 0x23, 0x39, 0x36, 0x2e, 0x82, 0x0b, 0x7c, 0x0d, 0xff, 0xac, 0x9d, 0xfc, 0x02, 0x0e, 0xe4,
	0x6c, 0xf0, 0x82, 0xa6, 0x0a, 0x93, 0x5c, 0x99, 0x48, 0x19, 0xd6, 0xf4, 0x4e, 0xc5, 0xfb, 0xee,
	0xa1, 0x9d, 0x2b, 0x1d, 0x2a, 0xd1, 0x37, 0xf0, 0xe1, 0x9c, 0x0a, 0x36, 0x5a, 0x6c, 0x56, 0x80,
	0x65, 0x39, 0x61, 0x61, 0xc3, 0x30, 0x3e, 0xb0, 0xcf, 0x1b, 0x95, 0x24, 0xe5, 0x84, 0xdd, 0xc1,
	0xcb, 0x88, 0xcc, 0xc2, 0xdd, 0x3b, 0x78, 0xd7, 0x44, 0x66, 0xe8, 0x05, 0x1c, 0x4e, 0x59, 0x81,
	0x57, 0xfb, 0x80, 0xf5, 0x6f, 0x9c, 0xf1, 0x22, 0xdc, 0x36, 0x73, 0x79, 0xf4, 0xae, 0x73, 0xe9,
	0x3a, 0x9d, 0x18, 0x4d, 0x59, 0xb1, 0xba, 0x3c, 0xb3, 0x9a, 0x26, 0x17, 0x79, 0xf5, 0x66, 0xae,
	0xfa, 0x7b, 0xe7, 0x22, 0xaf, 0xfe, 0x9d, 0xeb, 0x13, 0x68, 0xa6, 0xac, 0xcc, 0xa8, 0xc0, 0x72,
	0xc6, 0xf4, 0x0c, 0x77, 0x8c, 0x0b, 0xbb, 0x16, 0x4c, 0x0c, 0xd6, 0x7a, 0x0e, 0xdb, 0x6e, 0x97,
	0xd0, 0x3e, 0x34, 0xba, 0xed, 0x24, 0xe9, 0x5d, 0xc7, 0xb7, 0xfd, 0x27, 0xd7, 0xc1, 0x3d, 0x04,
	0x50, 0x4b, 0x6e, 0x9e, 0x76, 0x3b, 0x57, 0x81, 0xa7, 0xcf, 0x4f, 0xfb, 0xbd, 0x7e, 0xbb, 0x13,
	0x54, 0xd0, 0x21, 0x04, 0xed, 0x7e, 0xef, 0x16, 0x6f, 0x46, 0x57, 0x51, 0x00, 0xbb, 0x37, 0x49,
	0xef, 0xe6, 0x16, 0xbb, 0x38, 0xbf, 0x75, 0x0b, 0x8d, 0x8d, 0x1a, 0xd1, 0x2e, 0xd4, 0x7b, 0x9d,
	0x04, 0x6b, 0x6a, 0x70, 0x0f, 0x35, 0x4c, 0xe2, 0x67, 0xe7, 0xf8, 0x61, 0xe0, 0xad, 0x2f, 0xe7,
	0x41, 0x65, 0x7d, 0xb9, 0x08, 0xaa, 0xeb, 0xcb, 0x65, 0xe0, 0x3f, 0x8e, 0x7e, 0x5d, 0x1e, 0x7b,
	0xbf, 0x2d, 0x8f, 0xbd, 0x3f, 0x96, 0xc7, 0xde, 0xf3, 0x53, 0x6b, 0x16, 0xe3, 0xe6, 0x8f, 0xff,
	0x3f, 0xbe, 0x20, 0x83, 0x9a, 0xf1, 0xf9, 0xf2, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x75, 0x04,
	0x41, 0xab, 0x5f, 0x06, 0x00, 0x00,
}

func (m *Gateway) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Gateway) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Gateway) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Selector) > 0 {
		for k := range m.Selector {
			v := m.Selector[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintGateway(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintGateway(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintGateway(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Servers) > 0 {
		for iNdEx := len(m.Servers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Servers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGateway(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Server) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Server) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Server) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.DefaultEndpoint) > 0 {
		i -= len(m.DefaultEndpoint)
		copy(dAtA[i:], m.DefaultEndpoint)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.DefaultEndpoint)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Bind) > 0 {
		i -= len(m.Bind)
		copy(dAtA[i:], m.Bind)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.Bind)))
		i--
		dAtA[i] = 0x22
	}
	if m.Tls != nil {
		{
			size, err := m.Tls.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGateway(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Hosts) > 0 {
		for iNdEx := len(m.Hosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hosts[iNdEx])
			copy(dAtA[i:], m.Hosts[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.Hosts[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Port != nil {
		{
			size, err := m.Port.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGateway(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Port) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Port) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Port) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TargetPort != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.TargetPort))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0x12
	}
	if m.Number != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.Number))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ServerTLSSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerTLSSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerTLSSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.VerifyCertificateHash) > 0 {
		for iNdEx := len(m.VerifyCertificateHash) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.VerifyCertificateHash[iNdEx])
			copy(dAtA[i:], m.VerifyCertificateHash[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.VerifyCertificateHash[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for iNdEx := len(m.VerifyCertificateSpki) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.VerifyCertificateSpki[iNdEx])
			copy(dAtA[i:], m.VerifyCertificateSpki[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.VerifyCertificateSpki[iNdEx])))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.CredentialName) > 0 {
		i -= len(m.CredentialName)
		copy(dAtA[i:], m.CredentialName)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.CredentialName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.CipherSuites) > 0 {
		for iNdEx := len(m.CipherSuites) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CipherSuites[iNdEx])
			copy(dAtA[i:], m.CipherSuites[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.CipherSuites[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.MaxProtocolVersion != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.MaxProtocolVersion))
		i--
		dAtA[i] = 0x40
	}
	if m.MinProtocolVersion != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.MinProtocolVersion))
		i--
		dAtA[i] = 0x38
	}
	if len(m.SubjectAltNames) > 0 {
		for iNdEx := len(m.SubjectAltNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SubjectAltNames[iNdEx])
			copy(dAtA[i:], m.SubjectAltNames[iNdEx])
			i = encodeVarintGateway(dAtA, i, uint64(len(m.SubjectAltNames[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.CaCertificates) > 0 {
		i -= len(m.CaCertificates)
		copy(dAtA[i:], m.CaCertificates)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.CaCertificates)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.PrivateKey) > 0 {
		i -= len(m.PrivateKey)
		copy(dAtA[i:], m.PrivateKey)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.PrivateKey)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ServerCertificate) > 0 {
		i -= len(m.ServerCertificate)
		copy(dAtA[i:], m.ServerCertificate)
		i = encodeVarintGateway(dAtA, i, uint64(len(m.ServerCertificate)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Mode != 0 {
		i = encodeVarintGateway(dAtA, i, uint64(m.Mode))
		i--
		dAtA[i] = 0x10
	}
	if m.HttpsRedirect {
		i--
		if m.HttpsRedirect {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintGateway(dAtA []byte, offset int, v uint64) int {
	offset -= sovGateway(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Gateway) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Servers) > 0 {
		for _, e := range m.Servers {
			l = e.Size()
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if len(m.Selector) > 0 {
		for k, v := range m.Selector {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGateway(uint64(len(k))) + 1 + len(v) + sovGateway(uint64(len(v)))
			n += mapEntrySize + 1 + sovGateway(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Server) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovGateway(uint64(l))
	}
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if m.Tls != nil {
		l = m.Tls.Size()
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.Bind)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.DefaultEndpoint)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Port) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Number != 0 {
		n += 1 + sovGateway(uint64(m.Number))
	}
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if m.TargetPort != 0 {
		n += 1 + sovGateway(uint64(m.TargetPort))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServerTLSSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpsRedirect {
		n += 2
	}
	if m.Mode != 0 {
		n += 1 + sovGateway(uint64(m.Mode))
	}
	l = len(m.ServerCertificate)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.PrivateKey)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	l = len(m.CaCertificates)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if len(m.SubjectAltNames) > 0 {
		for _, s := range m.SubjectAltNames {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if m.MinProtocolVersion != 0 {
		n += 1 + sovGateway(uint64(m.MinProtocolVersion))
	}
	if m.MaxProtocolVersion != 0 {
		n += 1 + sovGateway(uint64(m.MaxProtocolVersion))
	}
	if len(m.CipherSuites) > 0 {
		for _, s := range m.CipherSuites {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	l = len(m.CredentialName)
	if l > 0 {
		n += 1 + l + sovGateway(uint64(l))
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for _, s := range m.VerifyCertificateSpki {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if len(m.VerifyCertificateHash) > 0 {
		for _, s := range m.VerifyCertificateHash {
			l = len(s)
			n += 1 + l + sovGateway(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovGateway(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGateway(x uint64) (n int) {
	return sovGateway(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Gateway) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Gateway: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Gateway: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Servers = append(m.Servers, &Server{})
			if err := m.Servers[len(m.Servers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selector == nil {
				m.Selector = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGateway
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGateway
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGateway
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthGateway
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGateway
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthGateway
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthGateway
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGateway(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthGateway
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Selector[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Server) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Server: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Server: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Port == nil {
				m.Port = &Port{}
			}
			if err := m.Port.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tls == nil {
				m.Tls = &ServerTLSSettings{}
			}
			if err := m.Tls.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultEndpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultEndpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Port) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Port: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Port: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Number", wireType)
			}
			m.Number = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Number |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetPort", wireType)
			}
			m.TargetPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetPort |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerTLSSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerTLSSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerTLSSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpsRedirect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HttpsRedirect = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= ServerTLSSettings_TLSmode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerCertificate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerCertificate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificates", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificates = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectAltNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectAltNames = append(m.SubjectAltNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinProtocolVersion", wireType)
			}
			m.MinProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinProtocolVersion |= ServerTLSSettings_TLSProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxProtocolVersion", wireType)
			}
			m.MaxProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxProtocolVersion |= ServerTLSSettings_TLSProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherSuites", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CipherSuites = append(m.CipherSuites, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateSpki", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateSpki = append(m.VerifyCertificateSpki, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateHash = append(m.VerifyCertificateHash, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGateway(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGateway
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGateway
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGateway
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGateway
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGateway
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGateway        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGateway          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGateway = fmt.Errorf("proto: unexpected end of group")
)
