//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import (
	"context"
	"errors"
	"fmt"
	"net/http"
	"net/url"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// ResolvePrivateLinkServiceIDClient contains the methods for the ResolvePrivateLinkServiceID group.
// Don't use this type directly, use NewResolvePrivateLinkServiceIDClient() instead.
type ResolvePrivateLinkServiceIDClient struct {
	ep             string
	pl             runtime.Pipeline
	subscriptionID string
}

// NewResolvePrivateLinkServiceIDClient creates a new instance of ResolvePrivateLinkServiceIDClient with the specified values.
func NewResolvePrivateLinkServiceIDClient(con *arm.Connection, subscriptionID string) *ResolvePrivateLinkServiceIDClient {
	return &ResolvePrivateLinkServiceIDClient{ep: con.Endpoint(), pl: con.NewPipeline(module, version), subscriptionID: subscriptionID}
}

// POST - Gets the private link service ID for the specified managed cluster.
// If the operation fails it returns the *CloudError error type.
func (client *ResolvePrivateLinkServiceIDClient) POST(ctx context.Context, resourceGroupName string, resourceName string, parameters PrivateLinkResource, options *ResolvePrivateLinkServiceIDPOSTOptions) (ResolvePrivateLinkServiceIDPOSTResponse, error) {
	req, err := client.postCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return ResolvePrivateLinkServiceIDPOSTResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ResolvePrivateLinkServiceIDPOSTResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResolvePrivateLinkServiceIDPOSTResponse{}, client.postHandleError(resp)
	}
	return client.postHandleResponse(resp)
}

// postCreateRequest creates the POST request.
func (client *ResolvePrivateLinkServiceIDClient) postCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters PrivateLinkResource, options *ResolvePrivateLinkServiceIDPOSTOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resolvePrivateLinkServiceId"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.ep, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("Accept", "application/json")
	return req, runtime.MarshalAsJSON(req, parameters)
}

// postHandleResponse handles the POST response.
func (client *ResolvePrivateLinkServiceIDClient) postHandleResponse(resp *http.Response) (ResolvePrivateLinkServiceIDPOSTResponse, error) {
	result := ResolvePrivateLinkServiceIDPOSTResponse{RawResponse: resp}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResource); err != nil {
		return ResolvePrivateLinkServiceIDPOSTResponse{}, err
	}
	return result, nil
}

// postHandleError handles the POST error response.
func (client *ResolvePrivateLinkServiceIDClient) postHandleError(resp *http.Response) error {
	body, err := runtime.Payload(resp)
	if err != nil {
		return runtime.NewResponseError(err, resp)
	}
	errType := CloudError{raw: string(body)}
	if err := runtime.UnmarshalAsJSON(resp, &errType); err != nil {
		return runtime.NewResponseError(fmt.Errorf("%s\n%s", string(body), err), resp)
	}
	return runtime.NewResponseError(&errType, resp)
}
