//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	core "github.com/gardener/gardener/pkg/apis/core"
	v1beta1 "github.com/gardener/gardener/pkg/apis/core/v1beta1"
	config "github.com/gardener/gardener/pkg/gardenlet/apis/config"
	corev1 "k8s.io/api/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	componentbaseconfig "k8s.io/component-base/config"
	configv1alpha1 "k8s.io/component-base/config/v1alpha1"
	klog "k8s.io/klog"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*BackupBucketControllerConfiguration)(nil), (*config.BackupBucketControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupBucketControllerConfiguration_To_config_BackupBucketControllerConfiguration(a.(*BackupBucketControllerConfiguration), b.(*config.BackupBucketControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.BackupBucketControllerConfiguration)(nil), (*BackupBucketControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_BackupBucketControllerConfiguration_To_v1alpha1_BackupBucketControllerConfiguration(a.(*config.BackupBucketControllerConfiguration), b.(*BackupBucketControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackupCompactionController)(nil), (*config.BackupCompactionController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupCompactionController_To_config_BackupCompactionController(a.(*BackupCompactionController), b.(*config.BackupCompactionController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.BackupCompactionController)(nil), (*BackupCompactionController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_BackupCompactionController_To_v1alpha1_BackupCompactionController(a.(*config.BackupCompactionController), b.(*BackupCompactionController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BackupEntryControllerConfiguration)(nil), (*config.BackupEntryControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BackupEntryControllerConfiguration_To_config_BackupEntryControllerConfiguration(a.(*BackupEntryControllerConfiguration), b.(*config.BackupEntryControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.BackupEntryControllerConfiguration)(nil), (*BackupEntryControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_BackupEntryControllerConfiguration_To_v1alpha1_BackupEntryControllerConfiguration(a.(*config.BackupEntryControllerConfiguration), b.(*BackupEntryControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BastionControllerConfiguration)(nil), (*config.BastionControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BastionControllerConfiguration_To_config_BastionControllerConfiguration(a.(*BastionControllerConfiguration), b.(*config.BastionControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.BastionControllerConfiguration)(nil), (*BastionControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_BastionControllerConfiguration_To_v1alpha1_BastionControllerConfiguration(a.(*config.BastionControllerConfiguration), b.(*BastionControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ConditionThreshold)(nil), (*config.ConditionThreshold)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ConditionThreshold_To_config_ConditionThreshold(a.(*ConditionThreshold), b.(*config.ConditionThreshold), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ConditionThreshold)(nil), (*ConditionThreshold)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ConditionThreshold_To_v1alpha1_ConditionThreshold(a.(*config.ConditionThreshold), b.(*ConditionThreshold), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerInstallationCareControllerConfiguration)(nil), (*config.ControllerInstallationCareControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerInstallationCareControllerConfiguration_To_config_ControllerInstallationCareControllerConfiguration(a.(*ControllerInstallationCareControllerConfiguration), b.(*config.ControllerInstallationCareControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ControllerInstallationCareControllerConfiguration)(nil), (*ControllerInstallationCareControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ControllerInstallationCareControllerConfiguration_To_v1alpha1_ControllerInstallationCareControllerConfiguration(a.(*config.ControllerInstallationCareControllerConfiguration), b.(*ControllerInstallationCareControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerInstallationControllerConfiguration)(nil), (*config.ControllerInstallationControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerInstallationControllerConfiguration_To_config_ControllerInstallationControllerConfiguration(a.(*ControllerInstallationControllerConfiguration), b.(*config.ControllerInstallationControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ControllerInstallationControllerConfiguration)(nil), (*ControllerInstallationControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ControllerInstallationControllerConfiguration_To_v1alpha1_ControllerInstallationControllerConfiguration(a.(*config.ControllerInstallationControllerConfiguration), b.(*ControllerInstallationControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerInstallationRequiredControllerConfiguration)(nil), (*config.ControllerInstallationRequiredControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerInstallationRequiredControllerConfiguration_To_config_ControllerInstallationRequiredControllerConfiguration(a.(*ControllerInstallationRequiredControllerConfiguration), b.(*config.ControllerInstallationRequiredControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ControllerInstallationRequiredControllerConfiguration)(nil), (*ControllerInstallationRequiredControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ControllerInstallationRequiredControllerConfiguration_To_v1alpha1_ControllerInstallationRequiredControllerConfiguration(a.(*config.ControllerInstallationRequiredControllerConfiguration), b.(*ControllerInstallationRequiredControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*CustodianController)(nil), (*config.CustodianController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CustodianController_To_config_CustodianController(a.(*CustodianController), b.(*config.CustodianController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.CustodianController)(nil), (*CustodianController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_CustodianController_To_v1alpha1_CustodianController(a.(*config.CustodianController), b.(*CustodianController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ETCDConfig)(nil), (*config.ETCDConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ETCDConfig_To_config_ETCDConfig(a.(*ETCDConfig), b.(*config.ETCDConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ETCDConfig)(nil), (*ETCDConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ETCDConfig_To_v1alpha1_ETCDConfig(a.(*config.ETCDConfig), b.(*ETCDConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ETCDController)(nil), (*config.ETCDController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ETCDController_To_config_ETCDController(a.(*ETCDController), b.(*config.ETCDController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ETCDController)(nil), (*ETCDController)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ETCDController_To_v1alpha1_ETCDController(a.(*config.ETCDController), b.(*ETCDController), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ExposureClassHandler)(nil), (*config.ExposureClassHandler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ExposureClassHandler_To_config_ExposureClassHandler(a.(*ExposureClassHandler), b.(*config.ExposureClassHandler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ExposureClassHandler)(nil), (*ExposureClassHandler)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ExposureClassHandler_To_v1alpha1_ExposureClassHandler(a.(*config.ExposureClassHandler), b.(*ExposureClassHandler), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FluentBit)(nil), (*config.FluentBit)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_FluentBit_To_config_FluentBit(a.(*FluentBit), b.(*config.FluentBit), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.FluentBit)(nil), (*FluentBit)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_FluentBit_To_v1alpha1_FluentBit(a.(*config.FluentBit), b.(*FluentBit), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*GardenClientConnection)(nil), (*config.GardenClientConnection)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GardenClientConnection_To_config_GardenClientConnection(a.(*GardenClientConnection), b.(*config.GardenClientConnection), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.GardenClientConnection)(nil), (*GardenClientConnection)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_GardenClientConnection_To_v1alpha1_GardenClientConnection(a.(*config.GardenClientConnection), b.(*GardenClientConnection), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*GardenLoki)(nil), (*config.GardenLoki)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GardenLoki_To_config_GardenLoki(a.(*GardenLoki), b.(*config.GardenLoki), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.GardenLoki)(nil), (*GardenLoki)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_GardenLoki_To_v1alpha1_GardenLoki(a.(*config.GardenLoki), b.(*GardenLoki), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*GardenletConfiguration)(nil), (*config.GardenletConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GardenletConfiguration_To_config_GardenletConfiguration(a.(*GardenletConfiguration), b.(*config.GardenletConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.GardenletConfiguration)(nil), (*GardenletConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_GardenletConfiguration_To_v1alpha1_GardenletConfiguration(a.(*config.GardenletConfiguration), b.(*GardenletConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*GardenletControllerConfiguration)(nil), (*config.GardenletControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GardenletControllerConfiguration_To_config_GardenletControllerConfiguration(a.(*GardenletControllerConfiguration), b.(*config.GardenletControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.GardenletControllerConfiguration)(nil), (*GardenletControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_GardenletControllerConfiguration_To_v1alpha1_GardenletControllerConfiguration(a.(*config.GardenletControllerConfiguration), b.(*GardenletControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HTTPSServer)(nil), (*config.HTTPSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer(a.(*HTTPSServer), b.(*config.HTTPSServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.HTTPSServer)(nil), (*HTTPSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer(a.(*config.HTTPSServer), b.(*HTTPSServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LoadBalancerServiceConfig)(nil), (*config.LoadBalancerServiceConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LoadBalancerServiceConfig_To_config_LoadBalancerServiceConfig(a.(*LoadBalancerServiceConfig), b.(*config.LoadBalancerServiceConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.LoadBalancerServiceConfig)(nil), (*LoadBalancerServiceConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_LoadBalancerServiceConfig_To_v1alpha1_LoadBalancerServiceConfig(a.(*config.LoadBalancerServiceConfig), b.(*LoadBalancerServiceConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Logging)(nil), (*config.Logging)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Logging_To_config_Logging(a.(*Logging), b.(*config.Logging), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.Logging)(nil), (*Logging)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_Logging_To_v1alpha1_Logging(a.(*config.Logging), b.(*Logging), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Loki)(nil), (*config.Loki)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Loki_To_config_Loki(a.(*Loki), b.(*config.Loki), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.Loki)(nil), (*Loki)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_Loki_To_v1alpha1_Loki(a.(*config.Loki), b.(*Loki), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ManagedSeedControllerConfiguration)(nil), (*config.ManagedSeedControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ManagedSeedControllerConfiguration_To_config_ManagedSeedControllerConfiguration(a.(*ManagedSeedControllerConfiguration), b.(*config.ManagedSeedControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ManagedSeedControllerConfiguration)(nil), (*ManagedSeedControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ManagedSeedControllerConfiguration_To_v1alpha1_ManagedSeedControllerConfiguration(a.(*config.ManagedSeedControllerConfiguration), b.(*ManagedSeedControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MonitoringConfig)(nil), (*config.MonitoringConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MonitoringConfig_To_config_MonitoringConfig(a.(*MonitoringConfig), b.(*config.MonitoringConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.MonitoringConfig)(nil), (*MonitoringConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_MonitoringConfig_To_v1alpha1_MonitoringConfig(a.(*config.MonitoringConfig), b.(*MonitoringConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RemoteWriteMonitoringConfig)(nil), (*config.RemoteWriteMonitoringConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_RemoteWriteMonitoringConfig_To_config_RemoteWriteMonitoringConfig(a.(*RemoteWriteMonitoringConfig), b.(*config.RemoteWriteMonitoringConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.RemoteWriteMonitoringConfig)(nil), (*RemoteWriteMonitoringConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_RemoteWriteMonitoringConfig_To_v1alpha1_RemoteWriteMonitoringConfig(a.(*config.RemoteWriteMonitoringConfig), b.(*RemoteWriteMonitoringConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourcesConfiguration)(nil), (*config.ResourcesConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourcesConfiguration_To_config_ResourcesConfiguration(a.(*ResourcesConfiguration), b.(*config.ResourcesConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ResourcesConfiguration)(nil), (*ResourcesConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ResourcesConfiguration_To_v1alpha1_ResourcesConfiguration(a.(*config.ResourcesConfiguration), b.(*ResourcesConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SNI)(nil), (*config.SNI)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SNI_To_config_SNI(a.(*SNI), b.(*config.SNI), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SNI)(nil), (*SNI)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SNI_To_v1alpha1_SNI(a.(*config.SNI), b.(*SNI), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SNIIngress)(nil), (*config.SNIIngress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SNIIngress_To_config_SNIIngress(a.(*SNIIngress), b.(*config.SNIIngress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SNIIngress)(nil), (*SNIIngress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SNIIngress_To_v1alpha1_SNIIngress(a.(*config.SNIIngress), b.(*SNIIngress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedAPIServerNetworkPolicyControllerConfiguration)(nil), (*config.SeedAPIServerNetworkPolicyControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration_To_config_SeedAPIServerNetworkPolicyControllerConfiguration(a.(*SeedAPIServerNetworkPolicyControllerConfiguration), b.(*config.SeedAPIServerNetworkPolicyControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SeedAPIServerNetworkPolicyControllerConfiguration)(nil), (*SeedAPIServerNetworkPolicyControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SeedAPIServerNetworkPolicyControllerConfiguration_To_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration(a.(*config.SeedAPIServerNetworkPolicyControllerConfiguration), b.(*SeedAPIServerNetworkPolicyControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedClientConnection)(nil), (*config.SeedClientConnection)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedClientConnection_To_config_SeedClientConnection(a.(*SeedClientConnection), b.(*config.SeedClientConnection), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SeedClientConnection)(nil), (*SeedClientConnection)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SeedClientConnection_To_v1alpha1_SeedClientConnection(a.(*config.SeedClientConnection), b.(*SeedClientConnection), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedConfig)(nil), (*config.SeedConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedConfig_To_config_SeedConfig(a.(*SeedConfig), b.(*config.SeedConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SeedConfig)(nil), (*SeedConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SeedConfig_To_v1alpha1_SeedConfig(a.(*config.SeedConfig), b.(*SeedConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedControllerConfiguration)(nil), (*config.SeedControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(a.(*SeedControllerConfiguration), b.(*config.SeedControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SeedControllerConfiguration)(nil), (*SeedControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(a.(*config.SeedControllerConfiguration), b.(*SeedControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Server)(nil), (*config.Server)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Server_To_config_Server(a.(*Server), b.(*config.Server), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.Server)(nil), (*Server)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_Server_To_v1alpha1_Server(a.(*config.Server), b.(*Server), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ServerConfiguration)(nil), (*config.ServerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(a.(*ServerConfiguration), b.(*config.ServerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ServerConfiguration)(nil), (*ServerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(a.(*config.ServerConfiguration), b.(*ServerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootCareControllerConfiguration)(nil), (*config.ShootCareControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootCareControllerConfiguration_To_config_ShootCareControllerConfiguration(a.(*ShootCareControllerConfiguration), b.(*config.ShootCareControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootCareControllerConfiguration)(nil), (*ShootCareControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootCareControllerConfiguration_To_v1alpha1_ShootCareControllerConfiguration(a.(*config.ShootCareControllerConfiguration), b.(*ShootCareControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootClientConnection)(nil), (*config.ShootClientConnection)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootClientConnection_To_config_ShootClientConnection(a.(*ShootClientConnection), b.(*config.ShootClientConnection), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootClientConnection)(nil), (*ShootClientConnection)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootClientConnection_To_v1alpha1_ShootClientConnection(a.(*config.ShootClientConnection), b.(*ShootClientConnection), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootControllerConfiguration)(nil), (*config.ShootControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootControllerConfiguration_To_config_ShootControllerConfiguration(a.(*ShootControllerConfiguration), b.(*config.ShootControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootControllerConfiguration)(nil), (*ShootControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootControllerConfiguration_To_v1alpha1_ShootControllerConfiguration(a.(*config.ShootControllerConfiguration), b.(*ShootControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootMonitoringConfig)(nil), (*config.ShootMonitoringConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootMonitoringConfig_To_config_ShootMonitoringConfig(a.(*ShootMonitoringConfig), b.(*config.ShootMonitoringConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootMonitoringConfig)(nil), (*ShootMonitoringConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootMonitoringConfig_To_v1alpha1_ShootMonitoringConfig(a.(*config.ShootMonitoringConfig), b.(*ShootMonitoringConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootNodeLogging)(nil), (*config.ShootNodeLogging)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootNodeLogging_To_config_ShootNodeLogging(a.(*ShootNodeLogging), b.(*config.ShootNodeLogging), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootNodeLogging)(nil), (*ShootNodeLogging)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootNodeLogging_To_v1alpha1_ShootNodeLogging(a.(*config.ShootNodeLogging), b.(*ShootNodeLogging), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootStateSyncControllerConfiguration)(nil), (*config.ShootStateSyncControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootStateSyncControllerConfiguration_To_config_ShootStateSyncControllerConfiguration(a.(*ShootStateSyncControllerConfiguration), b.(*config.ShootStateSyncControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootStateSyncControllerConfiguration)(nil), (*ShootStateSyncControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootStateSyncControllerConfiguration_To_v1alpha1_ShootStateSyncControllerConfiguration(a.(*config.ShootStateSyncControllerConfiguration), b.(*ShootStateSyncControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*StaleExtensionHealthChecks)(nil), (*config.StaleExtensionHealthChecks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_StaleExtensionHealthChecks_To_config_StaleExtensionHealthChecks(a.(*StaleExtensionHealthChecks), b.(*config.StaleExtensionHealthChecks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.StaleExtensionHealthChecks)(nil), (*StaleExtensionHealthChecks)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_StaleExtensionHealthChecks_To_v1alpha1_StaleExtensionHealthChecks(a.(*config.StaleExtensionHealthChecks), b.(*StaleExtensionHealthChecks), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*TLSServer)(nil), (*config.TLSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_TLSServer_To_config_TLSServer(a.(*TLSServer), b.(*config.TLSServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.TLSServer)(nil), (*TLSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_TLSServer_To_v1alpha1_TLSServer(a.(*config.TLSServer), b.(*TLSServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*core.SeedTemplate)(nil), (*v1beta1.SeedTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_SeedTemplate_To_v1beta1_SeedTemplate(a.(*core.SeedTemplate), b.(*v1beta1.SeedTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.SeedTemplate)(nil), (*core.SeedTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_SeedTemplate_To_core_SeedTemplate(a.(*v1beta1.SeedTemplate), b.(*core.SeedTemplate), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_BackupBucketControllerConfiguration_To_config_BackupBucketControllerConfiguration(in *BackupBucketControllerConfiguration, out *config.BackupBucketControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_v1alpha1_BackupBucketControllerConfiguration_To_config_BackupBucketControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_BackupBucketControllerConfiguration_To_config_BackupBucketControllerConfiguration(in *BackupBucketControllerConfiguration, out *config.BackupBucketControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupBucketControllerConfiguration_To_config_BackupBucketControllerConfiguration(in, out, s)
}

func autoConvert_config_BackupBucketControllerConfiguration_To_v1alpha1_BackupBucketControllerConfiguration(in *config.BackupBucketControllerConfiguration, out *BackupBucketControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_config_BackupBucketControllerConfiguration_To_v1alpha1_BackupBucketControllerConfiguration is an autogenerated conversion function.
func Convert_config_BackupBucketControllerConfiguration_To_v1alpha1_BackupBucketControllerConfiguration(in *config.BackupBucketControllerConfiguration, out *BackupBucketControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_BackupBucketControllerConfiguration_To_v1alpha1_BackupBucketControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_BackupCompactionController_To_config_BackupCompactionController(in *BackupCompactionController, out *config.BackupCompactionController, s conversion.Scope) error {
	out.Workers = (*int64)(unsafe.Pointer(in.Workers))
	out.EnableBackupCompaction = (*bool)(unsafe.Pointer(in.EnableBackupCompaction))
	out.EventsThreshold = (*int64)(unsafe.Pointer(in.EventsThreshold))
	out.ActiveDeadlineDuration = (*v1.Duration)(unsafe.Pointer(in.ActiveDeadlineDuration))
	return nil
}

// Convert_v1alpha1_BackupCompactionController_To_config_BackupCompactionController is an autogenerated conversion function.
func Convert_v1alpha1_BackupCompactionController_To_config_BackupCompactionController(in *BackupCompactionController, out *config.BackupCompactionController, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupCompactionController_To_config_BackupCompactionController(in, out, s)
}

func autoConvert_config_BackupCompactionController_To_v1alpha1_BackupCompactionController(in *config.BackupCompactionController, out *BackupCompactionController, s conversion.Scope) error {
	out.Workers = (*int64)(unsafe.Pointer(in.Workers))
	out.EnableBackupCompaction = (*bool)(unsafe.Pointer(in.EnableBackupCompaction))
	out.EventsThreshold = (*int64)(unsafe.Pointer(in.EventsThreshold))
	out.ActiveDeadlineDuration = (*v1.Duration)(unsafe.Pointer(in.ActiveDeadlineDuration))
	return nil
}

// Convert_config_BackupCompactionController_To_v1alpha1_BackupCompactionController is an autogenerated conversion function.
func Convert_config_BackupCompactionController_To_v1alpha1_BackupCompactionController(in *config.BackupCompactionController, out *BackupCompactionController, s conversion.Scope) error {
	return autoConvert_config_BackupCompactionController_To_v1alpha1_BackupCompactionController(in, out, s)
}

func autoConvert_v1alpha1_BackupEntryControllerConfiguration_To_config_BackupEntryControllerConfiguration(in *BackupEntryControllerConfiguration, out *config.BackupEntryControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.DeletionGracePeriodHours = (*int)(unsafe.Pointer(in.DeletionGracePeriodHours))
	out.DeletionGracePeriodShootPurposes = *(*[]core.ShootPurpose)(unsafe.Pointer(&in.DeletionGracePeriodShootPurposes))
	return nil
}

// Convert_v1alpha1_BackupEntryControllerConfiguration_To_config_BackupEntryControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_BackupEntryControllerConfiguration_To_config_BackupEntryControllerConfiguration(in *BackupEntryControllerConfiguration, out *config.BackupEntryControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_BackupEntryControllerConfiguration_To_config_BackupEntryControllerConfiguration(in, out, s)
}

func autoConvert_config_BackupEntryControllerConfiguration_To_v1alpha1_BackupEntryControllerConfiguration(in *config.BackupEntryControllerConfiguration, out *BackupEntryControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.DeletionGracePeriodHours = (*int)(unsafe.Pointer(in.DeletionGracePeriodHours))
	out.DeletionGracePeriodShootPurposes = *(*[]v1beta1.ShootPurpose)(unsafe.Pointer(&in.DeletionGracePeriodShootPurposes))
	return nil
}

// Convert_config_BackupEntryControllerConfiguration_To_v1alpha1_BackupEntryControllerConfiguration is an autogenerated conversion function.
func Convert_config_BackupEntryControllerConfiguration_To_v1alpha1_BackupEntryControllerConfiguration(in *config.BackupEntryControllerConfiguration, out *BackupEntryControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_BackupEntryControllerConfiguration_To_v1alpha1_BackupEntryControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_BastionControllerConfiguration_To_config_BastionControllerConfiguration(in *BastionControllerConfiguration, out *config.BastionControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_v1alpha1_BastionControllerConfiguration_To_config_BastionControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_BastionControllerConfiguration_To_config_BastionControllerConfiguration(in *BastionControllerConfiguration, out *config.BastionControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_BastionControllerConfiguration_To_config_BastionControllerConfiguration(in, out, s)
}

func autoConvert_config_BastionControllerConfiguration_To_v1alpha1_BastionControllerConfiguration(in *config.BastionControllerConfiguration, out *BastionControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_config_BastionControllerConfiguration_To_v1alpha1_BastionControllerConfiguration is an autogenerated conversion function.
func Convert_config_BastionControllerConfiguration_To_v1alpha1_BastionControllerConfiguration(in *config.BastionControllerConfiguration, out *BastionControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_BastionControllerConfiguration_To_v1alpha1_BastionControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ConditionThreshold_To_config_ConditionThreshold(in *ConditionThreshold, out *config.ConditionThreshold, s conversion.Scope) error {
	out.Type = in.Type
	out.Duration = in.Duration
	return nil
}

// Convert_v1alpha1_ConditionThreshold_To_config_ConditionThreshold is an autogenerated conversion function.
func Convert_v1alpha1_ConditionThreshold_To_config_ConditionThreshold(in *ConditionThreshold, out *config.ConditionThreshold, s conversion.Scope) error {
	return autoConvert_v1alpha1_ConditionThreshold_To_config_ConditionThreshold(in, out, s)
}

func autoConvert_config_ConditionThreshold_To_v1alpha1_ConditionThreshold(in *config.ConditionThreshold, out *ConditionThreshold, s conversion.Scope) error {
	out.Type = in.Type
	out.Duration = in.Duration
	return nil
}

// Convert_config_ConditionThreshold_To_v1alpha1_ConditionThreshold is an autogenerated conversion function.
func Convert_config_ConditionThreshold_To_v1alpha1_ConditionThreshold(in *config.ConditionThreshold, out *ConditionThreshold, s conversion.Scope) error {
	return autoConvert_config_ConditionThreshold_To_v1alpha1_ConditionThreshold(in, out, s)
}

func autoConvert_v1alpha1_ControllerInstallationCareControllerConfiguration_To_config_ControllerInstallationCareControllerConfiguration(in *ControllerInstallationCareControllerConfiguration, out *config.ControllerInstallationCareControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	return nil
}

// Convert_v1alpha1_ControllerInstallationCareControllerConfiguration_To_config_ControllerInstallationCareControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ControllerInstallationCareControllerConfiguration_To_config_ControllerInstallationCareControllerConfiguration(in *ControllerInstallationCareControllerConfiguration, out *config.ControllerInstallationCareControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerInstallationCareControllerConfiguration_To_config_ControllerInstallationCareControllerConfiguration(in, out, s)
}

func autoConvert_config_ControllerInstallationCareControllerConfiguration_To_v1alpha1_ControllerInstallationCareControllerConfiguration(in *config.ControllerInstallationCareControllerConfiguration, out *ControllerInstallationCareControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	return nil
}

// Convert_config_ControllerInstallationCareControllerConfiguration_To_v1alpha1_ControllerInstallationCareControllerConfiguration is an autogenerated conversion function.
func Convert_config_ControllerInstallationCareControllerConfiguration_To_v1alpha1_ControllerInstallationCareControllerConfiguration(in *config.ControllerInstallationCareControllerConfiguration, out *ControllerInstallationCareControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ControllerInstallationCareControllerConfiguration_To_v1alpha1_ControllerInstallationCareControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ControllerInstallationControllerConfiguration_To_config_ControllerInstallationControllerConfiguration(in *ControllerInstallationControllerConfiguration, out *config.ControllerInstallationControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_v1alpha1_ControllerInstallationControllerConfiguration_To_config_ControllerInstallationControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ControllerInstallationControllerConfiguration_To_config_ControllerInstallationControllerConfiguration(in *ControllerInstallationControllerConfiguration, out *config.ControllerInstallationControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerInstallationControllerConfiguration_To_config_ControllerInstallationControllerConfiguration(in, out, s)
}

func autoConvert_config_ControllerInstallationControllerConfiguration_To_v1alpha1_ControllerInstallationControllerConfiguration(in *config.ControllerInstallationControllerConfiguration, out *ControllerInstallationControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_config_ControllerInstallationControllerConfiguration_To_v1alpha1_ControllerInstallationControllerConfiguration is an autogenerated conversion function.
func Convert_config_ControllerInstallationControllerConfiguration_To_v1alpha1_ControllerInstallationControllerConfiguration(in *config.ControllerInstallationControllerConfiguration, out *ControllerInstallationControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ControllerInstallationControllerConfiguration_To_v1alpha1_ControllerInstallationControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ControllerInstallationRequiredControllerConfiguration_To_config_ControllerInstallationRequiredControllerConfiguration(in *ControllerInstallationRequiredControllerConfiguration, out *config.ControllerInstallationRequiredControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_v1alpha1_ControllerInstallationRequiredControllerConfiguration_To_config_ControllerInstallationRequiredControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ControllerInstallationRequiredControllerConfiguration_To_config_ControllerInstallationRequiredControllerConfiguration(in *ControllerInstallationRequiredControllerConfiguration, out *config.ControllerInstallationRequiredControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerInstallationRequiredControllerConfiguration_To_config_ControllerInstallationRequiredControllerConfiguration(in, out, s)
}

func autoConvert_config_ControllerInstallationRequiredControllerConfiguration_To_v1alpha1_ControllerInstallationRequiredControllerConfiguration(in *config.ControllerInstallationRequiredControllerConfiguration, out *ControllerInstallationRequiredControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_config_ControllerInstallationRequiredControllerConfiguration_To_v1alpha1_ControllerInstallationRequiredControllerConfiguration is an autogenerated conversion function.
func Convert_config_ControllerInstallationRequiredControllerConfiguration_To_v1alpha1_ControllerInstallationRequiredControllerConfiguration(in *config.ControllerInstallationRequiredControllerConfiguration, out *ControllerInstallationRequiredControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ControllerInstallationRequiredControllerConfiguration_To_v1alpha1_ControllerInstallationRequiredControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_CustodianController_To_config_CustodianController(in *CustodianController, out *config.CustodianController, s conversion.Scope) error {
	out.Workers = (*int64)(unsafe.Pointer(in.Workers))
	return nil
}

// Convert_v1alpha1_CustodianController_To_config_CustodianController is an autogenerated conversion function.
func Convert_v1alpha1_CustodianController_To_config_CustodianController(in *CustodianController, out *config.CustodianController, s conversion.Scope) error {
	return autoConvert_v1alpha1_CustodianController_To_config_CustodianController(in, out, s)
}

func autoConvert_config_CustodianController_To_v1alpha1_CustodianController(in *config.CustodianController, out *CustodianController, s conversion.Scope) error {
	out.Workers = (*int64)(unsafe.Pointer(in.Workers))
	return nil
}

// Convert_config_CustodianController_To_v1alpha1_CustodianController is an autogenerated conversion function.
func Convert_config_CustodianController_To_v1alpha1_CustodianController(in *config.CustodianController, out *CustodianController, s conversion.Scope) error {
	return autoConvert_config_CustodianController_To_v1alpha1_CustodianController(in, out, s)
}

func autoConvert_v1alpha1_ETCDConfig_To_config_ETCDConfig(in *ETCDConfig, out *config.ETCDConfig, s conversion.Scope) error {
	out.ETCDController = (*config.ETCDController)(unsafe.Pointer(in.ETCDController))
	out.CustodianController = (*config.CustodianController)(unsafe.Pointer(in.CustodianController))
	out.BackupCompactionController = (*config.BackupCompactionController)(unsafe.Pointer(in.BackupCompactionController))
	return nil
}

// Convert_v1alpha1_ETCDConfig_To_config_ETCDConfig is an autogenerated conversion function.
func Convert_v1alpha1_ETCDConfig_To_config_ETCDConfig(in *ETCDConfig, out *config.ETCDConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_ETCDConfig_To_config_ETCDConfig(in, out, s)
}

func autoConvert_config_ETCDConfig_To_v1alpha1_ETCDConfig(in *config.ETCDConfig, out *ETCDConfig, s conversion.Scope) error {
	out.ETCDController = (*ETCDController)(unsafe.Pointer(in.ETCDController))
	out.CustodianController = (*CustodianController)(unsafe.Pointer(in.CustodianController))
	out.BackupCompactionController = (*BackupCompactionController)(unsafe.Pointer(in.BackupCompactionController))
	return nil
}

// Convert_config_ETCDConfig_To_v1alpha1_ETCDConfig is an autogenerated conversion function.
func Convert_config_ETCDConfig_To_v1alpha1_ETCDConfig(in *config.ETCDConfig, out *ETCDConfig, s conversion.Scope) error {
	return autoConvert_config_ETCDConfig_To_v1alpha1_ETCDConfig(in, out, s)
}

func autoConvert_v1alpha1_ETCDController_To_config_ETCDController(in *ETCDController, out *config.ETCDController, s conversion.Scope) error {
	out.Workers = (*int64)(unsafe.Pointer(in.Workers))
	return nil
}

// Convert_v1alpha1_ETCDController_To_config_ETCDController is an autogenerated conversion function.
func Convert_v1alpha1_ETCDController_To_config_ETCDController(in *ETCDController, out *config.ETCDController, s conversion.Scope) error {
	return autoConvert_v1alpha1_ETCDController_To_config_ETCDController(in, out, s)
}

func autoConvert_config_ETCDController_To_v1alpha1_ETCDController(in *config.ETCDController, out *ETCDController, s conversion.Scope) error {
	out.Workers = (*int64)(unsafe.Pointer(in.Workers))
	return nil
}

// Convert_config_ETCDController_To_v1alpha1_ETCDController is an autogenerated conversion function.
func Convert_config_ETCDController_To_v1alpha1_ETCDController(in *config.ETCDController, out *ETCDController, s conversion.Scope) error {
	return autoConvert_config_ETCDController_To_v1alpha1_ETCDController(in, out, s)
}

func autoConvert_v1alpha1_ExposureClassHandler_To_config_ExposureClassHandler(in *ExposureClassHandler, out *config.ExposureClassHandler, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_v1alpha1_LoadBalancerServiceConfig_To_config_LoadBalancerServiceConfig(&in.LoadBalancerService, &out.LoadBalancerService, s); err != nil {
		return err
	}
	out.SNI = (*config.SNI)(unsafe.Pointer(in.SNI))
	return nil
}

// Convert_v1alpha1_ExposureClassHandler_To_config_ExposureClassHandler is an autogenerated conversion function.
func Convert_v1alpha1_ExposureClassHandler_To_config_ExposureClassHandler(in *ExposureClassHandler, out *config.ExposureClassHandler, s conversion.Scope) error {
	return autoConvert_v1alpha1_ExposureClassHandler_To_config_ExposureClassHandler(in, out, s)
}

func autoConvert_config_ExposureClassHandler_To_v1alpha1_ExposureClassHandler(in *config.ExposureClassHandler, out *ExposureClassHandler, s conversion.Scope) error {
	out.Name = in.Name
	if err := Convert_config_LoadBalancerServiceConfig_To_v1alpha1_LoadBalancerServiceConfig(&in.LoadBalancerService, &out.LoadBalancerService, s); err != nil {
		return err
	}
	out.SNI = (*SNI)(unsafe.Pointer(in.SNI))
	return nil
}

// Convert_config_ExposureClassHandler_To_v1alpha1_ExposureClassHandler is an autogenerated conversion function.
func Convert_config_ExposureClassHandler_To_v1alpha1_ExposureClassHandler(in *config.ExposureClassHandler, out *ExposureClassHandler, s conversion.Scope) error {
	return autoConvert_config_ExposureClassHandler_To_v1alpha1_ExposureClassHandler(in, out, s)
}

func autoConvert_v1alpha1_FluentBit_To_config_FluentBit(in *FluentBit, out *config.FluentBit, s conversion.Scope) error {
	out.ServiceSection = (*string)(unsafe.Pointer(in.ServiceSection))
	out.InputSection = (*string)(unsafe.Pointer(in.InputSection))
	out.OutputSection = (*string)(unsafe.Pointer(in.OutputSection))
	return nil
}

// Convert_v1alpha1_FluentBit_To_config_FluentBit is an autogenerated conversion function.
func Convert_v1alpha1_FluentBit_To_config_FluentBit(in *FluentBit, out *config.FluentBit, s conversion.Scope) error {
	return autoConvert_v1alpha1_FluentBit_To_config_FluentBit(in, out, s)
}

func autoConvert_config_FluentBit_To_v1alpha1_FluentBit(in *config.FluentBit, out *FluentBit, s conversion.Scope) error {
	out.ServiceSection = (*string)(unsafe.Pointer(in.ServiceSection))
	out.InputSection = (*string)(unsafe.Pointer(in.InputSection))
	out.OutputSection = (*string)(unsafe.Pointer(in.OutputSection))
	return nil
}

// Convert_config_FluentBit_To_v1alpha1_FluentBit is an autogenerated conversion function.
func Convert_config_FluentBit_To_v1alpha1_FluentBit(in *config.FluentBit, out *FluentBit, s conversion.Scope) error {
	return autoConvert_config_FluentBit_To_v1alpha1_FluentBit(in, out, s)
}

func autoConvert_v1alpha1_GardenClientConnection_To_config_GardenClientConnection(in *GardenClientConnection, out *config.GardenClientConnection, s conversion.Scope) error {
	if err := configv1alpha1.Convert_v1alpha1_ClientConnectionConfiguration_To_config_ClientConnectionConfiguration(&in.ClientConnectionConfiguration, &out.ClientConnectionConfiguration, s); err != nil {
		return err
	}
	out.GardenClusterAddress = (*string)(unsafe.Pointer(in.GardenClusterAddress))
	out.GardenClusterCACert = *(*[]byte)(unsafe.Pointer(&in.GardenClusterCACert))
	out.BootstrapKubeconfig = (*corev1.SecretReference)(unsafe.Pointer(in.BootstrapKubeconfig))
	out.KubeconfigSecret = (*corev1.SecretReference)(unsafe.Pointer(in.KubeconfigSecret))
	return nil
}

// Convert_v1alpha1_GardenClientConnection_To_config_GardenClientConnection is an autogenerated conversion function.
func Convert_v1alpha1_GardenClientConnection_To_config_GardenClientConnection(in *GardenClientConnection, out *config.GardenClientConnection, s conversion.Scope) error {
	return autoConvert_v1alpha1_GardenClientConnection_To_config_GardenClientConnection(in, out, s)
}

func autoConvert_config_GardenClientConnection_To_v1alpha1_GardenClientConnection(in *config.GardenClientConnection, out *GardenClientConnection, s conversion.Scope) error {
	if err := configv1alpha1.Convert_config_ClientConnectionConfiguration_To_v1alpha1_ClientConnectionConfiguration(&in.ClientConnectionConfiguration, &out.ClientConnectionConfiguration, s); err != nil {
		return err
	}
	out.GardenClusterAddress = (*string)(unsafe.Pointer(in.GardenClusterAddress))
	out.GardenClusterCACert = *(*[]byte)(unsafe.Pointer(&in.GardenClusterCACert))
	out.BootstrapKubeconfig = (*corev1.SecretReference)(unsafe.Pointer(in.BootstrapKubeconfig))
	out.KubeconfigSecret = (*corev1.SecretReference)(unsafe.Pointer(in.KubeconfigSecret))
	return nil
}

// Convert_config_GardenClientConnection_To_v1alpha1_GardenClientConnection is an autogenerated conversion function.
func Convert_config_GardenClientConnection_To_v1alpha1_GardenClientConnection(in *config.GardenClientConnection, out *GardenClientConnection, s conversion.Scope) error {
	return autoConvert_config_GardenClientConnection_To_v1alpha1_GardenClientConnection(in, out, s)
}

func autoConvert_v1alpha1_GardenLoki_To_config_GardenLoki(in *GardenLoki, out *config.GardenLoki, s conversion.Scope) error {
	if in.Priority != nil {
		in, out := &in.Priority, &out.Priority
		*out = new(int32)
		**out = int32(**in)
	} else {
		out.Priority = nil
	}
	return nil
}

// Convert_v1alpha1_GardenLoki_To_config_GardenLoki is an autogenerated conversion function.
func Convert_v1alpha1_GardenLoki_To_config_GardenLoki(in *GardenLoki, out *config.GardenLoki, s conversion.Scope) error {
	return autoConvert_v1alpha1_GardenLoki_To_config_GardenLoki(in, out, s)
}

func autoConvert_config_GardenLoki_To_v1alpha1_GardenLoki(in *config.GardenLoki, out *GardenLoki, s conversion.Scope) error {
	if in.Priority != nil {
		in, out := &in.Priority, &out.Priority
		*out = new(int)
		**out = int(**in)
	} else {
		out.Priority = nil
	}
	return nil
}

// Convert_config_GardenLoki_To_v1alpha1_GardenLoki is an autogenerated conversion function.
func Convert_config_GardenLoki_To_v1alpha1_GardenLoki(in *config.GardenLoki, out *GardenLoki, s conversion.Scope) error {
	return autoConvert_config_GardenLoki_To_v1alpha1_GardenLoki(in, out, s)
}

func autoConvert_v1alpha1_GardenletConfiguration_To_config_GardenletConfiguration(in *GardenletConfiguration, out *config.GardenletConfiguration, s conversion.Scope) error {
	if in.GardenClientConnection != nil {
		in, out := &in.GardenClientConnection, &out.GardenClientConnection
		*out = new(config.GardenClientConnection)
		if err := Convert_v1alpha1_GardenClientConnection_To_config_GardenClientConnection(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GardenClientConnection = nil
	}
	if in.SeedClientConnection != nil {
		in, out := &in.SeedClientConnection, &out.SeedClientConnection
		*out = new(config.SeedClientConnection)
		if err := Convert_v1alpha1_SeedClientConnection_To_config_SeedClientConnection(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SeedClientConnection = nil
	}
	if in.ShootClientConnection != nil {
		in, out := &in.ShootClientConnection, &out.ShootClientConnection
		*out = new(config.ShootClientConnection)
		if err := Convert_v1alpha1_ShootClientConnection_To_config_ShootClientConnection(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ShootClientConnection = nil
	}
	out.Controllers = (*config.GardenletControllerConfiguration)(unsafe.Pointer(in.Controllers))
	out.Resources = (*config.ResourcesConfiguration)(unsafe.Pointer(in.Resources))
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(componentbaseconfig.LeaderElectionConfiguration)
		if err := configv1alpha1.Convert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.LogLevel = (*string)(unsafe.Pointer(in.LogLevel))
	out.LogFormat = (*string)(unsafe.Pointer(in.LogFormat))
	out.KubernetesLogLevel = (*klog.Level)(unsafe.Pointer(in.KubernetesLogLevel))
	out.Server = (*config.ServerConfiguration)(unsafe.Pointer(in.Server))
	if in.Debugging != nil {
		in, out := &in.Debugging, &out.Debugging
		*out = new(componentbaseconfig.DebuggingConfiguration)
		if err := configv1alpha1.Convert_v1alpha1_DebuggingConfiguration_To_config_DebuggingConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Debugging = nil
	}
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	if in.SeedConfig != nil {
		in, out := &in.SeedConfig, &out.SeedConfig
		*out = new(config.SeedConfig)
		if err := Convert_v1alpha1_SeedConfig_To_config_SeedConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SeedConfig = nil
	}
	if in.Logging != nil {
		in, out := &in.Logging, &out.Logging
		*out = new(config.Logging)
		if err := Convert_v1alpha1_Logging_To_config_Logging(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Logging = nil
	}
	out.SNI = (*config.SNI)(unsafe.Pointer(in.SNI))
	out.ETCDConfig = (*config.ETCDConfig)(unsafe.Pointer(in.ETCDConfig))
	out.ExposureClassHandlers = *(*[]config.ExposureClassHandler)(unsafe.Pointer(&in.ExposureClassHandlers))
	out.Monitoring = (*config.MonitoringConfig)(unsafe.Pointer(in.Monitoring))
	return nil
}

// Convert_v1alpha1_GardenletConfiguration_To_config_GardenletConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_GardenletConfiguration_To_config_GardenletConfiguration(in *GardenletConfiguration, out *config.GardenletConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_GardenletConfiguration_To_config_GardenletConfiguration(in, out, s)
}

func autoConvert_config_GardenletConfiguration_To_v1alpha1_GardenletConfiguration(in *config.GardenletConfiguration, out *GardenletConfiguration, s conversion.Scope) error {
	if in.GardenClientConnection != nil {
		in, out := &in.GardenClientConnection, &out.GardenClientConnection
		*out = new(GardenClientConnection)
		if err := Convert_config_GardenClientConnection_To_v1alpha1_GardenClientConnection(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GardenClientConnection = nil
	}
	if in.SeedClientConnection != nil {
		in, out := &in.SeedClientConnection, &out.SeedClientConnection
		*out = new(SeedClientConnection)
		if err := Convert_config_SeedClientConnection_To_v1alpha1_SeedClientConnection(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SeedClientConnection = nil
	}
	if in.ShootClientConnection != nil {
		in, out := &in.ShootClientConnection, &out.ShootClientConnection
		*out = new(ShootClientConnection)
		if err := Convert_config_ShootClientConnection_To_v1alpha1_ShootClientConnection(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ShootClientConnection = nil
	}
	out.Controllers = (*GardenletControllerConfiguration)(unsafe.Pointer(in.Controllers))
	out.Resources = (*ResourcesConfiguration)(unsafe.Pointer(in.Resources))
	if in.LeaderElection != nil {
		in, out := &in.LeaderElection, &out.LeaderElection
		*out = new(configv1alpha1.LeaderElectionConfiguration)
		if err := configv1alpha1.Convert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.LeaderElection = nil
	}
	out.LogLevel = (*string)(unsafe.Pointer(in.LogLevel))
	out.LogFormat = (*string)(unsafe.Pointer(in.LogFormat))
	out.KubernetesLogLevel = (*klog.Level)(unsafe.Pointer(in.KubernetesLogLevel))
	out.Server = (*ServerConfiguration)(unsafe.Pointer(in.Server))
	if in.Debugging != nil {
		in, out := &in.Debugging, &out.Debugging
		*out = new(configv1alpha1.DebuggingConfiguration)
		if err := configv1alpha1.Convert_config_DebuggingConfiguration_To_v1alpha1_DebuggingConfiguration(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Debugging = nil
	}
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	if in.SeedConfig != nil {
		in, out := &in.SeedConfig, &out.SeedConfig
		*out = new(SeedConfig)
		if err := Convert_config_SeedConfig_To_v1alpha1_SeedConfig(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SeedConfig = nil
	}
	if in.Logging != nil {
		in, out := &in.Logging, &out.Logging
		*out = new(Logging)
		if err := Convert_config_Logging_To_v1alpha1_Logging(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Logging = nil
	}
	out.SNI = (*SNI)(unsafe.Pointer(in.SNI))
	out.ETCDConfig = (*ETCDConfig)(unsafe.Pointer(in.ETCDConfig))
	out.ExposureClassHandlers = *(*[]ExposureClassHandler)(unsafe.Pointer(&in.ExposureClassHandlers))
	out.Monitoring = (*MonitoringConfig)(unsafe.Pointer(in.Monitoring))
	return nil
}

// Convert_config_GardenletConfiguration_To_v1alpha1_GardenletConfiguration is an autogenerated conversion function.
func Convert_config_GardenletConfiguration_To_v1alpha1_GardenletConfiguration(in *config.GardenletConfiguration, out *GardenletConfiguration, s conversion.Scope) error {
	return autoConvert_config_GardenletConfiguration_To_v1alpha1_GardenletConfiguration(in, out, s)
}

func autoConvert_v1alpha1_GardenletControllerConfiguration_To_config_GardenletControllerConfiguration(in *GardenletControllerConfiguration, out *config.GardenletControllerConfiguration, s conversion.Scope) error {
	out.BackupBucket = (*config.BackupBucketControllerConfiguration)(unsafe.Pointer(in.BackupBucket))
	out.BackupEntry = (*config.BackupEntryControllerConfiguration)(unsafe.Pointer(in.BackupEntry))
	out.Bastion = (*config.BastionControllerConfiguration)(unsafe.Pointer(in.Bastion))
	out.ControllerInstallation = (*config.ControllerInstallationControllerConfiguration)(unsafe.Pointer(in.ControllerInstallation))
	out.ControllerInstallationCare = (*config.ControllerInstallationCareControllerConfiguration)(unsafe.Pointer(in.ControllerInstallationCare))
	out.ControllerInstallationRequired = (*config.ControllerInstallationRequiredControllerConfiguration)(unsafe.Pointer(in.ControllerInstallationRequired))
	out.Seed = (*config.SeedControllerConfiguration)(unsafe.Pointer(in.Seed))
	out.Shoot = (*config.ShootControllerConfiguration)(unsafe.Pointer(in.Shoot))
	out.ShootCare = (*config.ShootCareControllerConfiguration)(unsafe.Pointer(in.ShootCare))
	out.ShootStateSync = (*config.ShootStateSyncControllerConfiguration)(unsafe.Pointer(in.ShootStateSync))
	out.SeedAPIServerNetworkPolicy = (*config.SeedAPIServerNetworkPolicyControllerConfiguration)(unsafe.Pointer(in.SeedAPIServerNetworkPolicy))
	out.ManagedSeed = (*config.ManagedSeedControllerConfiguration)(unsafe.Pointer(in.ManagedSeed))
	return nil
}

// Convert_v1alpha1_GardenletControllerConfiguration_To_config_GardenletControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_GardenletControllerConfiguration_To_config_GardenletControllerConfiguration(in *GardenletControllerConfiguration, out *config.GardenletControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_GardenletControllerConfiguration_To_config_GardenletControllerConfiguration(in, out, s)
}

func autoConvert_config_GardenletControllerConfiguration_To_v1alpha1_GardenletControllerConfiguration(in *config.GardenletControllerConfiguration, out *GardenletControllerConfiguration, s conversion.Scope) error {
	out.BackupBucket = (*BackupBucketControllerConfiguration)(unsafe.Pointer(in.BackupBucket))
	out.BackupEntry = (*BackupEntryControllerConfiguration)(unsafe.Pointer(in.BackupEntry))
	out.Bastion = (*BastionControllerConfiguration)(unsafe.Pointer(in.Bastion))
	out.ControllerInstallation = (*ControllerInstallationControllerConfiguration)(unsafe.Pointer(in.ControllerInstallation))
	out.ControllerInstallationCare = (*ControllerInstallationCareControllerConfiguration)(unsafe.Pointer(in.ControllerInstallationCare))
	out.ControllerInstallationRequired = (*ControllerInstallationRequiredControllerConfiguration)(unsafe.Pointer(in.ControllerInstallationRequired))
	out.Seed = (*SeedControllerConfiguration)(unsafe.Pointer(in.Seed))
	out.Shoot = (*ShootControllerConfiguration)(unsafe.Pointer(in.Shoot))
	out.ShootCare = (*ShootCareControllerConfiguration)(unsafe.Pointer(in.ShootCare))
	out.ShootStateSync = (*ShootStateSyncControllerConfiguration)(unsafe.Pointer(in.ShootStateSync))
	out.SeedAPIServerNetworkPolicy = (*SeedAPIServerNetworkPolicyControllerConfiguration)(unsafe.Pointer(in.SeedAPIServerNetworkPolicy))
	out.ManagedSeed = (*ManagedSeedControllerConfiguration)(unsafe.Pointer(in.ManagedSeed))
	return nil
}

// Convert_config_GardenletControllerConfiguration_To_v1alpha1_GardenletControllerConfiguration is an autogenerated conversion function.
func Convert_config_GardenletControllerConfiguration_To_v1alpha1_GardenletControllerConfiguration(in *config.GardenletControllerConfiguration, out *GardenletControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_GardenletControllerConfiguration_To_v1alpha1_GardenletControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_HTTPSServer_To_config_HTTPSServer(in *HTTPSServer, out *config.HTTPSServer, s conversion.Scope) error {
	if err := Convert_v1alpha1_Server_To_config_Server(&in.Server, &out.Server, s); err != nil {
		return err
	}
	out.TLS = (*config.TLSServer)(unsafe.Pointer(in.TLS))
	return nil
}

// Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer is an autogenerated conversion function.
func Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer(in *HTTPSServer, out *config.HTTPSServer, s conversion.Scope) error {
	return autoConvert_v1alpha1_HTTPSServer_To_config_HTTPSServer(in, out, s)
}

func autoConvert_config_HTTPSServer_To_v1alpha1_HTTPSServer(in *config.HTTPSServer, out *HTTPSServer, s conversion.Scope) error {
	if err := Convert_config_Server_To_v1alpha1_Server(&in.Server, &out.Server, s); err != nil {
		return err
	}
	out.TLS = (*TLSServer)(unsafe.Pointer(in.TLS))
	return nil
}

// Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer is an autogenerated conversion function.
func Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer(in *config.HTTPSServer, out *HTTPSServer, s conversion.Scope) error {
	return autoConvert_config_HTTPSServer_To_v1alpha1_HTTPSServer(in, out, s)
}

func autoConvert_v1alpha1_LoadBalancerServiceConfig_To_config_LoadBalancerServiceConfig(in *LoadBalancerServiceConfig, out *config.LoadBalancerServiceConfig, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	return nil
}

// Convert_v1alpha1_LoadBalancerServiceConfig_To_config_LoadBalancerServiceConfig is an autogenerated conversion function.
func Convert_v1alpha1_LoadBalancerServiceConfig_To_config_LoadBalancerServiceConfig(in *LoadBalancerServiceConfig, out *config.LoadBalancerServiceConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_LoadBalancerServiceConfig_To_config_LoadBalancerServiceConfig(in, out, s)
}

func autoConvert_config_LoadBalancerServiceConfig_To_v1alpha1_LoadBalancerServiceConfig(in *config.LoadBalancerServiceConfig, out *LoadBalancerServiceConfig, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	return nil
}

// Convert_config_LoadBalancerServiceConfig_To_v1alpha1_LoadBalancerServiceConfig is an autogenerated conversion function.
func Convert_config_LoadBalancerServiceConfig_To_v1alpha1_LoadBalancerServiceConfig(in *config.LoadBalancerServiceConfig, out *LoadBalancerServiceConfig, s conversion.Scope) error {
	return autoConvert_config_LoadBalancerServiceConfig_To_v1alpha1_LoadBalancerServiceConfig(in, out, s)
}

func autoConvert_v1alpha1_Logging_To_config_Logging(in *Logging, out *config.Logging, s conversion.Scope) error {
	out.FluentBit = (*config.FluentBit)(unsafe.Pointer(in.FluentBit))
	if in.Loki != nil {
		in, out := &in.Loki, &out.Loki
		*out = new(config.Loki)
		if err := Convert_v1alpha1_Loki_To_config_Loki(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Loki = nil
	}
	out.ShootNodeLogging = (*config.ShootNodeLogging)(unsafe.Pointer(in.ShootNodeLogging))
	return nil
}

// Convert_v1alpha1_Logging_To_config_Logging is an autogenerated conversion function.
func Convert_v1alpha1_Logging_To_config_Logging(in *Logging, out *config.Logging, s conversion.Scope) error {
	return autoConvert_v1alpha1_Logging_To_config_Logging(in, out, s)
}

func autoConvert_config_Logging_To_v1alpha1_Logging(in *config.Logging, out *Logging, s conversion.Scope) error {
	out.FluentBit = (*FluentBit)(unsafe.Pointer(in.FluentBit))
	if in.Loki != nil {
		in, out := &in.Loki, &out.Loki
		*out = new(Loki)
		if err := Convert_config_Loki_To_v1alpha1_Loki(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Loki = nil
	}
	out.ShootNodeLogging = (*ShootNodeLogging)(unsafe.Pointer(in.ShootNodeLogging))
	return nil
}

// Convert_config_Logging_To_v1alpha1_Logging is an autogenerated conversion function.
func Convert_config_Logging_To_v1alpha1_Logging(in *config.Logging, out *Logging, s conversion.Scope) error {
	return autoConvert_config_Logging_To_v1alpha1_Logging(in, out, s)
}

func autoConvert_v1alpha1_Loki_To_config_Loki(in *Loki, out *config.Loki, s conversion.Scope) error {
	out.Enabled = (*bool)(unsafe.Pointer(in.Enabled))
	if in.Garden != nil {
		in, out := &in.Garden, &out.Garden
		*out = new(config.GardenLoki)
		if err := Convert_v1alpha1_GardenLoki_To_config_GardenLoki(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Garden = nil
	}
	return nil
}

// Convert_v1alpha1_Loki_To_config_Loki is an autogenerated conversion function.
func Convert_v1alpha1_Loki_To_config_Loki(in *Loki, out *config.Loki, s conversion.Scope) error {
	return autoConvert_v1alpha1_Loki_To_config_Loki(in, out, s)
}

func autoConvert_config_Loki_To_v1alpha1_Loki(in *config.Loki, out *Loki, s conversion.Scope) error {
	out.Enabled = (*bool)(unsafe.Pointer(in.Enabled))
	if in.Garden != nil {
		in, out := &in.Garden, &out.Garden
		*out = new(GardenLoki)
		if err := Convert_config_GardenLoki_To_v1alpha1_GardenLoki(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Garden = nil
	}
	return nil
}

// Convert_config_Loki_To_v1alpha1_Loki is an autogenerated conversion function.
func Convert_config_Loki_To_v1alpha1_Loki(in *config.Loki, out *Loki, s conversion.Scope) error {
	return autoConvert_config_Loki_To_v1alpha1_Loki(in, out, s)
}

func autoConvert_v1alpha1_ManagedSeedControllerConfiguration_To_config_ManagedSeedControllerConfiguration(in *ManagedSeedControllerConfiguration, out *config.ManagedSeedControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.WaitSyncPeriod = (*v1.Duration)(unsafe.Pointer(in.WaitSyncPeriod))
	out.SyncJitterPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncJitterPeriod))
	return nil
}

// Convert_v1alpha1_ManagedSeedControllerConfiguration_To_config_ManagedSeedControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ManagedSeedControllerConfiguration_To_config_ManagedSeedControllerConfiguration(in *ManagedSeedControllerConfiguration, out *config.ManagedSeedControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ManagedSeedControllerConfiguration_To_config_ManagedSeedControllerConfiguration(in, out, s)
}

func autoConvert_config_ManagedSeedControllerConfiguration_To_v1alpha1_ManagedSeedControllerConfiguration(in *config.ManagedSeedControllerConfiguration, out *ManagedSeedControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.WaitSyncPeriod = (*v1.Duration)(unsafe.Pointer(in.WaitSyncPeriod))
	out.SyncJitterPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncJitterPeriod))
	return nil
}

// Convert_config_ManagedSeedControllerConfiguration_To_v1alpha1_ManagedSeedControllerConfiguration is an autogenerated conversion function.
func Convert_config_ManagedSeedControllerConfiguration_To_v1alpha1_ManagedSeedControllerConfiguration(in *config.ManagedSeedControllerConfiguration, out *ManagedSeedControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ManagedSeedControllerConfiguration_To_v1alpha1_ManagedSeedControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_MonitoringConfig_To_config_MonitoringConfig(in *MonitoringConfig, out *config.MonitoringConfig, s conversion.Scope) error {
	out.Shoot = (*config.ShootMonitoringConfig)(unsafe.Pointer(in.Shoot))
	return nil
}

// Convert_v1alpha1_MonitoringConfig_To_config_MonitoringConfig is an autogenerated conversion function.
func Convert_v1alpha1_MonitoringConfig_To_config_MonitoringConfig(in *MonitoringConfig, out *config.MonitoringConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_MonitoringConfig_To_config_MonitoringConfig(in, out, s)
}

func autoConvert_config_MonitoringConfig_To_v1alpha1_MonitoringConfig(in *config.MonitoringConfig, out *MonitoringConfig, s conversion.Scope) error {
	out.Shoot = (*ShootMonitoringConfig)(unsafe.Pointer(in.Shoot))
	return nil
}

// Convert_config_MonitoringConfig_To_v1alpha1_MonitoringConfig is an autogenerated conversion function.
func Convert_config_MonitoringConfig_To_v1alpha1_MonitoringConfig(in *config.MonitoringConfig, out *MonitoringConfig, s conversion.Scope) error {
	return autoConvert_config_MonitoringConfig_To_v1alpha1_MonitoringConfig(in, out, s)
}

func autoConvert_v1alpha1_RemoteWriteMonitoringConfig_To_config_RemoteWriteMonitoringConfig(in *RemoteWriteMonitoringConfig, out *config.RemoteWriteMonitoringConfig, s conversion.Scope) error {
	out.URL = in.URL
	out.Keep = *(*[]string)(unsafe.Pointer(&in.Keep))
	out.QueueConfig = (*string)(unsafe.Pointer(in.QueueConfig))
	return nil
}

// Convert_v1alpha1_RemoteWriteMonitoringConfig_To_config_RemoteWriteMonitoringConfig is an autogenerated conversion function.
func Convert_v1alpha1_RemoteWriteMonitoringConfig_To_config_RemoteWriteMonitoringConfig(in *RemoteWriteMonitoringConfig, out *config.RemoteWriteMonitoringConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_RemoteWriteMonitoringConfig_To_config_RemoteWriteMonitoringConfig(in, out, s)
}

func autoConvert_config_RemoteWriteMonitoringConfig_To_v1alpha1_RemoteWriteMonitoringConfig(in *config.RemoteWriteMonitoringConfig, out *RemoteWriteMonitoringConfig, s conversion.Scope) error {
	out.URL = in.URL
	out.Keep = *(*[]string)(unsafe.Pointer(&in.Keep))
	out.QueueConfig = (*string)(unsafe.Pointer(in.QueueConfig))
	return nil
}

// Convert_config_RemoteWriteMonitoringConfig_To_v1alpha1_RemoteWriteMonitoringConfig is an autogenerated conversion function.
func Convert_config_RemoteWriteMonitoringConfig_To_v1alpha1_RemoteWriteMonitoringConfig(in *config.RemoteWriteMonitoringConfig, out *RemoteWriteMonitoringConfig, s conversion.Scope) error {
	return autoConvert_config_RemoteWriteMonitoringConfig_To_v1alpha1_RemoteWriteMonitoringConfig(in, out, s)
}

func autoConvert_v1alpha1_ResourcesConfiguration_To_config_ResourcesConfiguration(in *ResourcesConfiguration, out *config.ResourcesConfiguration, s conversion.Scope) error {
	out.Capacity = *(*corev1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Reserved = *(*corev1.ResourceList)(unsafe.Pointer(&in.Reserved))
	return nil
}

// Convert_v1alpha1_ResourcesConfiguration_To_config_ResourcesConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ResourcesConfiguration_To_config_ResourcesConfiguration(in *ResourcesConfiguration, out *config.ResourcesConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourcesConfiguration_To_config_ResourcesConfiguration(in, out, s)
}

func autoConvert_config_ResourcesConfiguration_To_v1alpha1_ResourcesConfiguration(in *config.ResourcesConfiguration, out *ResourcesConfiguration, s conversion.Scope) error {
	out.Capacity = *(*corev1.ResourceList)(unsafe.Pointer(&in.Capacity))
	out.Reserved = *(*corev1.ResourceList)(unsafe.Pointer(&in.Reserved))
	return nil
}

// Convert_config_ResourcesConfiguration_To_v1alpha1_ResourcesConfiguration is an autogenerated conversion function.
func Convert_config_ResourcesConfiguration_To_v1alpha1_ResourcesConfiguration(in *config.ResourcesConfiguration, out *ResourcesConfiguration, s conversion.Scope) error {
	return autoConvert_config_ResourcesConfiguration_To_v1alpha1_ResourcesConfiguration(in, out, s)
}

func autoConvert_v1alpha1_SNI_To_config_SNI(in *SNI, out *config.SNI, s conversion.Scope) error {
	out.Ingress = (*config.SNIIngress)(unsafe.Pointer(in.Ingress))
	return nil
}

// Convert_v1alpha1_SNI_To_config_SNI is an autogenerated conversion function.
func Convert_v1alpha1_SNI_To_config_SNI(in *SNI, out *config.SNI, s conversion.Scope) error {
	return autoConvert_v1alpha1_SNI_To_config_SNI(in, out, s)
}

func autoConvert_config_SNI_To_v1alpha1_SNI(in *config.SNI, out *SNI, s conversion.Scope) error {
	out.Ingress = (*SNIIngress)(unsafe.Pointer(in.Ingress))
	return nil
}

// Convert_config_SNI_To_v1alpha1_SNI is an autogenerated conversion function.
func Convert_config_SNI_To_v1alpha1_SNI(in *config.SNI, out *SNI, s conversion.Scope) error {
	return autoConvert_config_SNI_To_v1alpha1_SNI(in, out, s)
}

func autoConvert_v1alpha1_SNIIngress_To_config_SNIIngress(in *SNIIngress, out *config.SNIIngress, s conversion.Scope) error {
	out.ServiceName = (*string)(unsafe.Pointer(in.ServiceName))
	out.ServiceExternalIP = (*string)(unsafe.Pointer(in.ServiceExternalIP))
	out.Namespace = (*string)(unsafe.Pointer(in.Namespace))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1alpha1_SNIIngress_To_config_SNIIngress is an autogenerated conversion function.
func Convert_v1alpha1_SNIIngress_To_config_SNIIngress(in *SNIIngress, out *config.SNIIngress, s conversion.Scope) error {
	return autoConvert_v1alpha1_SNIIngress_To_config_SNIIngress(in, out, s)
}

func autoConvert_config_SNIIngress_To_v1alpha1_SNIIngress(in *config.SNIIngress, out *SNIIngress, s conversion.Scope) error {
	out.ServiceName = (*string)(unsafe.Pointer(in.ServiceName))
	out.ServiceExternalIP = (*string)(unsafe.Pointer(in.ServiceExternalIP))
	out.Namespace = (*string)(unsafe.Pointer(in.Namespace))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_config_SNIIngress_To_v1alpha1_SNIIngress is an autogenerated conversion function.
func Convert_config_SNIIngress_To_v1alpha1_SNIIngress(in *config.SNIIngress, out *SNIIngress, s conversion.Scope) error {
	return autoConvert_config_SNIIngress_To_v1alpha1_SNIIngress(in, out, s)
}

func autoConvert_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration_To_config_SeedAPIServerNetworkPolicyControllerConfiguration(in *SeedAPIServerNetworkPolicyControllerConfiguration, out *config.SeedAPIServerNetworkPolicyControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration_To_config_SeedAPIServerNetworkPolicyControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration_To_config_SeedAPIServerNetworkPolicyControllerConfiguration(in *SeedAPIServerNetworkPolicyControllerConfiguration, out *config.SeedAPIServerNetworkPolicyControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration_To_config_SeedAPIServerNetworkPolicyControllerConfiguration(in, out, s)
}

func autoConvert_config_SeedAPIServerNetworkPolicyControllerConfiguration_To_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration(in *config.SeedAPIServerNetworkPolicyControllerConfiguration, out *SeedAPIServerNetworkPolicyControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	return nil
}

// Convert_config_SeedAPIServerNetworkPolicyControllerConfiguration_To_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration is an autogenerated conversion function.
func Convert_config_SeedAPIServerNetworkPolicyControllerConfiguration_To_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration(in *config.SeedAPIServerNetworkPolicyControllerConfiguration, out *SeedAPIServerNetworkPolicyControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_SeedAPIServerNetworkPolicyControllerConfiguration_To_v1alpha1_SeedAPIServerNetworkPolicyControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_SeedClientConnection_To_config_SeedClientConnection(in *SeedClientConnection, out *config.SeedClientConnection, s conversion.Scope) error {
	if err := configv1alpha1.Convert_v1alpha1_ClientConnectionConfiguration_To_config_ClientConnectionConfiguration(&in.ClientConnectionConfiguration, &out.ClientConnectionConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_SeedClientConnection_To_config_SeedClientConnection is an autogenerated conversion function.
func Convert_v1alpha1_SeedClientConnection_To_config_SeedClientConnection(in *SeedClientConnection, out *config.SeedClientConnection, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedClientConnection_To_config_SeedClientConnection(in, out, s)
}

func autoConvert_config_SeedClientConnection_To_v1alpha1_SeedClientConnection(in *config.SeedClientConnection, out *SeedClientConnection, s conversion.Scope) error {
	if err := configv1alpha1.Convert_config_ClientConnectionConfiguration_To_v1alpha1_ClientConnectionConfiguration(&in.ClientConnectionConfiguration, &out.ClientConnectionConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_config_SeedClientConnection_To_v1alpha1_SeedClientConnection is an autogenerated conversion function.
func Convert_config_SeedClientConnection_To_v1alpha1_SeedClientConnection(in *config.SeedClientConnection, out *SeedClientConnection, s conversion.Scope) error {
	return autoConvert_config_SeedClientConnection_To_v1alpha1_SeedClientConnection(in, out, s)
}

func autoConvert_v1alpha1_SeedConfig_To_config_SeedConfig(in *SeedConfig, out *config.SeedConfig, s conversion.Scope) error {
	if err := Convert_v1beta1_SeedTemplate_To_core_SeedTemplate(&in.SeedTemplate, &out.SeedTemplate, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_SeedConfig_To_config_SeedConfig is an autogenerated conversion function.
func Convert_v1alpha1_SeedConfig_To_config_SeedConfig(in *SeedConfig, out *config.SeedConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedConfig_To_config_SeedConfig(in, out, s)
}

func autoConvert_config_SeedConfig_To_v1alpha1_SeedConfig(in *config.SeedConfig, out *SeedConfig, s conversion.Scope) error {
	if err := Convert_core_SeedTemplate_To_v1beta1_SeedTemplate(&in.SeedTemplate, &out.SeedTemplate, s); err != nil {
		return err
	}
	return nil
}

// Convert_config_SeedConfig_To_v1alpha1_SeedConfig is an autogenerated conversion function.
func Convert_config_SeedConfig_To_v1alpha1_SeedConfig(in *config.SeedConfig, out *SeedConfig, s conversion.Scope) error {
	return autoConvert_config_SeedConfig_To_v1alpha1_SeedConfig(in, out, s)
}

func autoConvert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(in *SeedControllerConfiguration, out *config.SeedControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	return nil
}

// Convert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(in *SeedControllerConfiguration, out *config.SeedControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(in, out, s)
}

func autoConvert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(in *config.SeedControllerConfiguration, out *SeedControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	return nil
}

// Convert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration is an autogenerated conversion function.
func Convert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(in *config.SeedControllerConfiguration, out *SeedControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_Server_To_config_Server(in *Server, out *config.Server, s conversion.Scope) error {
	out.BindAddress = in.BindAddress
	out.Port = in.Port
	return nil
}

// Convert_v1alpha1_Server_To_config_Server is an autogenerated conversion function.
func Convert_v1alpha1_Server_To_config_Server(in *Server, out *config.Server, s conversion.Scope) error {
	return autoConvert_v1alpha1_Server_To_config_Server(in, out, s)
}

func autoConvert_config_Server_To_v1alpha1_Server(in *config.Server, out *Server, s conversion.Scope) error {
	out.BindAddress = in.BindAddress
	out.Port = in.Port
	return nil
}

// Convert_config_Server_To_v1alpha1_Server is an autogenerated conversion function.
func Convert_config_Server_To_v1alpha1_Server(in *config.Server, out *Server, s conversion.Scope) error {
	return autoConvert_config_Server_To_v1alpha1_Server(in, out, s)
}

func autoConvert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(in *ServerConfiguration, out *config.ServerConfiguration, s conversion.Scope) error {
	if err := Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer(&in.HTTPS, &out.HTTPS, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(in *ServerConfiguration, out *config.ServerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(in, out, s)
}

func autoConvert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(in *config.ServerConfiguration, out *ServerConfiguration, s conversion.Scope) error {
	if err := Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer(&in.HTTPS, &out.HTTPS, s); err != nil {
		return err
	}
	return nil
}

// Convert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration is an autogenerated conversion function.
func Convert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(in *config.ServerConfiguration, out *ServerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ShootCareControllerConfiguration_To_config_ShootCareControllerConfiguration(in *ShootCareControllerConfiguration, out *config.ShootCareControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.StaleExtensionHealthChecks = (*config.StaleExtensionHealthChecks)(unsafe.Pointer(in.StaleExtensionHealthChecks))
	out.ConditionThresholds = *(*[]config.ConditionThreshold)(unsafe.Pointer(&in.ConditionThresholds))
	return nil
}

// Convert_v1alpha1_ShootCareControllerConfiguration_To_config_ShootCareControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ShootCareControllerConfiguration_To_config_ShootCareControllerConfiguration(in *ShootCareControllerConfiguration, out *config.ShootCareControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootCareControllerConfiguration_To_config_ShootCareControllerConfiguration(in, out, s)
}

func autoConvert_config_ShootCareControllerConfiguration_To_v1alpha1_ShootCareControllerConfiguration(in *config.ShootCareControllerConfiguration, out *ShootCareControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.StaleExtensionHealthChecks = (*StaleExtensionHealthChecks)(unsafe.Pointer(in.StaleExtensionHealthChecks))
	out.ConditionThresholds = *(*[]ConditionThreshold)(unsafe.Pointer(&in.ConditionThresholds))
	return nil
}

// Convert_config_ShootCareControllerConfiguration_To_v1alpha1_ShootCareControllerConfiguration is an autogenerated conversion function.
func Convert_config_ShootCareControllerConfiguration_To_v1alpha1_ShootCareControllerConfiguration(in *config.ShootCareControllerConfiguration, out *ShootCareControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ShootCareControllerConfiguration_To_v1alpha1_ShootCareControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ShootClientConnection_To_config_ShootClientConnection(in *ShootClientConnection, out *config.ShootClientConnection, s conversion.Scope) error {
	if err := configv1alpha1.Convert_v1alpha1_ClientConnectionConfiguration_To_config_ClientConnectionConfiguration(&in.ClientConnectionConfiguration, &out.ClientConnectionConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ShootClientConnection_To_config_ShootClientConnection is an autogenerated conversion function.
func Convert_v1alpha1_ShootClientConnection_To_config_ShootClientConnection(in *ShootClientConnection, out *config.ShootClientConnection, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootClientConnection_To_config_ShootClientConnection(in, out, s)
}

func autoConvert_config_ShootClientConnection_To_v1alpha1_ShootClientConnection(in *config.ShootClientConnection, out *ShootClientConnection, s conversion.Scope) error {
	if err := configv1alpha1.Convert_config_ClientConnectionConfiguration_To_v1alpha1_ClientConnectionConfiguration(&in.ClientConnectionConfiguration, &out.ClientConnectionConfiguration, s); err != nil {
		return err
	}
	return nil
}

// Convert_config_ShootClientConnection_To_v1alpha1_ShootClientConnection is an autogenerated conversion function.
func Convert_config_ShootClientConnection_To_v1alpha1_ShootClientConnection(in *config.ShootClientConnection, out *ShootClientConnection, s conversion.Scope) error {
	return autoConvert_config_ShootClientConnection_To_v1alpha1_ShootClientConnection(in, out, s)
}

func autoConvert_v1alpha1_ShootControllerConfiguration_To_config_ShootControllerConfiguration(in *ShootControllerConfiguration, out *config.ShootControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.ProgressReportPeriod = (*v1.Duration)(unsafe.Pointer(in.ProgressReportPeriod))
	out.ReconcileInMaintenanceOnly = (*bool)(unsafe.Pointer(in.ReconcileInMaintenanceOnly))
	out.RespectSyncPeriodOverwrite = (*bool)(unsafe.Pointer(in.RespectSyncPeriodOverwrite))
	out.RetryDuration = (*v1.Duration)(unsafe.Pointer(in.RetryDuration))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.DNSEntryTTLSeconds = (*int64)(unsafe.Pointer(in.DNSEntryTTLSeconds))
	return nil
}

// Convert_v1alpha1_ShootControllerConfiguration_To_config_ShootControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ShootControllerConfiguration_To_config_ShootControllerConfiguration(in *ShootControllerConfiguration, out *config.ShootControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootControllerConfiguration_To_config_ShootControllerConfiguration(in, out, s)
}

func autoConvert_config_ShootControllerConfiguration_To_v1alpha1_ShootControllerConfiguration(in *config.ShootControllerConfiguration, out *ShootControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.ProgressReportPeriod = (*v1.Duration)(unsafe.Pointer(in.ProgressReportPeriod))
	out.ReconcileInMaintenanceOnly = (*bool)(unsafe.Pointer(in.ReconcileInMaintenanceOnly))
	out.RespectSyncPeriodOverwrite = (*bool)(unsafe.Pointer(in.RespectSyncPeriodOverwrite))
	out.RetryDuration = (*v1.Duration)(unsafe.Pointer(in.RetryDuration))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	out.DNSEntryTTLSeconds = (*int64)(unsafe.Pointer(in.DNSEntryTTLSeconds))
	return nil
}

// Convert_config_ShootControllerConfiguration_To_v1alpha1_ShootControllerConfiguration is an autogenerated conversion function.
func Convert_config_ShootControllerConfiguration_To_v1alpha1_ShootControllerConfiguration(in *config.ShootControllerConfiguration, out *ShootControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ShootControllerConfiguration_To_v1alpha1_ShootControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ShootMonitoringConfig_To_config_ShootMonitoringConfig(in *ShootMonitoringConfig, out *config.ShootMonitoringConfig, s conversion.Scope) error {
	out.RemoteWrite = (*config.RemoteWriteMonitoringConfig)(unsafe.Pointer(in.RemoteWrite))
	out.ExternalLabels = *(*map[string]string)(unsafe.Pointer(&in.ExternalLabels))
	return nil
}

// Convert_v1alpha1_ShootMonitoringConfig_To_config_ShootMonitoringConfig is an autogenerated conversion function.
func Convert_v1alpha1_ShootMonitoringConfig_To_config_ShootMonitoringConfig(in *ShootMonitoringConfig, out *config.ShootMonitoringConfig, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootMonitoringConfig_To_config_ShootMonitoringConfig(in, out, s)
}

func autoConvert_config_ShootMonitoringConfig_To_v1alpha1_ShootMonitoringConfig(in *config.ShootMonitoringConfig, out *ShootMonitoringConfig, s conversion.Scope) error {
	out.RemoteWrite = (*RemoteWriteMonitoringConfig)(unsafe.Pointer(in.RemoteWrite))
	out.ExternalLabels = *(*map[string]string)(unsafe.Pointer(&in.ExternalLabels))
	return nil
}

// Convert_config_ShootMonitoringConfig_To_v1alpha1_ShootMonitoringConfig is an autogenerated conversion function.
func Convert_config_ShootMonitoringConfig_To_v1alpha1_ShootMonitoringConfig(in *config.ShootMonitoringConfig, out *ShootMonitoringConfig, s conversion.Scope) error {
	return autoConvert_config_ShootMonitoringConfig_To_v1alpha1_ShootMonitoringConfig(in, out, s)
}

func autoConvert_v1alpha1_ShootNodeLogging_To_config_ShootNodeLogging(in *ShootNodeLogging, out *config.ShootNodeLogging, s conversion.Scope) error {
	out.ShootPurposes = *(*[]core.ShootPurpose)(unsafe.Pointer(&in.ShootPurposes))
	return nil
}

// Convert_v1alpha1_ShootNodeLogging_To_config_ShootNodeLogging is an autogenerated conversion function.
func Convert_v1alpha1_ShootNodeLogging_To_config_ShootNodeLogging(in *ShootNodeLogging, out *config.ShootNodeLogging, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootNodeLogging_To_config_ShootNodeLogging(in, out, s)
}

func autoConvert_config_ShootNodeLogging_To_v1alpha1_ShootNodeLogging(in *config.ShootNodeLogging, out *ShootNodeLogging, s conversion.Scope) error {
	out.ShootPurposes = *(*[]v1beta1.ShootPurpose)(unsafe.Pointer(&in.ShootPurposes))
	return nil
}

// Convert_config_ShootNodeLogging_To_v1alpha1_ShootNodeLogging is an autogenerated conversion function.
func Convert_config_ShootNodeLogging_To_v1alpha1_ShootNodeLogging(in *config.ShootNodeLogging, out *ShootNodeLogging, s conversion.Scope) error {
	return autoConvert_config_ShootNodeLogging_To_v1alpha1_ShootNodeLogging(in, out, s)
}

func autoConvert_v1alpha1_ShootStateSyncControllerConfiguration_To_config_ShootStateSyncControllerConfiguration(in *ShootStateSyncControllerConfiguration, out *config.ShootStateSyncControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	return nil
}

// Convert_v1alpha1_ShootStateSyncControllerConfiguration_To_config_ShootStateSyncControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ShootStateSyncControllerConfiguration_To_config_ShootStateSyncControllerConfiguration(in *ShootStateSyncControllerConfiguration, out *config.ShootStateSyncControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootStateSyncControllerConfiguration_To_config_ShootStateSyncControllerConfiguration(in, out, s)
}

func autoConvert_config_ShootStateSyncControllerConfiguration_To_v1alpha1_ShootStateSyncControllerConfiguration(in *config.ShootStateSyncControllerConfiguration, out *ShootStateSyncControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = (*int)(unsafe.Pointer(in.ConcurrentSyncs))
	out.SyncPeriod = (*v1.Duration)(unsafe.Pointer(in.SyncPeriod))
	return nil
}

// Convert_config_ShootStateSyncControllerConfiguration_To_v1alpha1_ShootStateSyncControllerConfiguration is an autogenerated conversion function.
func Convert_config_ShootStateSyncControllerConfiguration_To_v1alpha1_ShootStateSyncControllerConfiguration(in *config.ShootStateSyncControllerConfiguration, out *ShootStateSyncControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ShootStateSyncControllerConfiguration_To_v1alpha1_ShootStateSyncControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_StaleExtensionHealthChecks_To_config_StaleExtensionHealthChecks(in *StaleExtensionHealthChecks, out *config.StaleExtensionHealthChecks, s conversion.Scope) error {
	out.Enabled = in.Enabled
	out.Threshold = (*v1.Duration)(unsafe.Pointer(in.Threshold))
	return nil
}

// Convert_v1alpha1_StaleExtensionHealthChecks_To_config_StaleExtensionHealthChecks is an autogenerated conversion function.
func Convert_v1alpha1_StaleExtensionHealthChecks_To_config_StaleExtensionHealthChecks(in *StaleExtensionHealthChecks, out *config.StaleExtensionHealthChecks, s conversion.Scope) error {
	return autoConvert_v1alpha1_StaleExtensionHealthChecks_To_config_StaleExtensionHealthChecks(in, out, s)
}

func autoConvert_config_StaleExtensionHealthChecks_To_v1alpha1_StaleExtensionHealthChecks(in *config.StaleExtensionHealthChecks, out *StaleExtensionHealthChecks, s conversion.Scope) error {
	out.Enabled = in.Enabled
	out.Threshold = (*v1.Duration)(unsafe.Pointer(in.Threshold))
	return nil
}

// Convert_config_StaleExtensionHealthChecks_To_v1alpha1_StaleExtensionHealthChecks is an autogenerated conversion function.
func Convert_config_StaleExtensionHealthChecks_To_v1alpha1_StaleExtensionHealthChecks(in *config.StaleExtensionHealthChecks, out *StaleExtensionHealthChecks, s conversion.Scope) error {
	return autoConvert_config_StaleExtensionHealthChecks_To_v1alpha1_StaleExtensionHealthChecks(in, out, s)
}

func autoConvert_v1alpha1_TLSServer_To_config_TLSServer(in *TLSServer, out *config.TLSServer, s conversion.Scope) error {
	out.ServerCertPath = in.ServerCertPath
	out.ServerKeyPath = in.ServerKeyPath
	return nil
}

// Convert_v1alpha1_TLSServer_To_config_TLSServer is an autogenerated conversion function.
func Convert_v1alpha1_TLSServer_To_config_TLSServer(in *TLSServer, out *config.TLSServer, s conversion.Scope) error {
	return autoConvert_v1alpha1_TLSServer_To_config_TLSServer(in, out, s)
}

func autoConvert_config_TLSServer_To_v1alpha1_TLSServer(in *config.TLSServer, out *TLSServer, s conversion.Scope) error {
	out.ServerCertPath = in.ServerCertPath
	out.ServerKeyPath = in.ServerKeyPath
	return nil
}

// Convert_config_TLSServer_To_v1alpha1_TLSServer is an autogenerated conversion function.
func Convert_config_TLSServer_To_v1alpha1_TLSServer(in *config.TLSServer, out *TLSServer, s conversion.Scope) error {
	return autoConvert_config_TLSServer_To_v1alpha1_TLSServer(in, out, s)
}
