//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

const (
	module  = "armcontainerservice"
	version = "v0.1.0"
)

// AgentPoolMode - A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices,
// see: https://docs.microsoft.com/azure/aks/use-system-pools
type AgentPoolMode string

const (
	// AgentPoolModeSystem - System agent pools are primarily for hosting critical system pods such as CoreDNS and metrics-server. System agent pools osType
	// must be Linux. System agent pools VM SKU must have at least 2vCPUs and 4GB of memory.
	AgentPoolModeSystem AgentPoolMode = "System"
	// AgentPoolModeUser - User agent pools are primarily for hosting your application pods.
	AgentPoolModeUser AgentPoolMode = "User"
)

// PossibleAgentPoolModeValues returns the possible values for the AgentPoolMode const type.
func PossibleAgentPoolModeValues() []AgentPoolMode {
	return []AgentPoolMode{
		AgentPoolModeSystem,
		AgentPoolModeUser,
	}
}

// ToPtr returns a *AgentPoolMode pointing to the current value.
func (c AgentPoolMode) ToPtr() *AgentPoolMode {
	return &c
}

// AgentPoolType - The type of Agent Pool.
type AgentPoolType string

const (
	// AgentPoolTypeAvailabilitySet - Use of this is strongly discouraged.
	AgentPoolTypeAvailabilitySet AgentPoolType = "AvailabilitySet"
	// AgentPoolTypeVirtualMachineScaleSets - Create an Agent Pool backed by a Virtual Machine Scale Set.
	AgentPoolTypeVirtualMachineScaleSets AgentPoolType = "VirtualMachineScaleSets"
)

// PossibleAgentPoolTypeValues returns the possible values for the AgentPoolType const type.
func PossibleAgentPoolTypeValues() []AgentPoolType {
	return []AgentPoolType{
		AgentPoolTypeAvailabilitySet,
		AgentPoolTypeVirtualMachineScaleSets,
	}
}

// ToPtr returns a *AgentPoolType pointing to the current value.
func (c AgentPoolType) ToPtr() *AgentPoolType {
	return &c
}

// Code - Tells whether the cluster is Running or Stopped
type Code string

const (
	// CodeRunning - The cluster is running.
	CodeRunning Code = "Running"
	// CodeStopped - The cluster is stopped.
	CodeStopped Code = "Stopped"
)

// PossibleCodeValues returns the possible values for the Code const type.
func PossibleCodeValues() []Code {
	return []Code{
		CodeRunning,
		CodeStopped,
	}
}

// ToPtr returns a *Code pointing to the current value.
func (c Code) ToPtr() *Code {
	return &c
}

// ConnectionStatus - The private link service connection status.
type ConnectionStatus string

const (
	ConnectionStatusApproved     ConnectionStatus = "Approved"
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	ConnectionStatusPending      ConnectionStatus = "Pending"
	ConnectionStatusRejected     ConnectionStatus = "Rejected"
)

// PossibleConnectionStatusValues returns the possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{
		ConnectionStatusApproved,
		ConnectionStatusDisconnected,
		ConnectionStatusPending,
		ConnectionStatusRejected,
	}
}

// ToPtr returns a *ConnectionStatus pointing to the current value.
func (c ConnectionStatus) ToPtr() *ConnectionStatus {
	return &c
}

// ContainerServiceStorageProfileTypes - Specifies what kind of storage to use. If omitted, the default will be chosen on your behalf based on the choice
// of orchestrator.
type ContainerServiceStorageProfileTypes string

const (
	ContainerServiceStorageProfileTypesManagedDisks   ContainerServiceStorageProfileTypes = "ManagedDisks"
	ContainerServiceStorageProfileTypesStorageAccount ContainerServiceStorageProfileTypes = "StorageAccount"
)

// PossibleContainerServiceStorageProfileTypesValues returns the possible values for the ContainerServiceStorageProfileTypes const type.
func PossibleContainerServiceStorageProfileTypesValues() []ContainerServiceStorageProfileTypes {
	return []ContainerServiceStorageProfileTypes{
		ContainerServiceStorageProfileTypesManagedDisks,
		ContainerServiceStorageProfileTypesStorageAccount,
	}
}

// ToPtr returns a *ContainerServiceStorageProfileTypes pointing to the current value.
func (c ContainerServiceStorageProfileTypes) ToPtr() *ContainerServiceStorageProfileTypes {
	return &c
}

// ContainerServiceVMSizeTypes - Size of agent VMs. Note: This is no longer maintained.
type ContainerServiceVMSizeTypes string

const (
	ContainerServiceVMSizeTypesStandardA1          ContainerServiceVMSizeTypes = "Standard_A1"
	ContainerServiceVMSizeTypesStandardA10         ContainerServiceVMSizeTypes = "Standard_A10"
	ContainerServiceVMSizeTypesStandardA11         ContainerServiceVMSizeTypes = "Standard_A11"
	ContainerServiceVMSizeTypesStandardA1V2        ContainerServiceVMSizeTypes = "Standard_A1_v2"
	ContainerServiceVMSizeTypesStandardA2          ContainerServiceVMSizeTypes = "Standard_A2"
	ContainerServiceVMSizeTypesStandardA2MV2       ContainerServiceVMSizeTypes = "Standard_A2m_v2"
	ContainerServiceVMSizeTypesStandardA2V2        ContainerServiceVMSizeTypes = "Standard_A2_v2"
	ContainerServiceVMSizeTypesStandardA3          ContainerServiceVMSizeTypes = "Standard_A3"
	ContainerServiceVMSizeTypesStandardA4          ContainerServiceVMSizeTypes = "Standard_A4"
	ContainerServiceVMSizeTypesStandardA4MV2       ContainerServiceVMSizeTypes = "Standard_A4m_v2"
	ContainerServiceVMSizeTypesStandardA4V2        ContainerServiceVMSizeTypes = "Standard_A4_v2"
	ContainerServiceVMSizeTypesStandardA5          ContainerServiceVMSizeTypes = "Standard_A5"
	ContainerServiceVMSizeTypesStandardA6          ContainerServiceVMSizeTypes = "Standard_A6"
	ContainerServiceVMSizeTypesStandardA7          ContainerServiceVMSizeTypes = "Standard_A7"
	ContainerServiceVMSizeTypesStandardA8          ContainerServiceVMSizeTypes = "Standard_A8"
	ContainerServiceVMSizeTypesStandardA8MV2       ContainerServiceVMSizeTypes = "Standard_A8m_v2"
	ContainerServiceVMSizeTypesStandardA8V2        ContainerServiceVMSizeTypes = "Standard_A8_v2"
	ContainerServiceVMSizeTypesStandardA9          ContainerServiceVMSizeTypes = "Standard_A9"
	ContainerServiceVMSizeTypesStandardB2Ms        ContainerServiceVMSizeTypes = "Standard_B2ms"
	ContainerServiceVMSizeTypesStandardB2S         ContainerServiceVMSizeTypes = "Standard_B2s"
	ContainerServiceVMSizeTypesStandardB4Ms        ContainerServiceVMSizeTypes = "Standard_B4ms"
	ContainerServiceVMSizeTypesStandardB8Ms        ContainerServiceVMSizeTypes = "Standard_B8ms"
	ContainerServiceVMSizeTypesStandardD1          ContainerServiceVMSizeTypes = "Standard_D1"
	ContainerServiceVMSizeTypesStandardD11         ContainerServiceVMSizeTypes = "Standard_D11"
	ContainerServiceVMSizeTypesStandardD11V2       ContainerServiceVMSizeTypes = "Standard_D11_v2"
	ContainerServiceVMSizeTypesStandardD11V2Promo  ContainerServiceVMSizeTypes = "Standard_D11_v2_Promo"
	ContainerServiceVMSizeTypesStandardD12         ContainerServiceVMSizeTypes = "Standard_D12"
	ContainerServiceVMSizeTypesStandardD12V2       ContainerServiceVMSizeTypes = "Standard_D12_v2"
	ContainerServiceVMSizeTypesStandardD12V2Promo  ContainerServiceVMSizeTypes = "Standard_D12_v2_Promo"
	ContainerServiceVMSizeTypesStandardD13         ContainerServiceVMSizeTypes = "Standard_D13"
	ContainerServiceVMSizeTypesStandardD13V2       ContainerServiceVMSizeTypes = "Standard_D13_v2"
	ContainerServiceVMSizeTypesStandardD13V2Promo  ContainerServiceVMSizeTypes = "Standard_D13_v2_Promo"
	ContainerServiceVMSizeTypesStandardD14         ContainerServiceVMSizeTypes = "Standard_D14"
	ContainerServiceVMSizeTypesStandardD14V2       ContainerServiceVMSizeTypes = "Standard_D14_v2"
	ContainerServiceVMSizeTypesStandardD14V2Promo  ContainerServiceVMSizeTypes = "Standard_D14_v2_Promo"
	ContainerServiceVMSizeTypesStandardD15V2       ContainerServiceVMSizeTypes = "Standard_D15_v2"
	ContainerServiceVMSizeTypesStandardD16SV3      ContainerServiceVMSizeTypes = "Standard_D16s_v3"
	ContainerServiceVMSizeTypesStandardD16V3       ContainerServiceVMSizeTypes = "Standard_D16_v3"
	ContainerServiceVMSizeTypesStandardD1V2        ContainerServiceVMSizeTypes = "Standard_D1_v2"
	ContainerServiceVMSizeTypesStandardD2          ContainerServiceVMSizeTypes = "Standard_D2"
	ContainerServiceVMSizeTypesStandardD2SV3       ContainerServiceVMSizeTypes = "Standard_D2s_v3"
	ContainerServiceVMSizeTypesStandardD2V2        ContainerServiceVMSizeTypes = "Standard_D2_v2"
	ContainerServiceVMSizeTypesStandardD2V2Promo   ContainerServiceVMSizeTypes = "Standard_D2_v2_Promo"
	ContainerServiceVMSizeTypesStandardD2V3        ContainerServiceVMSizeTypes = "Standard_D2_v3"
	ContainerServiceVMSizeTypesStandardD3          ContainerServiceVMSizeTypes = "Standard_D3"
	ContainerServiceVMSizeTypesStandardD32SV3      ContainerServiceVMSizeTypes = "Standard_D32s_v3"
	ContainerServiceVMSizeTypesStandardD32V3       ContainerServiceVMSizeTypes = "Standard_D32_v3"
	ContainerServiceVMSizeTypesStandardD3V2        ContainerServiceVMSizeTypes = "Standard_D3_v2"
	ContainerServiceVMSizeTypesStandardD3V2Promo   ContainerServiceVMSizeTypes = "Standard_D3_v2_Promo"
	ContainerServiceVMSizeTypesStandardD4          ContainerServiceVMSizeTypes = "Standard_D4"
	ContainerServiceVMSizeTypesStandardD4SV3       ContainerServiceVMSizeTypes = "Standard_D4s_v3"
	ContainerServiceVMSizeTypesStandardD4V2        ContainerServiceVMSizeTypes = "Standard_D4_v2"
	ContainerServiceVMSizeTypesStandardD4V2Promo   ContainerServiceVMSizeTypes = "Standard_D4_v2_Promo"
	ContainerServiceVMSizeTypesStandardD4V3        ContainerServiceVMSizeTypes = "Standard_D4_v3"
	ContainerServiceVMSizeTypesStandardD5V2        ContainerServiceVMSizeTypes = "Standard_D5_v2"
	ContainerServiceVMSizeTypesStandardD5V2Promo   ContainerServiceVMSizeTypes = "Standard_D5_v2_Promo"
	ContainerServiceVMSizeTypesStandardD64SV3      ContainerServiceVMSizeTypes = "Standard_D64s_v3"
	ContainerServiceVMSizeTypesStandardD64V3       ContainerServiceVMSizeTypes = "Standard_D64_v3"
	ContainerServiceVMSizeTypesStandardD8SV3       ContainerServiceVMSizeTypes = "Standard_D8s_v3"
	ContainerServiceVMSizeTypesStandardD8V3        ContainerServiceVMSizeTypes = "Standard_D8_v3"
	ContainerServiceVMSizeTypesStandardDS1         ContainerServiceVMSizeTypes = "Standard_DS1"
	ContainerServiceVMSizeTypesStandardDS11        ContainerServiceVMSizeTypes = "Standard_DS11"
	ContainerServiceVMSizeTypesStandardDS11V2      ContainerServiceVMSizeTypes = "Standard_DS11_v2"
	ContainerServiceVMSizeTypesStandardDS11V2Promo ContainerServiceVMSizeTypes = "Standard_DS11_v2_Promo"
	ContainerServiceVMSizeTypesStandardDS12        ContainerServiceVMSizeTypes = "Standard_DS12"
	ContainerServiceVMSizeTypesStandardDS12V2      ContainerServiceVMSizeTypes = "Standard_DS12_v2"
	ContainerServiceVMSizeTypesStandardDS12V2Promo ContainerServiceVMSizeTypes = "Standard_DS12_v2_Promo"
	ContainerServiceVMSizeTypesStandardDS13        ContainerServiceVMSizeTypes = "Standard_DS13"
	ContainerServiceVMSizeTypesStandardDS132V2     ContainerServiceVMSizeTypes = "Standard_DS13-2_v2"
	ContainerServiceVMSizeTypesStandardDS134V2     ContainerServiceVMSizeTypes = "Standard_DS13-4_v2"
	ContainerServiceVMSizeTypesStandardDS13V2      ContainerServiceVMSizeTypes = "Standard_DS13_v2"
	ContainerServiceVMSizeTypesStandardDS13V2Promo ContainerServiceVMSizeTypes = "Standard_DS13_v2_Promo"
	ContainerServiceVMSizeTypesStandardDS14        ContainerServiceVMSizeTypes = "Standard_DS14"
	ContainerServiceVMSizeTypesStandardDS144V2     ContainerServiceVMSizeTypes = "Standard_DS14-4_v2"
	ContainerServiceVMSizeTypesStandardDS148V2     ContainerServiceVMSizeTypes = "Standard_DS14-8_v2"
	ContainerServiceVMSizeTypesStandardDS14V2      ContainerServiceVMSizeTypes = "Standard_DS14_v2"
	ContainerServiceVMSizeTypesStandardDS14V2Promo ContainerServiceVMSizeTypes = "Standard_DS14_v2_Promo"
	ContainerServiceVMSizeTypesStandardDS15V2      ContainerServiceVMSizeTypes = "Standard_DS15_v2"
	ContainerServiceVMSizeTypesStandardDS1V2       ContainerServiceVMSizeTypes = "Standard_DS1_v2"
	ContainerServiceVMSizeTypesStandardDS2         ContainerServiceVMSizeTypes = "Standard_DS2"
	ContainerServiceVMSizeTypesStandardDS2V2       ContainerServiceVMSizeTypes = "Standard_DS2_v2"
	ContainerServiceVMSizeTypesStandardDS2V2Promo  ContainerServiceVMSizeTypes = "Standard_DS2_v2_Promo"
	ContainerServiceVMSizeTypesStandardDS3         ContainerServiceVMSizeTypes = "Standard_DS3"
	ContainerServiceVMSizeTypesStandardDS3V2       ContainerServiceVMSizeTypes = "Standard_DS3_v2"
	ContainerServiceVMSizeTypesStandardDS3V2Promo  ContainerServiceVMSizeTypes = "Standard_DS3_v2_Promo"
	ContainerServiceVMSizeTypesStandardDS4         ContainerServiceVMSizeTypes = "Standard_DS4"
	ContainerServiceVMSizeTypesStandardDS4V2       ContainerServiceVMSizeTypes = "Standard_DS4_v2"
	ContainerServiceVMSizeTypesStandardDS4V2Promo  ContainerServiceVMSizeTypes = "Standard_DS4_v2_Promo"
	ContainerServiceVMSizeTypesStandardDS5V2       ContainerServiceVMSizeTypes = "Standard_DS5_v2"
	ContainerServiceVMSizeTypesStandardDS5V2Promo  ContainerServiceVMSizeTypes = "Standard_DS5_v2_Promo"
	ContainerServiceVMSizeTypesStandardE16SV3      ContainerServiceVMSizeTypes = "Standard_E16s_v3"
	ContainerServiceVMSizeTypesStandardE16V3       ContainerServiceVMSizeTypes = "Standard_E16_v3"
	ContainerServiceVMSizeTypesStandardE2SV3       ContainerServiceVMSizeTypes = "Standard_E2s_v3"
	ContainerServiceVMSizeTypesStandardE2V3        ContainerServiceVMSizeTypes = "Standard_E2_v3"
	ContainerServiceVMSizeTypesStandardE3216SV3    ContainerServiceVMSizeTypes = "Standard_E32-16s_v3"
	ContainerServiceVMSizeTypesStandardE328SV3     ContainerServiceVMSizeTypes = "Standard_E32-8s_v3"
	ContainerServiceVMSizeTypesStandardE32SV3      ContainerServiceVMSizeTypes = "Standard_E32s_v3"
	ContainerServiceVMSizeTypesStandardE32V3       ContainerServiceVMSizeTypes = "Standard_E32_v3"
	ContainerServiceVMSizeTypesStandardE4SV3       ContainerServiceVMSizeTypes = "Standard_E4s_v3"
	ContainerServiceVMSizeTypesStandardE4V3        ContainerServiceVMSizeTypes = "Standard_E4_v3"
	ContainerServiceVMSizeTypesStandardE6416SV3    ContainerServiceVMSizeTypes = "Standard_E64-16s_v3"
	ContainerServiceVMSizeTypesStandardE6432SV3    ContainerServiceVMSizeTypes = "Standard_E64-32s_v3"
	ContainerServiceVMSizeTypesStandardE64SV3      ContainerServiceVMSizeTypes = "Standard_E64s_v3"
	ContainerServiceVMSizeTypesStandardE64V3       ContainerServiceVMSizeTypes = "Standard_E64_v3"
	ContainerServiceVMSizeTypesStandardE8SV3       ContainerServiceVMSizeTypes = "Standard_E8s_v3"
	ContainerServiceVMSizeTypesStandardE8V3        ContainerServiceVMSizeTypes = "Standard_E8_v3"
	ContainerServiceVMSizeTypesStandardF1          ContainerServiceVMSizeTypes = "Standard_F1"
	ContainerServiceVMSizeTypesStandardF16         ContainerServiceVMSizeTypes = "Standard_F16"
	ContainerServiceVMSizeTypesStandardF16S        ContainerServiceVMSizeTypes = "Standard_F16s"
	ContainerServiceVMSizeTypesStandardF16SV2      ContainerServiceVMSizeTypes = "Standard_F16s_v2"
	ContainerServiceVMSizeTypesStandardF1S         ContainerServiceVMSizeTypes = "Standard_F1s"
	ContainerServiceVMSizeTypesStandardF2          ContainerServiceVMSizeTypes = "Standard_F2"
	ContainerServiceVMSizeTypesStandardF2S         ContainerServiceVMSizeTypes = "Standard_F2s"
	ContainerServiceVMSizeTypesStandardF2SV2       ContainerServiceVMSizeTypes = "Standard_F2s_v2"
	ContainerServiceVMSizeTypesStandardF32SV2      ContainerServiceVMSizeTypes = "Standard_F32s_v2"
	ContainerServiceVMSizeTypesStandardF4          ContainerServiceVMSizeTypes = "Standard_F4"
	ContainerServiceVMSizeTypesStandardF4S         ContainerServiceVMSizeTypes = "Standard_F4s"
	ContainerServiceVMSizeTypesStandardF4SV2       ContainerServiceVMSizeTypes = "Standard_F4s_v2"
	ContainerServiceVMSizeTypesStandardF64SV2      ContainerServiceVMSizeTypes = "Standard_F64s_v2"
	ContainerServiceVMSizeTypesStandardF72SV2      ContainerServiceVMSizeTypes = "Standard_F72s_v2"
	ContainerServiceVMSizeTypesStandardF8          ContainerServiceVMSizeTypes = "Standard_F8"
	ContainerServiceVMSizeTypesStandardF8S         ContainerServiceVMSizeTypes = "Standard_F8s"
	ContainerServiceVMSizeTypesStandardF8SV2       ContainerServiceVMSizeTypes = "Standard_F8s_v2"
	ContainerServiceVMSizeTypesStandardG1          ContainerServiceVMSizeTypes = "Standard_G1"
	ContainerServiceVMSizeTypesStandardG2          ContainerServiceVMSizeTypes = "Standard_G2"
	ContainerServiceVMSizeTypesStandardG3          ContainerServiceVMSizeTypes = "Standard_G3"
	ContainerServiceVMSizeTypesStandardG4          ContainerServiceVMSizeTypes = "Standard_G4"
	ContainerServiceVMSizeTypesStandardG5          ContainerServiceVMSizeTypes = "Standard_G5"
	ContainerServiceVMSizeTypesStandardGS1         ContainerServiceVMSizeTypes = "Standard_GS1"
	ContainerServiceVMSizeTypesStandardGS2         ContainerServiceVMSizeTypes = "Standard_GS2"
	ContainerServiceVMSizeTypesStandardGS3         ContainerServiceVMSizeTypes = "Standard_GS3"
	ContainerServiceVMSizeTypesStandardGS4         ContainerServiceVMSizeTypes = "Standard_GS4"
	ContainerServiceVMSizeTypesStandardGS44        ContainerServiceVMSizeTypes = "Standard_GS4-4"
	ContainerServiceVMSizeTypesStandardGS48        ContainerServiceVMSizeTypes = "Standard_GS4-8"
	ContainerServiceVMSizeTypesStandardGS5         ContainerServiceVMSizeTypes = "Standard_GS5"
	ContainerServiceVMSizeTypesStandardGS516       ContainerServiceVMSizeTypes = "Standard_GS5-16"
	ContainerServiceVMSizeTypesStandardGS58        ContainerServiceVMSizeTypes = "Standard_GS5-8"
	ContainerServiceVMSizeTypesStandardH16         ContainerServiceVMSizeTypes = "Standard_H16"
	ContainerServiceVMSizeTypesStandardH16M        ContainerServiceVMSizeTypes = "Standard_H16m"
	ContainerServiceVMSizeTypesStandardH16Mr       ContainerServiceVMSizeTypes = "Standard_H16mr"
	ContainerServiceVMSizeTypesStandardH16R        ContainerServiceVMSizeTypes = "Standard_H16r"
	ContainerServiceVMSizeTypesStandardH8          ContainerServiceVMSizeTypes = "Standard_H8"
	ContainerServiceVMSizeTypesStandardH8M         ContainerServiceVMSizeTypes = "Standard_H8m"
	ContainerServiceVMSizeTypesStandardL16S        ContainerServiceVMSizeTypes = "Standard_L16s"
	ContainerServiceVMSizeTypesStandardL32S        ContainerServiceVMSizeTypes = "Standard_L32s"
	ContainerServiceVMSizeTypesStandardL4S         ContainerServiceVMSizeTypes = "Standard_L4s"
	ContainerServiceVMSizeTypesStandardL8S         ContainerServiceVMSizeTypes = "Standard_L8s"
	ContainerServiceVMSizeTypesStandardM12832Ms    ContainerServiceVMSizeTypes = "Standard_M128-32ms"
	ContainerServiceVMSizeTypesStandardM12864Ms    ContainerServiceVMSizeTypes = "Standard_M128-64ms"
	ContainerServiceVMSizeTypesStandardM128Ms      ContainerServiceVMSizeTypes = "Standard_M128ms"
	ContainerServiceVMSizeTypesStandardM128S       ContainerServiceVMSizeTypes = "Standard_M128s"
	ContainerServiceVMSizeTypesStandardM6416Ms     ContainerServiceVMSizeTypes = "Standard_M64-16ms"
	ContainerServiceVMSizeTypesStandardM6432Ms     ContainerServiceVMSizeTypes = "Standard_M64-32ms"
	ContainerServiceVMSizeTypesStandardM64Ms       ContainerServiceVMSizeTypes = "Standard_M64ms"
	ContainerServiceVMSizeTypesStandardM64S        ContainerServiceVMSizeTypes = "Standard_M64s"
	ContainerServiceVMSizeTypesStandardNC12        ContainerServiceVMSizeTypes = "Standard_NC12"
	ContainerServiceVMSizeTypesStandardNC12SV2     ContainerServiceVMSizeTypes = "Standard_NC12s_v2"
	ContainerServiceVMSizeTypesStandardNC12SV3     ContainerServiceVMSizeTypes = "Standard_NC12s_v3"
	ContainerServiceVMSizeTypesStandardNC24        ContainerServiceVMSizeTypes = "Standard_NC24"
	ContainerServiceVMSizeTypesStandardNC24R       ContainerServiceVMSizeTypes = "Standard_NC24r"
	ContainerServiceVMSizeTypesStandardNC24RsV2    ContainerServiceVMSizeTypes = "Standard_NC24rs_v2"
	ContainerServiceVMSizeTypesStandardNC24RsV3    ContainerServiceVMSizeTypes = "Standard_NC24rs_v3"
	ContainerServiceVMSizeTypesStandardNC24SV2     ContainerServiceVMSizeTypes = "Standard_NC24s_v2"
	ContainerServiceVMSizeTypesStandardNC24SV3     ContainerServiceVMSizeTypes = "Standard_NC24s_v3"
	ContainerServiceVMSizeTypesStandardNC6         ContainerServiceVMSizeTypes = "Standard_NC6"
	ContainerServiceVMSizeTypesStandardNC6SV2      ContainerServiceVMSizeTypes = "Standard_NC6s_v2"
	ContainerServiceVMSizeTypesStandardNC6SV3      ContainerServiceVMSizeTypes = "Standard_NC6s_v3"
	ContainerServiceVMSizeTypesStandardND12S       ContainerServiceVMSizeTypes = "Standard_ND12s"
	ContainerServiceVMSizeTypesStandardND24Rs      ContainerServiceVMSizeTypes = "Standard_ND24rs"
	ContainerServiceVMSizeTypesStandardND24S       ContainerServiceVMSizeTypes = "Standard_ND24s"
	ContainerServiceVMSizeTypesStandardND6S        ContainerServiceVMSizeTypes = "Standard_ND6s"
	ContainerServiceVMSizeTypesStandardNV12        ContainerServiceVMSizeTypes = "Standard_NV12"
	ContainerServiceVMSizeTypesStandardNV24        ContainerServiceVMSizeTypes = "Standard_NV24"
	ContainerServiceVMSizeTypesStandardNV6         ContainerServiceVMSizeTypes = "Standard_NV6"
)

// PossibleContainerServiceVMSizeTypesValues returns the possible values for the ContainerServiceVMSizeTypes const type.
func PossibleContainerServiceVMSizeTypesValues() []ContainerServiceVMSizeTypes {
	return []ContainerServiceVMSizeTypes{
		ContainerServiceVMSizeTypesStandardA1,
		ContainerServiceVMSizeTypesStandardA10,
		ContainerServiceVMSizeTypesStandardA11,
		ContainerServiceVMSizeTypesStandardA1V2,
		ContainerServiceVMSizeTypesStandardA2,
		ContainerServiceVMSizeTypesStandardA2MV2,
		ContainerServiceVMSizeTypesStandardA2V2,
		ContainerServiceVMSizeTypesStandardA3,
		ContainerServiceVMSizeTypesStandardA4,
		ContainerServiceVMSizeTypesStandardA4MV2,
		ContainerServiceVMSizeTypesStandardA4V2,
		ContainerServiceVMSizeTypesStandardA5,
		ContainerServiceVMSizeTypesStandardA6,
		ContainerServiceVMSizeTypesStandardA7,
		ContainerServiceVMSizeTypesStandardA8,
		ContainerServiceVMSizeTypesStandardA8MV2,
		ContainerServiceVMSizeTypesStandardA8V2,
		ContainerServiceVMSizeTypesStandardA9,
		ContainerServiceVMSizeTypesStandardB2Ms,
		ContainerServiceVMSizeTypesStandardB2S,
		ContainerServiceVMSizeTypesStandardB4Ms,
		ContainerServiceVMSizeTypesStandardB8Ms,
		ContainerServiceVMSizeTypesStandardD1,
		ContainerServiceVMSizeTypesStandardD11,
		ContainerServiceVMSizeTypesStandardD11V2,
		ContainerServiceVMSizeTypesStandardD11V2Promo,
		ContainerServiceVMSizeTypesStandardD12,
		ContainerServiceVMSizeTypesStandardD12V2,
		ContainerServiceVMSizeTypesStandardD12V2Promo,
		ContainerServiceVMSizeTypesStandardD13,
		ContainerServiceVMSizeTypesStandardD13V2,
		ContainerServiceVMSizeTypesStandardD13V2Promo,
		ContainerServiceVMSizeTypesStandardD14,
		ContainerServiceVMSizeTypesStandardD14V2,
		ContainerServiceVMSizeTypesStandardD14V2Promo,
		ContainerServiceVMSizeTypesStandardD15V2,
		ContainerServiceVMSizeTypesStandardD16SV3,
		ContainerServiceVMSizeTypesStandardD16V3,
		ContainerServiceVMSizeTypesStandardD1V2,
		ContainerServiceVMSizeTypesStandardD2,
		ContainerServiceVMSizeTypesStandardD2SV3,
		ContainerServiceVMSizeTypesStandardD2V2,
		ContainerServiceVMSizeTypesStandardD2V2Promo,
		ContainerServiceVMSizeTypesStandardD2V3,
		ContainerServiceVMSizeTypesStandardD3,
		ContainerServiceVMSizeTypesStandardD32SV3,
		ContainerServiceVMSizeTypesStandardD32V3,
		ContainerServiceVMSizeTypesStandardD3V2,
		ContainerServiceVMSizeTypesStandardD3V2Promo,
		ContainerServiceVMSizeTypesStandardD4,
		ContainerServiceVMSizeTypesStandardD4SV3,
		ContainerServiceVMSizeTypesStandardD4V2,
		ContainerServiceVMSizeTypesStandardD4V2Promo,
		ContainerServiceVMSizeTypesStandardD4V3,
		ContainerServiceVMSizeTypesStandardD5V2,
		ContainerServiceVMSizeTypesStandardD5V2Promo,
		ContainerServiceVMSizeTypesStandardD64SV3,
		ContainerServiceVMSizeTypesStandardD64V3,
		ContainerServiceVMSizeTypesStandardD8SV3,
		ContainerServiceVMSizeTypesStandardD8V3,
		ContainerServiceVMSizeTypesStandardDS1,
		ContainerServiceVMSizeTypesStandardDS11,
		ContainerServiceVMSizeTypesStandardDS11V2,
		ContainerServiceVMSizeTypesStandardDS11V2Promo,
		ContainerServiceVMSizeTypesStandardDS12,
		ContainerServiceVMSizeTypesStandardDS12V2,
		ContainerServiceVMSizeTypesStandardDS12V2Promo,
		ContainerServiceVMSizeTypesStandardDS13,
		ContainerServiceVMSizeTypesStandardDS132V2,
		ContainerServiceVMSizeTypesStandardDS134V2,
		ContainerServiceVMSizeTypesStandardDS13V2,
		ContainerServiceVMSizeTypesStandardDS13V2Promo,
		ContainerServiceVMSizeTypesStandardDS14,
		ContainerServiceVMSizeTypesStandardDS144V2,
		ContainerServiceVMSizeTypesStandardDS148V2,
		ContainerServiceVMSizeTypesStandardDS14V2,
		ContainerServiceVMSizeTypesStandardDS14V2Promo,
		ContainerServiceVMSizeTypesStandardDS15V2,
		ContainerServiceVMSizeTypesStandardDS1V2,
		ContainerServiceVMSizeTypesStandardDS2,
		ContainerServiceVMSizeTypesStandardDS2V2,
		ContainerServiceVMSizeTypesStandardDS2V2Promo,
		ContainerServiceVMSizeTypesStandardDS3,
		ContainerServiceVMSizeTypesStandardDS3V2,
		ContainerServiceVMSizeTypesStandardDS3V2Promo,
		ContainerServiceVMSizeTypesStandardDS4,
		ContainerServiceVMSizeTypesStandardDS4V2,
		ContainerServiceVMSizeTypesStandardDS4V2Promo,
		ContainerServiceVMSizeTypesStandardDS5V2,
		ContainerServiceVMSizeTypesStandardDS5V2Promo,
		ContainerServiceVMSizeTypesStandardE16SV3,
		ContainerServiceVMSizeTypesStandardE16V3,
		ContainerServiceVMSizeTypesStandardE2SV3,
		ContainerServiceVMSizeTypesStandardE2V3,
		ContainerServiceVMSizeTypesStandardE3216SV3,
		ContainerServiceVMSizeTypesStandardE328SV3,
		ContainerServiceVMSizeTypesStandardE32SV3,
		ContainerServiceVMSizeTypesStandardE32V3,
		ContainerServiceVMSizeTypesStandardE4SV3,
		ContainerServiceVMSizeTypesStandardE4V3,
		ContainerServiceVMSizeTypesStandardE6416SV3,
		ContainerServiceVMSizeTypesStandardE6432SV3,
		ContainerServiceVMSizeTypesStandardE64SV3,
		ContainerServiceVMSizeTypesStandardE64V3,
		ContainerServiceVMSizeTypesStandardE8SV3,
		ContainerServiceVMSizeTypesStandardE8V3,
		ContainerServiceVMSizeTypesStandardF1,
		ContainerServiceVMSizeTypesStandardF16,
		ContainerServiceVMSizeTypesStandardF16S,
		ContainerServiceVMSizeTypesStandardF16SV2,
		ContainerServiceVMSizeTypesStandardF1S,
		ContainerServiceVMSizeTypesStandardF2,
		ContainerServiceVMSizeTypesStandardF2S,
		ContainerServiceVMSizeTypesStandardF2SV2,
		ContainerServiceVMSizeTypesStandardF32SV2,
		ContainerServiceVMSizeTypesStandardF4,
		ContainerServiceVMSizeTypesStandardF4S,
		ContainerServiceVMSizeTypesStandardF4SV2,
		ContainerServiceVMSizeTypesStandardF64SV2,
		ContainerServiceVMSizeTypesStandardF72SV2,
		ContainerServiceVMSizeTypesStandardF8,
		ContainerServiceVMSizeTypesStandardF8S,
		ContainerServiceVMSizeTypesStandardF8SV2,
		ContainerServiceVMSizeTypesStandardG1,
		ContainerServiceVMSizeTypesStandardG2,
		ContainerServiceVMSizeTypesStandardG3,
		ContainerServiceVMSizeTypesStandardG4,
		ContainerServiceVMSizeTypesStandardG5,
		ContainerServiceVMSizeTypesStandardGS1,
		ContainerServiceVMSizeTypesStandardGS2,
		ContainerServiceVMSizeTypesStandardGS3,
		ContainerServiceVMSizeTypesStandardGS4,
		ContainerServiceVMSizeTypesStandardGS44,
		ContainerServiceVMSizeTypesStandardGS48,
		ContainerServiceVMSizeTypesStandardGS5,
		ContainerServiceVMSizeTypesStandardGS516,
		ContainerServiceVMSizeTypesStandardGS58,
		ContainerServiceVMSizeTypesStandardH16,
		ContainerServiceVMSizeTypesStandardH16M,
		ContainerServiceVMSizeTypesStandardH16Mr,
		ContainerServiceVMSizeTypesStandardH16R,
		ContainerServiceVMSizeTypesStandardH8,
		ContainerServiceVMSizeTypesStandardH8M,
		ContainerServiceVMSizeTypesStandardL16S,
		ContainerServiceVMSizeTypesStandardL32S,
		ContainerServiceVMSizeTypesStandardL4S,
		ContainerServiceVMSizeTypesStandardL8S,
		ContainerServiceVMSizeTypesStandardM12832Ms,
		ContainerServiceVMSizeTypesStandardM12864Ms,
		ContainerServiceVMSizeTypesStandardM128Ms,
		ContainerServiceVMSizeTypesStandardM128S,
		ContainerServiceVMSizeTypesStandardM6416Ms,
		ContainerServiceVMSizeTypesStandardM6432Ms,
		ContainerServiceVMSizeTypesStandardM64Ms,
		ContainerServiceVMSizeTypesStandardM64S,
		ContainerServiceVMSizeTypesStandardNC12,
		ContainerServiceVMSizeTypesStandardNC12SV2,
		ContainerServiceVMSizeTypesStandardNC12SV3,
		ContainerServiceVMSizeTypesStandardNC24,
		ContainerServiceVMSizeTypesStandardNC24R,
		ContainerServiceVMSizeTypesStandardNC24RsV2,
		ContainerServiceVMSizeTypesStandardNC24RsV3,
		ContainerServiceVMSizeTypesStandardNC24SV2,
		ContainerServiceVMSizeTypesStandardNC24SV3,
		ContainerServiceVMSizeTypesStandardNC6,
		ContainerServiceVMSizeTypesStandardNC6SV2,
		ContainerServiceVMSizeTypesStandardNC6SV3,
		ContainerServiceVMSizeTypesStandardND12S,
		ContainerServiceVMSizeTypesStandardND24Rs,
		ContainerServiceVMSizeTypesStandardND24S,
		ContainerServiceVMSizeTypesStandardND6S,
		ContainerServiceVMSizeTypesStandardNV12,
		ContainerServiceVMSizeTypesStandardNV24,
		ContainerServiceVMSizeTypesStandardNV6,
	}
}

// ToPtr returns a *ContainerServiceVMSizeTypes pointing to the current value.
func (c ContainerServiceVMSizeTypes) ToPtr() *ContainerServiceVMSizeTypes {
	return &c
}

// Count - Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
type Count int32

const (
	CountOne   Count = 1
	CountThree Count = 3
	CountFive  Count = 5
)

// PossibleCountValues returns the possible values for the Count const type.
func PossibleCountValues() []Count {
	return []Count{
		CountOne,
		CountThree,
		CountFive,
	}
}

// ToPtr returns a *Count pointing to the current value.
func (c Count) ToPtr() *Count {
	return &c
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// ToPtr returns a *CreatedByType pointing to the current value.
func (c CreatedByType) ToPtr() *CreatedByType {
	return &c
}

// Expander - If not specified, the default is 'random'. See expanders [https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders]
// for more information.
type Expander string

const (
	// ExpanderLeastWaste - Selects the node group that will have the least idle CPU (if tied, unused memory) after scale-up. This is useful when you have different
	// classes of nodes, for example, high CPU or high memory nodes, and only want to expand those when there are pending pods that need a lot of those resources.
	ExpanderLeastWaste Expander = "least-waste"
	// ExpanderMostPods - Selects the node group that would be able to schedule the most pods when scaling up. This is useful when you are using nodeSelector
	// to make sure certain pods land on certain nodes. Note that this won't cause the autoscaler to select bigger nodes vs. smaller, as it can add multiple
	// smaller nodes at once.
	ExpanderMostPods Expander = "most-pods"
	// ExpanderPriority - Selects the node group that has the highest priority assigned by the user. It's configuration is described in more details [here](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/expander/priority/readme.md).
	ExpanderPriority Expander = "priority"
	// ExpanderRandom - Used when you don't have a particular need for the node groups to scale differently.
	ExpanderRandom Expander = "random"
)

// PossibleExpanderValues returns the possible values for the Expander const type.
func PossibleExpanderValues() []Expander {
	return []Expander{
		ExpanderLeastWaste,
		ExpanderMostPods,
		ExpanderPriority,
		ExpanderRandom,
	}
}

// ToPtr returns a *Expander pointing to the current value.
func (c Expander) ToPtr() *Expander {
	return &c
}

// ExtendedLocationTypes - The type of extendedLocation.
type ExtendedLocationTypes string

const (
	ExtendedLocationTypesEdgeZone ExtendedLocationTypes = "EdgeZone"
)

// PossibleExtendedLocationTypesValues returns the possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{
		ExtendedLocationTypesEdgeZone,
	}
}

// ToPtr returns a *ExtendedLocationTypes pointing to the current value.
func (c ExtendedLocationTypes) ToPtr() *ExtendedLocationTypes {
	return &c
}

// GPUInstanceProfile - GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
type GPUInstanceProfile string

const (
	GPUInstanceProfileMIG1G GPUInstanceProfile = "MIG1g"
	GPUInstanceProfileMIG2G GPUInstanceProfile = "MIG2g"
	GPUInstanceProfileMIG3G GPUInstanceProfile = "MIG3g"
	GPUInstanceProfileMIG4G GPUInstanceProfile = "MIG4g"
	GPUInstanceProfileMIG7G GPUInstanceProfile = "MIG7g"
)

// PossibleGPUInstanceProfileValues returns the possible values for the GPUInstanceProfile const type.
func PossibleGPUInstanceProfileValues() []GPUInstanceProfile {
	return []GPUInstanceProfile{
		GPUInstanceProfileMIG1G,
		GPUInstanceProfileMIG2G,
		GPUInstanceProfileMIG3G,
		GPUInstanceProfileMIG4G,
		GPUInstanceProfileMIG7G,
	}
}

// ToPtr returns a *GPUInstanceProfile pointing to the current value.
func (c GPUInstanceProfile) ToPtr() *GPUInstanceProfile {
	return &c
}

// KubeletDiskType - Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
type KubeletDiskType string

const (
	// KubeletDiskTypeOS - Kubelet will use the OS disk for its data.
	KubeletDiskTypeOS KubeletDiskType = "OS"
	// KubeletDiskTypeTemporary - Kubelet will use the temporary disk for its data.
	KubeletDiskTypeTemporary KubeletDiskType = "Temporary"
)

// PossibleKubeletDiskTypeValues returns the possible values for the KubeletDiskType const type.
func PossibleKubeletDiskTypeValues() []KubeletDiskType {
	return []KubeletDiskType{
		KubeletDiskTypeOS,
		KubeletDiskTypeTemporary,
	}
}

// ToPtr returns a *KubeletDiskType pointing to the current value.
func (c KubeletDiskType) ToPtr() *KubeletDiskType {
	return &c
}

// LicenseType - The license type to use for Windows VMs. See Azure Hybrid User Benefits [https://azure.microsoft.com/pricing/hybrid-benefit/faq/] for more
// details.
type LicenseType string

const (
	// LicenseTypeNone - No additional licensing is applied.
	LicenseTypeNone LicenseType = "None"
	// LicenseTypeWindowsServer - Enables Azure Hybrid User Benefits for Windows VMs.
	LicenseTypeWindowsServer LicenseType = "Windows_Server"
)

// PossibleLicenseTypeValues returns the possible values for the LicenseType const type.
func PossibleLicenseTypeValues() []LicenseType {
	return []LicenseType{
		LicenseTypeNone,
		LicenseTypeWindowsServer,
	}
}

// ToPtr returns a *LicenseType pointing to the current value.
func (c LicenseType) ToPtr() *LicenseType {
	return &c
}

// LoadBalancerSKU - The default is 'standard'. See Azure Load Balancer SKUs [https://docs.microsoft.com/azure/load-balancer/skus] for more information
// about the differences between load balancer SKUs.
type LoadBalancerSKU string

const (
	// LoadBalancerSKUBasic - Use a basic Load Balancer with limited functionality.
	LoadBalancerSKUBasic LoadBalancerSKU = "basic"
	// LoadBalancerSKUStandard - Use a a standard Load Balancer. This is the recommended Load Balancer SKU. For more information about on working with the load
	// balancer in the managed cluster, see the [standard Load Balancer](https://docs.microsoft.com/azure/aks/load-balancer-standard) article.
	LoadBalancerSKUStandard LoadBalancerSKU = "standard"
)

// PossibleLoadBalancerSKUValues returns the possible values for the LoadBalancerSKU const type.
func PossibleLoadBalancerSKUValues() []LoadBalancerSKU {
	return []LoadBalancerSKU{
		LoadBalancerSKUBasic,
		LoadBalancerSKUStandard,
	}
}

// ToPtr returns a *LoadBalancerSKU pointing to the current value.
func (c LoadBalancerSKU) ToPtr() *LoadBalancerSKU {
	return &c
}

// ManagedClusterPodIdentityProvisioningState - The current provisioning state of the pod identity.
type ManagedClusterPodIdentityProvisioningState string

const (
	ManagedClusterPodIdentityProvisioningStateAssigned ManagedClusterPodIdentityProvisioningState = "Assigned"
	ManagedClusterPodIdentityProvisioningStateDeleting ManagedClusterPodIdentityProvisioningState = "Deleting"
	ManagedClusterPodIdentityProvisioningStateFailed   ManagedClusterPodIdentityProvisioningState = "Failed"
	ManagedClusterPodIdentityProvisioningStateUpdating ManagedClusterPodIdentityProvisioningState = "Updating"
)

// PossibleManagedClusterPodIdentityProvisioningStateValues returns the possible values for the ManagedClusterPodIdentityProvisioningState const type.
func PossibleManagedClusterPodIdentityProvisioningStateValues() []ManagedClusterPodIdentityProvisioningState {
	return []ManagedClusterPodIdentityProvisioningState{
		ManagedClusterPodIdentityProvisioningStateAssigned,
		ManagedClusterPodIdentityProvisioningStateDeleting,
		ManagedClusterPodIdentityProvisioningStateFailed,
		ManagedClusterPodIdentityProvisioningStateUpdating,
	}
}

// ToPtr returns a *ManagedClusterPodIdentityProvisioningState pointing to the current value.
func (c ManagedClusterPodIdentityProvisioningState) ToPtr() *ManagedClusterPodIdentityProvisioningState {
	return &c
}

// ManagedClusterSKUName - The name of a managed cluster SKU.
type ManagedClusterSKUName string

const (
	ManagedClusterSKUNameBasic ManagedClusterSKUName = "Basic"
)

// PossibleManagedClusterSKUNameValues returns the possible values for the ManagedClusterSKUName const type.
func PossibleManagedClusterSKUNameValues() []ManagedClusterSKUName {
	return []ManagedClusterSKUName{
		ManagedClusterSKUNameBasic,
	}
}

// ToPtr returns a *ManagedClusterSKUName pointing to the current value.
func (c ManagedClusterSKUName) ToPtr() *ManagedClusterSKUName {
	return &c
}

// ManagedClusterSKUTier - If not specified, the default is 'Free'. See uptime SLA [https://docs.microsoft.com/azure/aks/uptime-sla] for more details.
type ManagedClusterSKUTier string

const (
	// ManagedClusterSKUTierFree - No guaranteed SLA, no additional charges. Free tier clusters have an SLO of 99.5%.
	ManagedClusterSKUTierFree ManagedClusterSKUTier = "Free"
	// ManagedClusterSKUTierPaid - Guarantees 99.95% availability of the Kubernetes API server endpoint for clusters that use Availability Zones and 99.9% of
	// availability for clusters that don't use Availability Zones.
	ManagedClusterSKUTierPaid ManagedClusterSKUTier = "Paid"
)

// PossibleManagedClusterSKUTierValues returns the possible values for the ManagedClusterSKUTier const type.
func PossibleManagedClusterSKUTierValues() []ManagedClusterSKUTier {
	return []ManagedClusterSKUTier{
		ManagedClusterSKUTierFree,
		ManagedClusterSKUTierPaid,
	}
}

// ToPtr returns a *ManagedClusterSKUTier pointing to the current value.
func (c ManagedClusterSKUTier) ToPtr() *ManagedClusterSKUTier {
	return &c
}

// NetworkMode - This cannot be specified if networkPlugin is anything other than 'azure'.
type NetworkMode string

const (
	// NetworkModeBridge - This is no longer supported
	NetworkModeBridge NetworkMode = "bridge"
	// NetworkModeTransparent - No bridge is created. Intra-VM Pod to Pod communication is through IP routes created by Azure CNI. See [Transparent Mode](https://docs.microsoft.com/azure/aks/faq#transparent-mode)
	// for more information.
	NetworkModeTransparent NetworkMode = "transparent"
)

// PossibleNetworkModeValues returns the possible values for the NetworkMode const type.
func PossibleNetworkModeValues() []NetworkMode {
	return []NetworkMode{
		NetworkModeBridge,
		NetworkModeTransparent,
	}
}

// ToPtr returns a *NetworkMode pointing to the current value.
func (c NetworkMode) ToPtr() *NetworkMode {
	return &c
}

// NetworkPlugin - Network plugin used for building the Kubernetes network.
type NetworkPlugin string

const (
	// NetworkPluginAzure - Use the Azure CNI network plugin. See [Azure CNI (advanced) networking](https://docs.microsoft.com/azure/aks/concepts-network#azure-cni-advanced-networking)
	// for more information.
	NetworkPluginAzure NetworkPlugin = "azure"
	// NetworkPluginKubenet - Use the Kubenet network plugin. See [Kubenet (basic) networking](https://docs.microsoft.com/azure/aks/concepts-network#kubenet-basic-networking)
	// for more information.
	NetworkPluginKubenet NetworkPlugin = "kubenet"
)

// PossibleNetworkPluginValues returns the possible values for the NetworkPlugin const type.
func PossibleNetworkPluginValues() []NetworkPlugin {
	return []NetworkPlugin{
		NetworkPluginAzure,
		NetworkPluginKubenet,
	}
}

// ToPtr returns a *NetworkPlugin pointing to the current value.
func (c NetworkPlugin) ToPtr() *NetworkPlugin {
	return &c
}

// NetworkPolicy - Network policy used for building the Kubernetes network.
type NetworkPolicy string

const (
	// NetworkPolicyAzure - Use Azure network policies. See [differences between Azure and Calico policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities)
	// for more information.
	NetworkPolicyAzure NetworkPolicy = "azure"
	// NetworkPolicyCalico - Use Calico network policies. See [differences between Azure and Calico policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities)
	// for more information.
	NetworkPolicyCalico NetworkPolicy = "calico"
)

// PossibleNetworkPolicyValues returns the possible values for the NetworkPolicy const type.
func PossibleNetworkPolicyValues() []NetworkPolicy {
	return []NetworkPolicy{
		NetworkPolicyAzure,
		NetworkPolicyCalico,
	}
}

// ToPtr returns a *NetworkPolicy pointing to the current value.
func (c NetworkPolicy) ToPtr() *NetworkPolicy {
	return &c
}

// OSDiskType - The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'.
// May not be changed after creation. For more information
// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
type OSDiskType string

const (
	// OSDiskTypeEphemeral - Ephemeral OS disks are stored only on the host machine, just like a temporary disk. This provides lower read/write latency, along
	// with faster node scaling and cluster upgrades.
	OSDiskTypeEphemeral OSDiskType = "Ephemeral"
	// OSDiskTypeManaged - Azure replicates the operating system disk for a virtual machine to Azure storage to avoid data loss should the VM need to be relocated
	// to another host. Since containers aren't designed to have local state persisted, this behavior offers limited value while providing some drawbacks, including
	// slower node provisioning and higher read/write latency.
	OSDiskTypeManaged OSDiskType = "Managed"
)

// PossibleOSDiskTypeValues returns the possible values for the OSDiskType const type.
func PossibleOSDiskTypeValues() []OSDiskType {
	return []OSDiskType{
		OSDiskTypeEphemeral,
		OSDiskTypeManaged,
	}
}

// ToPtr returns a *OSDiskType pointing to the current value.
func (c OSDiskType) ToPtr() *OSDiskType {
	return &c
}

// OSSKU - Specifies an OS SKU. This value must not be specified if OSType is Windows.
type OSSKU string

const (
	OSSKUCBLMariner OSSKU = "CBLMariner"
	OSSKUUbuntu     OSSKU = "Ubuntu"
)

// PossibleOSSKUValues returns the possible values for the OSSKU const type.
func PossibleOSSKUValues() []OSSKU {
	return []OSSKU{
		OSSKUCBLMariner,
		OSSKUUbuntu,
	}
}

// ToPtr returns a *OSSKU pointing to the current value.
func (c OSSKU) ToPtr() *OSSKU {
	return &c
}

// OSType - The operating system type. The default is Linux.
type OSType string

const (
	// OSTypeLinux - Use Linux.
	OSTypeLinux OSType = "Linux"
	// OSTypeWindows - Use Windows.
	OSTypeWindows OSType = "Windows"
)

// PossibleOSTypeValues returns the possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{
		OSTypeLinux,
		OSTypeWindows,
	}
}

// ToPtr returns a *OSType pointing to the current value.
func (c OSType) ToPtr() *OSType {
	return &c
}

// OutboundType - This can only be set at cluster creation time and cannot be changed later. For more information see egress outbound type [https://docs.microsoft.com/azure/aks/egress-outboundtype].
type OutboundType string

const (
	// OutboundTypeLoadBalancer - The load balancer is used for egress through an AKS assigned public IP. This supports Kubernetes services of type 'loadBalancer'.
	// For more information see [outbound type loadbalancer](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-loadbalancer).
	OutboundTypeLoadBalancer OutboundType = "loadBalancer"
	// OutboundTypeManagedNATGateway - The AKS-managed NAT gateway is used for egress.
	OutboundTypeManagedNATGateway OutboundType = "managedNATGateway"
	// OutboundTypeUserAssignedNATGateway - The user-assigned NAT gateway associated to the cluster subnet is used for egress. This is an advanced scenario
	// and requires proper network configuration.
	OutboundTypeUserAssignedNATGateway OutboundType = "userAssignedNATGateway"
	// OutboundTypeUserDefinedRouting - Egress paths must be defined by the user. This is an advanced scenario and requires proper network configuration. For
	// more information see [outbound type userDefinedRouting](https://docs.microsoft.com/azure/aks/egress-outboundtype#outbound-type-of-userdefinedrouting).
	OutboundTypeUserDefinedRouting OutboundType = "userDefinedRouting"
)

// PossibleOutboundTypeValues returns the possible values for the OutboundType const type.
func PossibleOutboundTypeValues() []OutboundType {
	return []OutboundType{
		OutboundTypeLoadBalancer,
		OutboundTypeManagedNATGateway,
		OutboundTypeUserAssignedNATGateway,
		OutboundTypeUserDefinedRouting,
	}
}

// ToPtr returns a *OutboundType pointing to the current value.
func (c OutboundType) ToPtr() *OutboundType {
	return &c
}

// PrivateEndpointConnectionProvisioningState - The current provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = "Creating"
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = "Deleting"
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = "Failed"
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns the possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{
		PrivateEndpointConnectionProvisioningStateCreating,
		PrivateEndpointConnectionProvisioningStateDeleting,
		PrivateEndpointConnectionProvisioningStateFailed,
		PrivateEndpointConnectionProvisioningStateSucceeded,
	}
}

// ToPtr returns a *PrivateEndpointConnectionProvisioningState pointing to the current value.
func (c PrivateEndpointConnectionProvisioningState) ToPtr() *PrivateEndpointConnectionProvisioningState {
	return &c
}

// PublicNetworkAccess - Default value is 'Enabled' (case insensitive). Could be set to 'Disabled' to enable private cluster
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled  PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// ToPtr returns a *PublicNetworkAccess pointing to the current value.
func (c PublicNetworkAccess) ToPtr() *PublicNetworkAccess {
	return &c
}

// ResourceIdentityType - For more information see use managed identities in AKS [https://docs.microsoft.com/azure/aks/use-managed-identity].
type ResourceIdentityType string

const (
	// ResourceIdentityTypeSystemAssigned - Use an implicitly created system assigned managed identity to manage cluster resources. Master components in the
	// control plane such as kube-controller-manager will use the system assigned managed identity to manipulate Azure resources.
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeUserAssigned - Use a user-specified identity to manage cluster resources. Master components in the control plane such as kube-controller-manager
	// will use the specified user assigned managed identity to manipulate Azure resources.
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
	// ResourceIdentityTypeNone - Do not use a managed identity for the Managed Cluster, service principal will be used instead.
	ResourceIdentityTypeNone ResourceIdentityType = "None"
)

// PossibleResourceIdentityTypeValues returns the possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{
		ResourceIdentityTypeSystemAssigned,
		ResourceIdentityTypeUserAssigned,
		ResourceIdentityTypeNone,
	}
}

// ToPtr returns a *ResourceIdentityType pointing to the current value.
func (c ResourceIdentityType) ToPtr() *ResourceIdentityType {
	return &c
}

// ScaleDownMode - Describes how VMs are added to or removed from Agent Pools. See billing states [https://docs.microsoft.com/azure/virtual-machines/states-billing].
type ScaleDownMode string

const (
	// ScaleDownModeDeallocate - Attempt to start deallocated instances (if they exist) during scale up and deallocate instances during scale down.
	ScaleDownModeDeallocate ScaleDownMode = "Deallocate"
	// ScaleDownModeDelete - Create new instances during scale up and remove instances during scale down.
	ScaleDownModeDelete ScaleDownMode = "Delete"
)

// PossibleScaleDownModeValues returns the possible values for the ScaleDownMode const type.
func PossibleScaleDownModeValues() []ScaleDownMode {
	return []ScaleDownMode{
		ScaleDownModeDeallocate,
		ScaleDownModeDelete,
	}
}

// ToPtr returns a *ScaleDownMode pointing to the current value.
func (c ScaleDownMode) ToPtr() *ScaleDownMode {
	return &c
}

// ScaleSetEvictionPolicy - The eviction policy specifies what to do with the VM when it is evicted. The default is Delete. For more information about eviction
// see spot VMs
// [https://docs.microsoft.com/azure/virtual-machines/spot-vms]
type ScaleSetEvictionPolicy string

const (
	// ScaleSetEvictionPolicyDeallocate - Nodes in the underlying Scale Set of the node pool are set to the stopped-deallocated state upon eviction. Nodes in
	// the stopped-deallocated state count against your compute quota and can cause issues with cluster scaling or upgrading.
	ScaleSetEvictionPolicyDeallocate ScaleSetEvictionPolicy = "Deallocate"
	// ScaleSetEvictionPolicyDelete - Nodes in the underlying Scale Set of the node pool are deleted when they're evicted.
	ScaleSetEvictionPolicyDelete ScaleSetEvictionPolicy = "Delete"
)

// PossibleScaleSetEvictionPolicyValues returns the possible values for the ScaleSetEvictionPolicy const type.
func PossibleScaleSetEvictionPolicyValues() []ScaleSetEvictionPolicy {
	return []ScaleSetEvictionPolicy{
		ScaleSetEvictionPolicyDeallocate,
		ScaleSetEvictionPolicyDelete,
	}
}

// ToPtr returns a *ScaleSetEvictionPolicy pointing to the current value.
func (c ScaleSetEvictionPolicy) ToPtr() *ScaleSetEvictionPolicy {
	return &c
}

// ScaleSetPriority - The Virtual Machine Scale Set priority.
type ScaleSetPriority string

const (
	// ScaleSetPriorityRegular - Regular VMs will be used.
	ScaleSetPriorityRegular ScaleSetPriority = "Regular"
	// ScaleSetPrioritySpot - Spot priority VMs will be used. There is no SLA for spot nodes. See [spot on AKS](https://docs.microsoft.com/azure/aks/spot-node-pool)
	// for more information.
	ScaleSetPrioritySpot ScaleSetPriority = "Spot"
)

// PossibleScaleSetPriorityValues returns the possible values for the ScaleSetPriority const type.
func PossibleScaleSetPriorityValues() []ScaleSetPriority {
	return []ScaleSetPriority{
		ScaleSetPriorityRegular,
		ScaleSetPrioritySpot,
	}
}

// ToPtr returns a *ScaleSetPriority pointing to the current value.
func (c ScaleSetPriority) ToPtr() *ScaleSetPriority {
	return &c
}

// SnapshotType - The type of a snapshot. The default is NodePool.
type SnapshotType string

const (
	// SnapshotTypeNodePool - The snapshot is a snapshot of a node pool.
	SnapshotTypeNodePool SnapshotType = "NodePool"
)

// PossibleSnapshotTypeValues returns the possible values for the SnapshotType const type.
func PossibleSnapshotTypeValues() []SnapshotType {
	return []SnapshotType{
		SnapshotTypeNodePool,
	}
}

// ToPtr returns a *SnapshotType pointing to the current value.
func (c SnapshotType) ToPtr() *SnapshotType {
	return &c
}

// UpgradeChannel - For more information see setting the AKS cluster auto-upgrade channel [https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel].
type UpgradeChannel string

const (
	// UpgradeChannelNodeImage - Automatically upgrade the node image to the latest version available. Microsoft provides patches and new images for image nodes
	// frequently (usually weekly), but your running nodes won't get the new images unless you do a node image upgrade. Turning on the node-image channel will
	// automatically update your node images whenever a new version is available.
	UpgradeChannelNodeImage UpgradeChannel = "node-image"
	// UpgradeChannelNone - Disables auto-upgrades and keeps the cluster at its current version of Kubernetes.
	UpgradeChannelNone UpgradeChannel = "none"
	// UpgradeChannelPatch - Automatically upgrade the cluster to the latest supported patch version when it becomes available while keeping the minor version
	// the same. For example, if a cluster is running version 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster is upgraded
	// to 1.17.9.
	UpgradeChannelPatch UpgradeChannel = "patch"
	// UpgradeChannelRapid - Automatically upgrade the cluster to the latest supported patch release on the latest supported minor version. In cases where the
	// cluster is at a version of Kubernetes that is at an N-2 minor version where N is the latest supported minor version, the cluster first upgrades to the
	// latest supported patch version on N-1 minor version. For example, if a cluster is running version 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1
	// are available, your cluster first is upgraded to 1.18.6, then is upgraded to 1.19.1.
	UpgradeChannelRapid UpgradeChannel = "rapid"
	// UpgradeChannelStable - Automatically upgrade the cluster to the latest supported patch release on minor version N-1, where N is the latest supported
	// minor version. For example, if a cluster is running version 1.17.7 and versions 1.17.9, 1.18.4, 1.18.6, and 1.19.1 are available, your cluster is upgraded
	// to 1.18.6.
	UpgradeChannelStable UpgradeChannel = "stable"
)

// PossibleUpgradeChannelValues returns the possible values for the UpgradeChannel const type.
func PossibleUpgradeChannelValues() []UpgradeChannel {
	return []UpgradeChannel{
		UpgradeChannelNodeImage,
		UpgradeChannelNone,
		UpgradeChannelPatch,
		UpgradeChannelRapid,
		UpgradeChannelStable,
	}
}

// ToPtr returns a *UpgradeChannel pointing to the current value.
func (c UpgradeChannel) ToPtr() *UpgradeChannel {
	return &c
}

// WeekDay - The weekday enum.
type WeekDay string

const (
	WeekDayFriday    WeekDay = "Friday"
	WeekDayMonday    WeekDay = "Monday"
	WeekDaySaturday  WeekDay = "Saturday"
	WeekDaySunday    WeekDay = "Sunday"
	WeekDayThursday  WeekDay = "Thursday"
	WeekDayTuesday   WeekDay = "Tuesday"
	WeekDayWednesday WeekDay = "Wednesday"
)

// PossibleWeekDayValues returns the possible values for the WeekDay const type.
func PossibleWeekDayValues() []WeekDay {
	return []WeekDay{
		WeekDayFriday,
		WeekDayMonday,
		WeekDaySaturday,
		WeekDaySunday,
		WeekDayThursday,
		WeekDayTuesday,
		WeekDayWednesday,
	}
}

// ToPtr returns a *WeekDay pointing to the current value.
func (c WeekDay) ToPtr() *WeekDay {
	return &c
}

// WorkloadRuntime - Determines the type of workload a node can run.
type WorkloadRuntime string

const (
	// WorkloadRuntimeOCIContainer - Nodes will use Kubelet to run standard OCI container workloads.
	WorkloadRuntimeOCIContainer WorkloadRuntime = "OCIContainer"
	// WorkloadRuntimeWasmWasi - Nodes will use Krustlet to run WASM workloads using the WASI provider (Preview).
	WorkloadRuntimeWasmWasi WorkloadRuntime = "WasmWasi"
)

// PossibleWorkloadRuntimeValues returns the possible values for the WorkloadRuntime const type.
func PossibleWorkloadRuntimeValues() []WorkloadRuntime {
	return []WorkloadRuntime{
		WorkloadRuntimeOCIContainer,
		WorkloadRuntimeWasmWasi,
	}
}

// ToPtr returns a *WorkloadRuntime pointing to the current value.
func (c WorkloadRuntime) ToPtr() *WorkloadRuntime {
	return &c
}
