// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1beta1/destination_rule.proto

// `DestinationRule` defines policies that apply to traffic intended for a
// service after routing has occurred. These rules specify configuration
// for load balancing, connection pool size from the sidecar, and outlier
// detection settings to detect and evict unhealthy hosts from the load
// balancing pool. For example, a simple load balancing policy for the
// ratings service would look as follows:
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_CONN
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_CONN
// ```
// {{</tab>}}
// {{</tabset>}}
//
// Version specific policies can be specified by defining a named
// `subset` and overriding the settings specified at the service level. The
// following rule uses a round robin load balancing policy for all traffic
// going to a subset named testversion that is composed of endpoints (e.g.,
// pods) with labels (version:v3).
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_CONN
//   subsets:
//   - name: testversion
//     labels:
//       version: v3
//     trafficPolicy:
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_CONN
//   subsets:
//   - name: testversion
//     labels:
//       version: v3
//     trafficPolicy:
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
// {{</tab>}}
// {{</tabset>}}
//
// **Note:** Policies specified for subsets will not take effect until
// a route rule explicitly sends traffic to this subset.
//
// Traffic policies can be customized to specific ports as well. The
// following rule uses the least connection load balancing policy for all
// traffic to port 80, while uses a round robin load balancing setting for
// traffic to the port 9080.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings-port
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy: # Apply to all ports
//     portLevelSettings:
//     - port:
//         number: 80
//       loadBalancer:
//         simple: LEAST_CONN
//     - port:
//         number: 9080
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings-port
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy: # Apply to all ports
//     portLevelSettings:
//     - port:
//         number: 80
//       loadBalancer:
//         simple: LEAST_CONN
//     - port:
//         number: 9080
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
// {{</tab>}}
// {{</tabset>}}
//

package v1beta1

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Standard load balancing algorithms that require no tuning.
type LoadBalancerSettings_SimpleLB int32

const (
	// Round Robin policy. Default
	LoadBalancerSettings_ROUND_ROBIN LoadBalancerSettings_SimpleLB = 0
	// The least request load balancer uses an O(1) algorithm which selects
	// two random healthy hosts and picks the host which has fewer active
	// requests.
	LoadBalancerSettings_LEAST_CONN LoadBalancerSettings_SimpleLB = 1
	// The random load balancer selects a random healthy host. The random
	// load balancer generally performs better than round robin if no health
	// checking policy is configured.
	LoadBalancerSettings_RANDOM LoadBalancerSettings_SimpleLB = 2
	// This option will forward the connection to the original IP address
	// requested by the caller without doing any form of load
	// balancing. This option must be used with care. It is meant for
	// advanced use cases. Refer to Original Destination load balancer in
	// Envoy for further details.
	LoadBalancerSettings_PASSTHROUGH LoadBalancerSettings_SimpleLB = 3
)

var LoadBalancerSettings_SimpleLB_name = map[int32]string{
	0: "ROUND_ROBIN",
	1: "LEAST_CONN",
	2: "RANDOM",
	3: "PASSTHROUGH",
}

var LoadBalancerSettings_SimpleLB_value = map[string]int32{
	"ROUND_ROBIN": 0,
	"LEAST_CONN":  1,
	"RANDOM":      2,
	"PASSTHROUGH": 3,
}

func (x LoadBalancerSettings_SimpleLB) String() string {
	return proto.EnumName(LoadBalancerSettings_SimpleLB_name, int32(x))
}

func (LoadBalancerSettings_SimpleLB) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{3, 0}
}

// Policy for upgrading http1.1 connections to http2.
type ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy int32

const (
	// Use the global default.
	ConnectionPoolSettings_HTTPSettings_DEFAULT ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy = 0
	// Do not upgrade the connection to http2.
	// This opt-out option overrides the default.
	ConnectionPoolSettings_HTTPSettings_DO_NOT_UPGRADE ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy = 1
	// Upgrade the connection to http2.
	// This opt-in option overrides the default.
	ConnectionPoolSettings_HTTPSettings_UPGRADE ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy = 2
)

var ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy_name = map[int32]string{
	0: "DEFAULT",
	1: "DO_NOT_UPGRADE",
	2: "UPGRADE",
}

var ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy_value = map[string]int32{
	"DEFAULT":        0,
	"DO_NOT_UPGRADE": 1,
	"UPGRADE":        2,
}

func (x ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) String() string {
	return proto.EnumName(ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy_name, int32(x))
}

func (ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{4, 1, 0}
}

// TLS connection mode
type ClientTLSSettings_TLSmode int32

const (
	// Do not setup a TLS connection to the upstream endpoint.
	ClientTLSSettings_DISABLE ClientTLSSettings_TLSmode = 0
	// Originate a TLS connection to the upstream endpoint.
	ClientTLSSettings_SIMPLE ClientTLSSettings_TLSmode = 1
	// Secure connections to the upstream using mutual TLS by presenting
	// client certificates for authentication.
	ClientTLSSettings_MUTUAL ClientTLSSettings_TLSmode = 2
	// Secure connections to the upstream using mutual TLS by presenting
	// client certificates for authentication.
	// Compared to Mutual mode, this mode uses certificates generated
	// automatically by Istio for mTLS authentication. When this mode is
	// used, all other fields in `ClientTLSSettings` should be empty.
	ClientTLSSettings_ISTIO_MUTUAL ClientTLSSettings_TLSmode = 3
)

var ClientTLSSettings_TLSmode_name = map[int32]string{
	0: "DISABLE",
	1: "SIMPLE",
	2: "MUTUAL",
	3: "ISTIO_MUTUAL",
}

var ClientTLSSettings_TLSmode_value = map[string]int32{
	"DISABLE":      0,
	"SIMPLE":       1,
	"MUTUAL":       2,
	"ISTIO_MUTUAL": 3,
}

func (x ClientTLSSettings_TLSmode) String() string {
	return proto.EnumName(ClientTLSSettings_TLSmode_name, int32(x))
}

func (ClientTLSSettings_TLSmode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{6, 0}
}

// DestinationRule defines policies that apply to traffic intended for a service
// after routing has occurred.
//
// <!-- crd generation tags
// +cue-gen:DestinationRule:groupName:networking.istio.io
// +cue-gen:DestinationRule:version:v1beta1
// +cue-gen:DestinationRule:annotations:helm.sh/resource-policy=keep
// +cue-gen:DestinationRule:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:DestinationRule:subresource:status
// +cue-gen:DestinationRule:scope:Namespaced
// +cue-gen:DestinationRule:resource:categories=istio-io,networking-istio-io,shortNames=dr
// +cue-gen:DestinationRule:printerColumn:name=Host,type=string,JSONPath=.spec.host,description="The name of a service from the service registry"
// +cue-gen:DestinationRule:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// +cue-gen:DestinationRule:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1beta1
// +genclient
// +k8s:deepcopy-gen=true
// -->
type DestinationRule struct {
	// The name of a service from the service registry. Service
	// names are looked up from the platform's service registry (e.g.,
	// Kubernetes services, Consul services, etc.) and from the hosts
	// declared by [ServiceEntries](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Rules defined for
	// services that do not exist in the service registry will be ignored.
	//
	// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
	// instead of "reviews.default.svc.cluster.local"), Istio will interpret
	// the short name based on the namespace of the rule, not the service. A
	// rule in the "default" namespace containing a host "reviews" will be
	// interpreted as "reviews.default.svc.cluster.local", irrespective of
	// the actual namespace associated with the reviews service. _To avoid
	// potential misconfigurations, it is recommended to always use fully
	// qualified domain names over short names._
	//
	// Note that the host field applies to both HTTP and TCP services.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Traffic policies to apply (load balancing policy, connection pool
	// sizes, outlier detection).
	TrafficPolicy *TrafficPolicy `protobuf:"bytes,2,opt,name=traffic_policy,json=trafficPolicy,proto3" json:"traffic_policy,omitempty"`
	// One or more named sets that represent individual versions of a
	// service. Traffic policies can be overridden at subset level.
	Subsets []*Subset `protobuf:"bytes,3,rep,name=subsets,proto3" json:"subsets,omitempty"`
	// A list of namespaces to which this destination rule is exported.
	// The resolution of a destination rule to apply to a service occurs in the
	// context of a hierarchy of namespaces. Exporting a destination rule allows
	// it to be included in the resolution hierarchy for services in
	// other namespaces. This feature provides a mechanism for service owners
	// and mesh administrators to control the visibility of destination rules
	// across namespace boundaries.
	//
	// If no namespaces are specified then the destination rule is exported to all
	// namespaces by default.
	//
	// The value "." is reserved and defines an export to the same namespace that
	// the destination rule is declared in. Similarly, the value "*" is reserved and
	// defines an export to all namespaces.
	ExportTo             []string `protobuf:"bytes,4,rep,name=export_to,json=exportTo,proto3" json:"export_to,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestinationRule) Reset()         { *m = DestinationRule{} }
func (m *DestinationRule) String() string { return proto.CompactTextString(m) }
func (*DestinationRule) ProtoMessage()    {}
func (*DestinationRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{0}
}
func (m *DestinationRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DestinationRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DestinationRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DestinationRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestinationRule.Merge(m, src)
}
func (m *DestinationRule) XXX_Size() int {
	return m.Size()
}
func (m *DestinationRule) XXX_DiscardUnknown() {
	xxx_messageInfo_DestinationRule.DiscardUnknown(m)
}

var xxx_messageInfo_DestinationRule proto.InternalMessageInfo

func (m *DestinationRule) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *DestinationRule) GetTrafficPolicy() *TrafficPolicy {
	if m != nil {
		return m.TrafficPolicy
	}
	return nil
}

func (m *DestinationRule) GetSubsets() []*Subset {
	if m != nil {
		return m.Subsets
	}
	return nil
}

func (m *DestinationRule) GetExportTo() []string {
	if m != nil {
		return m.ExportTo
	}
	return nil
}

// Traffic policies to apply for a specific destination, across all
// destination ports. See DestinationRule for examples.
type TrafficPolicy struct {
	// Settings controlling the load balancer algorithms.
	LoadBalancer *LoadBalancerSettings `protobuf:"bytes,1,opt,name=load_balancer,json=loadBalancer,proto3" json:"load_balancer,omitempty"`
	// Settings controlling the volume of connections to an upstream service
	ConnectionPool *ConnectionPoolSettings `protobuf:"bytes,2,opt,name=connection_pool,json=connectionPool,proto3" json:"connection_pool,omitempty"`
	// Settings controlling eviction of unhealthy hosts from the load balancing pool
	OutlierDetection *OutlierDetection `protobuf:"bytes,3,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	// TLS related settings for connections to the upstream service.
	Tls *ClientTLSSettings `protobuf:"bytes,4,opt,name=tls,proto3" json:"tls,omitempty"`
	// Traffic policies specific to individual ports. Note that port level
	// settings will override the destination-level settings. Traffic
	// settings specified at the destination-level will not be inherited when
	// overridden by port-level settings, i.e. default values will be applied
	// to fields omitted in port-level traffic policies.
	PortLevelSettings    []*TrafficPolicy_PortTrafficPolicy `protobuf:"bytes,5,rep,name=port_level_settings,json=portLevelSettings,proto3" json:"port_level_settings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *TrafficPolicy) Reset()         { *m = TrafficPolicy{} }
func (m *TrafficPolicy) String() string { return proto.CompactTextString(m) }
func (*TrafficPolicy) ProtoMessage()    {}
func (*TrafficPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{1}
}
func (m *TrafficPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TrafficPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TrafficPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TrafficPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrafficPolicy.Merge(m, src)
}
func (m *TrafficPolicy) XXX_Size() int {
	return m.Size()
}
func (m *TrafficPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_TrafficPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_TrafficPolicy proto.InternalMessageInfo

func (m *TrafficPolicy) GetLoadBalancer() *LoadBalancerSettings {
	if m != nil {
		return m.LoadBalancer
	}
	return nil
}

func (m *TrafficPolicy) GetConnectionPool() *ConnectionPoolSettings {
	if m != nil {
		return m.ConnectionPool
	}
	return nil
}

func (m *TrafficPolicy) GetOutlierDetection() *OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *TrafficPolicy) GetTls() *ClientTLSSettings {
	if m != nil {
		return m.Tls
	}
	return nil
}

func (m *TrafficPolicy) GetPortLevelSettings() []*TrafficPolicy_PortTrafficPolicy {
	if m != nil {
		return m.PortLevelSettings
	}
	return nil
}

// Traffic policies that apply to specific ports of the service
type TrafficPolicy_PortTrafficPolicy struct {
	// Specifies the number of a port on the destination service
	// on which this policy is being applied.
	//
	Port *PortSelector `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	// Settings controlling the load balancer algorithms.
	LoadBalancer *LoadBalancerSettings `protobuf:"bytes,2,opt,name=load_balancer,json=loadBalancer,proto3" json:"load_balancer,omitempty"`
	// Settings controlling the volume of connections to an upstream service
	ConnectionPool *ConnectionPoolSettings `protobuf:"bytes,3,opt,name=connection_pool,json=connectionPool,proto3" json:"connection_pool,omitempty"`
	// Settings controlling eviction of unhealthy hosts from the load balancing pool
	OutlierDetection *OutlierDetection `protobuf:"bytes,4,opt,name=outlier_detection,json=outlierDetection,proto3" json:"outlier_detection,omitempty"`
	// TLS related settings for connections to the upstream service.
	Tls                  *ClientTLSSettings `protobuf:"bytes,5,opt,name=tls,proto3" json:"tls,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TrafficPolicy_PortTrafficPolicy) Reset()         { *m = TrafficPolicy_PortTrafficPolicy{} }
func (m *TrafficPolicy_PortTrafficPolicy) String() string { return proto.CompactTextString(m) }
func (*TrafficPolicy_PortTrafficPolicy) ProtoMessage()    {}
func (*TrafficPolicy_PortTrafficPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{1, 0}
}
func (m *TrafficPolicy_PortTrafficPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TrafficPolicy_PortTrafficPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TrafficPolicy_PortTrafficPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TrafficPolicy_PortTrafficPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrafficPolicy_PortTrafficPolicy.Merge(m, src)
}
func (m *TrafficPolicy_PortTrafficPolicy) XXX_Size() int {
	return m.Size()
}
func (m *TrafficPolicy_PortTrafficPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_TrafficPolicy_PortTrafficPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_TrafficPolicy_PortTrafficPolicy proto.InternalMessageInfo

func (m *TrafficPolicy_PortTrafficPolicy) GetPort() *PortSelector {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetLoadBalancer() *LoadBalancerSettings {
	if m != nil {
		return m.LoadBalancer
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetConnectionPool() *ConnectionPoolSettings {
	if m != nil {
		return m.ConnectionPool
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetOutlierDetection() *OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetTls() *ClientTLSSettings {
	if m != nil {
		return m.Tls
	}
	return nil
}

// A subset of endpoints of a service. Subsets can be used for scenarios
// like A/B testing, or routing to a specific version of a service. Refer
// to [VirtualService](https://istio.io/docs/reference/config/networking/virtual-service/#VirtualService) documentation for examples of using
// subsets in these scenarios. In addition, traffic policies defined at the
// service-level can be overridden at a subset-level. The following rule
// uses a round robin load balancing policy for all traffic going to a
// subset named testversion that is composed of endpoints (e.g., pods) with
// labels (version:v3).
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_CONN
//   subsets:
//   - name: testversion
//     labels:
//       version: v3
//     trafficPolicy:
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: LEAST_CONN
//   subsets:
//   - name: testversion
//     labels:
//       version: v3
//     trafficPolicy:
//       loadBalancer:
//         simple: ROUND_ROBIN
// ```
// {{</tab>}}
// {{</tabset>}}
//
// **Note:** Policies specified for subsets will not take effect until
// a route rule explicitly sends traffic to this subset.
//
// One or more labels are typically required to identify the subset destination,
// however, when the corresponding DestinationRule represents a host that
// supports multiple SNI hosts (e.g., an egress gateway), a subset without labels
// may be meaningful. In this case a traffic policy with [ClientTLSSettings](#ClientTLSSettings)
// can be used to identify a specific SNI host corresponding to the named subset.
type Subset struct {
	// Name of the subset. The service name and the subset name can
	// be used for traffic splitting in a route rule.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Labels apply a filter over the endpoints of a service in the
	// service registry. See route rules for examples of usage.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Traffic policies that apply to this subset. Subsets inherit the
	// traffic policies specified at the DestinationRule level. Settings
	// specified at the subset level will override the corresponding settings
	// specified at the DestinationRule level.
	TrafficPolicy        *TrafficPolicy `protobuf:"bytes,3,opt,name=traffic_policy,json=trafficPolicy,proto3" json:"traffic_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Subset) Reset()         { *m = Subset{} }
func (m *Subset) String() string { return proto.CompactTextString(m) }
func (*Subset) ProtoMessage()    {}
func (*Subset) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{2}
}
func (m *Subset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Subset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Subset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subset.Merge(m, src)
}
func (m *Subset) XXX_Size() int {
	return m.Size()
}
func (m *Subset) XXX_DiscardUnknown() {
	xxx_messageInfo_Subset.DiscardUnknown(m)
}

var xxx_messageInfo_Subset proto.InternalMessageInfo

func (m *Subset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subset) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Subset) GetTrafficPolicy() *TrafficPolicy {
	if m != nil {
		return m.TrafficPolicy
	}
	return nil
}

// Load balancing policies to apply for a specific destination. See Envoy's
// load balancing
// [documentation](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/load_balancing)
// for more details.
//
// For example, the following rule uses a round robin load balancing policy
// for all traffic going to the ratings service.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: ROUND_ROBIN
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: bookinfo-ratings
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     loadBalancer:
//       simple: ROUND_ROBIN
// ```
// {{</tab>}}
// {{</tabset>}}
//
// The following example sets up sticky sessions for the ratings service
// hashing-based load balancer for the same ratings service using the
// the User cookie as the hash key.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
//  apiVersion: networking.istio.io/v1alpha3
//  kind: DestinationRule
//  metadata:
//    name: bookinfo-ratings
//  spec:
//    host: ratings.prod.svc.cluster.local
//    trafficPolicy:
//      loadBalancer:
//        consistentHash:
//          httpCookie:
//            name: user
//            ttl: 0s
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
//  apiVersion: networking.istio.io/v1beta1
//  kind: DestinationRule
//  metadata:
//    name: bookinfo-ratings
//  spec:
//    host: ratings.prod.svc.cluster.local
//    trafficPolicy:
//      loadBalancer:
//        consistentHash:
//          httpCookie:
//            name: user
//            ttl: 0s
// ```
// {{</tab>}}
// {{</tabset>}}
//
type LoadBalancerSettings struct {
	// Upstream load balancing policy.
	//
	// Types that are valid to be assigned to LbPolicy:
	//	*LoadBalancerSettings_Simple
	//	*LoadBalancerSettings_ConsistentHash
	LbPolicy isLoadBalancerSettings_LbPolicy `protobuf_oneof:"lb_policy"`
	// Locality load balancer settings, this will override mesh wide settings in entirety, meaning no merging would be performed
	// between this object and the object one in MeshConfig
	LocalityLbSetting    *LocalityLoadBalancerSetting `protobuf:"bytes,3,opt,name=locality_lb_setting,json=localityLbSetting,proto3" json:"locality_lb_setting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *LoadBalancerSettings) Reset()         { *m = LoadBalancerSettings{} }
func (m *LoadBalancerSettings) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerSettings) ProtoMessage()    {}
func (*LoadBalancerSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{3}
}
func (m *LoadBalancerSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadBalancerSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadBalancerSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadBalancerSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerSettings.Merge(m, src)
}
func (m *LoadBalancerSettings) XXX_Size() int {
	return m.Size()
}
func (m *LoadBalancerSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerSettings.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerSettings proto.InternalMessageInfo

type isLoadBalancerSettings_LbPolicy interface {
	isLoadBalancerSettings_LbPolicy()
	MarshalTo([]byte) (int, error)
	Size() int
}

type LoadBalancerSettings_Simple struct {
	Simple LoadBalancerSettings_SimpleLB `protobuf:"varint,1,opt,name=simple,proto3,enum=istio.networking.v1beta1.LoadBalancerSettings_SimpleLB,oneof" json:"simple,omitempty"`
}
type LoadBalancerSettings_ConsistentHash struct {
	ConsistentHash *LoadBalancerSettings_ConsistentHashLB `protobuf:"bytes,2,opt,name=consistent_hash,json=consistentHash,proto3,oneof" json:"consistent_hash,omitempty"`
}

func (*LoadBalancerSettings_Simple) isLoadBalancerSettings_LbPolicy()         {}
func (*LoadBalancerSettings_ConsistentHash) isLoadBalancerSettings_LbPolicy() {}

func (m *LoadBalancerSettings) GetLbPolicy() isLoadBalancerSettings_LbPolicy {
	if m != nil {
		return m.LbPolicy
	}
	return nil
}

func (m *LoadBalancerSettings) GetSimple() LoadBalancerSettings_SimpleLB {
	if x, ok := m.GetLbPolicy().(*LoadBalancerSettings_Simple); ok {
		return x.Simple
	}
	return LoadBalancerSettings_ROUND_ROBIN
}

func (m *LoadBalancerSettings) GetConsistentHash() *LoadBalancerSettings_ConsistentHashLB {
	if x, ok := m.GetLbPolicy().(*LoadBalancerSettings_ConsistentHash); ok {
		return x.ConsistentHash
	}
	return nil
}

func (m *LoadBalancerSettings) GetLocalityLbSetting() *LocalityLoadBalancerSetting {
	if m != nil {
		return m.LocalityLbSetting
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LoadBalancerSettings) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LoadBalancerSettings_Simple)(nil),
		(*LoadBalancerSettings_ConsistentHash)(nil),
	}
}

// Consistent Hash-based load balancing can be used to provide soft
// session affinity based on HTTP headers, cookies or other
// properties. This load balancing policy is applicable only for HTTP
// connections. The affinity to a particular destination host will be
// lost when one or more hosts are added/removed from the destination
// service.
type LoadBalancerSettings_ConsistentHashLB struct {
	// The hash key to use.
	//
	// Types that are valid to be assigned to HashKey:
	//	*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName
	//	*LoadBalancerSettings_ConsistentHashLB_HttpCookie
	//	*LoadBalancerSettings_ConsistentHashLB_UseSourceIp
	//	*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName
	HashKey isLoadBalancerSettings_ConsistentHashLB_HashKey `protobuf_oneof:"hash_key"`
	// The minimum number of virtual nodes to use for the hash
	// ring. Defaults to 1024. Larger ring sizes result in more granular
	// load distributions. If the number of hosts in the load balancing
	// pool is larger than the ring size, each host will be assigned a
	// single virtual node.
	MinimumRingSize      uint64   `protobuf:"varint,4,opt,name=minimum_ring_size,json=minimumRingSize,proto3" json:"minimum_ring_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoadBalancerSettings_ConsistentHashLB) Reset()         { *m = LoadBalancerSettings_ConsistentHashLB{} }
func (m *LoadBalancerSettings_ConsistentHashLB) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerSettings_ConsistentHashLB) ProtoMessage()    {}
func (*LoadBalancerSettings_ConsistentHashLB) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{3, 0}
}
func (m *LoadBalancerSettings_ConsistentHashLB) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadBalancerSettings_ConsistentHashLB) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadBalancerSettings_ConsistentHashLB) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB.Merge(m, src)
}
func (m *LoadBalancerSettings_ConsistentHashLB) XXX_Size() int {
	return m.Size()
}
func (m *LoadBalancerSettings_ConsistentHashLB) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB proto.InternalMessageInfo

type isLoadBalancerSettings_ConsistentHashLB_HashKey interface {
	isLoadBalancerSettings_ConsistentHashLB_HashKey()
	MarshalTo([]byte) (int, error)
	Size() int
}

type LoadBalancerSettings_ConsistentHashLB_HttpHeaderName struct {
	HttpHeaderName string `protobuf:"bytes,1,opt,name=http_header_name,json=httpHeaderName,proto3,oneof" json:"http_header_name,omitempty"`
}
type LoadBalancerSettings_ConsistentHashLB_HttpCookie struct {
	HttpCookie *LoadBalancerSettings_ConsistentHashLB_HTTPCookie `protobuf:"bytes,2,opt,name=http_cookie,json=httpCookie,proto3,oneof" json:"http_cookie,omitempty"`
}
type LoadBalancerSettings_ConsistentHashLB_UseSourceIp struct {
	UseSourceIp bool `protobuf:"varint,3,opt,name=use_source_ip,json=useSourceIp,proto3,oneof" json:"use_source_ip,omitempty"`
}
type LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName struct {
	HttpQueryParameterName string `protobuf:"bytes,5,opt,name=http_query_parameter_name,json=httpQueryParameterName,proto3,oneof" json:"http_query_parameter_name,omitempty"`
}

func (*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}
func (*LoadBalancerSettings_ConsistentHashLB_HttpCookie) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}
func (*LoadBalancerSettings_ConsistentHashLB_UseSourceIp) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}
func (*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName) isLoadBalancerSettings_ConsistentHashLB_HashKey() {
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetHashKey() isLoadBalancerSettings_ConsistentHashLB_HashKey {
	if m != nil {
		return m.HashKey
	}
	return nil
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetHttpHeaderName() string {
	if x, ok := m.GetHashKey().(*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName); ok {
		return x.HttpHeaderName
	}
	return ""
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetHttpCookie() *LoadBalancerSettings_ConsistentHashLB_HTTPCookie {
	if x, ok := m.GetHashKey().(*LoadBalancerSettings_ConsistentHashLB_HttpCookie); ok {
		return x.HttpCookie
	}
	return nil
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetUseSourceIp() bool {
	if x, ok := m.GetHashKey().(*LoadBalancerSettings_ConsistentHashLB_UseSourceIp); ok {
		return x.UseSourceIp
	}
	return false
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetHttpQueryParameterName() string {
	if x, ok := m.GetHashKey().(*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName); ok {
		return x.HttpQueryParameterName
	}
	return ""
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetMinimumRingSize() uint64 {
	if m != nil {
		return m.MinimumRingSize
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LoadBalancerSettings_ConsistentHashLB) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LoadBalancerSettings_ConsistentHashLB_HttpHeaderName)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_HttpCookie)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_UseSourceIp)(nil),
		(*LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName)(nil),
	}
}

// Describes a HTTP cookie that will be used as the hash key for the
// Consistent Hash load balancer. If the cookie is not present, it will
// be generated.
type LoadBalancerSettings_ConsistentHashLB_HTTPCookie struct {
	// Name of the cookie.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path to set for the cookie.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Lifetime of the cookie.
	Ttl                  *types.Duration `protobuf:"bytes,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) Reset() {
	*m = LoadBalancerSettings_ConsistentHashLB_HTTPCookie{}
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) String() string {
	return proto.CompactTextString(m)
}
func (*LoadBalancerSettings_ConsistentHashLB_HTTPCookie) ProtoMessage() {}
func (*LoadBalancerSettings_ConsistentHashLB_HTTPCookie) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{3, 0, 0}
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB_HTTPCookie.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB_HTTPCookie.Merge(m, src)
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) XXX_Size() int {
	return m.Size()
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB_HTTPCookie.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerSettings_ConsistentHashLB_HTTPCookie proto.InternalMessageInfo

func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) GetTtl() *types.Duration {
	if m != nil {
		return m.Ttl
	}
	return nil
}

// Connection pool settings for an upstream host. The settings apply to
// each individual host in the upstream service.  See Envoy's [circuit
// breaker](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/circuit_breaking)
// for more details. Connection pool settings can be applied at the TCP
// level as well as at HTTP level.
//
// For example, the following rule sets a limit of 100 connections to redis
// service called myredissrv with a connect timeout of 30ms
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: bookinfo-redis
// spec:
//   host: myredissrv.prod.svc.cluster.local
//   trafficPolicy:
//     connectionPool:
//       tcp:
//         maxConnections: 100
//         connectTimeout: 30ms
//         tcpKeepalive:
//           time: 7200s
//           interval: 75s
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: bookinfo-redis
// spec:
//   host: myredissrv.prod.svc.cluster.local
//   trafficPolicy:
//     connectionPool:
//       tcp:
//         maxConnections: 100
//         connectTimeout: 30ms
//         tcpKeepalive:
//           time: 7200s
//           interval: 75s
// ```
// {{</tab>}}
// {{</tabset>}}
//
type ConnectionPoolSettings struct {
	// Settings common to both HTTP and TCP upstream connections.
	Tcp *ConnectionPoolSettings_TCPSettings `protobuf:"bytes,1,opt,name=tcp,proto3" json:"tcp,omitempty"`
	// HTTP connection pool settings.
	Http                 *ConnectionPoolSettings_HTTPSettings `protobuf:"bytes,2,opt,name=http,proto3" json:"http,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ConnectionPoolSettings) Reset()         { *m = ConnectionPoolSettings{} }
func (m *ConnectionPoolSettings) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolSettings) ProtoMessage()    {}
func (*ConnectionPoolSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{4}
}
func (m *ConnectionPoolSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectionPoolSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectionPoolSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectionPoolSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionPoolSettings.Merge(m, src)
}
func (m *ConnectionPoolSettings) XXX_Size() int {
	return m.Size()
}
func (m *ConnectionPoolSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionPoolSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionPoolSettings proto.InternalMessageInfo

func (m *ConnectionPoolSettings) GetTcp() *ConnectionPoolSettings_TCPSettings {
	if m != nil {
		return m.Tcp
	}
	return nil
}

func (m *ConnectionPoolSettings) GetHttp() *ConnectionPoolSettings_HTTPSettings {
	if m != nil {
		return m.Http
	}
	return nil
}

// Settings common to both HTTP and TCP upstream connections.
type ConnectionPoolSettings_TCPSettings struct {
	// Maximum number of HTTP1 /TCP connections to a destination host. Default 2^32-1.
	MaxConnections int32 `protobuf:"varint,1,opt,name=max_connections,json=maxConnections,proto3" json:"max_connections,omitempty"`
	// TCP connection timeout. format:
	// 1h/1m/1s/1ms. MUST BE >=1ms. Default is 10s.
	ConnectTimeout *types.Duration `protobuf:"bytes,2,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	// If set then set SO_KEEPALIVE on the socket to enable TCP Keepalives.
	TcpKeepalive         *ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,3,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *ConnectionPoolSettings_TCPSettings) Reset()         { *m = ConnectionPoolSettings_TCPSettings{} }
func (m *ConnectionPoolSettings_TCPSettings) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolSettings_TCPSettings) ProtoMessage()    {}
func (*ConnectionPoolSettings_TCPSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{4, 0}
}
func (m *ConnectionPoolSettings_TCPSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectionPoolSettings_TCPSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectionPoolSettings_TCPSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectionPoolSettings_TCPSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionPoolSettings_TCPSettings.Merge(m, src)
}
func (m *ConnectionPoolSettings_TCPSettings) XXX_Size() int {
	return m.Size()
}
func (m *ConnectionPoolSettings_TCPSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionPoolSettings_TCPSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionPoolSettings_TCPSettings proto.InternalMessageInfo

func (m *ConnectionPoolSettings_TCPSettings) GetMaxConnections() int32 {
	if m != nil {
		return m.MaxConnections
	}
	return 0
}

func (m *ConnectionPoolSettings_TCPSettings) GetConnectTimeout() *types.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return nil
}

func (m *ConnectionPoolSettings_TCPSettings) GetTcpKeepalive() *ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if m != nil {
		return m.TcpKeepalive
	}
	return nil
}

// TCP keepalive.
type ConnectionPoolSettings_TCPSettings_TcpKeepalive struct {
	// Maximum number of keepalive probes to send without response before
	// deciding the connection is dead. Default is to use the OS level configuration
	// (unless overridden, Linux defaults to 9.)
	Probes uint32 `protobuf:"varint,1,opt,name=probes,proto3" json:"probes,omitempty"`
	// The time duration a connection needs to be idle before keep-alive
	// probes start being sent. Default is to use the OS level configuration
	// (unless overridden, Linux defaults to 7200s (ie 2 hours.)
	Time *types.Duration `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// The time duration between keep-alive probes.
	// Default is to use the OS level configuration
	// (unless overridden, Linux defaults to 75s.)
	Interval             *types.Duration `protobuf:"bytes,3,opt,name=interval,proto3" json:"interval,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) Reset() {
	*m = ConnectionPoolSettings_TCPSettings_TcpKeepalive{}
}
func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) String() string {
	return proto.CompactTextString(m)
}
func (*ConnectionPoolSettings_TCPSettings_TcpKeepalive) ProtoMessage() {}
func (*ConnectionPoolSettings_TCPSettings_TcpKeepalive) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{4, 0, 0}
}
func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectionPoolSettings_TCPSettings_TcpKeepalive.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionPoolSettings_TCPSettings_TcpKeepalive.Merge(m, src)
}
func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) XXX_Size() int {
	return m.Size()
}
func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionPoolSettings_TCPSettings_TcpKeepalive.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionPoolSettings_TCPSettings_TcpKeepalive proto.InternalMessageInfo

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) GetProbes() uint32 {
	if m != nil {
		return m.Probes
	}
	return 0
}

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) GetTime() *types.Duration {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) GetInterval() *types.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

// Settings applicable to HTTP1.1/HTTP2/GRPC connections.
type ConnectionPoolSettings_HTTPSettings struct {
	// Maximum number of pending HTTP requests to a destination. Default 2^32-1.
	Http1MaxPendingRequests int32 `protobuf:"varint,1,opt,name=http1_max_pending_requests,json=http1MaxPendingRequests,proto3" json:"http1_max_pending_requests,omitempty"`
	// Maximum number of requests to a backend. Default 2^32-1.
	Http2MaxRequests int32 `protobuf:"varint,2,opt,name=http2_max_requests,json=http2MaxRequests,proto3" json:"http2_max_requests,omitempty"`
	// Maximum number of requests per connection to a backend. Setting this
	// parameter to 1 disables keep alive. Default 0, meaning "unlimited",
	// up to 2^29.
	MaxRequestsPerConnection int32 `protobuf:"varint,3,opt,name=max_requests_per_connection,json=maxRequestsPerConnection,proto3" json:"max_requests_per_connection,omitempty"`
	// Maximum number of retries that can be outstanding to all hosts in a
	// cluster at a given time. Defaults to 2^32-1.
	MaxRetries int32 `protobuf:"varint,4,opt,name=max_retries,json=maxRetries,proto3" json:"max_retries,omitempty"`
	// The idle timeout for upstream connection pool connections. The idle timeout
	// is defined as the period in which there are no active requests.
	// If not set, the default is 1 hour. When the idle timeout is reached,
	// the connection will be closed. If the connection is an HTTP/2
	// connection a drain sequence will occur prior to closing the connection.
	// Note that request based timeouts mean that HTTP/2 PINGs will not
	// keep the connection alive. Applies to both HTTP1.1 and HTTP2 connections.
	IdleTimeout *types.Duration `protobuf:"bytes,5,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// Specify if http1.1 connection should be upgraded to http2 for the associated destination.
	H2UpgradePolicy ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy `protobuf:"varint,6,opt,name=h2_upgrade_policy,json=h2UpgradePolicy,proto3,enum=istio.networking.v1beta1.ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy" json:"h2_upgrade_policy,omitempty"`
	// If set to true, client protocol will be preserved while initiating connection to backend.
	// Note that when this is set to true, h2_upgrade_policy will be ineffective i.e. the client
	// connections will not be upgraded to http2.
	UseClientProtocol    bool     `protobuf:"varint,7,opt,name=use_client_protocol,json=useClientProtocol,proto3" json:"use_client_protocol,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectionPoolSettings_HTTPSettings) Reset()         { *m = ConnectionPoolSettings_HTTPSettings{} }
func (m *ConnectionPoolSettings_HTTPSettings) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolSettings_HTTPSettings) ProtoMessage()    {}
func (*ConnectionPoolSettings_HTTPSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{4, 1}
}
func (m *ConnectionPoolSettings_HTTPSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectionPoolSettings_HTTPSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectionPoolSettings_HTTPSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectionPoolSettings_HTTPSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionPoolSettings_HTTPSettings.Merge(m, src)
}
func (m *ConnectionPoolSettings_HTTPSettings) XXX_Size() int {
	return m.Size()
}
func (m *ConnectionPoolSettings_HTTPSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionPoolSettings_HTTPSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionPoolSettings_HTTPSettings proto.InternalMessageInfo

func (m *ConnectionPoolSettings_HTTPSettings) GetHttp1MaxPendingRequests() int32 {
	if m != nil {
		return m.Http1MaxPendingRequests
	}
	return 0
}

func (m *ConnectionPoolSettings_HTTPSettings) GetHttp2MaxRequests() int32 {
	if m != nil {
		return m.Http2MaxRequests
	}
	return 0
}

func (m *ConnectionPoolSettings_HTTPSettings) GetMaxRequestsPerConnection() int32 {
	if m != nil {
		return m.MaxRequestsPerConnection
	}
	return 0
}

func (m *ConnectionPoolSettings_HTTPSettings) GetMaxRetries() int32 {
	if m != nil {
		return m.MaxRetries
	}
	return 0
}

func (m *ConnectionPoolSettings_HTTPSettings) GetIdleTimeout() *types.Duration {
	if m != nil {
		return m.IdleTimeout
	}
	return nil
}

func (m *ConnectionPoolSettings_HTTPSettings) GetH2UpgradePolicy() ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy {
	if m != nil {
		return m.H2UpgradePolicy
	}
	return ConnectionPoolSettings_HTTPSettings_DEFAULT
}

func (m *ConnectionPoolSettings_HTTPSettings) GetUseClientProtocol() bool {
	if m != nil {
		return m.UseClientProtocol
	}
	return false
}

// A Circuit breaker implementation that tracks the status of each
// individual host in the upstream service.  Applicable to both HTTP and
// TCP services.  For HTTP services, hosts that continually return 5xx
// errors for API calls are ejected from the pool for a pre-defined period
// of time. For TCP services, connection timeouts or connection
// failures to a given host counts as an error when measuring the
// consecutive errors metric. See Envoy's [outlier
// detection](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/outlier)
// for more details.
//
// The following rule sets a connection pool size of 100 HTTP1 connections
// with no more than 10 req/connection to the "reviews" service. In addition,
// it sets a limit of 1000 concurrent HTTP2 requests and configures upstream
// hosts to be scanned every 5 mins so that any host that fails 7 consecutive
// times with a 502, 503, or 504 error code will be ejected for 15 minutes.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: reviews-cb-policy
// spec:
//   host: reviews.prod.svc.cluster.local
//   trafficPolicy:
//     connectionPool:
//       tcp:
//         maxConnections: 100
//       http:
//         http2MaxRequests: 1000
//         maxRequestsPerConnection: 10
//     outlierDetection:
//       consecutive5xxErrors: 7
//       interval: 5m
//       baseEjectionTime: 15m
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: reviews-cb-policy
// spec:
//   host: reviews.prod.svc.cluster.local
//   trafficPolicy:
//     connectionPool:
//       tcp:
//         maxConnections: 100
//       http:
//         http2MaxRequests: 1000
//         maxRequestsPerConnection: 10
//     outlierDetection:
//       consecutive5xxErrors: 7
//       interval: 5m
//       baseEjectionTime: 15m
// ```
// {{</tab>}}
// {{</tabset>}}
//
type OutlierDetection struct {
	// Number of errors before a host is ejected from the connection
	// pool. Defaults to 5. When the upstream host is accessed over HTTP, a
	// 502, 503, or 504 return code qualifies as an error. When the upstream host
	// is accessed over an opaque TCP connection, connect timeouts and
	// connection error/failure events qualify as an error.
	// $hide_from_docs
	ConsecutiveErrors int32 `protobuf:"varint,1,opt,name=consecutive_errors,json=consecutiveErrors,proto3" json:"consecutive_errors,omitempty"` // Deprecated: Do not use.
	// Number of gateway errors before a host is ejected from the connection pool.
	// When the upstream host is accessed over HTTP, a 502, 503, or 504 return
	// code qualifies as a gateway error. When the upstream host is accessed over
	// an opaque TCP connection, connect timeouts and connection error/failure
	// events qualify as a gateway error.
	// This feature is disabled by default or when set to the value 0.
	//
	// Note that consecutive_gateway_errors and consecutive_5xx_errors can be
	// used separately or together. Because the errors counted by
	// consecutive_gateway_errors are also included in consecutive_5xx_errors,
	// if the value of consecutive_gateway_errors is greater than or equal to
	// the value of consecutive_5xx_errors, consecutive_gateway_errors will have
	// no effect.
	ConsecutiveGatewayErrors *types.UInt32Value `protobuf:"bytes,6,opt,name=consecutive_gateway_errors,json=consecutiveGatewayErrors,proto3" json:"consecutive_gateway_errors,omitempty"`
	// Number of 5xx errors before a host is ejected from the connection pool.
	// When the upstream host is accessed over an opaque TCP connection, connect
	// timeouts, connection error/failure and request failure events qualify as a
	// 5xx error.
	// This feature defaults to 5 but can be disabled by setting the value to 0.
	//
	// Note that consecutive_gateway_errors and consecutive_5xx_errors can be
	// used separately or together. Because the errors counted by
	// consecutive_gateway_errors are also included in consecutive_5xx_errors,
	// if the value of consecutive_gateway_errors is greater than or equal to
	// the value of consecutive_5xx_errors, consecutive_gateway_errors will have
	// no effect.
	Consecutive_5XxErrors *types.UInt32Value `protobuf:"bytes,7,opt,name=consecutive_5xx_errors,json=consecutive5xxErrors,proto3" json:"consecutive_5xx_errors,omitempty"`
	// Time interval between ejection sweep analysis. format:
	// 1h/1m/1s/1ms. MUST BE >=1ms. Default is 10s.
	Interval *types.Duration `protobuf:"bytes,2,opt,name=interval,proto3" json:"interval,omitempty"`
	// Minimum ejection duration. A host will remain ejected for a period
	// equal to the product of minimum ejection duration and the number of
	// times the host has been ejected. This technique allows the system to
	// automatically increase the ejection period for unhealthy upstream
	// servers. format: 1h/1m/1s/1ms. MUST BE >=1ms. Default is 30s.
	BaseEjectionTime *types.Duration `protobuf:"bytes,3,opt,name=base_ejection_time,json=baseEjectionTime,proto3" json:"base_ejection_time,omitempty"`
	// Maximum % of hosts in the load balancing pool for the upstream
	// service that can be ejected. Defaults to 10%.
	MaxEjectionPercent int32 `protobuf:"varint,4,opt,name=max_ejection_percent,json=maxEjectionPercent,proto3" json:"max_ejection_percent,omitempty"`
	// Outlier detection will be enabled as long as the associated load balancing
	// pool has at least min_health_percent hosts in healthy mode. When the
	// percentage of healthy hosts in the load balancing pool drops below this
	// threshold, outlier detection will be disabled and the proxy will load balance
	// across all hosts in the pool (healthy and unhealthy). The threshold can be
	// disabled by setting it to 0%. The default is 0% as it's not typically
	// applicable in k8s environments with few pods per service.
	MinHealthPercent     int32    `protobuf:"varint,5,opt,name=min_health_percent,json=minHealthPercent,proto3" json:"min_health_percent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutlierDetection) Reset()         { *m = OutlierDetection{} }
func (m *OutlierDetection) String() string { return proto.CompactTextString(m) }
func (*OutlierDetection) ProtoMessage()    {}
func (*OutlierDetection) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{5}
}
func (m *OutlierDetection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutlierDetection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutlierDetection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OutlierDetection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutlierDetection.Merge(m, src)
}
func (m *OutlierDetection) XXX_Size() int {
	return m.Size()
}
func (m *OutlierDetection) XXX_DiscardUnknown() {
	xxx_messageInfo_OutlierDetection.DiscardUnknown(m)
}

var xxx_messageInfo_OutlierDetection proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *OutlierDetection) GetConsecutiveErrors() int32 {
	if m != nil {
		return m.ConsecutiveErrors
	}
	return 0
}

func (m *OutlierDetection) GetConsecutiveGatewayErrors() *types.UInt32Value {
	if m != nil {
		return m.ConsecutiveGatewayErrors
	}
	return nil
}

func (m *OutlierDetection) GetConsecutive_5XxErrors() *types.UInt32Value {
	if m != nil {
		return m.Consecutive_5XxErrors
	}
	return nil
}

func (m *OutlierDetection) GetInterval() *types.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *OutlierDetection) GetBaseEjectionTime() *types.Duration {
	if m != nil {
		return m.BaseEjectionTime
	}
	return nil
}

func (m *OutlierDetection) GetMaxEjectionPercent() int32 {
	if m != nil {
		return m.MaxEjectionPercent
	}
	return 0
}

func (m *OutlierDetection) GetMinHealthPercent() int32 {
	if m != nil {
		return m.MinHealthPercent
	}
	return 0
}

// SSL/TLS related settings for upstream connections. See Envoy's [TLS
// context](https://www.envoyproxy.io/docs/envoy/latest/api-v2/api/v2/auth/cert.proto.html)
// for more details. These settings are common to both HTTP and TCP upstreams.
//
// For example, the following rule configures a client to use mutual TLS
// for connections to upstream database cluster.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: db-mtls
// spec:
//   host: mydbserver.prod.svc.cluster.local
//   trafficPolicy:
//     tls:
//       mode: MUTUAL
//       clientCertificate: /etc/certs/myclientcert.pem
//       privateKey: /etc/certs/client_private_key.pem
//       caCertificates: /etc/certs/rootcacerts.pem
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: db-mtls
// spec:
//   host: mydbserver.prod.svc.cluster.local
//   trafficPolicy:
//     tls:
//       mode: MUTUAL
//       clientCertificate: /etc/certs/myclientcert.pem
//       privateKey: /etc/certs/client_private_key.pem
//       caCertificates: /etc/certs/rootcacerts.pem
// ```
// {{</tab>}}
// {{</tabset>}}
//
// The following rule configures a client to use TLS when talking to a
// foreign service whose domain matches *.foo.com.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: tls-foo
// spec:
//   host: "*.foo.com"
//   trafficPolicy:
//     tls:
//       mode: SIMPLE
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: tls-foo
// spec:
//   host: "*.foo.com"
//   trafficPolicy:
//     tls:
//       mode: SIMPLE
// ```
// {{</tab>}}
// {{</tabset>}}
//
// The following rule configures a client to use Istio mutual TLS when talking
// to rating services.
//
// {{<tabset category-name="example">}}
// {{<tab name="v1alpha3" category-value="v1alpha3">}}
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: ratings-istio-mtls
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     tls:
//       mode: ISTIO_MUTUAL
// ```
// {{</tab>}}
//
// {{<tab name="v1beta1" category-value="v1beta1">}}
// ```yaml
// apiVersion: networking.istio.io/v1beta1
// kind: DestinationRule
// metadata:
//   name: ratings-istio-mtls
// spec:
//   host: ratings.prod.svc.cluster.local
//   trafficPolicy:
//     tls:
//       mode: ISTIO_MUTUAL
// ```
// {{</tab>}}
// {{</tabset>}}
//
type ClientTLSSettings struct {
	// Indicates whether connections to this port should be secured
	// using TLS. The value of this field determines how TLS is enforced.
	Mode ClientTLSSettings_TLSmode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.networking.v1beta1.ClientTLSSettings_TLSmode" json:"mode,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to the file holding the
	// client-side TLS certificate to use.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	ClientCertificate string `protobuf:"bytes,2,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to the file holding the
	// client's private key.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	PrivateKey string `protobuf:"bytes,3,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// OPTIONAL: The path to the file containing certificate authority
	// certificates to use in verifying a presented server certificate. If
	// omitted, the proxy will not verify the server's certificate.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	CaCertificates string `protobuf:"bytes,4,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// The name of the secret that holds the TLS certs for the
	// client including the CA certificates. Secret must exist in the
	// same namespace with the proxy using the certificates.
	// The secret (of type `generic`)should contain the
	// following keys and values: `key: <privateKey>`,
	// `cert: <serverCert>`, `cacert: <CACertificate>`.
	// Secret of type tls for client certificates along with
	// ca.crt key for CA certificates is also supported.
	// Only one of client certificates and CA certificate
	// or credentialName can be specified.
	//
	// **NOTE:** This field is currently applicable only at gateways.
	// Sidecars will continue to use the certificate paths.
	CredentialName string `protobuf:"bytes,7,opt,name=credential_name,json=credentialName,proto3" json:"credential_name,omitempty"`
	// A list of alternate names to verify the subject identity in the
	// certificate. If specified, the proxy will verify that the server
	// certificate's subject alt name matches one of the specified values.
	// If specified, this list overrides the value of subject_alt_names
	// from the ServiceEntry.
	SubjectAltNames []string `protobuf:"bytes,5,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
	// SNI string to present to the server during TLS handshake.
	Sni                  string   `protobuf:"bytes,6,opt,name=sni,proto3" json:"sni,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClientTLSSettings) Reset()         { *m = ClientTLSSettings{} }
func (m *ClientTLSSettings) String() string { return proto.CompactTextString(m) }
func (*ClientTLSSettings) ProtoMessage()    {}
func (*ClientTLSSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{6}
}
func (m *ClientTLSSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClientTLSSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClientTLSSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClientTLSSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientTLSSettings.Merge(m, src)
}
func (m *ClientTLSSettings) XXX_Size() int {
	return m.Size()
}
func (m *ClientTLSSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientTLSSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ClientTLSSettings proto.InternalMessageInfo

func (m *ClientTLSSettings) GetMode() ClientTLSSettings_TLSmode {
	if m != nil {
		return m.Mode
	}
	return ClientTLSSettings_DISABLE
}

func (m *ClientTLSSettings) GetClientCertificate() string {
	if m != nil {
		return m.ClientCertificate
	}
	return ""
}

func (m *ClientTLSSettings) GetPrivateKey() string {
	if m != nil {
		return m.PrivateKey
	}
	return ""
}

func (m *ClientTLSSettings) GetCaCertificates() string {
	if m != nil {
		return m.CaCertificates
	}
	return ""
}

func (m *ClientTLSSettings) GetCredentialName() string {
	if m != nil {
		return m.CredentialName
	}
	return ""
}

func (m *ClientTLSSettings) GetSubjectAltNames() []string {
	if m != nil {
		return m.SubjectAltNames
	}
	return nil
}

func (m *ClientTLSSettings) GetSni() string {
	if m != nil {
		return m.Sni
	}
	return ""
}

// Locality-weighted load balancing allows administrators to control the
// distribution of traffic to endpoints based on the localities of where the
// traffic originates and where it will terminate. These localities are
// specified using arbitrary labels that designate a hierarchy of localities in
// {region}/{zone}/{sub-zone} form. For additional detail refer to
// [Locality Weight](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/locality_weight)
// The following example shows how to setup locality weights mesh-wide.
//
// Given a mesh with workloads and their service deployed to "us-west/zone1/*"
// and "us-west/zone2/*". This example specifies that when traffic accessing a
// service originates from workloads in "us-west/zone1/*", 80% of the traffic
// will be sent to endpoints in "us-west/zone1/*", i.e the same zone, and the
// remaining 20% will go to endpoints in "us-west/zone2/*". This setup is
// intended to favor routing traffic to endpoints in the same locality.
// A similar setting is specified for traffic originating in "us-west/zone2/*".
//
// ```yaml
//   distribute:
//     - from: us-west/zone1/*
//       to:
//         "us-west/zone1/*": 80
//         "us-west/zone2/*": 20
//     - from: us-west/zone2/*
//       to:
//         "us-west/zone1/*": 20
//         "us-west/zone2/*": 80
// ```
//
// If the goal of the operator is not to distribute load across zones and
// regions but rather to restrict the regionality of failover to meet other
// operational requirements an operator can set a 'failover' policy instead of
// a 'distribute' policy.
//
// The following example sets up a locality failover policy for regions.
// Assume a service resides in zones within us-east, us-west & eu-west
// this example specifies that when endpoints within us-east become unhealthy
// traffic should failover to endpoints in any zone or sub-zone within eu-west
// and similarly us-west should failover to us-east.
//
// ```yaml
//  failover:
//    - from: us-east
//      to: eu-west
//    - from: us-west
//      to: us-east
// ```
// Locality load balancing settings.
type LocalityLoadBalancerSetting struct {
	// Optional: only one of distribute or failover can be set.
	// Explicitly specify loadbalancing weight across different zones and geographical locations.
	// Refer to [Locality weighted load balancing](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/upstream/load_balancing/locality_weight)
	// If empty, the locality weight is set according to the endpoints number within it.
	Distribute []*LocalityLoadBalancerSetting_Distribute `protobuf:"bytes,1,rep,name=distribute,proto3" json:"distribute,omitempty"`
	// Optional: only failover or distribute can be set.
	// Explicitly specify the region traffic will land on when endpoints in local region becomes unhealthy.
	// Should be used together with OutlierDetection to detect unhealthy endpoints.
	// Note: if no OutlierDetection specified, this will not take effect.
	Failover []*LocalityLoadBalancerSetting_Failover `protobuf:"bytes,2,rep,name=failover,proto3" json:"failover,omitempty"`
	// enable locality load balancing, this is DestinationRule-level and will override mesh wide settings in entirety.
	// e.g. true means that turn on locality load balancing for this DestinationRule no matter what mesh wide settings is.
	Enabled              *types.BoolValue `protobuf:"bytes,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LocalityLoadBalancerSetting) Reset()         { *m = LocalityLoadBalancerSetting{} }
func (m *LocalityLoadBalancerSetting) String() string { return proto.CompactTextString(m) }
func (*LocalityLoadBalancerSetting) ProtoMessage()    {}
func (*LocalityLoadBalancerSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{7}
}
func (m *LocalityLoadBalancerSetting) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalityLoadBalancerSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalityLoadBalancerSetting.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalityLoadBalancerSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalityLoadBalancerSetting.Merge(m, src)
}
func (m *LocalityLoadBalancerSetting) XXX_Size() int {
	return m.Size()
}
func (m *LocalityLoadBalancerSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalityLoadBalancerSetting.DiscardUnknown(m)
}

var xxx_messageInfo_LocalityLoadBalancerSetting proto.InternalMessageInfo

func (m *LocalityLoadBalancerSetting) GetDistribute() []*LocalityLoadBalancerSetting_Distribute {
	if m != nil {
		return m.Distribute
	}
	return nil
}

func (m *LocalityLoadBalancerSetting) GetFailover() []*LocalityLoadBalancerSetting_Failover {
	if m != nil {
		return m.Failover
	}
	return nil
}

func (m *LocalityLoadBalancerSetting) GetEnabled() *types.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

// Describes how traffic originating in the 'from' zone or sub-zone is
// distributed over a set of 'to' zones. Syntax for specifying a zone is
// {region}/{zone}/{sub-zone} and terminal wildcards are allowed on any
// segment of the specification. Examples:
//
// `*` - matches all localities
//
// `us-west/*` - all zones and sub-zones within the us-west region
//
// `us-west/zone-1/*` - all sub-zones within us-west/zone-1
type LocalityLoadBalancerSetting_Distribute struct {
	// Originating locality, '/' separated, e.g. 'region/zone/sub_zone'.
	From string `protobuf:"bytes,1,opt,name=from,proto3" json:"from,omitempty"`
	// Map of upstream localities to traffic distribution weights. The sum of
	// all weights should be 100. Any locality not present will
	// receive no traffic.
	To                   map[string]uint32 `protobuf:"bytes,2,rep,name=to,proto3" json:"to,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LocalityLoadBalancerSetting_Distribute) Reset() {
	*m = LocalityLoadBalancerSetting_Distribute{}
}
func (m *LocalityLoadBalancerSetting_Distribute) String() string { return proto.CompactTextString(m) }
func (*LocalityLoadBalancerSetting_Distribute) ProtoMessage()    {}
func (*LocalityLoadBalancerSetting_Distribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{7, 0}
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalityLoadBalancerSetting_Distribute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalityLoadBalancerSetting_Distribute.Merge(m, src)
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_Size() int {
	return m.Size()
}
func (m *LocalityLoadBalancerSetting_Distribute) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalityLoadBalancerSetting_Distribute.DiscardUnknown(m)
}

var xxx_messageInfo_LocalityLoadBalancerSetting_Distribute proto.InternalMessageInfo

func (m *LocalityLoadBalancerSetting_Distribute) GetFrom() string {
	if m != nil {
		return m.From
	}
	return ""
}

func (m *LocalityLoadBalancerSetting_Distribute) GetTo() map[string]uint32 {
	if m != nil {
		return m.To
	}
	return nil
}

// Specify the traffic failover policy across regions. Since zone and sub-zone
// failover is supported by default this only needs to be specified for
// regions when the operator needs to constrain traffic failover so that
// the default behavior of failing over to any endpoint globally does not
// apply. This is useful when failing over traffic across regions would not
// improve service health or may need to be restricted for other reasons
// like regulatory controls.
type LocalityLoadBalancerSetting_Failover struct {
	// Originating region.
	From string `protobuf:"bytes,1,opt,name=from,proto3" json:"from,omitempty"`
	// Destination region the traffic will fail over to when endpoints in
	// the 'from' region becomes unhealthy.
	To                   string   `protobuf:"bytes,2,opt,name=to,proto3" json:"to,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocalityLoadBalancerSetting_Failover) Reset()         { *m = LocalityLoadBalancerSetting_Failover{} }
func (m *LocalityLoadBalancerSetting_Failover) String() string { return proto.CompactTextString(m) }
func (*LocalityLoadBalancerSetting_Failover) ProtoMessage()    {}
func (*LocalityLoadBalancerSetting_Failover) Descriptor() ([]byte, []int) {
	return fileDescriptor_31054629b619ca4b, []int{7, 1}
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LocalityLoadBalancerSetting_Failover.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalityLoadBalancerSetting_Failover.Merge(m, src)
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_Size() int {
	return m.Size()
}
func (m *LocalityLoadBalancerSetting_Failover) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalityLoadBalancerSetting_Failover.DiscardUnknown(m)
}

var xxx_messageInfo_LocalityLoadBalancerSetting_Failover proto.InternalMessageInfo

func (m *LocalityLoadBalancerSetting_Failover) GetFrom() string {
	if m != nil {
		return m.From
	}
	return ""
}

func (m *LocalityLoadBalancerSetting_Failover) GetTo() string {
	if m != nil {
		return m.To
	}
	return ""
}

func init() {
	proto.RegisterEnum("istio.networking.v1beta1.LoadBalancerSettings_SimpleLB", LoadBalancerSettings_SimpleLB_name, LoadBalancerSettings_SimpleLB_value)
	proto.RegisterEnum("istio.networking.v1beta1.ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy", ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy_name, ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy_value)
	proto.RegisterEnum("istio.networking.v1beta1.ClientTLSSettings_TLSmode", ClientTLSSettings_TLSmode_name, ClientTLSSettings_TLSmode_value)
	proto.RegisterType((*DestinationRule)(nil), "istio.networking.v1beta1.DestinationRule")
	proto.RegisterType((*TrafficPolicy)(nil), "istio.networking.v1beta1.TrafficPolicy")
	proto.RegisterType((*TrafficPolicy_PortTrafficPolicy)(nil), "istio.networking.v1beta1.TrafficPolicy.PortTrafficPolicy")
	proto.RegisterType((*Subset)(nil), "istio.networking.v1beta1.Subset")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1beta1.Subset.LabelsEntry")
	proto.RegisterType((*LoadBalancerSettings)(nil), "istio.networking.v1beta1.LoadBalancerSettings")
	proto.RegisterType((*LoadBalancerSettings_ConsistentHashLB)(nil), "istio.networking.v1beta1.LoadBalancerSettings.ConsistentHashLB")
	proto.RegisterType((*LoadBalancerSettings_ConsistentHashLB_HTTPCookie)(nil), "istio.networking.v1beta1.LoadBalancerSettings.ConsistentHashLB.HTTPCookie")
	proto.RegisterType((*ConnectionPoolSettings)(nil), "istio.networking.v1beta1.ConnectionPoolSettings")
	proto.RegisterType((*ConnectionPoolSettings_TCPSettings)(nil), "istio.networking.v1beta1.ConnectionPoolSettings.TCPSettings")
	proto.RegisterType((*ConnectionPoolSettings_TCPSettings_TcpKeepalive)(nil), "istio.networking.v1beta1.ConnectionPoolSettings.TCPSettings.TcpKeepalive")
	proto.RegisterType((*ConnectionPoolSettings_HTTPSettings)(nil), "istio.networking.v1beta1.ConnectionPoolSettings.HTTPSettings")
	proto.RegisterType((*OutlierDetection)(nil), "istio.networking.v1beta1.OutlierDetection")
	proto.RegisterType((*ClientTLSSettings)(nil), "istio.networking.v1beta1.ClientTLSSettings")
	proto.RegisterType((*LocalityLoadBalancerSetting)(nil), "istio.networking.v1beta1.LocalityLoadBalancerSetting")
	proto.RegisterType((*LocalityLoadBalancerSetting_Distribute)(nil), "istio.networking.v1beta1.LocalityLoadBalancerSetting.Distribute")
	proto.RegisterMapType((map[string]uint32)(nil), "istio.networking.v1beta1.LocalityLoadBalancerSetting.Distribute.ToEntry")
	proto.RegisterType((*LocalityLoadBalancerSetting_Failover)(nil), "istio.networking.v1beta1.LocalityLoadBalancerSetting.Failover")
}

func init() {
	proto.RegisterFile("networking/v1beta1/destination_rule.proto", fileDescriptor_31054629b619ca4b)
}

var fileDescriptor_31054629b619ca4b = []byte{
	// 1822 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcd, 0x73, 0x1b, 0xb7,
	0x15, 0x17, 0x3f, 0x44, 0x49, 0x8f, 0xfa, 0x20, 0x61, 0x8d, 0xcb, 0xd0, 0x1d, 0x5b, 0xc3, 0xe9,
	0x34, 0xaa, 0x1b, 0xaf, 0x22, 0xb9, 0x9a, 0x36, 0x4e, 0xdc, 0x44, 0x14, 0x15, 0x53, 0x0d, 0x25,
	0xd2, 0x20, 0xd5, 0x0f, 0x5f, 0xb6, 0xe0, 0x12, 0x22, 0x11, 0x2d, 0x17, 0x1b, 0x2c, 0x96, 0x26,
	0x73, 0x6d, 0x8f, 0xbd, 0xf7, 0xef, 0xe8, 0xa9, 0xa7, 0xde, 0x7b, 0xe9, 0x4c, 0x0f, 0xed, 0xad,
	0x87, 0x8e, 0xff, 0x85, 0x4e, 0x0f, 0xbd, 0x75, 0x80, 0xc5, 0x92, 0x2b, 0x4b, 0xb2, 0x2c, 0x2b,
	0xbe, 0x01, 0xef, 0xe3, 0x87, 0x87, 0x87, 0xdf, 0x03, 0xde, 0x2e, 0xfc, 0xc8, 0xa3, 0xf2, 0x25,
	0x17, 0x67, 0xcc, 0xeb, 0x6f, 0x8d, 0xb6, 0xbb, 0x54, 0x92, 0xed, 0xad, 0x1e, 0x0d, 0x24, 0xf3,
	0x88, 0x64, 0xdc, 0xb3, 0x45, 0xe8, 0x52, 0xcb, 0x17, 0x5c, 0x72, 0x54, 0x62, 0x81, 0x64, 0xdc,
	0x9a, 0x39, 0x58, 0xc6, 0xa1, 0xfc, 0xa0, 0xcf, 0x79, 0xdf, 0xa5, 0x5b, 0xc4, 0x67, 0x5b, 0xa7,
	0x8c, 0xba, 0x3d, 0xbb, 0x4b, 0x07, 0x64, 0xc4, 0xb8, 0x88, 0x5c, 0xcb, 0xf7, 0x8d, 0x81, 0x9e,
	0x75, 0xc3, 0xd3, 0xad, 0x5e, 0x28, 0x34, 0xfe, 0x55, 0xfa, 0x97, 0x82, 0xf8, 0x3e, 0x15, 0x81,
	0xd1, 0x6f, 0x5e, 0x12, 0xe5, 0x88, 0x09, 0x19, 0x12, 0xd7, 0x0e, 0xa8, 0x18, 0x31, 0xc7, 0x04,
	0x59, 0x5e, 0xef, 0xf3, 0x3e, 0xd7, 0xc3, 0x2d, 0x35, 0x8a, 0xa4, 0x95, 0x7f, 0xa4, 0x60, 0xad,
	0x36, 0xdb, 0x15, 0x0e, 0x5d, 0x8a, 0x4a, 0x90, 0x1d, 0xf0, 0x40, 0x96, 0x52, 0x1b, 0xa9, 0xcd,
	0xa5, 0x6a, 0xf6, 0xd5, 0x5e, 0x2a, 0x8d, 0xb5, 0x04, 0x1d, 0xc3, 0xaa, 0x14, 0xe4, 0xf4, 0x94,
	0x39, 0xb6, 0xcf, 0x5d, 0xe6, 0x4c, 0x4a, 0xe9, 0x8d, 0xd4, 0x66, 0x7e, 0xe7, 0x43, 0xeb, 0xaa,
	0x0c, 0x58, 0x9d, 0xc8, 0xbe, 0xa5, 0xcd, 0xf1, 0x8a, 0x4c, 0x4e, 0xd1, 0x13, 0x58, 0x08, 0xc2,
	0x6e, 0x40, 0x65, 0x50, 0xca, 0x6c, 0x64, 0x36, 0xf3, 0x3b, 0x1b, 0x57, 0x03, 0xb5, 0xb5, 0x21,
	0x8e, 0x1d, 0xd0, 0x3d, 0x58, 0xa2, 0x63, 0x9f, 0x0b, 0x69, 0x4b, 0x5e, 0xca, 0x6e, 0x64, 0x36,
	0x97, 0xf0, 0x62, 0x24, 0xe8, 0xf0, 0xca, 0xbf, 0x72, 0xb0, 0x72, 0x6e, 0x65, 0xd4, 0x86, 0x15,
	0x97, 0x93, 0x9e, 0xdd, 0x25, 0x2e, 0xf1, 0x1c, 0x2a, 0xf4, 0xee, 0xf2, 0x3b, 0xd6, 0xd5, 0x0b,
	0x36, 0x38, 0xe9, 0x55, 0x8d, 0x75, 0x9b, 0x4a, 0xc9, 0xbc, 0x7e, 0x80, 0x97, 0xdd, 0x84, 0x14,
	0xfd, 0x06, 0xd6, 0x1c, 0xee, 0x79, 0xd4, 0xd1, 0x8c, 0xf0, 0x39, 0x77, 0x4d, 0x42, 0x3e, 0xbe,
	0x1a, 0x76, 0x7f, 0xea, 0xd0, 0xe2, 0xdc, 0x9d, 0x02, 0xaf, 0x3a, 0xe7, 0xe4, 0xe8, 0x57, 0x50,
	0xe4, 0xa1, 0x74, 0x19, 0x15, 0x76, 0x8f, 0xca, 0x48, 0x51, 0xca, 0x68, 0xf0, 0x87, 0x57, 0x83,
	0x37, 0x23, 0x97, 0x5a, 0xec, 0x81, 0x0b, 0xfc, 0x35, 0x09, 0x7a, 0x0a, 0x19, 0xe9, 0x06, 0xa5,
	0xac, 0x86, 0xfa, 0xf1, 0x1b, 0xe2, 0x74, 0x19, 0xf5, 0x64, 0xa7, 0xd1, 0x9e, 0x86, 0xa8, 0xfc,
	0x10, 0x83, 0x3b, 0x3a, 0xe9, 0x2e, 0x1d, 0x51, 0x45, 0xb1, 0x48, 0x57, 0x9a, 0xd7, 0xc7, 0xf7,
	0xc9, 0x5b, 0xf2, 0xc0, 0x6a, 0xa9, 0x63, 0x3a, 0xc7, 0x8c, 0xa2, 0x42, 0x6d, 0x28, 0xd0, 0x78,
	0xbd, 0xf2, 0x1f, 0x33, 0x50, 0xbc, 0x60, 0x88, 0x9e, 0x40, 0x56, 0x99, 0x9a, 0xf3, 0xfb, 0xe1,
	0xd5, 0x2b, 0x2a, 0xd7, 0x36, 0x75, 0xa9, 0x23, 0xb9, 0xc0, 0xda, 0xe7, 0x22, 0x09, 0xd2, 0xef,
	0x87, 0x04, 0x99, 0xf7, 0x49, 0x82, 0xec, 0x77, 0x47, 0x82, 0xf9, 0x77, 0x23, 0x41, 0xe5, 0x3f,
	0x29, 0xc8, 0x45, 0xf5, 0xa8, 0x2e, 0x0b, 0x8f, 0x0c, 0xe9, 0xf9, 0xcb, 0x42, 0x49, 0x50, 0x0d,
	0x72, 0x2e, 0xe9, 0x52, 0x37, 0x28, 0xa5, 0x35, 0x39, 0x3e, 0xba, 0xae, 0xb6, 0xad, 0x86, 0x36,
	0x3f, 0xf0, 0xa4, 0x98, 0x60, 0xe3, 0x7b, 0xc9, 0x95, 0x93, 0xb9, 0xcd, 0x95, 0x53, 0xfe, 0x04,
	0xf2, 0x89, 0x65, 0x50, 0x01, 0x32, 0x67, 0x74, 0x12, 0x45, 0x8f, 0xd5, 0x10, 0xad, 0xc3, 0xfc,
	0x88, 0xb8, 0x21, 0xd5, 0xdc, 0x58, 0xc2, 0xd1, 0xe4, 0x49, 0xfa, 0x67, 0xa9, 0xca, 0xdf, 0x72,
	0xb0, 0x7e, 0x19, 0x1f, 0xd0, 0x73, 0xc8, 0x05, 0x6c, 0xe8, 0xbb, 0x51, 0x16, 0x56, 0x77, 0x7e,
	0x7a, 0x33, 0x3e, 0x59, 0x6d, 0xed, 0xdc, 0xa8, 0xd6, 0xe7, 0xb0, 0x01, 0x42, 0x5f, 0x6b, 0x52,
	0x05, 0x2c, 0x90, 0xd4, 0x93, 0xf6, 0x80, 0x04, 0x03, 0xc3, 0xd5, 0xcf, 0x6f, 0x88, 0xbd, 0x3f,
	0x45, 0xa9, 0x93, 0x60, 0xa0, 0xd7, 0x58, 0x75, 0xce, 0xc9, 0x10, 0x85, 0x3b, 0x2e, 0x77, 0x88,
	0xcb, 0xe4, 0xc4, 0x76, 0xbb, 0x71, 0x4d, 0x9b, 0x3c, 0xef, 0xbe, 0x69, 0xbd, 0xc8, 0xe9, 0x92,
	0x75, 0x71, 0x31, 0x46, 0x6c, 0x74, 0x8d, 0xa8, 0xfc, 0xe7, 0x0c, 0x14, 0x5e, 0x8f, 0x06, 0x3d,
	0x84, 0xc2, 0x40, 0x4a, 0xdf, 0x1e, 0x50, 0xd2, 0xa3, 0xc2, 0x9e, 0x51, 0x49, 0xc5, 0xa9, 0x34,
	0x75, 0xad, 0x38, 0x56, 0x84, 0x1a, 0x42, 0x5e, 0xdb, 0x3a, 0x9c, 0x9f, 0x31, 0x6a, 0xf2, 0xf1,
	0x8b, 0x5b, 0xe6, 0xc3, 0xaa, 0x77, 0x3a, 0xad, 0x7d, 0x8d, 0x58, 0x9f, 0xc3, 0xa0, 0x16, 0x88,
	0x66, 0xe8, 0x07, 0xb0, 0x12, 0x06, 0xd4, 0x0e, 0x78, 0x28, 0x1c, 0x6a, 0x33, 0x5f, 0x27, 0x64,
	0xb1, 0x3e, 0x87, 0xf3, 0x61, 0x40, 0xdb, 0x5a, 0x7a, 0xe8, 0xa3, 0x4f, 0xe1, 0x03, 0x1d, 0xd4,
	0x37, 0x21, 0x15, 0x13, 0xdb, 0x27, 0x82, 0x0c, 0xa9, 0x8c, 0x77, 0x32, 0x6f, 0x76, 0x72, 0x57,
	0x99, 0x3c, 0x57, 0x16, 0xad, 0xd8, 0x40, 0xef, 0xe8, 0x21, 0x14, 0x87, 0xcc, 0x63, 0xc3, 0x70,
	0x68, 0x0b, 0xe6, 0xf5, 0xed, 0x80, 0x7d, 0x4b, 0x75, 0x7d, 0x67, 0xf1, 0x9a, 0x51, 0x60, 0xe6,
	0xf5, 0xdb, 0xec, 0x5b, 0x5a, 0x1e, 0x02, 0xcc, 0x42, 0x7d, 0x43, 0xd9, 0x21, 0xc8, 0xfa, 0x44,
	0x0e, 0x0c, 0x7d, 0xf5, 0x18, 0x6d, 0x43, 0x46, 0xca, 0xf8, 0x5a, 0xfa, 0xc0, 0x8a, 0x7a, 0x0a,
	0x2b, 0xee, 0x29, 0xac, 0x9a, 0xe9, 0x39, 0x0c, 0x8e, 0xb2, 0xad, 0x02, 0x2c, 0x2a, 0xd6, 0xd9,
	0x67, 0x74, 0x52, 0xa9, 0xc3, 0x62, 0x4c, 0x51, 0xb4, 0x06, 0x79, 0xdc, 0x3c, 0x39, 0xae, 0xd9,
	0xb8, 0x59, 0x3d, 0x3c, 0x2e, 0xcc, 0xa1, 0x55, 0x80, 0xc6, 0xc1, 0x5e, 0xbb, 0x63, 0xef, 0x37,
	0x8f, 0x8f, 0x0b, 0x29, 0x04, 0x90, 0xc3, 0x7b, 0xc7, 0xb5, 0xe6, 0x51, 0x21, 0xad, 0x8c, 0x5b,
	0x7b, 0xed, 0x76, 0xa7, 0x8e, 0x9b, 0x27, 0xcf, 0xea, 0x85, 0x4c, 0x35, 0x0f, 0x4b, 0x6e, 0xd7,
	0x14, 0x72, 0xe5, 0x2f, 0x8b, 0x70, 0xf7, 0xf2, 0x8b, 0x10, 0x1d, 0x43, 0x46, 0x3a, 0xbe, 0xb9,
	0xe3, 0x3f, 0xbb, 0xe9, 0x3d, 0x6a, 0x75, 0xf6, 0x5b, 0x89, 0x0b, 0xcb, 0xf1, 0xd1, 0x73, 0xc8,
	0xaa, 0x23, 0x30, 0x9c, 0x79, 0x7a, 0x63, 0x40, 0x95, 0xf9, 0x29, 0xa2, 0x86, 0x2a, 0xff, 0x2f,
	0x0d, 0xf9, 0xc4, 0x3a, 0xe8, 0x43, 0x58, 0x1b, 0x92, 0xb1, 0x3d, 0xbb, 0xc1, 0x03, 0x1d, 0xfe,
	0x3c, 0x5e, 0x1d, 0x92, 0xf1, 0x0c, 0x36, 0x40, 0xd5, 0xe9, 0x7b, 0x61, 0x4b, 0x36, 0xa4, 0x3c,
	0x94, 0x26, 0xac, 0xab, 0x0f, 0x66, 0xfa, 0x30, 0x74, 0x22, 0x07, 0xe4, 0xc1, 0x8a, 0x74, 0x7c,
	0xfb, 0x8c, 0x52, 0x9f, 0xb8, 0x6c, 0x44, 0xcd, 0xd1, 0x1e, 0xde, 0x26, 0x53, 0x56, 0xc7, 0xf1,
	0xbf, 0x8a, 0x01, 0xf1, 0xb2, 0x4c, 0xcc, 0xca, 0x7f, 0x48, 0xc1, 0x72, 0x52, 0x8d, 0xee, 0x42,
	0xce, 0x17, 0xbc, 0x4b, 0xa3, 0x4d, 0xae, 0x60, 0x33, 0x43, 0x8f, 0x20, 0xab, 0x36, 0x75, 0xfd,
	0x8e, 0xb4, 0x19, 0xda, 0x85, 0x45, 0xe6, 0x49, 0x2a, 0x46, 0xe4, 0x7a, 0x76, 0xe2, 0xa9, 0x69,
	0xf9, 0x77, 0x59, 0x58, 0x4e, 0x1e, 0x09, 0xfa, 0x14, 0xca, 0xea, 0x50, 0xb6, 0x6d, 0x75, 0x04,
	0x3e, 0xf5, 0x7a, 0xaa, 0x9a, 0x04, 0xfd, 0x26, 0xa4, 0x81, 0x8c, 0xcf, 0xe1, 0x7b, 0xda, 0xe2,
	0x88, 0x8c, 0x5b, 0x91, 0x1e, 0x1b, 0x35, 0xfa, 0x08, 0x90, 0x52, 0xed, 0x68, 0xe7, 0xa9, 0x53,
	0x5a, 0x3b, 0xe9, 0xdb, 0x69, 0xe7, 0x88, 0x8c, 0xa7, 0xd6, 0x4f, 0xe1, 0x5e, 0xd2, 0xce, 0xf6,
	0xa9, 0x48, 0x1c, 0xba, 0xde, 0xc5, 0x3c, 0x2e, 0x0d, 0x67, 0x1e, 0x2d, 0x2a, 0x66, 0xc9, 0x47,
	0x0f, 0x20, 0x1f, 0xb9, 0x4b, 0xc1, 0x68, 0xd4, 0x86, 0xcd, 0x63, 0xd0, 0xe6, 0x5a, 0x82, 0x3e,
	0x83, 0x65, 0xd6, 0x73, 0xe9, 0x94, 0x1b, 0xf3, 0xd7, 0xa5, 0x25, 0xaf, 0xcc, 0x63, 0x62, 0x4c,
	0xa0, 0x38, 0xd8, 0xb1, 0x43, 0xbf, 0x2f, 0x48, 0x8f, 0xc6, 0x2f, 0x66, 0x4e, 0xbf, 0x4a, 0x47,
	0xb7, 0x62, 0xbd, 0x55, 0xdf, 0x39, 0x89, 0x50, 0xcd, 0xbb, 0xba, 0x36, 0x38, 0x2f, 0x40, 0x16,
	0xdc, 0x51, 0xf7, 0xa5, 0xa3, 0x5b, 0x06, 0x5b, 0xc7, 0xe9, 0x70, 0xb7, 0xb4, 0xa0, 0x6e, 0x4d,
	0x5c, 0x0c, 0x03, 0x1a, 0x35, 0x13, 0x2d, 0xa3, 0xa8, 0x7c, 0x0e, 0x6b, 0xaf, 0x61, 0xa2, 0x3c,
	0x2c, 0xd4, 0x0e, 0xbe, 0xdc, 0x3b, 0x69, 0x74, 0x0a, 0x73, 0x08, 0xc1, 0x6a, 0xad, 0x69, 0x1f,
	0x37, 0x3b, 0xf6, 0x49, 0xeb, 0x19, 0xde, 0xab, 0x1d, 0x14, 0x52, 0xca, 0x20, 0x9e, 0xa4, 0x2b,
	0xff, 0xcc, 0x40, 0xe1, 0xf5, 0x5e, 0x07, 0x6d, 0x03, 0x52, 0xcf, 0x1b, 0x75, 0x42, 0xc9, 0x46,
	0xd4, 0xa6, 0x42, 0x70, 0x61, 0x18, 0x50, 0x4d, 0x97, 0x52, 0xb8, 0x98, 0xd0, 0x1e, 0x68, 0x25,
	0x7a, 0x01, 0xe5, 0xa4, 0x4b, 0x9f, 0x48, 0xfa, 0x92, 0x4c, 0x62, 0xd7, 0x9c, 0xce, 0xff, 0xf7,
	0x2f, 0xe4, 0xff, 0xe4, 0xd0, 0x93, 0x8f, 0x77, 0x7e, 0xa9, 0xba, 0x03, 0x5c, 0x4a, 0xf8, 0x3f,
	0x8b, 0xdc, 0x0d, 0x36, 0x86, 0xbb, 0x49, 0xec, 0xdd, 0xf1, 0x38, 0xc6, 0x5d, 0x78, 0x0b, 0xdc,
	0xf5, 0x84, 0xef, 0xee, 0x78, 0x6c, 0x30, 0x93, 0x45, 0x93, 0x7e, 0xeb, 0xa2, 0x41, 0xcf, 0x00,
	0x75, 0x49, 0x40, 0x6d, 0xfa, 0xb5, 0x69, 0x55, 0x75, 0xa1, 0x5e, 0x5b, 0x75, 0x05, 0xe5, 0x74,
	0x60, 0x7c, 0x14, 0xcd, 0xd0, 0xc7, 0xb0, 0xae, 0x28, 0x3c, 0xc5, 0xf1, 0xa9, 0x70, 0xa8, 0x27,
	0x0d, 0x97, 0xd1, 0x90, 0x8c, 0x63, 0xf3, 0x56, 0xa4, 0x51, 0x15, 0x36, 0x64, 0x9e, 0x7a, 0xe4,
	0x5d, 0x39, 0x98, 0xda, 0xcf, 0x47, 0x15, 0x36, 0x64, 0x5e, 0x5d, 0x2b, 0x8c, 0x75, 0xe5, 0xf7,
	0x19, 0x28, 0x5e, 0x68, 0x3c, 0xd1, 0x11, 0x64, 0x87, 0xbc, 0x17, 0xb7, 0x58, 0x8f, 0x6f, 0xd0,
	0xb3, 0x5a, 0x9d, 0x46, 0x5b, 0xb9, 0xc6, 0xcf, 0xa4, 0x1a, 0xa3, 0x47, 0x80, 0x0c, 0x53, 0x1d,
	0x2a, 0x24, 0x3b, 0x65, 0x0e, 0x91, 0x71, 0xcf, 0x57, 0x8c, 0x34, 0xfb, 0x33, 0x85, 0x2a, 0x5b,
	0x5f, 0xb0, 0x11, 0x91, 0x54, 0xbd, 0x88, 0x3a, 0x6b, 0x4b, 0x18, 0x8c, 0xe8, 0x2b, 0x3a, 0x51,
	0xd7, 0xbf, 0x43, 0x92, 0x58, 0x51, 0x6d, 0x2f, 0xe1, 0x55, 0x87, 0x24, 0x80, 0xf4, 0x3b, 0xe1,
	0x08, 0xda, 0xa3, 0x9e, 0x64, 0xc4, 0x8d, 0xda, 0x84, 0x05, 0x63, 0x38, 0x15, 0xc7, 0xcd, 0x41,
	0x10, 0x76, 0x55, 0x26, 0x6d, 0xe2, 0x4a, 0x6d, 0x19, 0x7d, 0x67, 0x2d, 0xe1, 0x35, 0xa3, 0xd8,
	0x73, 0xa5, 0x32, 0x0d, 0x54, 0x1b, 0x1b, 0x78, 0x4c, 0x73, 0x75, 0x09, 0xab, 0x61, 0xe5, 0x0b,
	0x58, 0x30, 0xdb, 0xd6, 0x55, 0x75, 0xd8, 0xde, 0xab, 0x36, 0x0e, 0x0a, 0x73, 0xea, 0x79, 0x6e,
	0x1f, 0x1e, 0xb5, 0x1a, 0x07, 0xd1, 0x53, 0x7d, 0x74, 0xd2, 0x39, 0xd9, 0x6b, 0x14, 0xd2, 0xa8,
	0x00, 0xcb, 0x87, 0xed, 0xce, 0x61, 0xd3, 0x36, 0x92, 0x4c, 0xe5, 0xbf, 0x19, 0xb8, 0xf7, 0x86,
	0x16, 0x0f, 0xfd, 0x16, 0xa0, 0xc7, 0x02, 0x29, 0x58, 0x37, 0x94, 0xea, 0x58, 0x54, 0x8f, 0xff,
	0xc5, 0x3b, 0x75, 0x8b, 0x56, 0x6d, 0x8a, 0x83, 0x13, 0x98, 0xe8, 0x05, 0x2c, 0x9e, 0x12, 0xe6,
	0xf2, 0x91, 0xfe, 0x52, 0x53, 0xf8, 0x3f, 0x7f, 0x37, 0xfc, 0x2f, 0x0d, 0x0a, 0x9e, 0xe2, 0xa1,
	0x9f, 0xc0, 0x02, 0xf5, 0x48, 0xd7, 0xa5, 0x3d, 0x53, 0x02, 0xe5, 0x0b, 0x25, 0x50, 0xe5, 0xdc,
	0x8d, 0xea, 0x30, 0x36, 0x2d, 0xff, 0x29, 0x05, 0x30, 0x0b, 0x56, 0xf5, 0x5a, 0xa7, 0x82, 0x0f,
	0xcd, 0xe7, 0x83, 0x1e, 0xa3, 0x5f, 0x43, 0x5a, 0x72, 0x13, 0x6e, 0xfd, 0xb6, 0xe9, 0xb0, 0x3a,
	0x3c, 0xfa, 0x1c, 0x4a, 0x4b, 0x5e, 0xde, 0x85, 0x05, 0x33, 0xbd, 0xee, 0xb3, 0x65, 0x25, 0xf1,
	0xd9, 0x52, 0xb6, 0x60, 0x31, 0xde, 0xff, 0xa5, 0x01, 0xaf, 0x9a, 0x80, 0x95, 0x24, 0x2d, 0x79,
	0xf5, 0xd1, 0x5f, 0x5f, 0xdd, 0x4f, 0xfd, 0xfd, 0xd5, 0xfd, 0xd4, 0xbf, 0x5f, 0xdd, 0x4f, 0xbd,
	0x78, 0x10, 0xed, 0x80, 0x71, 0xfd, 0x0f, 0xeb, 0xe2, 0xdf, 0xa6, 0x6e, 0x4e, 0xe7, 0xeb, 0xf1,
	0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x58, 0xca, 0x88, 0x30, 0x13, 0x00, 0x00,
}

func (m *DestinationRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DestinationRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DestinationRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExportTo) > 0 {
		for iNdEx := len(m.ExportTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExportTo[iNdEx])
			copy(dAtA[i:], m.ExportTo[iNdEx])
			i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.ExportTo[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Subsets) > 0 {
		for iNdEx := len(m.Subsets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Subsets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDestinationRule(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.TrafficPolicy != nil {
		{
			size, err := m.TrafficPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TrafficPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TrafficPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TrafficPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PortLevelSettings) > 0 {
		for iNdEx := len(m.PortLevelSettings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PortLevelSettings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDestinationRule(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Tls != nil {
		{
			size, err := m.Tls.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.OutlierDetection != nil {
		{
			size, err := m.OutlierDetection.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ConnectionPool != nil {
		{
			size, err := m.ConnectionPool.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.LoadBalancer != nil {
		{
			size, err := m.LoadBalancer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TrafficPolicy_PortTrafficPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TrafficPolicy_PortTrafficPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TrafficPolicy_PortTrafficPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Tls != nil {
		{
			size, err := m.Tls.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.OutlierDetection != nil {
		{
			size, err := m.OutlierDetection.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ConnectionPool != nil {
		{
			size, err := m.ConnectionPool.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.LoadBalancer != nil {
		{
			size, err := m.LoadBalancer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Port != nil {
		{
			size, err := m.Port.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Subset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Subset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TrafficPolicy != nil {
		{
			size, err := m.TrafficPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintDestinationRule(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintDestinationRule(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintDestinationRule(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LoadBalancerSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LocalityLbSetting != nil {
		{
			size, err := m.LocalityLbSetting.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.LbPolicy != nil {
		{
			size := m.LbPolicy.Size()
			i -= size
			if _, err := m.LbPolicy.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *LoadBalancerSettings_Simple) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_Simple) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintDestinationRule(dAtA, i, uint64(m.Simple))
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *LoadBalancerSettings_ConsistentHash) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_ConsistentHash) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ConsistentHash != nil {
		{
			size, err := m.ConsistentHash.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *LoadBalancerSettings_ConsistentHashLB) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerSettings_ConsistentHashLB) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_ConsistentHashLB) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HashKey != nil {
		{
			size := m.HashKey.Size()
			i -= size
			if _, err := m.HashKey.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.MinimumRingSize != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MinimumRingSize))
		i--
		dAtA[i] = 0x20
	}
	return len(dAtA) - i, nil
}

func (m *LoadBalancerSettings_ConsistentHashLB_HttpHeaderName) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_ConsistentHashLB_HttpHeaderName) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.HttpHeaderName)
	copy(dAtA[i:], m.HttpHeaderName)
	i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.HttpHeaderName)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *LoadBalancerSettings_ConsistentHashLB_HttpCookie) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_ConsistentHashLB_HttpCookie) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.HttpCookie != nil {
		{
			size, err := m.HttpCookie.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *LoadBalancerSettings_ConsistentHashLB_UseSourceIp) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_ConsistentHashLB_UseSourceIp) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.UseSourceIp {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.HttpQueryParameterName)
	copy(dAtA[i:], m.HttpQueryParameterName)
	i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.HttpQueryParameterName)))
	i--
	dAtA[i] = 0x2a
	return len(dAtA) - i, nil
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Ttl != nil {
		{
			size, err := m.Ttl.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConnectionPoolSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionPoolSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectionPoolSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Http != nil {
		{
			size, err := m.Http.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Tcp != nil {
		{
			size, err := m.Tcp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConnectionPoolSettings_TCPSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionPoolSettings_TCPSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectionPoolSettings_TCPSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TcpKeepalive != nil {
		{
			size, err := m.TcpKeepalive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ConnectTimeout != nil {
		{
			size, err := m.ConnectTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.MaxConnections != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxConnections))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Interval != nil {
		{
			size, err := m.Interval.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Probes != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Probes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConnectionPoolSettings_HTTPSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionPoolSettings_HTTPSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectionPoolSettings_HTTPSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UseClientProtocol {
		i--
		if m.UseClientProtocol {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.H2UpgradePolicy != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.H2UpgradePolicy))
		i--
		dAtA[i] = 0x30
	}
	if m.IdleTimeout != nil {
		{
			size, err := m.IdleTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.MaxRetries != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxRetries))
		i--
		dAtA[i] = 0x20
	}
	if m.MaxRequestsPerConnection != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxRequestsPerConnection))
		i--
		dAtA[i] = 0x18
	}
	if m.Http2MaxRequests != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Http2MaxRequests))
		i--
		dAtA[i] = 0x10
	}
	if m.Http1MaxPendingRequests != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Http1MaxPendingRequests))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OutlierDetection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutlierDetection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OutlierDetection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Consecutive_5XxErrors != nil {
		{
			size, err := m.Consecutive_5XxErrors.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.ConsecutiveGatewayErrors != nil {
		{
			size, err := m.ConsecutiveGatewayErrors.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.MinHealthPercent != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MinHealthPercent))
		i--
		dAtA[i] = 0x28
	}
	if m.MaxEjectionPercent != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxEjectionPercent))
		i--
		dAtA[i] = 0x20
	}
	if m.BaseEjectionTime != nil {
		{
			size, err := m.BaseEjectionTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Interval != nil {
		{
			size, err := m.Interval.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ConsecutiveErrors != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.ConsecutiveErrors))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ClientTLSSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClientTLSSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClientTLSSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CredentialName) > 0 {
		i -= len(m.CredentialName)
		copy(dAtA[i:], m.CredentialName)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.CredentialName)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Sni) > 0 {
		i -= len(m.Sni)
		copy(dAtA[i:], m.Sni)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Sni)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.SubjectAltNames) > 0 {
		for iNdEx := len(m.SubjectAltNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SubjectAltNames[iNdEx])
			copy(dAtA[i:], m.SubjectAltNames[iNdEx])
			i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.SubjectAltNames[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.CaCertificates) > 0 {
		i -= len(m.CaCertificates)
		copy(dAtA[i:], m.CaCertificates)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.CaCertificates)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.PrivateKey) > 0 {
		i -= len(m.PrivateKey)
		copy(dAtA[i:], m.PrivateKey)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.PrivateKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ClientCertificate) > 0 {
		i -= len(m.ClientCertificate)
		copy(dAtA[i:], m.ClientCertificate)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.ClientCertificate)))
		i--
		dAtA[i] = 0x12
	}
	if m.Mode != 0 {
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Mode))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LocalityLoadBalancerSetting) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityLoadBalancerSetting) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LocalityLoadBalancerSetting) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Enabled != nil {
		{
			size, err := m.Enabled.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDestinationRule(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Failover) > 0 {
		for iNdEx := len(m.Failover) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Failover[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDestinationRule(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Distribute) > 0 {
		for iNdEx := len(m.Distribute) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Distribute[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDestinationRule(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LocalityLoadBalancerSetting_Distribute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityLoadBalancerSetting_Distribute) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LocalityLoadBalancerSetting_Distribute) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.To) > 0 {
		for k := range m.To {
			v := m.To[k]
			baseI := i
			i = encodeVarintDestinationRule(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintDestinationRule(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintDestinationRule(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.From) > 0 {
		i -= len(m.From)
		copy(dAtA[i:], m.From)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.From)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LocalityLoadBalancerSetting_Failover) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityLoadBalancerSetting_Failover) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LocalityLoadBalancerSetting_Failover) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.To) > 0 {
		i -= len(m.To)
		copy(dAtA[i:], m.To)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.To)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.From) > 0 {
		i -= len(m.From)
		copy(dAtA[i:], m.From)
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.From)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintDestinationRule(dAtA []byte, offset int, v uint64) int {
	offset -= sovDestinationRule(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DestinationRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.TrafficPolicy != nil {
		l = m.TrafficPolicy.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.Subsets) > 0 {
		for _, e := range m.Subsets {
			l = e.Size()
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	if len(m.ExportTo) > 0 {
		for _, s := range m.ExportTo {
			l = len(s)
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TrafficPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LoadBalancer != nil {
		l = m.LoadBalancer.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.ConnectionPool != nil {
		l = m.ConnectionPool.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Tls != nil {
		l = m.Tls.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.PortLevelSettings) > 0 {
		for _, e := range m.PortLevelSettings {
			l = e.Size()
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TrafficPolicy_PortTrafficPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.LoadBalancer != nil {
		l = m.LoadBalancer.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.ConnectionPool != nil {
		l = m.ConnectionPool.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Tls != nil {
		l = m.Tls.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Subset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovDestinationRule(uint64(len(k))) + 1 + len(v) + sovDestinationRule(uint64(len(v)))
			n += mapEntrySize + 1 + sovDestinationRule(uint64(mapEntrySize))
		}
	}
	if m.TrafficPolicy != nil {
		l = m.TrafficPolicy.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoadBalancerSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LbPolicy != nil {
		n += m.LbPolicy.Size()
	}
	if m.LocalityLbSetting != nil {
		l = m.LocalityLbSetting.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoadBalancerSettings_Simple) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovDestinationRule(uint64(m.Simple))
	return n
}
func (m *LoadBalancerSettings_ConsistentHash) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsistentHash != nil {
		l = m.ConsistentHash.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}
func (m *LoadBalancerSettings_ConsistentHashLB) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HashKey != nil {
		n += m.HashKey.Size()
	}
	if m.MinimumRingSize != 0 {
		n += 1 + sovDestinationRule(uint64(m.MinimumRingSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoadBalancerSettings_ConsistentHashLB_HttpHeaderName) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HttpHeaderName)
	n += 1 + l + sovDestinationRule(uint64(l))
	return n
}
func (m *LoadBalancerSettings_ConsistentHashLB_HttpCookie) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HttpCookie != nil {
		l = m.HttpCookie.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}
func (m *LoadBalancerSettings_ConsistentHashLB_UseSourceIp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HttpQueryParameterName)
	n += 1 + l + sovDestinationRule(uint64(l))
	return n
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Ttl != nil {
		l = m.Ttl.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectionPoolSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Tcp != nil {
		l = m.Tcp.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Http != nil {
		l = m.Http.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectionPoolSettings_TCPSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MaxConnections != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxConnections))
	}
	if m.ConnectTimeout != nil {
		l = m.ConnectTimeout.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.TcpKeepalive != nil {
		l = m.TcpKeepalive.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Probes != 0 {
		n += 1 + sovDestinationRule(uint64(m.Probes))
	}
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Interval != nil {
		l = m.Interval.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectionPoolSettings_HTTPSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Http1MaxPendingRequests != 0 {
		n += 1 + sovDestinationRule(uint64(m.Http1MaxPendingRequests))
	}
	if m.Http2MaxRequests != 0 {
		n += 1 + sovDestinationRule(uint64(m.Http2MaxRequests))
	}
	if m.MaxRequestsPerConnection != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxRequestsPerConnection))
	}
	if m.MaxRetries != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxRetries))
	}
	if m.IdleTimeout != nil {
		l = m.IdleTimeout.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.H2UpgradePolicy != 0 {
		n += 1 + sovDestinationRule(uint64(m.H2UpgradePolicy))
	}
	if m.UseClientProtocol {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OutlierDetection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConsecutiveErrors != 0 {
		n += 1 + sovDestinationRule(uint64(m.ConsecutiveErrors))
	}
	if m.Interval != nil {
		l = m.Interval.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.BaseEjectionTime != nil {
		l = m.BaseEjectionTime.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.MaxEjectionPercent != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxEjectionPercent))
	}
	if m.MinHealthPercent != 0 {
		n += 1 + sovDestinationRule(uint64(m.MinHealthPercent))
	}
	if m.ConsecutiveGatewayErrors != nil {
		l = m.ConsecutiveGatewayErrors.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Consecutive_5XxErrors != nil {
		l = m.Consecutive_5XxErrors.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClientTLSSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovDestinationRule(uint64(m.Mode))
	}
	l = len(m.ClientCertificate)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	l = len(m.PrivateKey)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	l = len(m.CaCertificates)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.SubjectAltNames) > 0 {
		for _, s := range m.SubjectAltNames {
			l = len(s)
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	l = len(m.Sni)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	l = len(m.CredentialName)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalityLoadBalancerSetting) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Distribute) > 0 {
		for _, e := range m.Distribute {
			l = e.Size()
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	if len(m.Failover) > 0 {
		for _, e := range m.Failover {
			l = e.Size()
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	if m.Enabled != nil {
		l = m.Enabled.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalityLoadBalancerSetting_Distribute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.From)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.To) > 0 {
		for k, v := range m.To {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovDestinationRule(uint64(len(k))) + 1 + sovDestinationRule(uint64(v))
			n += mapEntrySize + 1 + sovDestinationRule(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LocalityLoadBalancerSetting_Failover) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.From)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	l = len(m.To)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovDestinationRule(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozDestinationRule(x uint64) (n int) {
	return sovDestinationRule(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DestinationRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestinationRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestinationRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrafficPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrafficPolicy == nil {
				m.TrafficPolicy = &TrafficPolicy{}
			}
			if err := m.TrafficPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subsets = append(m.Subsets, &Subset{})
			if err := m.Subsets[len(m.Subsets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExportTo = append(m.ExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TrafficPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TrafficPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TrafficPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadBalancer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadBalancer == nil {
				m.LoadBalancer = &LoadBalancerSettings{}
			}
			if err := m.LoadBalancer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionPool", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectionPool == nil {
				m.ConnectionPool = &ConnectionPoolSettings{}
			}
			if err := m.ConnectionPool.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tls == nil {
				m.Tls = &ClientTLSSettings{}
			}
			if err := m.Tls.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortLevelSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortLevelSettings = append(m.PortLevelSettings, &TrafficPolicy_PortTrafficPolicy{})
			if err := m.PortLevelSettings[len(m.PortLevelSettings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TrafficPolicy_PortTrafficPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortTrafficPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortTrafficPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Port == nil {
				m.Port = &PortSelector{}
			}
			if err := m.Port.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadBalancer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadBalancer == nil {
				m.LoadBalancer = &LoadBalancerSettings{}
			}
			if err := m.LoadBalancer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionPool", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectionPool == nil {
				m.ConnectionPool = &ConnectionPoolSettings{}
			}
			if err := m.ConnectionPool.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tls == nil {
				m.Tls = &ClientTLSSettings{}
			}
			if err := m.Tls.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDestinationRule
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDestinationRule
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDestinationRule
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthDestinationRule
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDestinationRule
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthDestinationRule
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthDestinationRule
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDestinationRule(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthDestinationRule
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrafficPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrafficPolicy == nil {
				m.TrafficPolicy = &TrafficPolicy{}
			}
			if err := m.TrafficPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadBalancerSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadBalancerSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadBalancerSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Simple", wireType)
			}
			var v LoadBalancerSettings_SimpleLB
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= LoadBalancerSettings_SimpleLB(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LbPolicy = &LoadBalancerSettings_Simple{v}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsistentHash", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LoadBalancerSettings_ConsistentHashLB{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbPolicy = &LoadBalancerSettings_ConsistentHash{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityLbSetting", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalityLbSetting == nil {
				m.LocalityLbSetting = &LocalityLoadBalancerSetting{}
			}
			if err := m.LocalityLbSetting.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadBalancerSettings_ConsistentHashLB) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConsistentHashLB: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConsistentHashLB: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpHeaderName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HashKey = &LoadBalancerSettings_ConsistentHashLB_HttpHeaderName{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpCookie", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LoadBalancerSettings_ConsistentHashLB_HTTPCookie{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HashKey = &LoadBalancerSettings_ConsistentHashLB_HttpCookie{v}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseSourceIp", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.HashKey = &LoadBalancerSettings_ConsistentHashLB_UseSourceIp{b}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinimumRingSize", wireType)
			}
			m.MinimumRingSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinimumRingSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpQueryParameterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HashKey = &LoadBalancerSettings_ConsistentHashLB_HttpQueryParameterName{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadBalancerSettings_ConsistentHashLB_HTTPCookie) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPCookie: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPCookie: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ttl == nil {
				m.Ttl = &types.Duration{}
			}
			if err := m.Ttl.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionPoolSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectionPoolSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectionPoolSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tcp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tcp == nil {
				m.Tcp = &ConnectionPoolSettings_TCPSettings{}
			}
			if err := m.Tcp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http == nil {
				m.Http = &ConnectionPoolSettings_HTTPSettings{}
			}
			if err := m.Http.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionPoolSettings_TCPSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxConnections", wireType)
			}
			m.MaxConnections = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxConnections |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectTimeout == nil {
				m.ConnectTimeout = &types.Duration{}
			}
			if err := m.ConnectTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpKeepalive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpKeepalive == nil {
				m.TcpKeepalive = &ConnectionPoolSettings_TCPSettings_TcpKeepalive{}
			}
			if err := m.TcpKeepalive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionPoolSettings_TCPSettings_TcpKeepalive) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TcpKeepalive: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TcpKeepalive: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Probes", wireType)
			}
			m.Probes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Probes |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Duration{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = &types.Duration{}
			}
			if err := m.Interval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionPoolSettings_HTTPSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http1MaxPendingRequests", wireType)
			}
			m.Http1MaxPendingRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Http1MaxPendingRequests |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2MaxRequests", wireType)
			}
			m.Http2MaxRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Http2MaxRequests |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRequestsPerConnection", wireType)
			}
			m.MaxRequestsPerConnection = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRequestsPerConnection |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRetries", wireType)
			}
			m.MaxRetries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRetries |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IdleTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IdleTimeout == nil {
				m.IdleTimeout = &types.Duration{}
			}
			if err := m.IdleTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field H2UpgradePolicy", wireType)
			}
			m.H2UpgradePolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.H2UpgradePolicy |= ConnectionPoolSettings_HTTPSettings_H2UpgradePolicy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseClientProtocol", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseClientProtocol = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutlierDetection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierDetection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierDetection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsecutiveErrors", wireType)
			}
			m.ConsecutiveErrors = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConsecutiveErrors |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = &types.Duration{}
			}
			if err := m.Interval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseEjectionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseEjectionTime == nil {
				m.BaseEjectionTime = &types.Duration{}
			}
			if err := m.BaseEjectionTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxEjectionPercent", wireType)
			}
			m.MaxEjectionPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxEjectionPercent |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinHealthPercent", wireType)
			}
			m.MinHealthPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinHealthPercent |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsecutiveGatewayErrors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsecutiveGatewayErrors == nil {
				m.ConsecutiveGatewayErrors = &types.UInt32Value{}
			}
			if err := m.ConsecutiveGatewayErrors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Consecutive_5XxErrors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Consecutive_5XxErrors == nil {
				m.Consecutive_5XxErrors = &types.UInt32Value{}
			}
			if err := m.Consecutive_5XxErrors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientTLSSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientTLSSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientTLSSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= ClientTLSSettings_TLSmode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertificate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertificate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificates", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificates = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectAltNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectAltNames = append(m.SubjectAltNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sni", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sni = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityLoadBalancerSetting) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalityLoadBalancerSetting: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalityLoadBalancerSetting: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Distribute", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Distribute = append(m.Distribute, &LocalityLoadBalancerSetting_Distribute{})
			if err := m.Distribute[len(m.Distribute)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failover", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Failover = append(m.Failover, &LocalityLoadBalancerSetting_Failover{})
			if err := m.Failover[len(m.Failover)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Enabled == nil {
				m.Enabled = &types.BoolValue{}
			}
			if err := m.Enabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityLoadBalancerSetting_Distribute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Distribute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Distribute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.From = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = make(map[string]uint32)
			}
			var mapkey string
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDestinationRule
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDestinationRule
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDestinationRule
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthDestinationRule
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDestinationRule
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDestinationRule(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthDestinationRule
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.To[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityLoadBalancerSetting_Failover) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Failover: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Failover: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.From = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.To = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDestinationRule(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthDestinationRule
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupDestinationRule
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthDestinationRule
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthDestinationRule        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDestinationRule          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupDestinationRule = fmt.Errorf("proto: unexpected end of group")
)
