// +build !ignore_autogenerated

/*
Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	core "github.com/gardener/gardener/pkg/apis/core"
	v1beta1 "github.com/gardener/gardener/pkg/apis/core/v1beta1"
	seedmanagement "github.com/gardener/gardener/pkg/apis/seedmanagement"
	v1 "k8s.io/api/core/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*GardenletDeployment)(nil), (*seedmanagement.GardenletDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GardenletDeployment_To_seedmanagement_GardenletDeployment(a.(*GardenletDeployment), b.(*seedmanagement.GardenletDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*seedmanagement.GardenletDeployment)(nil), (*GardenletDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_GardenletDeployment_To_v1alpha1_GardenletDeployment(a.(*seedmanagement.GardenletDeployment), b.(*GardenletDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Image)(nil), (*seedmanagement.Image)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Image_To_seedmanagement_Image(a.(*Image), b.(*seedmanagement.Image), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*seedmanagement.Image)(nil), (*Image)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_Image_To_v1alpha1_Image(a.(*seedmanagement.Image), b.(*Image), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ManagedSeed)(nil), (*seedmanagement.ManagedSeed)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ManagedSeed_To_seedmanagement_ManagedSeed(a.(*ManagedSeed), b.(*seedmanagement.ManagedSeed), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*seedmanagement.ManagedSeed)(nil), (*ManagedSeed)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_ManagedSeed_To_v1alpha1_ManagedSeed(a.(*seedmanagement.ManagedSeed), b.(*ManagedSeed), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ManagedSeedList)(nil), (*seedmanagement.ManagedSeedList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ManagedSeedList_To_seedmanagement_ManagedSeedList(a.(*ManagedSeedList), b.(*seedmanagement.ManagedSeedList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*seedmanagement.ManagedSeedList)(nil), (*ManagedSeedList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_ManagedSeedList_To_v1alpha1_ManagedSeedList(a.(*seedmanagement.ManagedSeedList), b.(*ManagedSeedList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ManagedSeedSpec)(nil), (*seedmanagement.ManagedSeedSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ManagedSeedSpec_To_seedmanagement_ManagedSeedSpec(a.(*ManagedSeedSpec), b.(*seedmanagement.ManagedSeedSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*seedmanagement.ManagedSeedSpec)(nil), (*ManagedSeedSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_ManagedSeedSpec_To_v1alpha1_ManagedSeedSpec(a.(*seedmanagement.ManagedSeedSpec), b.(*ManagedSeedSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ManagedSeedStatus)(nil), (*seedmanagement.ManagedSeedStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ManagedSeedStatus_To_seedmanagement_ManagedSeedStatus(a.(*ManagedSeedStatus), b.(*seedmanagement.ManagedSeedStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*seedmanagement.ManagedSeedStatus)(nil), (*ManagedSeedStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_ManagedSeedStatus_To_v1alpha1_ManagedSeedStatus(a.(*seedmanagement.ManagedSeedStatus), b.(*ManagedSeedStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Shoot)(nil), (*seedmanagement.Shoot)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Shoot_To_seedmanagement_Shoot(a.(*Shoot), b.(*seedmanagement.Shoot), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*seedmanagement.Shoot)(nil), (*Shoot)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_Shoot_To_v1alpha1_Shoot(a.(*seedmanagement.Shoot), b.(*Shoot), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*seedmanagement.Gardenlet)(nil), (*Gardenlet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_seedmanagement_Gardenlet_To_v1alpha1_Gardenlet(a.(*seedmanagement.Gardenlet), b.(*Gardenlet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*Gardenlet)(nil), (*seedmanagement.Gardenlet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Gardenlet_To_seedmanagement_Gardenlet(a.(*Gardenlet), b.(*seedmanagement.Gardenlet), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_Gardenlet_To_seedmanagement_Gardenlet(in *Gardenlet, out *seedmanagement.Gardenlet, s conversion.Scope) error {
	out.Deployment = (*seedmanagement.GardenletDeployment)(unsafe.Pointer(in.Deployment))
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.Config, &out.Config, s); err != nil {
		return err
	}
	out.Bootstrap = (*seedmanagement.Bootstrap)(unsafe.Pointer(in.Bootstrap))
	out.MergeWithParent = (*bool)(unsafe.Pointer(in.MergeWithParent))
	return nil
}

func autoConvert_seedmanagement_Gardenlet_To_v1alpha1_Gardenlet(in *seedmanagement.Gardenlet, out *Gardenlet, s conversion.Scope) error {
	out.Deployment = (*GardenletDeployment)(unsafe.Pointer(in.Deployment))
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.Config, &out.Config, s); err != nil {
		return err
	}
	out.Bootstrap = (*Bootstrap)(unsafe.Pointer(in.Bootstrap))
	out.MergeWithParent = (*bool)(unsafe.Pointer(in.MergeWithParent))
	return nil
}

func autoConvert_v1alpha1_GardenletDeployment_To_seedmanagement_GardenletDeployment(in *GardenletDeployment, out *seedmanagement.GardenletDeployment, s conversion.Scope) error {
	out.ReplicaCount = (*int32)(unsafe.Pointer(in.ReplicaCount))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.ServiceAccountName = (*string)(unsafe.Pointer(in.ServiceAccountName))
	out.Image = (*seedmanagement.Image)(unsafe.Pointer(in.Image))
	out.Resources = (*v1.ResourceRequirements)(unsafe.Pointer(in.Resources))
	out.PodLabels = *(*map[string]string)(unsafe.Pointer(&in.PodLabels))
	out.PodAnnotations = *(*map[string]string)(unsafe.Pointer(&in.PodAnnotations))
	out.AdditionalVolumes = *(*[]v1.Volume)(unsafe.Pointer(&in.AdditionalVolumes))
	out.AdditionalVolumeMounts = *(*[]v1.VolumeMount)(unsafe.Pointer(&in.AdditionalVolumeMounts))
	out.Env = *(*[]v1.EnvVar)(unsafe.Pointer(&in.Env))
	out.VPA = (*bool)(unsafe.Pointer(in.VPA))
	return nil
}

// Convert_v1alpha1_GardenletDeployment_To_seedmanagement_GardenletDeployment is an autogenerated conversion function.
func Convert_v1alpha1_GardenletDeployment_To_seedmanagement_GardenletDeployment(in *GardenletDeployment, out *seedmanagement.GardenletDeployment, s conversion.Scope) error {
	return autoConvert_v1alpha1_GardenletDeployment_To_seedmanagement_GardenletDeployment(in, out, s)
}

func autoConvert_seedmanagement_GardenletDeployment_To_v1alpha1_GardenletDeployment(in *seedmanagement.GardenletDeployment, out *GardenletDeployment, s conversion.Scope) error {
	out.ReplicaCount = (*int32)(unsafe.Pointer(in.ReplicaCount))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.ServiceAccountName = (*string)(unsafe.Pointer(in.ServiceAccountName))
	out.Image = (*Image)(unsafe.Pointer(in.Image))
	out.Resources = (*v1.ResourceRequirements)(unsafe.Pointer(in.Resources))
	out.PodLabels = *(*map[string]string)(unsafe.Pointer(&in.PodLabels))
	out.PodAnnotations = *(*map[string]string)(unsafe.Pointer(&in.PodAnnotations))
	out.AdditionalVolumes = *(*[]v1.Volume)(unsafe.Pointer(&in.AdditionalVolumes))
	out.AdditionalVolumeMounts = *(*[]v1.VolumeMount)(unsafe.Pointer(&in.AdditionalVolumeMounts))
	out.Env = *(*[]v1.EnvVar)(unsafe.Pointer(&in.Env))
	out.VPA = (*bool)(unsafe.Pointer(in.VPA))
	return nil
}

// Convert_seedmanagement_GardenletDeployment_To_v1alpha1_GardenletDeployment is an autogenerated conversion function.
func Convert_seedmanagement_GardenletDeployment_To_v1alpha1_GardenletDeployment(in *seedmanagement.GardenletDeployment, out *GardenletDeployment, s conversion.Scope) error {
	return autoConvert_seedmanagement_GardenletDeployment_To_v1alpha1_GardenletDeployment(in, out, s)
}

func autoConvert_v1alpha1_Image_To_seedmanagement_Image(in *Image, out *seedmanagement.Image, s conversion.Scope) error {
	out.Repository = (*string)(unsafe.Pointer(in.Repository))
	out.Tag = (*string)(unsafe.Pointer(in.Tag))
	out.PullPolicy = (*v1.PullPolicy)(unsafe.Pointer(in.PullPolicy))
	return nil
}

// Convert_v1alpha1_Image_To_seedmanagement_Image is an autogenerated conversion function.
func Convert_v1alpha1_Image_To_seedmanagement_Image(in *Image, out *seedmanagement.Image, s conversion.Scope) error {
	return autoConvert_v1alpha1_Image_To_seedmanagement_Image(in, out, s)
}

func autoConvert_seedmanagement_Image_To_v1alpha1_Image(in *seedmanagement.Image, out *Image, s conversion.Scope) error {
	out.Repository = (*string)(unsafe.Pointer(in.Repository))
	out.Tag = (*string)(unsafe.Pointer(in.Tag))
	out.PullPolicy = (*v1.PullPolicy)(unsafe.Pointer(in.PullPolicy))
	return nil
}

// Convert_seedmanagement_Image_To_v1alpha1_Image is an autogenerated conversion function.
func Convert_seedmanagement_Image_To_v1alpha1_Image(in *seedmanagement.Image, out *Image, s conversion.Scope) error {
	return autoConvert_seedmanagement_Image_To_v1alpha1_Image(in, out, s)
}

func autoConvert_v1alpha1_ManagedSeed_To_seedmanagement_ManagedSeed(in *ManagedSeed, out *seedmanagement.ManagedSeed, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ManagedSeedSpec_To_seedmanagement_ManagedSeedSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ManagedSeedStatus_To_seedmanagement_ManagedSeedStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ManagedSeed_To_seedmanagement_ManagedSeed is an autogenerated conversion function.
func Convert_v1alpha1_ManagedSeed_To_seedmanagement_ManagedSeed(in *ManagedSeed, out *seedmanagement.ManagedSeed, s conversion.Scope) error {
	return autoConvert_v1alpha1_ManagedSeed_To_seedmanagement_ManagedSeed(in, out, s)
}

func autoConvert_seedmanagement_ManagedSeed_To_v1alpha1_ManagedSeed(in *seedmanagement.ManagedSeed, out *ManagedSeed, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_seedmanagement_ManagedSeedSpec_To_v1alpha1_ManagedSeedSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_seedmanagement_ManagedSeedStatus_To_v1alpha1_ManagedSeedStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_seedmanagement_ManagedSeed_To_v1alpha1_ManagedSeed is an autogenerated conversion function.
func Convert_seedmanagement_ManagedSeed_To_v1alpha1_ManagedSeed(in *seedmanagement.ManagedSeed, out *ManagedSeed, s conversion.Scope) error {
	return autoConvert_seedmanagement_ManagedSeed_To_v1alpha1_ManagedSeed(in, out, s)
}

func autoConvert_v1alpha1_ManagedSeedList_To_seedmanagement_ManagedSeedList(in *ManagedSeedList, out *seedmanagement.ManagedSeedList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]seedmanagement.ManagedSeed, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_ManagedSeed_To_seedmanagement_ManagedSeed(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_ManagedSeedList_To_seedmanagement_ManagedSeedList is an autogenerated conversion function.
func Convert_v1alpha1_ManagedSeedList_To_seedmanagement_ManagedSeedList(in *ManagedSeedList, out *seedmanagement.ManagedSeedList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ManagedSeedList_To_seedmanagement_ManagedSeedList(in, out, s)
}

func autoConvert_seedmanagement_ManagedSeedList_To_v1alpha1_ManagedSeedList(in *seedmanagement.ManagedSeedList, out *ManagedSeedList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ManagedSeed, len(*in))
		for i := range *in {
			if err := Convert_seedmanagement_ManagedSeed_To_v1alpha1_ManagedSeed(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_seedmanagement_ManagedSeedList_To_v1alpha1_ManagedSeedList is an autogenerated conversion function.
func Convert_seedmanagement_ManagedSeedList_To_v1alpha1_ManagedSeedList(in *seedmanagement.ManagedSeedList, out *ManagedSeedList, s conversion.Scope) error {
	return autoConvert_seedmanagement_ManagedSeedList_To_v1alpha1_ManagedSeedList(in, out, s)
}

func autoConvert_v1alpha1_ManagedSeedSpec_To_seedmanagement_ManagedSeedSpec(in *ManagedSeedSpec, out *seedmanagement.ManagedSeedSpec, s conversion.Scope) error {
	if err := Convert_v1alpha1_Shoot_To_seedmanagement_Shoot(&in.Shoot, &out.Shoot, s); err != nil {
		return err
	}
	if in.SeedTemplate != nil {
		in, out := &in.SeedTemplate, &out.SeedTemplate
		*out = new(core.SeedTemplate)
		// TODO: Inefficient conversion - can we improve it?
		if err := s.Convert(*in, *out, 0); err != nil {
			return err
		}
	} else {
		out.SeedTemplate = nil
	}
	if in.Gardenlet != nil {
		in, out := &in.Gardenlet, &out.Gardenlet
		*out = new(seedmanagement.Gardenlet)
		if err := Convert_v1alpha1_Gardenlet_To_seedmanagement_Gardenlet(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Gardenlet = nil
	}
	return nil
}

// Convert_v1alpha1_ManagedSeedSpec_To_seedmanagement_ManagedSeedSpec is an autogenerated conversion function.
func Convert_v1alpha1_ManagedSeedSpec_To_seedmanagement_ManagedSeedSpec(in *ManagedSeedSpec, out *seedmanagement.ManagedSeedSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ManagedSeedSpec_To_seedmanagement_ManagedSeedSpec(in, out, s)
}

func autoConvert_seedmanagement_ManagedSeedSpec_To_v1alpha1_ManagedSeedSpec(in *seedmanagement.ManagedSeedSpec, out *ManagedSeedSpec, s conversion.Scope) error {
	if err := Convert_seedmanagement_Shoot_To_v1alpha1_Shoot(&in.Shoot, &out.Shoot, s); err != nil {
		return err
	}
	if in.SeedTemplate != nil {
		in, out := &in.SeedTemplate, &out.SeedTemplate
		*out = new(v1beta1.SeedTemplate)
		// TODO: Inefficient conversion - can we improve it?
		if err := s.Convert(*in, *out, 0); err != nil {
			return err
		}
	} else {
		out.SeedTemplate = nil
	}
	if in.Gardenlet != nil {
		in, out := &in.Gardenlet, &out.Gardenlet
		*out = new(Gardenlet)
		if err := Convert_seedmanagement_Gardenlet_To_v1alpha1_Gardenlet(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Gardenlet = nil
	}
	return nil
}

// Convert_seedmanagement_ManagedSeedSpec_To_v1alpha1_ManagedSeedSpec is an autogenerated conversion function.
func Convert_seedmanagement_ManagedSeedSpec_To_v1alpha1_ManagedSeedSpec(in *seedmanagement.ManagedSeedSpec, out *ManagedSeedSpec, s conversion.Scope) error {
	return autoConvert_seedmanagement_ManagedSeedSpec_To_v1alpha1_ManagedSeedSpec(in, out, s)
}

func autoConvert_v1alpha1_ManagedSeedStatus_To_seedmanagement_ManagedSeedStatus(in *ManagedSeedStatus, out *seedmanagement.ManagedSeedStatus, s conversion.Scope) error {
	out.Conditions = *(*[]core.Condition)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1alpha1_ManagedSeedStatus_To_seedmanagement_ManagedSeedStatus is an autogenerated conversion function.
func Convert_v1alpha1_ManagedSeedStatus_To_seedmanagement_ManagedSeedStatus(in *ManagedSeedStatus, out *seedmanagement.ManagedSeedStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_ManagedSeedStatus_To_seedmanagement_ManagedSeedStatus(in, out, s)
}

func autoConvert_seedmanagement_ManagedSeedStatus_To_v1alpha1_ManagedSeedStatus(in *seedmanagement.ManagedSeedStatus, out *ManagedSeedStatus, s conversion.Scope) error {
	out.Conditions = *(*[]v1beta1.Condition)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_seedmanagement_ManagedSeedStatus_To_v1alpha1_ManagedSeedStatus is an autogenerated conversion function.
func Convert_seedmanagement_ManagedSeedStatus_To_v1alpha1_ManagedSeedStatus(in *seedmanagement.ManagedSeedStatus, out *ManagedSeedStatus, s conversion.Scope) error {
	return autoConvert_seedmanagement_ManagedSeedStatus_To_v1alpha1_ManagedSeedStatus(in, out, s)
}

func autoConvert_v1alpha1_Shoot_To_seedmanagement_Shoot(in *Shoot, out *seedmanagement.Shoot, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_Shoot_To_seedmanagement_Shoot is an autogenerated conversion function.
func Convert_v1alpha1_Shoot_To_seedmanagement_Shoot(in *Shoot, out *seedmanagement.Shoot, s conversion.Scope) error {
	return autoConvert_v1alpha1_Shoot_To_seedmanagement_Shoot(in, out, s)
}

func autoConvert_seedmanagement_Shoot_To_v1alpha1_Shoot(in *seedmanagement.Shoot, out *Shoot, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_seedmanagement_Shoot_To_v1alpha1_Shoot is an autogenerated conversion function.
func Convert_seedmanagement_Shoot_To_v1alpha1_Shoot(in *seedmanagement.Shoot, out *Shoot, s conversion.Scope) error {
	return autoConvert_seedmanagement_Shoot_To_v1alpha1_Shoot(in, out, s)
}
