/*
Copyright 2024 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package primitives

import (
	"testing"

	field "k8s.io/apimachinery/pkg/util/validation/field"
)

func Test(t *testing.T) {
	st := localSchemeBuilder.Test(t)

	structA := Struct{
		S: "zero",
		I: 0,
		B: false,
		F: 0.0,
	}

	// Different data.
	structB := Struct{
		S: "one",
		I: 1,
		B: true,
		F: 1.1,
	}

	st.Value(&structA).OldValue(&structA).ExpectValid()

	st.Value(&structA).OldValue(&structB).ExpectMatches(field.ErrorMatcher{}.ByType().ByField().ByDetailSubstring().ByOrigin(), field.ErrorList{
		field.Invalid(field.NewPath("s"), nil, "").WithOrigin("immutable"),
		field.Invalid(field.NewPath("i"), nil, "").WithOrigin("immutable"),
		field.Invalid(field.NewPath("b"), nil, "").WithOrigin("immutable"),
		field.Invalid(field.NewPath("f"), nil, "").WithOrigin("immutable"),
	})
}
