/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/podresources/v1/api.proto

package v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AllocatableResourcesRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AllocatableResourcesRequest) Reset() {
	*x = AllocatableResourcesRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocatableResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocatableResourcesRequest) ProtoMessage() {}

func (x *AllocatableResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocatableResourcesRequest.ProtoReflect.Descriptor instead.
func (*AllocatableResourcesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{0}
}

// AllocatableResourcesResponses contains informations about all the devices known by the kubelet
type AllocatableResourcesResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Devices       []*ContainerDevices    `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	CpuIds        []int64                `protobuf:"varint,2,rep,packed,name=cpu_ids,json=cpuIds,proto3" json:"cpu_ids,omitempty"`
	Memory        []*ContainerMemory     `protobuf:"bytes,3,rep,name=memory,proto3" json:"memory,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AllocatableResourcesResponse) Reset() {
	*x = AllocatableResourcesResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocatableResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocatableResourcesResponse) ProtoMessage() {}

func (x *AllocatableResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocatableResourcesResponse.ProtoReflect.Descriptor instead.
func (*AllocatableResourcesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{1}
}

func (x *AllocatableResourcesResponse) GetDevices() []*ContainerDevices {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *AllocatableResourcesResponse) GetCpuIds() []int64 {
	if x != nil {
		return x.CpuIds
	}
	return nil
}

func (x *AllocatableResourcesResponse) GetMemory() []*ContainerMemory {
	if x != nil {
		return x.Memory
	}
	return nil
}

// ListPodResourcesRequest is the request made to the PodResourcesLister service
type ListPodResourcesRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodResourcesRequest) Reset() {
	*x = ListPodResourcesRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodResourcesRequest) ProtoMessage() {}

func (x *ListPodResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodResourcesRequest.ProtoReflect.Descriptor instead.
func (*ListPodResourcesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{2}
}

// ListPodResourcesResponse is the response returned by List function
type ListPodResourcesResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PodResources  []*PodResources        `protobuf:"bytes,1,rep,name=pod_resources,json=podResources,proto3" json:"pod_resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListPodResourcesResponse) Reset() {
	*x = ListPodResourcesResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPodResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPodResourcesResponse) ProtoMessage() {}

func (x *ListPodResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPodResourcesResponse.ProtoReflect.Descriptor instead.
func (*ListPodResourcesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{3}
}

func (x *ListPodResourcesResponse) GetPodResources() []*PodResources {
	if x != nil {
		return x.PodResources
	}
	return nil
}

// PodResources contains information about the node resources assigned to a pod
type PodResources struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Containers    []*ContainerResources  `protobuf:"bytes,3,rep,name=containers,proto3" json:"containers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PodResources) Reset() {
	*x = PodResources{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodResources) ProtoMessage() {}

func (x *PodResources) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodResources.ProtoReflect.Descriptor instead.
func (*PodResources) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{4}
}

func (x *PodResources) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PodResources) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *PodResources) GetContainers() []*ContainerResources {
	if x != nil {
		return x.Containers
	}
	return nil
}

// ContainerResources contains information about the resources assigned to a container
type ContainerResources struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Name             string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Devices          []*ContainerDevices    `protobuf:"bytes,2,rep,name=devices,proto3" json:"devices,omitempty"`
	CpuIds           []int64                `protobuf:"varint,3,rep,packed,name=cpu_ids,json=cpuIds,proto3" json:"cpu_ids,omitempty"`
	Memory           []*ContainerMemory     `protobuf:"bytes,4,rep,name=memory,proto3" json:"memory,omitempty"`
	DynamicResources []*DynamicResource     `protobuf:"bytes,5,rep,name=dynamic_resources,json=dynamicResources,proto3" json:"dynamic_resources,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ContainerResources) Reset() {
	*x = ContainerResources{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerResources) ProtoMessage() {}

func (x *ContainerResources) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerResources.ProtoReflect.Descriptor instead.
func (*ContainerResources) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{5}
}

func (x *ContainerResources) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ContainerResources) GetDevices() []*ContainerDevices {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *ContainerResources) GetCpuIds() []int64 {
	if x != nil {
		return x.CpuIds
	}
	return nil
}

func (x *ContainerResources) GetMemory() []*ContainerMemory {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *ContainerResources) GetDynamicResources() []*DynamicResource {
	if x != nil {
		return x.DynamicResources
	}
	return nil
}

// ContainerMemory contains information about memory and hugepages assigned to a container
type ContainerMemory struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MemoryType    string                 `protobuf:"bytes,1,opt,name=memory_type,json=memoryType,proto3" json:"memory_type,omitempty"`
	Size          uint64                 `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	Topology      *TopologyInfo          `protobuf:"bytes,3,opt,name=topology,proto3" json:"topology,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerMemory) Reset() {
	*x = ContainerMemory{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerMemory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerMemory) ProtoMessage() {}

func (x *ContainerMemory) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerMemory.ProtoReflect.Descriptor instead.
func (*ContainerMemory) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{6}
}

func (x *ContainerMemory) GetMemoryType() string {
	if x != nil {
		return x.MemoryType
	}
	return ""
}

func (x *ContainerMemory) GetSize() uint64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *ContainerMemory) GetTopology() *TopologyInfo {
	if x != nil {
		return x.Topology
	}
	return nil
}

// ContainerDevices contains information about the devices assigned to a container
type ContainerDevices struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ResourceName  string                 `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	DeviceIds     []string               `protobuf:"bytes,2,rep,name=device_ids,json=deviceIds,proto3" json:"device_ids,omitempty"`
	Topology      *TopologyInfo          `protobuf:"bytes,3,opt,name=topology,proto3" json:"topology,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ContainerDevices) Reset() {
	*x = ContainerDevices{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerDevices) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerDevices) ProtoMessage() {}

func (x *ContainerDevices) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerDevices.ProtoReflect.Descriptor instead.
func (*ContainerDevices) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{7}
}

func (x *ContainerDevices) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *ContainerDevices) GetDeviceIds() []string {
	if x != nil {
		return x.DeviceIds
	}
	return nil
}

func (x *ContainerDevices) GetTopology() *TopologyInfo {
	if x != nil {
		return x.Topology
	}
	return nil
}

// Topology describes hardware topology of the resource
type TopologyInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Nodes         []*NUMANode            `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TopologyInfo) Reset() {
	*x = TopologyInfo{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TopologyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopologyInfo) ProtoMessage() {}

func (x *TopologyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopologyInfo.ProtoReflect.Descriptor instead.
func (*TopologyInfo) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{8}
}

func (x *TopologyInfo) GetNodes() []*NUMANode {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// NUMA representation of NUMA node
type NUMANode struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ID            int64                  `protobuf:"varint,1,opt,name=ID,proto3" json:"ID,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NUMANode) Reset() {
	*x = NUMANode{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NUMANode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NUMANode) ProtoMessage() {}

func (x *NUMANode) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NUMANode.ProtoReflect.Descriptor instead.
func (*NUMANode) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{9}
}

func (x *NUMANode) GetID() int64 {
	if x != nil {
		return x.ID
	}
	return 0
}

// DynamicResource contains information about the devices assigned to a container by DRA
type DynamicResource struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// tombstone: removed in 1.31 because claims are no longer associated with one class
	// string class_name = 1;
	ClaimName      string           `protobuf:"bytes,2,opt,name=claim_name,json=claimName,proto3" json:"claim_name,omitempty"`
	ClaimNamespace string           `protobuf:"bytes,3,opt,name=claim_namespace,json=claimNamespace,proto3" json:"claim_namespace,omitempty"`
	ClaimResources []*ClaimResource `protobuf:"bytes,4,rep,name=claim_resources,json=claimResources,proto3" json:"claim_resources,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *DynamicResource) Reset() {
	*x = DynamicResource{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicResource) ProtoMessage() {}

func (x *DynamicResource) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicResource.ProtoReflect.Descriptor instead.
func (*DynamicResource) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{10}
}

func (x *DynamicResource) GetClaimName() string {
	if x != nil {
		return x.ClaimName
	}
	return ""
}

func (x *DynamicResource) GetClaimNamespace() string {
	if x != nil {
		return x.ClaimNamespace
	}
	return ""
}

func (x *DynamicResource) GetClaimResources() []*ClaimResource {
	if x != nil {
		return x.ClaimResources
	}
	return nil
}

// ClaimResource contains resource information. The driver name/pool name/device name
// triplet uniquely identifies the device. Should DRA get extended to other kinds
// of resources, then device_name will be empty and other fields will get added.
// Each device at the DRA API level may map to zero or more CDI devices.
type ClaimResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	CdiDevices    []*CDIDevice           `protobuf:"bytes,1,rep,name=cdi_devices,json=cdiDevices,proto3" json:"cdi_devices,omitempty"`
	DriverName    string                 `protobuf:"bytes,2,opt,name=driver_name,json=driverName,proto3" json:"driver_name,omitempty"`
	PoolName      string                 `protobuf:"bytes,3,opt,name=pool_name,json=poolName,proto3" json:"pool_name,omitempty"`
	DeviceName    string                 `protobuf:"bytes,4,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ClaimResource) Reset() {
	*x = ClaimResource{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClaimResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClaimResource) ProtoMessage() {}

func (x *ClaimResource) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClaimResource.ProtoReflect.Descriptor instead.
func (*ClaimResource) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{11}
}

func (x *ClaimResource) GetCdiDevices() []*CDIDevice {
	if x != nil {
		return x.CdiDevices
	}
	return nil
}

func (x *ClaimResource) GetDriverName() string {
	if x != nil {
		return x.DriverName
	}
	return ""
}

func (x *ClaimResource) GetPoolName() string {
	if x != nil {
		return x.PoolName
	}
	return ""
}

func (x *ClaimResource) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

// CDIDevice specifies a CDI device information
type CDIDevice struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified CDI device name
	// for example: vendor.com/gpu=gpudevice1
	// see more details in the CDI specification:
	// https://github.com/container-orchestrated-devices/container-device-interface/blob/main/SPEC.md
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CDIDevice) Reset() {
	*x = CDIDevice{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CDIDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CDIDevice) ProtoMessage() {}

func (x *CDIDevice) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CDIDevice.ProtoReflect.Descriptor instead.
func (*CDIDevice) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{12}
}

func (x *CDIDevice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// GetPodResourcesRequest contains information about the pod
type GetPodResourcesRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PodName       string                 `protobuf:"bytes,1,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	PodNamespace  string                 `protobuf:"bytes,2,opt,name=pod_namespace,json=podNamespace,proto3" json:"pod_namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPodResourcesRequest) Reset() {
	*x = GetPodResourcesRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPodResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPodResourcesRequest) ProtoMessage() {}

func (x *GetPodResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPodResourcesRequest.ProtoReflect.Descriptor instead.
func (*GetPodResourcesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{13}
}

func (x *GetPodResourcesRequest) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

func (x *GetPodResourcesRequest) GetPodNamespace() string {
	if x != nil {
		return x.PodNamespace
	}
	return ""
}

// GetPodResourcesResponse contains information about the pod the devices
type GetPodResourcesResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	PodResources  *PodResources          `protobuf:"bytes,1,opt,name=pod_resources,json=podResources,proto3" json:"pod_resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetPodResourcesResponse) Reset() {
	*x = GetPodResourcesResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPodResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPodResourcesResponse) ProtoMessage() {}

func (x *GetPodResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPodResourcesResponse.ProtoReflect.Descriptor instead.
func (*GetPodResourcesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP(), []int{14}
}

func (x *GetPodResourcesResponse) GetPodResources() *PodResources {
	if x != nil {
		return x.PodResources
	}
	return nil
}

var File_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDesc = string([]byte{
	0x0a, 0x3d, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x70, 0x6f, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x02, 0x76, 0x31, 0x22, 0x1d, 0x0a, 0x1b, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0x94, 0x01, 0x0a, 0x1c, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x70, 0x75, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x03, 0x52, 0x06, 0x63, 0x70, 0x75, 0x49, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x06,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x22, 0x19, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0x51, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x35, 0x0a, 0x0d, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0x78, 0x0a, 0x0c, 0x50, 0x6f, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x73, 0x22, 0xe0, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x07,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x07,
	0x63, 0x70, 0x75, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x06, 0x63,
	0x70, 0x75, 0x49, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x12, 0x40, 0x0a, 0x11, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x10, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x22, 0x74, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x2c, 0x0a, 0x08,
	0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x08, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x22, 0x84, 0x01, 0x0a, 0x10, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x08, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x6f, 0x6c,
	0x6f, 0x67, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x22, 0x32, 0x0a, 0x0c, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x22, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0c, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x55, 0x4d, 0x41, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x1a, 0x0a, 0x08, 0x4e, 0x55, 0x4d, 0x41, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x49,
	0x44, 0x22, 0x95, 0x01, 0x0a, 0x0f, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63,
	0x6c, 0x61, 0x69, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3a, 0x0a,
	0x0f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x61, 0x69,
	0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0e, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0x9e, 0x01, 0x0a, 0x0d, 0x43, 0x6c,
	0x61, 0x69, 0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2e, 0x0a, 0x0b, 0x63,
	0x64, 0x69, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x44, 0x49, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x0a, 0x63, 0x64, 0x69, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x1f, 0x0a, 0x09, 0x43, 0x44,
	0x49, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x58, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x50, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x70, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x50, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x35, 0x0a, 0x0d, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x32, 0xfb, 0x01, 0x0a, 0x12, 0x50, 0x6f, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x72, 0x12, 0x43,
	0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x1b, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x5e, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1f,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x20, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x40, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x1a, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x50, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50,
	0x6f, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x29, 0x5a, 0x27, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f,
	0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x70, 0x6f, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDescData
}

var file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_goTypes = []any{
	(*AllocatableResourcesRequest)(nil),  // 0: v1.AllocatableResourcesRequest
	(*AllocatableResourcesResponse)(nil), // 1: v1.AllocatableResourcesResponse
	(*ListPodResourcesRequest)(nil),      // 2: v1.ListPodResourcesRequest
	(*ListPodResourcesResponse)(nil),     // 3: v1.ListPodResourcesResponse
	(*PodResources)(nil),                 // 4: v1.PodResources
	(*ContainerResources)(nil),           // 5: v1.ContainerResources
	(*ContainerMemory)(nil),              // 6: v1.ContainerMemory
	(*ContainerDevices)(nil),             // 7: v1.ContainerDevices
	(*TopologyInfo)(nil),                 // 8: v1.TopologyInfo
	(*NUMANode)(nil),                     // 9: v1.NUMANode
	(*DynamicResource)(nil),              // 10: v1.DynamicResource
	(*ClaimResource)(nil),                // 11: v1.ClaimResource
	(*CDIDevice)(nil),                    // 12: v1.CDIDevice
	(*GetPodResourcesRequest)(nil),       // 13: v1.GetPodResourcesRequest
	(*GetPodResourcesResponse)(nil),      // 14: v1.GetPodResourcesResponse
}
var file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_depIdxs = []int32{
	7,  // 0: v1.AllocatableResourcesResponse.devices:type_name -> v1.ContainerDevices
	6,  // 1: v1.AllocatableResourcesResponse.memory:type_name -> v1.ContainerMemory
	4,  // 2: v1.ListPodResourcesResponse.pod_resources:type_name -> v1.PodResources
	5,  // 3: v1.PodResources.containers:type_name -> v1.ContainerResources
	7,  // 4: v1.ContainerResources.devices:type_name -> v1.ContainerDevices
	6,  // 5: v1.ContainerResources.memory:type_name -> v1.ContainerMemory
	10, // 6: v1.ContainerResources.dynamic_resources:type_name -> v1.DynamicResource
	8,  // 7: v1.ContainerMemory.topology:type_name -> v1.TopologyInfo
	8,  // 8: v1.ContainerDevices.topology:type_name -> v1.TopologyInfo
	9,  // 9: v1.TopologyInfo.nodes:type_name -> v1.NUMANode
	11, // 10: v1.DynamicResource.claim_resources:type_name -> v1.ClaimResource
	12, // 11: v1.ClaimResource.cdi_devices:type_name -> v1.CDIDevice
	4,  // 12: v1.GetPodResourcesResponse.pod_resources:type_name -> v1.PodResources
	2,  // 13: v1.PodResourcesLister.List:input_type -> v1.ListPodResourcesRequest
	0,  // 14: v1.PodResourcesLister.GetAllocatableResources:input_type -> v1.AllocatableResourcesRequest
	13, // 15: v1.PodResourcesLister.Get:input_type -> v1.GetPodResourcesRequest
	3,  // 16: v1.PodResourcesLister.List:output_type -> v1.ListPodResourcesResponse
	1,  // 17: v1.PodResourcesLister.GetAllocatableResources:output_type -> v1.AllocatableResourcesResponse
	14, // 18: v1.PodResourcesLister.Get:output_type -> v1.GetPodResourcesResponse
	16, // [16:19] is the sub-list for method output_type
	13, // [13:16] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_init() }
func file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_init() {
	if File_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_depIdxs,
		MessageInfos:      file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto = out.File
	file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_goTypes = nil
	file_staging_src_k8s_io_kubelet_pkg_apis_podresources_v1_api_proto_depIdxs = nil
}
