/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	scheme "github.com/cert-manager/cert-manager/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CertificateRequestsGetter has a method to return a CertificateRequestInterface.
// A group's client should implement this interface.
type CertificateRequestsGetter interface {
	CertificateRequests(namespace string) CertificateRequestInterface
}

// CertificateRequestInterface has methods to work with CertificateRequest resources.
type CertificateRequestInterface interface {
	Create(ctx context.Context, certificateRequest *certmanagerv1.CertificateRequest, opts metav1.CreateOptions) (*certmanagerv1.CertificateRequest, error)
	Update(ctx context.Context, certificateRequest *certmanagerv1.CertificateRequest, opts metav1.UpdateOptions) (*certmanagerv1.CertificateRequest, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, certificateRequest *certmanagerv1.CertificateRequest, opts metav1.UpdateOptions) (*certmanagerv1.CertificateRequest, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*certmanagerv1.CertificateRequest, error)
	List(ctx context.Context, opts metav1.ListOptions) (*certmanagerv1.CertificateRequestList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *certmanagerv1.CertificateRequest, err error)
	CertificateRequestExpansion
}

// certificateRequests implements CertificateRequestInterface
type certificateRequests struct {
	*gentype.ClientWithList[*certmanagerv1.CertificateRequest, *certmanagerv1.CertificateRequestList]
}

// newCertificateRequests returns a CertificateRequests
func newCertificateRequests(c *CertmanagerV1Client, namespace string) *certificateRequests {
	return &certificateRequests{
		gentype.NewClientWithList[*certmanagerv1.CertificateRequest, *certmanagerv1.CertificateRequestList](
			"certificaterequests",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *certmanagerv1.CertificateRequest { return &certmanagerv1.CertificateRequest{} },
			func() *certmanagerv1.CertificateRequestList { return &certmanagerv1.CertificateRequestList{} },
		),
	}
}
