/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	kops "k8s.io/kops/pkg/apis/kops"
	internalversion "k8s.io/kops/pkg/client/clientset_generated/internalclientset/typed/kops/internalversion"
)

// fakeSSHCredentials implements SSHCredentialInterface
type fakeSSHCredentials struct {
	*gentype.FakeClientWithList[*kops.SSHCredential, *kops.SSHCredentialList]
	Fake *FakeKops
}

func newFakeSSHCredentials(fake *FakeKops, namespace string) internalversion.SSHCredentialInterface {
	return &fakeSSHCredentials{
		gentype.NewFakeClientWithList[*kops.SSHCredential, *kops.SSHCredentialList](
			fake.Fake,
			namespace,
			kops.SchemeGroupVersion.WithResource("sshcredentials"),
			kops.SchemeGroupVersion.WithKind("SSHCredential"),
			func() *kops.SSHCredential { return &kops.SSHCredential{} },
			func() *kops.SSHCredentialList { return &kops.SSHCredentialList{} },
			func(dst, src *kops.SSHCredentialList) { dst.ListMeta = src.ListMeta },
			func(list *kops.SSHCredentialList) []*kops.SSHCredential { return gentype.ToPointerSlice(list.Items) },
			func(list *kops.SSHCredentialList, items []*kops.SSHCredential) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
