/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	acmev1 "github.com/cert-manager/cert-manager/pkg/client/clientset/versioned/typed/acme/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeChallenges implements ChallengeInterface
type fakeChallenges struct {
	*gentype.FakeClientWithList[*v1.Challenge, *v1.ChallengeList]
	Fake *FakeAcmeV1
}

func newFakeChallenges(fake *FakeAcmeV1, namespace string) acmev1.ChallengeInterface {
	return &fakeChallenges{
		gentype.NewFakeClientWithList[*v1.Challenge, *v1.ChallengeList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("challenges"),
			v1.SchemeGroupVersion.WithKind("Challenge"),
			func() *v1.Challenge { return &v1.Challenge{} },
			func() *v1.ChallengeList { return &v1.ChallengeList{} },
			func(dst, src *v1.ChallengeList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ChallengeList) []*v1.Challenge { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.ChallengeList, items []*v1.Challenge) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
