// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes all resources associated with the specified trust store.
func (c *Client) DescribeTrustStoreAssociations(ctx context.Context, params *DescribeTrustStoreAssociationsInput, optFns ...func(*Options)) (*DescribeTrustStoreAssociationsOutput, error) {
	if params == nil {
		params = &DescribeTrustStoreAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTrustStoreAssociations", params, optFns, c.addOperationDescribeTrustStoreAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrustStoreAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrustStoreAssociationsInput struct {

	// The Amazon Resource Name (ARN) of the trust store.
	//
	// This member is required.
	TrustStoreArn *string

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string

	// The maximum number of results to return with this call.
	PageSize *int32

	noSmithyDocumentSerde
}

type DescribeTrustStoreAssociationsOutput struct {

	// If there are additional results, this is the marker for the next set of
	// results. Otherwise, this is null.
	NextMarker *string

	// Information about the resources the trust store is associated to.
	TrustStoreAssociations []types.TrustStoreAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrustStoreAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeTrustStoreAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeTrustStoreAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTrustStoreAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeTrustStoreAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTrustStoreAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeTrustStoreAssociationsPaginatorOptions is the paginator options for
// DescribeTrustStoreAssociations
type DescribeTrustStoreAssociationsPaginatorOptions struct {
	// The maximum number of results to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeTrustStoreAssociationsPaginator is a paginator for
// DescribeTrustStoreAssociations
type DescribeTrustStoreAssociationsPaginator struct {
	options   DescribeTrustStoreAssociationsPaginatorOptions
	client    DescribeTrustStoreAssociationsAPIClient
	params    *DescribeTrustStoreAssociationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeTrustStoreAssociationsPaginator returns a new
// DescribeTrustStoreAssociationsPaginator
func NewDescribeTrustStoreAssociationsPaginator(client DescribeTrustStoreAssociationsAPIClient, params *DescribeTrustStoreAssociationsInput, optFns ...func(*DescribeTrustStoreAssociationsPaginatorOptions)) *DescribeTrustStoreAssociationsPaginator {
	if params == nil {
		params = &DescribeTrustStoreAssociationsInput{}
	}

	options := DescribeTrustStoreAssociationsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeTrustStoreAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeTrustStoreAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeTrustStoreAssociations page.
func (p *DescribeTrustStoreAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeTrustStoreAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeTrustStoreAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeTrustStoreAssociationsAPIClient is a client that implements the
// DescribeTrustStoreAssociations operation.
type DescribeTrustStoreAssociationsAPIClient interface {
	DescribeTrustStoreAssociations(context.Context, *DescribeTrustStoreAssociationsInput, ...func(*Options)) (*DescribeTrustStoreAssociationsOutput, error)
}

var _ DescribeTrustStoreAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeTrustStoreAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTrustStoreAssociations",
	}
}
