//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armauthorization

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// AlertConfigurationsClient contains the methods for the AlertConfigurations group.
// Don't use this type directly, use NewAlertConfigurationsClient() instead.
type AlertConfigurationsClient struct {
	internal *arm.Client
}

// NewAlertConfigurationsClient creates a new instance of AlertConfigurationsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAlertConfigurationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AlertConfigurationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AlertConfigurationsClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get the specified alert configuration.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - scope - The scope of the alert configuration. The scope can be any REST resource instance. For example, use '/providers/Microsoft.Subscription/subscriptions/{subscription-id}/'
//     for a subscription,
//     '/providers/Microsoft.Subscription/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource
//     group, and
//     '/providers/Microsoft.Subscription/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
//     for a resource.
//   - alertID - The name of the alert configuration to get.
//   - options - AlertConfigurationsClientGetOptions contains the optional parameters for the AlertConfigurationsClient.Get method.
func (client *AlertConfigurationsClient) Get(ctx context.Context, scope string, alertID string, options *AlertConfigurationsClientGetOptions) (AlertConfigurationsClientGetResponse, error) {
	var err error
	const operationName = "AlertConfigurationsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, alertID, options)
	if err != nil {
		return AlertConfigurationsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AlertConfigurationsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AlertConfigurationsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AlertConfigurationsClient) getCreateRequest(ctx context.Context, scope string, alertID string, options *AlertConfigurationsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleManagementAlertConfigurations/{alertId}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	urlPath = strings.ReplaceAll(urlPath, "{alertId}", alertID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AlertConfigurationsClient) getHandleResponse(resp *http.Response) (AlertConfigurationsClientGetResponse, error) {
	result := AlertConfigurationsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertConfiguration); err != nil {
		return AlertConfigurationsClientGetResponse{}, err
	}
	return result, nil
}

// NewListForScopePager - Gets alert configurations for a resource scope.
//
// Generated from API version 2022-08-01-preview
//   - scope - The scope of the alert configuration.
//   - options - AlertConfigurationsClientListForScopeOptions contains the optional parameters for the AlertConfigurationsClient.NewListForScopePager
//     method.
func (client *AlertConfigurationsClient) NewListForScopePager(scope string, options *AlertConfigurationsClientListForScopeOptions) *runtime.Pager[AlertConfigurationsClientListForScopeResponse] {
	return runtime.NewPager(runtime.PagingHandler[AlertConfigurationsClientListForScopeResponse]{
		More: func(page AlertConfigurationsClientListForScopeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AlertConfigurationsClientListForScopeResponse) (AlertConfigurationsClientListForScopeResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "AlertConfigurationsClient.NewListForScopePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForScopeCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return AlertConfigurationsClientListForScopeResponse{}, err
			}
			return client.listForScopeHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForScopeCreateRequest creates the ListForScope request.
func (client *AlertConfigurationsClient) listForScopeCreateRequest(ctx context.Context, scope string, options *AlertConfigurationsClientListForScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleManagementAlertConfigurations"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForScopeHandleResponse handles the ListForScope response.
func (client *AlertConfigurationsClient) listForScopeHandleResponse(resp *http.Response) (AlertConfigurationsClientListForScopeResponse, error) {
	result := AlertConfigurationsClientListForScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertConfigurationListResult); err != nil {
		return AlertConfigurationsClientListForScopeResponse{}, err
	}
	return result, nil
}

// Update - Update an alert configuration.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - scope - The scope of the alert configuration.
//   - alertID - The name of the alert configuration to update.
//   - parameters - Parameters for the alert configuration.
//   - options - AlertConfigurationsClientUpdateOptions contains the optional parameters for the AlertConfigurationsClient.Update
//     method.
func (client *AlertConfigurationsClient) Update(ctx context.Context, scope string, alertID string, parameters AlertConfiguration, options *AlertConfigurationsClientUpdateOptions) (AlertConfigurationsClientUpdateResponse, error) {
	var err error
	const operationName = "AlertConfigurationsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, scope, alertID, parameters, options)
	if err != nil {
		return AlertConfigurationsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AlertConfigurationsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return AlertConfigurationsClientUpdateResponse{}, err
	}
	return AlertConfigurationsClientUpdateResponse{}, nil
}

// updateCreateRequest creates the Update request.
func (client *AlertConfigurationsClient) updateCreateRequest(ctx context.Context, scope string, alertID string, parameters AlertConfiguration, options *AlertConfigurationsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleManagementAlertConfigurations/{alertId}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	urlPath = strings.ReplaceAll(urlPath, "{alertId}", alertID)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
