
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops create instancegroup

Create an instancegroup.

### Synopsis

Create an InstanceGroup configuration.

 An InstanceGroup is a group of similar virtual machines. On AWS, an InstanceGroup maps to an AutoScalingGroup.

 The Role of an InstanceGroup defines whether machines will act as a Kubernetes master or node.

```
kops create instancegroup INSTANCE_GROUP [flags]
```

### Examples

```
  # Create an instancegroup for the k8s-cluster.example.com cluster.
  kops create instancegroup --name=k8s-cluster.example.com node-example \
  --role node --subnet my-subnet-name,my-other-subnet-name
  
  # Create a YAML manifest for an instancegroup for the k8s-cluster.example.com cluster.
  kops create instancegroup --name=k8s-cluster.example.com node-example \
  --role node --subnet my-subnet-name --dry-run -oyaml
```

### Options

```
      --dry-run          Only print the object that would be created, without created it. This flag can be used to create an instance group YAML or JSON manifest.
      --edit             Open an editor to edit default values (default true)
  -h, --help             help for instancegroup
  -o, --output string    Output format. One of json or yaml
      --role string      Type of instance group to create (master,node,bastion) (default "Node")
      --subnet strings   Subnet in which to create instance group. One of Availability Zone like eu-west-1a or a comma-separated list of multiple Availability Zones.
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops create](kops_create.md)	 - Create a resource by command line, filename or stdin.

