// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: attest.proto

package attest

import (
	tpm "github.com/google/go-tpm-tools/proto/tpm"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of hardware technology used to protect this instance
type GCEConfidentialTechnology int32

const (
	GCEConfidentialTechnology_NONE       GCEConfidentialTechnology = 0
	GCEConfidentialTechnology_AMD_SEV    GCEConfidentialTechnology = 1
	GCEConfidentialTechnology_AMD_SEV_ES GCEConfidentialTechnology = 2
)

// Enum value maps for GCEConfidentialTechnology.
var (
	GCEConfidentialTechnology_name = map[int32]string{
		0: "NONE",
		1: "AMD_SEV",
		2: "AMD_SEV_ES",
	}
	GCEConfidentialTechnology_value = map[string]int32{
		"NONE":       0,
		"AMD_SEV":    1,
		"AMD_SEV_ES": 2,
	}
)

func (x GCEConfidentialTechnology) Enum() *GCEConfidentialTechnology {
	p := new(GCEConfidentialTechnology)
	*p = x
	return p
}

func (x GCEConfidentialTechnology) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GCEConfidentialTechnology) Descriptor() protoreflect.EnumDescriptor {
	return file_attest_proto_enumTypes[0].Descriptor()
}

func (GCEConfidentialTechnology) Type() protoreflect.EnumType {
	return &file_attest_proto_enumTypes[0]
}

func (x GCEConfidentialTechnology) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GCEConfidentialTechnology.Descriptor instead.
func (GCEConfidentialTechnology) EnumDescriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{0}
}

// Common, publicly-listed certificates by different vendors.
type WellKnownCertificate int32

const (
	WellKnownCertificate_UNKNOWN WellKnownCertificate = 0
	// Microsoft certs:
	// https://go.microsoft.com/fwlink/p/?linkid=321192
	WellKnownCertificate_MS_WINDOWS_PROD_PCA_2011 WellKnownCertificate = 1
	// https://go.microsoft.com/fwlink/p/?linkid=321194
	WellKnownCertificate_MS_THIRD_PARTY_UEFI_CA_2011 WellKnownCertificate = 2
)

// Enum value maps for WellKnownCertificate.
var (
	WellKnownCertificate_name = map[int32]string{
		0: "UNKNOWN",
		1: "MS_WINDOWS_PROD_PCA_2011",
		2: "MS_THIRD_PARTY_UEFI_CA_2011",
	}
	WellKnownCertificate_value = map[string]int32{
		"UNKNOWN":                     0,
		"MS_WINDOWS_PROD_PCA_2011":    1,
		"MS_THIRD_PARTY_UEFI_CA_2011": 2,
	}
)

func (x WellKnownCertificate) Enum() *WellKnownCertificate {
	p := new(WellKnownCertificate)
	*p = x
	return p
}

func (x WellKnownCertificate) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WellKnownCertificate) Descriptor() protoreflect.EnumDescriptor {
	return file_attest_proto_enumTypes[1].Descriptor()
}

func (WellKnownCertificate) Type() protoreflect.EnumType {
	return &file_attest_proto_enumTypes[1]
}

func (x WellKnownCertificate) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WellKnownCertificate.Descriptor instead.
func (WellKnownCertificate) EnumDescriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{1}
}

// The container's restart policy.
// See the following Kubernetes documentation for more details:
// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
// Note that these enum variants do not conform to the standard Protocol Buffers
// Style Guide so that RestartPolicy_name, RestartPolicy_value, and
// RestartPolicy.String() match the values used by Kubernetes and others.
type RestartPolicy int32

const (
	RestartPolicy_Always    RestartPolicy = 0
	RestartPolicy_OnFailure RestartPolicy = 1
	RestartPolicy_Never     RestartPolicy = 2
)

// Enum value maps for RestartPolicy.
var (
	RestartPolicy_name = map[int32]string{
		0: "Always",
		1: "OnFailure",
		2: "Never",
	}
	RestartPolicy_value = map[string]int32{
		"Always":    0,
		"OnFailure": 1,
		"Never":     2,
	}
)

func (x RestartPolicy) Enum() *RestartPolicy {
	p := new(RestartPolicy)
	*p = x
	return p
}

func (x RestartPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestartPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_attest_proto_enumTypes[2].Descriptor()
}

func (RestartPolicy) Type() protoreflect.EnumType {
	return &file_attest_proto_enumTypes[2]
}

func (x RestartPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestartPolicy.Descriptor instead.
func (RestartPolicy) EnumDescriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{2}
}

// Information uniquely identifying a GCE instance. Can be used to create an
// instance URL, which can then be used with GCE APIs. Formatted like:
//   https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/instances/{instance_name}
type GCEInstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Zone          string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	ProjectId     string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	ProjectNumber uint64 `protobuf:"varint,3,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	InstanceName  string `protobuf:"bytes,4,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	InstanceId    uint64 `protobuf:"varint,5,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
}

func (x *GCEInstanceInfo) Reset() {
	*x = GCEInstanceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCEInstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCEInstanceInfo) ProtoMessage() {}

func (x *GCEInstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCEInstanceInfo.ProtoReflect.Descriptor instead.
func (*GCEInstanceInfo) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{0}
}

func (x *GCEInstanceInfo) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *GCEInstanceInfo) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GCEInstanceInfo) GetProjectNumber() uint64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *GCEInstanceInfo) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *GCEInstanceInfo) GetInstanceId() uint64 {
	if x != nil {
		return x.InstanceId
	}
	return 0
}

type Attestation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Attestation Key (AK) Public Area, encoded as a TPMT_PUBLIC
	AkPub []byte `protobuf:"bytes,1,opt,name=ak_pub,json=akPub,proto3" json:"ak_pub,omitempty"`
	// Quotes over all supported PCR banks
	Quotes []*tpm.Quote `protobuf:"bytes,2,rep,name=quotes,proto3" json:"quotes,omitempty"`
	// TCG Event Log, encoded in the raw binary format.
	// Can be SHA-1 or crypto-agile.
	EventLog []byte `protobuf:"bytes,3,opt,name=event_log,json=eventLog,proto3" json:"event_log,omitempty"`
	// Optional information about a GCE instance, unused outside of GCE
	InstanceInfo *GCEInstanceInfo `protobuf:"bytes,4,opt,name=instance_info,json=instanceInfo,proto3" json:"instance_info,omitempty"`
	// A TCG Canonical Event Log.
	CanonicalEventLog []byte `protobuf:"bytes,5,opt,name=canonical_event_log,json=canonicalEventLog,proto3" json:"canonical_event_log,omitempty"`
	// Attestation Key (AK) Certificate, encoded as ASN.1 DER.
	// Optional.
	AkCert []byte `protobuf:"bytes,6,opt,name=ak_cert,json=akCert,proto3" json:"ak_cert,omitempty"`
	// Intermediate Certificates for verifying the AK Certificate, encoded as ASN.1 DER.
	// Optional.
	IntermediateCerts [][]byte `protobuf:"bytes,7,rep,name=intermediate_certs,json=intermediateCerts,proto3" json:"intermediate_certs,omitempty"`
}

func (x *Attestation) Reset() {
	*x = Attestation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attestation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attestation) ProtoMessage() {}

func (x *Attestation) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attestation.ProtoReflect.Descriptor instead.
func (*Attestation) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{1}
}

func (x *Attestation) GetAkPub() []byte {
	if x != nil {
		return x.AkPub
	}
	return nil
}

func (x *Attestation) GetQuotes() []*tpm.Quote {
	if x != nil {
		return x.Quotes
	}
	return nil
}

func (x *Attestation) GetEventLog() []byte {
	if x != nil {
		return x.EventLog
	}
	return nil
}

func (x *Attestation) GetInstanceInfo() *GCEInstanceInfo {
	if x != nil {
		return x.InstanceInfo
	}
	return nil
}

func (x *Attestation) GetCanonicalEventLog() []byte {
	if x != nil {
		return x.CanonicalEventLog
	}
	return nil
}

func (x *Attestation) GetAkCert() []byte {
	if x != nil {
		return x.AkCert
	}
	return nil
}

func (x *Attestation) GetIntermediateCerts() [][]byte {
	if x != nil {
		return x.IntermediateCerts
	}
	return nil
}

// The platform/firmware state for this instance
type PlatformState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Firmware:
	//	*PlatformState_ScrtmVersionId
	//	*PlatformState_GceVersion
	Firmware isPlatformState_Firmware `protobuf_oneof:"firmware"`
	// Set to NONE on non-GCE instances or non-Confidential Shielded GCE instances
	Technology GCEConfidentialTechnology `protobuf:"varint,3,opt,name=technology,proto3,enum=attest.GCEConfidentialTechnology" json:"technology,omitempty"`
	// Only set for GCE instances
	InstanceInfo *GCEInstanceInfo `protobuf:"bytes,4,opt,name=instance_info,json=instanceInfo,proto3" json:"instance_info,omitempty"`
}

func (x *PlatformState) Reset() {
	*x = PlatformState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformState) ProtoMessage() {}

func (x *PlatformState) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformState.ProtoReflect.Descriptor instead.
func (*PlatformState) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{2}
}

func (m *PlatformState) GetFirmware() isPlatformState_Firmware {
	if m != nil {
		return m.Firmware
	}
	return nil
}

func (x *PlatformState) GetScrtmVersionId() []byte {
	if x, ok := x.GetFirmware().(*PlatformState_ScrtmVersionId); ok {
		return x.ScrtmVersionId
	}
	return nil
}

func (x *PlatformState) GetGceVersion() uint32 {
	if x, ok := x.GetFirmware().(*PlatformState_GceVersion); ok {
		return x.GceVersion
	}
	return 0
}

func (x *PlatformState) GetTechnology() GCEConfidentialTechnology {
	if x != nil {
		return x.Technology
	}
	return GCEConfidentialTechnology_NONE
}

func (x *PlatformState) GetInstanceInfo() *GCEInstanceInfo {
	if x != nil {
		return x.InstanceInfo
	}
	return nil
}

type isPlatformState_Firmware interface {
	isPlatformState_Firmware()
}

type PlatformState_ScrtmVersionId struct {
	// Raw S-CRTM version identifier (EV_S_CRTM_VERSION)
	ScrtmVersionId []byte `protobuf:"bytes,1,opt,name=scrtm_version_id,json=scrtmVersionId,proto3,oneof"`
}

type PlatformState_GceVersion struct {
	// Virtual GCE firmware version (parsed from S-CRTM version id)
	GceVersion uint32 `protobuf:"varint,2,opt,name=gce_version,json=gceVersion,proto3,oneof"`
}

func (*PlatformState_ScrtmVersionId) isPlatformState_Firmware() {}

func (*PlatformState_GceVersion) isPlatformState_Firmware() {}

// A parsed event from the TCG event log
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Platform Control Register (PCR) this event was extended into.
	PcrIndex uint32 `protobuf:"varint,1,opt,name=pcr_index,json=pcrIndex,proto3" json:"pcr_index,omitempty"`
	// The type of this event. Note that this value is not verified, so it should
	// only be used as a hint during event parsing.
	UntrustedType uint32 `protobuf:"varint,2,opt,name=untrusted_type,json=untrustedType,proto3" json:"untrusted_type,omitempty"`
	// The raw data associated to this event. The meaning of this data is
	// specific to the type of the event.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// The event digest actually extended into the TPM. This is often the hash of
	// the data field, but in some cases it may have a type-specific calculation.
	Digest []byte `protobuf:"bytes,4,opt,name=digest,proto3" json:"digest,omitempty"`
	// This is true if hash(data) == digest.
	DigestVerified bool `protobuf:"varint,5,opt,name=digest_verified,json=digestVerified,proto3" json:"digest_verified,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{3}
}

func (x *Event) GetPcrIndex() uint32 {
	if x != nil {
		return x.PcrIndex
	}
	return 0
}

func (x *Event) GetUntrustedType() uint32 {
	if x != nil {
		return x.UntrustedType
	}
	return 0
}

func (x *Event) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Event) GetDigest() []byte {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *Event) GetDigestVerified() bool {
	if x != nil {
		return x.DigestVerified
	}
	return false
}

type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The representation of the certificate. If the certificate matches a
	// well-known certificate above, representation should contain the value in
	// the enum. Otherwise, it will contain the raw DER.
	//
	// Types that are assignable to Representation:
	//	*Certificate_Der
	//	*Certificate_WellKnown
	Representation isCertificate_Representation `protobuf_oneof:"representation"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{4}
}

func (m *Certificate) GetRepresentation() isCertificate_Representation {
	if m != nil {
		return m.Representation
	}
	return nil
}

func (x *Certificate) GetDer() []byte {
	if x, ok := x.GetRepresentation().(*Certificate_Der); ok {
		return x.Der
	}
	return nil
}

func (x *Certificate) GetWellKnown() WellKnownCertificate {
	if x, ok := x.GetRepresentation().(*Certificate_WellKnown); ok {
		return x.WellKnown
	}
	return WellKnownCertificate_UNKNOWN
}

type isCertificate_Representation interface {
	isCertificate_Representation()
}

type Certificate_Der struct {
	// DER representation of the certificate.
	Der []byte `protobuf:"bytes,1,opt,name=der,proto3,oneof"`
}

type Certificate_WellKnown struct {
	WellKnown WellKnownCertificate `protobuf:"varint,2,opt,name=well_known,json=wellKnown,proto3,enum=attest.WellKnownCertificate,oneof"`
}

func (*Certificate_Der) isCertificate_Representation() {}

func (*Certificate_WellKnown) isCertificate_Representation() {}

// A Secure Boot database containing lists of hashes and certificates,
// as defined by section 32.4.1 Signature Database in the UEFI spec.
type Database struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Certs  []*Certificate `protobuf:"bytes,1,rep,name=certs,proto3" json:"certs,omitempty"`
	Hashes [][]byte       `protobuf:"bytes,2,rep,name=hashes,proto3" json:"hashes,omitempty"`
}

func (x *Database) Reset() {
	*x = Database{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Database) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Database) ProtoMessage() {}

func (x *Database) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Database.ProtoReflect.Descriptor instead.
func (*Database) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{5}
}

func (x *Database) GetCerts() []*Certificate {
	if x != nil {
		return x.Certs
	}
	return nil
}

func (x *Database) GetHashes() [][]byte {
	if x != nil {
		return x.Hashes
	}
	return nil
}

// The Secure Boot state for this instance.
type SecureBootState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Secure Boot is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The Secure Boot signature (allowed) database.
	Db *Database `protobuf:"bytes,2,opt,name=db,proto3" json:"db,omitempty"`
	// The Secure Boot revoked signature (forbidden) database.
	Dbx *Database `protobuf:"bytes,3,opt,name=dbx,proto3" json:"dbx,omitempty"`
	// Authority events post-separator. Pre-separator authorities
	// are currently not supported.
	Authority *Database `protobuf:"bytes,4,opt,name=authority,proto3" json:"authority,omitempty"`
}

func (x *SecureBootState) Reset() {
	*x = SecureBootState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecureBootState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecureBootState) ProtoMessage() {}

func (x *SecureBootState) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecureBootState.ProtoReflect.Descriptor instead.
func (*SecureBootState) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{6}
}

func (x *SecureBootState) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SecureBootState) GetDb() *Database {
	if x != nil {
		return x.Db
	}
	return nil
}

func (x *SecureBootState) GetDbx() *Database {
	if x != nil {
		return x.Dbx
	}
	return nil
}

func (x *SecureBootState) GetAuthority() *Database {
	if x != nil {
		return x.Authority
	}
	return nil
}

type ContainerState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ImageReference string `protobuf:"bytes,1,opt,name=image_reference,json=imageReference,proto3" json:"image_reference,omitempty"`
	// Digest of the registry's image manifest, which contains a list of the
	// layers comprising the image.
	ImageDigest   string        `protobuf:"bytes,2,opt,name=image_digest,json=imageDigest,proto3" json:"image_digest,omitempty"`
	RestartPolicy RestartPolicy `protobuf:"varint,3,opt,name=restart_policy,json=restartPolicy,proto3,enum=attest.RestartPolicy" json:"restart_policy,omitempty"`
	// Digest of the local image configuration object, containing config items
	// such as local layer digests.
	ImageId string            `protobuf:"bytes,4,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	Args    []string          `protobuf:"bytes,5,rep,name=args,proto3" json:"args,omitempty"`
	EnvVars map[string]string `protobuf:"bytes,6,rep,name=env_vars,json=envVars,proto3" json:"env_vars,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ContainerState) Reset() {
	*x = ContainerState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerState) ProtoMessage() {}

func (x *ContainerState) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerState.ProtoReflect.Descriptor instead.
func (*ContainerState) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{7}
}

func (x *ContainerState) GetImageReference() string {
	if x != nil {
		return x.ImageReference
	}
	return ""
}

func (x *ContainerState) GetImageDigest() string {
	if x != nil {
		return x.ImageDigest
	}
	return ""
}

func (x *ContainerState) GetRestartPolicy() RestartPolicy {
	if x != nil {
		return x.RestartPolicy
	}
	return RestartPolicy_Always
}

func (x *ContainerState) GetImageId() string {
	if x != nil {
		return x.ImageId
	}
	return ""
}

func (x *ContainerState) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ContainerState) GetEnvVars() map[string]string {
	if x != nil {
		return x.EnvVars
	}
	return nil
}

type SemanticVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Major uint32 `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor uint32 `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
	Patch uint32 `protobuf:"varint,3,opt,name=patch,proto3" json:"patch,omitempty"`
}

func (x *SemanticVersion) Reset() {
	*x = SemanticVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SemanticVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SemanticVersion) ProtoMessage() {}

func (x *SemanticVersion) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SemanticVersion.ProtoReflect.Descriptor instead.
func (*SemanticVersion) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{8}
}

func (x *SemanticVersion) GetMajor() uint32 {
	if x != nil {
		return x.Major
	}
	return 0
}

func (x *SemanticVersion) GetMinor() uint32 {
	if x != nil {
		return x.Minor
	}
	return 0
}

func (x *SemanticVersion) GetPatch() uint32 {
	if x != nil {
		return x.Patch
	}
	return 0
}

type AttestedCosState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Container       *ContainerState  `protobuf:"bytes,1,opt,name=container,proto3" json:"container,omitempty"`
	CosVersion      *SemanticVersion `protobuf:"bytes,2,opt,name=cos_version,json=cosVersion,proto3" json:"cos_version,omitempty"`
	LauncherVersion *SemanticVersion `protobuf:"bytes,3,opt,name=launcher_version,json=launcherVersion,proto3" json:"launcher_version,omitempty"`
}

func (x *AttestedCosState) Reset() {
	*x = AttestedCosState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttestedCosState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttestedCosState) ProtoMessage() {}

func (x *AttestedCosState) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttestedCosState.ProtoReflect.Descriptor instead.
func (*AttestedCosState) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{9}
}

func (x *AttestedCosState) GetContainer() *ContainerState {
	if x != nil {
		return x.Container
	}
	return nil
}

func (x *AttestedCosState) GetCosVersion() *SemanticVersion {
	if x != nil {
		return x.CosVersion
	}
	return nil
}

func (x *AttestedCosState) GetLauncherVersion() *SemanticVersion {
	if x != nil {
		return x.LauncherVersion
	}
	return nil
}

// The verified state of a booted machine, obtained from an Attestation
type MachineState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Platform   *PlatformState   `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
	SecureBoot *SecureBootState `protobuf:"bytes,2,opt,name=secure_boot,json=secureBoot,proto3" json:"secure_boot,omitempty"`
	// The complete parsed TCG Event Log, including those events used to
	// create the PlatformState.
	RawEvents []*Event `protobuf:"bytes,3,rep,name=raw_events,json=rawEvents,proto3" json:"raw_events,omitempty"`
	// The hash algorithm used when verifying the Attestation. This indicates:
	//   - which PCR bank was used for for quote validation and event log replay
	//   - the hash algorithm used to calculate event digests
	Hash tpm.HashAlgo      `protobuf:"varint,4,opt,name=hash,proto3,enum=tpm.HashAlgo" json:"hash,omitempty"`
	Cos  *AttestedCosState `protobuf:"bytes,7,opt,name=cos,proto3" json:"cos,omitempty"`
}

func (x *MachineState) Reset() {
	*x = MachineState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineState) ProtoMessage() {}

func (x *MachineState) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineState.ProtoReflect.Descriptor instead.
func (*MachineState) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{10}
}

func (x *MachineState) GetPlatform() *PlatformState {
	if x != nil {
		return x.Platform
	}
	return nil
}

func (x *MachineState) GetSecureBoot() *SecureBootState {
	if x != nil {
		return x.SecureBoot
	}
	return nil
}

func (x *MachineState) GetRawEvents() []*Event {
	if x != nil {
		return x.RawEvents
	}
	return nil
}

func (x *MachineState) GetHash() tpm.HashAlgo {
	if x != nil {
		return x.Hash
	}
	return tpm.HashAlgo(0)
}

func (x *MachineState) GetCos() *AttestedCosState {
	if x != nil {
		return x.Cos
	}
	return nil
}

// A policy dictating which values of PlatformState to allow
type PlatformPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If PlatformState.firmware contains a scrtm_version_id, it must appear
	// in this list. For use with a GCE VM, minimum_gce_firmware_version is
	// often a better alternative.
	AllowedScrtmVersionIds [][]byte `protobuf:"bytes,1,rep,name=allowed_scrtm_version_ids,json=allowedScrtmVersionIds,proto3" json:"allowed_scrtm_version_ids,omitempty"`
	// If PlatformState.firmware contains a minimum_gce_firmware_version, it must
	// be greater than or equal to this value. Currently, the max version is 1.
	MinimumGceFirmwareVersion uint32 `protobuf:"varint,2,opt,name=minimum_gce_firmware_version,json=minimumGceFirmwareVersion,proto3" json:"minimum_gce_firmware_version,omitempty"`
	// The PlatformState's technology must be at least as secure as
	// the specified minimum_technology (i.e. AMD_SEV_ES > AMD_SEV > NONE).
	MinimumTechnology GCEConfidentialTechnology `protobuf:"varint,3,opt,name=minimum_technology,json=minimumTechnology,proto3,enum=attest.GCEConfidentialTechnology" json:"minimum_technology,omitempty"`
}

func (x *PlatformPolicy) Reset() {
	*x = PlatformPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformPolicy) ProtoMessage() {}

func (x *PlatformPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformPolicy.ProtoReflect.Descriptor instead.
func (*PlatformPolicy) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{11}
}

func (x *PlatformPolicy) GetAllowedScrtmVersionIds() [][]byte {
	if x != nil {
		return x.AllowedScrtmVersionIds
	}
	return nil
}

func (x *PlatformPolicy) GetMinimumGceFirmwareVersion() uint32 {
	if x != nil {
		return x.MinimumGceFirmwareVersion
	}
	return 0
}

func (x *PlatformPolicy) GetMinimumTechnology() GCEConfidentialTechnology {
	if x != nil {
		return x.MinimumTechnology
	}
	return GCEConfidentialTechnology_NONE
}

// A policy dictating which type of MachineStates to allow
type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Platform *PlatformPolicy `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{12}
}

func (x *Policy) GetPlatform() *PlatformPolicy {
	if x != nil {
		return x.Platform
	}
	return nil
}

var File_attest_proto protoreflect.FileDescriptor

var file_attest_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06,
	0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x1a, 0x09, 0x74, 0x70, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xb1, 0x01, 0x0a, 0x0f, 0x47, 0x43, 0x45, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x64, 0x22, 0x9b, 0x02, 0x0a, 0x0b, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x06, 0x61, 0x6b, 0x5f, 0x70, 0x75, 0x62, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x61, 0x6b, 0x50, 0x75, 0x62, 0x12, 0x22, 0x0a, 0x06,
	0x71, 0x75, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x74,
	0x70, 0x6d, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x52, 0x06, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x12, 0x3c, 0x0a,
	0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x43,
	0x45, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2e, 0x0a, 0x13, 0x63,
	0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c,
	0x6f, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x61,
	0x6b, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x61, 0x6b,
	0x43, 0x65, 0x72, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0c,
	0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x43, 0x65,
	0x72, 0x74, 0x73, 0x22, 0xeb, 0x01, 0x0a, 0x0d, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x73, 0x63, 0x72, 0x74, 0x6d, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48,
	0x00, 0x52, 0x0e, 0x73, 0x63, 0x72, 0x74, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x0b, 0x67, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x0a, 0x67, 0x63, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x0a, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f,
	0x67, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x2e, 0x47, 0x43, 0x45, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52, 0x0a, 0x74, 0x65, 0x63,
	0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x3c, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x43, 0x45, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0x0a, 0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x22, 0xa0, 0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x63, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x70, 0x63, 0x72, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x6e, 0x74, 0x72,
	0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0d, 0x75, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x22, 0x72, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x03, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x48, 0x00, 0x52, 0x03, 0x64, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x0a, 0x77, 0x65, 0x6c, 0x6c, 0x5f,
	0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x61, 0x74,
	0x74, 0x65, 0x73, 0x74, 0x2e, 0x57, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x77, 0x65, 0x6c,
	0x6c, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4d, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x05, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x05, 0x63, 0x65, 0x72, 0x74, 0x73, 0x12,
	0x16, 0x0a, 0x06, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52,
	0x06, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x22, 0xa1, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x02, 0x64, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x52, 0x02, 0x64, 0x62, 0x12, 0x22, 0x0a, 0x03, 0x64, 0x62, 0x78, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x03, 0x64, 0x62, 0x78, 0x12, 0x2e, 0x0a, 0x09, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0xc5, 0x02, 0x0a, 0x0e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x27,
	0x0a, 0x0f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x0e, 0x72, 0x65,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x15, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x3e, 0x0a, 0x08, 0x65, 0x6e, 0x76, 0x5f, 0x76,
	0x61, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07,
	0x65, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x45, 0x6e, 0x76, 0x56, 0x61,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x53, 0x0a, 0x0f, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05,
	0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6d, 0x69, 0x6e,
	0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x70, 0x61, 0x74, 0x63, 0x68, 0x22, 0xc6, 0x01, 0x0a, 0x10, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a,
	0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x12, 0x38, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73,
	0x74, 0x2e, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a,
	0x10, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x2e, 0x53, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x0f, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0xf8, 0x01, 0x0a, 0x0c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x31, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x08, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x38, 0x0a, 0x0b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f,
	0x62, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12,
	0x2c, 0x0a, 0x0a, 0x72, 0x61, 0x77, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x09, 0x72, 0x61, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x21, 0x0a,
	0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0d, 0x2e, 0x74, 0x70,
	0x6d, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x52, 0x04, 0x68, 0x61, 0x73, 0x68,
	0x12, 0x2a, 0x0a, 0x03, 0x63, 0x6f, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43,
	0x6f, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x03, 0x63, 0x6f, 0x73, 0x22, 0xde, 0x01, 0x0a,
	0x0e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x39, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x72, 0x74, 0x6d,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0c, 0x52, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x63, 0x72, 0x74, 0x6d,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x3f, 0x0a, 0x1c, 0x6d, 0x69,
	0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x67, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x19, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x47, 0x63, 0x65, 0x46, 0x69, 0x72, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x12, 0x6d,
	0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x2e, 0x47, 0x43, 0x45, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52, 0x11, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x22, 0x3c, 0x0a,
	0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x32, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2a, 0x42, 0x0a, 0x19, 0x47,
	0x43, 0x45, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x54, 0x65,
	0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x4d, 0x44, 0x5f, 0x53, 0x45, 0x56, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x41, 0x4d, 0x44, 0x5f, 0x53, 0x45, 0x56, 0x5f, 0x45, 0x53, 0x10, 0x02, 0x2a,
	0x62, 0x0a, 0x14, 0x57, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x53, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f,
	0x57, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x5f, 0x50, 0x43, 0x41, 0x5f, 0x32, 0x30, 0x31, 0x31,
	0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x53, 0x5f, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50,
	0x41, 0x52, 0x54, 0x59, 0x5f, 0x55, 0x45, 0x46, 0x49, 0x5f, 0x43, 0x41, 0x5f, 0x32, 0x30, 0x31,
	0x31, 0x10, 0x02, 0x2a, 0x35, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x4e, 0x65, 0x76, 0x65, 0x72, 0x10, 0x02, 0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x67, 0x6f, 0x2d, 0x74, 0x70, 0x6d, 0x2d, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_attest_proto_rawDescOnce sync.Once
	file_attest_proto_rawDescData = file_attest_proto_rawDesc
)

func file_attest_proto_rawDescGZIP() []byte {
	file_attest_proto_rawDescOnce.Do(func() {
		file_attest_proto_rawDescData = protoimpl.X.CompressGZIP(file_attest_proto_rawDescData)
	})
	return file_attest_proto_rawDescData
}

var file_attest_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_attest_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_attest_proto_goTypes = []interface{}{
	(GCEConfidentialTechnology)(0), // 0: attest.GCEConfidentialTechnology
	(WellKnownCertificate)(0),      // 1: attest.WellKnownCertificate
	(RestartPolicy)(0),             // 2: attest.RestartPolicy
	(*GCEInstanceInfo)(nil),        // 3: attest.GCEInstanceInfo
	(*Attestation)(nil),            // 4: attest.Attestation
	(*PlatformState)(nil),          // 5: attest.PlatformState
	(*Event)(nil),                  // 6: attest.Event
	(*Certificate)(nil),            // 7: attest.Certificate
	(*Database)(nil),               // 8: attest.Database
	(*SecureBootState)(nil),        // 9: attest.SecureBootState
	(*ContainerState)(nil),         // 10: attest.ContainerState
	(*SemanticVersion)(nil),        // 11: attest.SemanticVersion
	(*AttestedCosState)(nil),       // 12: attest.AttestedCosState
	(*MachineState)(nil),           // 13: attest.MachineState
	(*PlatformPolicy)(nil),         // 14: attest.PlatformPolicy
	(*Policy)(nil),                 // 15: attest.Policy
	nil,                            // 16: attest.ContainerState.EnvVarsEntry
	(*tpm.Quote)(nil),              // 17: tpm.Quote
	(tpm.HashAlgo)(0),              // 18: tpm.HashAlgo
}
var file_attest_proto_depIdxs = []int32{
	17, // 0: attest.Attestation.quotes:type_name -> tpm.Quote
	3,  // 1: attest.Attestation.instance_info:type_name -> attest.GCEInstanceInfo
	0,  // 2: attest.PlatformState.technology:type_name -> attest.GCEConfidentialTechnology
	3,  // 3: attest.PlatformState.instance_info:type_name -> attest.GCEInstanceInfo
	1,  // 4: attest.Certificate.well_known:type_name -> attest.WellKnownCertificate
	7,  // 5: attest.Database.certs:type_name -> attest.Certificate
	8,  // 6: attest.SecureBootState.db:type_name -> attest.Database
	8,  // 7: attest.SecureBootState.dbx:type_name -> attest.Database
	8,  // 8: attest.SecureBootState.authority:type_name -> attest.Database
	2,  // 9: attest.ContainerState.restart_policy:type_name -> attest.RestartPolicy
	16, // 10: attest.ContainerState.env_vars:type_name -> attest.ContainerState.EnvVarsEntry
	10, // 11: attest.AttestedCosState.container:type_name -> attest.ContainerState
	11, // 12: attest.AttestedCosState.cos_version:type_name -> attest.SemanticVersion
	11, // 13: attest.AttestedCosState.launcher_version:type_name -> attest.SemanticVersion
	5,  // 14: attest.MachineState.platform:type_name -> attest.PlatformState
	9,  // 15: attest.MachineState.secure_boot:type_name -> attest.SecureBootState
	6,  // 16: attest.MachineState.raw_events:type_name -> attest.Event
	18, // 17: attest.MachineState.hash:type_name -> tpm.HashAlgo
	12, // 18: attest.MachineState.cos:type_name -> attest.AttestedCosState
	0,  // 19: attest.PlatformPolicy.minimum_technology:type_name -> attest.GCEConfidentialTechnology
	14, // 20: attest.Policy.platform:type_name -> attest.PlatformPolicy
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_attest_proto_init() }
func file_attest_proto_init() {
	if File_attest_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_attest_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GCEInstanceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attestation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Database); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecureBootState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SemanticVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttestedCosState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_attest_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*PlatformState_ScrtmVersionId)(nil),
		(*PlatformState_GceVersion)(nil),
	}
	file_attest_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Certificate_Der)(nil),
		(*Certificate_WellKnown)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_attest_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_attest_proto_goTypes,
		DependencyIndexes: file_attest_proto_depIdxs,
		EnumInfos:         file_attest_proto_enumTypes,
		MessageInfos:      file_attest_proto_msgTypes,
	}.Build()
	File_attest_proto = out.File
	file_attest_proto_rawDesc = nil
	file_attest_proto_goTypes = nil
	file_attest_proto_depIdxs = nil
}
