## Release notes for kops 1.11 series

# Significant changes

* kops will attempt to remove NLBs (also known as ELB v2) that are
  tagged as created by the cluster.  Please double-check the preview
  from `kops delete cluster` before allowing deletion.

* JSON & YAML field names in the kops objects are case-sensitive.
  This was a regression across the kubernetes API libraries as
  observed [kubernetes#64612](https://github.com/kubernetes/kubernetes/issues/64612).
  Please double-check that you are using the correct field names if
  you are constructing YAML / JSON outside of kops.

* The default image on AWS for kubernetes 1.11 is now based on debian stretch,
  instead of debian jessie.  This has better support for NVME.

# New features

* Support for kubernetes 1.11
* Support using existing/shared AWS Security Groups
* Support for more AWS instance types (r5, r5d, z1d, t3, f1.4xlarge, p3dn.24xlarge)
* Addon updates (weave, dashboard, heapster, cluster-autoscaler, canal, coredns, cilium, aws-vpc-cni, lyft-vpc-cni, calico, kopeio-networking)
* Allow users to opt-in to etcd-manager
* More secure default settings when running kubernetes >= 1.11 (e.g. kubelet anonymous auth disabled)
* Improved GCE & OpenStack support, experimental support for SpotInst

# Required Actions

None known at this time

# Full change list since 1.10.0 release

* Move alpha channels to stable and update alpha [@mikesplain](https://github.com/mikesplain) [#5493](https://github.com/kubernetes/kops/pull/5493)
* Update stable channel to recommend latest kubernetes [@justinsb](https://github.com/justinsb) [#5500](https://github.com/kubernetes/kops/pull/5500)
* Put new kops versions into channels [@justinsb](https://github.com/justinsb) [#5501](https://github.com/kubernetes/kops/pull/5501)
* Add authentication-token-webhook-cache-ttl flag to kubelet config [@ihoegen](https://github.com/ihoegen) [#5508](https://github.com/kubernetes/kops/pull/5508)
* Add ssh user to kops toolbox dump [@justinsb](https://github.com/justinsb) [#5511](https://github.com/kubernetes/kops/pull/5511)
* makefile: tweaks to push & run targets [@justinsb](https://github.com/justinsb) [#5515](https://github.com/kubernetes/kops/pull/5515)
* kops set: fix example [@justinsb](https://github.com/justinsb) [#5516](https://github.com/kubernetes/kops/pull/5516)
* Docker installation from tar.gz [@justinsb](https://github.com/justinsb) [#5517](https://github.com/kubernetes/kops/pull/5517)
* Add new instance types r5, r5d, z1d [@rekcah78](https://github.com/rekcah78) [#5529](https://github.com/kubernetes/kops/pull/5529)
* add wider tolerations to the kube-router daemonset [@zivagolee](https://github.com/zivagolee) [#5525](https://github.com/kubernetes/kops/pull/5525)
* Some tweaks around IAM additional policies [@justinsb](https://github.com/justinsb) [#5536](https://github.com/kubernetes/kops/pull/5536)
* Add HACK_UPDATE_EXPECTED_IN_PLACE for cloudformation output [@justinsb](https://github.com/justinsb) [#5535](https://github.com/kubernetes/kops/pull/5535)
* Fix typo in comment [@justinsb](https://github.com/justinsb) [#5534](https://github.com/kubernetes/kops/pull/5534)
* Check errors when parsing JSON on IAM policies [@justinsb](https://github.com/justinsb) [#5533](https://github.com/kubernetes/kops/pull/5533)
* amazon-vpc-routed-eni cloudprovider check [@mikesplain](https://github.com/mikesplain) [#5540](https://github.com/kubernetes/kops/pull/5540)
* Add error handling for failed deletion of tempfiles [@justinsb](https://github.com/justinsb) [#5543](https://github.com/kubernetes/kops/pull/5543)
* Validate IAM additionalPolicies [@justinsb](https://github.com/justinsb) [#5541](https://github.com/kubernetes/kops/pull/5541)
* Add missing error handling when reading stdin [@justinsb](https://github.com/justinsb) [#5542](https://github.com/kubernetes/kops/pull/5542)
* Add error handling (logging) when we fail to close a file [@justinsb](https://github.com/justinsb) [#5544](https://github.com/kubernetes/kops/pull/5544)
* Fix api-gen-docs dependencies [@mikesplain](https://github.com/mikesplain) [#5507](https://github.com/kubernetes/kops/pull/5507)
* Parallel bazel crossbuild kops [@mikesplain](https://github.com/mikesplain) [#5523](https://github.com/kubernetes/kops/pull/5523)
* Load client-auth plugins [@ripta](https://github.com/ripta) [#5513](https://github.com/kubernetes/kops/pull/5513)
* one word change to docs grammar tense issue ran -> run [@ms4720](https://github.com/ms4720) [#5546](https://github.com/kubernetes/kops/pull/5546)
* Spell Fix: Fixing spelling of "Kubernetes" in doc [@Rajat-0](https://github.com/Rajat-0) [#5550](https://github.com/kubernetes/kops/pull/5550)
* Remove GetAsgForInstance IAM permission [@justinsb](https://github.com/justinsb) [#5566](https://github.com/kubernetes/kops/pull/5566)
* Don't set kube-proxy cluster-cidr with aws-vpc-cni [@spikecurtis](https://github.com/spikecurtis) [#5579](https://github.com/kubernetes/kops/pull/5579)
* Move CloudProviderID consts into a block  [#5590](https://github.com/kubernetes/kops/pull/5590)
* Fix cpu unit measurement [@asosso](https://github.com/asosso) [#5589](https://github.com/kubernetes/kops/pull/5589)
* Node Authorizer Prometheus Metrics [@gambol99](https://github.com/gambol99) [#5599](https://github.com/kubernetes/kops/pull/5599)
* Add AWS IAM permission to check for volume resize [@KashifSaadat](https://github.com/KashifSaadat) [#5597](https://github.com/kubernetes/kops/pull/5597)
* Add amazon.com image owner alias and Amazon Linux 2 documentation [@Pharb](https://github.com/Pharb) [#5577](https://github.com/kubernetes/kops/pull/5577)
* make dep-ensure checks that mercurial is installed [@justinsb](https://github.com/justinsb) [#5600](https://github.com/kubernetes/kops/pull/5600)
* Ability to configure `--node-cidr-mask-size` into `kube-controller-manager` [@robermorales](https://github.com/robermorales) [#5596](https://github.com/kubernetes/kops/pull/5596)
* fix typo [@fqsghostcloud](https://github.com/fqsghostcloud) [#5604](https://github.com/kubernetes/kops/pull/5604)
* Update install.md [@fqsghostcloud](https://github.com/fqsghostcloud) [#5603](https://github.com/kubernetes/kops/pull/5603)
* Don't assume that we only have one subnet per AZ [@justinsb](https://github.com/justinsb) [#5601](https://github.com/kubernetes/kops/pull/5601)
* Fix additional security groups changes on api lb [@mikesplain](https://github.com/mikesplain) [#5602](https://github.com/kubernetes/kops/pull/5602)
* fix name of demo-app-v2 [@fqsghostcloud](https://github.com/fqsghostcloud) [#5605](https://github.com/kubernetes/kops/pull/5605)
* Enable weave network encryption for k8s 1.6 [@Andrey9kin](https://github.com/Andrey9kin) [#5595](https://github.com/kubernetes/kops/pull/5595)
* Bump Weave Net to v2.4.0  [#5552](https://github.com/kubernetes/kops/pull/5552)
* Create ExperimentalClusterDNS feature flag [@justinsb](https://github.com/justinsb) [#5610](https://github.com/kubernetes/kops/pull/5610)
* weave: bump version for 2.3.0 [@justinsb](https://github.com/justinsb) [#5618](https://github.com/kubernetes/kops/pull/5618)
* Validate that require-kubeconfig is not passed after 1.10 [@justinsb](https://github.com/justinsb) [#5621](https://github.com/kubernetes/kops/pull/5621)
* Docs for policy to do cross account state store in s3 [@geojaz](https://github.com/geojaz) [#5622](https://github.com/kubernetes/kops/pull/5622)
* DigitalOcean: don't try to set SSE [@justinsb](https://github.com/justinsb) [#5625](https://github.com/kubernetes/kops/pull/5625)
* Remove _kubernetes_master tag [@justinsb](https://github.com/justinsb) [#5623](https://github.com/kubernetes/kops/pull/5623)
* Update CoreDNS deployment [@rajansandeep](https://github.com/rajansandeep) [#5608](https://github.com/kubernetes/kops/pull/5608)
* Add `DEBUGGABLE` option to Makefile to compile debuggable bins  [#5636](https://github.com/kubernetes/kops/pull/5636)
* Add changelog to release notes for 1.10 [@justinsb](https://github.com/justinsb) [#5639](https://github.com/kubernetes/kops/pull/5639)
* Update README.md [@wangxy518](https://github.com/wangxy518) [#5638](https://github.com/kubernetes/kops/pull/5638)
* Fix build: prevent verify-misspelling failing on releases [@Mikulas](https://github.com/Mikulas) [#5643](https://github.com/kubernetes/kops/pull/5643)
* Update readme compatibility matrix for 1.10 [@mikesplain](https://github.com/mikesplain) [#5484](https://github.com/kubernetes/kops/pull/5484)
* Bump channels for 1.10.0 [@mikesplain](https://github.com/mikesplain) [#5645](https://github.com/kubernetes/kops/pull/5645)
* Upgrade DigitalOcean CCM to v0.1.7 [@andrewsykim](https://github.com/andrewsykim) [#5651](https://github.com/kubernetes/kops/pull/5651)
* add kube-proxy hostname override [@andrewsykim](https://github.com/andrewsykim) [#5649](https://github.com/kubernetes/kops/pull/5649)
* Create getting started with OpenStack doc  [#5637](https://github.com/kubernetes/kops/pull/5637)
* Update route53api.go [@wangxy518](https://github.com/wangxy518) [#5648](https://github.com/kubernetes/kops/pull/5648)
* AWS VPC Daemonset Correctly Tolerate Node Taints [@benjigoldberg](https://github.com/benjigoldberg) [#5654](https://github.com/kubernetes/kops/pull/5654)
* Added // restore // guide to single-to-multi-master.md [@vlaza](https://github.com/vlaza) [#5580](https://github.com/kubernetes/kops/pull/5580)
* Update alpha channel with images for foreshadow [@justinsb](https://github.com/justinsb) [#5657](https://github.com/kubernetes/kops/pull/5657)
* Basic validation for imagetype for NVME enabled instances [@geojaz](https://github.com/geojaz) [#5660](https://github.com/kubernetes/kops/pull/5660)
* Apply cloud labels into ELB [@wingyplus](https://github.com/wingyplus) [#5593](https://github.com/kubernetes/kops/pull/5593)
* Cherry-pick release 1.10.0 commit [@justinsb](https://github.com/justinsb) [#5665](https://github.com/kubernetes/kops/pull/5665)
* Promote kubernetes versions from alpha -> stable [@justinsb](https://github.com/justinsb) [#5663](https://github.com/kubernetes/kops/pull/5663)
* Fix codegen make target  [#5662](https://github.com/kubernetes/kops/pull/5662)
* Push latest k8s versions to alpha channel [@justinsb](https://github.com/justinsb) [#5666](https://github.com/kubernetes/kops/pull/5666)
* Added myself to SECURITY_CONTACTS [@geojaz](https://github.com/geojaz) [#5674](https://github.com/kubernetes/kops/pull/5674)
* Fixes go vet complain in package upup/pkg/fi/cloudup/awstasks [@wingyplus](https://github.com/wingyplus) [#5669](https://github.com/kubernetes/kops/pull/5669)
* Update machine_types.go to support T3 family [@wanghanlin](https://github.com/wanghanlin) [#5681](https://github.com/kubernetes/kops/pull/5681)
* Change vendored weave mesh to use hash keys by default [@justinsb](https://github.com/justinsb) [#5693](https://github.com/kubernetes/kops/pull/5693)
* Add etcd volumeSize docs [@mikesplain](https://github.com/mikesplain) [#5692](https://github.com/kubernetes/kops/pull/5692)
* Fix a typo: ectd->etcd [@AdamDang](https://github.com/AdamDang) [#5698](https://github.com/kubernetes/kops/pull/5698)
* add flag +ExperimentalClusterDNS in docs [@rekcah78](https://github.com/rekcah78) [#5708](https://github.com/kubernetes/kops/pull/5708)
* Adding kubernetes/dashboard v1.10.0 for K8S >=1.10.0 [@schweizerbolzonello](https://github.com/schweizerbolzonello) [#5702](https://github.com/kubernetes/kops/pull/5702)
* updated image versions and deployment instructions for the nginx-ingress addon [@kanolato](https://github.com/kanolato) [#5711](https://github.com/kubernetes/kops/pull/5711)
* Update CoreDNS version and manifest [@rajansandeep](https://github.com/rajansandeep) [#5727](https://github.com/kubernetes/kops/pull/5727)
* Vendor servergroup module from gophercloud  [#5678](https://github.com/kubernetes/kops/pull/5678)
* Make chrisz100 a reviewer for kops [@chrisz100](https://github.com/chrisz100) [#5716](https://github.com/kubernetes/kops/pull/5716)
* OpenStack: enable cluster state deletion  [#5731](https://github.com/kubernetes/kops/pull/5731)
* OpenStack: vendor schedulerhints  [#5732](https://github.com/kubernetes/kops/pull/5732)
* lifecycle tests: check no legacy tags on shared resources [@justinsb](https://github.com/justinsb) [#4797](https://github.com/kubernetes/kops/pull/4797)
* Refactor tables package to be more reusable [@justinsb](https://github.com/justinsb) [#5565](https://github.com/kubernetes/kops/pull/5565)
* Fix suspendprocess [@mikesplain](https://github.com/mikesplain) [#5503](https://github.com/kubernetes/kops/pull/5503)
* Fixes go vet complains [@wingyplus](https://github.com/wingyplus) [#5686](https://github.com/kubernetes/kops/pull/5686)
* correct 8 spell errors [@sunlintong](https://github.com/sunlintong) [#5740](https://github.com/kubernetes/kops/pull/5740)
* correct spell errors in 'docs/cluster_spec.md' [@sunlintong](https://github.com/sunlintong) [#5739](https://github.com/kubernetes/kops/pull/5739)
* --output json added to aws [@kulik0v](https://github.com/kulik0v) [#5742](https://github.com/kubernetes/kops/pull/5742)
* Use appropriate log level for KOPS_STATE_S3_ACL debug message [@davidarcher](https://github.com/davidarcher) [#5726](https://github.com/kubernetes/kops/pull/5726)
* Update k8s-ec2-srcdst to v0.2.2 [@willthames](https://github.com/willthames) [#5746](https://github.com/kubernetes/kops/pull/5746)
* Add elasticloadbalancing:DeregisterTargets permission to master policy [@kellycampbell](https://github.com/kellycampbell) [#5752](https://github.com/kubernetes/kops/pull/5752)
* Typo fix: bellow -> below [@mirake](https://github.com/mirake) [#5764](https://github.com/kubernetes/kops/pull/5764)
* Update README.md [@geojaz](https://github.com/geojaz) [#5769](https://github.com/kubernetes/kops/pull/5769)
* Machine type generator [@mikesplain](https://github.com/mikesplain) [#5553](https://github.com/kubernetes/kops/pull/5553)
* let aws command output json [@zouguangxian](https://github.com/zouguangxian) [#5471](https://github.com/kubernetes/kops/pull/5471)
* Explicitly install conntrack [@johanneswuerbach](https://github.com/johanneswuerbach) [#5745](https://github.com/kubernetes/kops/pull/5745)
* Don't unset AWS_PROFILE in Makefile [@justinsb](https://github.com/justinsb) [#5784](https://github.com/kubernetes/kops/pull/5784)
* machine-type generator: go vet fixes [@justinsb](https://github.com/justinsb) [#5787](https://github.com/kubernetes/kops/pull/5787)
* typo fixes in stable for ci verify jobs [@chrisz100](https://github.com/chrisz100) [#5737](https://github.com/kubernetes/kops/pull/5737)
* Fix interactive rolling update silently ignored [@Mikulas](https://github.com/Mikulas) [#5642](https://github.com/kubernetes/kops/pull/5642)
* Add Docker 18.06.1 for Debian Stretch [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#5758](https://github.com/kubernetes/kops/pull/5758)
* Update iaminstanceprofile.go [@wangxy518](https://github.com/wangxy518) [#5641](https://github.com/kubernetes/kops/pull/5641)
* Recognize ubuntu images in sshUser dumping [@justinsb](https://github.com/justinsb) [#5796](https://github.com/kubernetes/kops/pull/5796)
* Added documentation for Api server LB Certificate [@fernandocarletti](https://github.com/fernandocarletti) [#5793](https://github.com/kubernetes/kops/pull/5793)
* Move verify-spelling to script, install from vendor [@justinsb](https://github.com/justinsb) [#5785](https://github.com/kubernetes/kops/pull/5785)
* Protect against panic when networking is not set [@justinsb](https://github.com/justinsb) [#5801](https://github.com/kubernetes/kops/pull/5801)
* Cni toleration for tainted nodes [@jhohertz](https://github.com/jhohertz) [#5804](https://github.com/kubernetes/kops/pull/5804)
* Fix bazel cross platform [@mikesplain](https://github.com/mikesplain) [#5799](https://github.com/kubernetes/kops/pull/5799)
* Addon update heapster [@recollir](https://github.com/recollir) [#5199](https://github.com/kubernetes/kops/pull/5199)
* Amazon VPC CNI: Kubernetes 1.8+ Manifests [@ripta](https://github.com/ripta) [#5290](https://github.com/kubernetes/kops/pull/5290)
* Add `useRawManifest` hook option to install `manifest` as a hook unmodified [@geekofalltrades](https://github.com/geekofalltrades) [#5106](https://github.com/kubernetes/kops/pull/5106)
* Add rdrgmnzs as a reviewer to owners file. [@rdrgmnzs](https://github.com/rdrgmnzs) [#5813](https://github.com/kubernetes/kops/pull/5813)
* Support for deletion of aws resources albs nlbs during delete [@nareshku](https://github.com/nareshku) [#5635](https://github.com/kubernetes/kops/pull/5635)
* dns-controller: allow configuring DNS update interval  [#5759](https://github.com/kubernetes/kops/pull/5759)
* Avoid using which, CoreOS doesn't always have it [@justinsb](https://github.com/justinsb) [#5795](https://github.com/kubernetes/kops/pull/5795)
* Start release notes for 1.11 [@justinsb](https://github.com/justinsb) [#5815](https://github.com/kubernetes/kops/pull/5815)
* Generate live project documentation using mkdocs and gh-pages [@aledbf](https://github.com/aledbf),[@justinsb](https://github.com/justinsb) [#5085](https://github.com/kubernetes/kops/pull/5085)
* Fix a typo in usage of server.go [@AdamDang](https://github.com/AdamDang) [#5811](https://github.com/kubernetes/kops/pull/5811)
* Bazel Rules go 0.14 [@mikesplain](https://github.com/mikesplain) [#5481](https://github.com/kubernetes/kops/pull/5481)
* Update gazelle for concurrent PR changes [@justinsb](https://github.com/justinsb) [#5819](https://github.com/kubernetes/kops/pull/5819)
* Add test for etcd-manager output [@justinsb](https://github.com/justinsb) [#5547](https://github.com/kubernetes/kops/pull/5547)
* Delete nodes from k8s api during rolling-update [@justinsb](https://github.com/justinsb) [#5794](https://github.com/kubernetes/kops/pull/5794)
* Update golang version to 1.10.3, for k8s 1.11 [@justinsb](https://github.com/justinsb) [#5817](https://github.com/kubernetes/kops/pull/5817)
* Prune some broken files out of vendor [@justinsb](https://github.com/justinsb) [#5821](https://github.com/kubernetes/kops/pull/5821)
* Field names are case-sensitive again [@justinsb](https://github.com/justinsb) [#5828](https://github.com/kubernetes/kops/pull/5828)
* Run dep to add missing new aws dependencies for elbv2 [@justinsb](https://github.com/justinsb) [#5822](https://github.com/kubernetes/kops/pull/5822)
* Tweak machine_types generator to match our existing values [@justinsb](https://github.com/justinsb) [#5783](https://github.com/kubernetes/kops/pull/5783)
* Fixes spurious LoadBalancer change when using ACM Certificate [@rifelpet](https://github.com/rifelpet) [#5814](https://github.com/kubernetes/kops/pull/5814)
* Revert "Apply cloud labels into ELB" [@gambol99](https://github.com/gambol99) [#5834](https://github.com/kubernetes/kops/pull/5834)
* Fix markdown typo [@coryflucas](https://github.com/coryflucas) [#5838](https://github.com/kubernetes/kops/pull/5838)
* Node Authorizer Fixes [@gambol99](https://github.com/gambol99) [#5841](https://github.com/kubernetes/kops/pull/5841)
* Update HPA docs [@jsenon](https://github.com/jsenon) [#5842](https://github.com/kubernetes/kops/pull/5842)
* Add clarity to AWS IAM Authenticator documentation [@rifelpet](https://github.com/rifelpet) [#5843](https://github.com/kubernetes/kops/pull/5843)
* ECU fixes and add f1.4xlarge [@mikesplain](https://github.com/mikesplain) [#5844](https://github.com/kubernetes/kops/pull/5844)
* Update to k8s 1.11 libraries, fix code [@justinsb](https://github.com/justinsb) [#5823](https://github.com/kubernetes/kops/pull/5823)
* Fix minor typo. [@bheesham](https://github.com/bheesham) [#5849](https://github.com/kubernetes/kops/pull/5849)
* copy path on kops-server-build [@mahuihuang](https://github.com/mahuihuang) [#5719](https://github.com/kubernetes/kops/pull/5719)
* cluster-autoscaler.yaml for 1.10 [@koooge](https://github.com/koooge) [#5741](https://github.com/kubernetes/kops/pull/5741)
* Controller Manager Flag [@gambol99](https://github.com/gambol99) [#5855](https://github.com/kubernetes/kops/pull/5855)
* Allow using existing/shared Security Groups [@rdrgmnzs](https://github.com/rdrgmnzs) [#5744](https://github.com/kubernetes/kops/pull/5744)
* etcd: introduce field to specify whether we are using etcd-manager or legacy mode [@justinsb](https://github.com/justinsb) [#5820](https://github.com/kubernetes/kops/pull/5820)
* Follow on for #5744 [@justinsb](https://github.com/justinsb) [#5862](https://github.com/kubernetes/kops/pull/5862)
* Remove last vestiges of _vendor directory [@justinsb](https://github.com/justinsb) [#5865](https://github.com/kubernetes/kops/pull/5865)
* Stop cloudformation output switching to literal quotes [@justinsb](https://github.com/justinsb) [#5857](https://github.com/kubernetes/kops/pull/5857)
* doc: Trivial spelling change [@karlmutch](https://github.com/karlmutch) [#5861](https://github.com/kubernetes/kops/pull/5861)
* Node mode controllers [@gambol99](https://github.com/gambol99) [#5867](https://github.com/kubernetes/kops/pull/5867)
* Node Authorizer Fixes [@gambol99](https://github.com/gambol99) [#5868](https://github.com/kubernetes/kops/pull/5868)
* Fix broken url in CONTRIBUTING.md [@posquit0](https://github.com/posquit0) [#5853](https://github.com/kubernetes/kops/pull/5853)
* doc: fix minor typo in the terraform doc [@a8m](https://github.com/a8m) [#5860](https://github.com/kubernetes/kops/pull/5860)
* Mirror secrets using API [@justinsb](https://github.com/justinsb) [#5858](https://github.com/kubernetes/kops/pull/5858)
* Fix mis-typing in documentation [@posquit0](https://github.com/posquit0) [#5859](https://github.com/kubernetes/kops/pull/5859)
* Generate much smaller keys in integration tests [@justinsb](https://github.com/justinsb) [#5869](https://github.com/kubernetes/kops/pull/5869)
* Don't override name of ELB API SecurityGroup [@justinsb](https://github.com/justinsb) [#5863](https://github.com/kubernetes/kops/pull/5863)
* Fix a few typos. [@rdrgmnzs](https://github.com/rdrgmnzs) [#5872](https://github.com/kubernetes/kops/pull/5872)
* Fix mis-typings in docs [@posquit0](https://github.com/posquit0) [#5879](https://github.com/kubernetes/kops/pull/5879)
* Fix mis-typings in documentation. [@posquit0](https://github.com/posquit0) [#5878](https://github.com/kubernetes/kops/pull/5878)
* Add no_masq_local to weave network options. [@arturo-c](https://github.com/arturo-c) [#5812](https://github.com/kubernetes/kops/pull/5812)
* propagate error when initializing digitalocean provider [@andrewsykim](https://github.com/andrewsykim) [#5894](https://github.com/kubernetes/kops/pull/5894)
* Fixed duplicate info  [#5425](https://github.com/kubernetes/kops/pull/5425)
* Small typo fix [@AdamDang](https://github.com/AdamDang) [#5721](https://github.com/kubernetes/kops/pull/5721)
* Grammar mistakes [@yjl-lgx](https://github.com/yjl-lgx),[@justinsb](https://github.com/justinsb) [#4687](https://github.com/kubernetes/kops/pull/4687)
* add support for max-mutating-requests-inflight parameter [@captainkerk](https://github.com/captainkerk) [#5832](https://github.com/kubernetes/kops/pull/5832)
* Fix mis-typings in docs [@posquit0](https://github.com/posquit0) [#5887](https://github.com/kubernetes/kops/pull/5887)
* Fix some typos [@mirake](https://github.com/mirake) [#5882](https://github.com/kubernetes/kops/pull/5882)
* Fix typos issues [@mooncak](https://github.com/mooncak) [#5885](https://github.com/kubernetes/kops/pull/5885)
* Fix typos issues in upup files [@mooncak](https://github.com/mooncak) [#5886](https://github.com/kubernetes/kops/pull/5886)
* Fix mis-typings in docs [@posquit0](https://github.com/posquit0) [#5888](https://github.com/kubernetes/kops/pull/5888)
* Fix broken link to etcd 2 documentation [@mbode](https://github.com/mbode) [#5889](https://github.com/kubernetes/kops/pull/5889)
* Update create-cluster arg help [@justinsb](https://github.com/justinsb) [#5896](https://github.com/kubernetes/kops/pull/5896)
* fix network.md [@fqsghostcloud](https://github.com/fqsghostcloud) [#5900](https://github.com/kubernetes/kops/pull/5900)
* fix install.md [@fqsghostcloud](https://github.com/fqsghostcloud) [#5901](https://github.com/kubernetes/kops/pull/5901)
* Removed misleading comment about metav1 [@justinsb](https://github.com/justinsb) [#5898](https://github.com/kubernetes/kops/pull/5898)
* add targetRamMb to kubeAPIServer spec [@captainkerk](https://github.com/captainkerk) [#5890](https://github.com/kubernetes/kops/pull/5890)
* Fix mis-typing in CLI command documentations [@posquit0](https://github.com/posquit0) [#5854](https://github.com/kubernetes/kops/pull/5854)
* alpha-channel: Use stretch by default for k8s 1.11 on AWS [@justinsb](https://github.com/justinsb) [#5897](https://github.com/kubernetes/kops/pull/5897)
* Fix cloudmock to pass govet [@justinsb](https://github.com/justinsb) [#4949](https://github.com/kubernetes/kops/pull/4949)
* Update Weave Net to version 2.4.1 [@bboreham](https://github.com/bboreham) [#5845](https://github.com/kubernetes/kops/pull/5845)
* fix typo: remove duplicate words [@SataQiu](https://github.com/SataQiu) [#5883](https://github.com/kubernetes/kops/pull/5883)
* Add default S3 encryption example [@RulerOf](https://github.com/RulerOf) [#5884](https://github.com/kubernetes/kops/pull/5884)
* fix service name [@fqsghostcloud](https://github.com/fqsghostcloud) [#5899](https://github.com/kubernetes/kops/pull/5899)
* Canal Manifest Fix (Kubernetes >= v1.12.0) [@gambol99](https://github.com/gambol99) [#5910](https://github.com/kubernetes/kops/pull/5910)
* Update weave bootstrapchannelbuilder version [@justinsb](https://github.com/justinsb) [#5903](https://github.com/kubernetes/kops/pull/5903)
* fix some typos [@SataQiu](https://github.com/SataQiu) [#5909](https://github.com/kubernetes/kops/pull/5909)
* Google Cloud Storage md5 decoding fix [@justinsb](https://github.com/justinsb) [#5906](https://github.com/kubernetes/kops/pull/5906)
* If don't use formatted output,fix logging calls [@mikeweiwei](https://github.com/mikeweiwei) [#5911](https://github.com/kubernetes/kops/pull/5911)
* Promote kubernetes versions from alpha to stable [@justinsb](https://github.com/justinsb) [#5913](https://github.com/kubernetes/kops/pull/5913)
* alpha channel: update with latest kubernetes versions [@justinsb](https://github.com/justinsb) [#5914](https://github.com/kubernetes/kops/pull/5914)
* Recognize shasum format for hashes [@justinsb](https://github.com/justinsb) [#5893](https://github.com/kubernetes/kops/pull/5893)
* fix typo in comment [@rdrgmnzs](https://github.com/rdrgmnzs) [#5915](https://github.com/kubernetes/kops/pull/5915)
* Optimize kops get cluster with a cluster name [@justinsb](https://github.com/justinsb) [#5920](https://github.com/kubernetes/kops/pull/5920)
* Service Address Check [@gambol99](https://github.com/gambol99) [#5923](https://github.com/kubernetes/kops/pull/5923)
* s3: lazy-evaluate encryption policy [@justinsb](https://github.com/justinsb) [#5921](https://github.com/kubernetes/kops/pull/5921)
* Fixed node-authorizer systemd Unit paths [@liviudm](https://github.com/liviudm) [#5918](https://github.com/kubernetes/kops/pull/5918)
* fix some typos [@SataQiu](https://github.com/SataQiu) [#5924](https://github.com/kubernetes/kops/pull/5924)
* Disable RBAC Addon's in Node Mode [@gambol99](https://github.com/gambol99) [#5925](https://github.com/kubernetes/kops/pull/5925)
* added possible state store vendors to documentation [@chrisz100](https://github.com/chrisz100) [#5931](https://github.com/kubernetes/kops/pull/5931)
* Fix documents issue [@mooncak](https://github.com/mooncak) [#5943](https://github.com/kubernetes/kops/pull/5943)
* Canal v3 [@gambol99](https://github.com/gambol99) [#5927](https://github.com/kubernetes/kops/pull/5927)
* fix small typos in security.md [@AdamDang](https://github.com/AdamDang) [#5942](https://github.com/kubernetes/kops/pull/5942)
* Fix typos in files [@mooncak](https://github.com/mooncak) [#5944](https://github.com/kubernetes/kops/pull/5944)
* New integration: Spotinst [@liranp](https://github.com/liranp) [#5922](https://github.com/kubernetes/kops/pull/5922)
* Ensure we parse k8s versions through 1.16 [@justinsb](https://github.com/justinsb) [#5948](https://github.com/kubernetes/kops/pull/5948)
*  IPVS Options [@gambol99](https://github.com/gambol99) [#5935](https://github.com/kubernetes/kops/pull/5935)
* Promote AMIs from alpha -> stable [@justinsb](https://github.com/justinsb) [#5947](https://github.com/kubernetes/kops/pull/5947)
* Mark release 1.11.0-alpha.1 [@justinsb](https://github.com/justinsb) [#5949](https://github.com/kubernetes/kops/pull/5949)
* add EnableNodeAuthorization in the list of experimental features [@rekcah78](https://github.com/rekcah78) [#5953](https://github.com/kubernetes/kops/pull/5953)
* Fix broken url in documentation [@posquit0](https://github.com/posquit0) [#5957](https://github.com/kubernetes/kops/pull/5957)
* Delete duplicate 'be'. [@xichengliudui](https://github.com/xichengliudui) [#5963](https://github.com/kubernetes/kops/pull/5963)
* Fix grammatical error in the warning message [@AdamDang](https://github.com/AdamDang) [#5951](https://github.com/kubernetes/kops/pull/5951)
* Add suggested alias for bazelrc import location [@justinsb](https://github.com/justinsb) [#5966](https://github.com/kubernetes/kops/pull/5966)
* Fix the typos [@SataQiu](https://github.com/SataQiu) [#5972](https://github.com/kubernetes/kops/pull/5972)
* Switch CI to bazel [@justinsb](https://github.com/justinsb) [#5974](https://github.com/kubernetes/kops/pull/5974)
* Fix nsenter mounter in protokube [@justinsb](https://github.com/justinsb) [#5970](https://github.com/kubernetes/kops/pull/5970)
* Use hostPID: true with etcd-manager [@justinsb](https://github.com/justinsb) [#5969](https://github.com/kubernetes/kops/pull/5969)
* terraform: Fix resource formatting for IPv6 CIDRs [@a8m](https://github.com/a8m) [#5979](https://github.com/kubernetes/kops/pull/5979)
* Correct Spelling of "kubernetesVersion" [@johannes-gehrs](https://github.com/johannes-gehrs) [#5928](https://github.com/kubernetes/kops/pull/5928)
* Add support for cn-northwest-1c. [@leeeboo](https://github.com/leeeboo) [#5956](https://github.com/kubernetes/kops/pull/5956)
* Remove excess Spaces [@xichengliudui](https://github.com/xichengliudui) [#5981](https://github.com/kubernetes/kops/pull/5981)
* More CNI toleration for tainted nodes. [@jhohertz](https://github.com/jhohertz) [#5946](https://github.com/kubernetes/kops/pull/5946)
* Fixed issue when specifying ACM cert and no load balancer is defined [@Raffo](https://github.com/Raffo) [#5971](https://github.com/kubernetes/kops/pull/5971)
* fix typo in comments [@TinySong](https://github.com/TinySong) [#6001](https://github.com/kubernetes/kops/pull/6001)
* Clarify license statement for nvidia-bootstrap hook [@swinslow](https://github.com/swinslow) [#6006](https://github.com/kubernetes/kops/pull/6006)
* fixed MIN_NODES missing closing bracket [@victortrac](https://github.com/victortrac) [#5996](https://github.com/kubernetes/kops/pull/5996)
* fix typo in log [@TinySong](https://github.com/TinySong) [#6002](https://github.com/kubernetes/kops/pull/6002)
* Mount etc-hosts in calico-kube-controller [@shrinandj](https://github.com/shrinandj) [#5950](https://github.com/kubernetes/kops/pull/5950)
* Bump CoreDNS version to 1.2.4 and update manifest [@rajansandeep](https://github.com/rajansandeep) [#5985](https://github.com/kubernetes/kops/pull/5985)
* cilium: Fix Prometheus serve addr flag [@rochacon](https://github.com/rochacon) [#5987](https://github.com/kubernetes/kops/pull/5987)
* Add stdin input for secrets [@ihoegen](https://github.com/ihoegen) [#5993](https://github.com/kubernetes/kops/pull/5993)
* Separate subnet utils into a standalone package [@errordeveloper](https://github.com/errordeveloper) [#6004](https://github.com/kubernetes/kops/pull/6004)
* Fixed missing closing bracket around MIN_NODES [@vivekgarg20](https://github.com/vivekgarg20) [#5870](https://github.com/kubernetes/kops/pull/5870)
* Update v0.19.0.yaml [@wangxy518](https://github.com/wangxy518) [#5997](https://github.com/kubernetes/kops/pull/5997)
* Change the wrong function name and wrong word [@xichengliudui](https://github.com/xichengliudui) [#6018](https://github.com/kubernetes/kops/pull/6018)
* Prune some license files that dep added [@justinsb](https://github.com/justinsb) [#6019](https://github.com/kubernetes/kops/pull/6019)
* Fix s3 encryption role [@rhyas](https://github.com/rhyas) [#6039](https://github.com/kubernetes/kops/pull/6039)
* Fix indentation for monitoring-standalone addon [@KashifSaadat](https://github.com/KashifSaadat) [#6032](https://github.com/kubernetes/kops/pull/6032)
* Canal v3.3.0 for Kubernetes v1.12+ [@KashifSaadat](https://github.com/KashifSaadat) [#6037](https://github.com/kubernetes/kops/pull/6037)
* Correct the table format in upgrade_from_kubeup.md [@AdamDang](https://github.com/AdamDang) [#6023](https://github.com/kubernetes/kops/pull/6023)
* Update Weave Net to version 2.5.0 [@bboreham](https://github.com/bboreham) [#6043](https://github.com/kubernetes/kops/pull/6043)
* Change "if" -> "if and only if" to make more clear  [@mooncak](https://github.com/mooncak) [#6041](https://github.com/kubernetes/kops/pull/6041)
* Spotinst: Attempt to find a Security Group even without a VPC ID [@liranp](https://github.com/liranp) [#6030](https://github.com/kubernetes/kops/pull/6030)
* fix some typos [@SataQiu](https://github.com/SataQiu) [#6013](https://github.com/kubernetes/kops/pull/6013)
* Fix blog link [@hintss](https://github.com/hintss) [#6022](https://github.com/kubernetes/kops/pull/6022)
* Bump kopeio-networking to latest version [@justinsb](https://github.com/justinsb) [#6010](https://github.com/kubernetes/kops/pull/6010)
* Spotinst: Do not log unmatched groups as warning messages [@liranp](https://github.com/liranp) [#6025](https://github.com/kubernetes/kops/pull/6025)
* #5700: Add command line flag for disabling Subnet ELB tags [@seanson](https://github.com/seanson) [#5875](https://github.com/kubernetes/kops/pull/5875)
* Remove unnecessary code [@xichengliudui](https://github.com/xichengliudui) [#6053](https://github.com/kubernetes/kops/pull/6053)
* Fix some typos [@mooncak](https://github.com/mooncak) [#6048](https://github.com/kubernetes/kops/pull/6048)
* Fix some typos in files [@mooncak](https://github.com/mooncak) [#6064](https://github.com/kubernetes/kops/pull/6064)
* Detail Calico BGP route reflector requirements [@Vlaaaaaaad](https://github.com/Vlaaaaaaad) [#6047](https://github.com/kubernetes/kops/pull/6047)
* coredns should not be running on master by default [@bhegazy](https://github.com/bhegazy) [#5917](https://github.com/kubernetes/kops/pull/5917)
* Document etcd volume options + fail fast if ratio is too high [@Vlaaaaaaad](https://github.com/Vlaaaaaaad) [#6035](https://github.com/kubernetes/kops/pull/6035)
* Spotinst: Skip the creation of LoadBalancerAttachment tasks if Spotinst is enabled [@liranp](https://github.com/liranp) [#6015](https://github.com/kubernetes/kops/pull/6015)
* Calico v3 upgrade [@tmjd](https://github.com/tmjd) [#5102](https://github.com/kubernetes/kops/pull/5102)
* Update Calico to v3.3.1 [@caseydavenport](https://github.com/caseydavenport) [#6077](https://github.com/kubernetes/kops/pull/6077)
* delete some code [@xichengliudui](https://github.com/xichengliudui) [#6078](https://github.com/kubernetes/kops/pull/6078)
* Adding describe launch config to autoscaler permissions [@brosander](https://github.com/brosander) [#5929](https://github.com/kubernetes/kops/pull/5929)
* Remove trailing comma from k8s-1.7-v3.yaml.template [@Smirl](https://github.com/Smirl) [#6086](https://github.com/kubernetes/kops/pull/6086)
* Updating image and docs for metrics-server add-on [@Cryptophobia](https://github.com/Cryptophobia) [#5873](https://github.com/kubernetes/kops/pull/5873)
* Updates to roadmap for 1.11 and 1.12 and new upcoming features section (WIP) [@geojaz](https://github.com/geojaz) [#5824](https://github.com/kubernetes/kops/pull/5824)
* Update amazon-vpc-routed-eni to v1.2.1 [@adammw](https://github.com/adammw) [#5905](https://github.com/kubernetes/kops/pull/5905)
* Request AWS ASGs in batches [@KierranM](https://github.com/KierranM) [#6056](https://github.com/kubernetes/kops/pull/6056)
* Typo fix: Deploy -> Deploying [@JoeWrightss](https://github.com/JoeWrightss) [#6087](https://github.com/kubernetes/kops/pull/6087)
* Use a single command in Linux install instructions [@jbowes](https://github.com/jbowes) [#6084](https://github.com/kubernetes/kops/pull/6084)
* autoscaler setup: Use set -e to stop execution if errors are encountered [@eherot](https://github.com/eherot) [#6089](https://github.com/kubernetes/kops/pull/6089)
* Typo fix "api server" -> "API server" [@JoeWrightss](https://github.com/JoeWrightss) [#6092](https://github.com/kubernetes/kops/pull/6092)
* increase docker-healthcheck respose timeout [@tatobi](https://github.com/tatobi) [#5644](https://github.com/kubernetes/kops/pull/5644)
* Bump version of amazon-vpc-cni in bootstrapchannelbuilder [@justinsb](https://github.com/justinsb) [#6094](https://github.com/kubernetes/kops/pull/6094)
* Fix typo in CRD: singuar [@justinsb](https://github.com/justinsb) [#6095](https://github.com/kubernetes/kops/pull/6095)
* add SSL certificate ARN to Terraform output [@j00p34](https://github.com/j00p34) [#6082](https://github.com/kubernetes/kops/pull/6082)
* Add flag to disable Basic Auth. [@fernandocarletti](https://github.com/fernandocarletti) [#5586](https://github.com/kubernetes/kops/pull/5586)
* Update machine types [@justinsb](https://github.com/justinsb) [#6096](https://github.com/kubernetes/kops/pull/6096)
* Implemented Nvidia DevicePlugin GPU Support on AWS [@dcwangmit01](https://github.com/dcwangmit01) [#5502](https://github.com/kubernetes/kops/pull/5502)
* Setting the manifest directory when it is required by kubelet [@mmerrill3](https://github.com/mmerrill3) [#5939](https://github.com/kubernetes/kops/pull/5939)
* Update CoreDNS version to 1.2.6 [@rajansandeep](https://github.com/rajansandeep) [#6101](https://github.com/kubernetes/kops/pull/6101)
* Fix typos: dnsmaq -> dnsmasq, mutiple -> multiple [@SataQiu](https://github.com/SataQiu) [#6108](https://github.com/kubernetes/kops/pull/6108)
* Document how to create a custom addon [@thrawny](https://github.com/thrawny) [#6100](https://github.com/kubernetes/kops/pull/6100)
* [monitoring-standalone] Add kubernetes 1.7 version [@tuannvm](https://github.com/tuannvm) [#5902](https://github.com/kubernetes/kops/pull/5902)
* Cni ipvlan vpc k8s support [@polarbizzle](https://github.com/polarbizzle) [#4762](https://github.com/kubernetes/kops/pull/4762)
* Node Authorizer Recovery Middleware [@gambol99](https://github.com/gambol99) [#6105](https://github.com/kubernetes/kops/pull/6105)
* Fix log warning info [@gaozhenhai](https://github.com/gaozhenhai) [#6111](https://github.com/kubernetes/kops/pull/6111)
* Set a `dateformat` on logrotate configs on CoreOS [@ripta](https://github.com/ripta) [#6059](https://github.com/kubernetes/kops/pull/6059)
* Mention about possible state store vendors in error message [@nak3](https://github.com/nak3) [#6114](https://github.com/kubernetes/kops/pull/6114)
* kops set: support for enableEtcdTLS and enableTLSAuth [@justinsb](https://github.com/justinsb) [#6113](https://github.com/kubernetes/kops/pull/6113)
* feat(cmd/kops/create_cluster): default to kubelet.anonymousAuth false on k8s versions >=1.10 [@jaredallard](https://github.com/jaredallard) [#6091](https://github.com/kubernetes/kops/pull/6091)
* Create separate certificate for etcd peer authentication [@justinsb](https://github.com/justinsb) [#6112](https://github.com/kubernetes/kops/pull/6112)
* Set MaxPods when using Amazon VPC CNI Plugin [@sethpollack](https://github.com/sethpollack),[@ripta](https://github.com/ripta) [#6058](https://github.com/kubernetes/kops/pull/6058)
* Automated cherry pick of #6128: Update amazon cni to 1.3.0 [@mikesplain](https://github.com/mikesplain) [#6132](https://github.com/kubernetes/kops/pull/6132)
* Automated cherry pick of #6156: Fix Calico upgrade job to use the correct version [@tmjd](https://github.com/tmjd) [#6159](https://github.com/kubernetes/kops/pull/6159)
* Automated cherry pick of #6129: feat: bump controller version to 1.0.18 [@liranp](https://github.com/liranp) [#6143](https://github.com/kubernetes/kops/pull/6143)
* Automated cherry pick of #6175: Fix for when node and master use the same SG. [@rdrgmnzs](https://github.com/rdrgmnzs) [#6176](https://github.com/kubernetes/kops/pull/6176)
* Add a1 and c5n instance types [@justinsb](https://github.com/justinsb) [#6117](https://github.com/kubernetes/kops/pull/6117)
* Automated cherry pick of #6144: Workspace updates for bazel [@mikesplain](https://github.com/mikesplain) [#6220](https://github.com/kubernetes/kops/pull/6220)
* ExperimentalAllowedUnsafeSysctls has moved to AllowedUnsafeSysctls in k8s 1.11 [@rdrgmnzs](https://github.com/rdrgmnzs) [#6179](https://github.com/kubernetes/kops/pull/6179)
* Add GCE europe-north1-{a,b,c} [@eetujalonen](https://github.com/eetujalonen) [#6152](https://github.com/kubernetes/kops/pull/6152)
* Automated cherry pick of #6253: Add p3dn.24xlarge [@mikesplain](https://github.com/mikesplain) [#6254](https://github.com/kubernetes/kops/pull/6254)

## Changes from 1.11.0 to 1.11.1

* Don't panic when an etcd cluster is added [@justinsb](https://github.com/justinsb) [#6180](https://github.com/kubernetes/kops/pull/6180)
* Add Docker 18.06.1 for CentOS and RHEL 7 [@bcorijn](https://github.com/bcorijn) [#6202](https://github.com/kubernetes/kops/pull/6202)
* Update go version to 1.10.8 [@justinsb](https://github.com/justinsb) [#6401](https://github.com/kubernetes/kops/pull/6401)
* Normalize etcd cluster provider names [@justinsb](https://github.com/justinsb) [#6410](https://github.com/kubernetes/kops/pull/6410)
* Automated cherry pick of #6288: Recognize 2019 as a year [@justinsb](https://github.com/justinsb) [#6364](https://github.com/kubernetes/kops/pull/6364)
* Fix machine types and cleanup makefile [@mikesplain](https://github.com/mikesplain) [#6427](https://github.com/kubernetes/kops/pull/6427)
* Upgrade base image to alpine 3.8 and GO to 1.10.8 [@ricardo-larosa](https://github.com/ricardo-larosa) [#6458](https://github.com/kubernetes/kops/pull/6458)
* Support etcd-manager v3, suitable for backporting [@justinsb](https://github.com/justinsb) [#6411](https://github.com/kubernetes/kops/pull/6411)
* Choose docker version 18.06.2 for k8s >= 1.12 [@justinsb](https://github.com/justinsb) [#6488](https://github.com/kubernetes/kops/pull/6488)
* Workaround for overlay2 vs rhel-family docker bug [@justinsb](https://github.com/justinsb) [#6491](https://github.com/kubernetes/kops/pull/6491)
* Try using chattr to mark docker-runc as immutable [@justinsb](https://github.com/justinsb) [#6506](https://github.com/kubernetes/kops/pull/6506)
* include docker 18.06.1 missed dependency [@nareshku](https://github.com/nareshku) [#6338](https://github.com/kubernetes/kops/pull/6338)
* set net.ipv4.ip_local_reserved_ports to the KubeAPIServer ServiceNodePortRange parameter on nodeup [@sp-joseluis-ledesma](https://github.com/sp-joseluis-ledesma) [#6343](https://github.com/kubernetes/kops/pull/6343)
* Add jessie patch [@jjo](https://github.com/jjo) [#6461](https://github.com/kubernetes/kops/pull/6461)
* Bump etcd-manager version to 3.0.20190224 [@justinsb](https://github.com/justinsb) [#6526](https://github.com/kubernetes/kops/pull/6526)
* Make docker 18.06.3 the default for k8s >= 1.12 [@justinsb](https://github.com/justinsb) [#6524](https://github.com/kubernetes/kops/pull/6524)
* update-machine-types: more metal instance types [@justinsb](https://github.com/justinsb) [#6551](https://github.com/kubernetes/kops/pull/6551)
* Map docker 18.06.3 [@justinsb](https://github.com/justinsb) [#6523](https://github.com/kubernetes/kops/pull/6523)
* Sync up docker with master [@justinsb](https://github.com/justinsb) [#6559](https://github.com/kubernetes/kops/pull/6559)
* Update distroless [@justinsb](https://github.com/justinsb) [#6287](https://github.com/kubernetes/kops/pull/6287)
* Mark 1.11.1 [@justinsb](https://github.com/justinsb) [#6561](https://github.com/kubernetes/kops/pull/6561)
