
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops rolling-update cluster

Rolling update a cluster.

### Synopsis

This command updates a kubernetes cluster to match the cloud and kOps specifications.

To perform a rolling update, you need to update the cloud resources first with the command
`kops update cluster --yes`. Nodes may be additionally marked for update by placing a
`kops.k8s.io/needs-update` annotation on them.

If rolling-update does not report that the cluster needs to be updated, you can force the cluster to be
updated with the --force flag.  Rolling update drains and validates the cluster by default.  A cluster is
deemed validated when all required nodes are running and all pods with a critical priority are operational.

Note: terraform users will need to run all of the following commands from the same directory
`kops update cluster --target=terraform` then `terraform plan` then
`terraform apply` prior to running `kops rolling-update cluster`.

```
kops rolling-update cluster [CLUSTER] [flags]
```

### Examples

```
  # Preview a rolling update.
  kops rolling-update cluster
  
  # Update the currently selected kOps cluster with defaults.
  # Nodes will be drained and the cluster will be validated between node replacement.
  kops rolling-update cluster --yes
  
  # Update the k8s-cluster.example.com kOps cluster.
  # Do not fail if the cluster does not validate.
  kops rolling-update cluster k8s-cluster.example.com --yes \
  --fail-on-validate-error="false"
  
  # Update the k8s-cluster.example.com kOps cluster.
  # Do not validate the cluster.
  # Force the entire cluster to update, even if rolling update
  # reports that the cluster does not need to be updated.
  kops rolling-update cluster k8s-cluster.example.com --yes \
  --cloudonly \
  --force
  
  # Update only the "nodes-1a" instance group of the k8s-cluster.example.com kOps cluster.
  kops rolling-update cluster k8s-cluster.example.com --yes \
  --instance-group nodes-1a
```

### Options

```
      --bastion-interval duration      Time to wait between restarting bastions (default 15s)
      --cloudonly                      Perform rolling update without confirming progress with Kubernetes
      --drain-timeout duration         Maximum time to wait for a node to drain (default 15m0s)
      --fail-on-drain-error            Fail if draining a node fails (default true)
      --fail-on-validate-error         Fail if the cluster fails to validate (default true)
      --force                          Force rolling update, even if no changes
  -h, --help                           help for cluster
      --instance-group strings         Instance groups to update (defaults to all if not specified)
      --instance-group-roles strings   Instance group roles to update (master,apiserver,node,bastion)
  -i, --interactive                    Prompt to continue after each instance is updated
      --master-interval duration       Time to wait between restarting control plane nodes (default 15s)
      --node-interval duration         Time to wait between restarting worker nodes (default 15s)
      --post-drain-delay duration      Time to wait after draining each node (default 5s)
      --validate-count int32           Number of times that a cluster needs to be validated after single node update (default 2)
      --validation-timeout duration    Maximum time to wait for a cluster to validate (default 15m0s)
  -y, --yes                            Perform rolling update immediately; without --yes rolling-update executes a dry-run
```

### Options inherited from parent commands

```
      --add_dir_header                   If true, adds the file directory to the header of the log messages
      --alsologtostderr                  log to standard error as well as files (no effect when -logtostderr=true)
      --config string                    yaml config file (default is $HOME/.kops.yaml)
      --log_backtrace_at traceLocation   when logging hits line file:N, emit a stack trace (default :0)
      --log_dir string                   If non-empty, write log files in this directory (no effect when -logtostderr=true)
      --log_file string                  If non-empty, use this log file (no effect when -logtostderr=true)
      --log_file_max_size uint           Defines the maximum size a log file can grow to (no effect when -logtostderr=true). Unit is megabytes. If the value is 0, the maximum file size is unlimited. (default 1800)
      --logtostderr                      log to standard error instead of files (default true)
      --name string                      Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --one_output                       If true, only write logs to their native severity level (vs also writing to each lower severity level; no effect when -logtostderr=true)
      --skip_headers                     If true, avoid header prefixes in the log messages
      --skip_log_headers                 If true, avoid headers when opening log files (no effect when -logtostderr=true)
      --state string                     Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
      --stderrthreshold severity         logs at or above this threshold go to stderr when writing to files and stderr (no effect when -logtostderr=true or -alsologtostderr=false) (default 2)
  -v, --v Level                          number for the log level verbosity
      --vmodule moduleSpec               comma-separated list of pattern=N settings for file-filtered logging
```

### SEE ALSO

* [kops rolling-update](kops_rolling-update.md)	 - Rolling update a cluster.

