// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.17.3
// source: attest.proto

package attest

import (
	tpm "github.com/google/go-tpm-tools/proto/tpm"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of hardware technology used to protect this instance
type GCEConfidentialTechnology int32

const (
	GCEConfidentialTechnology_NONE       GCEConfidentialTechnology = 0
	GCEConfidentialTechnology_AMD_SEV    GCEConfidentialTechnology = 1
	GCEConfidentialTechnology_AMD_SEV_ES GCEConfidentialTechnology = 2
)

// Enum value maps for GCEConfidentialTechnology.
var (
	GCEConfidentialTechnology_name = map[int32]string{
		0: "NONE",
		1: "AMD_SEV",
		2: "AMD_SEV_ES",
	}
	GCEConfidentialTechnology_value = map[string]int32{
		"NONE":       0,
		"AMD_SEV":    1,
		"AMD_SEV_ES": 2,
	}
)

func (x GCEConfidentialTechnology) Enum() *GCEConfidentialTechnology {
	p := new(GCEConfidentialTechnology)
	*p = x
	return p
}

func (x GCEConfidentialTechnology) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GCEConfidentialTechnology) Descriptor() protoreflect.EnumDescriptor {
	return file_attest_proto_enumTypes[0].Descriptor()
}

func (GCEConfidentialTechnology) Type() protoreflect.EnumType {
	return &file_attest_proto_enumTypes[0]
}

func (x GCEConfidentialTechnology) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GCEConfidentialTechnology.Descriptor instead.
func (GCEConfidentialTechnology) EnumDescriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{0}
}

// Information uniquely identifying a GCE instance. Can be used to create an
// instance URL, which can then be used with GCE APIs. Formatted like:
//   https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone}/instances/{instance_name}
type GCEInstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Zone          string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	ProjectId     string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	ProjectNumber uint64 `protobuf:"varint,3,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	InstanceName  string `protobuf:"bytes,4,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	InstanceId    uint64 `protobuf:"varint,5,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
}

func (x *GCEInstanceInfo) Reset() {
	*x = GCEInstanceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GCEInstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GCEInstanceInfo) ProtoMessage() {}

func (x *GCEInstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GCEInstanceInfo.ProtoReflect.Descriptor instead.
func (*GCEInstanceInfo) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{0}
}

func (x *GCEInstanceInfo) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *GCEInstanceInfo) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GCEInstanceInfo) GetProjectNumber() uint64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *GCEInstanceInfo) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *GCEInstanceInfo) GetInstanceId() uint64 {
	if x != nil {
		return x.InstanceId
	}
	return 0
}

type Attestation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Attestation Key (AK) Public Area, encoded as a TPMT_PUBLIC
	AkPub []byte `protobuf:"bytes,1,opt,name=ak_pub,json=akPub,proto3" json:"ak_pub,omitempty"`
	// Quotes over all supported PCR banks
	Quotes []*tpm.Quote `protobuf:"bytes,2,rep,name=quotes,proto3" json:"quotes,omitempty"`
	// TCG Event Log, encoded in the raw binary format
	EventLog []byte `protobuf:"bytes,3,opt,name=event_log,json=eventLog,proto3" json:"event_log,omitempty"`
	// Optional information about a GCE instance, unused outside of GCE
	InstanceInfo *GCEInstanceInfo `protobuf:"bytes,4,opt,name=instance_info,json=instanceInfo,proto3" json:"instance_info,omitempty"`
}

func (x *Attestation) Reset() {
	*x = Attestation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Attestation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attestation) ProtoMessage() {}

func (x *Attestation) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attestation.ProtoReflect.Descriptor instead.
func (*Attestation) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{1}
}

func (x *Attestation) GetAkPub() []byte {
	if x != nil {
		return x.AkPub
	}
	return nil
}

func (x *Attestation) GetQuotes() []*tpm.Quote {
	if x != nil {
		return x.Quotes
	}
	return nil
}

func (x *Attestation) GetEventLog() []byte {
	if x != nil {
		return x.EventLog
	}
	return nil
}

func (x *Attestation) GetInstanceInfo() *GCEInstanceInfo {
	if x != nil {
		return x.InstanceInfo
	}
	return nil
}

// The platform/firmware state for this instance
type PlatformState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Firmware:
	//	*PlatformState_ScrtmVersionId
	//	*PlatformState_GceVersion
	Firmware isPlatformState_Firmware `protobuf_oneof:"firmware"`
	// Set to NONE on non-GCE instances or non-Confidential Shielded GCE instances
	Technology GCEConfidentialTechnology `protobuf:"varint,3,opt,name=technology,proto3,enum=attest.GCEConfidentialTechnology" json:"technology,omitempty"`
	// Only set for GCE instances
	InstanceInfo *GCEInstanceInfo `protobuf:"bytes,4,opt,name=instance_info,json=instanceInfo,proto3" json:"instance_info,omitempty"`
}

func (x *PlatformState) Reset() {
	*x = PlatformState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformState) ProtoMessage() {}

func (x *PlatformState) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformState.ProtoReflect.Descriptor instead.
func (*PlatformState) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{2}
}

func (m *PlatformState) GetFirmware() isPlatformState_Firmware {
	if m != nil {
		return m.Firmware
	}
	return nil
}

func (x *PlatformState) GetScrtmVersionId() []byte {
	if x, ok := x.GetFirmware().(*PlatformState_ScrtmVersionId); ok {
		return x.ScrtmVersionId
	}
	return nil
}

func (x *PlatformState) GetGceVersion() uint32 {
	if x, ok := x.GetFirmware().(*PlatformState_GceVersion); ok {
		return x.GceVersion
	}
	return 0
}

func (x *PlatformState) GetTechnology() GCEConfidentialTechnology {
	if x != nil {
		return x.Technology
	}
	return GCEConfidentialTechnology_NONE
}

func (x *PlatformState) GetInstanceInfo() *GCEInstanceInfo {
	if x != nil {
		return x.InstanceInfo
	}
	return nil
}

type isPlatformState_Firmware interface {
	isPlatformState_Firmware()
}

type PlatformState_ScrtmVersionId struct {
	// Raw S-CRTM version identifier (EV_S_CRTM_VERSION)
	ScrtmVersionId []byte `protobuf:"bytes,1,opt,name=scrtm_version_id,json=scrtmVersionId,proto3,oneof"`
}

type PlatformState_GceVersion struct {
	// Virtual GCE firmware version (parsed from S-CRTM version id)
	GceVersion uint32 `protobuf:"varint,2,opt,name=gce_version,json=gceVersion,proto3,oneof"`
}

func (*PlatformState_ScrtmVersionId) isPlatformState_Firmware() {}

func (*PlatformState_GceVersion) isPlatformState_Firmware() {}

// A parsed event from the TCG event log
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Platform Control Register (PCR) this event was extended into.
	PcrIndex uint32 `protobuf:"varint,1,opt,name=pcr_index,json=pcrIndex,proto3" json:"pcr_index,omitempty"`
	// The type of this event. Note that this value is not verified, so it should
	// only be used as a hint during event parsing.
	UntrustedType uint32 `protobuf:"varint,2,opt,name=untrusted_type,json=untrustedType,proto3" json:"untrusted_type,omitempty"`
	// The raw data associated to this event. The meaning of this data is
	// specific to the type of the event.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// The event digest actually extended into the TPM. This is often the hash of
	// the data field, but in some cases it may have a type-specific calculation.
	Digest []byte `protobuf:"bytes,4,opt,name=digest,proto3" json:"digest,omitempty"`
	// This is true if hash(data) == digest.
	DigestVerified bool `protobuf:"varint,5,opt,name=digest_verified,json=digestVerified,proto3" json:"digest_verified,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{3}
}

func (x *Event) GetPcrIndex() uint32 {
	if x != nil {
		return x.PcrIndex
	}
	return 0
}

func (x *Event) GetUntrustedType() uint32 {
	if x != nil {
		return x.UntrustedType
	}
	return 0
}

func (x *Event) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Event) GetDigest() []byte {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *Event) GetDigestVerified() bool {
	if x != nil {
		return x.DigestVerified
	}
	return false
}

// The verified state of a booted machine, obtained from an Attestation
type MachineState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Platform *PlatformState `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
	// The complete parsed TCG Event Log, including those events used to
	// create the PlatformState.
	RawEvents []*Event `protobuf:"bytes,3,rep,name=raw_events,json=rawEvents,proto3" json:"raw_events,omitempty"`
	// The hash algorithm used when verifying the Attestation. This indicates:
	//   - which PCR bank was used for for quote validation and event log replay
	//   - the hash algorithm used to calculate event digests
	Hash tpm.HashAlgo `protobuf:"varint,4,opt,name=hash,proto3,enum=tpm.HashAlgo" json:"hash,omitempty"`
}

func (x *MachineState) Reset() {
	*x = MachineState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineState) ProtoMessage() {}

func (x *MachineState) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineState.ProtoReflect.Descriptor instead.
func (*MachineState) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{4}
}

func (x *MachineState) GetPlatform() *PlatformState {
	if x != nil {
		return x.Platform
	}
	return nil
}

func (x *MachineState) GetRawEvents() []*Event {
	if x != nil {
		return x.RawEvents
	}
	return nil
}

func (x *MachineState) GetHash() tpm.HashAlgo {
	if x != nil {
		return x.Hash
	}
	return tpm.HashAlgo(0)
}

// A policy dictating which values of PlatformState to allow
type PlatformPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If PlatformState.firmware contains a scrtm_version_id, it must appear
	// in this list. For use with a GCE VM, minimum_gce_firmware_version is
	// often a better alternative.
	AllowedScrtmVersionIds [][]byte `protobuf:"bytes,1,rep,name=allowed_scrtm_version_ids,json=allowedScrtmVersionIds,proto3" json:"allowed_scrtm_version_ids,omitempty"`
	// If PlatformState.firmware contains a minimum_gce_firmware_version, it must
	// be greater than or equal to this value. Currently, the max version is 1.
	MinimumGceFirmwareVersion uint32 `protobuf:"varint,2,opt,name=minimum_gce_firmware_version,json=minimumGceFirmwareVersion,proto3" json:"minimum_gce_firmware_version,omitempty"`
	// The PlatformState's technology must be at least as secure as
	// the specified minimum_technology (i.e. AMD_SEV_ES > AMD_SEV > NONE).
	MinimumTechnology GCEConfidentialTechnology `protobuf:"varint,3,opt,name=minimum_technology,json=minimumTechnology,proto3,enum=attest.GCEConfidentialTechnology" json:"minimum_technology,omitempty"`
}

func (x *PlatformPolicy) Reset() {
	*x = PlatformPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformPolicy) ProtoMessage() {}

func (x *PlatformPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformPolicy.ProtoReflect.Descriptor instead.
func (*PlatformPolicy) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{5}
}

func (x *PlatformPolicy) GetAllowedScrtmVersionIds() [][]byte {
	if x != nil {
		return x.AllowedScrtmVersionIds
	}
	return nil
}

func (x *PlatformPolicy) GetMinimumGceFirmwareVersion() uint32 {
	if x != nil {
		return x.MinimumGceFirmwareVersion
	}
	return 0
}

func (x *PlatformPolicy) GetMinimumTechnology() GCEConfidentialTechnology {
	if x != nil {
		return x.MinimumTechnology
	}
	return GCEConfidentialTechnology_NONE
}

// A policy dictating which type of MachineStates to allow
type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Platform *PlatformPolicy `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_attest_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_attest_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_attest_proto_rawDescGZIP(), []int{6}
}

func (x *Policy) GetPlatform() *PlatformPolicy {
	if x != nil {
		return x.Platform
	}
	return nil
}

var File_attest_proto protoreflect.FileDescriptor

var file_attest_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06,
	0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x1a, 0x09, 0x74, 0x70, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xb1, 0x01, 0x0a, 0x0f, 0x47, 0x43, 0x45, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x64, 0x22, 0xa3, 0x01, 0x0a, 0x0b, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x06, 0x61, 0x6b, 0x5f, 0x70, 0x75, 0x62, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x61, 0x6b, 0x50, 0x75, 0x62, 0x12, 0x22, 0x0a, 0x06,
	0x71, 0x75, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x74,
	0x70, 0x6d, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x52, 0x06, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x08, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x12, 0x3c, 0x0a,
	0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x43,
	0x45, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xeb, 0x01, 0x0a, 0x0d,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a,
	0x10, 0x73, 0x63, 0x72, 0x74, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x63, 0x72, 0x74, 0x6d,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0b, 0x67, 0x63, 0x65,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00,
	0x52, 0x0a, 0x67, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x0a,
	0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x21, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x43, 0x45, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c,
	0x6f, 0x67, 0x79, 0x52, 0x0a, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12,
	0x3c, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e,
	0x47, 0x43, 0x45, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x0a, 0x0a,
	0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x05, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x63, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x63, 0x72, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x25, 0x0a, 0x0e, 0x75, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x75, 0x6e, 0x74, 0x72, 0x75, 0x73,
	0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x22, 0x92, 0x01, 0x0a,
	0x0c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x31, 0x0a,
	0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x12, 0x2c, 0x0a, 0x0a, 0x72, 0x61, 0x77, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x09, 0x72, 0x61, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x21,
	0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0d, 0x2e, 0x74,
	0x70, 0x6d, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x52, 0x04, 0x68, 0x61, 0x73,
	0x68, 0x22, 0xde, 0x01, 0x0a, 0x0e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x39, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x73, 0x63, 0x72, 0x74, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x53, 0x63, 0x72, 0x74, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12,
	0x3f, 0x0a, 0x1c, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x67, 0x63, 0x65, 0x5f, 0x66,
	0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x19, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x47, 0x63,
	0x65, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x50, 0x0a, 0x12, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x74, 0x65, 0x63, 0x68,
	0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x61,
	0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x43, 0x45, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52,
	0x11, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f,
	0x67, 0x79, 0x22, 0x3c, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x32, 0x0a, 0x08,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2a, 0x42, 0x0a, 0x19, 0x47, 0x43, 0x45, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x08, 0x0a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x4d, 0x44, 0x5f, 0x53,
	0x45, 0x56, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4d, 0x44, 0x5f, 0x53, 0x45, 0x56, 0x5f,
	0x45, 0x53, 0x10, 0x02, 0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x6f, 0x2d, 0x74, 0x70, 0x6d,
	0x2d, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x61, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_attest_proto_rawDescOnce sync.Once
	file_attest_proto_rawDescData = file_attest_proto_rawDesc
)

func file_attest_proto_rawDescGZIP() []byte {
	file_attest_proto_rawDescOnce.Do(func() {
		file_attest_proto_rawDescData = protoimpl.X.CompressGZIP(file_attest_proto_rawDescData)
	})
	return file_attest_proto_rawDescData
}

var file_attest_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_attest_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_attest_proto_goTypes = []interface{}{
	(GCEConfidentialTechnology)(0), // 0: attest.GCEConfidentialTechnology
	(*GCEInstanceInfo)(nil),        // 1: attest.GCEInstanceInfo
	(*Attestation)(nil),            // 2: attest.Attestation
	(*PlatformState)(nil),          // 3: attest.PlatformState
	(*Event)(nil),                  // 4: attest.Event
	(*MachineState)(nil),           // 5: attest.MachineState
	(*PlatformPolicy)(nil),         // 6: attest.PlatformPolicy
	(*Policy)(nil),                 // 7: attest.Policy
	(*tpm.Quote)(nil),              // 8: tpm.Quote
	(tpm.HashAlgo)(0),              // 9: tpm.HashAlgo
}
var file_attest_proto_depIdxs = []int32{
	8, // 0: attest.Attestation.quotes:type_name -> tpm.Quote
	1, // 1: attest.Attestation.instance_info:type_name -> attest.GCEInstanceInfo
	0, // 2: attest.PlatformState.technology:type_name -> attest.GCEConfidentialTechnology
	1, // 3: attest.PlatformState.instance_info:type_name -> attest.GCEInstanceInfo
	3, // 4: attest.MachineState.platform:type_name -> attest.PlatformState
	4, // 5: attest.MachineState.raw_events:type_name -> attest.Event
	9, // 6: attest.MachineState.hash:type_name -> tpm.HashAlgo
	0, // 7: attest.PlatformPolicy.minimum_technology:type_name -> attest.GCEConfidentialTechnology
	6, // 8: attest.Policy.platform:type_name -> attest.PlatformPolicy
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_attest_proto_init() }
func file_attest_proto_init() {
	if File_attest_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_attest_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GCEInstanceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Attestation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_attest_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_attest_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*PlatformState_ScrtmVersionId)(nil),
		(*PlatformState_GceVersion)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_attest_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_attest_proto_goTypes,
		DependencyIndexes: file_attest_proto_depIdxs,
		EnumInfos:         file_attest_proto_enumTypes,
		MessageInfos:      file_attest_proto_msgTypes,
	}.Build()
	File_attest_proto = out.File
	file_attest_proto_rawDesc = nil
	file_attest_proto_goTypes = nil
	file_attest_proto_depIdxs = nil
}
