## Release notes for kOps 1.22 series

**&#9888; kOps 1.22 has not been released yet! &#9888;**

This is a document to gather the release notes prior to the release.

# Significant changes

## Instance metadata service version 2

 On AWS, kOps will enable [Instance Metadata Service Version 2](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html) and require tokens on new clusters with Kubernetes 1.22. In addition, the following max hop limits will be set by default:

 * worker and API server Nodes, and bastions, will have a limit of 1 hop.
 * control plane nodes will have a limit of 3 hops to accommodate for controller Pods without host networking that need to assume roles.

This will increase security by default, but may break some types of workloads. In order to revert to old behavior, add the following to the InstanceGroup:

```
spec:
  instanceMetadata:
    httpTokens: optional
```

## External ServiceAccountPermissions

Many of kOps addons can now make direct use of external permissions.
This can be enabled by adding the following to the Cluster spec:

```
spec:
  iam:
    useServiceAcountExternalPermissions: true
```

Currently this is only available using the AWS cloud provider.

## Managed nvidia instances

kOps can now provision instances with nvidia GPUs and configure it for container workloads without the need of hooks and operators. See [GPU support](https://kops.sigs.k8s.io/gpu/)

## Other significant changes

* New clusters on AWS will no longer provision an SSH public key by default. To provision
  an SSH public key on a new cluster, use the `--ssh-public-key` flag to `kops create cluster`.

* The kOps Terraform support now renders managed files through the Terraform configuration instead 
  of writing them to S3 directly. This defers changes to these files until the time of `terraform apply`.
  This feature may be temporarily disabled by turning off the `TerraformManagedFiles` feature flag
  using `export KOPS_FEATURE_FLAGS="-TerraformManagedFiles"`.

* kOps now implements graceful rotation of its Certificate Authorities and the service
  account signing key. See the documentation on [How to rotate all secrets / credentials](../operations/rotate-secrets.md)

* New clusters running Kubernetes 1.22 will have AWS EBS CSI driver enabled by default.

* kOps now supports Debian 11 (Bullseye).

# Breaking changes

* Support for Kubernetes versions 1.15 and 1.16 has been removed.

* The legacy addons from `https://github.com/kubernetes/kops/tree/master/addons` have been deprecated and will not be available in Kubernetes 1.23+. Use [managed addons](https://kops.sigs.k8s.io/addons) instead.

* The legacy location for downloads `s3://https://kubeupv2.s3.amazonaws.com/kops/` has been deprecated and will not be used for new releases. The new canonical downloads location is `https://artifacts.k8s.io/binaries/kops/`.

* The `assets` phase of `kops update cluster` has been removed. It is replaced by the new `kops get assets --copy` command.

* Support for importing and converting kubeup clusters has been removed.

# Required actions

* Terraform support now requires Terraform >=0.15.0.
  Users on older versions must follow Terraform's recommended upgrade path of applying one minor version at a time prior to running `kops update cluster --target terraform`.

* The kOps Terraform support now renders managed files through the Terraform configuration instead 
  of writing them to S3 directly. If, after upgrading kOps and applying a new Terraform plan,
  you subsequently downgrade to an earlier version of kOps, the generated plan will delete these
  files, breaking the cluster. Prior to applying the plan, you will need to orphan all the
  `aws_s3_bucket_object` objects the plan wants to destroy. Use `terraform state rm` on each of them.
  Then re-run `terraform plan` until there are no such objects in the plan.
  
  If you applied the plan without first orphaning all of these objects, fix the cluster by re-running
  `kops update cluster --target terraform`.

* Terraform users of clusters with names beginning with digits will need to move resources prior to upgrading to kOps 1.22. Some of the following commands will need to be run depending on the particular cluster configuration. Confirm the Terraform plan doesn't destroy any of these resources before running `terraform apply`.
  ```bash
  # View the existing terraform resource names for the exact value to use
  HYPHENATED_CLUSTER_NAME=123-cluster-example-com
  terraform state mv "aws_iam_openid_connect_provider.${HYPHENATED_CLUSTER_NAME}" "aws_iam_openid_connect_provider.prefix_${HYPHENATED_CLUSTER_NAME}"
  terraform state mv "aws_internet_gateway.${HYPHENATED_CLUSTER_NAME}" "aws_internet_gateway.prefix_${HYPHENATED_CLUSTER_NAME}"
  terraform state mv "aws_route_table.${HYPHENATED_CLUSTER_NAME}" "aws_route_table.prefix_${HYPHENATED_CLUSTER_NAME}"
  terraform state mv "aws_vpc.${HYPHENATED_CLUSTER_NAME}" "aws_vpc.prefix_${HYPHENATED_CLUSTER_NAME}"
  terraform state mv "aws_vpc_dhcp_options.${HYPHENATED_CLUSTER_NAME}" "aws_vpc_dhcp_options.prefix_${HYPHENATED_CLUSTER_NAME}"
  terraform state mv "aws_vpc_dhcp_options_association.${HYPHENATED_CLUSTER_NAME}" "aws_vpc_dhcp_options_association.prefix_${HYPHENATED_CLUSTER_NAME}"
  ```

# Deprecations

* Support for Kubernetes version 1.17 is deprecated and will be removed in kOps 1.23.

* Support for Kubernetes version 1.18 is deprecated and will be removed in kOps 1.24.

* Support for the Lyft CNI is deprecated and will be removed in kOps 1.23.

* Support for CentOS 7 is deprecated and will be removed in future versions of kOps.

* Support for CentOS 8 is deprecated and will be removed in future versions of kOps.

* Support for Debian 9 (Stretch) is deprecated and will be removed in future versions of kOps.

* Support for RHEL 7 is deprecated and will be removed in future versions of kOps.

* Support for Ubuntu 18.04 (Bionic) is deprecated and will be removed in future versions of kOps.

* All legacy addons are deprecated in favor of managed addons, including the [metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) and the [autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler).

* The `node-role.kubernetes.io/master` and `kubernetes.io/role` labels are deprecated and might be removed from control plane nodes in kOps 1.23.

* The `TerraformJSON` feature flag is deprecated and will be removed in kOps 1.23. Only native HCL2 Terraform output will be supported.

* Due to lack of maintainers, the Aliyun/Alibaba Cloud support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this cloud provider.

* Due to lack of maintainers, the CloudFormation support has been deprecated. The current implementation will be left as-is until the implementation needs updates or otherwise becomes incompatible. At that point, it will be removed. We very much welcome anyone willing to contribute to this target.

# Other changes of note

* Support for shell completion has been substantially improved. kOps has added support for shell completion in `fish` and `PowerShell`.

* It is no longer necessary to set `AWS_SDK_LOAD_CONFIG=1` in the environment when using AWS assumed roles with the `kops` CLI.

* There is a new command `kops get assets` for listing image and file assets used by a cluster.
  It also includes a `--copy` flag to copy the assets to local repositories.
  See the documentation on [Using local asset repositories](../operations/asset-repository.md) for more information.
  
* kOps now provisions TLS server certificates signed by the Kubernetes general CA to kube-controller-manager and kube-scheduler.
  The previous behavior of using self-signed certs may be restored by setting `kubeControllerManager.tlsCertFile` and/or
  `kubeScheduler.tlsCertFile` to `""` in the cluster spec.

* Cilium now supports the wireguard protocol for transparent encryption.

# Full change list since 1.21.0 release

## 1.22.0-alpha.1 to 1.22.0-alpha.2

* e2e upgrade-ab: fix a few errors [@justinsb](https://github.com/justinsb) [#11409](https://github.com/kubernetes/kops/pull/11409)
* Verify all versions are set correctly [@johngmyers](https://github.com/johngmyers) [#11413](https://github.com/kubernetes/kops/pull/11413)
* Use etcd-manager built from etcdadm repo [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#11098](https://github.com/kubernetes/kops/pull/11098)
* Remove code for no-longer-supported k8s versions  [@johngmyers](https://github.com/johngmyers) [#11412](https://github.com/kubernetes/kops/pull/11412)
* Update the release process documentation [@johngmyers](https://github.com/johngmyers) [#11419](https://github.com/kubernetes/kops/pull/11419)
* [addons/awscsidriver] Bump to GA release [@dntosas](https://github.com/dntosas) [#11418](https://github.com/kubernetes/kops/pull/11418)
* [Digital Ocean] Add an e2e job for DO [@srikiz](https://github.com/srikiz) [#10963](https://github.com/kubernetes/kops/pull/10963)
* Fix references to v1.20 in v1.21 release notes [@hakman](https://github.com/hakman) [#11427](https://github.com/kubernetes/kops/pull/11427)
* Release notes for 1.21.0-beta.1 [@johngmyers](https://github.com/johngmyers) [#11426](https://github.com/kubernetes/kops/pull/11426)
* e2e: only get ExternalIPRange if we need it [@justinsb](https://github.com/justinsb) [#11431](https://github.com/kubernetes/kops/pull/11431)
* e2e upgrade-ab: a few more fixes and notes on how to run locally [@justinsb](https://github.com/justinsb) [#11432](https://github.com/kubernetes/kops/pull/11432)
* Create new clusters without forcing a container runtime [@hakman](https://github.com/hakman) [#11428](https://github.com/kubernetes/kops/pull/11428)
* Update verify-terraform to use 0.15.3 [@rifelpet](https://github.com/rifelpet) [#11433](https://github.com/kubernetes/kops/pull/11433)
* Carry forward 1.20 deprecations to 1.21 release notes [@johngmyers](https://github.com/johngmyers) [#11438](https://github.com/kubernetes/kops/pull/11438)
* Start release notes for 1.22 [@johngmyers](https://github.com/johngmyers) [#11439](https://github.com/kubernetes/kops/pull/11439)
* Sort --extra-tags of ebs-csi-driver [@codablock](https://github.com/codablock) [#11444](https://github.com/kubernetes/kops/pull/11444)
* Fix typo in 1.22 release notes [@johngmyers](https://github.com/johngmyers) [#11448](https://github.com/kubernetes/kops/pull/11448)
* Add test scenario for aws ebs csi driver [@olemarkus](https://github.com/olemarkus) [#11449](https://github.com/kubernetes/kops/pull/11449)
* Always install the latest plugin versions for Terraform tests [@hakman](https://github.com/hakman) [#11447](https://github.com/kubernetes/kops/pull/11447)
* Set the output base for fitask [@hakman](https://github.com/hakman) [#11411](https://github.com/kubernetes/kops/pull/11411)
* Simplify buildLaunchTemplateTask() part one [@johngmyers](https://github.com/johngmyers) [#11452](https://github.com/kubernetes/kops/pull/11452)
* Add missing carryover items from 1.21 release notes [@johngmyers](https://github.com/johngmyers) [#11451](https://github.com/kubernetes/kops/pull/11451)
* Add support for CAS 1.21.0 [@olemarkus](https://github.com/olemarkus) [#11462](https://github.com/kubernetes/kops/pull/11462)
* Allow AWS instance types with multiple architectures [@hakman](https://github.com/hakman) [#11463](https://github.com/kubernetes/kops/pull/11463)
* Fix KCM livenessProbe to use secure port [@rifelpet](https://github.com/rifelpet) [#11454](https://github.com/kubernetes/kops/pull/11454)
* Simplify buildLaunchTemplateTask() part two [@johngmyers](https://github.com/johngmyers) [#11461](https://github.com/kubernetes/kops/pull/11461)
* Use kubernetes.default for OIDC discovery in gossip clusters [@rifelpet](https://github.com/rifelpet) [#11470](https://github.com/kubernetes/kops/pull/11470)
* Add instructions for updating the k8s versions periodic jobs [@rifelpet](https://github.com/rifelpet) [#11473](https://github.com/kubernetes/kops/pull/11473)
* Release notes for 1.20.1 [@justinsb](https://github.com/justinsb) [#11475](https://github.com/kubernetes/kops/pull/11475)
* Release notes for 1.19.3 [@justinsb](https://github.com/justinsb) [#11474](https://github.com/kubernetes/kops/pull/11474)
* Update alpha channel with K8s releases from May-12 2021 [@MoShitrit](https://github.com/MoShitrit) [#11476](https://github.com/kubernetes/kops/pull/11476)
* upup: gcetasks: fix diffs in instance template and router [@nicktrav](https://github.com/nicktrav) [#11460](https://github.com/kubernetes/kops/pull/11460)
* Discover what zone the cluster is in for the aws-ebs-csi driver tests [@olemarkus](https://github.com/olemarkus) [#11472](https://github.com/kubernetes/kops/pull/11472)
* Use ginkgo to run the tests so we can run things in parallel [@olemarkus](https://github.com/olemarkus) [#11479](https://github.com/kubernetes/kops/pull/11479)
* Kubetest2 - Increase validation time for DO jobs [@rifelpet](https://github.com/rifelpet) [#11481](https://github.com/kubernetes/kops/pull/11481)
* upup: gcetasks: force send AutoCreateSubnetworks field when set to false [@nicktrav](https://github.com/nicktrav) [#11457](https://github.com/kubernetes/kops/pull/11457)
* Add kOps and k8s 1.21 to alpha channel [@MoShitrit](https://github.com/MoShitrit) [#11482](https://github.com/kubernetes/kops/pull/11482)
* Reduce kOps supported version range [@johngmyers](https://github.com/johngmyers) [#11485](https://github.com/kubernetes/kops/pull/11485)
* More release process documentation improvements [@johngmyers](https://github.com/johngmyers) [#11434](https://github.com/kubernetes/kops/pull/11434)
* Set the test cluster-tag [@olemarkus](https://github.com/olemarkus) [#11487](https://github.com/kubernetes/kops/pull/11487)
* Set canonical location for downloads to artifacts.k8s.io [@hakman](https://github.com/hakman) [#11486](https://github.com/kubernetes/kops/pull/11486)
* [AWS CCM] Permission to create SA token [@nckturner](https://github.com/nckturner) [#11368](https://github.com/kubernetes/kops/pull/11368)
* Add link to release notes on first beta release [@johngmyers](https://github.com/johngmyers) [#11488](https://github.com/kubernetes/kops/pull/11488)
* Remove etcd-manager certificate expiration advisory [@hakman](https://github.com/hakman) [#11480](https://github.com/kubernetes/kops/pull/11480)
* Adjust deprecation announcements [@johngmyers](https://github.com/johngmyers) [#11489](https://github.com/kubernetes/kops/pull/11489)
* Update cert-manager [@olemarkus](https://github.com/olemarkus) [#11493](https://github.com/kubernetes/kops/pull/11493)
* Set priorityClassName on critical addons [@olemarkus](https://github.com/olemarkus) [#11495](https://github.com/kubernetes/kops/pull/11495)
* fix(coredns/rbac): add permission to list and watch endpointslices [@nettoclaudio](https://github.com/nettoclaudio) [#11459](https://github.com/kubernetes/kops/pull/11459)
* bump aws lb controller to 2.2.0 [@olemarkus](https://github.com/olemarkus) [#11502](https://github.com/kubernetes/kops/pull/11502)
* Aws lb scenario fix flags [@olemarkus](https://github.com/olemarkus) [#11506](https://github.com/kubernetes/kops/pull/11506)
* AWS LB controller requires multiple subnets to work [@olemarkus](https://github.com/olemarkus) [#11507](https://github.com/kubernetes/kops/pull/11507)
* Cleanup some of the scenario scripts [@rifelpet](https://github.com/rifelpet) [#11508](https://github.com/kubernetes/kops/pull/11508)
* Include new pipeline job in the release branch process [@rifelpet](https://github.com/rifelpet) [#11509](https://github.com/kubernetes/kops/pull/11509)
* Spotinst: Update spotinst/ocean-controller to v1.0.75 [@liranp](https://github.com/liranp) [#11512](https://github.com/kubernetes/kops/pull/11512)
* Subsume StatusStore into fi.Cloud [@johngmyers](https://github.com/johngmyers) [#11498](https://github.com/kubernetes/kops/pull/11498)
* Split genkgo in two [@olemarkus](https://github.com/olemarkus) [#11519](https://github.com/kubernetes/kops/pull/11519)
* [DigitalOcean] [WIP] Increase droplet size for e2e tests [@srikiz](https://github.com/srikiz) [#11520](https://github.com/kubernetes/kops/pull/11520)
* Add initial support for configuring IPv6 with AWS [@hakman](https://github.com/hakman) [#11442](https://github.com/kubernetes/kops/pull/11442)
* Add default tags to LB controller and cilium eni resources [@olemarkus](https://github.com/olemarkus) [#11517](https://github.com/kubernetes/kops/pull/11517)
* Remove dead code in bootstrap script [@johngmyers](https://github.com/johngmyers) [#11521](https://github.com/kubernetes/kops/pull/11521)
* Set default fstype for ebs volumes to ext4 [@olemarkus](https://github.com/olemarkus) [#11525](https://github.com/kubernetes/kops/pull/11525)
* Skip feature tests for ebs csi e2e [@olemarkus](https://github.com/olemarkus) [#11530](https://github.com/kubernetes/kops/pull/11530)
* Update etcd_backup_restore_encryption.md [@aberenshtein](https://github.com/aberenshtein) [#11533](https://github.com/kubernetes/kops/pull/11533)
* Don't download nodeup if already in the AMI [@johngmyers](https://github.com/johngmyers) [#11524](https://github.com/kubernetes/kops/pull/11524)
* [addons/networking.cilium.io] enable prometheus scraping [@ulfox](https://github.com/ulfox) [#11514](https://github.com/kubernetes/kops/pull/11514)
* feat(openstack): enable configuration of servergroup affinities [@mitch000001](https://github.com/mitch000001) [#11531](https://github.com/kubernetes/kops/pull/11531)
* Update containerd to v1.4.6 [@hakman](https://github.com/hakman) [#11535](https://github.com/kubernetes/kops/pull/11535)
* Cleanup orphaned IAM service account roles in direct render [@johngmyers](https://github.com/johngmyers) [#11497](https://github.com/kubernetes/kops/pull/11497)
* Support terraform 0.12+'s filebase64() in json output [@rifelpet](https://github.com/rifelpet) [#11540](https://github.com/kubernetes/kops/pull/11540)
* Release images bundle instead of separate images [@hakman](https://github.com/hakman) [#11522](https://github.com/kubernetes/kops/pull/11522)
* Bump CoreDNS manifests to latest stable version 1.8.3 [@dntosas](https://github.com/dntosas) [#11500](https://github.com/kubernetes/kops/pull/11500)
* Run the tests requiring snapshotcontroller again [@olemarkus](https://github.com/olemarkus) [#11544](https://github.com/kubernetes/kops/pull/11544)
* Update CAS manifest [@olemarkus](https://github.com/olemarkus) [#11491](https://github.com/kubernetes/kops/pull/11491)
* Make events etcd cluster optional [@codablock](https://github.com/codablock) [#11330](https://github.com/kubernetes/kops/pull/11330)
* Add support for arbitrary terraform functions [@rifelpet](https://github.com/rifelpet) [#11542](https://github.com/kubernetes/kops/pull/11542)
* Add snapshot-controller [@olemarkus](https://github.com/olemarkus) [#10730](https://github.com/kubernetes/kops/pull/10730)
* Add etcd-server related tests [@hakman](https://github.com/hakman) [#11552](https://github.com/kubernetes/kops/pull/11552)
* Bump default cilium to 1.9.7 [@olemarkus](https://github.com/olemarkus) [#11554](https://github.com/kubernetes/kops/pull/11554)
* Document updating conformance is first stable minor release only [@johngmyers](https://github.com/johngmyers) [#11556](https://github.com/kubernetes/kops/pull/11556)
* Add hubble documentation [@olemarkus](https://github.com/olemarkus) [#11557](https://github.com/kubernetes/kops/pull/11557)
* Allow using insecure TLS for metrics-server with Kubernetes 1.19+ [@hakman](https://github.com/hakman) [#11559](https://github.com/kubernetes/kops/pull/11559)
* Add snapshot-controller [@olemarkus](https://github.com/olemarkus) [#11561](https://github.com/kubernetes/kops/pull/11561)
* Fix deletion of IAM roles and policies [@johngmyers](https://github.com/johngmyers) [#11558](https://github.com/kubernetes/kops/pull/11558)
* Allow Spotinst to use comma separated instance types [@hakman](https://github.com/hakman) [#11560](https://github.com/kubernetes/kops/pull/11560)
* Release notes for 1.21.0-beta.2 [@johngmyers](https://github.com/johngmyers) [#11570](https://github.com/kubernetes/kops/pull/11570)
* Set flags on AWS CCM mimicking KCM [@olemarkus](https://github.com/olemarkus) [#11566](https://github.com/kubernetes/kops/pull/11566)
* Enable cert-manager in the ebs csi e2e test [@olemarkus](https://github.com/olemarkus) [#11569](https://github.com/kubernetes/kops/pull/11569)
* Only allow deletion of snapshots owned by the cluster [@olemarkus](https://github.com/olemarkus) [#11571](https://github.com/kubernetes/kops/pull/11571)
* Avoid error when first creating VPC with IPv6 [@justinsb](https://github.com/justinsb) [#11575](https://github.com/kubernetes/kops/pull/11575)
* Improve some small issues with the release process [@hakman](https://github.com/hakman) [#11572](https://github.com/kubernetes/kops/pull/11572)
* Cleanup InstanceProfile only that have ownership tags in delete cluster [@h3poteto](https://github.com/h3poteto) [#11568](https://github.com/kubernetes/kops/pull/11568)
* Don't set the master address for aws ccm [@olemarkus](https://github.com/olemarkus) [#11582](https://github.com/kubernetes/kops/pull/11582)
* Enable reading shared config when possibly from CLI [@johngmyers](https://github.com/johngmyers) [#11387](https://github.com/kubernetes/kops/pull/11387)
* Only update kubeconfig user when we have user info [@justinsb](https://github.com/justinsb) [#11584](https://github.com/kubernetes/kops/pull/11584)
* Add release note for AWS shared config [@johngmyers](https://github.com/johngmyers) [#11585](https://github.com/kubernetes/kops/pull/11585)
* Use latest CI build instead of building in the test [@olemarkus](https://github.com/olemarkus) [#11588](https://github.com/kubernetes/kops/pull/11588)
* Remove unused files [@johngmyers](https://github.com/johngmyers) [#11591](https://github.com/kubernetes/kops/pull/11591)
* Use the downloaded kops version for awslbc test [@olemarkus](https://github.com/olemarkus) [#11593](https://github.com/kubernetes/kops/pull/11593)
* Use the OnDelete updateStrategy for AWS VPC CNI DaemonSet [@johngmyers](https://github.com/johngmyers) [#11590](https://github.com/kubernetes/kops/pull/11590)
* Update Calico to v3.19.1 [@hakman](https://github.com/hakman) [#11594](https://github.com/kubernetes/kops/pull/11594)
* Cleanup Docs [@hakman](https://github.com/hakman) [#11595](https://github.com/kubernetes/kops/pull/11595)
* First addon operator integration: CoreDNS [@justinsb](https://github.com/justinsb) [#9374](https://github.com/kubernetes/kops/pull/9374)
* Add a note about NTH Queue Process mode [@olemarkus](https://github.com/olemarkus) [#11600](https://github.com/kubernetes/kops/pull/11600)
* Enable AWS EBS CSI driver by default [@olemarkus](https://github.com/olemarkus) [#11605](https://github.com/kubernetes/kops/pull/11605)
* Add documentation about snapshot-controller [@olemarkus](https://github.com/olemarkus) [#11606](https://github.com/kubernetes/kops/pull/11606)
* Convert all indents to spaces in node bootstrap script [@hakman](https://github.com/hakman) [#11611](https://github.com/kubernetes/kops/pull/11611)
* Use version marker for kops upgrade scenario [@olemarkus](https://github.com/olemarkus) [#11612](https://github.com/kubernetes/kops/pull/11612)
* Add init image field for Amazon VPC CNI [@ryan-dyer](https://github.com/ryan-dyer) [#11602](https://github.com/kubernetes/kops/pull/11602)
* Add to release process documentation [@johngmyers](https://github.com/johngmyers) [#11581](https://github.com/kubernetes/kops/pull/11581)
* Change toolbox template flag for consistency [@johngmyers](https://github.com/johngmyers) [#11616](https://github.com/kubernetes/kops/pull/11616)
* Fix duplicate CopyFile tasks [@johngmyers](https://github.com/johngmyers) [#11619](https://github.com/kubernetes/kops/pull/11619)
* Don't stage kops as file assets [@johngmyers](https://github.com/johngmyers) [#11620](https://github.com/kubernetes/kops/pull/11620)
* Dump all CP node logs to artifacts [@olemarkus](https://github.com/olemarkus) [#11615](https://github.com/kubernetes/kops/pull/11615)
* Simplify release steps [@johngmyers](https://github.com/johngmyers) [#11624](https://github.com/kubernetes/kops/pull/11624)
* Remove debug code and copy kops to PATH [@olemarkus](https://github.com/olemarkus) [#11625](https://github.com/kubernetes/kops/pull/11625)
* Update Go to v1.16.4 [@hakman](https://github.com/hakman) [#11626](https://github.com/kubernetes/kops/pull/11626)
* Add "kops get assets" command [@johngmyers](https://github.com/johngmyers) [#11617](https://github.com/kubernetes/kops/pull/11617)
* Set lifecycle on WarmPool task [@johngmyers](https://github.com/johngmyers) [#11618](https://github.com/kubernetes/kops/pull/11618)
* Label issue types in issue templates [@johngmyers](https://github.com/johngmyers) [#11637](https://github.com/kubernetes/kops/pull/11637)
* Remove fallback support for legacy IAM [@johngmyers](https://github.com/johngmyers) [#11641](https://github.com/kubernetes/kops/pull/11641)
* Rename CopyDockerImage to CopyImage [@johngmyers](https://github.com/johngmyers) [#11640](https://github.com/kubernetes/kops/pull/11640)
* Update the service account issuer discovery documentation [@olemarkus](https://github.com/olemarkus) [#11642](https://github.com/kubernetes/kops/pull/11642)
* Require all HasLifecycle tasks to have lifecycle set  [@johngmyers](https://github.com/johngmyers) [#11650](https://github.com/kubernetes/kops/pull/11650)
* Consolidate CSI livenessprobe images for multi-arch support [@rifelpet](https://github.com/rifelpet) [#11652](https://github.com/kubernetes/kops/pull/11652)
* Protokube needs dns-controller IAM permissions [@johngmyers](https://github.com/johngmyers) [#11645](https://github.com/kubernetes/kops/pull/11645)
* Remove docs on static addons [@olemarkus](https://github.com/olemarkus) [#11653](https://github.com/kubernetes/kops/pull/11653)
* Skip some steps if not doing cluster lifecycle [@johngmyers](https://github.com/johngmyers) [#11657](https://github.com/kubernetes/kops/pull/11657)
* Fix detection of virtual-hosted-style S3 urls in us-east-1 [@johngmyers](https://github.com/johngmyers) [#11655](https://github.com/kubernetes/kops/pull/11655)
* Promote channel alpha to stable [@johngmyers](https://github.com/johngmyers) [#11658](https://github.com/kubernetes/kops/pull/11658)
* Bump default cilium to 1.10 [@olemarkus](https://github.com/olemarkus) [#11659](https://github.com/kubernetes/kops/pull/11659)
* [Digital Ocean] Code cleanup with no functional modifications [@srikiz](https://github.com/srikiz) [#11592](https://github.com/kubernetes/kops/pull/11592)
* Fix jwks object path in S3 for IRSA [@h3poteto](https://github.com/h3poteto) [#11649](https://github.com/kubernetes/kops/pull/11649)
* Use version marker for kops ab scenario [@olemarkus](https://github.com/olemarkus) [#11648](https://github.com/kubernetes/kops/pull/11648)
* Kubetest2 scenario script cleanup [@rifelpet](https://github.com/rifelpet) [#11664](https://github.com/kubernetes/kops/pull/11664)
* Add more lifecycles to HasLifecycle tasks [@rifelpet](https://github.com/rifelpet) [#11666](https://github.com/kubernetes/kops/pull/11666)
* Set lifecycle on Droplet task [@johngmyers](https://github.com/johngmyers) [#11665](https://github.com/kubernetes/kops/pull/11665)
* Don't describe CloudLabels as being AWS-specific [@johngmyers](https://github.com/johngmyers) [#11667](https://github.com/kubernetes/kops/pull/11667)
* Move common stuff in e2e scenarios to common.sh [@olemarkus](https://github.com/olemarkus) [#11668](https://github.com/kubernetes/kops/pull/11668)
* Fix kubetest2 upgrade scripts [@rifelpet](https://github.com/rifelpet) [#11670](https://github.com/kubernetes/kops/pull/11670)
* Clean up straggling autogenerated code [@johngmyers](https://github.com/johngmyers) [#11671](https://github.com/kubernetes/kops/pull/11671)
* Remove dead code [@johngmyers](https://github.com/johngmyers) [#11672](https://github.com/kubernetes/kops/pull/11672)
* Explicitly set kubeconfig flag where we want to use it [@olemarkus](https://github.com/olemarkus) [#11676](https://github.com/kubernetes/kops/pull/11676)
* Add support for Docker v20.10.7 [@hakman](https://github.com/hakman) [#11674](https://github.com/kubernetes/kops/pull/11674)
* Use release markers instead of releases [@olemarkus](https://github.com/olemarkus) [#11679](https://github.com/kubernetes/kops/pull/11679)
* Drop trailing slash from oidc issuer [@olemarkus](https://github.com/olemarkus) [#11682](https://github.com/kubernetes/kops/pull/11682)
* Make Lifecycle field non-pointer [@johngmyers](https://github.com/johngmyers) [#11673](https://github.com/kubernetes/kops/pull/11673)
* Update Go to v1.16.5 [@hakman](https://github.com/hakman) [#11686](https://github.com/kubernetes/kops/pull/11686)
* Fix set-version leaving backup files with "-e" suffix [@johngmyers](https://github.com/johngmyers) [#11691](https://github.com/kubernetes/kops/pull/11691)
* Release notes for 1.21.0-beta.3 [@johngmyers](https://github.com/johngmyers) [#11694](https://github.com/kubernetes/kops/pull/11694)
* Update release process documentation [@johngmyers](https://github.com/johngmyers) [#11695](https://github.com/kubernetes/kops/pull/11695)
* Set IMDSv2 on by default for nodes and apiservers [@olemarkus](https://github.com/olemarkus) [#11329](https://github.com/kubernetes/kops/pull/11329)
* Deprecate old OS versions [@johngmyers](https://github.com/johngmyers) [#11696](https://github.com/kubernetes/kops/pull/11696)
* Fix panic in dryrun report [@johngmyers](https://github.com/johngmyers) [#11698](https://github.com/kubernetes/kops/pull/11698)
* Add options for configuring IPv4 and IPv6 support with Calico [@hakman](https://github.com/hakman) [#11688](https://github.com/kubernetes/kops/pull/11688)
* add e2e scenario script for testing cilium connectivity [@olemarkus](https://github.com/olemarkus) [#11697](https://github.com/kubernetes/kops/pull/11697)
* Fix copying of images from docker.io [@johngmyers](https://github.com/johngmyers) [#11656](https://github.com/kubernetes/kops/pull/11656)
* Fix the CSI EBS DS CRB. [@olemarkus](https://github.com/olemarkus) [#11701](https://github.com/kubernetes/kops/pull/11701)
* Use v1 certificate for LB controller [@olemarkus](https://github.com/olemarkus) [#11703](https://github.com/kubernetes/kops/pull/11703)
* Move asset copying out of apply_cluster [@johngmyers](https://github.com/johngmyers) [#11700](https://github.com/kubernetes/kops/pull/11700)
* Remove documentation of legacy IAM permissions [@johngmyers](https://github.com/johngmyers) [#11706](https://github.com/kubernetes/kops/pull/11706)
* Add some tests around channel adding needs-update annotation [@olemarkus](https://github.com/olemarkus) [#11598](https://github.com/kubernetes/kops/pull/11598)
* Update kube-router to v1.2.3 [@hakman](https://github.com/hakman) [#11124](https://github.com/kubernetes/kops/pull/11124)
* Create document on asset repositories [@johngmyers](https://github.com/johngmyers) [#11654](https://github.com/kubernetes/kops/pull/11654)
* Make relnotes match the new max hop limit IMDS behaviour [@olemarkus](https://github.com/olemarkus) [#11702](https://github.com/kubernetes/kops/pull/11702)
* Add proxy envs to calico to make possible usage of AWS source destination check [@DOboznyi](https://github.com/DOboznyi) [#11709](https://github.com/kubernetes/kops/pull/11709)
* Update controller-runtime to v0.9.0 [@hakman](https://github.com/hakman) [#11713](https://github.com/kubernetes/kops/pull/11713)
* Generate AWSEBSCSIDriver model only when using AWS [@hakman](https://github.com/hakman) [#11716](https://github.com/kubernetes/kops/pull/11716)
* Make AWS EBS CSI Driver default as of k8s 1.22 [@olemarkus](https://github.com/olemarkus) [#11721](https://github.com/kubernetes/kops/pull/11721)
* Use quay images for cilium [@olemarkus](https://github.com/olemarkus) [#11722](https://github.com/kubernetes/kops/pull/11722)
* Allow master to touch volumes tagged with kubernetes.io/cluster/<clusterName>:owned [@wongma7](https://github.com/wongma7) [#11729](https://github.com/kubernetes/kops/pull/11729)
* Update release branch docs with kubetest2 presubmit job [@rifelpet](https://github.com/rifelpet) [#11732](https://github.com/kubernetes/kops/pull/11732)
* Perform ClusterCIDR and ServiceClusterIPRange assignments for IPv6 [@johngmyers](https://github.com/johngmyers) [#11724](https://github.com/kubernetes/kops/pull/11724)
* Spotinst: Support for API Load Balancer with AWS/NLB [@liranp](https://github.com/liranp) [#11604](https://github.com/kubernetes/kops/pull/11604)
* Add support for setting latest k8s in ab scenario [@olemarkus](https://github.com/olemarkus) [#11735](https://github.com/kubernetes/kops/pull/11735)
* Deprecate CloudFormation support [@johngmyers](https://github.com/johngmyers) [#11630](https://github.com/kubernetes/kops/pull/11630)
* Calculate IPv6 subnet CIDR based on cluster CIDR [@hakman](https://github.com/hakman) [#11523](https://github.com/kubernetes/kops/pull/11523)
* Only warm-pull images used by the CSI DS [@olemarkus](https://github.com/olemarkus) [#11734](https://github.com/kubernetes/kops/pull/11734)
* Remove k8s-upgrade script as upgrade-ab is now used instead [@olemarkus](https://github.com/olemarkus) [#11738](https://github.com/kubernetes/kops/pull/11738)
* Add small note about rotating cluster after backup restore [@olemarkus](https://github.com/olemarkus) [#11733](https://github.com/kubernetes/kops/pull/11733)
* Make forwardToKubeDNS work in the NodeLocal DNSCache template [@ederst](https://github.com/ederst) [#11743](https://github.com/kubernetes/kops/pull/11743)
* Add test scenario for if channels is able to delete dangling resources [@olemarkus](https://github.com/olemarkus) [#11739](https://github.com/kubernetes/kops/pull/11739)
* Remove InstanceGroup from NodeupModelContext [@johngmyers](https://github.com/johngmyers) [#9294](https://github.com/kubernetes/kops/pull/9294)
* Refactor keypair code in preparation for secret rotation [@johngmyers](https://github.com/johngmyers) [#11219](https://github.com/kubernetes/kops/pull/11219)
* Remove unused field [@johngmyers](https://github.com/johngmyers) [#11749](https://github.com/kubernetes/kops/pull/11749)
* Hyperlink Sprig reference [@OutdatedVersion](https://github.com/OutdatedVersion) [#11730](https://github.com/kubernetes/kops/pull/11730)
* Compare OpenStack security groups deterministically [@ederst](https://github.com/ederst) [#11741](https://github.com/kubernetes/kops/pull/11741)
* Don't set Subnet dependency on AmazonIPv6CIDR for shared VPCs [@hakman](https://github.com/hakman) [#11752](https://github.com/kubernetes/kops/pull/11752)
* Set BindAddress appropriately when in IPv6-only mode [@johngmyers](https://github.com/johngmyers) [#11737](https://github.com/kubernetes/kops/pull/11737)
* Add --ipv6 experimental cli flag [@hakman](https://github.com/hakman) [#11629](https://github.com/kubernetes/kops/pull/11629)
* Don't restrict nodeup download to IPv4 [@johngmyers](https://github.com/johngmyers) [#11755](https://github.com/kubernetes/kops/pull/11755)
* Cilium: disable masquerade by default when in ENI IPAM mode [@johngmyers](https://github.com/johngmyers) [#11753](https://github.com/kubernetes/kops/pull/11753)
* Set default ClusterCIDR through the PodCIDR [@johngmyers](https://github.com/johngmyers) [#11756](https://github.com/kubernetes/kops/pull/11756)
* Enable IPv6 support for Cilium [@johngmyers](https://github.com/johngmyers) [#11754](https://github.com/kubernetes/kops/pull/11754)
* Allow unsetting fields from the command line [@johngmyers](https://github.com/johngmyers) [#11745](https://github.com/kubernetes/kops/pull/11745)
* Adjustments to SpecOverride [@johngmyers](https://github.com/johngmyers) [#11761](https://github.com/kubernetes/kops/pull/11761)
* Make the AdminAccess default inclusive of IPv6 [@johngmyers](https://github.com/johngmyers) [#11763](https://github.com/kubernetes/kops/pull/11763)
* Default the NodeCIDRMaskSize appropriately for IPv6 [@johngmyers](https://github.com/johngmyers) [#11762](https://github.com/kubernetes/kops/pull/11762)
* Simplify Calico IPv6 configuration [@johngmyers](https://github.com/johngmyers) [#11725](https://github.com/kubernetes/kops/pull/11725)
* Fix typo in IRSA docs [@yurrriq](https://github.com/yurrriq) [#11770](https://github.com/kubernetes/kops/pull/11770)
* Fix typo in populate_instancegroup_spec.go [@yurrriq](https://github.com/yurrriq) [#11769](https://github.com/kubernetes/kops/pull/11769)
* fix enable default SC when EBS driver is not installed [@olemarkus](https://github.com/olemarkus) [#11771](https://github.com/kubernetes/kops/pull/11771)
* Set containerd config on nodeup.Config instead of clusterspec [@olemarkus](https://github.com/olemarkus) [#11750](https://github.com/kubernetes/kops/pull/11750)
* Make it easy to run scenarios with irsa enabled [@olemarkus](https://github.com/olemarkus) [#11758](https://github.com/kubernetes/kops/pull/11758)
* Trim unnecessary paths from worker node IAM [@johngmyers](https://github.com/johngmyers) [#11775](https://github.com/kubernetes/kops/pull/11775)
* Allocate smaller IPv6 PodCIDRs by default [@johngmyers](https://github.com/johngmyers) [#11772](https://github.com/kubernetes/kops/pull/11772)
* Update github.com/spf13/viper to v1.8.0 [@hakman](https://github.com/hakman) [#11777](https://github.com/kubernetes/kops/pull/11777)
* [cni/cilium] Add support for additional config options [@dntosas](https://github.com/dntosas) [#11678](https://github.com/kubernetes/kops/pull/11678)
* Bump the cas addon version. [@olemarkus](https://github.com/olemarkus) [#11780](https://github.com/kubernetes/kops/pull/11780)
* Also set haveUserInfo=true in case --user was provided in "kops export kubecfg" [@codablock](https://github.com/codablock) [#11778](https://github.com/kubernetes/kops/pull/11778)
* Don't try to build etcd-manager secrets for cilium twice [@olemarkus](https://github.com/olemarkus) [#11764](https://github.com/kubernetes/kops/pull/11764)
* [addons] Introduce NodeProblemDetector [@dntosas](https://github.com/dntosas) [#11381](https://github.com/kubernetes/kops/pull/11381)
* Enable ability to use IRSA for cluster autoscaler [@olemarkus](https://github.com/olemarkus) [#11748](https://github.com/kubernetes/kops/pull/11748)
* Allow using IRSA for EBS CSI Driver [@olemarkus](https://github.com/olemarkus) [#11747](https://github.com/kubernetes/kops/pull/11747)
* Delete all files in the provided discoveryStore on cluster deletion [@olemarkus](https://github.com/olemarkus) [#11791](https://github.com/kubernetes/kops/pull/11791)
* Release notes for 1.20.2 [@justinsb](https://github.com/justinsb) [#11804](https://github.com/kubernetes/kops/pull/11804)
* Update alpha channel k8s versions and ec2 ami base image [@MoShitrit](https://github.com/MoShitrit) [#11803](https://github.com/kubernetes/kops/pull/11803)
* Seed the random number generator on AWS  [@johngmyers](https://github.com/johngmyers) [#11789](https://github.com/kubernetes/kops/pull/11789)
* Upgrade AWS CNI to latest release 1.8.0 [@MoShitrit](https://github.com/MoShitrit) [#11805](https://github.com/kubernetes/kops/pull/11805)
* bump the version of gophercloud [@cardoe](https://github.com/cardoe) [#11788](https://github.com/kubernetes/kops/pull/11788)
* Allow "kops create keypair" to stage next CA cert [@johngmyers](https://github.com/johngmyers) [#11252](https://github.com/kubernetes/kops/pull/11252)
* Reduce policy size [@olemarkus](https://github.com/olemarkus) [#11814](https://github.com/kubernetes/kops/pull/11814)
* Fix lbc permissions [@olemarkus](https://github.com/olemarkus) [#11815](https://github.com/kubernetes/kops/pull/11815)
* doc: remove `brew switch` ref and simplify version bump [@chenrui333](https://github.com/chenrui333) [#11817](https://github.com/kubernetes/kops/pull/11817)
* brew: remove kops.rb [@chenrui333](https://github.com/chenrui333) [#11819](https://github.com/kubernetes/kops/pull/11819)
* Split out get, describe, and delete keypairs commands [@johngmyers](https://github.com/johngmyers) [#11820](https://github.com/kubernetes/kops/pull/11820)
* Include multiple cluster CAs in trust stores [@johngmyers](https://github.com/johngmyers) [#11809](https://github.com/kubernetes/kops/pull/11809)
* Fix validating presence of AWS EBS CSI [@olemarkus](https://github.com/olemarkus) [#11795](https://github.com/kubernetes/kops/pull/11795)
* Pre-pull all container images used by components and addons [@hakman](https://github.com/hakman) [#11717](https://github.com/kubernetes/kops/pull/11717)
* skip flaking ebs csi flakes [@olemarkus](https://github.com/olemarkus) [#11821](https://github.com/kubernetes/kops/pull/11821)
* Set EnableExternalCloudController to true by default [@hakman](https://github.com/hakman) [#11825](https://github.com/kubernetes/kops/pull/11825)
* Put versioned API of cluster into state store [@johngmyers](https://github.com/johngmyers) [#9229](https://github.com/kubernetes/kops/pull/9229)
* Support creating new service-account keypairs [@johngmyers](https://github.com/johngmyers) [#11822](https://github.com/kubernetes/kops/pull/11822)
* Add support for logging-format option (text/json) [@dntosas](https://github.com/dntosas) [#11583](https://github.com/kubernetes/kops/pull/11583)
* Add back createvolume to master + bump ebs driver [@olemarkus](https://github.com/olemarkus) [#11811](https://github.com/kubernetes/kops/pull/11811)
* Improve the output of 'kops get keypairs'  [@johngmyers](https://github.com/johngmyers) [#11823](https://github.com/kubernetes/kops/pull/11823)
* Fix kOps version for managed flag on cert-manager [@djablonski-moia](https://github.com/djablonski-moia) [#11828](https://github.com/kubernetes/kops/pull/11828)
* Run scenarios as presubmit tests [@olemarkus](https://github.com/olemarkus) [#11801](https://github.com/kubernetes/kops/pull/11801)
* Include multiple CA certs in exported kubeconfigs [@johngmyers](https://github.com/johngmyers) [#11831](https://github.com/kubernetes/kops/pull/11831)
* Remove support for importing and converting kubeup clusters [@johngmyers](https://github.com/johngmyers) [#11824](https://github.com/kubernetes/kops/pull/11824)
* Ignore failing tests in upgrade scenario [@rifelpet](https://github.com/rifelpet) [#11832](https://github.com/kubernetes/kops/pull/11832)
* Set priority class for AWS CCM addon [@hakman](https://github.com/hakman) [#11834](https://github.com/kubernetes/kops/pull/11834)
* Limit concurrency of asset copy tasks  [@johngmyers](https://github.com/johngmyers) [#11708](https://github.com/kubernetes/kops/pull/11708)
* Add 'kops promote keypair' command [@johngmyers](https://github.com/johngmyers) [#11835](https://github.com/kubernetes/kops/pull/11835)
* Kubetest2 fix periodic end to end tests [@olemarkus](https://github.com/olemarkus) [#11838](https://github.com/kubernetes/kops/pull/11838)
* Kubetest2 - Add --skip-regex logic [@rifelpet](https://github.com/rifelpet) [#11841](https://github.com/kubernetes/kops/pull/11841)
* Fix skip regex for ebs csi test [@olemarkus](https://github.com/olemarkus) [#11840](https://github.com/kubernetes/kops/pull/11840)
* Mark nodes NeedsUpdate when keys they use change  [@johngmyers](https://github.com/johngmyers) [#11833](https://github.com/kubernetes/kops/pull/11833)
* Completely remove EnableExternalCloudController feature flag [@hakman](https://github.com/hakman) [#11839](https://github.com/kubernetes/kops/pull/11839)
* Only set default --skip-regex if it hasn't been set [@rifelpet](https://github.com/rifelpet) [#11842](https://github.com/kubernetes/kops/pull/11842)
* Clarify the limitations of Azure DNS support [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11844](https://github.com/kubernetes/kops/pull/11844)
* Refactor kube-controller-manager secrets [@johngmyers](https://github.com/johngmyers) [#11847](https://github.com/kubernetes/kops/pull/11847)
* Escape --skip-regex pattern [@rifelpet](https://github.com/rifelpet) [#11851](https://github.com/kubernetes/kops/pull/11851)
* Make aws-cni config more flexible and generalized [@MoShitrit](https://github.com/MoShitrit) [#11816](https://github.com/kubernetes/kops/pull/11816)
* Weaken some interfaces [@johngmyers](https://github.com/johngmyers) [#11837](https://github.com/kubernetes/kops/pull/11837)
* Handle containerExec hooks when using containerd [@hakman](https://github.com/hakman) [#11852](https://github.com/kubernetes/kops/pull/11852)
* Improve image copying [@johngmyers](https://github.com/johngmyers) [#11854](https://github.com/kubernetes/kops/pull/11854)
* Update helm to v3.6.1 [@olemarkus](https://github.com/olemarkus) [#11860](https://github.com/kubernetes/kops/pull/11860)
* Update CNI plugins to v0.9.1 [@hakman](https://github.com/hakman) [#11846](https://github.com/kubernetes/kops/pull/11846)
* Don't include irrelevant bootstrap addons [@johngmyers](https://github.com/johngmyers) [#11861](https://github.com/kubernetes/kops/pull/11861)
* Remove obsolete Spotinst manifest [@johngmyers](https://github.com/johngmyers) [#11862](https://github.com/kubernetes/kops/pull/11862)
* Enable cross-subnet mode with Calico by default [@hakman](https://github.com/hakman) [#11810](https://github.com/kubernetes/kops/pull/11810)
* Fix dryrun cluster creation [@johngmyers](https://github.com/johngmyers) [#11863](https://github.com/kubernetes/kops/pull/11863)
* Push alpha channel to stable [@MoShitrit](https://github.com/MoShitrit) [#11864](https://github.com/kubernetes/kops/pull/11864)
* Add a note about running update-expected when updating base AMI [@MoShitrit](https://github.com/MoShitrit) [#11865](https://github.com/kubernetes/kops/pull/11865)
* Make it simpler to spot missing files in integration tests [@olemarkus](https://github.com/olemarkus) [#11866](https://github.com/kubernetes/kops/pull/11866)
* fix: broken link [@choeffer](https://github.com/choeffer) [#11793](https://github.com/kubernetes/kops/pull/11793)
* Decrease default values for net.ipv4.tcp_rmem and net.ipv4.tcp_wmem [@hakman](https://github.com/hakman) [#11868](https://github.com/kubernetes/kops/pull/11868)
* Remove version from addons [@hakman](https://github.com/hakman) [#11867](https://github.com/kubernetes/kops/pull/11867)
* Move most nodeup.Config data to config store [@johngmyers](https://github.com/johngmyers) [#11869](https://github.com/kubernetes/kops/pull/11869)
* Don't reconcile roles and policies if a profile is provided [@olemarkus](https://github.com/olemarkus) [#11836](https://github.com/kubernetes/kops/pull/11836)
* Use DualStack API NLB for IPv6 [@hakman](https://github.com/hakman) [#11870](https://github.com/kubernetes/kops/pull/11870)
* Simplify config server protocol [@johngmyers](https://github.com/johngmyers) [#11871](https://github.com/kubernetes/kops/pull/11871)
* Refactor etcd-client-cilium secrets [@johngmyers](https://github.com/johngmyers) [#11848](https://github.com/kubernetes/kops/pull/11848)
* Retain deleted keypairs [@johngmyers](https://github.com/johngmyers) [#11845](https://github.com/kubernetes/kops/pull/11845)
* Write config as ManagedFile [@johngmyers](https://github.com/johngmyers) [#11796](https://github.com/kubernetes/kops/pull/11796)
* Improve "kops distrust keypair" command [@johngmyers](https://github.com/johngmyers) [#11876](https://github.com/kubernetes/kops/pull/11876)
* Avoid spurious changes for ASG InstanceProtection and LT InstanceMonitoring [@hakman](https://github.com/hakman) [#11873](https://github.com/kubernetes/kops/pull/11873)
* Kubetest2 - set node-os-arch flag instead of skipping kubectl test on arm64 [@rifelpet](https://github.com/rifelpet) [#11879](https://github.com/kubernetes/kops/pull/11879)
* Improve completion for kops root command [@johngmyers](https://github.com/johngmyers) [#11880](https://github.com/kubernetes/kops/pull/11880)
* Spotinst: Update `spotinst/ocean-controller` to v1.0.76 [@liranp](https://github.com/liranp) [#11885](https://github.com/kubernetes/kops/pull/11885)
* support large/slow downloads [@aojea](https://github.com/aojea) [#11884](https://github.com/kubernetes/kops/pull/11884)
* Add support for darwin/arm64 on the client-side [@hakman](https://github.com/hakman) [#11883](https://github.com/kubernetes/kops/pull/11883)
* Refactor nodeup APIServer builder, part one  [@johngmyers](https://github.com/johngmyers) [#11872](https://github.com/kubernetes/kops/pull/11872)
* Allow rotation of etcd-clients-ca-cilium [@johngmyers](https://github.com/johngmyers) [#11877](https://github.com/kubernetes/kops/pull/11877)
* [DigitalOcean] Increase droplet size for e2e tests [@srikiz](https://github.com/srikiz) [#11887](https://github.com/kubernetes/kops/pull/11887)
* Set download timeout to 3 minutes [@hakman](https://github.com/hakman) [#11886](https://github.com/kubernetes/kops/pull/11886)
* Implement completion for "kops create keypair" [@johngmyers](https://github.com/johngmyers) [#11888](https://github.com/kubernetes/kops/pull/11888)
* Render managed files with Terraform [@johngmyers](https://github.com/johngmyers) [#9621](https://github.com/kubernetes/kops/pull/9621)
* Implement completion for "kops promote keypair" [@johngmyers](https://github.com/johngmyers) [#11892](https://github.com/kubernetes/kops/pull/11892)
* Fix nil-pointer dereference on dryrun [@johngmyers](https://github.com/johngmyers) [#11894](https://github.com/kubernetes/kops/pull/11894)
* Implement completion for "kops distrust keypair" [@johngmyers](https://github.com/johngmyers) [#11899](https://github.com/kubernetes/kops/pull/11899)
* Refactor etcd-clients-ca keyset for api-server [@johngmyers](https://github.com/johngmyers) [#11897](https://github.com/kubernetes/kops/pull/11897)
* Allow overriding the ServiceAccountIssuer for IRSA [@johngmyers](https://github.com/johngmyers) [#11853](https://github.com/kubernetes/kops/pull/11853)
* Remove unnecessary parameters from terraform finish methods [@rifelpet](https://github.com/rifelpet) [#11900](https://github.com/kubernetes/kops/pull/11900)
* Include GCP Project in terraform HCL2 output [@rifelpet](https://github.com/rifelpet) [#11901](https://github.com/kubernetes/kops/pull/11901)
* Use Cobra's built-in completion command  [@johngmyers](https://github.com/johngmyers) [#11905](https://github.com/kubernetes/kops/pull/11905)
* Refactor apiserver-aggregator-ca [@johngmyers](https://github.com/johngmyers) [#11906](https://github.com/kubernetes/kops/pull/11906)
* Add support for IPv6 addresses to dns-controller [@hakman](https://github.com/hakman) [#11907](https://github.com/kubernetes/kops/pull/11907)
* Improve "kops get keypairs" [@johngmyers](https://github.com/johngmyers) [#11904](https://github.com/kubernetes/kops/pull/11904)
* Release notes for 1.21.0 [@justinsb](https://github.com/justinsb) [#11910](https://github.com/kubernetes/kops/pull/11910)
* Update pause image to 3.5 [@rifelpet](https://github.com/rifelpet) [#11909](https://github.com/kubernetes/kops/pull/11909)
* Upgrade Cobra to 1.2.1 [@johngmyers](https://github.com/johngmyers) [#11912](https://github.com/kubernetes/kops/pull/11912)
* Capture logs from the containerd service [@hakman](https://github.com/hakman) [#11914](https://github.com/kubernetes/kops/pull/11914)
* Do not set both CIDR and IPv6CIDR on sg rules [@olemarkus](https://github.com/olemarkus) [#11915](https://github.com/kubernetes/kops/pull/11915)
* Remove unused test files from legacy IAM [@rifelpet](https://github.com/rifelpet) [#11918](https://github.com/kubernetes/kops/pull/11918)
* Reduce policy size further [@olemarkus](https://github.com/olemarkus) [#11843](https://github.com/kubernetes/kops/pull/11843)
* Set KOPS_RUN_TOO_NEW_VERSION in scenario scripts [@rifelpet](https://github.com/rifelpet) [#11923](https://github.com/kubernetes/kops/pull/11923)
* Update version support matrix for 1.21 [@johngmyers](https://github.com/johngmyers) [#11922](https://github.com/kubernetes/kops/pull/11922)
* Rename the "ca" keyset to "kubernetes-ca" [@johngmyers](https://github.com/johngmyers) [#11921](https://github.com/kubernetes/kops/pull/11921)
* Allow fsstore to be used for mock s3 rules [@olemarkus](https://github.com/olemarkus) [#11916](https://github.com/kubernetes/kops/pull/11916)
* Implement completion for "kops rolling-update cluster" [@johngmyers](https://github.com/johngmyers) [#11924](https://github.com/kubernetes/kops/pull/11924)
* Implement completion for "kops update cluster" [@johngmyers](https://github.com/johngmyers) [#11926](https://github.com/kubernetes/kops/pull/11926)
* Update the status of cloud providers [@johngmyers](https://github.com/johngmyers) [#11930](https://github.com/kubernetes/kops/pull/11930)
* Remove obsolete files [@johngmyers](https://github.com/johngmyers) [#11932](https://github.com/kubernetes/kops/pull/11932)
* Implement completion for validate and upgrade [@johngmyers](https://github.com/johngmyers) [#11927](https://github.com/kubernetes/kops/pull/11927)
* Continue if a single addon fails to be applied [@olemarkus](https://github.com/olemarkus) [#11933](https://github.com/kubernetes/kops/pull/11933)
* Remove unused golden files from manyaddons test [@olemarkus](https://github.com/olemarkus) [#11935](https://github.com/kubernetes/kops/pull/11935)
* Schedule certmanager webhook on control plane [@olemarkus](https://github.com/olemarkus) [#11934](https://github.com/kubernetes/kops/pull/11934)
* [Digital Ocean] Remove PrivateNetworking option in droplet since it's deprecated [@srikiz](https://github.com/srikiz) [#11936](https://github.com/kubernetes/kops/pull/11936)
* Run cert-manager cainjector on CP nodes as well [@olemarkus](https://github.com/olemarkus) [#11938](https://github.com/kubernetes/kops/pull/11938)
* Fix various CCM issues [@olemarkus](https://github.com/olemarkus) [#11939](https://github.com/kubernetes/kops/pull/11939)
* Add podPidsLimit / --pod-max-pids support [@uthark](https://github.com/uthark) [#11898](https://github.com/kubernetes/kops/pull/11898)
* Add log rotation for etcd-cilium.log [@hakman](https://github.com/hakman) [#11943](https://github.com/kubernetes/kops/pull/11943)
* [Digital Ocean] Modify error message when multiple zones are specified [@srikiz](https://github.com/srikiz) [#11944](https://github.com/kubernetes/kops/pull/11944)
* Fix bullet point rendering in state doc [@rothgar](https://github.com/rothgar) [#11948](https://github.com/kubernetes/kops/pull/11948)
* Implement some completion for "kops create cluster" [@johngmyers](https://github.com/johngmyers) [#11940](https://github.com/kubernetes/kops/pull/11940)
* check if the instance is under an asg [@olivierpilotte](https://github.com/olivierpilotte) [#11958](https://github.com/kubernetes/kops/pull/11958)
* Use etcd v3.5.0 for Kubernetes 1.22+ [@hakman](https://github.com/hakman) [#11941](https://github.com/kubernetes/kops/pull/11941)
* Unconditionally reenable KMS and Volume Limit tests [@rifelpet](https://github.com/rifelpet) [#11966](https://github.com/kubernetes/kops/pull/11966)
* Suppress usage for errors returned from RunE [@johngmyers](https://github.com/johngmyers) [#11969](https://github.com/kubernetes/kops/pull/11969)
* Implement completion for "kops create instancegroup"  [@johngmyers](https://github.com/johngmyers) [#11957](https://github.com/kubernetes/kops/pull/11957)
* Refactor keysets for etcd-manager [@johngmyers](https://github.com/johngmyers) [#11964](https://github.com/kubernetes/kops/pull/11964)
* Cilium etcd fixes [@olemarkus](https://github.com/olemarkus) [#11961](https://github.com/kubernetes/kops/pull/11961)
* Refactor service-account signing key [@johngmyers](https://github.com/johngmyers) [#11974](https://github.com/kubernetes/kops/pull/11974)
* Add "all" variants of key rotation commands [@johngmyers](https://github.com/johngmyers) [#11971](https://github.com/kubernetes/kops/pull/11971)
* Add documentation for keypair rotation [@johngmyers](https://github.com/johngmyers) [#11972](https://github.com/kubernetes/kops/pull/11972)
* Implement completion for delete commands [@johngmyers](https://github.com/johngmyers) [#11970](https://github.com/kubernetes/kops/pull/11970)
* Issue certs using CA KeypairID in NodeupConfig [@johngmyers](https://github.com/johngmyers) [#11975](https://github.com/kubernetes/kops/pull/11975)
* Stop writing the certificate-only keyset.yaml [@johngmyers](https://github.com/johngmyers) [#11977](https://github.com/kubernetes/kops/pull/11977)
* Provide more information on rotating secrets [@johngmyers](https://github.com/johngmyers) [#11978](https://github.com/kubernetes/kops/pull/11978)
* Spotinst: Update `spotinst/ocean-controller` to v1.0.77 [@liranp](https://github.com/liranp) [#11981](https://github.com/kubernetes/kops/pull/11981)
* [Digital Ocean] Fix sporadic volume detach error when volume is already detached [@srikiz](https://github.com/srikiz) [#11963](https://github.com/kubernetes/kops/pull/11963)
* Fix broken link to contributing [@MoShitrit](https://github.com/MoShitrit) [#11979](https://github.com/kubernetes/kops/pull/11979)
* Add "kops trust keypair" command [@johngmyers](https://github.com/johngmyers) [#11973](https://github.com/kubernetes/kops/pull/11973)
* Implement completion for "kops edit" commands [@johngmyers](https://github.com/johngmyers) [#11980](https://github.com/kubernetes/kops/pull/11980)
* Add missing IAM permissions to the NTH docs [@olemarkus](https://github.com/olemarkus) [#11984](https://github.com/kubernetes/kops/pull/11984)
* Implement completion for "kops export kubeconfig" [@johngmyers](https://github.com/johngmyers) [#11983](https://github.com/kubernetes/kops/pull/11983)
* Cobra cleanups [@johngmyers](https://github.com/johngmyers) [#11985](https://github.com/kubernetes/kops/pull/11985)
* Fix "kops export kubeconfig" [@johngmyers](https://github.com/johngmyers) [#11988](https://github.com/kubernetes/kops/pull/11988)
* Add region to aws lbc [@olemarkus](https://github.com/olemarkus) [#11990](https://github.com/kubernetes/kops/pull/11990)
* Move containerd config from cloudup to nodeup [@olemarkus](https://github.com/olemarkus) [#11986](https://github.com/kubernetes/kops/pull/11986)
* Change set and unset commands into flags on "kops edit cluster" [@johngmyers](https://github.com/johngmyers) [#11987](https://github.com/kubernetes/kops/pull/11987)
* Remove dead code [@johngmyers](https://github.com/johngmyers) [#11993](https://github.com/kubernetes/kops/pull/11993)
* Implement completion for "kops toolbox", part one [@johngmyers](https://github.com/johngmyers) [#11992](https://github.com/kubernetes/kops/pull/11992)
* hack/upload: avoid ACLs for GCS buckets with UBLA enabled [@spiffxp](https://github.com/spiffxp) [#11994](https://github.com/kubernetes/kops/pull/11994)
* Azure - support VMSS availability zones [@rifelpet](https://github.com/rifelpet) [#11962](https://github.com/kubernetes/kops/pull/11962)
* Upgrade aws-sdk-go [@rifelpet](https://github.com/rifelpet) [#11996](https://github.com/kubernetes/kops/pull/11996)
* remove references to kubernetes-release-dev [@spiffxp](https://github.com/spiffxp) [#11997](https://github.com/kubernetes/kops/pull/11997)
* Clean up extra spaces [@jayonlau](https://github.com/jayonlau) [#11989](https://github.com/kubernetes/kops/pull/11989)
* Verify CA keypair IDs for kops-controller-issued certs [@johngmyers](https://github.com/johngmyers) [#11982](https://github.com/kubernetes/kops/pull/11982)
* Use keypair IDs for non-kops-controller-issued worker node certs [@johngmyers](https://github.com/johngmyers) [#11998](https://github.com/kubernetes/kops/pull/11998)
* Update alpha channel with July k8s releases and bump Ubuntu EC2 AMI version [@MoShitrit](https://github.com/MoShitrit) [#12000](https://github.com/kubernetes/kops/pull/12000)
* Dedicated function for ccm permissons [@olemarkus](https://github.com/olemarkus) [#11991](https://github.com/kubernetes/kops/pull/11991)
* Add keypair rotation test scenario [@rifelpet](https://github.com/rifelpet) [#12001](https://github.com/kubernetes/kops/pull/12001)
* Fix file permissions on new keypair rotation test scenario [@rifelpet](https://github.com/rifelpet) [#12005](https://github.com/kubernetes/kops/pull/12005)
* Implement completion for "kops toolbox", part two [@johngmyers](https://github.com/johngmyers) [#11999](https://github.com/kubernetes/kops/pull/11999)
* Issue kubelet cert on apiserver nodes for k8s before 1.19 [@johngmyers](https://github.com/johngmyers) [#12002](https://github.com/kubernetes/kops/pull/12002)
* Refactor more kube-apiserver credentials [@johngmyers](https://github.com/johngmyers) [#12003](https://github.com/kubernetes/kops/pull/12003)
* Accommodate older destination kops versions in upgrade-ab scenario [@johngmyers](https://github.com/johngmyers) [#12008](https://github.com/kubernetes/kops/pull/12008)
* Fix kops binary references in keypair rotation scenario [@rifelpet](https://github.com/rifelpet) [#12009](https://github.com/kubernetes/kops/pull/12009)
* Don't provision SSH key by default on AWS [@johngmyers](https://github.com/johngmyers) [#12011](https://github.com/kubernetes/kops/pull/12011)
* Deprecate the Lyft CNI [@johngmyers](https://github.com/johngmyers) [#12010](https://github.com/kubernetes/kops/pull/12010)
* Remove apiserver's access to controller-manager secrets [@johngmyers](https://github.com/johngmyers) [#12006](https://github.com/kubernetes/kops/pull/12006)
