## Release notes for kOps 1.21 series

**&#9888; kOps 1.21 has not been released yet! &#9888;**

This is a document to gather the release notes prior to the release.

# Significant changes

## Service Account Issuer Discovery and AWS IAM Roles for Service Accounts (IRSA)

kOps now supports publishing an OIDC-compatible discovery document to an S3 bucket
and configuring AWS to use it for IAM Roles for Service Accounts (IRSA).

See the [Service Account Issuer Discovery](https://kops.sigs.k8s.io/cluster_spec#service-account-issuer-discovery-and-aws-iam-roles-for-service-accounts-irsa)
documentation for more information.

## Dedicated API Server nodes.

kOps now supports extending the control plane with [dedicated apiserver nodes](https://kops.sigs.k8s.io/operations/scaling). These nodes run in dedicated instance groups that can be scaled horizontally.

In 1.21, this feature is behind a feature flag as node role name, labels, taints, and domains can change based on feedback from the community.

## Warm Pool (AWS only)

A Warm Pool contains pre-initialized EC2 instances that can join the cluster significantly faster than regular instances. These instances run the kOps configuration process, pull known Docker images, and then shut down. When the ASG needs to scale out it will pull instances from the warm pool if any are available.

See the [warm pool](https://kops.sigs.k8s.io/instance_groups/#warmpool-aws-only) documentation for more information.


# Other significant changes

* Protokube now runs as a systemd process rather than a docker container.


# Breaking changes

# Required Actions

* To support [Node Termination Handler's Queue Process mode](/addons/#node-termination-handler), AWS cluster deletion now requires the kops CLI have `sqs:ListQueues` and `events:ListRules` permissions regardless of whether or not the addon is used.

# Deprecations

* Support for Kubernetes versions 1.15 and 1.16 are deprecated and will be removed in kOps 1.22.
* Support for launch configurations has been removed in favour of launch templates.

# Full change list since 1.21.0 release

## 1.21.0-alpha.2 to 1.21.0-alpha.1

* Release notes for 1.21.0-alpha.2 [@hakman](https://github.com/hakman) [#10768](https://github.com/kubernetes/kops/pull/10768)
* Add troubleshooting of corrupted api server leases [@olemarkus](https://github.com/olemarkus) [#10764](https://github.com/kubernetes/kops/pull/10764)
* Boot nodes without state store access [@justinsb](https://github.com/justinsb) [#10469](https://github.com/kubernetes/kops/pull/10469)
* Update GCE zones [@bharath-123](https://github.com/bharath-123) [#10771](https://github.com/kubernetes/kops/pull/10771)
* Kubetest2 - Use a shell lexer for passing extra args to `create cluster` [@rifelpet](https://github.com/rifelpet) [#10772](https://github.com/kubernetes/kops/pull/10772)
* Use the kubeApiServerConfig clientCAFile field [@slu2011](https://github.com/slu2011) [#10707](https://github.com/kubernetes/kops/pull/10707)
* Kubetest2 - Fix splitting of --create-args [@rifelpet](https://github.com/rifelpet) [#10775](https://github.com/kubernetes/kops/pull/10775)
* Logging: don't suggest we are pre-creating DNS records unless we are [@justinsb](https://github.com/justinsb) [#10782](https://github.com/kubernetes/kops/pull/10782)
* Add missing versions to channels [@olemarkus](https://github.com/olemarkus) [#10781](https://github.com/kubernetes/kops/pull/10781)
* fix: asset task copy docker image [@johanneswuerbach](https://github.com/johanneswuerbach) [#10767](https://github.com/kubernetes/kops/pull/10767)
* Add support for creating world-readable managedFiles [@olemarkus](https://github.com/olemarkus) [#10778](https://github.com/kubernetes/kops/pull/10778)
* Update kubectl documentation with new flags [@rpadovani](https://github.com/rpadovani),[@hakman](https://github.com/hakman) [#10779](https://github.com/kubernetes/kops/pull/10779)
* Add overrides testing in lifecycle integration tests [@rifelpet](https://github.com/rifelpet) [#10752](https://github.com/kubernetes/kops/pull/10752)
* Add AWS LoadBalancerController [@olemarkus](https://github.com/olemarkus) [#10489](https://github.com/kubernetes/kops/pull/10489)
* Update Calico to v3.17.2 [@hakman](https://github.com/hakman) [#10787](https://github.com/kubernetes/kops/pull/10787)
* Enable CSIMigrationAWS if CSI EBS driver is installed [@olemarkus](https://github.com/olemarkus) [#10791](https://github.com/kubernetes/kops/pull/10791)
* Fill Role names in kops-controller-config instead of instance profile names when it is specified [@h3poteto](https://github.com/h3poteto) [#10728](https://github.com/kubernetes/kops/pull/10728)
* Storage: Allow disabling of kOps's management of StorageClasses [@seh](https://github.com/seh) [#10733](https://github.com/kubernetes/kops/pull/10733)
* kubetest2 - Dump all pod logs in addition to host logs [@rifelpet](https://github.com/rifelpet) [#10799](https://github.com/kubernetes/kops/pull/10799)
* Update Docker to v19.03.15 [@hakman](https://github.com/hakman) [#10802](https://github.com/kubernetes/kops/pull/10802)
* Fix LaunchSpec TF output [@hakman](https://github.com/hakman) [#10806](https://github.com/kubernetes/kops/pull/10806)
* Make protokube CP label setting consistent with kops-controller [@olemarkus](https://github.com/olemarkus) [#10780](https://github.com/kubernetes/kops/pull/10780)
* Add deprecation notice for launch templates.  [@bharath-123](https://github.com/bharath-123) [#10809](https://github.com/kubernetes/kops/pull/10809)
* add azure support for internal loadbalancer to k8s api [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10744](https://github.com/kubernetes/kops/pull/10744)
* Allow managed images for Azure instance groups [@NickSchleicher](https://github.com/NickSchleicher) [#10797](https://github.com/kubernetes/kops/pull/10797)
* kubenet containerd: match upstream [@justinsb](https://github.com/justinsb) [#10759](https://github.com/kubernetes/kops/pull/10759)
* kubetest2: Add --host argument [@justinsb](https://github.com/justinsb) [#10814](https://github.com/kubernetes/kops/pull/10814)
* iptables: Use the lock when checking for existing rules [@justinsb](https://github.com/justinsb) [#10812](https://github.com/kubernetes/kops/pull/10812)
* Spotinst: Replace corev1.Taint to fix HCL2 serialization [@liranp](https://github.com/liranp) [#10819](https://github.com/kubernetes/kops/pull/10819)
* Spotinst: Bump the Ocean Controller to 1.0.72 [@liranp](https://github.com/liranp) [#10820](https://github.com/kubernetes/kops/pull/10820)
* Allow to control which subnets and IPs get used for the API loadbalancer [@codablock](https://github.com/codablock) [#10741](https://github.com/kubernetes/kops/pull/10741)
* kubetest2: Call Test, not Execute [@justinsb](https://github.com/justinsb) [#10824](https://github.com/kubernetes/kops/pull/10824)
* Fix kdi 'must specify' error [@olemarkus](https://github.com/olemarkus) [#10825](https://github.com/kubernetes/kops/pull/10825)
* Update aws-sdk-go [@rifelpet](https://github.com/rifelpet) [#10830](https://github.com/kubernetes/kops/pull/10830)
* Use correct tag when creating node labels from azure cloud tags [@NickSchleicher](https://github.com/NickSchleicher) [#10619](https://github.com/kubernetes/kops/pull/10619)
* Precreate the kops-controller DNS name [@rifelpet](https://github.com/rifelpet) [#10833](https://github.com/kubernetes/kops/pull/10833)
* containerd installation: always configure, even if we don't install [@justinsb](https://github.com/justinsb) [#10813](https://github.com/kubernetes/kops/pull/10813)
* Release binaries for protokube and channels [@hakman](https://github.com/hakman) [#10840](https://github.com/kubernetes/kops/pull/10840)
* Release 1.21.0-alpha.1 [@hakman](https://github.com/hakman) [#10841](https://github.com/kubernetes/kops/pull/10841)

## 1.21.0-alpha.1 to 1.21.0-alpha.2

* Release notes for 1.21.0-alpha.1 [@hakman](https://github.com/hakman) [#10844](https://github.com/kubernetes/kops/pull/10844)
* Update mock to v1.21.0-alpha.1 [@hakman](https://github.com/hakman) [#10845](https://github.com/kubernetes/kops/pull/10845)
* Kubetest2 - terraform support [@rifelpet](https://github.com/rifelpet) [#10697](https://github.com/kubernetes/kops/pull/10697)
* Actually enable systemd cgroup for containerd [@codablock](https://github.com/codablock) [#10846](https://github.com/kubernetes/kops/pull/10846)
* Update Go to v1.15.8 [@hakman](https://github.com/hakman) [#10853](https://github.com/kubernetes/kops/pull/10853)
* Add liveness probe for calico-kube-controllers [@hakman](https://github.com/hakman) [#10856](https://github.com/kubernetes/kops/pull/10856)
* Fix OpenStack delete functions [@ottosulin](https://github.com/ottosulin) [#10849](https://github.com/kubernetes/kops/pull/10849)
* Add support for CAS 1.20 + support for disabling CAS for a given IG [@olemarkus](https://github.com/olemarkus) [#10857](https://github.com/kubernetes/kops/pull/10857)
* Bump aws node termination handler to 1.12.0 [@bharath-123](https://github.com/bharath-123) [#10863](https://github.com/kubernetes/kops/pull/10863)
* Kubetest2 - add ginkgo node debug logs [@rifelpet](https://github.com/rifelpet) [#10866](https://github.com/kubernetes/kops/pull/10866)
* K8s Version Updates February 2021 [@MoShitrit](https://github.com/MoShitrit) [#10865](https://github.com/kubernetes/kops/pull/10865)
* Add note about remote identities [@olemarkus](https://github.com/olemarkus) [#10868](https://github.com/kubernetes/kops/pull/10868)
* Bump metrics-server to 0.4.2 [@olemarkus](https://github.com/olemarkus) [#10858](https://github.com/kubernetes/kops/pull/10858)
* kubetest2 - support terraform with `kops create cluster` [@rifelpet](https://github.com/rifelpet) [#10867](https://github.com/kubernetes/kops/pull/10867)
* Add validation for instanceType and ami architecture  [@bharath-123](https://github.com/bharath-123) [#10747](https://github.com/kubernetes/kops/pull/10747)
* Upgrade k8s 1.20 to latest patch version [@MoShitrit](https://github.com/MoShitrit) [#10875](https://github.com/kubernetes/kops/pull/10875)
* Update AWS CNI to latest patch version [@MoShitrit](https://github.com/MoShitrit) [#10876](https://github.com/kubernetes/kops/pull/10876)
* Fixes for 1.21 e2e tests [@olemarkus](https://github.com/olemarkus) [#10879](https://github.com/kubernetes/kops/pull/10879)
* Release notes for 1.19.1 [@justinsb](https://github.com/justinsb) [#10883](https://github.com/kubernetes/kops/pull/10883)
* Improve machine type and image validation [@hakman](https://github.com/hakman) [#10884](https://github.com/kubernetes/kops/pull/10884)
* fix loadBalancerID null pointer [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10886](https://github.com/kubernetes/kops/pull/10886)
* Update Openstack Cloud Go module to v1.20.1 [@bmelbourne](https://github.com/bmelbourne) [#10896](https://github.com/kubernetes/kops/pull/10896)
* Enforce 1.14 deprecation [@olemarkus](https://github.com/olemarkus) [#10897](https://github.com/kubernetes/kops/pull/10897)
* add usage of subnet and routetable shared resources in azure [@ngalantowicz](https://github.com/ngalantowicz) [#10900](https://github.com/kubernetes/kops/pull/10900)
* Update Calico to v3.18.0 [@hakman](https://github.com/hakman) [#10904](https://github.com/kubernetes/kops/pull/10904)
* Adding Elastic IP Allocations to NLB API [@timothyclarke](https://github.com/timothyclarke) [#10872](https://github.com/kubernetes/kops/pull/10872)
* Release notes for 1.20.0-beta.1 [@hakman](https://github.com/hakman) [#10909](https://github.com/kubernetes/kops/pull/10909)
* Update Google Cloud Go module to v0.77.0 [@bmelbourne](https://github.com/bmelbourne) [#10894](https://github.com/kubernetes/kops/pull/10894)
* Add Tagging to Instance Profiles and OIDC Providers [@rifelpet](https://github.com/rifelpet) [#10832](https://github.com/kubernetes/kops/pull/10832)
* AWS LB controller is as of 1.20, not 1.19 [@olemarkus](https://github.com/olemarkus) [#10919](https://github.com/kubernetes/kops/pull/10919)
* Spotinst: Prevent instance groups with the same suffix from being deleted [@liranp](https://github.com/liranp) [#10918](https://github.com/kubernetes/kops/pull/10918)
* add support for azure public loadbalancer [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#10915](https://github.com/kubernetes/kops/pull/10915)
* Fix nil pointer deference for image ID with spotinst [@hakman](https://github.com/hakman) [#10924](https://github.com/kubernetes/kops/pull/10924)
* Update SSH documentation for ubuntu [@jpugliesi](https://github.com/jpugliesi) [#10931](https://github.com/kubernetes/kops/pull/10931)
* Fix no-schedule issue [@christian-schlichtherle](https://github.com/christian-schlichtherle) [#10928](https://github.com/kubernetes/kops/pull/10928)
* Update Controller Runtime Go module to v0.8.2 [@bmelbourne](https://github.com/bmelbourne) [#10914](https://github.com/kubernetes/kops/pull/10914)
* Sort external policies when checking for changes [@hakman](https://github.com/hakman) [#10940](https://github.com/kubernetes/kops/pull/10940)
* Instruct GH to collapse BUILD.bazel diffs by default [@rifelpet](https://github.com/rifelpet) [#10912](https://github.com/kubernetes/kops/pull/10912)
* Further improve cloudLabel validation [@olemarkus](https://github.com/olemarkus) [#10910](https://github.com/kubernetes/kops/pull/10910)
* Add a standardised set of labels on all resources [@olemarkus](https://github.com/olemarkus) [#10796](https://github.com/kubernetes/kops/pull/10796)
* Bump external-dns to 0.7.6 [@olemarkus](https://github.com/olemarkus) [#10946](https://github.com/kubernetes/kops/pull/10946)
* Update etcd-manager to 3.0.20210228 [@justinsb](https://github.com/justinsb) [#10949](https://github.com/kubernetes/kops/pull/10949)
* gce doesn't suffix the IG names with ClusterName [@olemarkus](https://github.com/olemarkus) [#10944](https://github.com/kubernetes/kops/pull/10944)
* Add AWS Transit Gateway support [@rifelpet](https://github.com/rifelpet) [#10948](https://github.com/kubernetes/kops/pull/10948)
* Fix node label conversion in Azure [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#10935](https://github.com/kubernetes/kops/pull/10935)
* Spotinst: Bump the Ocean Controller to 1.0.73 [@liranp](https://github.com/liranp) [#10960](https://github.com/kubernetes/kops/pull/10960)
* Spotinst: Don't skip LB attachments when SpotinstHybrid is enabled [@liranp](https://github.com/liranp) [#10961](https://github.com/kubernetes/kops/pull/10961)
* Add explicit RBAC permissions for finalizers subresources [@olemarkus](https://github.com/olemarkus) [#10966](https://github.com/kubernetes/kops/pull/10966)
* Fix typos in docs/getting_started [@roim](https://github.com/roim) [#10921](https://github.com/kubernetes/kops/pull/10921)
* Add support for CPU Credits on AWS t2 and t3 instance families [@rifelpet](https://github.com/rifelpet) [#10934](https://github.com/kubernetes/kops/pull/10934)
* Add support for enable-cadvisor-json-endpoints with Kubelet [@adrianmoisey](https://github.com/adrianmoisey) [#10957](https://github.com/kubernetes/kops/pull/10957)
* Exclude CP nodes from load balancers [@olemarkus](https://github.com/olemarkus) [#10945](https://github.com/kubernetes/kops/pull/10945)
* Update k8s.io Go modules to v0.20.4 [@bmelbourne](https://github.com/bmelbourne) [#10965](https://github.com/kubernetes/kops/pull/10965)
* Update Go to v1.16 [@bmelbourne](https://github.com/bmelbourne) [#10892](https://github.com/kubernetes/kops/pull/10892)
* Add a note about informal office hours [@olemarkus](https://github.com/olemarkus) [#10650](https://github.com/kubernetes/kops/pull/10650)
* Removing duplicate local and output values in terraform(#10786) [@mmerrill3](https://github.com/mmerrill3) [#10978](https://github.com/kubernetes/kops/pull/10978)
* Add CloudLabels as --extra-tags to aws-ebs-csi driver [@codablock](https://github.com/codablock) [#10976](https://github.com/kubernetes/kops/pull/10976)
* Use internal api url for jwks [@olemarkus](https://github.com/olemarkus) [#10888](https://github.com/kubernetes/kops/pull/10888)
* Disable Calico Prometheus metrics by default [@hakman](https://github.com/hakman) [#10982](https://github.com/kubernetes/kops/pull/10982)
* Add etcd-manager discoveryPollInterval option [@ottosulin](https://github.com/ottosulin) [#10975](https://github.com/kubernetes/kops/pull/10975)
* Remove manually added labels from addons [@hakman](https://github.com/hakman) [#10987](https://github.com/kubernetes/kops/pull/10987)
* Fix kops-controller rbac due to leader election change [@olemarkus](https://github.com/olemarkus) [#10988](https://github.com/kubernetes/kops/pull/10988)
* Various cleanups around apply_cluster and awsmodel [@olemarkus](https://github.com/olemarkus) [#10579](https://github.com/kubernetes/kops/pull/10579)
* Fix very minor formatting typos in docs/manifests_and_customizing_via_api [@vitaliyf](https://github.com/vitaliyf) [#10990](https://github.com/kubernetes/kops/pull/10990)
* Run protokube as a systemd service [@bharath-123](https://github.com/bharath-123),[@hakman](https://github.com/hakman) [#10574](https://github.com/kubernetes/kops/pull/10574)
* kubetest2 - don't overwrite create args that use equals signs [@rifelpet](https://github.com/rifelpet) [#10994](https://github.com/kubernetes/kops/pull/10994)
* Remove support for launch configurations [@bharath-123](https://github.com/bharath-123) [#10937](https://github.com/kubernetes/kops/pull/10937)
* Use exponential backoff for DNS updates [@hakman](https://github.com/hakman) [#10996](https://github.com/kubernetes/kops/pull/10996)
* Storage: Amend default choice for StorageClass management to honor a specified OpenStack-related value [@seh](https://github.com/seh) [#11002](https://github.com/kubernetes/kops/pull/11002)
* Add to 1.21 release notes [@bharath-123](https://github.com/bharath-123) [#11004](https://github.com/kubernetes/kops/pull/11004)
* Kubetest2 - Add support for publishing the kops version marker [@rifelpet](https://github.com/rifelpet) [#11006](https://github.com/kubernetes/kops/pull/11006)
* Kubetest2 - Fix kops' --kubernetes-version with k8s version markers [@rifelpet](https://github.com/rifelpet) [#11007](https://github.com/kubernetes/kops/pull/11007)
* Don't build kops during periodic upgrade tests [@rifelpet](https://github.com/rifelpet) [#11005](https://github.com/kubernetes/kops/pull/11005)
* Remove extraneous field from integration test [@rifelpet](https://github.com/rifelpet) [#11010](https://github.com/kubernetes/kops/pull/11010)
* Remove trailing newline from kubernetes version marker [@rifelpet](https://github.com/rifelpet) [#11011](https://github.com/kubernetes/kops/pull/11011)
* aws: Graceful handling of EC2 detach errors [@hwoarang](https://github.com/hwoarang) [#10740](https://github.com/kubernetes/kops/pull/10740)
* Kubetest2 - use same kops binary for all commands in upgrade scenario [@rifelpet](https://github.com/rifelpet) [#11017](https://github.com/kubernetes/kops/pull/11017)
* Update Calico to v3.18.1 [@hakman](https://github.com/hakman) [#11018](https://github.com/kubernetes/kops/pull/11018)
* Increase route53 retry count from 3 to 5 [@rifelpet](https://github.com/rifelpet) [#11020](https://github.com/kubernetes/kops/pull/11020)
* Spotinst: Add support for block device mappings in Ocean Launch Spec [@liranp](https://github.com/liranp) [#11009](https://github.com/kubernetes/kops/pull/11009)
* Allow cilium 1.10 [@olemarkus](https://github.com/olemarkus) [#11026](https://github.com/kubernetes/kops/pull/11026)
* Fix rendering of multiple Docker insecure registries [@hakman](https://github.com/hakman) [#11027](https://github.com/kubernetes/kops/pull/11027)
* azure: fix null pointer when updating in place cluster [@collin-woodruff-t1cg](https://github.com/collin-woodruff-t1cg) [#11015](https://github.com/kubernetes/kops/pull/11015)
* Release notes for 1.20.0-beta.2 [@hakman](https://github.com/hakman) [#11034](https://github.com/kubernetes/kops/pull/11034)
* Update k8s dependencies to v1.21.0-beta.1 [@hakman](https://github.com/hakman) [#11013](https://github.com/kubernetes/kops/pull/11013)
* Trim space on kops version markers [@rifelpet](https://github.com/rifelpet) [#11037](https://github.com/kubernetes/kops/pull/11037)
* Honor OS update policy at InstanceGroup level too [@seh](https://github.com/seh) [#10913](https://github.com/kubernetes/kops/pull/10913)
* Update Go to v1.16.2 [@hakman](https://github.com/hakman) [#11039](https://github.com/kubernetes/kops/pull/11039)
* Create an environment file for kops-configuration systemd process [@bharath-123](https://github.com/bharath-123) [#11042](https://github.com/kubernetes/kops/pull/11042)
* Improve instance type validation error message [@bharath-123](https://github.com/bharath-123) [#11043](https://github.com/kubernetes/kops/pull/11043)
* Revert upgrade script to build kops [@rifelpet](https://github.com/rifelpet) [#11044](https://github.com/kubernetes/kops/pull/11044)
* cluster validation - allow flapping of validation errors [@rifelpet](https://github.com/rifelpet) [#11049](https://github.com/kubernetes/kops/pull/11049)
* Update Terraform to v0.14.8 [@bmelbourne](https://github.com/bmelbourne) [#11051](https://github.com/kubernetes/kops/pull/11051)
* Cleanup some nodeup & protokube logging [@rifelpet](https://github.com/rifelpet) [#11052](https://github.com/kubernetes/kops/pull/11052)
* Update Go modules to latest versions [@bmelbourne](https://github.com/bmelbourne) [#11047](https://github.com/kubernetes/kops/pull/11047)
* Add channels entries for image architecture [@hakman](https://github.com/hakman) [#11046](https://github.com/kubernetes/kops/pull/11046)
* fix CNI bin path in troubleshoot.md [@adrianmester](https://github.com/adrianmester) [#11061](https://github.com/kubernetes/kops/pull/11061)
* Kubetest2 - Add GCE default SSH key values from prow jobs [@rifelpet](https://github.com/rifelpet) [#11065](https://github.com/kubernetes/kops/pull/11065)
* correct a word for readme [@yojay11717](https://github.com/yojay11717) [#11066](https://github.com/kubernetes/kops/pull/11066)
* Update Bazel to v3.5.0 [@hakman](https://github.com/hakman) [#11041](https://github.com/kubernetes/kops/pull/11041)
* Install bazelisk before pushing images [@hakman](https://github.com/hakman) [#11067](https://github.com/kubernetes/kops/pull/11067)
* Kubetest2 - Add boskos for GCE support [@rifelpet](https://github.com/rifelpet) [#11070](https://github.com/kubernetes/kops/pull/11070)
* Download kubectl to /opt/kops/bin on Flatcar OS [@rifelpet](https://github.com/rifelpet) [#11054](https://github.com/kubernetes/kops/pull/11054)
* Kubetest2 - initialize boskos heartbeat channel [@rifelpet](https://github.com/rifelpet) [#11073](https://github.com/kubernetes/kops/pull/11073)
* Instance roles for service accounts (IRSA) contd [@rifelpet](https://github.com/rifelpet),[@olemarkus](https://github.com/olemarkus) [#10756](https://github.com/kubernetes/kops/pull/10756)
* Kubetest2 - add more validation time for --target terraform [@rifelpet](https://github.com/rifelpet) [#11077](https://github.com/kubernetes/kops/pull/11077)
* Fix GCE channels version constraints [@rifelpet](https://github.com/rifelpet) [#11076](https://github.com/kubernetes/kops/pull/11076)
* Update k8s versions with March 2021 releases [@MoShitrit](https://github.com/MoShitrit) [#11075](https://github.com/kubernetes/kops/pull/11075)
* Upgrade AWS CNI to version 1.7.10 [@MoShitrit](https://github.com/MoShitrit) [#11078](https://github.com/kubernetes/kops/pull/11078)
* Improve error messages around PublicJWKS [@justinsb](https://github.com/justinsb) [#11085](https://github.com/kubernetes/kops/pull/11085)
* Don't add control-plane DNS permissions with UseServiceAccountIAM [@justinsb](https://github.com/justinsb) [#11086](https://github.com/kubernetes/kops/pull/11086)
* Ensure a publicdatastore exists for jwks and that it can only be s3 [@olemarkus](https://github.com/olemarkus) [#11081](https://github.com/kubernetes/kops/pull/11081)
* Apiserver nodes [@olemarkus](https://github.com/olemarkus) [#10722](https://github.com/kubernetes/kops/pull/10722)
* fix(docs): cpuCFSQuotaPeriod needs a feature gate [@danmx](https://github.com/danmx) [#11071](https://github.com/kubernetes/kops/pull/11071)
* Update Ubuntu 20.04 to latest AMI [@bmelbourne](https://github.com/bmelbourne) [#11083](https://github.com/kubernetes/kops/pull/11083)
* Re-add integration tests for jwks [@justinsb](https://github.com/justinsb) [#11087](https://github.com/kubernetes/kops/pull/11087)
* Replace go-bindata with go:embed [@rifelpet](https://github.com/rifelpet) [#11089](https://github.com/kubernetes/kops/pull/11089)
* Dns controller fixes [@olemarkus](https://github.com/olemarkus) [#11069](https://github.com/kubernetes/kops/pull/11069)
* Remove unused RoleLabelName16 [@justinsb](https://github.com/justinsb) [#11097](https://github.com/kubernetes/kops/pull/11097)
* Add additional IOPS validation for AWS EBS gp3 volumes [@lichuan0620](https://github.com/lichuan0620) [#10843](https://github.com/kubernetes/kops/pull/10843)
* Update google SDK libraries [@justinsb](https://github.com/justinsb) [#11096](https://github.com/kubernetes/kops/pull/11096)
* Add values page [@justinsb](https://github.com/justinsb) [#11094](https://github.com/kubernetes/kops/pull/11094)
* Deeper validation in dns controller tests [@justinsb](https://github.com/justinsb) [#11095](https://github.com/kubernetes/kops/pull/11095)
* Ensure protokube can connect to kube-apiserver before starting the sync loop [@olemarkus](https://github.com/olemarkus) [#11093](https://github.com/kubernetes/kops/pull/11093)
* Remove dbus dependency [@bharath-123](https://github.com/bharath-123) [#11082](https://github.com/kubernetes/kops/pull/11082)
* Have nodeup retry kops-controller bootstrapping sooner if DNS isn't setup [@rifelpet](https://github.com/rifelpet) [#11101](https://github.com/kubernetes/kops/pull/11101)
* Update AWS zones used by e2e tests [@rifelpet](https://github.com/rifelpet) [#11103](https://github.com/kubernetes/kops/pull/11103)
* Add docs about dedicated apiserver ndoes [@olemarkus](https://github.com/olemarkus) [#11090](https://github.com/kubernetes/kops/pull/11090)
* Put awslbcontroller on the control-plane [@olemarkus](https://github.com/olemarkus) [#11091](https://github.com/kubernetes/kops/pull/11091)
* Release 1.21.0 alpha.2 [@hakman](https://github.com/hakman) [#11109](https://github.com/kubernetes/kops/pull/11109)

## 1.21.0-alpha.2 to 1.21.0-alpha.3

* Release notes for 1.21.0-alpha.2 [@hakman](https://github.com/hakman) [#11111](https://github.com/kubernetes/kops/pull/11111)
* Update release process docs [@hakman](https://github.com/hakman) [#11112](https://github.com/kubernetes/kops/pull/11112)
* Use "tag on create" for EIPs, NLBs, and TargetGroups [@rifelpet](https://github.com/rifelpet) [#11107](https://github.com/kubernetes/kops/pull/11107)
* Load env vars from file for kops-configuration service [@hakman](https://github.com/hakman) [#11114](https://github.com/kubernetes/kops/pull/11114)
* Update containerd to v1.3.10/v1.4.4 [@bmelbourne](https://github.com/bmelbourne) [#11084](https://github.com/kubernetes/kops/pull/11084)
* [DigitalOcean] Fix DO Tag issue [@srikiz](https://github.com/srikiz) [#11102](https://github.com/kubernetes/kops/pull/11102)
* Kubetest2 - Setup SSH keys for GCE [@rifelpet](https://github.com/rifelpet) [#11123](https://github.com/kubernetes/kops/pull/11123)
* Validate that kube-apiserver has the necessary authz modes set [@olemarkus](https://github.com/olemarkus) [#11127](https://github.com/kubernetes/kops/pull/11127)
* Remove instance-selector label [@bharath-123](https://github.com/bharath-123) [#11048](https://github.com/kubernetes/kops/pull/11048)
* Kubetest2 - fix temp directory created for GCE SSH keys [@rifelpet](https://github.com/rifelpet) [#11133](https://github.com/kubernetes/kops/pull/11133)
* replace hard coded aws region checks with aws sdk calls [@guydog28](https://github.com/guydog28) [#11119](https://github.com/kubernetes/kops/pull/11119)
* kubetest2 - Specify GCE network name  [@rifelpet](https://github.com/rifelpet) [#11139](https://github.com/kubernetes/kops/pull/11139)
* Update protokube systemd unit docs link [@rifelpet](https://github.com/rifelpet) [#11138](https://github.com/kubernetes/kops/pull/11138)
* Add scaleDownDelayAfterAdd to clusterAutoscaler spec [@jurriaanpro](https://github.com/jurriaanpro) [#11140](https://github.com/kubernetes/kops/pull/11140)
* Update cluster_spec.md [@carnivorelogic](https://github.com/carnivorelogic) [#11142](https://github.com/kubernetes/kops/pull/11142)
* minor protokube code clean up [@bharath-123](https://github.com/bharath-123) [#11143](https://github.com/kubernetes/kops/pull/11143)
* Pass ctx to drain helper [@olemarkus](https://github.com/olemarkus) [#11146](https://github.com/kubernetes/kops/pull/11146)
* Change registrable domains to placeholders [@lukehinds](https://github.com/lukehinds) [#11147](https://github.com/kubernetes/kops/pull/11147)
* Add tags to instance profile and OIDC provider terraform resources [@rifelpet](https://github.com/rifelpet) [#11149](https://github.com/kubernetes/kops/pull/11149)
* Clarify release notes around exporting kubeconfig [@justinsb](https://github.com/justinsb) [#11154](https://github.com/kubernetes/kops/pull/11154)
* Expand flag help on --user flags [@justinsb](https://github.com/justinsb) [#11153](https://github.com/kubernetes/kops/pull/11153)
* Update Getting Started AWS guide [@allir](https://github.com/allir) [#11150](https://github.com/kubernetes/kops/pull/11150)
* fix the mistake link in addons.md [@maoyangLiu](https://github.com/maoyangLiu) [#11151](https://github.com/kubernetes/kops/pull/11151)
* cloudbuild: capture some hashes [@justinsb](https://github.com/justinsb) [#11159](https://github.com/kubernetes/kops/pull/11159)
* Only update kops-controller pods on deletion [@olemarkus](https://github.com/olemarkus) [#10871](https://github.com/kubernetes/kops/pull/10871)
* Side load images also on apiserver [@olemarkus](https://github.com/olemarkus) [#11156](https://github.com/kubernetes/kops/pull/11156)
* Add an option to skip NTP installation [@kenji-cloudnatix](https://github.com/kenji-cloudnatix) [#11160](https://github.com/kubernetes/kops/pull/11160)
* kubetest2 - Pass GOPATH when building kops [@rifelpet](https://github.com/rifelpet) [#11167](https://github.com/kubernetes/kops/pull/11167)
* Filter kOps NatGateways from route table [@zetaab](https://github.com/zetaab) [#11169](https://github.com/kubernetes/kops/pull/11169)
* Bump k8s deps to 1.21-rc.0 [@olemarkus](https://github.com/olemarkus) [#11168](https://github.com/kubernetes/kops/pull/11168)
* Allow setting dedicated apiserver node count from create cluster cmd [@olemarkus](https://github.com/olemarkus) [#11152](https://github.com/kubernetes/kops/pull/11152)
* Update Go to v1.16.3 [@bmelbourne](https://github.com/bmelbourne) [#11174](https://github.com/kubernetes/kops/pull/11174)
* Add integration test for aws lb controller [@olemarkus](https://github.com/olemarkus) [#11175](https://github.com/kubernetes/kops/pull/11175)
* Enable use of irsa for aws load balancer controller [@olemarkus](https://github.com/olemarkus) [#11088](https://github.com/kubernetes/kops/pull/11088)
* Increase timeout and update images for postsubmit job [@rifelpet](https://github.com/rifelpet) [#11177](https://github.com/kubernetes/kops/pull/11177)
* Update Go modules to latest versions [@bmelbourne](https://github.com/bmelbourne) [#11176](https://github.com/kubernetes/kops/pull/11176)
* Kubetest2 - Add flag to expose cluster validation wait time [@rifelpet](https://github.com/rifelpet) [#11178](https://github.com/kubernetes/kops/pull/11178)
* Spotinst: Use BDM to configure the root volume size at VNG level [@liranp](https://github.com/liranp) [#11179](https://github.com/kubernetes/kops/pull/11179)
* Spotinst: Configure headroom resources only at the VNG level [@liranp](https://github.com/liranp) [#11181](https://github.com/kubernetes/kops/pull/11181)
* Update k8s dependencies to v1.21.0 [@hakman](https://github.com/hakman) [#11188](https://github.com/kubernetes/kops/pull/11188)
* Release notes for 1.19.2 [@justinsb](https://github.com/justinsb) [#11193](https://github.com/kubernetes/kops/pull/11193)
* Update node local dns cache [@zetaab](https://github.com/zetaab) [#11057](https://github.com/kubernetes/kops/pull/11057)
* Update cilium.md [@recollir](https://github.com/recollir) [#11189](https://github.com/kubernetes/kops/pull/11189)
* Release notes for 1.20.0 [@justinsb](https://github.com/justinsb) [#11196](https://github.com/kubernetes/kops/pull/11196)
* Docs: Remove 'prerelease' warning from 1.20 [@justinsb](https://github.com/justinsb) [#11198](https://github.com/kubernetes/kops/pull/11198)
* Kubetest2 - Create project-specific state store buckets in GCP [@rifelpet](https://github.com/rifelpet) [#11200](https://github.com/kubernetes/kops/pull/11200)
* Update release compatibility matrix [@johngmyers](https://github.com/johngmyers) [#11201](https://github.com/kubernetes/kops/pull/11201)
* Update integration tests to k8s v1.21.0 [@bmelbourne](https://github.com/bmelbourne) [#11206](https://github.com/kubernetes/kops/pull/11206)
* Kubetest2 - Set KOPS_BASE_URL to --build's stage location [@rifelpet](https://github.com/rifelpet) [#11210](https://github.com/kubernetes/kops/pull/11210)
* Update Docker to v20.10.5 [@bmelbourne](https://github.com/bmelbourne) [#11195](https://github.com/kubernetes/kops/pull/11195)
* Rename the service account key [@johngmyers](https://github.com/johngmyers) [#11207](https://github.com/kubernetes/kops/pull/11207)
* Update go deps [@zetaab](https://github.com/zetaab) [#11208](https://github.com/kubernetes/kops/pull/11208)
* Kubetest2 - detect errors creating GCS bucket [@rifelpet](https://github.com/rifelpet) [#11212](https://github.com/kubernetes/kops/pull/11212)
* Kubetest2 - Ensure the bucket path is the final gsutil arg [@rifelpet](https://github.com/rifelpet) [#11215](https://github.com/kubernetes/kops/pull/11215)
* Update IG tutorial for per-AZ node groups [@rifelpet](https://github.com/rifelpet) [#11218](https://github.com/kubernetes/kops/pull/11218)
* Use "string" for architecture type in ChannelRecommendedImage [@hakman](https://github.com/hakman) [#11220](https://github.com/kubernetes/kops/pull/11220)
* Always secure api -> kubelet communication [@olemarkus](https://github.com/olemarkus) [#11185](https://github.com/kubernetes/kops/pull/11185)
* Fix etcd volume validation logic [@hakman](https://github.com/hakman) [#11225](https://github.com/kubernetes/kops/pull/11225)
* Replace k8s.io/utils/mount with k8s.io/mount-utils [@hakman](https://github.com/hakman) [#11229](https://github.com/kubernetes/kops/pull/11229)
* Release 1.21.0-alpha.3 [@hakman](https://github.com/hakman) [#11231](https://github.com/kubernetes/kops/pull/11231)
