locals {
  bastion_autoscaling_group_ids     = [aws_autoscaling_group.bastion-privateflannel-example-com.id]
  bastion_security_group_ids        = [aws_security_group.bastion-privateflannel-example-com.id]
  bastions_role_arn                 = aws_iam_role.bastions-privateflannel-example-com.arn
  bastions_role_name                = aws_iam_role.bastions-privateflannel-example-com.name
  cluster_name                      = "privateflannel.example.com"
  master_autoscaling_group_ids      = [aws_autoscaling_group.master-us-test-1a-masters-privateflannel-example-com.id]
  master_security_group_ids         = [aws_security_group.masters-privateflannel-example-com.id]
  masters_role_arn                  = aws_iam_role.masters-privateflannel-example-com.arn
  masters_role_name                 = aws_iam_role.masters-privateflannel-example-com.name
  node_autoscaling_group_ids        = [aws_autoscaling_group.nodes-privateflannel-example-com.id]
  node_security_group_ids           = [aws_security_group.nodes-privateflannel-example-com.id]
  node_subnet_ids                   = [aws_subnet.us-test-1a-privateflannel-example-com.id]
  nodes_role_arn                    = aws_iam_role.nodes-privateflannel-example-com.arn
  nodes_role_name                   = aws_iam_role.nodes-privateflannel-example-com.name
  region                            = "us-test-1"
  route_table_private-us-test-1a_id = aws_route_table.private-us-test-1a-privateflannel-example-com.id
  route_table_public_id             = aws_route_table.privateflannel-example-com.id
  subnet_us-test-1a_id              = aws_subnet.us-test-1a-privateflannel-example-com.id
  subnet_utility-us-test-1a_id      = aws_subnet.utility-us-test-1a-privateflannel-example-com.id
  vpc_cidr_block                    = aws_vpc.privateflannel-example-com.cidr_block
  vpc_id                            = aws_vpc.privateflannel-example-com.id
}

output "bastion_autoscaling_group_ids" {
  value = [aws_autoscaling_group.bastion-privateflannel-example-com.id]
}

output "bastion_security_group_ids" {
  value = [aws_security_group.bastion-privateflannel-example-com.id]
}

output "bastions_role_arn" {
  value = aws_iam_role.bastions-privateflannel-example-com.arn
}

output "bastions_role_name" {
  value = aws_iam_role.bastions-privateflannel-example-com.name
}

output "cluster_name" {
  value = "privateflannel.example.com"
}

output "master_autoscaling_group_ids" {
  value = [aws_autoscaling_group.master-us-test-1a-masters-privateflannel-example-com.id]
}

output "master_security_group_ids" {
  value = [aws_security_group.masters-privateflannel-example-com.id]
}

output "masters_role_arn" {
  value = aws_iam_role.masters-privateflannel-example-com.arn
}

output "masters_role_name" {
  value = aws_iam_role.masters-privateflannel-example-com.name
}

output "node_autoscaling_group_ids" {
  value = [aws_autoscaling_group.nodes-privateflannel-example-com.id]
}

output "node_security_group_ids" {
  value = [aws_security_group.nodes-privateflannel-example-com.id]
}

output "node_subnet_ids" {
  value = [aws_subnet.us-test-1a-privateflannel-example-com.id]
}

output "nodes_role_arn" {
  value = aws_iam_role.nodes-privateflannel-example-com.arn
}

output "nodes_role_name" {
  value = aws_iam_role.nodes-privateflannel-example-com.name
}

output "region" {
  value = "us-test-1"
}

output "route_table_private-us-test-1a_id" {
  value = aws_route_table.private-us-test-1a-privateflannel-example-com.id
}

output "route_table_public_id" {
  value = aws_route_table.privateflannel-example-com.id
}

output "subnet_us-test-1a_id" {
  value = aws_subnet.us-test-1a-privateflannel-example-com.id
}

output "subnet_utility-us-test-1a_id" {
  value = aws_subnet.utility-us-test-1a-privateflannel-example-com.id
}

output "vpc_cidr_block" {
  value = aws_vpc.privateflannel-example-com.cidr_block
}

output "vpc_id" {
  value = aws_vpc.privateflannel-example-com.id
}

provider "aws" {
  region = "us-test-1"
}

resource "aws_autoscaling_group" "bastion-privateflannel-example-com" {
  enabled_metrics = ["GroupDesiredCapacity", "GroupInServiceInstances", "GroupMaxSize", "GroupMinSize", "GroupPendingInstances", "GroupStandbyInstances", "GroupTerminatingInstances", "GroupTotalInstances"]
  launch_template {
    id      = aws_launch_template.bastion-privateflannel-example-com.id
    version = aws_launch_template.bastion-privateflannel-example-com.latest_version
  }
  load_balancers      = [aws_elb.bastion-privateflannel-example-com.id]
  max_size            = 1
  metrics_granularity = "1Minute"
  min_size            = 1
  name                = "bastion.privateflannel.example.com"
  tag {
    key                 = "KubernetesCluster"
    propagate_at_launch = true
    value               = "privateflannel.example.com"
  }
  tag {
    key                 = "Name"
    propagate_at_launch = true
    value               = "bastion.privateflannel.example.com"
  }
  tag {
    key                 = "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"
    propagate_at_launch = true
    value               = "node"
  }
  tag {
    key                 = "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node"
    propagate_at_launch = true
    value               = ""
  }
  tag {
    key                 = "k8s.io/role/bastion"
    propagate_at_launch = true
    value               = "1"
  }
  tag {
    key                 = "kops.k8s.io/instancegroup"
    propagate_at_launch = true
    value               = "bastion"
  }
  tag {
    key                 = "kubernetes.io/cluster/privateflannel.example.com"
    propagate_at_launch = true
    value               = "owned"
  }
  vpc_zone_identifier = [aws_subnet.utility-us-test-1a-privateflannel-example-com.id]
}

resource "aws_autoscaling_group" "master-us-test-1a-masters-privateflannel-example-com" {
  enabled_metrics = ["GroupDesiredCapacity", "GroupInServiceInstances", "GroupMaxSize", "GroupMinSize", "GroupPendingInstances", "GroupStandbyInstances", "GroupTerminatingInstances", "GroupTotalInstances"]
  launch_template {
    id      = aws_launch_template.master-us-test-1a-masters-privateflannel-example-com.id
    version = aws_launch_template.master-us-test-1a-masters-privateflannel-example-com.latest_version
  }
  load_balancers      = [aws_elb.api-privateflannel-example-com.id]
  max_size            = 1
  metrics_granularity = "1Minute"
  min_size            = 1
  name                = "master-us-test-1a.masters.privateflannel.example.com"
  tag {
    key                 = "KubernetesCluster"
    propagate_at_launch = true
    value               = "privateflannel.example.com"
  }
  tag {
    key                 = "Name"
    propagate_at_launch = true
    value               = "master-us-test-1a.masters.privateflannel.example.com"
  }
  tag {
    key                 = "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"
    propagate_at_launch = true
    value               = "master"
  }
  tag {
    key                 = "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/control-plane"
    propagate_at_launch = true
    value               = ""
  }
  tag {
    key                 = "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/master"
    propagate_at_launch = true
    value               = ""
  }
  tag {
    key                 = "k8s.io/role/master"
    propagate_at_launch = true
    value               = "1"
  }
  tag {
    key                 = "kops.k8s.io/instancegroup"
    propagate_at_launch = true
    value               = "master-us-test-1a"
  }
  tag {
    key                 = "kubernetes.io/cluster/privateflannel.example.com"
    propagate_at_launch = true
    value               = "owned"
  }
  vpc_zone_identifier = [aws_subnet.us-test-1a-privateflannel-example-com.id]
}

resource "aws_autoscaling_group" "nodes-privateflannel-example-com" {
  enabled_metrics = ["GroupDesiredCapacity", "GroupInServiceInstances", "GroupMaxSize", "GroupMinSize", "GroupPendingInstances", "GroupStandbyInstances", "GroupTerminatingInstances", "GroupTotalInstances"]
  launch_template {
    id      = aws_launch_template.nodes-privateflannel-example-com.id
    version = aws_launch_template.nodes-privateflannel-example-com.latest_version
  }
  max_size            = 2
  metrics_granularity = "1Minute"
  min_size            = 2
  name                = "nodes.privateflannel.example.com"
  tag {
    key                 = "KubernetesCluster"
    propagate_at_launch = true
    value               = "privateflannel.example.com"
  }
  tag {
    key                 = "Name"
    propagate_at_launch = true
    value               = "nodes.privateflannel.example.com"
  }
  tag {
    key                 = "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"
    propagate_at_launch = true
    value               = "node"
  }
  tag {
    key                 = "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node"
    propagate_at_launch = true
    value               = ""
  }
  tag {
    key                 = "k8s.io/role/node"
    propagate_at_launch = true
    value               = "1"
  }
  tag {
    key                 = "kops.k8s.io/instancegroup"
    propagate_at_launch = true
    value               = "nodes"
  }
  tag {
    key                 = "kubernetes.io/cluster/privateflannel.example.com"
    propagate_at_launch = true
    value               = "owned"
  }
  vpc_zone_identifier = [aws_subnet.us-test-1a-privateflannel-example-com.id]
}

resource "aws_ebs_volume" "us-test-1a-etcd-events-privateflannel-example-com" {
  availability_zone = "us-test-1a"
  encrypted         = false
  iops              = 3000
  size              = 20
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "us-test-1a.etcd-events.privateflannel.example.com"
    "k8s.io/etcd/events"                               = "us-test-1a/us-test-1a"
    "k8s.io/role/master"                               = "1"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  throughput = 125
  type       = "gp3"
}

resource "aws_ebs_volume" "us-test-1a-etcd-main-privateflannel-example-com" {
  availability_zone = "us-test-1a"
  encrypted         = false
  iops              = 3000
  size              = 20
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "us-test-1a.etcd-main.privateflannel.example.com"
    "k8s.io/etcd/main"                                 = "us-test-1a/us-test-1a"
    "k8s.io/role/master"                               = "1"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  throughput = 125
  type       = "gp3"
}

resource "aws_eip" "us-test-1a-privateflannel-example-com" {
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "us-test-1a.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  vpc = true
}

resource "aws_elb" "api-privateflannel-example-com" {
  cross_zone_load_balancing = false
  health_check {
    healthy_threshold   = 2
    interval            = 10
    target              = "SSL:443"
    timeout             = 5
    unhealthy_threshold = 2
  }
  idle_timeout = 300
  listener {
    instance_port     = 443
    instance_protocol = "TCP"
    lb_port           = 443
    lb_protocol       = "TCP"
  }
  name            = "api-privateflannel-exampl-hsu11v"
  security_groups = [aws_security_group.api-elb-privateflannel-example-com.id]
  subnets         = [aws_subnet.utility-us-test-1a-privateflannel-example-com.id]
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "api.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_elb" "bastion-privateflannel-example-com" {
  health_check {
    healthy_threshold   = 2
    interval            = 10
    target              = "TCP:22"
    timeout             = 5
    unhealthy_threshold = 2
  }
  idle_timeout = 300
  listener {
    instance_port     = 22
    instance_protocol = "TCP"
    lb_port           = 22
    lb_protocol       = "TCP"
  }
  name            = "bastion-privateflannel-ex-753531"
  security_groups = [aws_security_group.bastion-elb-privateflannel-example-com.id]
  subnets         = [aws_subnet.utility-us-test-1a-privateflannel-example-com.id]
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "bastion.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_iam_instance_profile" "bastions-privateflannel-example-com" {
  name = "bastions.privateflannel.example.com"
  role = aws_iam_role.bastions-privateflannel-example-com.name
}

resource "aws_iam_instance_profile" "masters-privateflannel-example-com" {
  name = "masters.privateflannel.example.com"
  role = aws_iam_role.masters-privateflannel-example-com.name
}

resource "aws_iam_instance_profile" "nodes-privateflannel-example-com" {
  name = "nodes.privateflannel.example.com"
  role = aws_iam_role.nodes-privateflannel-example-com.name
}

resource "aws_iam_role_policy" "bastions-privateflannel-example-com" {
  name   = "bastions.privateflannel.example.com"
  policy = file("${path.module}/data/aws_iam_role_policy_bastions.privateflannel.example.com_policy")
  role   = aws_iam_role.bastions-privateflannel-example-com.name
}

resource "aws_iam_role_policy" "masters-privateflannel-example-com" {
  name   = "masters.privateflannel.example.com"
  policy = file("${path.module}/data/aws_iam_role_policy_masters.privateflannel.example.com_policy")
  role   = aws_iam_role.masters-privateflannel-example-com.name
}

resource "aws_iam_role_policy" "nodes-privateflannel-example-com" {
  name   = "nodes.privateflannel.example.com"
  policy = file("${path.module}/data/aws_iam_role_policy_nodes.privateflannel.example.com_policy")
  role   = aws_iam_role.nodes-privateflannel-example-com.name
}

resource "aws_iam_role" "bastions-privateflannel-example-com" {
  assume_role_policy = file("${path.module}/data/aws_iam_role_bastions.privateflannel.example.com_policy")
  name               = "bastions.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "bastions.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_iam_role" "masters-privateflannel-example-com" {
  assume_role_policy = file("${path.module}/data/aws_iam_role_masters.privateflannel.example.com_policy")
  name               = "masters.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "masters.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_iam_role" "nodes-privateflannel-example-com" {
  assume_role_policy = file("${path.module}/data/aws_iam_role_nodes.privateflannel.example.com_policy")
  name               = "nodes.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "nodes.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_internet_gateway" "privateflannel-example-com" {
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_key_pair" "kubernetes-privateflannel-example-com-c4a6ed9aa889b9e2c39cd663eb9c7157" {
  key_name   = "kubernetes.privateflannel.example.com-c4:a6:ed:9a:a8:89:b9:e2:c3:9c:d6:63:eb:9c:71:57"
  public_key = file("${path.module}/data/aws_key_pair_kubernetes.privateflannel.example.com-c4a6ed9aa889b9e2c39cd663eb9c7157_public_key")
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_launch_template" "bastion-privateflannel-example-com" {
  block_device_mappings {
    device_name = "/dev/xvda"
    ebs {
      delete_on_termination = true
      encrypted             = true
      iops                  = 3000
      throughput            = 125
      volume_size           = 32
      volume_type           = "gp3"
    }
  }
  iam_instance_profile {
    name = aws_iam_instance_profile.bastions-privateflannel-example-com.id
  }
  image_id      = "ami-12345678"
  instance_type = "t2.micro"
  key_name      = aws_key_pair.kubernetes-privateflannel-example-com-c4a6ed9aa889b9e2c39cd663eb9c7157.id
  lifecycle {
    create_before_destroy = true
  }
  metadata_options {
    http_endpoint               = "enabled"
    http_put_response_hop_limit = 1
    http_tokens                 = "optional"
  }
  name = "bastion.privateflannel.example.com"
  network_interfaces {
    associate_public_ip_address = true
    delete_on_termination       = true
    security_groups             = [aws_security_group.bastion-privateflannel-example-com.id]
  }
  tag_specifications {
    resource_type = "instance"
    tags = {
      "KubernetesCluster"                                                          = "privateflannel.example.com"
      "Name"                                                                       = "bastion.privateflannel.example.com"
      "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"           = "node"
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node" = ""
      "k8s.io/role/bastion"                                                        = "1"
      "kops.k8s.io/instancegroup"                                                  = "bastion"
      "kubernetes.io/cluster/privateflannel.example.com"                           = "owned"
    }
  }
  tag_specifications {
    resource_type = "volume"
    tags = {
      "KubernetesCluster"                                                          = "privateflannel.example.com"
      "Name"                                                                       = "bastion.privateflannel.example.com"
      "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"           = "node"
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node" = ""
      "k8s.io/role/bastion"                                                        = "1"
      "kops.k8s.io/instancegroup"                                                  = "bastion"
      "kubernetes.io/cluster/privateflannel.example.com"                           = "owned"
    }
  }
  tags = {
    "KubernetesCluster"                                                          = "privateflannel.example.com"
    "Name"                                                                       = "bastion.privateflannel.example.com"
    "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"           = "node"
    "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node" = ""
    "k8s.io/role/bastion"                                                        = "1"
    "kops.k8s.io/instancegroup"                                                  = "bastion"
    "kubernetes.io/cluster/privateflannel.example.com"                           = "owned"
  }
}

resource "aws_launch_template" "master-us-test-1a-masters-privateflannel-example-com" {
  block_device_mappings {
    device_name = "/dev/xvda"
    ebs {
      delete_on_termination = true
      encrypted             = true
      iops                  = 3000
      throughput            = 125
      volume_size           = 64
      volume_type           = "gp3"
    }
  }
  block_device_mappings {
    device_name  = "/dev/sdc"
    virtual_name = "ephemeral0"
  }
  iam_instance_profile {
    name = aws_iam_instance_profile.masters-privateflannel-example-com.id
  }
  image_id      = "ami-12345678"
  instance_type = "m3.medium"
  key_name      = aws_key_pair.kubernetes-privateflannel-example-com-c4a6ed9aa889b9e2c39cd663eb9c7157.id
  lifecycle {
    create_before_destroy = true
  }
  metadata_options {
    http_endpoint               = "enabled"
    http_put_response_hop_limit = 1
    http_tokens                 = "optional"
  }
  name = "master-us-test-1a.masters.privateflannel.example.com"
  network_interfaces {
    associate_public_ip_address = false
    delete_on_termination       = true
    security_groups             = [aws_security_group.masters-privateflannel-example-com.id]
  }
  tag_specifications {
    resource_type = "instance"
    tags = {
      "KubernetesCluster"                                                                   = "privateflannel.example.com"
      "Name"                                                                                = "master-us-test-1a.masters.privateflannel.example.com"
      "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"                    = "master"
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/control-plane" = ""
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/master"        = ""
      "k8s.io/role/master"                                                                  = "1"
      "kops.k8s.io/instancegroup"                                                           = "master-us-test-1a"
      "kubernetes.io/cluster/privateflannel.example.com"                                    = "owned"
    }
  }
  tag_specifications {
    resource_type = "volume"
    tags = {
      "KubernetesCluster"                                                                   = "privateflannel.example.com"
      "Name"                                                                                = "master-us-test-1a.masters.privateflannel.example.com"
      "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"                    = "master"
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/control-plane" = ""
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/master"        = ""
      "k8s.io/role/master"                                                                  = "1"
      "kops.k8s.io/instancegroup"                                                           = "master-us-test-1a"
      "kubernetes.io/cluster/privateflannel.example.com"                                    = "owned"
    }
  }
  tags = {
    "KubernetesCluster"                                                                   = "privateflannel.example.com"
    "Name"                                                                                = "master-us-test-1a.masters.privateflannel.example.com"
    "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"                    = "master"
    "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/control-plane" = ""
    "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/master"        = ""
    "k8s.io/role/master"                                                                  = "1"
    "kops.k8s.io/instancegroup"                                                           = "master-us-test-1a"
    "kubernetes.io/cluster/privateflannel.example.com"                                    = "owned"
  }
  user_data = filebase64("${path.module}/data/aws_launch_template_master-us-test-1a.masters.privateflannel.example.com_user_data")
}

resource "aws_launch_template" "nodes-privateflannel-example-com" {
  block_device_mappings {
    device_name = "/dev/xvda"
    ebs {
      delete_on_termination = true
      encrypted             = true
      iops                  = 3000
      throughput            = 125
      volume_size           = 128
      volume_type           = "gp3"
    }
  }
  iam_instance_profile {
    name = aws_iam_instance_profile.nodes-privateflannel-example-com.id
  }
  image_id      = "ami-12345678"
  instance_type = "t2.medium"
  key_name      = aws_key_pair.kubernetes-privateflannel-example-com-c4a6ed9aa889b9e2c39cd663eb9c7157.id
  lifecycle {
    create_before_destroy = true
  }
  metadata_options {
    http_endpoint               = "enabled"
    http_put_response_hop_limit = 1
    http_tokens                 = "optional"
  }
  name = "nodes.privateflannel.example.com"
  network_interfaces {
    associate_public_ip_address = false
    delete_on_termination       = true
    security_groups             = [aws_security_group.nodes-privateflannel-example-com.id]
  }
  tag_specifications {
    resource_type = "instance"
    tags = {
      "KubernetesCluster"                                                          = "privateflannel.example.com"
      "Name"                                                                       = "nodes.privateflannel.example.com"
      "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"           = "node"
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node" = ""
      "k8s.io/role/node"                                                           = "1"
      "kops.k8s.io/instancegroup"                                                  = "nodes"
      "kubernetes.io/cluster/privateflannel.example.com"                           = "owned"
    }
  }
  tag_specifications {
    resource_type = "volume"
    tags = {
      "KubernetesCluster"                                                          = "privateflannel.example.com"
      "Name"                                                                       = "nodes.privateflannel.example.com"
      "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"           = "node"
      "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node" = ""
      "k8s.io/role/node"                                                           = "1"
      "kops.k8s.io/instancegroup"                                                  = "nodes"
      "kubernetes.io/cluster/privateflannel.example.com"                           = "owned"
    }
  }
  tags = {
    "KubernetesCluster"                                                          = "privateflannel.example.com"
    "Name"                                                                       = "nodes.privateflannel.example.com"
    "k8s.io/cluster-autoscaler/node-template/label/kubernetes.io/role"           = "node"
    "k8s.io/cluster-autoscaler/node-template/label/node-role.kubernetes.io/node" = ""
    "k8s.io/role/node"                                                           = "1"
    "kops.k8s.io/instancegroup"                                                  = "nodes"
    "kubernetes.io/cluster/privateflannel.example.com"                           = "owned"
  }
  user_data = filebase64("${path.module}/data/aws_launch_template_nodes.privateflannel.example.com_user_data")
}

resource "aws_nat_gateway" "us-test-1a-privateflannel-example-com" {
  allocation_id = aws_eip.us-test-1a-privateflannel-example-com.id
  subnet_id     = aws_subnet.utility-us-test-1a-privateflannel-example-com.id
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "us-test-1a.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_route53_record" "api-privateflannel-example-com" {
  alias {
    evaluate_target_health = false
    name                   = aws_elb.api-privateflannel-example-com.dns_name
    zone_id                = aws_elb.api-privateflannel-example-com.zone_id
  }
  name    = "api.privateflannel.example.com"
  type    = "A"
  zone_id = "/hostedzone/Z1AFAKE1ZON3YO"
}

resource "aws_route_table_association" "private-us-test-1a-privateflannel-example-com" {
  route_table_id = aws_route_table.private-us-test-1a-privateflannel-example-com.id
  subnet_id      = aws_subnet.us-test-1a-privateflannel-example-com.id
}

resource "aws_route_table_association" "utility-us-test-1a-privateflannel-example-com" {
  route_table_id = aws_route_table.privateflannel-example-com.id
  subnet_id      = aws_subnet.utility-us-test-1a-privateflannel-example-com.id
}

resource "aws_route_table" "private-us-test-1a-privateflannel-example-com" {
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "private-us-test-1a.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
    "kubernetes.io/kops/role"                          = "private-us-test-1a"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_route_table" "privateflannel-example-com" {
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
    "kubernetes.io/kops/role"                          = "public"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_route" "route-0-0-0-0--0" {
  destination_cidr_block = "0.0.0.0/0"
  gateway_id             = aws_internet_gateway.privateflannel-example-com.id
  route_table_id         = aws_route_table.privateflannel-example-com.id
}

resource "aws_route" "route-private-us-test-1a-0-0-0-0--0" {
  destination_cidr_block = "0.0.0.0/0"
  nat_gateway_id         = aws_nat_gateway.us-test-1a-privateflannel-example-com.id
  route_table_id         = aws_route_table.private-us-test-1a-privateflannel-example-com.id
}

resource "aws_security_group_rule" "from-0-0-0-0--0-ingress-tcp-22to22-bastion-elb-privateflannel-example-com" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 22
  protocol          = "tcp"
  security_group_id = aws_security_group.bastion-elb-privateflannel-example-com.id
  to_port           = 22
  type              = "ingress"
}

resource "aws_security_group_rule" "from-0-0-0-0--0-ingress-tcp-443to443-api-elb-privateflannel-example-com" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 443
  protocol          = "tcp"
  security_group_id = aws_security_group.api-elb-privateflannel-example-com.id
  to_port           = 443
  type              = "ingress"
}

resource "aws_security_group_rule" "from-api-elb-privateflannel-example-com-egress-all-0to0-0-0-0-0--0" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 0
  protocol          = "-1"
  security_group_id = aws_security_group.api-elb-privateflannel-example-com.id
  to_port           = 0
  type              = "egress"
}

resource "aws_security_group_rule" "from-bastion-elb-privateflannel-example-com-egress-all-0to0-0-0-0-0--0" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 0
  protocol          = "-1"
  security_group_id = aws_security_group.bastion-elb-privateflannel-example-com.id
  to_port           = 0
  type              = "egress"
}

resource "aws_security_group_rule" "from-bastion-elb-privateflannel-example-com-ingress-tcp-22to22-bastion-privateflannel-example-com" {
  from_port                = 22
  protocol                 = "tcp"
  security_group_id        = aws_security_group.bastion-privateflannel-example-com.id
  source_security_group_id = aws_security_group.bastion-elb-privateflannel-example-com.id
  to_port                  = 22
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-bastion-privateflannel-example-com-egress-all-0to0-0-0-0-0--0" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 0
  protocol          = "-1"
  security_group_id = aws_security_group.bastion-privateflannel-example-com.id
  to_port           = 0
  type              = "egress"
}

resource "aws_security_group_rule" "from-bastion-privateflannel-example-com-ingress-tcp-22to22-masters-privateflannel-example-com" {
  from_port                = 22
  protocol                 = "tcp"
  security_group_id        = aws_security_group.masters-privateflannel-example-com.id
  source_security_group_id = aws_security_group.bastion-privateflannel-example-com.id
  to_port                  = 22
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-bastion-privateflannel-example-com-ingress-tcp-22to22-nodes-privateflannel-example-com" {
  from_port                = 22
  protocol                 = "tcp"
  security_group_id        = aws_security_group.nodes-privateflannel-example-com.id
  source_security_group_id = aws_security_group.bastion-privateflannel-example-com.id
  to_port                  = 22
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-masters-privateflannel-example-com-egress-all-0to0-0-0-0-0--0" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 0
  protocol          = "-1"
  security_group_id = aws_security_group.masters-privateflannel-example-com.id
  to_port           = 0
  type              = "egress"
}

resource "aws_security_group_rule" "from-masters-privateflannel-example-com-ingress-all-0to0-masters-privateflannel-example-com" {
  from_port                = 0
  protocol                 = "-1"
  security_group_id        = aws_security_group.masters-privateflannel-example-com.id
  source_security_group_id = aws_security_group.masters-privateflannel-example-com.id
  to_port                  = 0
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-masters-privateflannel-example-com-ingress-all-0to0-nodes-privateflannel-example-com" {
  from_port                = 0
  protocol                 = "-1"
  security_group_id        = aws_security_group.nodes-privateflannel-example-com.id
  source_security_group_id = aws_security_group.masters-privateflannel-example-com.id
  to_port                  = 0
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-nodes-privateflannel-example-com-egress-all-0to0-0-0-0-0--0" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 0
  protocol          = "-1"
  security_group_id = aws_security_group.nodes-privateflannel-example-com.id
  to_port           = 0
  type              = "egress"
}

resource "aws_security_group_rule" "from-nodes-privateflannel-example-com-ingress-all-0to0-nodes-privateflannel-example-com" {
  from_port                = 0
  protocol                 = "-1"
  security_group_id        = aws_security_group.nodes-privateflannel-example-com.id
  source_security_group_id = aws_security_group.nodes-privateflannel-example-com.id
  to_port                  = 0
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-nodes-privateflannel-example-com-ingress-tcp-1to2379-masters-privateflannel-example-com" {
  from_port                = 1
  protocol                 = "tcp"
  security_group_id        = aws_security_group.masters-privateflannel-example-com.id
  source_security_group_id = aws_security_group.nodes-privateflannel-example-com.id
  to_port                  = 2379
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-nodes-privateflannel-example-com-ingress-tcp-2382to4000-masters-privateflannel-example-com" {
  from_port                = 2382
  protocol                 = "tcp"
  security_group_id        = aws_security_group.masters-privateflannel-example-com.id
  source_security_group_id = aws_security_group.nodes-privateflannel-example-com.id
  to_port                  = 4000
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-nodes-privateflannel-example-com-ingress-tcp-4003to65535-masters-privateflannel-example-com" {
  from_port                = 4003
  protocol                 = "tcp"
  security_group_id        = aws_security_group.masters-privateflannel-example-com.id
  source_security_group_id = aws_security_group.nodes-privateflannel-example-com.id
  to_port                  = 65535
  type                     = "ingress"
}

resource "aws_security_group_rule" "from-nodes-privateflannel-example-com-ingress-udp-1to65535-masters-privateflannel-example-com" {
  from_port                = 1
  protocol                 = "udp"
  security_group_id        = aws_security_group.masters-privateflannel-example-com.id
  source_security_group_id = aws_security_group.nodes-privateflannel-example-com.id
  to_port                  = 65535
  type                     = "ingress"
}

resource "aws_security_group_rule" "https-elb-to-master" {
  from_port                = 443
  protocol                 = "tcp"
  security_group_id        = aws_security_group.masters-privateflannel-example-com.id
  source_security_group_id = aws_security_group.api-elb-privateflannel-example-com.id
  to_port                  = 443
  type                     = "ingress"
}

resource "aws_security_group_rule" "icmp-pmtu-api-elb-0-0-0-0--0" {
  cidr_blocks       = ["0.0.0.0/0"]
  from_port         = 3
  protocol          = "icmp"
  security_group_id = aws_security_group.api-elb-privateflannel-example-com.id
  to_port           = 4
  type              = "ingress"
}

resource "aws_security_group" "api-elb-privateflannel-example-com" {
  description = "Security group for api ELB"
  name        = "api-elb.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "api-elb.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_security_group" "bastion-elb-privateflannel-example-com" {
  description = "Security group for bastion ELB"
  name        = "bastion-elb.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "bastion-elb.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_security_group" "bastion-privateflannel-example-com" {
  description = "Security group for bastion"
  name        = "bastion.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "bastion.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_security_group" "masters-privateflannel-example-com" {
  description = "Security group for masters"
  name        = "masters.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "masters.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_security_group" "nodes-privateflannel-example-com" {
  description = "Security group for nodes"
  name        = "nodes.privateflannel.example.com"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "nodes.privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_subnet" "us-test-1a-privateflannel-example-com" {
  availability_zone = "us-test-1a"
  cidr_block        = "172.20.32.0/19"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "us-test-1a.privateflannel.example.com"
    "SubnetType"                                       = "Private"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
    "kubernetes.io/role/internal-elb"                  = "1"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_subnet" "utility-us-test-1a-privateflannel-example-com" {
  availability_zone = "us-test-1a"
  cidr_block        = "172.20.4.0/22"
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "utility-us-test-1a.privateflannel.example.com"
    "SubnetType"                                       = "Utility"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
    "kubernetes.io/role/elb"                           = "1"
  }
  vpc_id = aws_vpc.privateflannel-example-com.id
}

resource "aws_vpc_dhcp_options_association" "privateflannel-example-com" {
  dhcp_options_id = aws_vpc_dhcp_options.privateflannel-example-com.id
  vpc_id          = aws_vpc.privateflannel-example-com.id
}

resource "aws_vpc_dhcp_options" "privateflannel-example-com" {
  domain_name         = "us-test-1.compute.internal"
  domain_name_servers = ["AmazonProvidedDNS"]
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

resource "aws_vpc" "privateflannel-example-com" {
  cidr_block           = "172.20.0.0/16"
  enable_dns_hostnames = true
  enable_dns_support   = true
  tags = {
    "KubernetesCluster"                                = "privateflannel.example.com"
    "Name"                                             = "privateflannel.example.com"
    "kubernetes.io/cluster/privateflannel.example.com" = "owned"
  }
}

terraform {
  required_version = ">= 0.12.26"
  required_providers {
    aws = {
      "source"  = "hashicorp/aws"
      "version" = ">= 2.46.0"
    }
  }
}
