## Release notes for kops 1.19 series

(The kops 1.19 release has not been released yet; this is a document to gather the notes prior to the release).

# Significant changes

## Changes to kubernetes config export

Kops will no longer automatically export the kubernetes config on `kops update cluster`. In order to export the config on cluster update, you need to either add the `--user <user>` to reference an existing user, or `--admin` to export the cluster admin user. If neither flag is passed, the kubernetes config will not be modified. This makes it easier to reuse user definitions across clusters should you, for example, use OIDC for authentication.

Similarly, `kops export kubecfg` will also require passing either the `--admin` or `--user` flag if the context does not already exist.

By default, the credentials of any exported admin user now have a lifetime of 18 hours. The lifetime of the exported
credentials may be specified as a value of the `--admin` flag. To get the previous behavior, specify `--admin=87600h` to either `kops update cluster` or `kops export kubecfg`.

`kops create cluster --yes` exports the admin user along with rest of the cluster config, as was the previous behaviour (except for the 18-hour validity).

## OpenStack Cinder plugin

Kops will install the Cinder plugin for kops running kubernetes 1.16 or newer. If you already have this plugin installed you should remove it before upgrading.

If you already have a default `StorageClass`, you should set `cloudConfig.Openstack.BlockStorage.CreateStorageClass: false` to prevent kops from installing one.

## Other significant changes by kind

### General

* New clusters will now have one nodes group per zone. The number of nodes now defaults to the number of zones.

* On AWS kops now defaults to using launch templates instead of launch configurations.

* There is now Alpha support for Hashicorp Vault as a store for secrets and keys. See the [Vault state store docs](/state/#vault-vault).

* The lifetimes of certificates used by various components have been substantially reduced.
The certificates on a node will expire sometime between 455 and 485 days after the node's creation.
The expiration times vary randomly so that nodes are likely to have their certs expire at different times than other nodes.

* kOps now supports using an AWS Network Load Balancer (NLB) for API access.
See the [documentation](/cluster_spec/#load-balancer-class) for more info.

* Allow users to partially compress user-data, check the instance groups docs for more details.

### CLI

* The `kops update cluster` command will now refuse to run on a cluster that
has been updated by a newer version of kops unless it is given the `--allow-kops-downgrade` flag.

* New command for deleting a single instance: [kops delete instance](/docs/cli/kops_delete_instance/)

### CNI

* Clusters using the Amazon VPC CNI provider now perform an `ec2.DescribeInstanceTypes` call at instance launch time. In large clusters or AWS accounts this may lead to API throttling which could delay node readiness. If this becomes a problem please open a GitHub issue.

* Clusters using Calico with `CrossSubnet` enabled will switch to the new [awsSrcDstCheck](https://docs.projectcalico.org/reference/resources/felixconfig#spec) for disabling the [AWS source/destination checks](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html#EIP_Disable_SrcDestCheck). The previous implementation using [k8s-ec2-srcdst](https://github.com/ottoyiu/k8s-ec2-srcdst) is now deprecated.

* Clusters using Calico can now enable the [eBPF dataplane](https://docs.projectcalico.org/about/about-ebpf) mode for Ubuntu 20.04 (Focal) hosts. Add `spec.networking.calico.bpfEnabled: true` and `spec.kubeProxy.enabled: false` to the cluster spec to enable.

* Clusters using Calico can now encrypt pod-to-pod traffic with [WireGuard](https://docs.projectcalico.org/security/encrypt-cluster-pod-traffic) for Ubuntu hosts. Add `spec.networking.calico.wireguardEnabled: true` to the cluster spec to enable.

* New clusters running Cilium now enable BPF NodePort by default if the Kubernetes version is 1.12 or newer.

### Addons

* Metrics Server is now available as a configurable addon. Add `spec.metricsServer.enabled: true` to the cluster spec to enable.

* Cluster Autoscaler is now availalble as a configurable addon. Add `spec.clusterAutoscaler.enabled: true` to the cluster spec to enable.

* AWS Node Termination Handler is now available as a configurable addon. Add `spec.nodeTerminationHandler.enabled: true` to the cluster spec to enable.

# Breaking changes

* Support for Kubernetes 1.9 and 1.10 has been removed.

* Support for the Romana networking provider has been removed.

* Support for legacy IAM permissions has been removed. This removal may be temporarily deferred to kops 1.20 by setting the `LegacyIAM` feature flag.

# Required Actions

* See note about [Openstack Cinder plugin](#openstack-cinder-plugin) above.

* Terraform users, in order to prevent downtime you will have to remove the state of any existing ELB or TargetGroup attatchments from your Terraform state file. This is due to migrating the attachments to the in-line `aws_autoscaling_group` fields. See the [terraform documentation](https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/autoscaling_group) for more information about the difference. This migration is required due to a bug described in [#9913](https://github.com/kubernetes/kops/issues/9913).

To prevent downtime, follow these steps with the new version of Kops:
  ```
  kops update cluster --target terraform ...
  terraform plan
  terraform state list | grep aws_autoscaling_attachment | xargs -L1 terraform state rm
  terraform plan
  # Ensure these resources are no longer being destroyed and recreated
  terraform apply
  ```

* If you are using Terraform with an additional .tf file and using "aws_autoscaling_attachment" to attach additional Load Balancers or ALB/NLB Target Groups you'll need to migrate to [attaching them through the InstanceGroup spec instead](https://kops.sigs.k8s.io/instance_groups/#externalloadbalancers).

# Deprecations

* Support for Kubernetes versions 1.11 and 1.12 are deprecated and will be removed in kops 1.20.

* Support for Terraform version 0.11 has been deprecated and will be removed in kops 1.20.

* Support for feature flag `Terraform-0.12` has been deprecated and will be removed in kops 1.20. All generated Terraform HCL2/JSON files will support versions `0.12.26+` and `0.13.0+`.

* The [manifest based metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) has been deprecated in favour of a configurable addon.

* The [manifest based cluster autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler) has been deprecated in favour of a configurable addon.

# Full change list since 1.18.0 release

## v1.18.0-alpha.3 to v1.19.0-alpha.1

* Add etcd-manager certificate expiration advisory [@rifelpet](https://github.com/rifelpet) [#9030](https://github.com/kubernetes/kops/pull/9030)
* Treat NatGatewaysNotFound error as already-deleted [@johngmyers](https://github.com/johngmyers) [#9052](https://github.com/kubernetes/kops/pull/9052)
* Allow cluster maintenance when channel is unavailable [@johngmyers](https://github.com/johngmyers) [#9053](https://github.com/kubernetes/kops/pull/9053)
* Release notes for 1.18.0-alpha.3 [@justinsb](https://github.com/justinsb) [#9075](https://github.com/kubernetes/kops/pull/9075)
* Release notes for 1.17.0-beta.2 [@justinsb](https://github.com/justinsb) [#9073](https://github.com/kubernetes/kops/pull/9073)
* Disable TX checksum offload for Flannel VXLAN [@hakman](https://github.com/hakman) [#9074](https://github.com/kubernetes/kops/pull/9074)
* Added support for configuring disable-attach-detach-reconcile-sync in… [@andersosthus](https://github.com/andersosthus) [#9068](https://github.com/kubernetes/kops/pull/9068)
* Add advisory notice to readme and docs homepage [@rifelpet](https://github.com/rifelpet) [#9083](https://github.com/kubernetes/kops/pull/9083)
* Revert "feat(openstack): propagate cloud labels to machines" [@zetaab](https://github.com/zetaab) [#9087](https://github.com/kubernetes/kops/pull/9087)
* kube-apiserver: healthcheck via sidecar container [@justinsb](https://github.com/justinsb) [#9069](https://github.com/kubernetes/kops/pull/9069)
* Include secondary protocol flag always [@jacksontj](https://github.com/jacksontj) [#9008](https://github.com/kubernetes/kops/pull/9008)
* Fix port conflict on etcd-cilium vs dns-controller memberlist [@justinsb](https://github.com/justinsb) [#9097](https://github.com/kubernetes/kops/pull/9097)
* kube-apiserver-healthcheck: actually enable on 1.17 [@justinsb](https://github.com/justinsb) [#9098](https://github.com/kubernetes/kops/pull/9098)
* Update instance_groups.md [@ranshn](https://github.com/ranshn) [#9072](https://github.com/kubernetes/kops/pull/9072)
* Fix containerd image side-loading [@hakman](https://github.com/hakman) [#9101](https://github.com/kubernetes/kops/pull/9101)
* Dont use terraform's file() for singleline strings in GCE metadata [@rifelpet](https://github.com/rifelpet) [#9084](https://github.com/kubernetes/kops/pull/9084)
* Add documentation on gossip [@olemarkus](https://github.com/olemarkus) [#9111](https://github.com/kubernetes/kops/pull/9111)
* upgrade to use cinder v3 api [@zetaab](https://github.com/zetaab) [#9113](https://github.com/kubernetes/kops/pull/9113)
* Fix zsh completion [@olemarkus](https://github.com/olemarkus) [#9108](https://github.com/kubernetes/kops/pull/9108)
* Add unit test for util/pkg/hashing/hash.go [@Hellcatlk](https://github.com/Hellcatlk) [#9114](https://github.com/kubernetes/kops/pull/9114)
* Spotinst: Allow users to disable the controller add-on [@liranp](https://github.com/liranp) [#9091](https://github.com/kubernetes/kops/pull/9091)
* Fail cluster validation if too few nodes for ig's target size [@johngmyers](https://github.com/johngmyers) [#9126](https://github.com/kubernetes/kops/pull/9126)
* Adding most recent version of kube-state-metrics - 1.9.5 [@MoShitrit](https://github.com/MoShitrit) [#9125](https://github.com/kubernetes/kops/pull/9125)
* PKI code cleanup [@johngmyers](https://github.com/johngmyers) [#9106](https://github.com/kubernetes/kops/pull/9106)
* Return cluster validation failure if ASG missing [@johngmyers](https://github.com/johngmyers) [#9118](https://github.com/kubernetes/kops/pull/9118)
* Add EC2 Instance LifeCycle label [@atmosx](https://github.com/atmosx) [#9121](https://github.com/kubernetes/kops/pull/9121)
* add some unit tests [@q384566678](https://github.com/q384566678) [#8960](https://github.com/kubernetes/kops/pull/8960)
* Remove code for unsupported Kubernetes version [@johngmyers](https://github.com/johngmyers) [#9134](https://github.com/kubernetes/kops/pull/9134)
* http download: set a timeout to avoid hangs [@justinsb](https://github.com/justinsb) [#9136](https://github.com/kubernetes/kops/pull/9136)
* Move CNI docs to their own files [@olemarkus](https://github.com/olemarkus) [#9107](https://github.com/kubernetes/kops/pull/9107)
* Added Launch Template support for instance interruption behavior [@tomesm](https://github.com/tomesm),[@rifelpet](https://github.com/rifelpet) [#9024](https://github.com/kubernetes/kops/pull/9024)
* DNS: Don't try to apply empty changesets [@justinsb](https://github.com/justinsb) [#8464](https://github.com/kubernetes/kops/pull/8464)
* Remove redundant menu item in the docs site [@rifelpet](https://github.com/rifelpet) [#9144](https://github.com/kubernetes/kops/pull/9144)
* Remove Classic networking from docs [@johngmyers](https://github.com/johngmyers) [#9142](https://github.com/kubernetes/kops/pull/9142)
* doc: Typo in docs/state.md [@nvanheuverzwijn](https://github.com/nvanheuverzwijn) [#9147](https://github.com/kubernetes/kops/pull/9147)
* Spotinst: Documentation [@liranp](https://github.com/liranp) [#9139](https://github.com/kubernetes/kops/pull/9139)
* Map kube-apiserver service-account-jwks-uri flag [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#9133](https://github.com/kubernetes/kops/pull/9133)
* Don't put bastions in the utility subnets [@johngmyers](https://github.com/johngmyers) [#9124](https://github.com/kubernetes/kops/pull/9124)
* Create golden image test for nodeup kube-apiserver [@justinsb](https://github.com/justinsb) [#8950](https://github.com/kubernetes/kops/pull/8950)
* Add unit test for func matchesElbTags [@hs0210](https://github.com/hs0210) [#8989](https://github.com/kubernetes/kops/pull/8989)
* Remove support for reading legacy-format keypairs [@johngmyers](https://github.com/johngmyers) [#9131](https://github.com/kubernetes/kops/pull/9131)
* Update alpha channels with May updates [@MoShitrit](https://github.com/MoShitrit) [#9155](https://github.com/kubernetes/kops/pull/9155)
* Add support for Kubenet with containerd [@hakman](https://github.com/hakman) [#9104](https://github.com/kubernetes/kops/pull/9104)
* [Digital Ocean] Handle logic for kops edit/update cluster [@srikiz](https://github.com/srikiz) [#9116](https://github.com/kubernetes/kops/pull/9116)
* Move OS deprecations to deprecations section of relnotes [@johngmyers](https://github.com/johngmyers) [#9093](https://github.com/kubernetes/kops/pull/9093)
* Add unit test case for pkg/k8sversion/version_test.go [@Hellcatlk](https://github.com/Hellcatlk) [#9112](https://github.com/kubernetes/kops/pull/9112)
* Update OWNERS file [@johngmyers](https://github.com/johngmyers) [#9105](https://github.com/kubernetes/kops/pull/9105)
* Minor doc fix. __address__ is not valid to use, will cuase etcd faili… [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#9160](https://github.com/kubernetes/kops/pull/9160)
* GCE: don't rely on hostname being correct [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#9135](https://github.com/kubernetes/kops/pull/9135)
* Reduce test flakiness [@johngmyers](https://github.com/johngmyers) [#9164](https://github.com/kubernetes/kops/pull/9164)
* Add unit test case for pkg/apis/kops/util/versions_test.go [@Hellcatlk](https://github.com/Hellcatlk) [#9156](https://github.com/kubernetes/kops/pull/9156)
* Spotinst: New hybrid integration mode [@liranp](https://github.com/liranp) [#7252](https://github.com/kubernetes/kops/pull/7252)
* Fix nodetask.File dependency on owner [@johngmyers](https://github.com/johngmyers) [#9169](https://github.com/kubernetes/kops/pull/9169)
* Networking cleanup [@olemarkus](https://github.com/olemarkus) [#9157](https://github.com/kubernetes/kops/pull/9157)
* Update DigitalOcean cloud-controller-manager to v0.1.24 [@timoreimann](https://github.com/timoreimann) [#9179](https://github.com/kubernetes/kops/pull/9179)
* Update etcd-manager to 3.0.20200527 [@justinsb](https://github.com/justinsb) [#9184](https://github.com/kubernetes/kops/pull/9184)
* Use debian as default image for DO images [@srikiz](https://github.com/srikiz) [#9181](https://github.com/kubernetes/kops/pull/9181)
* Remove all versions of a file form the S3 bucket [@hakman](https://github.com/hakman) [#9171](https://github.com/kubernetes/kops/pull/9171)
* Remove unused VFSScan [@johngmyers](https://github.com/johngmyers) [#9174](https://github.com/kubernetes/kops/pull/9174)
* Remove loader support for nodeup tasks not used in models [@johngmyers](https://github.com/johngmyers) [#9170](https://github.com/kubernetes/kops/pull/9170)
* Document etcd-manager backups retention settings [@hakman](https://github.com/hakman) [#9187](https://github.com/kubernetes/kops/pull/9187)
* Add gjtempleton as reviewer [@johngmyers](https://github.com/johngmyers) [#9183](https://github.com/kubernetes/kops/pull/9183)
* Fix nits for removal of S3 file versions [@hakman](https://github.com/hakman) [#9188](https://github.com/kubernetes/kops/pull/9188)
* Remove support for CoreOS and Jessie [@johngmyers](https://github.com/johngmyers) [#9065](https://github.com/kubernetes/kops/pull/9065)
* Update Bazel rules for Docker to v0.14.2 [@hakman](https://github.com/hakman) [#9196](https://github.com/kubernetes/kops/pull/9196)
* Remove support for the legacy etcd provider as of k8s 1.18 [@johngmyers](https://github.com/johngmyers) [#8826](https://github.com/kubernetes/kops/pull/8826)
* Add deprecation notice for legacy etcd provider to 1.17 relnotes [@johngmyers](https://github.com/johngmyers) [#9201](https://github.com/kubernetes/kops/pull/9201)
* Add comment in OWNERS linking to test-infra OWNERS files [@rifelpet](https://github.com/rifelpet) [#9202](https://github.com/kubernetes/kops/pull/9202)
* Fix repo packages not being installed [@hakman](https://github.com/hakman) [#9203](https://github.com/kubernetes/kops/pull/9203)
* Allow listing versions for objects in the S3 bucket [@hakman](https://github.com/hakman) [#9205](https://github.com/kubernetes/kops/pull/9205)
* Try validating multiple times before updating instancegroup [@johngmyers](https://github.com/johngmyers) [#9165](https://github.com/kubernetes/kops/pull/9165)
* Use kubescheduler.config.k8s.io/v1beta1 for Kubernetes 1.19 [@hakman](https://github.com/hakman) [#9204](https://github.com/kubernetes/kops/pull/9204)
* Update adding_a_feature.md with more modern example [@johngmyers](https://github.com/johngmyers) [#9208](https://github.com/kubernetes/kops/pull/9208)
* Add example for delete secret [@q384566678](https://github.com/q384566678) [#9198](https://github.com/kubernetes/kops/pull/9198)
* Upgrade docker/containerd/containeros hashes to SHA256 [@johngmyers](https://github.com/johngmyers) [#9215](https://github.com/kubernetes/kops/pull/9215)
* Release notes for 1.16.3 [@justinsb](https://github.com/justinsb) [#9219](https://github.com/kubernetes/kops/pull/9219)
* Remove extraneous markdown files in pkg/apis [@rifelpet](https://github.com/rifelpet) [#9220](https://github.com/kubernetes/kops/pull/9220)
* Release notes for 1.17.0 [@justinsb](https://github.com/justinsb) [#9222](https://github.com/kubernetes/kops/pull/9222)
* Remove unused file [@johngmyers](https://github.com/johngmyers) [#9218](https://github.com/kubernetes/kops/pull/9218)
* Update set-version script to bump tag in Makefile [@justinsb](https://github.com/justinsb) [#9224](https://github.com/kubernetes/kops/pull/9224)
* Start release notes for kops 1.19 [@justinsb](https://github.com/justinsb) [#9223](https://github.com/kubernetes/kops/pull/9223)
* Use AWS SDK to fetch metadata [@justinsb](https://github.com/justinsb) [#9227](https://github.com/kubernetes/kops/pull/9227)
* S3 DeleteAllVersions: use pagination [@justinsb](https://github.com/justinsb) [#9228](https://github.com/kubernetes/kops/pull/9228)
* Bump compatibility matrix for kops 1.17 [@johngmyers](https://github.com/johngmyers) [#9225](https://github.com/kubernetes/kops/pull/9225)
* Validation: MixedInstancePolicy need not override instance types [@justinsb](https://github.com/justinsb) [#9231](https://github.com/kubernetes/kops/pull/9231)
* GCE: fix typo [@justinsb](https://github.com/justinsb) [#9232](https://github.com/kubernetes/kops/pull/9232)
* Add packages hashes verification for containerd and Docker [@hakman](https://github.com/hakman) [#9234](https://github.com/kubernetes/kops/pull/9234)
* Remove vsphere cloud provider [@olemarkus](https://github.com/olemarkus) [#9177](https://github.com/kubernetes/kops/pull/9177)
* Update etcd-manager to 3.0.20200531 [@hakman](https://github.com/hakman) [#9237](https://github.com/kubernetes/kops/pull/9237)
* Don't build site when docs are unchanged [@hakman](https://github.com/hakman) [#9235](https://github.com/kubernetes/kops/pull/9235)
* Updating stable channel with May updates [@MoShitrit](https://github.com/MoShitrit) [#9212](https://github.com/kubernetes/kops/pull/9212)
* Upgrde amazon vpc cni to 1.6.2 [@MoShitrit](https://github.com/MoShitrit) [#9214](https://github.com/kubernetes/kops/pull/9214)
* Disable static tokens by default as of Kubernetes 1.18 [@johngmyers](https://github.com/johngmyers) [#8850](https://github.com/kubernetes/kops/pull/8850)
* Add example for describe secret [@q384566678](https://github.com/q384566678) [#9241](https://github.com/kubernetes/kops/pull/9241)
* Release notes for 1.18.0-beta.1 [@justinsb](https://github.com/justinsb) [#9242](https://github.com/kubernetes/kops/pull/9242)
* 1.18 release note corrections [@johngmyers](https://github.com/johngmyers) [#9243](https://github.com/kubernetes/kops/pull/9243)
* Update channels for 1.18 [@mikesplain](https://github.com/mikesplain) [#9250](https://github.com/kubernetes/kops/pull/9250)
* [Digital Ocean] Update RBAC for DO CCM [@srikiz](https://github.com/srikiz) [#9249](https://github.com/kubernetes/kops/pull/9249)
* Remove redundant ValidateInstanceGroup call [@rifelpet](https://github.com/rifelpet) [#9252](https://github.com/kubernetes/kops/pull/9252)
* Add ARM64 build targets for kops and nodeup [@hakman](https://github.com/hakman) [#8922](https://github.com/kubernetes/kops/pull/8922)
* Remove all traces of utils.tar.gz [@hakman](https://github.com/hakman) [#9197](https://github.com/kubernetes/kops/pull/9197)
* Enable configuration of the calico IP_AUTODETECTION_METHOD  and IP6_AUTODETECTION_METHOD [@mtl-wgtwo](https://github.com/mtl-wgtwo) [#9175](https://github.com/kubernetes/kops/pull/9175)
* Use CNI 0.8.6 for Kubernetes 1.15+ [@hakman](https://github.com/hakman) [#9256](https://github.com/kubernetes/kops/pull/9256)
* Add table of networking providers and their status [@olemarkus](https://github.com/olemarkus) [#9140](https://github.com/kubernetes/kops/pull/9140)
* Use Docker 19.03.11 for Kubernetes 1.18+ [@hakman](https://github.com/hakman) [#9258](https://github.com/kubernetes/kops/pull/9258)
* Fix link to point to aws docs [@mikesplain](https://github.com/mikesplain) [#9263](https://github.com/kubernetes/kops/pull/9263)
* Refactor Debian automatic upgrades to Go code [@johngmyers](https://github.com/johngmyers) [#9213](https://github.com/kubernetes/kops/pull/9213)
* Remove romana support [@olemarkus](https://github.com/olemarkus) [#9255](https://github.com/kubernetes/kops/pull/9255)
* Don't make it possible to toggle ipv4/6. We only support ipv4 anyway [@olemarkus](https://github.com/olemarkus) [#9253](https://github.com/kubernetes/kops/pull/9253)
* Update channel 1.15 k8s recommendation to 1.15.12 [@jeffb4](https://github.com/jeffb4) [#9266](https://github.com/kubernetes/kops/pull/9266)
* Add support for encryption in Cilium  [@MoShitrit](https://github.com/MoShitrit) [#9154](https://github.com/kubernetes/kops/pull/9154)
* Bump Dashboard to v2.0.1 [@maciaszczykm](https://github.com/maciaszczykm) [#9199](https://github.com/kubernetes/kops/pull/9199)
* Update Calico and Canal for CVE-2020-13597 [@hakman](https://github.com/hakman) [#9268](https://github.com/kubernetes/kops/pull/9268)
* Tag all cilium keys with omitempty [@olemarkus](https://github.com/olemarkus) [#9254](https://github.com/kubernetes/kops/pull/9254)
* When building to staging, split out the marker files by branch [@justinsb](https://github.com/justinsb) [#9272](https://github.com/kubernetes/kops/pull/9272)
* Move networking in nodeup to dedicated subpackage [@olemarkus](https://github.com/olemarkus) [#9137](https://github.com/kubernetes/kops/pull/9137)
* Bump supported and recommended k8s versions for kops 1.19 [@johngmyers](https://github.com/johngmyers) [#9226](https://github.com/kubernetes/kops/pull/9226)
* Clean up wording in releases.md [@johngmyers](https://github.com/johngmyers) [#9230](https://github.com/kubernetes/kops/pull/9230)
* Spotinst: Allow a user specifiable node draining timeout [@liranp](https://github.com/liranp) [#9221](https://github.com/kubernetes/kops/pull/9221)
* Validate IG RootVolumeType [@olemarkus](https://github.com/olemarkus) [#9265](https://github.com/kubernetes/kops/pull/9265)
* gce: log bucket-policy-only message at a level that always appears [@justinsb](https://github.com/justinsb) [#9276](https://github.com/kubernetes/kops/pull/9276)
* Prepare Kops for multi-architecture support [@hakman](https://github.com/hakman) [#9216](https://github.com/kubernetes/kops/pull/9216)
* Ensure we have IAM bucket permissions to other S3 buckets [@justinsb](https://github.com/justinsb) [#9274](https://github.com/kubernetes/kops/pull/9274)
* Refactor cert issuance code [@johngmyers](https://github.com/johngmyers) [#9130](https://github.com/kubernetes/kops/pull/9130)
* Allow failure of the ARM64 job in TravisCI [@hakman](https://github.com/hakman) [#9279](https://github.com/kubernetes/kops/pull/9279)
* Use Ubuntu 20.04 as the default image for Kubernetes 1.18+ [@hakman](https://github.com/hakman) [#9283](https://github.com/kubernetes/kops/pull/9283)
* Disable disk based evictions for Kubernetes 1.19 [@hakman](https://github.com/hakman) [#9296](https://github.com/kubernetes/kops/pull/9296)
* More nodeup golden tests [@justinsb](https://github.com/justinsb) [#9248](https://github.com/kubernetes/kops/pull/9248)
* Adding recent releases to docs site [@MoShitrit](https://github.com/MoShitrit) [#9293](https://github.com/kubernetes/kops/pull/9293)
* Update Weave for CVE-2020-13597 [@hakman](https://github.com/hakman) [#9285](https://github.com/kubernetes/kops/pull/9285)
* Create nodetasks.IssueCert() [@johngmyers](https://github.com/johngmyers) [#9282](https://github.com/kubernetes/kops/pull/9282)
* Don't export basic auth credentials if basic auth is disabled [@johngmyers](https://github.com/johngmyers) [#9284](https://github.com/kubernetes/kops/pull/9284)
* Copy "portmap" to /opt/cni/bin for Weave [@hakman](https://github.com/hakman) [#9286](https://github.com/kubernetes/kops/pull/9286)
* Update shipbot config [@hakman](https://github.com/hakman) [#9277](https://github.com/kubernetes/kops/pull/9277)
* Fix some go-lint warning [@Hellcatlk](https://github.com/Hellcatlk) [#9236](https://github.com/kubernetes/kops/pull/9236)
* Docs - add syntax highlighting + markdown cleanup [@rifelpet](https://github.com/rifelpet) [#9308](https://github.com/kubernetes/kops/pull/9308)
* Install common CNI plugin binaries for all network plugins [@hakman](https://github.com/hakman) [#9310](https://github.com/kubernetes/kops/pull/9310)
* Don't try building TLS for etcd-manager if not using etcd-manager [@johngmyers](https://github.com/johngmyers) [#9302](https://github.com/kubernetes/kops/pull/9302)
* Use ec2.DescribeInstanceTypes for machine type info [@rifelpet](https://github.com/rifelpet) [#8856](https://github.com/kubernetes/kops/pull/8856)
* Don't require nodeup tasks to have SetName() [@johngmyers](https://github.com/johngmyers) [#9299](https://github.com/kubernetes/kops/pull/9299)
* Refactor and improve API validation [@johngmyers](https://github.com/johngmyers) [#9217](https://github.com/kubernetes/kops/pull/9217)
* Disable kubeproxy when creating a kube-router cluster [@rifelpet](https://github.com/rifelpet) [#9321](https://github.com/kubernetes/kops/pull/9321)
* Use Docker 19.03.11 for Kubernetes 1.17+ [@hakman](https://github.com/hakman) [#9317](https://github.com/kubernetes/kops/pull/9317)
* Install all CNI plugin binaries for all network plugins [@hakman](https://github.com/hakman) [#9320](https://github.com/kubernetes/kops/pull/9320)
* Fix NPD when creating a kube-router cluster [@rifelpet](https://github.com/rifelpet) [#9323](https://github.com/kubernetes/kops/pull/9323)
* Fix mismatch in SecurityGroups handling with launch templates [@johngmyers](https://github.com/johngmyers) [#9288](https://github.com/kubernetes/kops/pull/9288)
* Allow docker options to be specified by create cluster overrides [@bertinatto](https://github.com/bertinatto) [#9324](https://github.com/kubernetes/kops/pull/9324)
* Issue kube-scheduler and kube-controller-manager certs in nodeup [@johngmyers](https://github.com/johngmyers),[@justinsb](https://github.com/justinsb) [#9313](https://github.com/kubernetes/kops/pull/9313)
* IAM: Refactor vfs-access logic so we can see the required readable paths [@justinsb](https://github.com/justinsb) [#9328](https://github.com/kubernetes/kops/pull/9328)
* Update Weave Net to 2.6.5 [@hakman](https://github.com/hakman) [#9330](https://github.com/kubernetes/kops/pull/9330)
* Docs helptext [@olemarkus](https://github.com/olemarkus) [#9333](https://github.com/kubernetes/kops/pull/9333)
* Use launch templates by default [@johngmyers](https://github.com/johngmyers) [#9289](https://github.com/kubernetes/kops/pull/9289)
* Refactor kubemanifest to be clearer [@justinsb](https://github.com/justinsb) [#9342](https://github.com/kubernetes/kops/pull/9342)
* Refactor BootstrapChannelBuilder to use a KopsModelContext [@justinsb](https://github.com/justinsb) [#9338](https://github.com/kubernetes/kops/pull/9338)
* Issue kubecfg and kops certs in nodeup [@johngmyers](https://github.com/johngmyers) [#9347](https://github.com/kubernetes/kops/pull/9347)
* Update release notes for Ubuntu 20.04 and CVEs [@hakman](https://github.com/hakman) [#9332](https://github.com/kubernetes/kops/pull/9332)
* Add nodelocal dns cache to release notes and add kops version to docs [@olemarkus](https://github.com/olemarkus) [#9351](https://github.com/kubernetes/kops/pull/9351)
* Bug: Explicitly set default StorageClass to support upgrades [@joshbranham](https://github.com/joshbranham) [#9337](https://github.com/kubernetes/kops/pull/9337)
* Promote alpha channel to stable [@johngmyers](https://github.com/johngmyers) [#9366](https://github.com/kubernetes/kops/pull/9366)
* Prefer the GA label for node zone [@johngmyers](https://github.com/johngmyers) [#9363](https://github.com/kubernetes/kops/pull/9363)
* Cleanup networking docs [@ari-becker](https://github.com/ari-becker) [#9349](https://github.com/kubernetes/kops/pull/9349)
* Bump recommended kops versions in alpha channel [@johngmyers](https://github.com/johngmyers) [#9361](https://github.com/kubernetes/kops/pull/9361)
* Validate cilium version [@olemarkus](https://github.com/olemarkus) [#9295](https://github.com/kubernetes/kops/pull/9295)
* Fix kube-apiserver-healthcheck image [@coreypobrien](https://github.com/coreypobrien) [#9359](https://github.com/kubernetes/kops/pull/9359)
* Remove the baremetal cloud provider [@johngmyers](https://github.com/johngmyers) [#9360](https://github.com/kubernetes/kops/pull/9360)
* Add "--selinux-enabled" flag for Docker [@hakman](https://github.com/hakman) [#9334](https://github.com/kubernetes/kops/pull/9334)
* Issue kubelet-api cert in nodeup [@johngmyers](https://github.com/johngmyers) [#9356](https://github.com/kubernetes/kops/pull/9356)
* Revert "Fix kube-apiserver-healthcheck image" [@johngmyers](https://github.com/johngmyers) [#9371](https://github.com/kubernetes/kops/pull/9371)
* Move host-network services off of port 8080 [@johngmyers](https://github.com/johngmyers) [#9355](https://github.com/kubernetes/kops/pull/9355)
* Remove bundler as baremetal support was removed [@johngmyers](https://github.com/johngmyers) [#9372](https://github.com/kubernetes/kops/pull/9372)
* Add support for AWS OIDC Provider [@rifelpet](https://github.com/rifelpet) [#9375](https://github.com/kubernetes/kops/pull/9375)
* NodeLocalDNS config population: small tweaks [@justinsb](https://github.com/justinsb) [#9376](https://github.com/kubernetes/kops/pull/9376)
* Add comment on blocking jobs to actions [@mikesplain](https://github.com/mikesplain) [#9305](https://github.com/kubernetes/kops/pull/9305)
* Prune old metrics-server and update HPA docs [@johngmyers](https://github.com/johngmyers) [#9233](https://github.com/kubernetes/kops/pull/9233)
* Upgrade mkdocs to latest versions [@rifelpet](https://github.com/rifelpet) [#9309](https://github.com/kubernetes/kops/pull/9309)
* Store terraform launchtemplate userdata in plaintext rather than b64 [@rifelpet](https://github.com/rifelpet) [#9340](https://github.com/kubernetes/kops/pull/9340)
* Update alpha channel with June releases [@MoShitrit](https://github.com/MoShitrit) [#9384](https://github.com/kubernetes/kops/pull/9384)
* try github actions failure to see if PRs can't be merged  [@rifelpet](https://github.com/rifelpet) [#9015](https://github.com/kubernetes/kops/pull/9015)
* Run "go mod vendor" in verify-gomod [@rifelpet](https://github.com/rifelpet) [#9389](https://github.com/kubernetes/kops/pull/9389)
* Start moving InstanceGroup data to NodeupConfig [@johngmyers](https://github.com/johngmyers) [#9391](https://github.com/kubernetes/kops/pull/9391)
* Refactor to clean up TemplateFunctions [@justinsb](https://github.com/justinsb) [#9390](https://github.com/kubernetes/kops/pull/9390)
* Revert "try github actions failures to see if PRs can't be merged" [@rifelpet](https://github.com/rifelpet) [#9392](https://github.com/kubernetes/kops/pull/9392)
* Add notice from k8s.io to docs site [@mikesplain](https://github.com/mikesplain) [#9393](https://github.com/kubernetes/kops/pull/9393)
* Issue aws-iam-authenticator cert in nodeup [@johngmyers](https://github.com/johngmyers) [#9378](https://github.com/kubernetes/kops/pull/9378)
* Updating cluster_spec doc. [@michalschott](https://github.com/michalschott) [#9380](https://github.com/kubernetes/kops/pull/9380)
* Add a couple more "area" labels [@rifelpet](https://github.com/rifelpet) [#9394](https://github.com/kubernetes/kops/pull/9394)
* Cache terraform's providers between tests [@rifelpet](https://github.com/rifelpet) [#9399](https://github.com/kubernetes/kops/pull/9399)
* Stop creating SHA1 hashes for build artifacts [@hakman](https://github.com/hakman) [#9400](https://github.com/kubernetes/kops/pull/9400)
* Add initial support for ARM64 [@hakman](https://github.com/hakman) [#8938](https://github.com/kubernetes/kops/pull/8938)
* Use -mod=vendor for most go commands [@rifelpet](https://github.com/rifelpet) [#9396](https://github.com/kubernetes/kops/pull/9396)
* Add olemarkus as reviewer [@hakman](https://github.com/hakman) [#9200](https://github.com/kubernetes/kops/pull/9200)
* Temporarily use containerd from Docker packages [@hakman](https://github.com/hakman) [#9346](https://github.com/kubernetes/kops/pull/9346)
* Fix override css [@mikesplain](https://github.com/mikesplain) [#9406](https://github.com/kubernetes/kops/pull/9406)
* Upgrade Amazon VPC CNI to 1.6.3 [@MoShitrit](https://github.com/MoShitrit) [#9408](https://github.com/kubernetes/kops/pull/9408)
* Fold multiple integration test cases into the complex test case [@rifelpet](https://github.com/rifelpet) [#9409](https://github.com/kubernetes/kops/pull/9409)
* Move apply logic down into pkg for import use [@johngmyers](https://github.com/johngmyers) [#9411](https://github.com/kubernetes/kops/pull/9411)
* Clean up the HA docs [@olemarkus](https://github.com/olemarkus) [#9387](https://github.com/kubernetes/kops/pull/9387)
* Add master and node image options when creating a cluster [@hakman](https://github.com/hakman) [#9407](https://github.com/kubernetes/kops/pull/9407)
* Implement VFS for vault [@olemarkus](https://github.com/olemarkus) [#9094](https://github.com/kubernetes/kops/pull/9094)
* Rolling update instance groups in consistent order [@johngmyers](https://github.com/johngmyers) [#9412](https://github.com/kubernetes/kops/pull/9412)
* Refactor lyft config file to Go code [@johngmyers](https://github.com/johngmyers) [#9410](https://github.com/kubernetes/kops/pull/9410)
* Update 1.17-NOTES.md [@wangxy518](https://github.com/wangxy518) [#9414](https://github.com/kubernetes/kops/pull/9414)
* Make dns pods work on arm64 clusters [@olemarkus](https://github.com/olemarkus) [#9418](https://github.com/kubernetes/kops/pull/9418)
* Typo and wording fix to getting_started/commands doc [@MoShitrit](https://github.com/MoShitrit) [#9417](https://github.com/kubernetes/kops/pull/9417)
* Alicloud: Refactor LoadBalancerWhiteList to LoadBalancerACL [@bittopaz](https://github.com/bittopaz) [#8304](https://github.com/kubernetes/kops/pull/8304)
* Remove PHONY declaration on non-phony targets [@johngmyers](https://github.com/johngmyers) [#9419](https://github.com/kubernetes/kops/pull/9419)
* Build and publish only Linux AMD64 Kops artifacts for CI [@hakman](https://github.com/hakman) [#9401](https://github.com/kubernetes/kops/pull/9401)
* Remove more sha1-generation code [@johngmyers](https://github.com/johngmyers) [#9423](https://github.com/kubernetes/kops/pull/9423)
* Fix: dns-controller: 3999 port address already in use [@vgunapati](https://github.com/vgunapati) [#9404](https://github.com/kubernetes/kops/pull/9404)
* Fix dns selectors for older k8s [@olemarkus](https://github.com/olemarkus) [#9431](https://github.com/kubernetes/kops/pull/9431)
* Fix staticcheck error with Go 1.14 [@johngmyers](https://github.com/johngmyers) [#9434](https://github.com/kubernetes/kops/pull/9434)
* Remove kube-discovery [@johngmyers](https://github.com/johngmyers) [#9435](https://github.com/kubernetes/kops/pull/9435)
* Start pushing create_cluster logic into pkg [@johngmyers](https://github.com/johngmyers) [#9413](https://github.com/kubernetes/kops/pull/9413)
* Spotinst: Add missing lifecycle to awstasks.SecurityGroup [@liranp](https://github.com/liranp) [#9445](https://github.com/kubernetes/kops/pull/9445)
* Prepatory refactoring of BootstrapScript [@johngmyers](https://github.com/johngmyers) [#9402](https://github.com/kubernetes/kops/pull/9402)
* Fix cilium etcd migration [@olemarkus](https://github.com/olemarkus) [#9451](https://github.com/kubernetes/kops/pull/9451)
* Spotinst: Support for Root Volume Size in Ocean Launch Spec [@liranp](https://github.com/liranp) [#9459](https://github.com/kubernetes/kops/pull/9459)
* Spotinst: Upgrade the Spotinst controller to version 1.0.61 [@liranp](https://github.com/liranp) [#9460](https://github.com/kubernetes/kops/pull/9460)
* Remove dead cloudup code [@johngmyers](https://github.com/johngmyers) [#9422](https://github.com/kubernetes/kops/pull/9422)
* Refactor BootstrapScript into a Task [@johngmyers](https://github.com/johngmyers) [#9449](https://github.com/kubernetes/kops/pull/9449)
* Refactor how api-server addresses are exported from tasks [@johngmyers](https://github.com/johngmyers) [#9450](https://github.com/kubernetes/kops/pull/9450)
* Add unit test for func VersionedJSON [@Hellcatlk](https://github.com/Hellcatlk) [#9458](https://github.com/kubernetes/kops/pull/9458)
* Cilium requires manual restart when migrating to nodeport [@olemarkus](https://github.com/olemarkus) [#9454](https://github.com/kubernetes/kops/pull/9454)
* Bump k8s versions for alpha channel with latest releases [@MoShitrit](https://github.com/MoShitrit) [#9455](https://github.com/kubernetes/kops/pull/9455)
* Enable nodeport by default [@olemarkus](https://github.com/olemarkus) [#9425](https://github.com/kubernetes/kops/pull/9425)
* Update staticcheck to latest version [@rifelpet](https://github.com/rifelpet) [#9463](https://github.com/kubernetes/kops/pull/9463)
* Add Ambassador addon to kops [@concaf](https://github.com/concaf) [#9115](https://github.com/kubernetes/kops/pull/9115)
* Update Calico to v3.15.0 for k8s 1.16+ [@hakman](https://github.com/hakman) [#9444](https://github.com/kubernetes/kops/pull/9444)
* Update KubeDNS to v1.15.13 [@hakman](https://github.com/hakman) [#9462](https://github.com/kubernetes/kops/pull/9462)
* Refactor more cluster creation code into NewCluster() [@johngmyers](https://github.com/johngmyers) [#9443](https://github.com/kubernetes/kops/pull/9443)
* Update the service manifest for Docker [@hakman](https://github.com/hakman) [#9465](https://github.com/kubernetes/kops/pull/9465)
* Cleanup tempfiles [@zhijianli88](https://github.com/zhijianli88) [#9472](https://github.com/kubernetes/kops/pull/9472)
* Fix where etcd-cluster-spec is writen when etcd's BackupStore is defined -v2 [@rdrgmnzs](https://github.com/rdrgmnzs) [#9474](https://github.com/kubernetes/kops/pull/9474)
* Create separate field for disabling rolling updates [@johngmyers](https://github.com/johngmyers) [#9348](https://github.com/kubernetes/kops/pull/9348)
* Move more cluster creation code to NewCluster() [@johngmyers](https://github.com/johngmyers) [#9467](https://github.com/kubernetes/kops/pull/9467)
* Continue moving InstanceGroup data to NodeupConfig [@johngmyers](https://github.com/johngmyers) [#9415](https://github.com/kubernetes/kops/pull/9415)
* Use new templates for cilium 1.8 [@olemarkus](https://github.com/olemarkus) [#9424](https://github.com/kubernetes/kops/pull/9424)
* Update terraform docs with version compatibility [@rifelpet](https://github.com/rifelpet) [#9488](https://github.com/kubernetes/kops/pull/9488)
* Updating the YAMLs for Ingress-Citrix Addon [@christus02](https://github.com/christus02) [#9480](https://github.com/kubernetes/kops/pull/9480)
* Allow CI builds to build a tagged version [@justinsb](https://github.com/justinsb) [#9493](https://github.com/kubernetes/kops/pull/9493)
* Release 1.19.0-alpha.1 [@justinsb](https://github.com/justinsb) [#9494](https://github.com/kubernetes/kops/pull/9494)

## 1.19.0-alpha.1 to 1.19.0-alpha.2

* Use kubelet docker-specific flags only for Docker [@hakman](https://github.com/hakman) [#9495](https://github.com/kubernetes/kops/pull/9495)
* cloudbuild: Push additional images from cloudbuild [@justinsb](https://github.com/justinsb) [#9497](https://github.com/kubernetes/kops/pull/9497)
* Release notes for 1.19.0-alpha.1 [@justinsb](https://github.com/justinsb) [#9498](https://github.com/kubernetes/kops/pull/9498)
* Release notes for 1.16.4 [@justinsb](https://github.com/justinsb) [#9501](https://github.com/kubernetes/kops/pull/9501)
* Update bazel rules versions [@rifelpet](https://github.com/rifelpet) [#9428](https://github.com/kubernetes/kops/pull/9428)
* Release notes for 1.17.1 [@justinsb](https://github.com/justinsb) [#9503](https://github.com/kubernetes/kops/pull/9503)
* Default ClusterDNS appropriately when NodeLocalDNS is enabled [@johngmyers](https://github.com/johngmyers) [#9491](https://github.com/kubernetes/kops/pull/9491)
* Fixing typos and rewording docs/examples/basic-requirements.md [@MoShitrit](https://github.com/MoShitrit) [#9442](https://github.com/kubernetes/kops/pull/9442)
* Move more cluster creation code to NewCluster() [@johngmyers](https://github.com/johngmyers) [#9490](https://github.com/kubernetes/kops/pull/9490)
* Continue refactoring certs into nodeup [@johngmyers](https://github.com/johngmyers) [#9354](https://github.com/kubernetes/kops/pull/9354)
* Update AWS VPC CNI docs to use `--networking amazonvpc` [@rifelpet](https://github.com/rifelpet) [#9509](https://github.com/kubernetes/kops/pull/9509)
* Update aws-sdk-go to v1.32.13 [@hakman](https://github.com/hakman) [#9510](https://github.com/kubernetes/kops/pull/9510)
* Add Ambassador documentation to addons docs [@concaf](https://github.com/concaf) [#9516](https://github.com/kubernetes/kops/pull/9516)
* Move remaining new cluster setup to pkg [@johngmyers](https://github.com/johngmyers) [#9513](https://github.com/kubernetes/kops/pull/9513)
* Changing base image for node authorizer. [@michalschott](https://github.com/michalschott) [#9056](https://github.com/kubernetes/kops/pull/9056)
* Update kube-router to v1.0.0 [@hakman](https://github.com/hakman) [#9512](https://github.com/kubernetes/kops/pull/9512)
* Remove deprecated function [@johngmyers](https://github.com/johngmyers) [#9514](https://github.com/kubernetes/kops/pull/9514)
* Add ability to set various cilium flags through CLI [@olemarkus](https://github.com/olemarkus) [#8928](https://github.com/kubernetes/kops/pull/8928)
* Add tag support to AWS launch templates [@rifelpet](https://github.com/rifelpet) [#9519](https://github.com/kubernetes/kops/pull/9519)
* Fix a link typo in the networking.md [@nikola-milikic](https://github.com/nikola-milikic) [#9461](https://github.com/kubernetes/kops/pull/9461)
* Cilium parse k8s version url [@olemarkus](https://github.com/olemarkus) [#9525](https://github.com/kubernetes/kops/pull/9525)
* Cloudmock cleanup - preparation for EC2 tag-on-create [@rifelpet](https://github.com/rifelpet) [#9520](https://github.com/kubernetes/kops/pull/9520)
* Update mock version to 1.19.0-alpha.1 [@hakman](https://github.com/hakman) [#9527](https://github.com/kubernetes/kops/pull/9527)
* Use EC2's tag-on-create for various resources [@rifelpet](https://github.com/rifelpet) [#9529](https://github.com/kubernetes/kops/pull/9529)
* Fix KubeDNS missing resourceVersion [@phspagiari](https://github.com/phspagiari),[@hakman](https://github.com/hakman) [#9521](https://github.com/kubernetes/kops/pull/9521)
* Use filebase64 for launch template userdata and Terraform 0.12 [@rifelpet](https://github.com/rifelpet) [#9532](https://github.com/kubernetes/kops/pull/9532)
* Promote alphas to stable [@olemarkus](https://github.com/olemarkus) [#9537](https://github.com/kubernetes/kops/pull/9537)
* Add some err judgments [@zhouhao3](https://github.com/zhouhao3) [#9538](https://github.com/kubernetes/kops/pull/9538)
* Force single arch support via env var [@hakman](https://github.com/hakman) [#9535](https://github.com/kubernetes/kops/pull/9535)
* Add lyft hash environment variable [@hintofbasil](https://github.com/hintofbasil) [#9539](https://github.com/kubernetes/kops/pull/9539)
* Update AWS IAM Authenticator to 0.5.1 [@rifelpet](https://github.com/rifelpet) [#9540](https://github.com/kubernetes/kops/pull/9540)
* Update CoreDNS to v1.7.0 - Take 2 [@rajansandeep](https://github.com/rajansandeep) [#9541](https://github.com/kubernetes/kops/pull/9541)
* Add healthcheck to aws-iam-authenticator [@rdrgmnzs](https://github.com/rdrgmnzs) [#8991](https://github.com/kubernetes/kops/pull/8991)
* Re-enable disk based evictions for Kubernetes 1.19 [@hakman](https://github.com/hakman) [#9475](https://github.com/kubernetes/kops/pull/9475)
* Switch AWS NAT Gateway creation to use tags on create [@rifelpet](https://github.com/rifelpet) [#8726](https://github.com/kubernetes/kops/pull/8726)
* Improve Makefile [@johngmyers](https://github.com/johngmyers) [#9542](https://github.com/kubernetes/kops/pull/9542)
* Remove the checksum workaround for Flannel VXLAN [@hakman](https://github.com/hakman) [#9543](https://github.com/kubernetes/kops/pull/9543)
* Widen the tolerations of kuberouter [@johngmyers](https://github.com/johngmyers) [#9547](https://github.com/kubernetes/kops/pull/9547)
* Add missing lifecycle to etcd keypair tasks [@johngmyers](https://github.com/johngmyers) [#9553](https://github.com/kubernetes/kops/pull/9553)
* Use a stable key for signing service account tokens [@johngmyers](https://github.com/johngmyers) [#9534](https://github.com/kubernetes/kops/pull/9534)
* Use distroless image as base for Protokube [@justinsb](https://github.com/justinsb),[@hakman](https://github.com/hakman) [#9403](https://github.com/kubernetes/kops/pull/9403)
* Use stable names for GH workflow jobs [@hakman](https://github.com/hakman) [#9552](https://github.com/kubernetes/kops/pull/9552)
* File permission test: clear umask before testing [@justinsb](https://github.com/justinsb) [#9562](https://github.com/kubernetes/kops/pull/9562)
* Don't try to delete terraform providers [@justinsb](https://github.com/justinsb) [#9561](https://github.com/kubernetes/kops/pull/9561)
* Release notes for 1.18.0-beta.2 [@justinsb](https://github.com/justinsb) [#9563](https://github.com/kubernetes/kops/pull/9563)
* Remove old unused files [@rifelpet](https://github.com/rifelpet) [#9564](https://github.com/kubernetes/kops/pull/9564)
* Add support for uploading to private buckets [@johngmyers](https://github.com/johngmyers) [#9568](https://github.com/kubernetes/kops/pull/9568)
* Upgrade to go 1.14.4 [@rifelpet](https://github.com/rifelpet) [#9499](https://github.com/kubernetes/kops/pull/9499)
* Upgrade go to 1.14.5 [@rifelpet](https://github.com/rifelpet) [#9572](https://github.com/kubernetes/kops/pull/9572)
* Update goimports script for go 1.14 [@rifelpet](https://github.com/rifelpet) [#9573](https://github.com/kubernetes/kops/pull/9573)
* [Digital Ocean] Implement KOPS validate cluster [@srikiz](https://github.com/srikiz) [#9476](https://github.com/kubernetes/kops/pull/9476)
* Update alpha channel with July releases [@hakman](https://github.com/hakman) [#9579](https://github.com/kubernetes/kops/pull/9579)
* Use fixed UID for etcd user and restrict to legacy provider [@johngmyers](https://github.com/johngmyers) [#9581](https://github.com/kubernetes/kops/pull/9581)
* Adding feature stability table to docs and including one example for encryption support in cilium [@MoShitrit](https://github.com/MoShitrit) [#9555](https://github.com/kubernetes/kops/pull/9555)
* Print error during cluster delete for dependency violation [@hakman](https://github.com/hakman) [#9589](https://github.com/kubernetes/kops/pull/9589)
* Specify user on export kubecfg [@olemarkus](https://github.com/olemarkus) [#9280](https://github.com/kubernetes/kops/pull/9280)
* Require extra flag when updating cluster with downgraded kops version [@johngmyers](https://github.com/johngmyers) [#9362](https://github.com/kubernetes/kops/pull/9362)
* Create one nodes instance group per zone [@johngmyers](https://github.com/johngmyers) [#9471](https://github.com/kubernetes/kops/pull/9471)
* Promote Ciprian & John to approvers [@hakman](https://github.com/hakman) [#9590](https://github.com/kubernetes/kops/pull/9590)
* Remove unused and unmaintained Docker build targets [@hakman](https://github.com/hakman) [#9576](https://github.com/kubernetes/kops/pull/9576)
* Remove min width on tables [@mikesplain](https://github.com/mikesplain) [#9592](https://github.com/kubernetes/kops/pull/9592)
* Remove support for legacy IAM permissions [@johngmyers](https://github.com/johngmyers) [#9492](https://github.com/kubernetes/kops/pull/9492)
* Update stable channel with July releases [@hakman](https://github.com/hakman) [#9596](https://github.com/kubernetes/kops/pull/9596)
* Improve locking in memfs [@johngmyers](https://github.com/johngmyers) [#9597](https://github.com/kubernetes/kops/pull/9597)
* Docs - Add the new feature table to various feature sections [@rifelpet](https://github.com/rifelpet) [#9585](https://github.com/kubernetes/kops/pull/9585)
* Update stretch images (from 1.11) in alpha channel [@justinsb](https://github.com/justinsb) [#9599](https://github.com/kubernetes/kops/pull/9599)
* Restore default SELinux security contexts for container runtime binaries [@hakman](https://github.com/hakman) [#9584](https://github.com/kubernetes/kops/pull/9584)
* Revert move to explicit dependencies [@johngmyers](https://github.com/johngmyers) [#9605](https://github.com/kubernetes/kops/pull/9605)
* Prefer nodes with "master" role for Calico Typha pods [@hakman](https://github.com/hakman) [#9609](https://github.com/kubernetes/kops/pull/9609)
* Add Ubuntu 20.04 support for Docker 18.06.3 [@hakman](https://github.com/hakman) [#9616](https://github.com/kubernetes/kops/pull/9616)
* Openstack fixes [@olemarkus](https://github.com/olemarkus) [#9554](https://github.com/kubernetes/kops/pull/9554)
* remove LB circular in OpenStack [@zetaab](https://github.com/zetaab) [#9623](https://github.com/kubernetes/kops/pull/9623)
* fix(docs): render double curly braces [@FrankYang0529](https://github.com/FrankYang0529) [#9626](https://github.com/kubernetes/kops/pull/9626)
* Use public client accessors within openstackCloud functions [@rifelpet](https://github.com/rifelpet) [#9628](https://github.com/kubernetes/kops/pull/9628)
* Exempt OpenStack from the EnableExternalCloudController feature flag [@johngmyers](https://github.com/johngmyers) [#9629](https://github.com/kubernetes/kops/pull/9629)
* Fix int to string conversions [@hakman](https://github.com/hakman) [#9630](https://github.com/kubernetes/kops/pull/9630)
* add os.RemoveAll err verification [@zhouhao3](https://github.com/zhouhao3) [#9610](https://github.com/kubernetes/kops/pull/9610)
* Update instructions for fixing verify-gomod.sh [@johngmyers](https://github.com/johngmyers) [#9636](https://github.com/kubernetes/kops/pull/9636)
* Add repo SECURITY.md [@joelsmith](https://github.com/joelsmith) [#9638](https://github.com/kubernetes/kops/pull/9638)
* Use "tag on create" for AWS Route Tables [@rifelpet](https://github.com/rifelpet) [#9639](https://github.com/kubernetes/kops/pull/9639)
* Spotinst: Upgrade the Spotinst controller to version 1.0.62 [@liranp](https://github.com/liranp) [#9642](https://github.com/kubernetes/kops/pull/9642)
* Add tagging support for AWS Keypairs [@rifelpet](https://github.com/rifelpet) [#9533](https://github.com/kubernetes/kops/pull/9533)
* Make ARM64 job blocking with TravisCI [@hakman](https://github.com/hakman) [#9644](https://github.com/kubernetes/kops/pull/9644)
* Upgrade Go to version 1.15rc1 [@hakman](https://github.com/hakman) [#9641](https://github.com/kubernetes/kops/pull/9641)
* Replace custom codegen package with gengo [@johngmyers](https://github.com/johngmyers) [#9632](https://github.com/kubernetes/kops/pull/9632)
* Calico: Upgrade the "k8s-ec2-srcdst" controller to version v0.3.0 [@seh](https://github.com/seh) [#9647](https://github.com/kubernetes/kops/pull/9647)
* Remove dead code from tasks [@johngmyers](https://github.com/johngmyers) [#9646](https://github.com/kubernetes/kops/pull/9646)
* Cleanup AWS EC2 eventual consistency warnings [@hakman](https://github.com/hakman) [#9637](https://github.com/kubernetes/kops/pull/9637)
* Cleanup unused loader features [@johngmyers](https://github.com/johngmyers) [#9649](https://github.com/kubernetes/kops/pull/9649)
* Promote alpha channel to stable [@johngmyers](https://github.com/johngmyers) [#9652](https://github.com/kubernetes/kops/pull/9652)
* Remove tags from NodeupConfig [@johngmyers](https://github.com/johngmyers) [#9650](https://github.com/kubernetes/kops/pull/9650)
* Release 1.19.0-alpha.2 [@justinsb](https://github.com/justinsb) [#9654](https://github.com/kubernetes/kops/pull/9654)

## 1.19.0-alpha.2 to 1.19.0-alpha.3

* Update Calico to v3.15.1 for k8s 1.16+ [@hakman](https://github.com/hakman) [#9656](https://github.com/kubernetes/kops/pull/9656)
* Release notes for 1.19.0-alpha.2 [@justinsb](https://github.com/justinsb) [#9658](https://github.com/kubernetes/kops/pull/9658)
* Use BAZEL_OPTIONS  for bazel build [@srikiz](https://github.com/srikiz) [#9651](https://github.com/kubernetes/kops/pull/9651)
* Document new release process for kops 1.19 and on [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#9660](https://github.com/kubernetes/kops/pull/9660)
* Prefer nodes with "master" role for Canal Typha pods [@hakman](https://github.com/hakman) [#9663](https://github.com/kubernetes/kops/pull/9663)
* Refactor networking assets finder [@hakman](https://github.com/hakman) [#9665](https://github.com/kubernetes/kops/pull/9665)
* Release notes for 1.18.0 [@justinsb](https://github.com/justinsb) [#9668](https://github.com/kubernetes/kops/pull/9668)
* Update releases.md and alpha channel for 1.18.0 release [@johngmyers](https://github.com/johngmyers) [#9669](https://github.com/kubernetes/kops/pull/9669)
* Refactor openstackCloud to be mockable, add a MockCloud [@rifelpet](https://github.com/rifelpet) [#9645](https://github.com/kubernetes/kops/pull/9645)
* GCE: Fix spurious comparison failures on adddress & InstanceTemplate [@justinsb](https://github.com/justinsb) [#9671](https://github.com/kubernetes/kops/pull/9671)
* Upgrade cluster-proportional-autoscaler to multi-arch image [@johngmyers](https://github.com/johngmyers) [#9674](https://github.com/kubernetes/kops/pull/9674)
* Move cluster-proportional-autoscaler to worker nodes [@hakman](https://github.com/hakman) [#9676](https://github.com/kubernetes/kops/pull/9676)
* When channel is unavailable, don't try to validate things from it [@olemarkus](https://github.com/olemarkus) [#9559](https://github.com/kubernetes/kops/pull/9559)
* Determine fixedip during nodeup directly [@olemarkus](https://github.com/olemarkus) [#9560](https://github.com/kubernetes/kops/pull/9560)
* Remove embedded structs from spotinst terraform types [@rifelpet](https://github.com/rifelpet) [#9682](https://github.com/kubernetes/kops/pull/9682)
* Spotinst: Change `ScaleDown.MaxPercentage` from int to float64 [@liranp](https://github.com/liranp) [#9683](https://github.com/kubernetes/kops/pull/9683)
* Update protobuf to v1.4.2 [@hakman](https://github.com/hakman) [#9686](https://github.com/kubernetes/kops/pull/9686)
* Add missing locking in MockEC2 [@johngmyers](https://github.com/johngmyers) [#9677](https://github.com/kubernetes/kops/pull/9677)
* Openstack - Don't panic if the dns zone is not found [@rifelpet](https://github.com/rifelpet) [#9690](https://github.com/kubernetes/kops/pull/9690)
* Add an initial structure for openstack cloudmock [@rifelpet](https://github.com/rifelpet) [#9691](https://github.com/kubernetes/kops/pull/9691)
* Spotinst: Upgrade the Spot Cluster Controller to version 1.0.63 [@liranp](https://github.com/liranp) [#9696](https://github.com/kubernetes/kops/pull/9696)
* Add markdown code block to bug report GH issue template [@rifelpet](https://github.com/rifelpet) [#9697](https://github.com/kubernetes/kops/pull/9697)
* Spotinst: Selecting a default Instance Group in Spot Ocean should be optional [@liranp](https://github.com/liranp) [#9699](https://github.com/kubernetes/kops/pull/9699)
* [Digital Ocean] Upload binaries to DO Spaces [@srikiz](https://github.com/srikiz) [#9672](https://github.com/kubernetes/kops/pull/9672)
* Adds support for using OS application credentials [@olemarkus](https://github.com/olemarkus) [#9702](https://github.com/kubernetes/kops/pull/9702)
* Allow configurable backend modes for aws-iam-authenticator [@WarpRat](https://github.com/WarpRat) [#9500](https://github.com/kubernetes/kops/pull/9500)
* Add support for cilium on openstack [@olemarkus](https://github.com/olemarkus) [#9703](https://github.com/kubernetes/kops/pull/9703)
* Update Go to v1.15rc2 [@hakman](https://github.com/hakman) [#9709](https://github.com/kubernetes/kops/pull/9709)
* Update k8s dependencies to v1.18.6 [@hakman](https://github.com/hakman) [#9711](https://github.com/kubernetes/kops/pull/9711)
* Fix bazel darwin hash for Go 15rc2 [@hakman](https://github.com/hakman) [#9714](https://github.com/kubernetes/kops/pull/9714)
* Make it possible to change subnet dns servers [@olemarkus](https://github.com/olemarkus) [#9715](https://github.com/kubernetes/kops/pull/9715)
* Update example for Resources Reservation [@hakman](https://github.com/hakman) [#9708](https://github.com/kubernetes/kops/pull/9708)
* Improve the error logged when multiple DNS Zones match the provided name [@rifelpet](https://github.com/rifelpet) [#9717](https://github.com/kubernetes/kops/pull/9717)
* Default kubelet authorization-mode to Webhook for k8s 1.19+ [@johngmyers](https://github.com/johngmyers) [#9718](https://github.com/kubernetes/kops/pull/9718)
* Respect Topology when assigning floating ips or not [@olemarkus](https://github.com/olemarkus) [#9701](https://github.com/kubernetes/kops/pull/9701)
* Capture logs from a kops cluster [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#8577](https://github.com/kubernetes/kops/pull/8577)
* Update docs for Amazon Linux 2 [@hakman](https://github.com/hakman) [#9720](https://github.com/kubernetes/kops/pull/9720)
*  Update SECURITY_CONTACTS [@johngmyers](https://github.com/johngmyers) [#9627](https://github.com/kubernetes/kops/pull/9627)
* Remove amd64 TravisCI jobs [@rifelpet](https://github.com/rifelpet) [#9005](https://github.com/kubernetes/kops/pull/9005)
* Implement Openstack cloudmock, add integration test [@rifelpet](https://github.com/rifelpet) [#9722](https://github.com/kubernetes/kops/pull/9722)
* Add cinder plugin [@olemarkus](https://github.com/olemarkus) [#9700](https://github.com/kubernetes/kops/pull/9700)
* Add windows job to GH workflows [@hakman](https://github.com/hakman) [#9721](https://github.com/kubernetes/kops/pull/9721)
* Add instance-selector cmd to toolbox [@bwagner5](https://github.com/bwagner5) [#9478](https://github.com/kubernetes/kops/pull/9478)
* Upgrade CI jobs to go 1.15.0 [@rifelpet](https://github.com/rifelpet) [#9733](https://github.com/kubernetes/kops/pull/9733)
* Upgrade AWS VPC CNI provider to 1.6.4 [@rifelpet](https://github.com/rifelpet) [#9734](https://github.com/kubernetes/kops/pull/9734)
* Update Go to v1.15.0 for Bazel [@hakman](https://github.com/hakman) [#9735](https://github.com/kubernetes/kops/pull/9735)
* Add missing cli options for kube-controller-manager and kube-scheduler [@Evalle](https://github.com/Evalle) [#9726](https://github.com/kubernetes/kops/pull/9726)
* Fix test-windows target [@hakman](https://github.com/hakman) [#9738](https://github.com/kubernetes/kops/pull/9738)
* Add an integration test for openstack floating ip [@olemarkus](https://github.com/olemarkus) [#9739](https://github.com/kubernetes/kops/pull/9739)
* Fix update and verify goimports [@hakman](https://github.com/hakman) [#9740](https://github.com/kubernetes/kops/pull/9740)
* Upgrade to Terraform 0.13.0 [@rifelpet](https://github.com/rifelpet) [#9742](https://github.com/kubernetes/kops/pull/9742)
* Update cluster-proportional-autoscaler to v1.8.3 [@hakman](https://github.com/hakman) [#9744](https://github.com/kubernetes/kops/pull/9744)
* Update link names for releases [@hakman](https://github.com/hakman) [#9743](https://github.com/kubernetes/kops/pull/9743)
* Update images docs [@hakman](https://github.com/hakman) [#9736](https://github.com/kubernetes/kops/pull/9736)
* Remove unused Tags and FSRoot from NodeUp [@hakman](https://github.com/hakman) [#9737](https://github.com/kubernetes/kops/pull/9737)
* Spotinst: Support for Instance Types in Ocean Launch Spec [@liranp](https://github.com/liranp) [#9746](https://github.com/kubernetes/kops/pull/9746)
* Update alpha channel with August releases [@MoShitrit](https://github.com/MoShitrit) [#9748](https://github.com/kubernetes/kops/pull/9748)
* Update shared-VPC documentation [@johngmyers](https://github.com/johngmyers) [#9719](https://github.com/kubernetes/kops/pull/9719)
* Support for using hostPort when using kube-router [@andsens](https://github.com/andsens) [#9689](https://github.com/kubernetes/kops/pull/9689)
* Move kubernetes 1.18 from alpha to stable [@mariusv](https://github.com/mariusv) [#9754](https://github.com/kubernetes/kops/pull/9754)
* Add the client cert / ACM cert known issue to the 1.18 release notes [@rifelpet](https://github.com/rifelpet) [#9758](https://github.com/kubernetes/kops/pull/9758)
* Remove unused tags functionality [@johngmyers](https://github.com/johngmyers) [#9759](https://github.com/kubernetes/kops/pull/9759)
* Default kubelet authenticationTokenWebhook to true for k8s 1.19+ [@johngmyers](https://github.com/johngmyers) [#9757](https://github.com/kubernetes/kops/pull/9757)
* Reduce the lifetime of exported kubecfg credentials [@johngmyers](https://github.com/johngmyers) [#9593](https://github.com/kubernetes/kops/pull/9593)
* Add ARM64 support for masters [@hakman](https://github.com/hakman) [#9566](https://github.com/kubernetes/kops/pull/9566)
* Clear KOPS_FEATURE_FLAGS in update-expected.sh [@justinsb](https://github.com/justinsb) [#9764](https://github.com/kubernetes/kops/pull/9764)
* Bootstrap worker nodes using kops-controller [@johngmyers](https://github.com/johngmyers) [#9653](https://github.com/kubernetes/kops/pull/9653)
* Upgrade to klog v2 [@rifelpet](https://github.com/rifelpet) [#9765](https://github.com/kubernetes/kops/pull/9765)
* Issue more certs out of kops-controller [@johngmyers](https://github.com/johngmyers) [#9771](https://github.com/kubernetes/kops/pull/9771)
* Fix backwards compatibility when backend mode isn't set [@WarpRat](https://github.com/WarpRat) [#9755](https://github.com/kubernetes/kops/pull/9755)
* Update more klog v1 references to v2 [@rifelpet](https://github.com/rifelpet) [#9772](https://github.com/kubernetes/kops/pull/9772)
* Document Docker iptables settings [@hakman](https://github.com/hakman) [#9760](https://github.com/kubernetes/kops/pull/9760)
* Use /etc/os-release to identify the distribution [@hakman](https://github.com/hakman) [#9766](https://github.com/kubernetes/kops/pull/9766)
* Issue the cilium etcd client cert out of kops-controller [@johngmyers](https://github.com/johngmyers) [#9776](https://github.com/kubernetes/kops/pull/9776)
* Only add OS variables if they are needed [@olemarkus](https://github.com/olemarkus) [#9778](https://github.com/kubernetes/kops/pull/9778)
* Add support for containerd v1.4.0 [@hakman](https://github.com/hakman) [#9777](https://github.com/kubernetes/kops/pull/9777)
* Don't give access to calico-client key when not needed [@johngmyers](https://github.com/johngmyers) [#9779](https://github.com/kubernetes/kops/pull/9779)
* Squash patch versions of old release notes [@hakman](https://github.com/hakman) [#9770](https://github.com/kubernetes/kops/pull/9770)
* Enhancement in Ubuntu or debian apt-get and CI issue fix [@Rajpratik71](https://github.com/Rajpratik71) [#8687](https://github.com/kubernetes/kops/pull/8687)
* feat(openstack): propagate cloud labels to machines [@mitch000001](https://github.com/mitch000001) [#9211](https://github.com/kubernetes/kops/pull/9211)
* Add release note about cert expiration [@johngmyers](https://github.com/johngmyers) [#9781](https://github.com/kubernetes/kops/pull/9781)
* Put userid in kubecfg cert CommonName [@johngmyers](https://github.com/johngmyers) [#9780](https://github.com/kubernetes/kops/pull/9780)
* Adding support for permission boundaries for AWS IAM Roles [@victorfrancax1](https://github.com/victorfrancax1) [#9773](https://github.com/kubernetes/kops/pull/9773)
* Update Weave Net to v2.7.0 [@hakman](https://github.com/hakman) [#9783](https://github.com/kubernetes/kops/pull/9783)
* Upgrade AWS VPC CNI to 1.7.0 [@MoShitrit](https://github.com/MoShitrit) [#9786](https://github.com/kubernetes/kops/pull/9786)
* Unset more env vars in update-expected.sh [@rifelpet](https://github.com/rifelpet) [#9789](https://github.com/kubernetes/kops/pull/9789)
* Ignore the disableTxChecksumOffloading flag for Flannel and Canal [@hakman](https://github.com/hakman) [#9782](https://github.com/kubernetes/kops/pull/9782)
* Add flag for root volume encryption [@hakman](https://github.com/hakman) [#9793](https://github.com/kubernetes/kops/pull/9793)
* Don't use nova for glance mocks [@olemarkus](https://github.com/olemarkus) [#9792](https://github.com/kubernetes/kops/pull/9792)
* Fix feature flag typo in release notes [@rifelpet](https://github.com/rifelpet) [#9796](https://github.com/kubernetes/kops/pull/9796)
* De-emphasize bootstrap tokens and document node authorization as depr… [@johngmyers](https://github.com/johngmyers) [#9791](https://github.com/kubernetes/kops/pull/9791)
* Update the openstack getting started docs [@olemarkus](https://github.com/olemarkus) [#9797](https://github.com/kubernetes/kops/pull/9797)
* Mock create server should associate with mock ports [@olemarkus](https://github.com/olemarkus) [#9798](https://github.com/kubernetes/kops/pull/9798)
* Upgrade gophercloud to v1.11.0 [@olemarkus](https://github.com/olemarkus) [#9800](https://github.com/kubernetes/kops/pull/9800)
* Update validation for Calico to assume etcd3 as default [@hakman](https://github.com/hakman) [#9803](https://github.com/kubernetes/kops/pull/9803)
* Update API slice fields to not use pointers [@rifelpet](https://github.com/rifelpet) [#9802](https://github.com/kubernetes/kops/pull/9802)
* Bump stable versions from alpha [@MoShitrit](https://github.com/MoShitrit) [#9804](https://github.com/kubernetes/kops/pull/9804)
* Release 1.19.0-alpha.3 [@hakman](https://github.com/hakman) [#9801](https://github.com/kubernetes/kops/pull/9801)

## 1.19.0-alpha.3 to 1.19.0-alpha.4

* Upgrade kubernetes dependencies to 1.19.0-rc.4 [@rifelpet](https://github.com/rifelpet) [#9565](https://github.com/kubernetes/kops/pull/9565)
* Release notes for 1.19.0-alpha.3 [@hakman](https://github.com/hakman) [#9805](https://github.com/kubernetes/kops/pull/9805)
* Stop trying to pull the Protokube image [@hakman](https://github.com/hakman) [#9809](https://github.com/kubernetes/kops/pull/9809)
* Add all images to GH release [@hakman](https://github.com/hakman) [#9811](https://github.com/kubernetes/kops/pull/9811)
* Refactor: KopsModelContext embeds IAMModelContext [@justinsb](https://github.com/justinsb) [#9814](https://github.com/kubernetes/kops/pull/9814)
* Adding docs on AWS Permissions Boundaries support [@victorfrancax1](https://github.com/victorfrancax1) [#9807](https://github.com/kubernetes/kops/pull/9807)
* Fix GCE cluster creation with private topology [@rifelpet](https://github.com/rifelpet) [#9815](https://github.com/kubernetes/kops/pull/9815)
* Support writing a full certificate chain [@justinsb](https://github.com/justinsb) [#9812](https://github.com/kubernetes/kops/pull/9812)
* Update Calico to v3.15.2 for k8s 1.16+ [@hakman](https://github.com/hakman) [#9816](https://github.com/kubernetes/kops/pull/9816)
* Update kube-router to v1.0.1 [@hakman](https://github.com/hakman) [#9818](https://github.com/kubernetes/kops/pull/9818)
* Remove compute floating ip extension [@olemarkus](https://github.com/olemarkus) [#9790](https://github.com/kubernetes/kops/pull/9790)
* Pull images from k8s.gcr.io/kops instead of docker.io/kope [@hakman](https://github.com/hakman) [#9808](https://github.com/kubernetes/kops/pull/9808)
* Upgrade AWS VPC CNI to 1.7.1 [@MoShitrit](https://github.com/MoShitrit) [#9822](https://github.com/kubernetes/kops/pull/9822)
* Update k8s dependencies to v1.19.0 [@hakman](https://github.com/hakman) [#9824](https://github.com/kubernetes/kops/pull/9824)
* Remove unknown rules from managed security groups on openstack [@olemarkus](https://github.com/olemarkus) [#9820](https://github.com/kubernetes/kops/pull/9820)
* Add --internal flag for export kubecfg that targets the internal dns name [@rifelpet](https://github.com/rifelpet) [#9732](https://github.com/kubernetes/kops/pull/9732)
* Reconcile ports and floating ips [@olemarkus](https://github.com/olemarkus) [#9821](https://github.com/kubernetes/kops/pull/9821)
* GCE - Set Bastion InstanceGroup zone [@rifelpet](https://github.com/rifelpet) [#9827](https://github.com/kubernetes/kops/pull/9827)
* Move from debian-hyperkube-base to debian-base for node-authorizer [@rdrgmnzs](https://github.com/rdrgmnzs) [#9828](https://github.com/kubernetes/kops/pull/9828)
* Add kops delete instance command [@olemarkus](https://github.com/olemarkus) [#9784](https://github.com/kubernetes/kops/pull/9784)
* remove nodeAffinity from typha [@ozdanborne](https://github.com/ozdanborne) [#9826](https://github.com/kubernetes/kops/pull/9826)
* Use the get_workspace_status script to get the versions [@justinsb](https://github.com/justinsb) [#9830](https://github.com/kubernetes/kops/pull/9830)
* cloudbuild: allow CI env var to be specified [@justinsb](https://github.com/justinsb) [#9831](https://github.com/kubernetes/kops/pull/9831)
* TaskDependentResource: support preview when the task isn't ready [@justinsb](https://github.com/justinsb) [#9837](https://github.com/kubernetes/kops/pull/9837)
* Addons: Support arbitrary additional objects [@justinsb](https://github.com/justinsb) [#8119](https://github.com/kubernetes/kops/pull/8119)
* add support for cors-allowed-origins [@etwillbefine](https://github.com/etwillbefine) [#9838](https://github.com/kubernetes/kops/pull/9838)
* Implement setter by reflection [@justinsb](https://github.com/justinsb) [#8896](https://github.com/kubernetes/kops/pull/8896)
* Expose JWKS via a feature-flag [@justinsb](https://github.com/justinsb) [#9813](https://github.com/kubernetes/kops/pull/9813)
* Support authentication helper for kubectl [@justinsb](https://github.com/justinsb) [#9667](https://github.com/kubernetes/kops/pull/9667)
* Always use OpenStack Swift reauthentication [@justinsb](https://github.com/justinsb) [#9836](https://github.com/kubernetes/kops/pull/9836)
* Upgrade cilium versions [@olemarkus](https://github.com/olemarkus) [#9843](https://github.com/kubernetes/kops/pull/9843)
* Dont generate the ssl_certificate_id field on TCP listeners in Terraform [@rifelpet](https://github.com/rifelpet) [#9839](https://github.com/kubernetes/kops/pull/9839)
* Spotinst: Upgrade the Spot Cluster Controller to version 1.0.64 [@liranp](https://github.com/liranp) [#9846](https://github.com/kubernetes/kops/pull/9846)
* Update OpenStack CSIDriver to v1 and update few csi deps [@zetaab](https://github.com/zetaab) [#9847](https://github.com/kubernetes/kops/pull/9847)
* Remove more machinery for file-based cloudup models [@johngmyers](https://github.com/johngmyers) [#9841](https://github.com/kubernetes/kops/pull/9841)
* Keep SHELLCHECK_IMAGE vesion sync with SHELLCHECK_VERSION defined before [@MaXinjian](https://github.com/MaXinjian) [#9849](https://github.com/kubernetes/kops/pull/9849)
* Cloudinstances refactor [@olemarkus](https://github.com/olemarkus) [#9799](https://github.com/kubernetes/kops/pull/9799)
* Populate cloudinstances data on openstack [@olemarkus](https://github.com/olemarkus) [#9850](https://github.com/kubernetes/kops/pull/9850)
* Refactor IAM route53 construction [@justinsb](https://github.com/justinsb) [#9853](https://github.com/kubernetes/kops/pull/9853)
* Improve description of detaching instances [@johngmyers](https://github.com/johngmyers) [#9859](https://github.com/kubernetes/kops/pull/9859)
* Add command for listing cloud instances [@olemarkus](https://github.com/olemarkus) [#9762](https://github.com/kubernetes/kops/pull/9762)
* fix "unbound variable" issue [@MaXinjian](https://github.com/MaXinjian) [#9851](https://github.com/kubernetes/kops/pull/9851)
* Add instance info to detached nodes [@olemarkus](https://github.com/olemarkus) [#9860](https://github.com/kubernetes/kops/pull/9860)
* Update installation [@inductor](https://github.com/inductor) [#9864](https://github.com/kubernetes/kops/pull/9864)
* Update Calico to v3.16.0 for k8s 1.16+ [@hakman](https://github.com/hakman) [#9829](https://github.com/kubernetes/kops/pull/9829)
* Update alpha channel k8s 1.16 to 1.16.15 and Ubuntu image to latest available [@MoShitrit](https://github.com/MoShitrit) [#9869](https://github.com/kubernetes/kops/pull/9869)
* Implement cluster autoscaler as bootstrap addon [@olemarkus](https://github.com/olemarkus) [#9787](https://github.com/kubernetes/kops/pull/9787)
* Bump cilium to 1.8.3 [@olemarkus](https://github.com/olemarkus) [#9871](https://github.com/kubernetes/kops/pull/9871)
* Openstack golden servergrouptests [@olemarkus](https://github.com/olemarkus) [#9874](https://github.com/kubernetes/kops/pull/9874)
* Map ENOENT to ErrNotExist in FSPath [@johngmyers](https://github.com/johngmyers) [#9877](https://github.com/kubernetes/kops/pull/9877)
* Update Go to v1.15.1 [@hakman](https://github.com/hakman) [#9878](https://github.com/kubernetes/kops/pull/9878)
* Add kubelet cgroup driver property [@bmelbourne](https://github.com/bmelbourne) [#9879](https://github.com/kubernetes/kops/pull/9879)
* verify-terraform: rearrange arguments to find [@justinsb](https://github.com/justinsb) [#9881](https://github.com/kubernetes/kops/pull/9881)
* Update mock version to 1.19.0-alpha.3 [@hakman](https://github.com/hakman) [#9884](https://github.com/kubernetes/kops/pull/9884)
* Use new GitHub artifact names for mirrored assets [@hakman](https://github.com/hakman) [#9882](https://github.com/kubernetes/kops/pull/9882)
* Use root volume encryption flag for LaunchConfiguration with TF and CF [@hakman](https://github.com/hakman) [#9872](https://github.com/kubernetes/kops/pull/9872)
* Errors when encryptionConfig is enabled, but no encryptionconfig secret [@olemarkus](https://github.com/olemarkus) [#9885](https://github.com/kubernetes/kops/pull/9885)
* Add missing spot support to launch template direct render [@johngmyers](https://github.com/johngmyers) [#9897](https://github.com/kubernetes/kops/pull/9897)
* Don't explicitly set insecure-bind-address on newer k8s [@olemarkus](https://github.com/olemarkus) [#9899](https://github.com/kubernetes/kops/pull/9899)
* Deprecate old cluster autoscaler addon [@olemarkus](https://github.com/olemarkus) [#9892](https://github.com/kubernetes/kops/pull/9892)
* Update Calico to v3.16.1 [@hakman](https://github.com/hakman) [#9894](https://github.com/kubernetes/kops/pull/9894)
* Nodelocalcache configure resources [@commixon](https://github.com/commixon) [#9901](https://github.com/kubernetes/kops/pull/9901)
* Release notes for 1.17.2 [@justinsb](https://github.com/justinsb) [#9902](https://github.com/kubernetes/kops/pull/9902)
* Release notes for 1.18.1 [@justinsb](https://github.com/justinsb) [#9904](https://github.com/kubernetes/kops/pull/9904)
* Allow caching of Nodeidentity Info in kops-controller for AWS. [@rdrgmnzs](https://github.com/rdrgmnzs) [#9908](https://github.com/kubernetes/kops/pull/9908)
* Simplified form of IAM Roles for ServiceAccounts [@justinsb](https://github.com/justinsb) [#9352](https://github.com/kubernetes/kops/pull/9352)
* Detect AWS region for S3 inside containers [@hakman](https://github.com/hakman) [#9857](https://github.com/kubernetes/kops/pull/9857)
* Only apply external policies when these are defined [@kesor](https://github.com/kesor) [#9867](https://github.com/kubernetes/kops/pull/9867)
* Get launch template versions after filtering templates [@johngmyers](https://github.com/johngmyers) [#9909](https://github.com/kubernetes/kops/pull/9909)
* Remove constraint of setting volume type for OS [@olemarkus](https://github.com/olemarkus) [#9907](https://github.com/kubernetes/kops/pull/9907)
* Remove force_tcp flag for nodelocalcache dot zone [@astrikos](https://github.com/astrikos) [#9917](https://github.com/kubernetes/kops/pull/9917)
* Validate labels [@olemarkus](https://github.com/olemarkus) [#9918](https://github.com/kubernetes/kops/pull/9918)
* Add missing setResources on CA task [@justinsb](https://github.com/justinsb) [#9919](https://github.com/kubernetes/kops/pull/9919)
* Add missing flags to cluster autoscaler template [@olemarkus](https://github.com/olemarkus) [#9925](https://github.com/kubernetes/kops/pull/9925)
* Add unit test for pkg/apis/kops/model/features.go [@hs0210](https://github.com/hs0210) [#9883](https://github.com/kubernetes/kops/pull/9883)
* Continue if asg instance is unknown [@olemarkus](https://github.com/olemarkus) [#9900](https://github.com/kubernetes/kops/pull/9900)
* Allow the BootstrapClient task to run after Protokube [@hakman](https://github.com/hakman) [#9911](https://github.com/kubernetes/kops/pull/9911)
* Document process to get older releases into artifacts.k8s.io [@justinsb](https://github.com/justinsb) [#9934](https://github.com/kubernetes/kops/pull/9934)
* Don't write application credentials to cloud config unless external CCM is enabled [@olemarkus](https://github.com/olemarkus) [#9935](https://github.com/kubernetes/kops/pull/9935)
* add kube-system psp to system:nodes [@zetaab](https://github.com/zetaab) [#9941](https://github.com/kubernetes/kops/pull/9941)
* use subnet also when creating floatingip [@zetaab](https://github.com/zetaab) [#9936](https://github.com/kubernetes/kops/pull/9936)
* Block external CCM for k8s less than 1.13 [@olemarkus](https://github.com/olemarkus) [#9943](https://github.com/kubernetes/kops/pull/9943)
* Force external cloud controller manager on OS [@olemarkus](https://github.com/olemarkus) [#9942](https://github.com/kubernetes/kops/pull/9942)
* Update Go to v1.15.2 [@hakman](https://github.com/hakman) [#9944](https://github.com/kubernetes/kops/pull/9944)
* Only add additional policies to kops managed IAMRoles [@hakman](https://github.com/hakman) [#9924](https://github.com/kubernetes/kops/pull/9924)
* Release 1.19.0-alpha.4 [@hakman](https://github.com/hakman) [#9949](https://github.com/kubernetes/kops/pull/9949)

## 1.19.0-alpha.4 to 1.19.0-alpha.5

* Release notes for 1.19.0-alpha.4 [@hakman](https://github.com/hakman) [#9950](https://github.com/kubernetes/kops/pull/9950)
* Support ChainInsertMode config option for Calico Networking [@asmith030](https://github.com/asmith030) [#9945](https://github.com/kubernetes/kops/pull/9945)
* Add instance groups and k8s 1.19 to bootstrapchannelbuilder tests [@rifelpet](https://github.com/rifelpet) [#9962](https://github.com/kubernetes/kops/pull/9962)
* Bump k8s versions and Ubuntu ami version to latest [@MoShitrit](https://github.com/MoShitrit) [#9963](https://github.com/kubernetes/kops/pull/9963)
* AWS add cluster tag to detachinstances/findinstances filters [@zetaab](https://github.com/zetaab) [#9961](https://github.com/kubernetes/kops/pull/9961)
* Update containerd to v1.4.1 [@hakman](https://github.com/hakman) [#9968](https://github.com/kubernetes/kops/pull/9968)
* Add addon for aws node termination handler [@olemarkus](https://github.com/olemarkus) [#9921](https://github.com/kubernetes/kops/pull/9921)
* Use all kops mirrors to determine artifacts hashes [@hakman](https://github.com/hakman) [#9958](https://github.com/kubernetes/kops/pull/9958)
* OpenStack: allow to specify storageClass creation to false [@zetaab](https://github.com/zetaab) [#9971](https://github.com/kubernetes/kops/pull/9971)
* Add AWS partition support to iam service account roles [@rifelpet](https://github.com/rifelpet) [#9964](https://github.com/kubernetes/kops/pull/9964)
* Update Docker to v19.03.13 [@hakman](https://github.com/hakman) [#9969](https://github.com/kubernetes/kops/pull/9969)
* Improve kops get instances when api is unavailable [@olemarkus](https://github.com/olemarkus) [#9938](https://github.com/kubernetes/kops/pull/9938)
* Fix fip description [@olemarkus](https://github.com/olemarkus) [#9965](https://github.com/kubernetes/kops/pull/9965)
* Updating the Version [@christus02](https://github.com/christus02) [#9975](https://github.com/kubernetes/kops/pull/9975)
* Add missing permissions for cilium-operator [@codablock](https://github.com/codablock) [#9979](https://github.com/kubernetes/kops/pull/9979)
* Consolidate all buildMinimalClusters into a generic test cluster builder [@olemarkus](https://github.com/olemarkus) [#9972](https://github.com/kubernetes/kops/pull/9972)
* Build cloud outside of PerformAssignments [@olemarkus](https://github.com/olemarkus) [#9973](https://github.com/kubernetes/kops/pull/9973)
* Bumping k8s versions and ubuntu AMI version from alpha to stable [@MoShitrit](https://github.com/MoShitrit) [#9986](https://github.com/kubernetes/kops/pull/9986)
* Update mkdocs dependencies and pin macro plugin [@rifelpet](https://github.com/rifelpet) [#9988](https://github.com/kubernetes/kops/pull/9988)
* Fix nil pointer when instance has not joined the cluster [@olemarkus](https://github.com/olemarkus) [#9985](https://github.com/kubernetes/kops/pull/9985)
* Production recommendations document [@olemarkus](https://github.com/olemarkus) [#9984](https://github.com/kubernetes/kops/pull/9984)
* Clarified S3 state store encryption default [@CrossRoast](https://github.com/CrossRoast) [#9991](https://github.com/kubernetes/kops/pull/9991)
* Add deprecation notice for support of Terraform v0.11 [@bmelbourne](https://github.com/bmelbourne) [#9989](https://github.com/kubernetes/kops/pull/9989)
* Fix CAS ASG configuration [@olemarkus](https://github.com/olemarkus) [#9993](https://github.com/kubernetes/kops/pull/9993)
* Fix small typo in create cluster help output [@erismaster](https://github.com/erismaster) [#9995](https://github.com/kubernetes/kops/pull/9995)
* Set ctx and cluster on the rolling update struct instead of passing it around everywhere [@olemarkus](https://github.com/olemarkus) [#9974](https://github.com/kubernetes/kops/pull/9974)
* Fix pair of typos in openstack docs [@erismaster](https://github.com/erismaster) [#9997](https://github.com/kubernetes/kops/pull/9997)
* Add label to prevent kops-controller from running on old nodes [@johngmyers](https://github.com/johngmyers) [#9998](https://github.com/kubernetes/kops/pull/9998)
* Update prometheus-operator to support k8sv >= 1.16.0 [@flouthoc](https://github.com/flouthoc) [#10001](https://github.com/kubernetes/kops/pull/10001)
* Bump NTH to 1.8 [@olemarkus](https://github.com/olemarkus) [#10002](https://github.com/kubernetes/kops/pull/10002)
* Cilium hubble pointer [@olemarkus](https://github.com/olemarkus) [#9967](https://github.com/kubernetes/kops/pull/9967)
* Add missing closing inline code character [@mbacchi](https://github.com/mbacchi) [#10005](https://github.com/kubernetes/kops/pull/10005)
* Update rules_docker in order to build protokube [@DerrickMartinez](https://github.com/DerrickMartinez) [#10007](https://github.com/kubernetes/kops/pull/10007)
* Bump cilium to 1.8.4 [@olemarkus](https://github.com/olemarkus) [#10008](https://github.com/kubernetes/kops/pull/10008)
* Fix support for multiple additionalNetworkCIDR blocks [@rifelpet](https://github.com/rifelpet) [#9996](https://github.com/kubernetes/kops/pull/9996)
* More removals of BuildCloud [@olemarkus](https://github.com/olemarkus) [#9981](https://github.com/kubernetes/kops/pull/9981)
* OpenStack floatingip fixes for clean cluster [@zetaab](https://github.com/zetaab) [#10010](https://github.com/kubernetes/kops/pull/10010)
* Support rolling upgrade on openstack [@olemarkus](https://github.com/olemarkus) [#9927](https://github.com/kubernetes/kops/pull/9927)
* Spotinst: Upgrade the Spot Cluster Controller to version 1.0.67 [@liranp](https://github.com/liranp) [#10011](https://github.com/kubernetes/kops/pull/10011)
* Don't disassociate additional CIDR blocks with shared VPCs [@rifelpet](https://github.com/rifelpet) [#10013](https://github.com/kubernetes/kops/pull/10013)
* enable kubelet --housekeeping-interval flag [@nareshku](https://github.com/nareshku) [#10016](https://github.com/kubernetes/kops/pull/10016)
* Move kops-controller serving port out of conflict [@olemarkus](https://github.com/olemarkus) [#10024](https://github.com/kubernetes/kops/pull/10024)
* Sort wellknown ports and add missing ports to table [@olemarkus](https://github.com/olemarkus) [#10025](https://github.com/kubernetes/kops/pull/10025)
* [calico] awsSrcDstCheck to disable src/dest checks in AWS [@monicagangwar](https://github.com/monicagangwar) [#10019](https://github.com/kubernetes/kops/pull/10019)
* Minor fixes to swiftfs.go [@olemarkus](https://github.com/olemarkus) [#10030](https://github.com/kubernetes/kops/pull/10030)
* Open etcd port only when Calico uses "etcd" datastore [@hakman](https://github.com/hakman) [#10032](https://github.com/kubernetes/kops/pull/10032)
* Kubelet serving certificate and metrics server addon [@olemarkus](https://github.com/olemarkus) [#10022](https://github.com/kubernetes/kops/pull/10022)
* Update Calico to v3.16.3 [@hakman](https://github.com/hakman) [#10036](https://github.com/kubernetes/kops/pull/10036)
* Update Docker version defaults for older k8s versions [@hakman](https://github.com/hakman) [#10033](https://github.com/kubernetes/kops/pull/10033)
* Add support for KubeAPIServer --request-timeout flag [@dntosas](https://github.com/dntosas) [#10038](https://github.com/kubernetes/kops/pull/10038)
* Add WireGuard support for Calico CNI  [@h3poteto](https://github.com/h3poteto) [#10037](https://github.com/kubernetes/kops/pull/10037)
* Fix docs feature table not being rendered [@hakman](https://github.com/hakman) [#10042](https://github.com/kubernetes/kops/pull/10042)
* Fix nil pointer when deleting instance [@olemarkus](https://github.com/olemarkus) [#10046](https://github.com/kubernetes/kops/pull/10046)
* Don't require PriorityClassName to pass missing-static-pod checks [@johngmyers](https://github.com/johngmyers) [#10049](https://github.com/kubernetes/kops/pull/10049)
* Upgrade aws-iam-authenticator to 0.5.2 [@rifelpet](https://github.com/rifelpet) [#10047](https://github.com/kubernetes/kops/pull/10047)
* Recommend kops 1.18.1 for kops >= 1.15 in alpha channel [@johngmyers](https://github.com/johngmyers) [#10051](https://github.com/kubernetes/kops/pull/10051)
* upgrade-cluster: test that new image in stable or alpha channel will … [@nvanheuverzwijn](https://github.com/nvanheuverzwijn) [#10052](https://github.com/kubernetes/kops/pull/10052)
* Release 1.19.0-alpha.5 [@hakman](https://github.com/hakman) [#10054](https://github.com/kubernetes/kops/pull/10054)
