## Release notes for kops 1.18 series

# Significant changes

* **The default image has been updated to Ubuntu 20.04 (Focal)**. Consequently, the SSH user changed to `ubuntu` and the Linux kernel changed to version 5.4.

* To address the [issue](https://github.com/kubernetes/kubernetes/issues/91507) of IPv4 only clusters being susceptible to MitM attacks via IPv6 rogue router advertisements, the affected components have been upgraded as follows:
    * Docker version 19.03.11 - [CVE-2020-13401](https://github.com/docker/docker-ce/releases/v19.03.11)
    * CNI plugins 0.8.6 - [CVE-2020-10749](https://github.com/containernetworking/plugins/releases/tag/v0.8.6)
    * Calico 3.15.1 - [CVE-2020-13597](https://www.projectcalico.org/security-bulletins/)
    * Weave Net 2.6.5 - [CVE-2020-11091](https://github.com/weaveworks/weave/security/advisories/GHSA-59qg-grp7-5r73)

* Support for [RHEL 8](../operations/images.md#rhel-8) and [CentOS 8](../operations/images.md#centos-8) has been added.

* Support for Amazon Linux 2 has been improved and will work with the default Docker version.

* [containerd](https://github.com/containerd/containerd/blob/master/README.md) has been added and can be selected as an alternate container runtime for Kubernetes. Enable by using the `--container-runtime containerd` flag when creating a cluster or by setting `spec.containerRuntime: containerd`.

* Rolling updates now support surging and parallelism within an instance group. For details see [the documentation](../operations/rolling-update.md).

* Cilium CNI can now use AWS networking natively through the AWS ENI IPAM mode. Kops can also run a Kubernetes cluster entirely without kube-proxy using Cilium's BPF NodePort implementation.

* Cilium CNI can now use a dedicated etcd cluster managed by etcd-manager for synchronizing agent state instead of CRDs.

* The Terraform target now supports Terraform 0.12 syntax (HCL2) by default. See the Required Actions item below.

* New clusters in GCE are configured to run the [metadata-proxy](https://github.com/kubernetes/kubernetes/tree/master/cluster/addons/metadata-proxy) by default. The proxy runs as a DaemonSet and lands on nodes with the nodeLabel `cloud.google.com/metadata-proxy-ready: "true"`. If you want to enable metadata-proxy on an existing cluster/instance group, add that nodeLabel to your instancegroup specs (`kops edit ig ...`) and run `kops update cluster`. When the changes are applied, the proxy will roll out to those targeted nodes.

* GCE has a new flag: `--gce-service-account`. This takes the email of an existing GCP service account and launches the instances with it. This setting applies to the whole cluster (ie: it is not currently designed to support Instance Groups with different service accounts). If you do not specify a service account during cluster creation, the default compute service account will be used which matches the prior behavior.

* Google API client libraries updated from v0.beta to v1.

* Support for [NodeLocalDNS cache](https://kops.sigs.k8s.io/cluster_spec/#node-local-dns-cache).

# Breaking changes

* Support for Docker versions 1.11, 1.12 and 1.13 has been removed because of the [dockerproject.org shut down](https://www.docker.com/blog/changes-dockerproject-org-apt-yum-repositories/). Those affected must upgrade to a newer Docker version.

* Terraform users on AWS may need to rename some resources in their state file in order to prepare for Terraform 0.12 support. See Required Actions below.

* Support for the CoreOS OS distribution has been removed. Users should consider Flatcar as a replacement.

* Support for the Debian 8 (Jessie) OS distribution has been removed.

* The Docker `health-check` service has been disabled by default. It shouldn't be needed anymore, but it can still be enabled by setting `spec.docker.healthCheck: true`. It is recommended to also check [node-problem-detector](https://github.com/kubernetes/node-problem-detector) and [draino](https://github.com/planetlabs/draino) as replacements. See Required Actions below.

* Network and internet access for `docker run` containers has been disabled by default, to avoid any unwanted interaction between the Docker firewall rules and the firewall rules of netwok plugins. This was the default since the early days of Kops, but a race condition in the Docker startup sequence changed this behaviour in more recent years. To re-enable, set `spec.docker.ipTables: true` and `spec.docker.ipMasq: true`.

* Lyft CNI plugin default subnet tags changed from from `Type: pod` to `KubernetesCluster: myclustername.mydns.io`. Subnets intended for use by the plugin will need to be tagged with this new tag and [additional tag filters](https://github.com/lyft/cni-ipvlan-vpc-k8s#other-configuration-flags) may need to be added to the cluster spec in order to achieve the desired set of subnets.

* Support for basic authentication has been disabled by default for Kubernetes 1.18 and will be [removed](https://github.com/kubernetes/kubernetes/pull/89069) in Kubernetes 1.19.

* Support for static tokens has been disabled by default for Kubernetes 1.18 and later. To re-enable, see the [Security Notes for Kubernetes](../security.md). We intend to remove support entirely in a future kops version, so file an issue with your use case if you need this feature. 

* Support for Kubernetes versions prior to 1.9 has been removed.

* Kubernetes 1.9 users will need to enable the PodPriority feature gate. See Required Actions below.

* Support for the "Legacy" etcd provider has been removed for Kubernetes versions 1.18 and higher. Such clusters will need to migrate to the default "Manager" etcd provider. To migrate, see the [etcd migration documentation](../etcd3-migration.md).

* A controller is now used to apply labels to nodes.  If you are not using AWS, GCE or OpenStack your (non-master) nodes may not have labels applied correctly.

* The `kops.k8s.io/v1alpha1` API has been removed. Users of `kops replace` will need to supply v1alpha2 resources.

* Please see the notes in the 1.15 release about the apiGroup changing from kops to kops.k8s.io

# Required Actions

* Terraform users on AWS may need to rename resources in their terraform state file in order to support Terraform 0.12.
  Terraform 0.12 [no longer supports resource names starting with digits](https://www.terraform.io/upgrade-guides/0-12.html#pre-upgrade-checklist). In Kops, both the default route and additional VPC CIDR associations are affected. See [#7957](https://github.com/kubernetes/kops/pull/7957) for more information.
  * The default route was named `aws_route.0-0-0-0--0` and will now be named `aws_route.route-0-0-0-0--0`.
  * Additional CIDR blocks associated with a VPC were similarly named the hyphenated CIDR block with two hyphens for the `/`, for example `aws_vpc_ipv4_cidr_block_association.10-1-0-0--16`. These will now be prefixed with `cidr-`, for example `aws_vpc_ipv4_cidr_block_association.cidr-10-1-0-0--16`.

  To prevent downtime, follow these steps with the new version of Kops:
  ```
  KOPS_FEATURE_FLAGS=-Terraform-0.12 kops update cluster --target terraform ...
  # Use Terraform <0.12
  terraform plan
  # Observe any aws_route or aws_vpc_ipv4_cidr_block_association resources being destroyed and recreated
  # Run these commands as necessary. The exact names may differ; use what is outputted by terraform plan
  terraform state mv aws_route.0-0-0-0--0 aws_route.route-0-0-0-0--0
  terraform state mv aws_vpc_ipv4_cidr_block_association.10-1-0-0--16 aws_vpc_ipv4_cidr_block_association.cidr-10-1-0-0--16
  terraform plan
  # Ensure these resources are no longer being destroyed and recreated
  terraform apply
  ```
  Kops will now output Terraform 0.12 syntax with the normal workflow:
  ```
  kops update cluster --target terraform ...
  # Use Terraform 0.12. This plan should be a no-op
  terraform plan
  ```

* Users that need the Docker `health-check` service will need to explicitly enable it:
```
  kops edit cluster
  # Add the following section
  spec:
    docker:
      healthCheck: true
  ```

* Kubernetes 1.9 users will need to enable the PodPriority feature gate. This is required for newer versions of Kops.

  To enable the Pod priority feature, follow these steps:
  ```
  kops edit cluster
  # Add the following section
  spec:
    kubelet:
      featureGates:
        PodPriority: "true"
  ```

* If a custom Kops build was used on a cluster, a kops-controller Deployment may have been created that should get deleted.
  Run `kubectl -n kube-system delete deployment kops-controller` after upgrading to Kops 1.16.0-beta.1 or later.

# Known Issues

* AWS clusters with an ACM certificate attached to the API ELB (the cluster's `spec.api.loadBalancer.sslCertificate` is set) will need to reenable basic auth to use the kubeconfig context created by `kops export kubecfg`. Set `spec.kubeAPIServer.disableBasicAuth: false` before running `kops export kubecfg`. See [#9756](https://github.com/kubernetes/kops/issues/9756) for more information.

# Deprecations

* Support for Kubernetes versions 1.9 and 1.10 are deprecated and will be removed in kops 1.19.

* Support for Ubuntu 16.04 (Xenial) has been deprecated and will be removed in future versions of Kops.

* Support for the Romana networking provider is deprecated and will be removed in kops 1.19.

* Support for legacy IAM permissions is deprecated and will be removed in kops 1.19.

# Full change list since 1.17.0 release

## 1.17.0-alpha.1 to 1.18.0-alpha.1

* Release notes for 1.17.0-alpha.1 [@justinsb](https://github.com/justinsb) [#8006](https://github.com/kubernetes/kops/pull/8006)
* Implementing audit dynamic configuration (#7392) [@mmerrill3](https://github.com/mmerrill3) [#7424](https://github.com/kubernetes/kops/pull/7424)
* Set bazel version [@mikesplain](https://github.com/mikesplain) [#7996](https://github.com/kubernetes/kops/pull/7996)
* Add verify-gomod and verify-goimports to Travis job [@rifelpet](https://github.com/rifelpet) [#7952](https://github.com/kubernetes/kops/pull/7952)
* Alicloud: fix typo for listenerPort [@bittopaz](https://github.com/bittopaz) [#8011](https://github.com/kubernetes/kops/pull/8011)
* Alicloud: only private subnets need SNAT rule [@bittopaz](https://github.com/bittopaz) [#8015](https://github.com/kubernetes/kops/pull/8015)
* Alicloud: use ID of EIP to compare [@bittopaz](https://github.com/bittopaz) [#8012](https://github.com/kubernetes/kops/pull/8012)
* Improve rolling update test coverage [@johngmyers](https://github.com/johngmyers) [#7904](https://github.com/kubernetes/kops/pull/7904)
* Add download link for etcd-manager-ctl, clarify restarting etcd [@dzoeteman](https://github.com/dzoeteman) [#7506](https://github.com/kubernetes/kops/pull/7506)
* Run goimports in make ci [@tioxy](https://github.com/tioxy) [#8023](https://github.com/kubernetes/kops/pull/8023)
* Alicloud: fix comparison failure for scalinggroup [@bittopaz](https://github.com/bittopaz) [#8029](https://github.com/kubernetes/kops/pull/8029)
* Alicloud: support internal api loadbalancer [@bittopaz](https://github.com/bittopaz) [#8014](https://github.com/kubernetes/kops/pull/8014)
* Alicloud: fix comparison failures for SecurityGroupRule and SSHKey [@bittopaz](https://github.com/bittopaz) [#8028](https://github.com/kubernetes/kops/pull/8028)
* Alicloud: add Encrypted field in Disk Find func [@bittopaz](https://github.com/bittopaz) [#8026](https://github.com/kubernetes/kops/pull/8026)
* Add joshbranham to OWNERs as reviewer [@joshbranham](https://github.com/joshbranham) [#8010](https://github.com/kubernetes/kops/pull/8010)
* Add CapacityOptimized to list of supported spot allocation strategies [@gjtempleton](https://github.com/gjtempleton) [#7406](https://github.com/kubernetes/kops/pull/7406)
* Alicloud: fix comparison failures for VPC and NATGateway [@bittopaz](https://github.com/bittopaz) [#8027](https://github.com/kubernetes/kops/pull/8027)
* Alicloud: use Balance as MultiAZPolicy [@bittopaz](https://github.com/bittopaz) [#8030](https://github.com/kubernetes/kops/pull/8030)
* Allow users to set kube controller manager's concurrent sync flags. [@uruddarraju](https://github.com/uruddarraju) [#7600](https://github.com/kubernetes/kops/pull/7600)
* Pass the cloud object to validator from caller [@johngmyers](https://github.com/johngmyers) [#7925](https://github.com/kubernetes/kops/pull/7925)
* Rename to kops [@justinsb](https://github.com/justinsb) [#1](https://github.com/kubernetes/kops/pull/1)
* Alicloud: allow use RAM role for OSS client [@bittopaz](https://github.com/bittopaz) [#8025](https://github.com/kubernetes/kops/pull/8025)
* Fix Handling of LaunchTemplate Versions for MixedInstancePolicy [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#8038](https://github.com/kubernetes/kops/pull/8038)
* Additional leader election options [@DerekHeldtWerle](https://github.com/DerekHeldtWerle) [#8036](https://github.com/kubernetes/kops/pull/8036)
* Fix truncation of admission control plugins list [@johngmyers](https://github.com/johngmyers) [#8033](https://github.com/kubernetes/kops/pull/8033)
* Add more verifications to Travis [@johngmyers](https://github.com/johngmyers) [#8024](https://github.com/kubernetes/kops/pull/8024)
* Alicloud: fix comparison failures for LaunchConfiguration and LoadBalancerWhiteList [@bittopaz](https://github.com/bittopaz) [#8042](https://github.com/kubernetes/kops/pull/8042)
* [Issue-7956] - [Digital Ocean] Minor fix to have proper indexing for digital ocean regions [@srikiz](https://github.com/srikiz) [#8002](https://github.com/kubernetes/kops/pull/8002)
* EBS Root Volume Termination [@tioxy](https://github.com/tioxy) [#7865](https://github.com/kubernetes/kops/pull/7865)
* Canal v3.10 manifest for k8s v1.15+ [@KashifSaadat](https://github.com/KashifSaadat) [#7917](https://github.com/kubernetes/kops/pull/7917)
* Fix misleading message in "make ci" when imports formatted incorrectly [@johngmyers](https://github.com/johngmyers) [#8045](https://github.com/kubernetes/kops/pull/8045)
* Increase validation test coverage [@johngmyers](https://github.com/johngmyers) [#8039](https://github.com/kubernetes/kops/pull/8039)
* Update integration test to cover CloudFormation output of NAT gateways [@rifelpet](https://github.com/rifelpet) [#8053](https://github.com/kubernetes/kops/pull/8053)
* Fix CloudFormation template tags for NatGateway [@hakman](https://github.com/hakman) [#8051](https://github.com/kubernetes/kops/pull/8051)
* Alicloud: fix comparison failures for VSwitch and VSwitchSNAT [@bittopaz](https://github.com/bittopaz) [#8044](https://github.com/kubernetes/kops/pull/8044)
* Alicloud: fix comparison failures for RAMRole and RAMPolicy [@bittopaz](https://github.com/bittopaz) [#8043](https://github.com/kubernetes/kops/pull/8043)
* Bump cilium version to 1.6.4 [@olemarkus](https://github.com/olemarkus) [#8022](https://github.com/kubernetes/kops/pull/8022)
* Add verify-generate to Travis and 'make ci' [@johngmyers](https://github.com/johngmyers) [#8054](https://github.com/kubernetes/kops/pull/8054)
* Fix mounting Calico "flexvol-driver-host" in CoreOS [@hakman](https://github.com/hakman) [#8062](https://github.com/kubernetes/kops/pull/8062)
* Complete support for Flatcar [@mazzy89](https://github.com/mazzy89) [#7545](https://github.com/kubernetes/kops/pull/7545)
* Cloud controller template function [@DavidSie](https://github.com/DavidSie) [#7992](https://github.com/kubernetes/kops/pull/7992)
* put kubernetes 1.17.0 to channels [@zetaab](https://github.com/zetaab) [#8072](https://github.com/kubernetes/kops/pull/8072)
* remove unused functions and simplify return str [@tanjunchen](https://github.com/tanjunchen) [#7792](https://github.com/kubernetes/kops/pull/7792)
* Validate cluster after updating bastions [@johngmyers](https://github.com/johngmyers) [#8074](https://github.com/kubernetes/kops/pull/8074)
* Add support for NFT with Calico and Canal [@hakman](https://github.com/hakman) [#8076](https://github.com/kubernetes/kops/pull/8076)
* Docs: Fix some broken development links [@gjtempleton](https://github.com/gjtempleton) [#8075](https://github.com/kubernetes/kops/pull/8075)
* Docs: More List fixes [@gjtempleton](https://github.com/gjtempleton) [#8092](https://github.com/kubernetes/kops/pull/8092)
* Update documentation of go version requirement [@johngmyers](https://github.com/johngmyers) [#8094](https://github.com/kubernetes/kops/pull/8094)
* add missing rbac rules [@zetaab](https://github.com/zetaab) [#8095](https://github.com/kubernetes/kops/pull/8095)
* test validateCluster twice to make sure it does not flap [@zetaab](https://github.com/zetaab) [#8088](https://github.com/kubernetes/kops/pull/8088)
* update metrics server image [@nothinux](https://github.com/nothinux) [#8046](https://github.com/kubernetes/kops/pull/8046)
* docs(advanced): fix broken links on doc [@pshanoop](https://github.com/pshanoop) [#8102](https://github.com/kubernetes/kops/pull/8102)
* Add test for flapping cluster validation and improve its logging [@johngmyers](https://github.com/johngmyers) [#8105](https://github.com/kubernetes/kops/pull/8105)
* some resources upgraded to google provider 3.0 [@mccare](https://github.com/mccare) [#8103](https://github.com/kubernetes/kops/pull/8103)
* fix-pkg-staticcheck and remove the repeat code [@tanjunchen](https://github.com/tanjunchen) [#8035](https://github.com/kubernetes/kops/pull/8035)
* dev: hack/update-expected.sh should generate missing file [@justinsb](https://github.com/justinsb) [#8111](https://github.com/kubernetes/kops/pull/8111)
* dev: ignore kops-controller in hack/update-expected.sh [@justinsb](https://github.com/justinsb) [#8107](https://github.com/kubernetes/kops/pull/8107)
* Terraform GCE output: setting google provider to at least 3.0.0 [@mccare](https://github.com/mccare) [#8108](https://github.com/kubernetes/kops/pull/8108)
* Add test for protokube builder [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#8112](https://github.com/kubernetes/kops/pull/8112)
* channels: bump k8s versions after dec. patch releases [@idealhack](https://github.com/idealhack) [#8123](https://github.com/kubernetes/kops/pull/8123)
* Fix doc(advanced) broken links [@pshanoop](https://github.com/pshanoop) [#8125](https://github.com/kubernetes/kops/pull/8125)
* a little change [@zehuaiWANG](https://github.com/zehuaiWANG) [#8127](https://github.com/kubernetes/kops/pull/8127)
* fix 404 urls [@yuxiaobo96](https://github.com/yuxiaobo96) [#8052](https://github.com/kubernetes/kops/pull/8052)
* pkg/model pkg/diff pkg/client/:simplify code and remove unused code [@tanjunchen](https://github.com/tanjunchen) [#8120](https://github.com/kubernetes/kops/pull/8120)
* Cleans up the create cluster CLI prompts [@geojaz](https://github.com/geojaz) [#8122](https://github.com/kubernetes/kops/pull/8122)
* Add kubeconfig flag to validate cluster command [@vvbogdanov87](https://github.com/vvbogdanov87) [#8110](https://github.com/kubernetes/kops/pull/8110)
* Add inf1 isntances [@mikesplain](https://github.com/mikesplain) [#8128](https://github.com/kubernetes/kops/pull/8128)
* util/pkg/ upup/tools/ :  simplify code and remove unused  code [@tanjunchen](https://github.com/tanjunchen) [#8121](https://github.com/kubernetes/kops/pull/8121)
* Bump COS version in alpha channel for k8s >= 1.16 [@justinsb](https://github.com/justinsb) [#8116](https://github.com/kubernetes/kops/pull/8116)
* Openstack: Fix cluster floating ips [@mitch000001](https://github.com/mitch000001) [#8115](https://github.com/kubernetes/kops/pull/8115)
* Update Calico to v3.10.2 [@hakman](https://github.com/hakman) [#8104](https://github.com/kubernetes/kops/pull/8104)
* tests: increase timeout in rolling update tests [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#8139](https://github.com/kubernetes/kops/pull/8139)
* Automatically install dependencies with local packages [@hakman](https://github.com/hakman) [#8020](https://github.com/kubernetes/kops/pull/8020)
* Add support for Containerd container runtime [@hakman](https://github.com/hakman),[@justinsb](https://github.com/justinsb) [#7986](https://github.com/kubernetes/kops/pull/7986)
* Fix periodic e2e test for Ubuntu 16.04 [@hakman](https://github.com/hakman) [#8160](https://github.com/kubernetes/kops/pull/8160)
* Latest bazel launcher seems to require a newline at end of .bazelversion [@justinsb](https://github.com/justinsb) [#8161](https://github.com/kubernetes/kops/pull/8161)
* Spotinst: Upgrade the Spotinst controller to version 1.0.50 [@liranp](https://github.com/liranp) [#8080](https://github.com/kubernetes/kops/pull/8080)
* kops-change-main [@zehuaiWANG](https://github.com/zehuaiWANG) [#8132](https://github.com/kubernetes/kops/pull/8132)
* nodeup/pkg/model - fix static check [@hakman](https://github.com/hakman) [#8155](https://github.com/kubernetes/kops/pull/8155)
* upup/pkg/fi/ upup/pkg/kutil : simplify code and remove code [@tanjunchen](https://github.com/tanjunchen) [#8118](https://github.com/kubernetes/kops/pull/8118)
* Update kubernetes versions used in integration tests [@rifelpet](https://github.com/rifelpet) [#8173](https://github.com/kubernetes/kops/pull/8173)
* Run dns-controller and kops-controller as non-root user [@johngmyers](https://github.com/johngmyers) [#8169](https://github.com/kubernetes/kops/pull/8169)
* Fix verify-staticcheck prow job [@rifelpet](https://github.com/rifelpet) [#8182](https://github.com/kubernetes/kops/pull/8182)
* protokube/pkg - fix static check [@hakman](https://github.com/hakman) [#8165](https://github.com/kubernetes/kops/pull/8165)
* Refactor: Add Region() method to fi.Cloud [@justinsb](https://github.com/justinsb) [#8180](https://github.com/kubernetes/kops/pull/8180)
* Remove make command from verify-staticcheck.sh [@rifelpet](https://github.com/rifelpet) [#8189](https://github.com/kubernetes/kops/pull/8189)
* GCE: Fix Permission for the Storage Bucket [@mccare](https://github.com/mccare) [#8157](https://github.com/kubernetes/kops/pull/8157)
* pkg/instancegroups - fix static check [@johngmyers](https://github.com/johngmyers) [#8186](https://github.com/kubernetes/kops/pull/8186)
* pkg/resources/aws:simplify code and remove code [@Aresforchina](https://github.com/Aresforchina) [#8188](https://github.com/kubernetes/kops/pull/8188)
* Update links printed by Kops to use new docs site [@rifelpet](https://github.com/rifelpet) [#8190](https://github.com/kubernetes/kops/pull/8190)
* dnsprovider/pkg/dnsprovider - fix static check [@hakman](https://github.com/hakman) [#8149](https://github.com/kubernetes/kops/pull/8149)
* fix staticcheck failures in pkg/resources [@Aresforchina](https://github.com/Aresforchina) [#8191](https://github.com/kubernetes/kops/pull/8191)
* Add corresponding unit test to the function in subnet.go. [@fenggw-fnst](https://github.com/fenggw-fnst) [#8195](https://github.com/kubernetes/kops/pull/8195)
* Update gcr.io images [@justinsb](https://github.com/justinsb) [#8197](https://github.com/kubernetes/kops/pull/8197)
* pkg/resources-fix staticcheck  [@k8s-ci-robot](https://github.com/k8s-ci-robot),[@Aresforchina](https://github.com/Aresforchina) [#8192](https://github.com/kubernetes/kops/pull/8192)
* Update Weave Net to version 2.6.0 [@bboreham](https://github.com/bboreham) [#7898](https://github.com/kubernetes/kops/pull/7898)
* Guard External cloud controller manager with its feature flag [@mitch000001](https://github.com/mitch000001) [#7770](https://github.com/kubernetes/kops/pull/7770)
* Always consider spot instance node readiness in cluster validation [@johngmyers](https://github.com/johngmyers) [#8159](https://github.com/kubernetes/kops/pull/8159)
* Update support for RHEL 8 [@hakman](https://github.com/hakman) [#8164](https://github.com/kubernetes/kops/pull/8164)
* Fix upup/tools/generators/pkg/codegen staticcheck failures [@johngmyers](https://github.com/johngmyers) [#8203](https://github.com/kubernetes/kops/pull/8203)
* containerd: Use containerd 1.2.4 with Docker 18.09.3 [@hakman](https://github.com/hakman) [#8170](https://github.com/kubernetes/kops/pull/8170)
* util/pkg/vfs/:staticcheck [@tanjunchen](https://github.com/tanjunchen) [#8171](https://github.com/kubernetes/kops/pull/8171)
* containerd: Add --container-runtime cli flag [@hakman](https://github.com/hakman) [#8172](https://github.com/kubernetes/kops/pull/8172)
* Add deprecation warning for older k8s versions [@rifelpet](https://github.com/rifelpet) [#8176](https://github.com/kubernetes/kops/pull/8176)
* Add all flag to export cluster command [@vvbogdanov87](https://github.com/vvbogdanov87) [#8179](https://github.com/kubernetes/kops/pull/8179)
* Alicloud: refine Alicloud RAM role policy [@bittopaz](https://github.com/bittopaz) [#8194](https://github.com/kubernetes/kops/pull/8194)
* Fix cmd/kops staticcheck failures [@johngmyers](https://github.com/johngmyers) [#8202](https://github.com/kubernetes/kops/pull/8202)
* /hack: improve shell script  in hack [@tanjunchen](https://github.com/tanjunchen) [#8143](https://github.com/kubernetes/kops/pull/8143)
* dns-controller: allow it to run on CNI networking mode and remove dependency on kube-proxy [@rochacon](https://github.com/rochacon) [#8131](https://github.com/kubernetes/kops/pull/8131)
* replace TrimRight with TrimSuffix [@tanjunchen](https://github.com/tanjunchen) [#8041](https://github.com/kubernetes/kops/pull/8041)
* Fix typo in export kubeconfig [@vvbogdanov87](https://github.com/vvbogdanov87) [#8211](https://github.com/kubernetes/kops/pull/8211)
* Fix typo in KubeProxy model [@rifelpet](https://github.com/rifelpet) [#8210](https://github.com/kubernetes/kops/pull/8210)
* Fix link printed in k8s version deprecation message [@rifelpet](https://github.com/rifelpet) [#8209](https://github.com/kubernetes/kops/pull/8209)
* cilium: don't try to mount sys/fs/bpf if already mounted [@justinsb](https://github.com/justinsb) [#7832](https://github.com/kubernetes/kops/pull/7832)
* Set shared field for volume resource on delete [@vvbogdanov87](https://github.com/vvbogdanov87) [#8079](https://github.com/kubernetes/kops/pull/8079)
* clean up buildDiffLines [@zehuaiWANG](https://github.com/zehuaiWANG) [#8144](https://github.com/kubernetes/kops/pull/8144)
* Fix cloudmock/aws/mockelbv2 staticcheck failures [@johngmyers](https://github.com/johngmyers) [#8218](https://github.com/kubernetes/kops/pull/8218)
* Fix node-authorizer/pkg/authorizers/aws staticcheck failure [@johngmyers](https://github.com/johngmyers) [#8222](https://github.com/kubernetes/kops/pull/8222)
* Fix pkg/resources/openstack staticcheck failure [@johngmyers](https://github.com/johngmyers) [#8223](https://github.com/kubernetes/kops/pull/8223)
* Add code simplifications for staticheck [@hakman](https://github.com/hakman) [#8232](https://github.com/kubernetes/kops/pull/8232)
* util/pkg/slice: Add slice test [@q384566678](https://github.com/q384566678) [#8219](https://github.com/kubernetes/kops/pull/8219)
* pkg/apis/ pkg/commands/ pkg/model/ staticcheck [@tanjunchen](https://github.com/tanjunchen) [#8229](https://github.com/kubernetes/kops/pull/8229)
* dnsprovider staticcheck [@tanjunchen](https://github.com/tanjunchen) [#8233](https://github.com/kubernetes/kops/pull/8233)
* upup/pkg/fi/cloudup/apply_cluster staticcheck [@tanjunchen](https://github.com/tanjunchen) [#8231](https://github.com/kubernetes/kops/pull/8231)
* staticcheck:remove duplicate import packages [@yuxiaobo96](https://github.com/yuxiaobo96) [#8225](https://github.com/kubernetes/kops/pull/8225)
* cmd/kops/ staticcheck and remove one mom  [@tanjunchen](https://github.com/tanjunchen) [#8230](https://github.com/kubernetes/kops/pull/8230)
* nodeup/pkg/ pkg/ staticcheck: Fix ST1005 [@tanjunchen](https://github.com/tanjunchen) [#8234](https://github.com/kubernetes/kops/pull/8234)
* upup/pkg/fi/cloudup/ staticcheck: Fix ST1005 [@tanjunchen](https://github.com/tanjunchen) [#8236](https://github.com/kubernetes/kops/pull/8236)
* Update copyrights for 2020 [@johngmyers](https://github.com/johngmyers) [#8241](https://github.com/kubernetes/kops/pull/8241)
* Run Travis verifications in a separate parallel job [@johngmyers](https://github.com/johngmyers) [#8254](https://github.com/kubernetes/kops/pull/8254)
* Adding ability to configure resources for weave (#8113) [@mmerrill3](https://github.com/mmerrill3) [#8216](https://github.com/kubernetes/kops/pull/8216)
* containerd: Fix tiny nits [@hakman](https://github.com/hakman) [#8217](https://github.com/kubernetes/kops/pull/8217)
* Custom sysctl Parameters [@ripta](https://github.com/ripta) [#7730](https://github.com/kubernetes/kops/pull/7730)
* Update mock kops version in integration tests [@rifelpet](https://github.com/rifelpet) [#8258](https://github.com/kubernetes/kops/pull/8258)
* Fix protokube osx build [@mikesplain](https://github.com/mikesplain) [#8263](https://github.com/kubernetes/kops/pull/8263)
* Fix aws-china.md to download SHA-256 checksums for kops assets [@johngmyers](https://github.com/johngmyers) [#8243](https://github.com/kubernetes/kops/pull/8243)
* Fix broken link [@johngmyers](https://github.com/johngmyers) [#8266](https://github.com/kubernetes/kops/pull/8266)
* Exclude one Travis osx job [@johngmyers](https://github.com/johngmyers) [#8262](https://github.com/kubernetes/kops/pull/8262)
* Support tainting all nodes needing update during rolling update [@johngmyers](https://github.com/johngmyers) [#8021](https://github.com/kubernetes/kops/pull/8021)
* Fix RollingUpdate behaviour when using LaunchTemplates for both kops & terraform spec updates [@KashifSaadat](https://github.com/KashifSaadat) [#8261](https://github.com/kubernetes/kops/pull/8261)
* Refactor rolling update tests [@johngmyers](https://github.com/johngmyers) [#8268](https://github.com/kubernetes/kops/pull/8268)
* Simplify code for rolling updates of nodes [@johngmyers](https://github.com/johngmyers) [#8239](https://github.com/kubernetes/kops/pull/8239)
* Move nodeup to /opt/kops/bin [@hakman](https://github.com/hakman) [#8212](https://github.com/kubernetes/kops/pull/8212)
* For dev, don't preload docker images on nodes [@justinsb](https://github.com/justinsb) [#8196](https://github.com/kubernetes/kops/pull/8196)
* fixed yum proxy configuration [@zadowsmash](https://github.com/zadowsmash) [#7772](https://github.com/kubernetes/kops/pull/7772)
* Use non-experimental version of encryption provider config flag in 1.13+ [@zacblazic](https://github.com/zacblazic) [#7900](https://github.com/kubernetes/kops/pull/7900)
* Remove DrainAndValidateRollingUpdate feature flag [@johngmyers](https://github.com/johngmyers) [#7909](https://github.com/kubernetes/kops/pull/7909)
* staticcheck:modify the import package alias [@yuxiaobo96](https://github.com/yuxiaobo96) [#8253](https://github.com/kubernetes/kops/pull/8253)
* Remove forcing disabled cgos Darwin [@joshbranham](https://github.com/joshbranham) [#7914](https://github.com/kubernetes/kops/pull/7914)
* Make /opt/kops writeable on COS [@justinsb](https://github.com/justinsb) [#8269](https://github.com/kubernetes/kops/pull/8269)
* Remove duplicated words [@longkb](https://github.com/longkb) [#8277](https://github.com/kubernetes/kops/pull/8277)
* nodeup: Add some dependencies for Service [@justinsb](https://github.com/justinsb) [#8270](https://github.com/kubernetes/kops/pull/8270)
* Set CLUSTER_NAME env var on amazon-vpc-cni pods [@rifelpet](https://github.com/rifelpet) [#8274](https://github.com/kubernetes/kops/pull/8274)
* containerd: Set a default version even with Kubernetes 1.17 [@hakman](https://github.com/hakman) [#8283](https://github.com/kubernetes/kops/pull/8283)
* small documentation typo fixes [@stratusjerry](https://github.com/stratusjerry) [#8285](https://github.com/kubernetes/kops/pull/8285)
* Enable host logging for kops-controller [@rifelpet](https://github.com/rifelpet) [#8204](https://github.com/kubernetes/kops/pull/8204)
* Fix unit name for memory request for weave [@hakman](https://github.com/hakman) [#8303](https://github.com/kubernetes/kops/pull/8303)
* Add wget and nfs-utils deps needed for e2e tests [@hakman](https://github.com/hakman) [#8286](https://github.com/kubernetes/kops/pull/8286)
* Some Calico doc updates [@tmjd](https://github.com/tmjd) [#8302](https://github.com/kubernetes/kops/pull/8302)
* Remove "pigz" containerd dependency for RHEL/CentOS 7 [@hakman](https://github.com/hakman) [#8307](https://github.com/kubernetes/kops/pull/8307)
* Replace kubernetes mount code with utils [@justinsb](https://github.com/justinsb) [#8056](https://github.com/kubernetes/kops/pull/8056)
* Stabilize sequence of "export xx=xxx" statements [@bittopaz](https://github.com/bittopaz) [#8247](https://github.com/kubernetes/kops/pull/8247)
* upup/pkg/fi-fix staticcheck [@Aresforchina](https://github.com/Aresforchina) [#8193](https://github.com/kubernetes/kops/pull/8193)
* Build dns-controller using bazel [@justinsb](https://github.com/justinsb) [#8315](https://github.com/kubernetes/kops/pull/8315)
* Don't output empty sections in the manifests [@justinsb](https://github.com/justinsb) [#8317](https://github.com/kubernetes/kops/pull/8317)
* Remove support for Kubernetes 1.8 and earlier [@johngmyers](https://github.com/johngmyers) [#8208](https://github.com/kubernetes/kops/pull/8208)
* Improve CIDR validation [@johngmyers](https://github.com/johngmyers) [#8284](https://github.com/kubernetes/kops/pull/8284)
* Remove kops-controller deployment [@rifelpet](https://github.com/rifelpet) [#8273](https://github.com/kubernetes/kops/pull/8273)
* Remove traces of kops-server [@rifelpet](https://github.com/rifelpet) [#7824](https://github.com/kubernetes/kops/pull/7824)
* Add release notes for deleting the kops-controller deployment [@rifelpet](https://github.com/rifelpet) [#8321](https://github.com/kubernetes/kops/pull/8321)
* Don't share /etc/hosts when using etcd-manager [@justinsb](https://github.com/justinsb) [#8322](https://github.com/kubernetes/kops/pull/8322)
* Use /opt/cni/bin on all distros (including COS) [@justinsb](https://github.com/justinsb) [#7833](https://github.com/kubernetes/kops/pull/7833)
* Add unit test for func RenderInstanceGroupSubnets in instancegroup.go [@fenggw-fnst](https://github.com/fenggw-fnst) [#8245](https://github.com/kubernetes/kops/pull/8245)
* upup/pkg/fi/cloudup/awstasks/ staticcheck [@tanjunchen](https://github.com/tanjunchen) [#8235](https://github.com/kubernetes/kops/pull/8235)
* Allow CoreDNS to be specified by create cluster overrides [@rifelpet](https://github.com/rifelpet) [#8334](https://github.com/kubernetes/kops/pull/8334)
* Allow removed of additionalUserData on bastion [@nvanheuverzwijn](https://github.com/nvanheuverzwijn) [#8331](https://github.com/kubernetes/kops/pull/8331)
* docs(docs/operations) Adding more steps to etcd-manager restore operation to work properly [@phspagiari](https://github.com/phspagiari) [#8337](https://github.com/kubernetes/kops/pull/8337)
* Configuration to specify no SSH key [@austinmoore-](https://github.com/austinmoore-) [#7096](https://github.com/kubernetes/kops/pull/7096)
* Remove code for unsupported Kubernetes versions [@johngmyers](https://github.com/johngmyers) [#8327](https://github.com/kubernetes/kops/pull/8327)
* Securing http link to https link [@truongnh1992](https://github.com/truongnh1992) [#8345](https://github.com/kubernetes/kops/pull/8345)
* fix author nickName [@LinshanYu](https://github.com/LinshanYu) [#8205](https://github.com/kubernetes/kops/pull/8205)
* Fix crossbuild-nodeup-in-docker [@johngmyers](https://github.com/johngmyers) [#8343](https://github.com/kubernetes/kops/pull/8343)
* Update CentOS 7 AMI [@rifelpet](https://github.com/rifelpet) [#8350](https://github.com/kubernetes/kops/pull/8350)
* update gophercloud dependency [@zetaab](https://github.com/zetaab) [#8346](https://github.com/kubernetes/kops/pull/8346)
* Fix DNS loop on Ubuntu 18.04 (Bionic) [@hakman](https://github.com/hakman) [#8353](https://github.com/kubernetes/kops/pull/8353)
* Add support for weave.npcExtraArgs [@ReillyProcentive](https://github.com/ReillyProcentive) [#8265](https://github.com/kubernetes/kops/pull/8265)
* Make /opt/cni/bin writeable on COS [@justinsb](https://github.com/justinsb) [#8354](https://github.com/kubernetes/kops/pull/8354)
* Add shellcheck verification [@rifelpet](https://github.com/rifelpet) [#8328](https://github.com/kubernetes/kops/pull/8328)
* Update Terraform resource names to be 0.12 compatible. [@rifelpet](https://github.com/rifelpet) [#7957](https://github.com/kubernetes/kops/pull/7957)
* Update dependencies to kubernetes 1.16 [@justinsb](https://github.com/justinsb) [#8055](https://github.com/kubernetes/kops/pull/8055)
* Add unit test for pkg/edit/edit.go [@tiendc](https://github.com/tiendc) [#8349](https://github.com/kubernetes/kops/pull/8349)
* Test package versions as well as hashes [@justinsb](https://github.com/justinsb) [#8360](https://github.com/kubernetes/kops/pull/8360)
* Publish update AMIs into the alpha channel [@justinsb](https://github.com/justinsb) [#8361](https://github.com/kubernetes/kops/pull/8361)
* Allow local filesystem state stores (to aid CI pull-request workflows) [@ari-becker](https://github.com/ari-becker) [#6465](https://github.com/kubernetes/kops/pull/6465)
* Add release notes for terraform resource renaming [@rifelpet](https://github.com/rifelpet) [#8364](https://github.com/kubernetes/kops/pull/8364)
* Add a warning when using file:// state store [@rifelpet](https://github.com/rifelpet) [#8368](https://github.com/kubernetes/kops/pull/8368)
* Update default instance types for AWS [@hakman](https://github.com/hakman) [#8282](https://github.com/kubernetes/kops/pull/8282)
* update docs: updating kops [@nothinux](https://github.com/nothinux) [#8358](https://github.com/kubernetes/kops/pull/8358)
* Update lyft CNI to v0.5.3 [@maruina](https://github.com/maruina) [#8367](https://github.com/kubernetes/kops/pull/8367)
* Fix issues with older versions of k8s for basic clusters [@hakman](https://github.com/hakman) [#8248](https://github.com/kubernetes/kops/pull/8248)
* Backport the k8s 1.9 required action release note [@johngmyers](https://github.com/johngmyers) [#8378](https://github.com/kubernetes/kops/pull/8378)
* Change the deleted user to ghost [@LinshanYu](https://github.com/LinshanYu) [#8380](https://github.com/kubernetes/kops/pull/8380)
* Add Cilium.EnablePolicy back into templates [@olemarkus](https://github.com/olemarkus) [#8379](https://github.com/kubernetes/kops/pull/8379)
* Use IAMPrefix() for hostedzone [@lazzarello](https://github.com/lazzarello) [#8366](https://github.com/kubernetes/kops/pull/8366)
* Fix scheduler policy configmap args [@vvbogdanov87](https://github.com/vvbogdanov87) [#8386](https://github.com/kubernetes/kops/pull/8386)
* Bump k8s versions in alpha and stable channels [@olemarkus](https://github.com/olemarkus) [#8392](https://github.com/kubernetes/kops/pull/8392)
* Enabling JSON output for Terraform instead of writing the HCL syntax … [@mccare](https://github.com/mccare) [#8145](https://github.com/kubernetes/kops/pull/8145)
* containerd: Add support for tar.gz package [@hakman](https://github.com/hakman) [#8199](https://github.com/kubernetes/kops/pull/8199)
* CoreDNS default image bump to 1.6.6 to resolve CVE [@gjtempleton](https://github.com/gjtempleton) [#8333](https://github.com/kubernetes/kops/pull/8333)
* Bump etcd-manager to 3.0.20200116 (#8310) [@mmerrill3](https://github.com/mmerrill3) [#8399](https://github.com/kubernetes/kops/pull/8399)
* Remove addons only applicable to unsupported versions of Kubernetes [@johngmyers](https://github.com/johngmyers) [#8318](https://github.com/kubernetes/kops/pull/8318)
* Don't load nonexistent calico-client cert when CNI is Cilium [@johngmyers](https://github.com/johngmyers) [#8338](https://github.com/kubernetes/kops/pull/8338)
* Edit author name [@LinshanYu](https://github.com/LinshanYu) [#8374](https://github.com/kubernetes/kops/pull/8374)
* Kops releases - prefix git tags with v [@rifelpet](https://github.com/rifelpet) [#8373](https://github.com/kubernetes/kops/pull/8373)
* Support additional kube-scheduler config parameters via config file [@rralcala](https://github.com/rralcala) [#8407](https://github.com/kubernetes/kops/pull/8407)
* Option to increase concurrency of rolling update within instancegroup [@johngmyers](https://github.com/johngmyers) [#8271](https://github.com/kubernetes/kops/pull/8271)
* Fix template clusterName behavior [@lcrisci](https://github.com/lcrisci) [#7319](https://github.com/kubernetes/kops/pull/7319)
* Update support for Amazon Linux 2 [@hakman](https://github.com/hakman) [#8425](https://github.com/kubernetes/kops/pull/8425)
* Announce impending removal of v1alpha1 API [@johngmyers](https://github.com/johngmyers),[@justinsb](https://github.com/justinsb) [#8064](https://github.com/kubernetes/kops/pull/8064)
* Alicloud: etcd-manager support [@bittopaz](https://github.com/bittopaz) [#8016](https://github.com/kubernetes/kops/pull/8016)
* Fixes regression in e2e tests [@rralcala](https://github.com/rralcala) [#8430](https://github.com/kubernetes/kops/pull/8430)
* Release notes for 1.17.0-alpha.2 [@justinsb](https://github.com/justinsb) [#8438](https://github.com/kubernetes/kops/pull/8438)
* Add missing priorityClassName for critical pods [@johngmyers](https://github.com/johngmyers) [#8200](https://github.com/kubernetes/kops/pull/8200)
* Release notes for 1.16.0-beta.1 [@justinsb](https://github.com/justinsb) [#8441](https://github.com/kubernetes/kops/pull/8441)
* Release notes for 1.15.1 [@justinsb](https://github.com/justinsb) [#8442](https://github.com/kubernetes/kops/pull/8442)
* Fix typo in comment [@longkb](https://github.com/longkb) [#8444](https://github.com/kubernetes/kops/pull/8444)

## 1.18.0-alpha.1 to 1.18.0-alpha.2

* Add an EnvVar type to the API [@rifelpet](https://github.com/rifelpet) [#8455](https://github.com/kubernetes/kops/pull/8455)
* Update coredns to 1.6.7 [@maruina](https://github.com/maruina) [#8452](https://github.com/kubernetes/kops/pull/8452)
* Update godoc.org references to use pkg.go.dev [@rifelpet](https://github.com/rifelpet) [#8460](https://github.com/kubernetes/kops/pull/8460)
* docs: trivial fix some typos [@truongnh1992](https://github.com/truongnh1992) [#8450](https://github.com/kubernetes/kops/pull/8450)
* Tag EBS volumes when using launch templates with AWS API target [@johngmyers](https://github.com/johngmyers) [#8462](https://github.com/kubernetes/kops/pull/8462)
* [DigitalOcean] Add load balancer support for master HA [@srikiz](https://github.com/srikiz) [#8237](https://github.com/kubernetes/kops/pull/8237)
* Cilium - Add missing Identity Allocation Mode to Operator Template [@daviddyball](https://github.com/daviddyball) [#8445](https://github.com/kubernetes/kops/pull/8445)
* Stop logging to /var/log/kops-controller.log [@justinsb](https://github.com/justinsb) [#8467](https://github.com/kubernetes/kops/pull/8467)
* Fix typos in cluster_spec.md [@hase1128](https://github.com/hase1128) [#8474](https://github.com/kubernetes/kops/pull/8474)
* Fix Github download url for nodeup [@adri](https://github.com/adri),[@justinsb](https://github.com/justinsb) [#8468](https://github.com/kubernetes/kops/pull/8468)

## v1.18.0-alpha.2 to v1.18.0-alpha.3

* Release notes for 1.18.0-alpha.2 [@justinsb](https://github.com/justinsb) [#8480](https://github.com/kubernetes/kops/pull/8480)
* Update cilium to 1.6.6 [@olemarkus](https://github.com/olemarkus) [#8484](https://github.com/kubernetes/kops/pull/8484)
* Release notes for 1.17.0-alpha.3 [@justinsb](https://github.com/justinsb) [#8485](https://github.com/kubernetes/kops/pull/8485)
* Make it possible to enable Prometheus metrics for Cilium [@olemarkus](https://github.com/olemarkus) [#8433](https://github.com/kubernetes/kops/pull/8433)
* GCS: Don't try to set ACLs if bucket-policy only is set [@justinsb](https://github.com/justinsb) [#8493](https://github.com/kubernetes/kops/pull/8493)
* Revert "Merge pull request #8452 from maruina/coredns-1.6.7" [@gjtempleton](https://github.com/gjtempleton) [#8503](https://github.com/kubernetes/kops/pull/8503)
* GCS: Fix bug where around retry on GCS [@justinsb](https://github.com/justinsb) [#8495](https://github.com/kubernetes/kops/pull/8495)
* Fix Netlify deps for tests [@hakman](https://github.com/hakman) [#8506](https://github.com/kubernetes/kops/pull/8506)
* GCS: Log ACLs if we're writing them [@justinsb](https://github.com/justinsb) [#8496](https://github.com/kubernetes/kops/pull/8496)
* Move cloudbuild.yaml to repo root [@rifelpet](https://github.com/rifelpet) [#8505](https://github.com/kubernetes/kops/pull/8505)
* Add support for containerd v1.3.3 [@hakman](https://github.com/hakman) [#8504](https://github.com/kubernetes/kops/pull/8504)
* Use BindMount task for /home/kubernetes/bin [@justinsb](https://github.com/justinsb) [#8461](https://github.com/kubernetes/kops/pull/8461)
* Release notes for 1.15.2 [@justinsb](https://github.com/justinsb) [#8513](https://github.com/kubernetes/kops/pull/8513)
* Image Pushing - Remove .git dependency from get_workspace_status.sh [@rifelpet](https://github.com/rifelpet) [#8514](https://github.com/kubernetes/kops/pull/8514)
* [vendoring] Update google libs to latest [@geojaz](https://github.com/geojaz) [#8516](https://github.com/kubernetes/kops/pull/8516)
* cloudbuild: Try uploading our binaries to the staging bucket also [@justinsb](https://github.com/justinsb) [#8518](https://github.com/kubernetes/kops/pull/8518)
* Return more errors at once during API validation [@johngmyers](https://github.com/johngmyers) [#8449](https://github.com/kubernetes/kops/pull/8449)
* Release notes for 1.16.0-beta.2 [@justinsb](https://github.com/justinsb) [#8519](https://github.com/kubernetes/kops/pull/8519)
* Bump alphas to stable [@olemarkus](https://github.com/olemarkus) [#8489](https://github.com/kubernetes/kops/pull/8489)
* Use larger machine type for cloudbuild jobs [@rifelpet](https://github.com/rifelpet) [#8520](https://github.com/kubernetes/kops/pull/8520)
* Mark dns-controller and kops-controller as non-root [@johngmyers](https://github.com/johngmyers) [#8497](https://github.com/kubernetes/kops/pull/8497)
* Alicloud: support modification of LaunchConfiguration [@bittopaz](https://github.com/bittopaz) [#8246](https://github.com/kubernetes/kops/pull/8246)
* Fix Machine types vcpus [@mikesplain](https://github.com/mikesplain) [#8522](https://github.com/kubernetes/kops/pull/8522)
* Update AWS IAM Authenticator to 0.5.0 [@rifelpet](https://github.com/rifelpet) [#8423](https://github.com/kubernetes/kops/pull/8423)
* Release notes for 1.17.0-alpha.4 [@justinsb](https://github.com/justinsb) [#8524](https://github.com/kubernetes/kops/pull/8524)
* Add unit test for pkg/jsonutils/streamwriter.go [@tiendc](https://github.com/tiendc) [#8475](https://github.com/kubernetes/kops/pull/8475)
* channels: bump k8s versions after feb. patch releases [@idealhack](https://github.com/idealhack) [#8532](https://github.com/kubernetes/kops/pull/8532)
* Add events RBAC permissions to kops-controller [@rifelpet](https://github.com/rifelpet) [#8535](https://github.com/kubernetes/kops/pull/8535)
* Update amazon-vpc-cni-k8s to v1.6.0 [@hakman](https://github.com/hakman) [#8538](https://github.com/kubernetes/kops/pull/8538)
* Cilium nodeport [@olemarkus](https://github.com/olemarkus) [#8220](https://github.com/kubernetes/kops/pull/8220)
* Update IAM permissions for amazon-vpc-cni-k8s 1.6.0 [@rifelpet](https://github.com/rifelpet) [#8548](https://github.com/kubernetes/kops/pull/8548)
* Only create git tags with the v prefix [@rifelpet](https://github.com/rifelpet) [#8547](https://github.com/kubernetes/kops/pull/8547)
* Switch AWS IAM Authenticator to use non-scratch image [@rifelpet](https://github.com/rifelpet) [#8555](https://github.com/kubernetes/kops/pull/8555)
* Add Kubernetes deprecation/removal release notes [@johngmyers](https://github.com/johngmyers) [#8443](https://github.com/kubernetes/kops/pull/8443)
* go-bindata: don't store file metadata [@justinsb](https://github.com/justinsb) [#8565](https://github.com/kubernetes/kops/pull/8565)
* Replace unmaintained go-bindata [@justinsb](https://github.com/justinsb) [#8561](https://github.com/kubernetes/kops/pull/8561)
* gzip: use --no-name to avoid saving timestamp [@justinsb](https://github.com/justinsb) [#8566](https://github.com/kubernetes/kops/pull/8566)
* Update makefile to reduce dependency on GOPATH [@rifelpet](https://github.com/rifelpet) [#8570](https://github.com/kubernetes/kops/pull/8570)
* Fix field names in api validation [@johngmyers](https://github.com/johngmyers) [#8569](https://github.com/kubernetes/kops/pull/8569)
* Update golang to 1.13.8 [@justinsb](https://github.com/justinsb) [#8574](https://github.com/kubernetes/kops/pull/8574)
* Hack directory cleanup [@rifelpet](https://github.com/rifelpet) [#8572](https://github.com/kubernetes/kops/pull/8572)
* Cilium eni [@olemarkus](https://github.com/olemarkus) [#8316](https://github.com/kubernetes/kops/pull/8316)
* EnsureFileOwner: cleanup logic [@justinsb](https://github.com/justinsb) [#8576](https://github.com/kubernetes/kops/pull/8576)
* Use UTC when calculating copyright year [@johngmyers](https://github.com/johngmyers) [#8575](https://github.com/kubernetes/kops/pull/8575)
* makefile: use more hash helpers when building images [@justinsb](https://github.com/justinsb) [#8568](https://github.com/kubernetes/kops/pull/8568)
* Add External Policies (AWS managed policy attachments) [@mattouille](https://github.com/mattouille) [#7837](https://github.com/kubernetes/kops/pull/7837)
* Fix inappropriate use of field.Invalid() [@johngmyers](https://github.com/johngmyers) [#8578](https://github.com/kubernetes/kops/pull/8578)
* Use cluster name as default subnet tag for Lyft CNI [@hakman](https://github.com/hakman) [#8571](https://github.com/kubernetes/kops/pull/8571)
* Staging build: don't use _GIT_TAG [@justinsb](https://github.com/justinsb) [#8585](https://github.com/kubernetes/kops/pull/8585)
* prow-postsubmit: Upload to a consistently named directory [@justinsb](https://github.com/justinsb) [#8586](https://github.com/kubernetes/kops/pull/8586)
* Spotinst: Add OWNERS file to Spotinst specific packages [@liranp](https://github.com/liranp) [#8533](https://github.com/kubernetes/kops/pull/8533)
* Bump Cilium to 1.7 for k8s 1.12+ [@olemarkus](https://github.com/olemarkus) [#8589](https://github.com/kubernetes/kops/pull/8589)
* add s3 region [@zetaab](https://github.com/zetaab) [#8592](https://github.com/kubernetes/kops/pull/8592)
* Add unit test for pkg/nodelabels/builder.go [@tiendc](https://github.com/tiendc) [#8539](https://github.com/kubernetes/kops/pull/8539)
* Fix typo in the cilium default version [@olemarkus](https://github.com/olemarkus) [#8591](https://github.com/kubernetes/kops/pull/8591)
* Add unit test for pkg/apis/kops/util/labels.go [@tiendc](https://github.com/tiendc) [#8595](https://github.com/kubernetes/kops/pull/8595)
* Fail cluster validation if a master missing kube-controller-manager [@johngmyers](https://github.com/johngmyers) [#8600](https://github.com/kubernetes/kops/pull/8600)
* Update tags support for LaunchTemplates [@hakman](https://github.com/hakman) [#8466](https://github.com/kubernetes/kops/pull/8466)
* Fix a bug in UT apis/kops/util/labels_test.go [@tiendc](https://github.com/tiendc) [#8604](https://github.com/kubernetes/kops/pull/8604)
* [Digital Ocean] Update documentation for multi-master HA setup [@srikiz](https://github.com/srikiz) [#8601](https://github.com/kubernetes/kops/pull/8601)
* Add release notes and docs for containerd [@hakman](https://github.com/hakman) [#8603](https://github.com/kubernetes/kops/pull/8603)
* Update coredns to 1.6.7 [@maruina](https://github.com/maruina) [#8602](https://github.com/kubernetes/kops/pull/8602)
* Use supported kubernetes versions in tests [@johngmyers](https://github.com/johngmyers) [#8610](https://github.com/kubernetes/kops/pull/8610)
* kubelet: map rotate-certificates options [@justinsb](https://github.com/justinsb) [#8581](https://github.com/kubernetes/kops/pull/8581)
* Resolve TODO in /pkg/model/component/context.go [@sshukun](https://github.com/sshukun) [#8579](https://github.com/kubernetes/kops/pull/8579)
* Fix typo in comment for struct LyftVPCNetworkingSpec [@fenggw-fnst](https://github.com/fenggw-fnst) [#8590](https://github.com/kubernetes/kops/pull/8590)
* Cilium fix bpffs check [@olemarkus](https://github.com/olemarkus) [#8599](https://github.com/kubernetes/kops/pull/8599)
* Spotinst: Add support for blacklisting or whitelisting instance types in Ocean [@liranp](https://github.com/liranp) [#8549](https://github.com/kubernetes/kops/pull/8549)
* Don't try to configure a bastion DNS name in gossip mode [@justinsb](https://github.com/justinsb) [#8573](https://github.com/kubernetes/kops/pull/8573)
* use v0.29 in prometheus operator [@coryschwartz](https://github.com/coryschwartz) [#8563](https://github.com/kubernetes/kops/pull/8563)
* Update Calico CNI Networking Documentation Links [@jpugliesi](https://github.com/jpugliesi) [#8473](https://github.com/kubernetes/kops/pull/8473)
* Spotinst: Support for Tags (Cloud Labels) in Ocean Launch Spec [@liranp](https://github.com/liranp) [#8616](https://github.com/kubernetes/kops/pull/8616)
* Refuse to read channels with addons with unparseable versions [@johngmyers](https://github.com/johngmyers) [#8408](https://github.com/kubernetes/kops/pull/8408)
* Adding Unit Test for pkg/dns/gossip.go  [#8631](https://github.com/kubernetes/kops/pull/8631)
* Validate at most one networking option chosen [@johngmyers](https://github.com/johngmyers) [#8617](https://github.com/kubernetes/kops/pull/8617)
* Add support for custom env vars in amazon-vpc-cni [@rifelpet](https://github.com/rifelpet) [#8276](https://github.com/kubernetes/kops/pull/8276)
* Promote alphas to stable [@olemarkus](https://github.com/olemarkus) [#8632](https://github.com/kubernetes/kops/pull/8632)
* Release notes for 1.16.0 [@justinsb](https://github.com/justinsb) [#8637](https://github.com/kubernetes/kops/pull/8637)
* Update Calico and Canal to v3.12.0 [@hakman](https://github.com/hakman) [#8618](https://github.com/kubernetes/kops/pull/8618)
* Release notes for 1.17.0 beta.1 [@justinsb](https://github.com/justinsb) [#8641](https://github.com/kubernetes/kops/pull/8641)
* Update release process [@justinsb](https://github.com/justinsb) [#8453](https://github.com/kubernetes/kops/pull/8453)
* Fix node-authorizer/pkg/server staticcheck failure [@hakman](https://github.com/hakman) [#8649](https://github.com/kubernetes/kops/pull/8649)
* Bump Calico and Canal version tags for older k8s [@hakman](https://github.com/hakman) [#8646](https://github.com/kubernetes/kops/pull/8646)
* Add the aws iam authenticator known issue to the 1.17 release notes [@rifelpet](https://github.com/rifelpet) [#8651](https://github.com/kubernetes/kops/pull/8651)
* Install packages updates during bootstrap [@hakman](https://github.com/hakman) [#8635](https://github.com/kubernetes/kops/pull/8635)
* Treat nil of LaunchTemplateSpecification.Version as $Default [0] [@qqshfox](https://github.com/qqshfox) [#8567](https://github.com/kubernetes/kops/pull/8567)
* Cleanup release documentation [@rifelpet](https://github.com/rifelpet) [#8654](https://github.com/kubernetes/kops/pull/8654)
* Fix condition for innstall packages updates during bootstrap [@hakman](https://github.com/hakman) [#8657](https://github.com/kubernetes/kops/pull/8657)
* Delete launch templates when using EnableLaunchTemplates [@hakman](https://github.com/hakman) [#8639](https://github.com/kubernetes/kops/pull/8639)
* Update release notes for the default instance type change [@hakman](https://github.com/hakman) [#8658](https://github.com/kubernetes/kops/pull/8658)
* Remove not-yet-released blurb now that 1.16.0 has been released [@johngmyers](https://github.com/johngmyers) [#8659](https://github.com/kubernetes/kops/pull/8659)
* Add "owned" tag for volumes and instances created with launch templates [@hakman](https://github.com/hakman) [#8660](https://github.com/kubernetes/kops/pull/8660)
* support apiserver --kubelet-certificate-authority  flag [@tanjunchen](https://github.com/tanjunchen) [#8661](https://github.com/kubernetes/kops/pull/8661)
* Fix punctuation [@johngmyers](https://github.com/johngmyers) [#8663](https://github.com/kubernetes/kops/pull/8663)
* Fix SecurityGroup check when there are no Network Interfaces associated with a LaunchTemplate [@KashifSaadat](https://github.com/KashifSaadat) [#8666](https://github.com/kubernetes/kops/pull/8666)
* Revert AWS IAM Authenticator upgrade to 0.5.0 on master [@rifelpet](https://github.com/rifelpet) [#8670](https://github.com/kubernetes/kops/pull/8670)
* Update compatibility matrix [@johngmyers](https://github.com/johngmyers) [#8672](https://github.com/kubernetes/kops/pull/8672)
* Option to surge during rolling update [@johngmyers](https://github.com/johngmyers) [#8313](https://github.com/kubernetes/kops/pull/8313)
* retry nvidia-device-plugin.sh when failed [@qqshfox](https://github.com/qqshfox) [#7989](https://github.com/kubernetes/kops/pull/7989)
* Changed "you cache" to "your cache" [@medined](https://github.com/medined) [#8669](https://github.com/kubernetes/kops/pull/8669)
* [Digital Ocean] Fix minor document issue [@srikiz](https://github.com/srikiz) [#8676](https://github.com/kubernetes/kops/pull/8676)
* Default maxSurge to 1 on AWS [@johngmyers](https://github.com/johngmyers) [#8674](https://github.com/kubernetes/kops/pull/8674)
* Update roadmap [@johngmyers](https://github.com/johngmyers) [#8675](https://github.com/kubernetes/kops/pull/8675)
* amazon-vpc-routed-eni env variable config [@mikesplain](https://github.com/mikesplain) [#8682](https://github.com/kubernetes/kops/pull/8682)
* [Docs] Add service account token volumes [@jmymy](https://github.com/jmymy) [#8680](https://github.com/kubernetes/kops/pull/8680)
* Update rolling update documentation [@johngmyers](https://github.com/johngmyers) [#8673](https://github.com/kubernetes/kops/pull/8673)
* Add more API validation for Cilium [@johngmyers](https://github.com/johngmyers) [#8667](https://github.com/kubernetes/kops/pull/8667)
* Update Weave Net to version 2.6.1 [@hakman](https://github.com/hakman) [#8691](https://github.com/kubernetes/kops/pull/8691)
* Update etcd-manager to 3.0.20200307 [@justinsb](https://github.com/justinsb) [#8692](https://github.com/kubernetes/kops/pull/8692)
* [Docs] add link for Service Account Token Volumes [@jmymy](https://github.com/jmymy) [#8688](https://github.com/kubernetes/kops/pull/8688)
* Add UT for util/pkg/vfs/fs.go [@tiendc](https://github.com/tiendc) [#8686](https://github.com/kubernetes/kops/pull/8686)
* remove // TODO path.Join here? [@tanjunchen](https://github.com/tanjunchen) [#8701](https://github.com/kubernetes/kops/pull/8701)
* Refactor/simplify rolling update [@johngmyers](https://github.com/johngmyers) [#8709](https://github.com/kubernetes/kops/pull/8709)
* Add UT for util/pkg/proxy/proxy.go [@tiendc](https://github.com/tiendc) [#8640](https://github.com/kubernetes/kops/pull/8640)
* Adding Unit Test for util/pkg/exec/exec.go  [#8712](https://github.com/kubernetes/kops/pull/8712)
* remove // TODO move this into networking.go :( [@tanjunchen](https://github.com/tanjunchen) [#8711](https://github.com/kubernetes/kops/pull/8711)
* Bump Cilium to 1.7.1 for k8s 1.12+ [@errordeveloper](https://github.com/errordeveloper) [#8713](https://github.com/kubernetes/kops/pull/8713)
* Use BPF_FS_MAGIC from go sys lib instead of hardcode [@odinuge](https://github.com/odinuge) [#8650](https://github.com/kubernetes/kops/pull/8650)
* Fix uploading of file assets [@johngmyers](https://github.com/johngmyers) [#8694](https://github.com/kubernetes/kops/pull/8694)
* Add labels to OWNERS files [@rifelpet](https://github.com/rifelpet) [#8717](https://github.com/kubernetes/kops/pull/8717)
* Support the kops.k8s.io/needs-update annotation on nodes [@johngmyers](https://github.com/johngmyers) [#8272](https://github.com/kubernetes/kops/pull/8272)
* When nodeport is enabled, use strict kube-proxy-replacement to ensure… [@olemarkus](https://github.com/olemarkus) [#8655](https://github.com/kubernetes/kops/pull/8655)
* Upgrade AWS SDK [@rifelpet](https://github.com/rifelpet) [#8721](https://github.com/kubernetes/kops/pull/8721)
* fix OWNERS labels format [@rifelpet](https://github.com/rifelpet) [#8725](https://github.com/kubernetes/kops/pull/8725)
* Adding docs for calico MTU [@vgunapati](https://github.com/vgunapati),[@rifelpet](https://github.com/rifelpet) [#8724](https://github.com/kubernetes/kops/pull/8724)
* Add support for Ubuntu 20.04 (Focal) [@hakman](https://github.com/hakman) [#8727](https://github.com/kubernetes/kops/pull/8727)
* Use PriorityClassName instead of namespace in cluster validation [@johngmyers](https://github.com/johngmyers) [#8446](https://github.com/kubernetes/kops/pull/8446)
* Fix kuberouter for k8s 1.16+ [@UnderMyBed](https://github.com/UnderMyBed) [#8697](https://github.com/kubernetes/kops/pull/8697)
* Update cilium docs with note about eni and bpf nodeport [@olemarkus](https://github.com/olemarkus) [#8551](https://github.com/kubernetes/kops/pull/8551)
* Update alpha channel with the march updates [@olemarkus](https://github.com/olemarkus) [#8733](https://github.com/kubernetes/kops/pull/8733)
* Document all the fields in the Cilium spec [@olemarkus](https://github.com/olemarkus) [#8559](https://github.com/kubernetes/kops/pull/8559)
* Update kube-router to v0.4.0 [@hakman](https://github.com/hakman) [#8735](https://github.com/kubernetes/kops/pull/8735)
* Add UT for util/pkg/vfs/memfs.go [@tiendc](https://github.com/tiendc) [#8730](https://github.com/kubernetes/kops/pull/8730)
* Remove unused integration test files, make complex cluster spec consistent [@rifelpet](https://github.com/rifelpet) [#8739](https://github.com/kubernetes/kops/pull/8739)
* Set kube-proxy-replacement to partial [@olemarkus](https://github.com/olemarkus) [#8741](https://github.com/kubernetes/kops/pull/8741)
* Create New Default StorageClass: kops-ssd-1-17 [@joshbranham](https://github.com/joshbranham) [#8582](https://github.com/kubernetes/kops/pull/8582)
* Fix template for kube-router v0.4.0 [@hakman](https://github.com/hakman) [#8742](https://github.com/kubernetes/kops/pull/8742)
* Node metadata-concealment in GCE [@geojaz](https://github.com/geojaz) [#8634](https://github.com/kubernetes/kops/pull/8634)
* Add cloud ntp addresses [@simonmacklin](https://github.com/simonmacklin) [#8312](https://github.com/kubernetes/kops/pull/8312)
* Update support for docker tgz package [@hakman](https://github.com/hakman) [#8525](https://github.com/kubernetes/kops/pull/8525)
* Add option to use etcd managed by cilium-etcd-operator as kvstore [@olemarkus](https://github.com/olemarkus) [#8629](https://github.com/kubernetes/kops/pull/8629)
* Tweak the featureflag.GoogleCloudBucketACL.Enabled [@geojaz](https://github.com/geojaz) [#8747](https://github.com/kubernetes/kops/pull/8747)
* Move "docker-healthcheck" to DockerBuilder [@hakman](https://github.com/hakman) [#8221](https://github.com/kubernetes/kops/pull/8221)
* Update Docker to 19.03.8 for 1.18 [@hakman](https://github.com/hakman) [#8748](https://github.com/kubernetes/kops/pull/8748)
* Fix template for kube-router v0.4.0 #2 [@hakman](https://github.com/hakman) [#8751](https://github.com/kubernetes/kops/pull/8751)
* etcd admin doc [@sdarwin](https://github.com/sdarwin) [#8729](https://github.com/kubernetes/kops/pull/8729)
* Allow users to overwrite etcd settings. [@rdrgmnzs](https://github.com/rdrgmnzs) [#8402](https://github.com/kubernetes/kops/pull/8402)
* Update apiVersion to resolve 'no matches for kind "Deployment" in ver… [@medined](https://github.com/medined) [#8732](https://github.com/kubernetes/kops/pull/8732)
* Fix command descriptions to match new cluster validation behavior [@johngmyers](https://github.com/johngmyers) [#8755](https://github.com/kubernetes/kops/pull/8755)
* Deprecate the route53-mapper addon [@rifelpet](https://github.com/rifelpet) [#8753](https://github.com/kubernetes/kops/pull/8753)
* Use containerd 1.2.13 with Docker 19.03.8 [@hakman](https://github.com/hakman) [#8756](https://github.com/kubernetes/kops/pull/8756)
* Expose etcd metrics. [@michalschott](https://github.com/michalschott) [#8162](https://github.com/kubernetes/kops/pull/8162)
* Add LaunchTemplate integration tests [@hakman](https://github.com/hakman) [#8758](https://github.com/kubernetes/kops/pull/8758)
* Add root volume tags for CF and TF targets [@hakman](https://github.com/hakman) [#8693](https://github.com/kubernetes/kops/pull/8693)
* Gce tests lifecycle [@geojaz](https://github.com/geojaz) [#8760](https://github.com/kubernetes/kops/pull/8760)
* Update lyft CNI to 0.6.0 [@maruina](https://github.com/maruina) [#8757](https://github.com/kubernetes/kops/pull/8757)
* Update Weave Net to version 2.6.2 [@hakman](https://github.com/hakman) [#8764](https://github.com/kubernetes/kops/pull/8764)
* Fix NTP failures after #8312 [@hakman](https://github.com/hakman) [#8763](https://github.com/kubernetes/kops/pull/8763)
* add support for OpenStack Octavia AllowedCIDRs [@zetaab](https://github.com/zetaab) [#8762](https://github.com/kubernetes/kops/pull/8762)
* Spotinst: Upgrade the Spotinst controller to version 1.0.57 [@liranp](https://github.com/liranp) [#8770](https://github.com/kubernetes/kops/pull/8770)
* Add missing priorityClassName to addons [@johngmyers](https://github.com/johngmyers) [#8752](https://github.com/kubernetes/kops/pull/8752)
* Allow configuration of enable-remote-node-identity [@olemarkus](https://github.com/olemarkus) [#8731](https://github.com/kubernetes/kops/pull/8731)
* Wait for validation to succeed N consecutive times [@hakman](https://github.com/hakman) [#8515](https://github.com/kubernetes/kops/pull/8515)
* Set default log level to "info" for containerd [@hakman](https://github.com/hakman) [#8782](https://github.com/kubernetes/kops/pull/8782)
* Upgrade to bazel 2.2.0 [@rifelpet](https://github.com/rifelpet) [#8790](https://github.com/kubernetes/kops/pull/8790)
* Add cilium option tofqdns-dns-reject-response-code [@fentas](https://github.com/fentas) [#8779](https://github.com/kubernetes/kops/pull/8779)
* Update bazel rules [@rifelpet](https://github.com/rifelpet) [#8749](https://github.com/kubernetes/kops/pull/8749)
* Make cilium operator health check go against localhost IP [@olemarkus](https://github.com/olemarkus) [#8789](https://github.com/kubernetes/kops/pull/8789)
* Canal v3.13.1 [@KashifSaadat](https://github.com/KashifSaadat) [#8795](https://github.com/kubernetes/kops/pull/8795)
* Fix weaveworks/mesh vendoring [@rifelpet](https://github.com/rifelpet) [#8797](https://github.com/kubernetes/kops/pull/8797)
* Update default users for kubeconfig with supported distros [@hakman](https://github.com/hakman) [#8798](https://github.com/kubernetes/kops/pull/8798)
* Update default user for CoreOS, Flatcar for kubecfg [@KashifSaadat](https://github.com/KashifSaadat) [#8800](https://github.com/kubernetes/kops/pull/8800)
* Add UT for upup/pkg/fi/files.go [@tiendc](https://github.com/tiendc) [#8776](https://github.com/kubernetes/kops/pull/8776)
* Deprecate support for Kubernetes 1.10 [@johngmyers](https://github.com/johngmyers) [#8799](https://github.com/kubernetes/kops/pull/8799)
* Fix terraform json field tags [@rifelpet](https://github.com/rifelpet) [#8813](https://github.com/kubernetes/kops/pull/8813)
* Remove v1alpha1 API [@johngmyers](https://github.com/johngmyers) [#8431](https://github.com/kubernetes/kops/pull/8431)
* Disable anonymous auth in integration test clusters [@rifelpet](https://github.com/rifelpet) [#8816](https://github.com/kubernetes/kops/pull/8816)
* Refactor integration tests [@rifelpet](https://github.com/rifelpet) [#8737](https://github.com/kubernetes/kops/pull/8737)
* Fix dns-controller flapping on spot instances [@johngmyers](https://github.com/johngmyers) [#8821](https://github.com/kubernetes/kops/pull/8821)
* Adding support for the Middle East (Bahrain) region (me-south-1) [@liranp](https://github.com/liranp) [#8820](https://github.com/kubernetes/kops/pull/8820)
* Don't set terraform user_data if it is empty  [@rifelpet](https://github.com/rifelpet) [#8744](https://github.com/kubernetes/kops/pull/8744)
* Add terraform testing [@rifelpet](https://github.com/rifelpet) [#8734](https://github.com/kubernetes/kops/pull/8734)
* Add support for Spot block in launch template [@thejasbabu](https://github.com/thejasbabu) [#8802](https://github.com/kubernetes/kops/pull/8802)
* Cleanup InstanceGroup MixedInstancePolicy docs [@gjtempleton](https://github.com/gjtempleton) [#8832](https://github.com/kubernetes/kops/pull/8832)
* Enable stamping on bazel image builds [@rifelpet](https://github.com/rifelpet) [#8835](https://github.com/kubernetes/kops/pull/8835)
* Remove unused ECU and Burstable fields from AWSMachineTypeInfo [@rifelpet](https://github.com/rifelpet) [#8844](https://github.com/kubernetes/kops/pull/8844)
* Use CNI 0.8.5 for Kubernetes 1.18+ [@hakman](https://github.com/hakman) [#8848](https://github.com/kubernetes/kops/pull/8848)
* Update GCB jobs to use bazel 2.2.0 [@rifelpet](https://github.com/rifelpet) [#8849](https://github.com/kubernetes/kops/pull/8849)
* Adds a gce-service-account flag so you BYO service-account [@geojaz](https://github.com/geojaz) [#8761](https://github.com/kubernetes/kops/pull/8761)
* Balk at using Kubernetes versions too new to be supported [@johngmyers](https://github.com/johngmyers) [#8700](https://github.com/kubernetes/kops/pull/8700)
* Remove basic authentication support for k8s 1.19+ [@hakman](https://github.com/hakman) [#8783](https://github.com/kubernetes/kops/pull/8783)
* Make kubelet topology-manager-policy configurable [@olemarkus](https://github.com/olemarkus) [#8833](https://github.com/kubernetes/kops/pull/8833)
* Switch to the k/k implementation of drain.Helper [@johngmyers](https://github.com/johngmyers) [#8852](https://github.com/kubernetes/kops/pull/8852)
* Update build instructions for dns controller [@justinsb](https://github.com/justinsb) [#8853](https://github.com/kubernetes/kops/pull/8853)
* Switch to using ec2.DescribeInstanceTypes for building the MachineTypes list [@rifelpet](https://github.com/rifelpet) [#8847](https://github.com/kubernetes/kops/pull/8847)
* Remove support for Docker 1.11, 1.12 and 1.13 [@hakman](https://github.com/hakman) [#8855](https://github.com/kubernetes/kops/pull/8855)
* Cleanup after #8855 [@hakman](https://github.com/hakman) [#8846](https://github.com/kubernetes/kops/pull/8846)
* fixes auth problem in case of openstack kops-controller [@zetaab](https://github.com/zetaab) [#8862](https://github.com/kubernetes/kops/pull/8862)
* Update metrics-server deployment apiVersion to apps/v1 [@elisiano](https://github.com/elisiano) [#8842](https://github.com/kubernetes/kops/pull/8842)
* Update Calico and Canal to v3.13.2 [@hakman](https://github.com/hakman) [#8865](https://github.com/kubernetes/kops/pull/8865)
* GCE: Delete cluster will also delete the DNS entries created by kubernetes [@mccare](https://github.com/mccare),[@justinsb](https://github.com/justinsb) [#8250](https://github.com/kubernetes/kops/pull/8250)
* Add Terraform 0.12 support [@rifelpet](https://github.com/rifelpet) [#8825](https://github.com/kubernetes/kops/pull/8825)
* Don't compress bindata & allow Kops to be imported as a package. [@rdrgmnzs](https://github.com/rdrgmnzs),[@justinsb](https://github.com/justinsb) [#8584](https://github.com/kubernetes/kops/pull/8584)
* Validate cluster N times in rolling-update [@zetaab](https://github.com/zetaab) [#8868](https://github.com/kubernetes/kops/pull/8868)
* Update go.mod for k8s 1.17 [@justinsb](https://github.com/justinsb) [#8873](https://github.com/kubernetes/kops/pull/8873)
* pkg: add some unit tests [@q384566678](https://github.com/q384566678) [#8872](https://github.com/kubernetes/kops/pull/8872)
* add verify-bindata.sh & separate bindata check and update make commands. [@rdrgmnzs](https://github.com/rdrgmnzs) [#8876](https://github.com/kubernetes/kops/pull/8876)
* Update controller-tools and generate v1 CRDs [@rifelpet](https://github.com/rifelpet) [#8875](https://github.com/kubernetes/kops/pull/8875)
* Don't delete bindata on "make clean" [@rifelpet](https://github.com/rifelpet) [#8877](https://github.com/kubernetes/kops/pull/8877)
* Fix Terraform 0.12 support for GCE [@rifelpet](https://github.com/rifelpet) [#8878](https://github.com/kubernetes/kops/pull/8878)
* Makefile: simplify running go-bindata [@justinsb](https://github.com/justinsb) [#8880](https://github.com/kubernetes/kops/pull/8880)
* update gophercloud dependencies [@zetaab](https://github.com/zetaab) [#8884](https://github.com/kubernetes/kops/pull/8884)
* Update to golang 1.13.9 to match 1.18.1 [@justinsb](https://github.com/justinsb) [#8882](https://github.com/kubernetes/kops/pull/8882)
* Use kubescheduler.config.k8s.io/v1alpha2 for Kubernetes 1.18+ [@hakman](https://github.com/hakman) [#8883](https://github.com/kubernetes/kops/pull/8883)
* Fix addon/ing/nginx v1.6.0 deployment apiVersion and selector [@mousavian](https://github.com/mousavian) [#8857](https://github.com/kubernetes/kops/pull/8857)
* Update go to 1.13.9 (continued) [@justinsb](https://github.com/justinsb) [#8886](https://github.com/kubernetes/kops/pull/8886)
* Replace deprecated x/net/context with context [@justinsb](https://github.com/justinsb) [#8885](https://github.com/kubernetes/kops/pull/8885)
* Add go 1.14 to travis testing [@justinsb](https://github.com/justinsb) [#8893](https://github.com/kubernetes/kops/pull/8893)
* Update 1.18 release notes now that Terraform 0.12 is supported [@rifelpet](https://github.com/rifelpet) [#8892](https://github.com/kubernetes/kops/pull/8892)
* Add Docker version and new distros to release notes [@hakman](https://github.com/hakman) [#8894](https://github.com/kubernetes/kops/pull/8894)
* NodeLocal DNSCache [@mazzy89](https://github.com/mazzy89),[@olemarkus](https://github.com/olemarkus) [#8780](https://github.com/kubernetes/kops/pull/8780)
* Remove duplicated docs [@olemarkus](https://github.com/olemarkus) [#8895](https://github.com/kubernetes/kops/pull/8895)
* Adds docsite hidden note on index.md [@mikesplain](https://github.com/mikesplain) [#8900](https://github.com/kubernetes/kops/pull/8900)
* Clean up the kubectl docs [@olemarkus](https://github.com/olemarkus) [#8901](https://github.com/kubernetes/kops/pull/8901)
* Update to kubernetes 1.18.1 dependencies [@justinsb](https://github.com/justinsb) [#8879](https://github.com/kubernetes/kops/pull/8879)
* Add CloudLabels tags to additional AWS resources [@rifelpet](https://github.com/rifelpet) [#8903](https://github.com/kubernetes/kops/pull/8903)
* Add unit test for func IsGTE [@Hellcatlk](https://github.com/Hellcatlk) [#8905](https://github.com/kubernetes/kops/pull/8905)
* Clean up the spec docs [@olemarkus](https://github.com/olemarkus) [#8902](https://github.com/kubernetes/kops/pull/8902)
* Etcd docs cleanup [@olemarkus](https://github.com/olemarkus) [#8907](https://github.com/kubernetes/kops/pull/8907)
* Exclude GO 1.14 for OSX [@hakman](https://github.com/hakman) [#8918](https://github.com/kubernetes/kops/pull/8918)
* Update security_groups.md [@zhming0](https://github.com/zhming0) [#8912](https://github.com/kubernetes/kops/pull/8912)
* Use etcd-manager for the cilium etcd cluster [@olemarkus](https://github.com/olemarkus) [#8750](https://github.com/kubernetes/kops/pull/8750)
* Bastion additionnal s gs [@nvanheuverzwijn](https://github.com/nvanheuverzwijn) [#8921](https://github.com/kubernetes/kops/pull/8921)
* Change NodeLocalDNS Enabled to *bool [@justinsb](https://github.com/justinsb) [#8930](https://github.com/kubernetes/kops/pull/8930)
* Rolling-update validation harmonization [@justinsb](https://github.com/justinsb) [#8931](https://github.com/kubernetes/kops/pull/8931)
* Upgrade CUDA from 9.1 to 10.0 [@fifar](https://github.com/fifar) [#8482](https://github.com/kubernetes/kops/pull/8482)
* Import package aliases modified [@tomesm](https://github.com/tomesm) [#8933](https://github.com/kubernetes/kops/pull/8933)
* Remove irrelevant TODO comment from userdata [@rifelpet](https://github.com/rifelpet) [#8936](https://github.com/kubernetes/kops/pull/8936)
* Update the testing page [@olemarkus](https://github.com/olemarkus) [#8934](https://github.com/kubernetes/kops/pull/8934)
* Spotinst: Support for Headroom, Taints and Subnets in Ocean Launch Spec and User Data fixes [@liranp](https://github.com/liranp) [#8294](https://github.com/kubernetes/kops/pull/8294)
* Partially implement MountSensitive [@justinsb](https://github.com/justinsb) [#8939](https://github.com/kubernetes/kops/pull/8939)
* Use latest patch version for GO in tests [@hakman](https://github.com/hakman) [#8940](https://github.com/kubernetes/kops/pull/8940)
* Add support for containerd v1.3.4 [@hakman](https://github.com/hakman) [#8941](https://github.com/kubernetes/kops/pull/8941)
* Add unit test for func rewriteAPIGroup [@hs0210](https://github.com/hs0210) [#8947](https://github.com/kubernetes/kops/pull/8947)
* Load the correct certificate before deleting [@olemarkus](https://github.com/olemarkus) [#8945](https://github.com/kubernetes/kops/pull/8945)
* Add unit test for func JoinSuffixes [@hs0210](https://github.com/hs0210) [#8955](https://github.com/kubernetes/kops/pull/8955)
* Update rotating secrets docs [@olemarkus](https://github.com/olemarkus) [#8948](https://github.com/kubernetes/kops/pull/8948)
* Fix net.bridge setting for Flannel on CentOS 7 [@bittopaz](https://github.com/bittopaz) [#8381](https://github.com/kubernetes/kops/pull/8381)
* Turn on flannel sysctl fixes on rhel7 as well [@justinsb](https://github.com/justinsb) [#8958](https://github.com/kubernetes/kops/pull/8958)
* Add unit test case for pkg/systemd/escaping_test.go [@Hellcatlk](https://github.com/Hellcatlk) [#8906](https://github.com/kubernetes/kops/pull/8906)
* Add release notes for 1.16.1 [@justinsb](https://github.com/justinsb) [#8966](https://github.com/kubernetes/kops/pull/8966)
* Modify the wrong name for unit test case [@Hellcatlk](https://github.com/Hellcatlk) [#8970](https://github.com/kubernetes/kops/pull/8970)
* Bumps the gcp client libraries to v0.22.0. [@geojaz](https://github.com/geojaz) [#8969](https://github.com/kubernetes/kops/pull/8969)
* Migrates GCE sdk from v0.beta to v1 [@geojaz](https://github.com/geojaz) [#8972](https://github.com/kubernetes/kops/pull/8972)
* Update Calico and Canal to latest patch versions [@hakman](https://github.com/hakman) [#8961](https://github.com/kubernetes/kops/pull/8961)
* Update alpha and stable channels with April updates [@MoShitrit](https://github.com/MoShitrit) [#8974](https://github.com/kubernetes/kops/pull/8974)
* Make addons directory link absolute to avoid 404 [@dj80hd](https://github.com/dj80hd) [#8986](https://github.com/kubernetes/kops/pull/8986)
* Make CPU Requests for Calico configurable instead of hard-coded [@MoShitrit](https://github.com/MoShitrit) [#8987](https://github.com/kubernetes/kops/pull/8987)
* Ignore already-deleted nodes during rolling update [@johngmyers](https://github.com/johngmyers) [#8994](https://github.com/kubernetes/kops/pull/8994)
* Add initial github actions workflow [@irons](https://github.com/irons) [#8990](https://github.com/kubernetes/kops/pull/8990)
* feat(openstack): propagate cloud labels to machines [@mitch000001](https://github.com/mitch000001) [#8999](https://github.com/kubernetes/kops/pull/8999)
* Profiling and protect kernel defaults flags [@michalschott](https://github.com/michalschott) [#8967](https://github.com/kubernetes/kops/pull/8967)
* Allow single to multi-master cluster [@olemarkus](https://github.com/olemarkus) [#8980](https://github.com/kubernetes/kops/pull/8980)
* Bump cilium to 1.7.2 [@olemarkus](https://github.com/olemarkus) [#8982](https://github.com/kubernetes/kops/pull/8982)
* GCE: needs to use v1 network resources, not beta [@geojaz](https://github.com/geojaz) [#9004](https://github.com/kubernetes/kops/pull/9004)
* Default to Debian 9 (Stretch) for Kubernetes 1.8, 1.9 and 1.10 [@hakman](https://github.com/hakman) [#8977](https://github.com/kubernetes/kops/pull/8977)
* Fix missing changes in Weave manifest [@hakman](https://github.com/hakman) [#8965](https://github.com/kubernetes/kops/pull/8965)
* Spotinst: Support for Grace Period in Ocean Cluster [@liranp](https://github.com/liranp) [#9018](https://github.com/kubernetes/kops/pull/9018)
* Upgrade amazon vpc cni to 1.6.1 [@rifelpet](https://github.com/rifelpet) [#9020](https://github.com/kubernetes/kops/pull/9020)
* Add af-south-1 and eu-south-1 regions (AWS) [@MoShitrit](https://github.com/MoShitrit) [#9021](https://github.com/kubernetes/kops/pull/9021)
* Update to etcd-manager 3.0.20200429 [@justinsb](https://github.com/justinsb) [#9016](https://github.com/kubernetes/kops/pull/9016)
* Use KOPS_RSA_PRIVATE_KEY_SIZE for more keys [@johngmyers](https://github.com/johngmyers) [#8988](https://github.com/kubernetes/kops/pull/8988)
* Don't force bazel to use python2 [@olemarkus](https://github.com/olemarkus) [#8998](https://github.com/kubernetes/kops/pull/8998)
* GCE DNS Cleanup: Print record name [@justinsb](https://github.com/justinsb) [#8869](https://github.com/kubernetes/kops/pull/8869)
* Bump cilium to 1.7.3 [@olemarkus](https://github.com/olemarkus) [#9026](https://github.com/kubernetes/kops/pull/9026)
* Update docs on supported distros and images [@hakman](https://github.com/hakman) [#9029](https://github.com/kubernetes/kops/pull/9029)
* Rename tests to make it easier to search for failing tests [@rifelpet](https://github.com/rifelpet) [#9033](https://github.com/kubernetes/kops/pull/9033)
* Use raw tarfile for AmazonLinux2 + Containerd 1.2.10 [@justinsb](https://github.com/justinsb) [#9032](https://github.com/kubernetes/kops/pull/9032)
* Correct expression typos on docs/aws.md [@gpontesss](https://github.com/gpontesss),[@rifelpet](https://github.com/rifelpet) [#7733](https://github.com/kubernetes/kops/pull/7733)
* Update the cross-account example with working policy [@olemarkus](https://github.com/olemarkus) [#9019](https://github.com/kubernetes/kops/pull/9019)
* Allow changing AZ of masters [@olemarkus](https://github.com/olemarkus) [#9017](https://github.com/kubernetes/kops/pull/9017)
* Update k8s.gcr.io/pause image to version 3.2 [@hakman](https://github.com/hakman) [#9039](https://github.com/kubernetes/kops/pull/9039)
* Update docs on supported distros and release notes [@hakman](https://github.com/hakman) [#9034](https://github.com/kubernetes/kops/pull/9034)
* Updating stable channel to use latest k8s versions [@MoShitrit](https://github.com/MoShitrit) [#9038](https://github.com/kubernetes/kops/pull/9038)
* Support S3 Virtual Hosted Style [@johanneswuerbach](https://github.com/johanneswuerbach) [#8787](https://github.com/kubernetes/kops/pull/8787)
* Feature spotinst controller v1.0.58 [@acaire](https://github.com/acaire) [#9022](https://github.com/kubernetes/kops/pull/9022)
* Ubuntu focal: Use generic docker & container packages [@justinsb](https://github.com/justinsb) [#9044](https://github.com/kubernetes/kops/pull/9044)
* Move GCEServiceAccount into CloudConfig [@johngmyers](https://github.com/johngmyers) [#9055](https://github.com/kubernetes/kops/pull/9055)
* Don't restrict GitHub Actions to master [@johngmyers](https://github.com/johngmyers) [#9054](https://github.com/kubernetes/kops/pull/9054)
* Update service_account_token_volumes.md [@rvirdiz](https://github.com/rvirdiz) [#9050](https://github.com/kubernetes/kops/pull/9050)
* Don't install static utils for Flatcar [@hakman](https://github.com/hakman) [#8978](https://github.com/kubernetes/kops/pull/8978)
* Validate more static pods on masters [@johngmyers](https://github.com/johngmyers) [#9049](https://github.com/kubernetes/kops/pull/9049)
* util/pkg/vfs/fs.go: Add Unit Test for WriteTo [@littleroad](https://github.com/littleroad) [#8997](https://github.com/kubernetes/kops/pull/8997)
* Add more ca-central-1 AZs, add ap-northeast-3 AZs [@johngmyers](https://github.com/johngmyers) [#9064](https://github.com/kubernetes/kops/pull/9064)
* Update docs on supported distros and release notes [@hakman](https://github.com/hakman) [#9059](https://github.com/kubernetes/kops/pull/9059)
* Release notes for 1.15.3 [@justinsb](https://github.com/justinsb) [#9070](https://github.com/kubernetes/kops/pull/9070)
* Release notes for 1.16.2 [@justinsb](https://github.com/justinsb) [#9071](https://github.com/kubernetes/kops/pull/9071)

## v1.18.0-alpha.3 to v1.18.0-beta.1

* Add etcd-manager certificate expiration advisory [@rifelpet](https://github.com/rifelpet) [#9030](https://github.com/kubernetes/kops/pull/9030)
* Treat NatGatewaysNotFound error as already-deleted [@johngmyers](https://github.com/johngmyers) [#9052](https://github.com/kubernetes/kops/pull/9052)
* Allow cluster maintenance when channel is unavailable [@johngmyers](https://github.com/johngmyers) [#9053](https://github.com/kubernetes/kops/pull/9053)
* Release notes for 1.18.0-alpha.3 [@justinsb](https://github.com/justinsb) [#9075](https://github.com/kubernetes/kops/pull/9075)
* Release notes for 1.17.0-beta.2 [@justinsb](https://github.com/justinsb) [#9073](https://github.com/kubernetes/kops/pull/9073)
* Disable TX checksum offload for Flannel VXLAN [@hakman](https://github.com/hakman) [#9074](https://github.com/kubernetes/kops/pull/9074)
* Added support for configuring disable-attach-detach-reconcile-sync in… [@andersosthus](https://github.com/andersosthus) [#9068](https://github.com/kubernetes/kops/pull/9068)
* Add advisory notice to readme and docs homepage [@rifelpet](https://github.com/rifelpet) [#9083](https://github.com/kubernetes/kops/pull/9083)
* Revert "feat(openstack): propagate cloud labels to machines" [@zetaab](https://github.com/zetaab) [#9087](https://github.com/kubernetes/kops/pull/9087)
* kube-apiserver: healthcheck via sidecar container [@justinsb](https://github.com/justinsb) [#9069](https://github.com/kubernetes/kops/pull/9069)
* Include secondary protocol flag always [@jacksontj](https://github.com/jacksontj) [#9008](https://github.com/kubernetes/kops/pull/9008)
* Fix port conflict on etcd-cilium vs dns-controller memberlist [@justinsb](https://github.com/justinsb) [#9097](https://github.com/kubernetes/kops/pull/9097)
* kube-apiserver-healthcheck: actually enable on 1.17 [@justinsb](https://github.com/justinsb) [#9098](https://github.com/kubernetes/kops/pull/9098)
* Update instance_groups.md [@ranshn](https://github.com/ranshn) [#9072](https://github.com/kubernetes/kops/pull/9072)
* Fix containerd image side-loading [@hakman](https://github.com/hakman) [#9101](https://github.com/kubernetes/kops/pull/9101)
* Dont use terraform's file() for singleline strings in GCE metadata [@rifelpet](https://github.com/rifelpet) [#9084](https://github.com/kubernetes/kops/pull/9084)
* Add documentation on gossip [@olemarkus](https://github.com/olemarkus) [#9111](https://github.com/kubernetes/kops/pull/9111)
* upgrade to use cinder v3 api [@zetaab](https://github.com/zetaab) [#9113](https://github.com/kubernetes/kops/pull/9113)
* Fix zsh completion [@olemarkus](https://github.com/olemarkus) [#9108](https://github.com/kubernetes/kops/pull/9108)
* Add unit test for util/pkg/hashing/hash.go [@Hellcatlk](https://github.com/Hellcatlk) [#9114](https://github.com/kubernetes/kops/pull/9114)
* Spotinst: Allow users to disable the controller add-on [@liranp](https://github.com/liranp) [#9091](https://github.com/kubernetes/kops/pull/9091)
* Fail cluster validation if too few nodes for ig's target size [@johngmyers](https://github.com/johngmyers) [#9126](https://github.com/kubernetes/kops/pull/9126)
* Adding most recent version of kube-state-metrics - 1.9.5 [@MoShitrit](https://github.com/MoShitrit) [#9125](https://github.com/kubernetes/kops/pull/9125)
* PKI code cleanup [@johngmyers](https://github.com/johngmyers) [#9106](https://github.com/kubernetes/kops/pull/9106)
* Return cluster validation failure if ASG missing [@johngmyers](https://github.com/johngmyers) [#9118](https://github.com/kubernetes/kops/pull/9118)
* Add EC2 Instance LifeCycle label [@atmosx](https://github.com/atmosx) [#9121](https://github.com/kubernetes/kops/pull/9121)
* add some unit tests [@q384566678](https://github.com/q384566678) [#8960](https://github.com/kubernetes/kops/pull/8960)
* Remove code for unsupported Kubernetes version [@johngmyers](https://github.com/johngmyers) [#9134](https://github.com/kubernetes/kops/pull/9134)
* http download: set a timeout to avoid hangs [@justinsb](https://github.com/justinsb) [#9136](https://github.com/kubernetes/kops/pull/9136)
* Move CNI docs to their own files [@olemarkus](https://github.com/olemarkus) [#9107](https://github.com/kubernetes/kops/pull/9107)
* Added Launch Template support for instance interruption behavior [@tomesm](https://github.com/tomesm),[@rifelpet](https://github.com/rifelpet) [#9024](https://github.com/kubernetes/kops/pull/9024)
* DNS: Don't try to apply empty changesets [@justinsb](https://github.com/justinsb) [#8464](https://github.com/kubernetes/kops/pull/8464)
* Remove redundant menu item in the docs site [@rifelpet](https://github.com/rifelpet) [#9144](https://github.com/kubernetes/kops/pull/9144)
* Remove Classic networking from docs [@johngmyers](https://github.com/johngmyers) [#9142](https://github.com/kubernetes/kops/pull/9142)
* doc: Typo in docs/state.md [@nvanheuverzwijn](https://github.com/nvanheuverzwijn) [#9147](https://github.com/kubernetes/kops/pull/9147)
* Spotinst: Documentation [@liranp](https://github.com/liranp) [#9139](https://github.com/kubernetes/kops/pull/9139)
* Map kube-apiserver service-account-jwks-uri flag [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#9133](https://github.com/kubernetes/kops/pull/9133)
* Don't put bastions in the utility subnets [@johngmyers](https://github.com/johngmyers) [#9124](https://github.com/kubernetes/kops/pull/9124)
* Create golden image test for nodeup kube-apiserver [@justinsb](https://github.com/justinsb) [#8950](https://github.com/kubernetes/kops/pull/8950)
* Add unit test for func matchesElbTags [@hs0210](https://github.com/hs0210) [#8989](https://github.com/kubernetes/kops/pull/8989)
* Remove support for reading legacy-format keypairs [@johngmyers](https://github.com/johngmyers) [#9131](https://github.com/kubernetes/kops/pull/9131)
* Update alpha channels with May updates [@MoShitrit](https://github.com/MoShitrit) [#9155](https://github.com/kubernetes/kops/pull/9155)
* Add support for Kubenet with containerd [@hakman](https://github.com/hakman) [#9104](https://github.com/kubernetes/kops/pull/9104)
* [Digital Ocean] Handle logic for kops edit/update cluster [@srikiz](https://github.com/srikiz) [#9116](https://github.com/kubernetes/kops/pull/9116)
* Move OS deprecations to deprecations section of relnotes [@johngmyers](https://github.com/johngmyers) [#9093](https://github.com/kubernetes/kops/pull/9093)
* Add unit test case for pkg/k8sversion/version_test.go [@Hellcatlk](https://github.com/Hellcatlk) [#9112](https://github.com/kubernetes/kops/pull/9112)
* Update OWNERS file [@johngmyers](https://github.com/johngmyers) [#9105](https://github.com/kubernetes/kops/pull/9105)
* Minor doc fix. __address__ is not valid to use, will cuase etcd faili… [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#9160](https://github.com/kubernetes/kops/pull/9160)
* GCE: don't rely on hostname being correct [@justinsb](https://github.com/justinsb),[@rifelpet](https://github.com/rifelpet) [#9135](https://github.com/kubernetes/kops/pull/9135)
* Reduce test flakiness [@johngmyers](https://github.com/johngmyers) [#9164](https://github.com/kubernetes/kops/pull/9164)
* Add unit test case for pkg/apis/kops/util/versions_test.go [@Hellcatlk](https://github.com/Hellcatlk) [#9156](https://github.com/kubernetes/kops/pull/9156)
* Spotinst: New hybrid integration mode [@liranp](https://github.com/liranp) [#7252](https://github.com/kubernetes/kops/pull/7252)
* Fix nodetask.File dependency on owner [@johngmyers](https://github.com/johngmyers) [#9169](https://github.com/kubernetes/kops/pull/9169)
* Networking cleanup [@olemarkus](https://github.com/olemarkus) [#9157](https://github.com/kubernetes/kops/pull/9157)
* Update DigitalOcean cloud-controller-manager to v0.1.24 [@timoreimann](https://github.com/timoreimann) [#9179](https://github.com/kubernetes/kops/pull/9179)
* Update etcd-manager to 3.0.20200527 [@justinsb](https://github.com/justinsb) [#9184](https://github.com/kubernetes/kops/pull/9184)
* Use debian as default image for DO images [@srikiz](https://github.com/srikiz) [#9181](https://github.com/kubernetes/kops/pull/9181)
* Remove all versions of a file form the S3 bucket [@hakman](https://github.com/hakman) [#9171](https://github.com/kubernetes/kops/pull/9171)
* Remove unused VFSScan [@johngmyers](https://github.com/johngmyers) [#9174](https://github.com/kubernetes/kops/pull/9174)
* Remove loader support for nodeup tasks not used in models [@johngmyers](https://github.com/johngmyers) [#9170](https://github.com/kubernetes/kops/pull/9170)
* Document etcd-manager backups retention settings [@hakman](https://github.com/hakman) [#9187](https://github.com/kubernetes/kops/pull/9187)
* Add gjtempleton as reviewer [@johngmyers](https://github.com/johngmyers) [#9183](https://github.com/kubernetes/kops/pull/9183)
* Fix nits for removal of S3 file versions [@hakman](https://github.com/hakman) [#9188](https://github.com/kubernetes/kops/pull/9188)
* Remove support for CoreOS and Jessie [@johngmyers](https://github.com/johngmyers) [#9065](https://github.com/kubernetes/kops/pull/9065)
* Update Bazel rules for Docker to v0.14.2 [@hakman](https://github.com/hakman) [#9196](https://github.com/kubernetes/kops/pull/9196)
* Remove support for the legacy etcd provider as of k8s 1.18 [@johngmyers](https://github.com/johngmyers) [#8826](https://github.com/kubernetes/kops/pull/8826)
* Add deprecation notice for legacy etcd provider to 1.17 relnotes [@johngmyers](https://github.com/johngmyers) [#9201](https://github.com/kubernetes/kops/pull/9201)
* Add comment in OWNERS linking to test-infra OWNERS files [@rifelpet](https://github.com/rifelpet) [#9202](https://github.com/kubernetes/kops/pull/9202)
* Fix repo packages not being installed [@hakman](https://github.com/hakman) [#9203](https://github.com/kubernetes/kops/pull/9203)
* Allow listing versions for objects in the S3 bucket [@hakman](https://github.com/hakman) [#9205](https://github.com/kubernetes/kops/pull/9205)
* Try validating multiple times before updating instancegroup [@johngmyers](https://github.com/johngmyers) [#9165](https://github.com/kubernetes/kops/pull/9165)
* Use kubescheduler.config.k8s.io/v1beta1 for Kubernetes 1.19 [@hakman](https://github.com/hakman) [#9204](https://github.com/kubernetes/kops/pull/9204)
* Update adding_a_feature.md with more modern example [@johngmyers](https://github.com/johngmyers) [#9208](https://github.com/kubernetes/kops/pull/9208)
* Add example for delete secret [@q384566678](https://github.com/q384566678) [#9198](https://github.com/kubernetes/kops/pull/9198)
* Upgrade docker/containerd/containeros hashes to SHA256 [@johngmyers](https://github.com/johngmyers) [#9215](https://github.com/kubernetes/kops/pull/9215)
* Release notes for 1.16.3 [@justinsb](https://github.com/justinsb) [#9219](https://github.com/kubernetes/kops/pull/9219)
* Remove extraneous markdown files in pkg/apis [@rifelpet](https://github.com/rifelpet) [#9220](https://github.com/kubernetes/kops/pull/9220)
* Release notes for 1.17.0 [@justinsb](https://github.com/justinsb) [#9222](https://github.com/kubernetes/kops/pull/9222)
* Remove unused file [@johngmyers](https://github.com/johngmyers) [#9218](https://github.com/kubernetes/kops/pull/9218)
* Update set-version script to bump tag in Makefile [@justinsb](https://github.com/justinsb) [#9224](https://github.com/kubernetes/kops/pull/9224)
* Start release notes for kops 1.19 [@justinsb](https://github.com/justinsb) [#9223](https://github.com/kubernetes/kops/pull/9223)
* Use AWS SDK to fetch metadata [@justinsb](https://github.com/justinsb) [#9227](https://github.com/kubernetes/kops/pull/9227)
* S3 DeleteAllVersions: use pagination [@justinsb](https://github.com/justinsb) [#9228](https://github.com/kubernetes/kops/pull/9228)
* Bump compatibility matrix for kops 1.17 [@johngmyers](https://github.com/johngmyers) [#9225](https://github.com/kubernetes/kops/pull/9225)
* Validation: MixedInstancePolicy need not override instance types [@justinsb](https://github.com/justinsb) [#9231](https://github.com/kubernetes/kops/pull/9231)
* GCE: fix typo [@justinsb](https://github.com/justinsb) [#9232](https://github.com/kubernetes/kops/pull/9232)
* Add packages hashes verification for containerd and Docker [@hakman](https://github.com/hakman) [#9234](https://github.com/kubernetes/kops/pull/9234)
* Remove vsphere cloud provider [@olemarkus](https://github.com/olemarkus) [#9177](https://github.com/kubernetes/kops/pull/9177)
* Update etcd-manager to 3.0.20200531 [@hakman](https://github.com/hakman) [#9237](https://github.com/kubernetes/kops/pull/9237)
* Don't build site when docs are unchanged [@hakman](https://github.com/hakman) [#9235](https://github.com/kubernetes/kops/pull/9235)
* Updating stable channel with May updates [@MoShitrit](https://github.com/MoShitrit) [#9212](https://github.com/kubernetes/kops/pull/9212)
* Upgrde amazon vpc cni to 1.6.2 [@MoShitrit](https://github.com/MoShitrit) [#9214](https://github.com/kubernetes/kops/pull/9214)
* Disable static tokens by default as of Kubernetes 1.18 [@johngmyers](https://github.com/johngmyers) [#8850](https://github.com/kubernetes/kops/pull/8850)

## 1.18.0-beta.1 to 1.18.0-beta.2

* [Digital Ocean] Update RBAC for DO CCM [@srikiz](https://github.com/srikiz) [#9249](https://github.com/kubernetes/kops/pull/9249)
* Use Docker 19.03.11 for Kubernetes 1.18+ [@hakman](https://github.com/hakman) [#9258](https://github.com/kubernetes/kops/pull/9258)
* Use CNI 0.8.6 for Kubernetes 1.15+ [@hakman](https://github.com/hakman) [#9256](https://github.com/kubernetes/kops/pull/9256)
* Update Calico and Canal for CVE-2020-13597 [@hakman](https://github.com/hakman) [#9268](https://github.com/kubernetes/kops/pull/9268)
* Update Weave for CVE-2020-13597 [@hakman](https://github.com/hakman) [#9285](https://github.com/kubernetes/kops/pull/9285)
* Don't export basic auth credentials if basic auth is disabled [@johngmyers](https://github.com/johngmyers) [#9284](https://github.com/kubernetes/kops/pull/9284)
* Use Docker 19.03.11 for Kubernetes 1.17+ [@hakman](https://github.com/hakman) [#9317](https://github.com/kubernetes/kops/pull/9317)
* Fix mismatch in SecurityGroups handling with launch templates [@johngmyers](https://github.com/johngmyers) [#9288](https://github.com/kubernetes/kops/pull/9288)
* Remove all traces of utils.tar.gz [@hakman](https://github.com/hakman) [#9197](https://github.com/kubernetes/kops/pull/9197)
* Update Weave Net to 2.6.5 [@hakman](https://github.com/hakman) [#9330](https://github.com/kubernetes/kops/pull/9330)
* Bug: Explicitly set default StorageClass to support upgrades [@joshbranham](https://github.com/joshbranham) [#9337](https://github.com/kubernetes/kops/pull/9337)
* Bump cilium to 1.7.5 [@olemarkus](https://github.com/olemarkus) [#9367](https://github.com/kubernetes/kops/pull/9367)
* Move host-network services off of port 8080 [@johngmyers](https://github.com/johngmyers) [#9355](https://github.com/kubernetes/kops/pull/9355)
* Run "go mod vendor" in verify-gomod [@rifelpet](https://github.com/rifelpet) [#9389](https://github.com/kubernetes/kops/pull/9389)
* Remove go 1.14 CI jobs for k8s 1.18 [@hakman](https://github.com/hakman) [#9398](https://github.com/kubernetes/kops/pull/9398)
* Add support for c5a aws ec2 instance types [@coolstang](https://github.com/coolstang) [#9386](https://github.com/kubernetes/kops/pull/9386)
* Fix: dns-controller: 3999 port address already in use [@vgunapati](https://github.com/vgunapati) [#9404](https://github.com/kubernetes/kops/pull/9404)
* Fix cilium etcd migration [@olemarkus](https://github.com/olemarkus) [#9451](https://github.com/kubernetes/kops/pull/9451)
* Create separate field for disabling rolling updates [@johngmyers](https://github.com/johngmyers) [#9348](https://github.com/kubernetes/kops/pull/9348)
* Fix where etcd-cluster-spec is writen when etcd's BackupStore is defined -v2 [@rdrgmnzs](https://github.com/rdrgmnzs) [#9474](https://github.com/kubernetes/kops/pull/9474)
* Update Calico to v3.15.0 for k8s 1.16+ [@hakman](https://github.com/hakman) [#9444](https://github.com/kubernetes/kops/pull/9444)
* Update KubeDNS to v1.15.13 [@hakman](https://github.com/hakman) [#9462](https://github.com/kubernetes/kops/pull/9462)
* Update the service manifest for Docker [@hakman](https://github.com/hakman) [#9465](https://github.com/kubernetes/kops/pull/9465)
* When building to staging, split out the marker files by branch [@justinsb](https://github.com/justinsb) [#9272](https://github.com/kubernetes/kops/pull/9272)
* Fix verify-terraform in release-1.18 branch [@rifelpet](https://github.com/rifelpet) [#9504](https://github.com/kubernetes/kops/pull/9504)
* Use kubelet docker-specific flags only for Docker [@hakman](https://github.com/hakman) [#9495](https://github.com/kubernetes/kops/pull/9495)
* Default ClusterDNS appropriately when NodeLocalDNS is enabled [@johngmyers](https://github.com/johngmyers) [#9491](https://github.com/kubernetes/kops/pull/9491)
* Update kube-router to v1.0.0 [@hakman](https://github.com/hakman),[@johngmyers](https://github.com/johngmyers) [#9512](https://github.com/kubernetes/kops/pull/9512)
* Add missing lifecycle to etcd keypair tasks [@johngmyers](https://github.com/johngmyers) [#9553](https://github.com/kubernetes/kops/pull/9553)

## 1.18.0-beta.2 to 1.18.0

* Use stable names for GH workflow jobs [@hakman](https://github.com/hakman) [#9552](https://github.com/kubernetes/kops/pull/9552)
* Use fixed UID for etcd user and restrict to legacy provider [@johngmyers](https://github.com/johngmyers) [#9581](https://github.com/kubernetes/kops/pull/9581)
* Promote Ciprian & John to approvers [@hakman](https://github.com/hakman) [#9590](https://github.com/kubernetes/kops/pull/9590)
* Prefer nodes with "master" role for Calico Typha pods [@hakman](https://github.com/hakman) [#9609](https://github.com/kubernetes/kops/pull/9609)
* Docs helptext [@olemarkus](https://github.com/olemarkus) [#9333](https://github.com/kubernetes/kops/pull/9333)
* Add Ubuntu 20.04 support for Docker 18.06.3 [@hakman](https://github.com/hakman) [#9616](https://github.com/kubernetes/kops/pull/9616)
* Calico: Upgrade the "k8s-ec2-srcdst" controller to version v0.3.0 [@seh](https://github.com/seh),[@hakman](https://github.com/hakman) [#9647](https://github.com/kubernetes/kops/pull/9647)
* Update Calico to v3.15.1 for k8s 1.16+ [@hakman](https://github.com/hakman) [#9656](https://github.com/kubernetes/kops/pull/9656)
* Prefer nodes with "master" role for Canal Typha pods [@hakman](https://github.com/hakman) [#9663](https://github.com/kubernetes/kops/pull/9663)

## 1.18.0 to 1.18.1

* Improve locking in memfs [@johngmyers](https://github.com/johngmyers) [#9597](https://github.com/kubernetes/kops/pull/9597)
* Update aws-sdk-go to 1.30.29 [@johngmyers](https://github.com/johngmyers),[@hakman](https://github.com/hakman) [#9675](https://github.com/kubernetes/kops/pull/9675)
* When channel is unavailable, don't try to validate things from it [@olemarkus](https://github.com/olemarkus) [#9559](https://github.com/kubernetes/kops/pull/9559)
* Remove embedded structs from spotinst terraform types [@rifelpet](https://github.com/rifelpet) [#9682](https://github.com/kubernetes/kops/pull/9682)
* Upgrade k8s-dns-dnsmasq-nanny to match KubeDNS [@johngmyers](https://github.com/johngmyers) [#9687](https://github.com/kubernetes/kops/pull/9687)
* Update k8s dependencies to v1.18.6 [@hakman](https://github.com/hakman) [#9710](https://github.com/kubernetes/kops/pull/9710)
* Add flag to disable the checksum workaround for Flannel VXLAN [@hakman](https://github.com/hakman) [#9614](https://github.com/kubernetes/kops/pull/9614)
* Update Calico to v3.15.2 for k8s 1.16+ [@hakman](https://github.com/hakman) [#9816](https://github.com/kubernetes/kops/pull/9816)
* Support for using hostPort when using kube-router [@andsens](https://github.com/andsens),[@hakman](https://github.com/hakman) [#9689](https://github.com/kubernetes/kops/pull/9689)
* Backport #9803: Update validation for Calico to assume etcd3 as default [@hakman](https://github.com/hakman) [#9823](https://github.com/kubernetes/kops/pull/9823)
* Always use OpenStack Swift reauthentication [@justinsb](https://github.com/justinsb) [#9836](https://github.com/kubernetes/kops/pull/9836)
* Add kubelet cgroup driver property [@bmelbourne](https://github.com/bmelbourne),[@hakman](https://github.com/hakman) [#9879](https://github.com/kubernetes/kops/pull/9879)
* Add flag for root volume encryption [@hakman](https://github.com/hakman) [#9793](https://github.com/kubernetes/kops/pull/9793)
* Update Calico to v3.15.3 [@hakman](https://github.com/hakman) [#9895](https://github.com/kubernetes/kops/pull/9895)
