### **Node Authorization Service**

:warning: The node authorization service is deprecated.
As of Kubernetes 1.19 kops will, on AWS, ignore the `nodeAuthorization` field of the cluster spec and
worker nodes will obtain client certificates for kubelet and other purposes through kops-controller.

The [node authorization service] is an experimental service which in the absence of a kops-apiserver provides the distribution of tokens to the worker nodes. Bootstrap tokens provide worker nodes a short-time credential to request access kubeconfig certificate. A gist of the flow is;

- a secret of type `bootstrap.kubernetes.io/token` is created on behalf of a node in the kube-system namespace.
- the token is distributed to the node by _some_ means and then used as the bearer token of the initial request to the kubernetes api.
- the token itself is bound to the cluster role which grants permission to generate a CSR, an additional cluster role provides access for the controller to auto-approve this CSR requests as well.
- two certificates are generated by the kubelet using bootstrap process, one for the kubelet api and the other a client certificate to the kubelet itself.
- the client certificate by default is added into the system:nodes rbac group _(note, if you are using PSP this is automatically bound by kops on your behalf)_.
- the kubelet at this point has a server certificate and the client api certificate and good to go.

#### **Integration with Kops**

The node authorization service is run on the master as a daemonset, by default dns is _node-authorizer-internal.dns_zone_:10443 and added via same mechanism at the internal kube-apiserver i.e. annotations on the kube-apiserver pods which is picked up the dns-controller and added to the dns zone.

When the node authorization service is enabled a systemd _(node-authorizer.service)_ unit is added on the worker nodes. This runs the node-authorizer in client mode and connects to the authorization service requesting a bootstrap token.

#### **Authorizers**

The node authorizer currently supports two authorizers; aws and alwaysallow. The latter is self-explanatory, as for the aws authorizer, in order for a request to be authorized the following checks are performed.

- the worker node retrieves the [pkcs7 signed instance document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-identity-documents.html) from the metadata service; this is unique for each instance and available only to them.
- the client connects using a client certificate which is first checked and passes the instance document to the authorization service.
- the signed instance document is validated against the public certificates from AWS.
- we check the node exists and is running.
- we check the node is running in our region.
- we check the node is running in our vpc.
- we check the node is tagged with the correct kubernetes tag.
- we check the ip address of the client requesting the document is the same the instance document.
- we check that the node has not already registered.

Assuming all the conditions are met a secret token is generated and returned to the client to continue the providing of the worker node.

#### **Enabling the Node Authorization Service**

Enabling the node authorization service is as follows; firstly you must enable the feature flag as node authorization is still experimental; export KOPS_FEATURE_FLAGS=EnableNodeAuthorization

```yaml
# in the cluster spec
nodeAuthorization:
  # enable the service under the node authorization section, please review the settings in the components.go
  nodeAuthorizer: {}
```

Note, by default this will also switch on the [Node authorization](https://kubernetes.io/docs/reference/access-authn-authz/node/) and RBAC mode. We would also suggest turning on the NodeRestriction admission controller.
