package views

import (
	"testing"

	"github.com/derailed/k9s/internal/config"
	"github.com/stretchr/testify/assert"
)

func TestCommandPush(t *testing.T) {
	c := newCommand(NewApp(config.NewConfig(ks{})))
	c.pushCmd("fred")
	c.pushCmd("blee")
	p, top := c.previousCmd()

	assert.Equal(t, "fred", p)
	assert.True(t, top)
	assert.True(t, c.lastCmd())
}
