// Copyright 2020-2023 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by goyacc -o proto.y.go -l -p proto proto.y. DO NOT EDIT.
package parser

import __yyfmt__ "fmt"

//lint:file-ignore SA4006 generated parser has unused values

import (
	"math"
	"strings"

	"github.com/bufbuild/protocompile/ast"
)

type protoSymType struct {
	yys          int
	file         *ast.FileNode
	syn          *ast.SyntaxNode
	ed           *ast.EditionNode
	fileElements []ast.FileElement
	pkg          nodeWithRunes[*ast.PackageNode]
	imprt        nodeWithRunes[*ast.ImportNode]
	msg          nodeWithRunes[*ast.MessageNode]
	msgElements  []ast.MessageElement
	fld          *ast.FieldNode
	msgFld       nodeWithRunes[*ast.FieldNode]
	mapFld       nodeWithRunes[*ast.MapFieldNode]
	mapType      *ast.MapTypeNode
	grp          *ast.GroupNode
	msgGrp       nodeWithRunes[*ast.GroupNode]
	oo           nodeWithRunes[*ast.OneofNode]
	ooElement    ast.OneofElement
	ooElements   []ast.OneofElement
	ext          nodeWithRunes[*ast.ExtensionRangeNode]
	resvd        nodeWithRunes[*ast.ReservedNode]
	en           nodeWithRunes[*ast.EnumNode]
	enElements   []ast.EnumElement
	env          nodeWithRunes[*ast.EnumValueNode]
	extend       nodeWithRunes[*ast.ExtendNode]
	extElement   ast.ExtendElement
	extElements  []ast.ExtendElement
	svc          nodeWithRunes[*ast.ServiceNode]
	svcElements  []ast.ServiceElement
	mtd          nodeWithRunes[*ast.RPCNode]
	mtdMsgType   *ast.RPCTypeNode
	mtdElements  []ast.RPCElement
	optRaw       *ast.OptionNode
	opt          nodeWithRunes[*ast.OptionNode]
	opts         *compactOptionSlices
	refRaw       *ast.FieldReferenceNode
	ref          nodeWithRunes[*ast.FieldReferenceNode]
	optNms       *fieldRefSlices
	cmpctOpts    *ast.CompactOptionsNode
	rng          *ast.RangeNode
	rngs         *rangeSlices
	names        *nameSlices
	cidPart      nodeWithRunes[*ast.IdentNode]
	cid          *identSlices
	tid          ast.IdentValueNode
	sl           *valueSlices
	msgLitFlds   *messageFieldList
	msgLitFld    *ast.MessageFieldNode
	v            ast.ValueNode
	il           ast.IntValueNode
	str          []*ast.StringLiteralNode
	s            *ast.StringLiteralNode
	i            *ast.UintLiteralNode
	f            *ast.FloatLiteralNode
	id           *ast.IdentNode
	b            *ast.RuneNode
	bs           []*ast.RuneNode
	err          error
}

const _STRING_LIT = 57346
const _INT_LIT = 57347
const _FLOAT_LIT = 57348
const _NAME = 57349
const _SYNTAX = 57350
const _EDITION = 57351
const _IMPORT = 57352
const _WEAK = 57353
const _PUBLIC = 57354
const _PACKAGE = 57355
const _OPTION = 57356
const _TRUE = 57357
const _FALSE = 57358
const _INF = 57359
const _NAN = 57360
const _REPEATED = 57361
const _OPTIONAL = 57362
const _REQUIRED = 57363
const _DOUBLE = 57364
const _FLOAT = 57365
const _INT32 = 57366
const _INT64 = 57367
const _UINT32 = 57368
const _UINT64 = 57369
const _SINT32 = 57370
const _SINT64 = 57371
const _FIXED32 = 57372
const _FIXED64 = 57373
const _SFIXED32 = 57374
const _SFIXED64 = 57375
const _BOOL = 57376
const _STRING = 57377
const _BYTES = 57378
const _GROUP = 57379
const _ONEOF = 57380
const _MAP = 57381
const _EXTENSIONS = 57382
const _TO = 57383
const _MAX = 57384
const _RESERVED = 57385
const _ENUM = 57386
const _MESSAGE = 57387
const _EXTEND = 57388
const _SERVICE = 57389
const _RPC = 57390
const _STREAM = 57391
const _RETURNS = 57392
const _ERROR = 57393

var protoToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"_STRING_LIT",
	"_INT_LIT",
	"_FLOAT_LIT",
	"_NAME",
	"_SYNTAX",
	"_EDITION",
	"_IMPORT",
	"_WEAK",
	"_PUBLIC",
	"_PACKAGE",
	"_OPTION",
	"_TRUE",
	"_FALSE",
	"_INF",
	"_NAN",
	"_REPEATED",
	"_OPTIONAL",
	"_REQUIRED",
	"_DOUBLE",
	"_FLOAT",
	"_INT32",
	"_INT64",
	"_UINT32",
	"_UINT64",
	"_SINT32",
	"_SINT64",
	"_FIXED32",
	"_FIXED64",
	"_SFIXED32",
	"_SFIXED64",
	"_BOOL",
	"_STRING",
	"_BYTES",
	"_GROUP",
	"_ONEOF",
	"_MAP",
	"_EXTENSIONS",
	"_TO",
	"_MAX",
	"_RESERVED",
	"_ENUM",
	"_MESSAGE",
	"_EXTEND",
	"_SERVICE",
	"_RPC",
	"_STREAM",
	"_RETURNS",
	"_ERROR",
	"'='",
	"';'",
	"':'",
	"'{'",
	"'}'",
	"'\\\\'",
	"'/'",
	"'?'",
	"'.'",
	"','",
	"'>'",
	"'<'",
	"'+'",
	"'-'",
	"'('",
	"')'",
	"'['",
	"']'",
	"'*'",
	"'&'",
	"'^'",
	"'%'",
	"'$'",
	"'#'",
	"'@'",
	"'!'",
	"'~'",
	"'`'",
}

var protoStatenames = [...]string{}

const protoEofCode = 1
const protoErrCode = 2
const protoInitialStackSize = 16

var protoExca = [...]int16{
	-1, 0,
	1, 6,
	-2, 21,
	-1, 1,
	1, -1,
	-2, 0,
	-1, 2,
	1, 1,
	-2, 21,
	-1, 3,
	1, 2,
	-2, 21,
	-1, 14,
	1, 7,
	-2, 0,
	-1, 89,
	52, 60,
	61, 60,
	69, 60,
	-2, 61,
	-1, 101,
	55, 37,
	58, 37,
	62, 37,
	67, 37,
	69, 37,
	-2, 34,
	-1, 112,
	52, 60,
	61, 60,
	69, 60,
	-2, 62,
	-1, 118,
	56, 237,
	-2, 0,
	-1, 121,
	55, 37,
	58, 37,
	62, 37,
	67, 37,
	69, 37,
	-2, 35,
	-1, 140,
	56, 217,
	-2, 0,
	-1, 142,
	56, 206,
	-2, 0,
	-1, 144,
	56, 238,
	-2, 0,
	-1, 198,
	56, 250,
	-2, 0,
	-1, 203,
	56, 83,
	62, 83,
	-2, 0,
	-1, 214,
	56, 218,
	-2, 0,
	-1, 271,
	56, 207,
	-2, 0,
	-1, 377,
	56, 251,
	-2, 0,
	-1, 462,
	56, 153,
	-2, 0,
	-1, 517,
	69, 144,
	-2, 141,
	-1, 522,
	56, 154,
	-2, 0,
	-1, 597,
	67, 52,
	-2, 49,
	-1, 652,
	69, 144,
	-2, 142,
	-1, 677,
	67, 52,
	-2, 50,
	-1, 708,
	56, 261,
	-2, 0,
	-1, 718,
	56, 262,
	-2, 0,
}

const protoPrivate = 57344

const protoLast = 1948

var protoAct = [...]int16{
	140, 7, 139, 7, 7, 586, 18, 719, 437, 436,
	498, 440, 127, 394, 439, 96, 458, 594, 597, 100,
	492, 95, 39, 523, 518, 514, 517, 32, 34, 422,
	421, 405, 200, 435, 233, 378, 272, 106, 326, 36,
	109, 404, 21, 145, 20, 40, 90, 93, 94, 19,
	102, 85, 107, 108, 149, 215, 202, 98, 101, 650,
	33, 137, 135, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
	78, 79, 80, 81, 82, 83, 84, 90, 124, 125,
	86, 134, 89, 119, 115, 449, 645, 643, 142, 395,
	504, 441, 453, 131, 198, 129, 130, 642, 199, 503,
	126, 133, 390, 134, 452, 641, 457, 502, 588, 714,
	9, 395, 698, 680, 459, 451, 396, 222, 667, 273,
	423, 460, 460, 460, 207, 460, 460, 120, 121, 674,
	493, 460, 138, 134, 416, 423, 692, 501, 134, 110,
	373, 395, 388, 389, 678, 40, 395, 279, 375, 653,
	387, 485, 448, 219, 9, 217, 9, 583, 323, 484,
	218, 464, 468, 386, 466, 227, 577, 9, 113, 459,
	112, 385, 661, 428, 110, 379, 414, 374, 122, 114,
	424, 732, 730, 723, 399, 392, 104, 717, 716, 709,
	705, 222, 655, 207, 397, 424, 9, 383, 697, 486,
	376, 322, 270, 213, 726, 700, 694, 462, 123, 118,
	117, 116, 5, 6, 9, 104, 104, 412, 403, 588,
	407, 408, 413, 657, 324, 40, 31, 219, 415, 217,
	384, 689, 688, 687, 218, 9, 402, 654, 23, 227,
	400, 417, 507, 506, 409, 489, 24, 488, 273, 25,
	26, 463, 456, 430, 419, 111, 461, 9, 13, 12,
	589, 381, 15, 412, 105, 103, 704, 721, 413, 519,
	8, 703, 647, 26, 210, 209, 279, 35, 418, 26,
	28, 27, 29, 30, 33, 104, 211, 212, 646, 585,
	584, 37, 38, 425, 471, 472, 473, 474, 475, 476,
	477, 478, 479, 480, 481, 482, 520, 382, 573, 406,
	508, 491, 487, 33, 707, 426, 427, 718, 40, 4,
	380, 429, 10, 11, 197, 377, 22, 143, 144, 274,
	141, 271, 220, 420, 275, 225, 411, 410, 521, 522,
	214, 231, 224, 221, 526, 147, 223, 432, 146, 525,
	216, 204, 203, 447, 379, 495, 591, 529, 150, 228,
	595, 99, 592, 327, 431, 531, 154, 234, 277, 596,
	329, 533, 434, 156, 237, 450, 470, 391, 393, 442,
	442, 465, 467, 433, 438, 207, 132, 128, 87, 88,
	206, 454, 455, 91, 444, 515, 512, 524, 445, 516,
	17, 16, 14, 3, 469, 2, 1, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 490, 483,
	0, 0, 500, 499, 0, 0, 0, 0, 509, 510,
	0, 494, 0, 442, 0, 574, 0, 0, 505, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	90, 575, 0, 0, 578, 0, 581, 0, 576, 0,
	0, 511, 0, 0, 0, 0, 0, 0, 0, 0,
	579, 0, 0, 0, 0, 0, 0, 0, 587, 648,
	0, 0, 644, 0, 0, 580, 582, 0, 0, 0,
	0, 0, 0, 0, 0, 649, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 90, 0, 0, 0, 0,
	0, 651, 652, 0, 0, 0, 656, 0, 90, 659,
	660, 0, 40, 658, 0, 662, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 663, 0, 0, 0, 0, 0,
	666, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	664, 669, 0, 671, 0, 0, 0, 0, 0, 665,
	0, 668, 670, 0, 0, 0, 0, 0, 0, 675,
	672, 0, 673, 676, 677, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 682, 0,
	684, 500, 499, 679, 0, 0, 686, 0, 0, 0,
	0, 0, 442, 681, 683, 691, 131, 685, 129, 130,
	693, 0, 0, 696, 133, 0, 695, 0, 0, 0,
	0, 690, 0, 699, 701, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 706, 708, 131,
	702, 129, 130, 710, 0, 0, 0, 133, 711, 712,
	722, 0, 0, 0, 0, 720, 0, 725, 727, 724,
	713, 715, 0, 0, 729, 720, 728, 0, 497, 731,
	33, 137, 135, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
	78, 79, 80, 81, 82, 83, 84, 0, 0, 0,
	0, 134, 0, 0, 0, 0, 0, 0, 0, 395,
	0, 441, 0, 0, 0, 496, 33, 137, 135, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 0, 0, 0, 0, 134, 0, 0,
	0, 0, 0, 0, 0, 395, 0, 441, 0, 0,
	443, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 205,
	92, 0, 0, 513, 41, 42, 43, 44, 45, 46,
	47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 80, 81, 82, 83, 84, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 446,
	0, 205, 0, 0, 0, 208, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
	75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
	0, 0, 0, 0, 0, 201, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 208, 33, 137,
	135, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 0, 0, 0, 0, 134,
	0, 0, 0, 0, 0, 205, 0, 0, 0, 136,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 83, 84, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 33,
	423, 208, 41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	424, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	92, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 97, 598, 599, 600, 601, 602,
	603, 604, 605, 606, 607, 608, 609, 610, 611, 612,
	613, 614, 615, 616, 617, 618, 619, 620, 621, 622,
	623, 624, 625, 626, 627, 628, 629, 630, 631, 632,
	633, 634, 635, 636, 637, 638, 639, 590, 640, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 593, 330,
	331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
	341, 342, 343, 344, 345, 346, 347, 348, 349, 350,
	351, 352, 353, 354, 355, 356, 357, 358, 359, 401,
	360, 361, 362, 363, 364, 365, 366, 367, 368, 369,
	370, 371, 372, 0, 0, 0, 0, 0, 226, 0,
	0, 0, 328, 238, 239, 240, 241, 242, 243, 244,
	26, 245, 246, 247, 248, 153, 152, 151, 249, 250,
	251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
	261, 262, 263, 0, 230, 236, 229, 264, 265, 232,
	28, 27, 29, 266, 267, 268, 269, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 235, 330, 331, 332,
	333, 334, 335, 336, 337, 338, 339, 340, 341, 342,
	343, 344, 345, 346, 347, 348, 349, 350, 351, 352,
	353, 354, 355, 356, 357, 358, 359, 325, 360, 361,
	362, 363, 364, 365, 366, 367, 368, 369, 370, 371,
	372, 0, 0, 0, 0, 0, 148, 0, 0, 0,
	328, 157, 158, 159, 160, 161, 162, 163, 164, 165,
	166, 167, 168, 153, 152, 151, 169, 170, 171, 172,
	173, 174, 175, 176, 177, 178, 179, 180, 181, 182,
	183, 0, 184, 185, 186, 187, 188, 189, 190, 191,
	192, 193, 194, 195, 196, 0, 0, 0, 0, 0,
	527, 0, 0, 0, 155, 534, 535, 536, 537, 538,
	539, 540, 528, 541, 542, 543, 544, 0, 0, 0,
	545, 546, 547, 548, 549, 550, 551, 552, 553, 554,
	555, 556, 557, 558, 559, 530, 560, 561, 562, 563,
	564, 565, 566, 567, 568, 569, 570, 571, 572, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 532, 210,
	209, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 33, 406, 0, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
	83, 84, 276, 0, 0, 0, 0, 280, 281, 282,
	283, 284, 285, 286, 26, 287, 288, 289, 290, 291,
	292, 293, 294, 295, 296, 297, 298, 299, 300, 301,
	302, 303, 304, 305, 306, 307, 308, 309, 310, 311,
	312, 313, 314, 278, 315, 316, 317, 318, 319, 320,
	321, 398, 0, 0, 0, 0, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
	75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
	41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 83, 84, 598, 599, 600, 601, 602, 603,
	604, 605, 606, 607, 608, 609, 610, 611, 612, 613,
	614, 615, 616, 617, 618, 619, 620, 621, 622, 623,
	624, 625, 626, 627, 628, 629, 630, 631, 632, 633,
	634, 635, 636, 637, 638, 639, 0, 640,
}

var protoPact = [...]int16{
	234, -1000, 191, 191, -1000, 237, 236, 266, 203, -1000,
	-1000, -1000, 339, 339, 266, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 310, 1853, 1224, 1853, 1853, 1284,
	1853, -1000, 242, -1000, 241, -1000, 212, 339, 339, 144,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 233, -1000, 1224, 149, -1000,
	-1000, -1000, 1284, 186, 185, 184, -1000, 1853, -1000, 1853,
	148, -1000, 183, -1000, -1000, -1000, -1000, 212, 212, -1000,
	1853, 1044, -1000, -1000, -1000, 95, 191, 191, 1554, -1000,
	-1000, -1000, -1000, 191, -1000, -1000, -1000, 191, -1000, -1000,
	311, -1000, -1000, -1000, 979, -1000, 299, -1000, -1000, 177,
	1446, 176, 1760, 175, 1554, -1000, -1000, -1000, 201, 1500,
	1853, -1000, -1000, -1000, 147, 1853, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 174, 289, -1000,
	171, -1000, -1000, 1103, 140, 119, 78, -1000, 1809, -1000,
	-1000, -1000, -1000, 191, 1446, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 1392, 1853, 334,
	1853, 1853, 1711, -1000, 146, 1853, 101, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	191, 1760, -1000, -1000, -1000, -1000, -1000, 232, 1165, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 191, -1000, -1000, 1853, 1853, 143, 1853, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 231, 1853, 109, 191, 289, -1000, -1000,
	-1000, -1000, 1853, -1000, -1000, -1000, -1000, -1000, -1000, 792,
	792, -1000, -1000, -1000, -1000, 917, 113, 76, 53, -1000,
	-1000, 1853, 1853, 230, 83, -1000, 245, 182, 229, 138,
	133, 131, 311, -1000, 1853, 109, 300, -1000, -1000, 160,
	128, -1000, 188, -1000, 337, -1000, 225, 223, 1853, 109,
	336, -1000, -1000, -1000, 94, -1000, -1000, -1000, -1000, 311,
	-1000, 1664, -1000, 726, -1000, 105, -1000, 68, -1000, 51,
	-1000, -1000, 1853, -1000, 221, 220, 335, 191, 191, 334,
	854, 294, 1608, 333, 191, -1000, 339, -1000, 1853, -1000,
	135, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 87, 160, 191, 145, -1000, 315, 314,
	-1000, 85, 240, 1338, -1000, 66, -1000, 48, -1000, -1000,
	-1000, -1000, -1000, 108, -1000, 47, 313, 297, 87, -1000,
	-1000, -1000, -10, -1000, -1000, 1224, 118, -1000, 215, -1000,
	-1000, 166, 1608, -1000, -1000, -1000, -1000, 200, 1224, 1853,
	1853, 142, 1853, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 87, -1000, 311, -1000, 1284, -1000, 191,
	-1000, -1000, -1000, -1000, 93, 85, -1000, 196, -1000, 94,
	1284, 92, -1000, 1853, -1000, 1897, 114, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 56, -1000, -1000, -1000, 88, 87, -1000, 191,
	-1000, -1000, -1000, -1000, 1044, 191, -1000, -1000, 211, 210,
	209, 1853, 109, -1000, 191, 104, -1000, 191, 181, -1000,
	196, -1000, 173, 75, -1000, -1000, -1000, -1000, -1000, -1000,
	191, 180, -1000, 191, -1000, -1000, -1000, 1044, 296, 291,
	-1000, -1000, -1000, 164, 191, -1000, -1000, 191, -1000, 163,
	191, -1000, 196, 85, 84, -1000, 162, 161, 295, 191,
	157, -1000, -1000, 196, 191, 179, -1000, 191, 295, -1000,
	-1000, -1000, -1000, 191, -1000, 156, 191, -1000, -1000, -1000,
	-1000, 155, -1000,
}

var protoPgo = [...]int16{
	0, 436, 435, 433, 349, 292, 432, 431, 430, 429,
	427, 6, 26, 25, 426, 425, 423, 420, 419, 112,
	110, 24, 418, 16, 33, 12, 417, 9, 13, 8,
	11, 416, 414, 10, 408, 407, 29, 19, 406, 404,
	403, 401, 400, 399, 398, 54, 58, 57, 18, 17,
	22, 397, 396, 395, 393, 392, 15, 391, 390, 21,
	389, 388, 387, 38, 386, 385, 383, 382, 56, 32,
	381, 380, 379, 378, 376, 375, 374, 373, 372, 371,
	49, 55, 370, 2, 23, 369, 368, 367, 366, 365,
	364, 34, 31, 30, 41, 363, 362, 44, 36, 361,
	360, 359, 42, 43, 358, 357, 14, 356, 35, 355,
	354, 350, 7, 347, 344, 20, 5, 0, 300,
}

var protoR1 = [...]int8{
	0, 1, 1, 1, 1, 1, 1, 4, 6, 6,
	5, 5, 5, 5, 5, 5, 5, 5, 118, 118,
	117, 117, 116, 116, 2, 3, 7, 7, 7, 8,
	50, 50, 56, 56, 57, 57, 47, 47, 46, 51,
	51, 52, 52, 53, 53, 54, 54, 55, 55, 58,
	58, 49, 49, 48, 10, 11, 18, 18, 19, 20,
	20, 22, 22, 21, 21, 16, 25, 25, 26, 26,
	26, 26, 30, 30, 30, 30, 31, 31, 106, 106,
	28, 28, 69, 68, 68, 67, 67, 67, 67, 67,
	67, 70, 70, 70, 17, 17, 17, 17, 24, 24,
	24, 27, 27, 27, 27, 35, 35, 29, 29, 29,
	32, 32, 32, 65, 65, 33, 33, 34, 34, 34,
	66, 66, 59, 59, 60, 60, 61, 61, 62, 62,
	63, 63, 64, 64, 45, 45, 45, 23, 23, 14,
	14, 15, 15, 13, 13, 12, 9, 9, 75, 75,
	77, 77, 74, 86, 86, 85, 85, 84, 84, 84,
	84, 84, 72, 72, 76, 76, 78, 78, 79, 38,
	38, 38, 38, 38, 38, 38, 38, 38, 38, 38,
	38, 96, 96, 94, 94, 92, 92, 92, 95, 95,
	93, 93, 93, 36, 36, 89, 89, 90, 90, 91,
	91, 87, 87, 88, 88, 97, 100, 100, 99, 99,
	98, 98, 98, 98, 101, 101, 80, 83, 83, 82,
	82, 81, 81, 81, 81, 81, 81, 81, 81, 81,
	81, 81, 71, 71, 71, 71, 102, 105, 105, 104,
	104, 103, 103, 103, 103, 73, 73, 73, 73, 107,
	110, 110, 109, 109, 108, 108, 108, 111, 111, 115,
	115, 114, 114, 113, 113, 112, 112, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
	39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 44, 41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
	41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
	41, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
	42, 42, 42, 42, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43,
	43, 43, 43, 43, 43, 43, 43, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
	37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
	37,
}

var protoR2 = [...]int8{
	0, 1, 1, 1, 2, 2, 0, 2, 2, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
	1, 0, 1, 0, 4, 4, 3, 4, 4, 3,
	1, 3, 1, 2, 1, 2, 1, 1, 2, 1,
	3, 1, 3, 1, 3, 1, 3, 1, 2, 1,
	2, 1, 1, 2, 5, 5, 1, 1, 2, 1,
	1, 1, 2, 1, 2, 3, 1, 1, 1, 1,
	1, 1, 1, 2, 1, 2, 2, 2, 1, 2,
	3, 2, 1, 1, 2, 1, 2, 2, 2, 2,
	1, 3, 2, 3, 1, 3, 5, 3, 1, 1,
	1, 1, 1, 2, 1, 1, 1, 1, 3, 2,
	3, 2, 3, 1, 3, 1, 1, 3, 2, 3,
	1, 3, 1, 2, 1, 2, 1, 2, 1, 2,
	1, 2, 1, 2, 1, 1, 1, 3, 2, 1,
	2, 1, 2, 1, 1, 2, 3, 1, 8, 9,
	9, 10, 6, 0, 1, 2, 1, 1, 1, 1,
	2, 1, 5, 6, 7, 8, 5, 6, 6, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 4, 4, 1, 3, 1, 3, 3, 1, 3,
	1, 3, 3, 1, 2, 4, 1, 4, 1, 3,
	3, 1, 3, 1, 3, 6, 1, 2, 2, 1,
	1, 1, 1, 1, 4, 5, 6, 1, 2, 2,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 6, 7, 5, 6, 6, 0, 1, 2,
	1, 1, 1, 2, 1, 6, 7, 5, 6, 6,
	1, 2, 2, 1, 1, 1, 1, 6, 9, 4,
	3, 1, 2, 2, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1,
}

var protoChk = [...]int16{
	-1000, -1, -2, -3, -4, 8, 9, -117, -118, 53,
	-4, -4, 52, 52, -6, -5, -7, -8, -11, -80,
	-97, -102, -107, 2, 10, 13, 14, 45, 44, 46,
	47, 53, -106, 4, -106, -5, -106, 11, 12, -50,
	-37, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
	36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
	46, 47, 48, 49, 50, -21, -20, -22, -18, -19,
	-37, -16, 66, -37, -37, -59, -56, 60, -47, -57,
	-37, -46, -37, 53, 4, 53, -117, -106, -106, -117,
	60, 52, -19, -20, 60, -59, 55, 55, 55, -56,
	-47, -46, 60, 55, -117, -117, -37, -25, -26, -28,
	-106, -30, -31, -37, 55, 6, 65, 5, 67, -83,
	-117, -100, -117, -105, -104, -103, -73, -75, 2, -45,
	-61, 21, 20, 19, -52, 60, -40, 7, 8, 9,
	10, 11, 12, 13, 14, 15, 16, 17, 18, 22,
	23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
	33, 34, 35, 36, 38, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, -110, -117, -117,
	-69, 56, -68, -67, -70, 2, -17, -37, 68, 6,
	5, 17, 18, 56, -82, -81, -71, -97, -80, -102,
	-96, -77, -11, -74, -78, -89, 2, -45, -60, 40,
	38, -79, 43, -91, -51, 60, 39, -39, 7, 8,
	9, 10, 11, 12, 13, 15, 16, 17, 18, 22,
	23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
	33, 34, 35, 36, 41, 42, 47, 48, 49, 50,
	56, -99, -98, -11, -101, -90, 2, -44, 43, -91,
	7, 8, 9, 10, 11, 12, 13, 15, 16, 17,
	18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
	38, 39, 40, 41, 42, 44, 45, 46, 47, 48,
	49, 50, 56, -103, 53, 37, -63, -54, 60, -42,
	7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
	27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, -37, 60, -50, 56, -109, -108, -11,
	-111, 2, 48, 56, -68, 61, 53, 61, 53, 54,
	54, -35, -29, -34, -28, 63, 68, -56, 2, -117,
	-81, 37, -63, -37, -94, -92, 5, -37, -37, -94,
	-87, -88, -106, -37, 60, -50, 63, -117, -98, 52,
	-95, -93, -36, 5, 65, -117, -37, -37, 60, -50,
	52, -37, -117, -108, -37, -24, -27, -29, -32, -106,
	-30, 65, -37, 68, -24, -69, 62, -66, 69, 2,
	-29, 69, 58, 69, -37, -37, 52, 53, -23, 61,
	68, 41, 55, 52, 53, -117, 61, -117, 61, -37,
	-38, 24, 25, 26, 27, 28, 29, 30, 31, 32,
	33, 34, 35, -36, 61, 53, 41, 5, 52, 52,
	-37, 5, -115, 66, -37, -65, 69, 2, -33, -27,
	-29, 62, 69, 61, 69, -56, 52, 52, 5, -117,
	-117, -92, -14, 69, -13, -15, -9, -12, -21, 5,
	42, -86, -85, -84, -10, -72, -76, 2, 14, -62,
	37, -53, 60, -41, 7, 8, 9, 10, 11, 12,
	13, 15, 16, 17, 18, 22, 23, 24, 25, 26,
	27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
	38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 5, -117, -106, -37, 61, -117, -23,
	-93, -117, -36, 42, 5, 5, -116, -23, 53, 50,
	49, -64, -55, 60, -49, -58, -43, -48, 7, 8,
	9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
	19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
	39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
	50, 69, 61, 69, -29, 69, 5, 5, -117, -23,
	69, -13, -12, 61, 52, 56, -84, 53, -21, -37,
	-37, 60, -50, -117, -23, -59, -117, 55, -23, -116,
	-23, -116, -115, -59, 67, -56, -49, -48, 60, -33,
	55, -23, -117, -23, -117, -25, -117, 52, 52, 52,
	-37, -117, 62, -83, 55, -116, -117, 55, 67, -83,
	55, -117, -25, 5, 5, 56, -83, -114, -117, 56,
	-83, -116, -116, -23, 55, -23, 56, 56, -113, -112,
	-11, 2, -117, 56, -116, -83, 55, -117, -112, -117,
	56, -83, 56,
}

var protoDef = [...]int16{
	-2, -2, -2, -2, 3, 0, 0, 0, 20, 18,
	4, 5, 0, 0, -2, 9, 10, 11, 12, 13,
	14, 15, 16, 17, 0, 0, 0, 0, 0, 0,
	0, 19, 0, 78, 0, 8, 21, 0, 0, 21,
	30, 507, 508, 509, 510, 511, 512, 513, 514, 515,
	516, 517, 518, 519, 520, 521, 522, 523, 524, 525,
	526, 527, 528, 529, 530, 531, 532, 533, 534, 535,
	536, 537, 538, 539, 540, 541, 542, 543, 544, 545,
	546, 547, 548, 549, 550, 0, 63, 0, 59, -2,
	56, 57, 0, 0, 0, 0, 122, 0, 32, 0,
	36, -2, 0, 24, 79, 25, 26, 21, 21, 29,
	0, 0, -2, 64, 58, 0, 21, 21, -2, 123,
	33, -2, 38, 21, 27, 28, 31, 21, 66, 67,
	68, 69, 70, 71, 0, 72, 0, 74, 65, 0,
	-2, 0, -2, 0, -2, 240, 241, 242, 244, 0,
	0, 134, 135, 136, 126, 0, 41, 300, 301, 302,
	303, 304, 305, 306, 307, 308, 309, 310, 311, 312,
	313, 314, 315, 316, 317, 318, 319, 320, 321, 322,
	323, 324, 325, 326, 327, 328, 329, 330, 331, 332,
	333, 334, 335, 336, 337, 338, 339, 0, -2, 55,
	0, 81, 82, -2, 85, 90, 0, 94, 0, 73,
	75, 76, 77, 21, -2, 220, 221, 222, 223, 224,
	225, 226, 227, 228, 229, 230, 231, 0, 0, 0,
	0, 0, 0, 196, 124, 0, 293, 39, 267, 268,
	269, 270, 271, 272, 273, 274, 275, 276, 277, 278,
	279, 280, 281, 282, 283, 284, 285, 286, 287, 288,
	289, 290, 291, 292, 294, 295, 296, 297, 298, 299,
	21, -2, 209, 210, 211, 212, 213, 0, 0, 198,
	340, 341, 342, 343, 344, 345, 346, 347, 348, 349,
	350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
	360, 361, 362, 363, 364, 365, 366, 367, 368, 369,
	370, 371, 372, 373, 374, 375, 376, 377, 378, 379,
	380, 381, 21, 239, 243, 0, 0, 130, 0, 45,
	421, 422, 423, 424, 425, 426, 427, 428, 429, 430,
	431, 432, 433, 434, 435, 436, 437, 438, 439, 440,
	441, 442, 443, 444, 445, 446, 447, 448, 449, 450,
	451, 452, 453, 454, 455, 456, 457, 458, 459, 460,
	461, 462, 463, 0, 0, 127, 21, -2, 253, 254,
	255, 256, 0, 80, 84, 86, 87, 88, 89, 0,
	0, 92, 105, 106, 107, 0, 0, 0, 0, 216,
	219, 0, 0, 0, 0, 183, 185, 0, 0, 0,
	21, 21, 201, 203, 0, 125, 0, 205, 208, 0,
	0, 188, 190, 193, 0, 236, 0, 0, 0, 131,
	0, 42, 249, 252, 0, 93, 98, 99, 100, 101,
	102, 0, 104, 0, 91, 0, 109, 0, 118, 0,
	120, 95, 0, 97, 0, 0, 0, 21, 21, 0,
	0, 0, -2, 0, 21, 199, 0, 200, 0, 40,
	0, 169, 170, 171, 172, 173, 174, 175, 176, 177,
	178, 179, 180, 21, 0, 21, 0, 194, 0, 0,
	46, 23, 0, 0, 103, 0, 111, 0, 113, 115,
	116, 108, 117, 0, 119, 0, 0, 0, 21, 181,
	182, 184, 0, 138, 139, 0, 143, -2, 147, 186,
	187, 0, -2, 156, 157, 158, 159, 161, 0, 0,
	0, 128, 0, 43, 382, 383, 384, 385, 386, 387,
	388, 389, 390, 391, 392, 393, 394, 395, 396, 397,
	398, 399, 400, 401, 402, 403, 404, 405, 406, 407,
	408, 409, 410, 411, 412, 413, 414, 415, 416, 417,
	418, 419, 420, 21, 195, 202, 204, 0, 214, 21,
	189, 197, 191, 192, 0, 23, 247, 23, 22, 0,
	0, 0, 132, 0, 47, 0, 51, -2, 464, 465,
	466, 467, 468, 469, 470, 471, 472, 473, 474, 475,
	476, 477, 478, 479, 480, 481, 482, 483, 484, 485,
	486, 487, 488, 489, 490, 491, 492, 493, 494, 495,
	496, 497, 498, 499, 500, 501, 502, 503, 504, 505,
	506, 110, 0, 112, 121, 96, 0, 21, 234, 21,
	137, 140, -2, 145, 0, 21, 155, 160, 0, 0,
	0, 0, 129, 166, 21, 0, 215, 21, 0, 245,
	23, 248, 21, 0, 260, 133, 48, -2, 53, 114,
	21, 0, 232, 21, 235, 146, 152, 0, 0, 0,
	44, 167, 168, 0, 21, 246, 257, 21, 259, 0,
	21, 233, 23, 23, 0, 148, 0, 0, -2, 21,
	0, 54, 162, 23, 21, 0, 149, 21, -2, 264,
	265, 266, 150, 21, 163, 0, 21, 258, 263, 151,
	164, 0, 165,
}

var protoTok1 = [...]int8{
	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 77, 3, 75, 74, 73, 71, 3,
	66, 67, 70, 64, 61, 65, 60, 58, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 54, 53,
	63, 52, 62, 59, 76, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 68, 57, 69, 72, 3, 79, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 55, 3, 56, 78,
}

var protoTok2 = [...]int8{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
}

var protoTok3 = [...]int8{
	0,
}

var protoErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

/*	parser for yacc output	*/

var (
	protoDebug        = 0
	protoErrorVerbose = false
)

type protoLexer interface {
	Lex(lval *protoSymType) int
	Error(s string)
}

type protoParser interface {
	Parse(protoLexer) int
	Lookahead() int
}

type protoParserImpl struct {
	lval  protoSymType
	stack [protoInitialStackSize]protoSymType
	char  int
}

func (p *protoParserImpl) Lookahead() int {
	return p.char
}

func protoNewParser() protoParser {
	return &protoParserImpl{}
}

const protoFlag = -1000

func protoTokname(c int) string {
	if c >= 1 && c-1 < len(protoToknames) {
		if protoToknames[c-1] != "" {
			return protoToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func protoStatname(s int) string {
	if s >= 0 && s < len(protoStatenames) {
		if protoStatenames[s] != "" {
			return protoStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func protoErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !protoErrorVerbose {
		return "syntax error"
	}

	for _, e := range protoErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + protoTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := int(protoPact[state])
	for tok := TOKSTART; tok-1 < len(protoToknames); tok++ {
		if n := base + tok; n >= 0 && n < protoLast && int(protoChk[int(protoAct[n])]) == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if protoDef[state] == -2 {
		i := 0
		for protoExca[i] != -1 || int(protoExca[i+1]) != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; protoExca[i] >= 0; i += 2 {
			tok := int(protoExca[i])
			if tok < TOKSTART || protoExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if protoExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += protoTokname(tok)
	}
	return res
}

func protolex1(lex protoLexer, lval *protoSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = int(protoTok1[0])
		goto out
	}
	if char < len(protoTok1) {
		token = int(protoTok1[char])
		goto out
	}
	if char >= protoPrivate {
		if char < protoPrivate+len(protoTok2) {
			token = int(protoTok2[char-protoPrivate])
			goto out
		}
	}
	for i := 0; i < len(protoTok3); i += 2 {
		token = int(protoTok3[i+0])
		if token == char {
			token = int(protoTok3[i+1])
			goto out
		}
	}

out:
	if token == 0 {
		token = int(protoTok2[1]) /* unknown char */
	}
	if protoDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", protoTokname(token), uint(char))
	}
	return char, token
}

func protoParse(protolex protoLexer) int {
	return protoNewParser().Parse(protolex)
}

func (protorcvr *protoParserImpl) Parse(protolex protoLexer) int {
	var proton int
	var protoVAL protoSymType
	var protoDollar []protoSymType
	_ = protoDollar // silence set and not used
	protoS := protorcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	protostate := 0
	protorcvr.char = -1
	prototoken := -1 // protorcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		protostate = -1
		protorcvr.char = -1
		prototoken = -1
	}()
	protop := -1
	goto protostack

ret0:
	return 0

ret1:
	return 1

protostack:
	/* put a state and value onto the stack */
	if protoDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", protoTokname(prototoken), protoStatname(protostate))
	}

	protop++
	if protop >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoS[protop] = protoVAL
	protoS[protop].yys = protostate

protonewstate:
	proton = int(protoPact[protostate])
	if proton <= protoFlag {
		goto protodefault /* simple state */
	}
	if protorcvr.char < 0 {
		protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
	}
	proton += prototoken
	if proton < 0 || proton >= protoLast {
		goto protodefault
	}
	proton = int(protoAct[proton])
	if int(protoChk[proton]) == prototoken { /* valid shift */
		protorcvr.char = -1
		prototoken = -1
		protoVAL = protorcvr.lval
		protostate = proton
		if Errflag > 0 {
			Errflag--
		}
		goto protostack
	}

protodefault:
	/* default state action */
	proton = int(protoDef[protostate])
	if proton == -2 {
		if protorcvr.char < 0 {
			protorcvr.char, prototoken = protolex1(protolex, &protorcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if protoExca[xi+0] == -1 && int(protoExca[xi+1]) == protostate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			proton = int(protoExca[xi+0])
			if proton < 0 || proton == prototoken {
				break
			}
		}
		proton = int(protoExca[xi+1])
		if proton < 0 {
			goto ret0
		}
	}
	if proton == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			protolex.Error(protoErrorMessage(protostate, prototoken))
			Nerrs++
			if protoDebug >= 1 {
				__yyfmt__.Printf("%s", protoStatname(protostate))
				__yyfmt__.Printf(" saw %s\n", protoTokname(prototoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for protop >= 0 {
				proton = int(protoPact[protoS[protop].yys]) + protoErrCode
				if proton >= 0 && proton < protoLast {
					protostate = int(protoAct[proton]) /* simulate a shift of "error" */
					if int(protoChk[protostate]) == protoErrCode {
						goto protostack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if protoDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", protoS[protop].yys)
				}
				protop--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if protoDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", protoTokname(prototoken))
			}
			if prototoken == protoEofCode {
				goto ret1
			}
			protorcvr.char = -1
			prototoken = -1
			goto protonewstate /* try again in the same state */
		}
	}

	/* reduction by production proton */
	if protoDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", proton, protoStatname(protostate))
	}

	protont := proton
	protopt := protop
	_ = protopt // guard against "declared and not used"

	protop -= int(protoR2[proton])
	// protop is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if protop+1 >= len(protoS) {
		nyys := make([]protoSymType, len(protoS)*2)
		copy(nyys, protoS)
		protoS = nyys
	}
	protoVAL = protoS[protop+1]

	/* consult goto table to find next state */
	proton = int(protoR1[proton])
	protog := int(protoPgo[proton])
	protoj := protog + protoS[protop].yys + 1

	if protoj >= protoLast {
		protostate = int(protoAct[protog])
	} else {
		protostate = int(protoAct[protoj])
		if int(protoChk[protostate]) != -proton {
			protostate = int(protoAct[protog])
		}
	}
	// dummy call; replaced with literal code
	switch protont {

	case 1:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 2:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNodeWithEdition(lex.info, protoDollar[1].ed, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 3:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, protoDollar[1].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 4:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, protoDollar[1].syn, protoDollar[2].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 5:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNodeWithEdition(lex.info, protoDollar[1].ed, protoDollar[2].fileElements, lex.eof)
			lex.res = protoVAL.file
		}
	case 6:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			lex := protolex.(*protoLex)
			protoVAL.file = ast.NewFileNode(lex.info, nil, nil, lex.eof)
			lex.res = protoVAL.file
		}
	case 7:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.fileElements = prependRunes(toFileElement, protoDollar[1].bs, protoDollar[2].fileElements)
		}
	case 8:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.fileElements = append(protoDollar[1].fileElements, protoDollar[2].fileElements...)
		}
	case 9:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = protoDollar[1].fileElements
		}
	case 10:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].imprt.Node, protoDollar[1].imprt.Runes)
		}
	case 11:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].pkg.Node, protoDollar[1].pkg.Runes)
		}
	case 12:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 13:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].msg.Node, protoDollar[1].msg.Runes)
		}
	case 14:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].en.Node, protoDollar[1].en.Runes)
		}
	case 15:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].extend.Node, protoDollar[1].extend.Runes)
		}
	case 16:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = toElements[ast.FileElement](toFileElement, protoDollar[1].svc.Node, protoDollar[1].svc.Runes)
		}
	case 17:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.fileElements = nil
		}
	case 18:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.bs = []*ast.RuneNode{protoDollar[1].b}
		}
	case 19:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.bs = append(protoDollar[1].bs, protoDollar[2].b)
		}
	case 20:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.bs = protoDollar[1].bs
		}
	case 21:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.bs = nil
		}
	case 22:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.b = protoDollar[1].b
		}
	case 23:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: expecting ';'")
			protoVAL.b = nil
		}
	case 24:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.syn = ast.NewSyntaxNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 25:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.ed = ast.NewEditionNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, toStringValueNode(protoDollar[3].str), protoDollar[4].b)
		}
	case 26:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.imprt = newNodeWithRunes(ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, nil, toStringValueNode(protoDollar[2].str), semi), extra...)
		}
	case 27:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.imprt = newNodeWithRunes(ast.NewImportNode(protoDollar[1].id.ToKeyword(), nil, protoDollar[2].id.ToKeyword(), toStringValueNode(protoDollar[3].str), semi), extra...)
		}
	case 28:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.imprt = newNodeWithRunes(ast.NewImportNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), nil, toStringValueNode(protoDollar[3].str), semi), extra...)
		}
	case 29:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.pkg = newNodeWithRunes(ast.NewPackageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].cid.toIdentValueNode(nil), semi), extra...)
		}
	case 30:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 31:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 32:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 33:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 34:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 35:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 36:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id)
		}
	case 37:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected '.'")
			protoVAL.cidPart = protoDollar[1].cidPart
		}
	case 38:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id, protoDollar[2].b)
		}
	case 39:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 40:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 41:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 42:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 43:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 44:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 45:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 46:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[3].id)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].b)
			protoVAL.cid = protoDollar[1].cid
		}
	case 47:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 48:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 49:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cid = &identSlices{idents: []*ast.IdentNode{protoDollar[1].cidPart.Node}, dots: protoDollar[1].cidPart.Runes}
		}
	case 50:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].cid.idents = append(protoDollar[1].cid.idents, protoDollar[2].cidPart.Node)
			protoDollar[1].cid.dots = append(protoDollar[1].cid.dots, protoDollar[2].cidPart.Runes...)
			protoVAL.cid = protoDollar[1].cid
		}
	case 51:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id)
		}
	case 52:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected '.'")
			protoVAL.cidPart = protoDollar[1].cidPart
		}
	case 53:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.cidPart = newNodeWithRunes(protoDollar[1].id, protoDollar[2].b)
		}
	case 54:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[2].optNms.refs, protoDollar[2].optNms.dots)
			protoVAL.optRaw = ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, protoDollar[5].b)
		}
	case 55:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[2].optNms.refs, protoDollar[2].optNms.dots)
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.opt = newNodeWithRunes(ast.NewOptionNode(protoDollar[1].id.ToKeyword(), optName, protoDollar[3].b, protoDollar[4].v, semi), extra...)
		}
	case 56:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.refRaw = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 57:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.refRaw = protoDollar[1].refRaw
		}
	case 58:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.ref = newNodeWithRunes(protoDollar[1].refRaw, protoDollar[2].b)
		}
	case 59:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ref = newNodeWithRunes(protoDollar[1].refRaw)
		}
	case 60:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected '.'")
			protoVAL.ref = protoDollar[1].ref
		}
	case 61:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{protoDollar[1].ref.Node}, dots: protoDollar[1].ref.Runes}
		}
	case 62:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, protoDollar[2].ref.Node)
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].ref.Runes...)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 63:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.optNms = &fieldRefSlices{refs: []*ast.FieldReferenceNode{protoDollar[1].ref.Node}, dots: protoDollar[1].ref.Runes}
		}
	case 64:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].optNms.refs = append(protoDollar[1].optNms.refs, protoDollar[2].ref.Node)
			protoDollar[1].optNms.dots = append(protoDollar[1].optNms.dots, protoDollar[2].ref.Runes...)
			protoVAL.optNms = protoDollar[1].optNms
		}
	case 65:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.refRaw = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].tid, protoDollar[3].b)
		}
	case 68:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = toStringValueNode(protoDollar[1].str)
		}
	case 71:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].id
		}
	case 72:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].f
		}
	case 73:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].f)
		}
	case 74:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].i
		}
	case 75:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].i.Val > math.MaxInt64+1 {
				// can't represent as int so treat as float literal
				protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, protoDollar[2].i)
			} else {
				protoVAL.v = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
			}
		}
	case 76:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 77:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			f := ast.NewSpecialFloatLiteralNode(protoDollar[2].id.ToKeyword())
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 78:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.str = []*ast.StringLiteralNode{protoDollar[1].s}
		}
	case 79:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.str = append(protoDollar[1].str, protoDollar[2].s)
		}
	case 80:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 81:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 84:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFlds != nil {
				protoDollar[1].msgLitFlds.next = protoDollar[2].msgLitFlds
				protoVAL.msgLitFlds = protoDollar[1].msgLitFlds
			} else {
				protoVAL.msgLitFlds = protoDollar[2].msgLitFlds
			}
		}
	case 85:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 86:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 87:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].msgLitFld != nil {
				protoVAL.msgLitFlds = &messageFieldList{field: protoDollar[1].msgLitFld, delimiter: protoDollar[2].b}
			} else {
				protoVAL.msgLitFlds = nil
			}
		}
	case 88:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 89:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 90:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgLitFlds = nil
		}
	case 91:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[1].refRaw != nil && protoDollar[2].b != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].refRaw, protoDollar[2].b, protoDollar[3].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 92:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[1].refRaw != nil && protoDollar[2].v != nil {
				protoVAL.msgLitFld = ast.NewMessageFieldNode(protoDollar[1].refRaw, nil, protoDollar[2].v)
			} else {
				protoVAL.msgLitFld = nil
			}
		}
	case 93:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.msgLitFld = nil
		}
	case 94:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.refRaw = ast.NewFieldReferenceNode(protoDollar[1].id)
		}
	case 95:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.refRaw = ast.NewExtensionFieldReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b)
		}
	case 96:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.refRaw = ast.NewAnyTypeReferenceNode(protoDollar[1].b, protoDollar[2].cid.toIdentValueNode(nil), protoDollar[3].b, protoDollar[4].cid.toIdentValueNode(nil), protoDollar[5].b)
		}
	case 97:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.refRaw = nil
		}
	case 101:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = toStringValueNode(protoDollar[1].str)
		}
	case 103:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			kw := protoDollar[2].id.ToKeyword()
			switch strings.ToLower(kw.Val) {
			case "inf", "infinity", "nan":
				// these are acceptable
			default:
				// anything else is not
				protolex.(*protoLex).Error(`only identifiers "inf", "infinity", or "nan" may appear after negative sign`)
			}
			// we'll validate the identifier later
			f := ast.NewSpecialFloatLiteralNode(kw)
			protoVAL.v = ast.NewSignedFloatLiteralNode(protoDollar[1].b, f)
		}
	case 104:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.v = protoDollar[1].id
		}
	case 108:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].msgLitFlds == nil {
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				fields, delimiters := protoDollar[2].msgLitFlds.toNodes()
				protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, fields, delimiters, protoDollar[3].b)
			}
		}
	case 109:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewMessageLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 110:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 111:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 112:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
		}
	case 113:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 114:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 117:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			if protoDollar[2].sl == nil {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
			} else {
				protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, protoDollar[2].sl.vals, protoDollar[2].sl.commas, protoDollar[3].b)
			}
		}
	case 118:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 119:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.v = ast.NewArrayLiteralNode(protoDollar[1].b, nil, nil, protoDollar[3].b)
		}
	case 120:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.sl = &valueSlices{vals: []ast.ValueNode{protoDollar[1].v}}
		}
	case 121:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].sl.vals = append(protoDollar[1].sl.vals, protoDollar[3].v)
			protoDollar[1].sl.commas = append(protoDollar[1].sl.commas, protoDollar[2].b)
			protoVAL.sl = protoDollar[1].sl
		}
	case 122:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 123:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 124:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 125:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 126:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 127:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 128:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 129:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 130:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 131:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 132:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.tid = protoDollar[1].cid.toIdentValueNode(nil)
		}
	case 133:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.tid = protoDollar[2].cid.toIdentValueNode(protoDollar[1].b)
		}
	case 137:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, protoDollar[2].opts.options, protoDollar[2].opts.commas, protoDollar[3].b)
		}
	case 138:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protolex.(*protoLex).Error("compact options must have at least one option")
			protoVAL.cmpctOpts = ast.NewCompactOptionsNode(protoDollar[1].b, nil, nil, protoDollar[2].b)
		}
	case 139:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opts = &compactOptionSlices{options: []*ast.OptionNode{protoDollar[1].opt.Node}, commas: protoDollar[1].opt.Runes}
		}
	case 140:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].opts.options = append(protoDollar[1].opts.options, protoDollar[2].opt.Node)
			protoDollar[1].opts.commas = append(protoDollar[1].opts.commas, protoDollar[2].opt.Runes...)
			protoVAL.opts = protoDollar[1].opts
		}
	case 141:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opts = &compactOptionSlices{options: []*ast.OptionNode{protoDollar[1].opt.Node}, commas: protoDollar[1].opt.Runes}
		}
	case 142:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoDollar[1].opts.options = append(protoDollar[1].opts.options, protoDollar[2].opt.Node)
			protoDollar[1].opts.commas = append(protoDollar[1].opts.commas, protoDollar[2].opt.Runes...)
			protoVAL.opts = protoDollar[1].opts
		}
	case 143:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.opt = newNodeWithRunes(protoDollar[1].optRaw)
		}
	case 144:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protolex.(*protoLex).Error("syntax error: unexpected ','")
			protoVAL.opt = protoDollar[1].opt
		}
	case 145:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.opt = newNodeWithRunes(protoDollar[1].optRaw, protoDollar[2].b)
		}
	case 146:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[1].optNms.refs, protoDollar[1].optNms.dots)
			protoVAL.optRaw = ast.NewCompactOptionNode(optName, protoDollar[2].b, protoDollar[3].v)
		}
	case 147:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			optName := ast.NewOptionNameNode(protoDollar[1].optNms.refs, protoDollar[1].optNms.dots)
			protolex.(*protoLex).Error("compact option must have a value")
			protoVAL.optRaw = ast.NewCompactOptionNode(optName, nil, nil)
		}
	case 148:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 149:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgElements, protoDollar[9].b)
		}
	case 150:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithRunes(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b), protoDollar[9].bs...)
		}
	case 151:
		protoDollar = protoS[protopt-10 : protopt+1]
		{
			protoVAL.msgGrp = newNodeWithRunes(ast.NewGroupNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id.ToKeyword(), protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b, protoDollar[8].msgElements, protoDollar[9].b), protoDollar[10].bs...)
		}
	case 152:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.oo = newNodeWithRunes(ast.NewOneofNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].ooElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 153:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.ooElements = nil
		}
	case 155:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].ooElement != nil {
				protoVAL.ooElements = append(protoDollar[1].ooElements, protoDollar[2].ooElement)
			} else {
				protoVAL.ooElements = protoDollar[1].ooElements
			}
		}
	case 156:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].ooElement != nil {
				protoVAL.ooElements = []ast.OneofElement{protoDollar[1].ooElement}
			} else {
				protoVAL.ooElements = nil
			}
		}
	case 157:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].optRaw
		}
	case 158:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].fld
		}
	case 159:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = protoDollar[1].grp
		}
	case 160:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 161:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.ooElement = nil
		}
	case 162:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 163:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 164:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b, protoDollar[6].msgElements, protoDollar[7].b)
		}
	case 165:
		protoDollar = protoS[protopt-8 : protopt+1]
		{
			protoVAL.grp = ast.NewGroupNode(nil, protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b, protoDollar[7].msgElements, protoDollar[8].b)
		}
	case 166:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.mapFld = newNodeWithRunes(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semi), extra...)
		}
	case 167:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.mapFld = newNodeWithRunes(ast.NewMapFieldNode(protoDollar[1].mapType, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semi), extra...)
		}
	case 168:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.mapType = ast.NewMapTypeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].b, protoDollar[3].id, protoDollar[4].b, protoDollar[5].tid, protoDollar[6].b)
		}
	case 181:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `extensions 1 to 10` and `extensions 1` followed by `to = 10`.
			protoVAL.ext = newNodeWithRunes(ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, nil, protoDollar[3].b), protoDollar[4].bs...)
		}
	case 182:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.ext = newNodeWithRunes(ast.NewExtensionRangeNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].cmpctOpts, semi), extra...)
		}
	case 183:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 184:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 185:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, nil, nil, nil)
		}
	case 186:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), protoDollar[3].i, nil)
		}
	case 187:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].i, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 188:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rngs = &rangeSlices{ranges: []*ast.RangeNode{protoDollar[1].rng}}
		}
	case 189:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].rngs.ranges = append(protoDollar[1].rngs.ranges, protoDollar[3].rng)
			protoDollar[1].rngs.commas = append(protoDollar[1].rngs.commas, protoDollar[2].b)
			protoVAL.rngs = protoDollar[1].rngs
		}
	case 190:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, nil, nil, nil)
		}
	case 191:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), protoDollar[3].il, nil)
		}
	case 192:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.rng = ast.NewRangeNode(protoDollar[1].il, protoDollar[2].id.ToKeyword(), nil, protoDollar[3].id.ToKeyword())
		}
	case 193:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.il = protoDollar[1].i
		}
	case 194:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.il = ast.NewNegativeIntLiteralNode(protoDollar[1].b, protoDollar[2].i)
		}
	case 195:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `reserved 1 to 10` and `reserved 1` followed by `to = 10`.
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b), protoDollar[4].bs...)
		}
	case 197:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			// TODO: Tolerate a missing semicolon here. This currnelty creates a shift/reduce conflict
			// between `reserved 1 to 10` and `reserved 1` followed by `to = 10`.
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedRangesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].rngs.ranges, protoDollar[2].rngs.commas, protoDollar[3].b), protoDollar[4].bs...)
		}
	case 199:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedNamesNode(protoDollar[1].id.ToKeyword(), protoDollar[2].names.names, protoDollar[2].names.commas, semi), extra...)
		}
	case 200:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[3].bs)
			protoVAL.resvd = newNodeWithRunes(ast.NewReservedIdentifiersNode(protoDollar[1].id.ToKeyword(), protoDollar[2].names.idents, protoDollar[2].names.commas, semi), extra...)
		}
	case 201:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameSlices{names: []ast.StringValueNode{toStringValueNode(protoDollar[1].str)}}
		}
	case 202:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].names.names = append(protoDollar[1].names.names, toStringValueNode(protoDollar[3].str))
			protoDollar[1].names.commas = append(protoDollar[1].names.commas, protoDollar[2].b)
			protoVAL.names = protoDollar[1].names
		}
	case 203:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.names = &nameSlices{idents: []*ast.IdentNode{protoDollar[1].id}}
		}
	case 204:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoDollar[1].names.idents = append(protoDollar[1].names.idents, protoDollar[3].id)
			protoDollar[1].names.commas = append(protoDollar[1].names.commas, protoDollar[2].b)
			protoVAL.names = protoDollar[1].names
		}
	case 205:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.en = newNodeWithRunes(ast.NewEnumNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].enElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 206:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = prependRunes(toEnumElement, protoDollar[1].bs, nil)
		}
	case 207:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.enElements = prependRunes(toEnumElement, protoDollar[1].bs, protoDollar[2].enElements)
		}
	case 208:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.enElements = append(protoDollar[1].enElements, protoDollar[2].enElements...)
		}
	case 209:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = protoDollar[1].enElements
		}
	case 210:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toElements[ast.EnumElement](toEnumElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 211:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toElements[ast.EnumElement](toEnumElement, protoDollar[1].env.Node, protoDollar[1].env.Runes)
		}
	case 212:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = toElements[ast.EnumElement](toEnumElement, protoDollar[1].resvd.Node, protoDollar[1].resvd.Runes)
		}
	case 213:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.enElements = nil
		}
	case 214:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[4].bs)
			protoVAL.env = newNodeWithRunes(ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, nil, semi), extra...)
		}
	case 215:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.env = newNodeWithRunes(ast.NewEnumValueNode(protoDollar[1].id, protoDollar[2].b, protoDollar[3].il, protoDollar[4].cmpctOpts, semi), extra...)
		}
	case 216:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.msg = newNodeWithRunes(ast.NewMessageNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].msgElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 217:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = prependRunes(toMessageElement, protoDollar[1].bs, nil)
		}
	case 218:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgElements = prependRunes(toMessageElement, protoDollar[1].bs, protoDollar[2].msgElements)
		}
	case 219:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.msgElements = append(protoDollar[1].msgElements, protoDollar[2].msgElements...)
		}
	case 220:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = protoDollar[1].msgElements
		}
	case 221:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].msgFld.Node, protoDollar[1].msgFld.Runes)
		}
	case 222:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].en.Node, protoDollar[1].en.Runes)
		}
	case 223:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].msg.Node, protoDollar[1].msg.Runes)
		}
	case 224:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].extend.Node, protoDollar[1].extend.Runes)
		}
	case 225:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].ext.Node, protoDollar[1].ext.Runes)
		}
	case 226:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].msgGrp.Node, protoDollar[1].msgGrp.Runes)
		}
	case 227:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 228:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].oo.Node, protoDollar[1].oo.Runes)
		}
	case 229:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].mapFld.Node, protoDollar[1].mapFld.Runes)
		}
	case 230:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = toElements[ast.MessageElement](toMessageElement, protoDollar[1].resvd.Node, protoDollar[1].resvd.Runes)
		}
	case 231:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.msgElements = nil
		}
	case 232:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, semis), extra...)
		}
	case 233:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[7].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, semis), extra...)
		}
	case 234:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[5].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, semis), extra...)
		}
	case 235:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semis, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.msgFld = newNodeWithRunes(ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, semis), extra...)
		}
	case 236:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.extend = newNodeWithRunes(ast.NewExtendNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].b, protoDollar[4].extElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 237:
		protoDollar = protoS[protopt-0 : protopt+1]
		{
			protoVAL.extElements = nil
		}
	case 239:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			if protoDollar[2].extElement != nil {
				protoVAL.extElements = append(protoDollar[1].extElements, protoDollar[2].extElement)
			} else {
				protoVAL.extElements = protoDollar[1].extElements
			}
		}
	case 240:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			if protoDollar[1].extElement != nil {
				protoVAL.extElements = []ast.ExtendElement{protoDollar[1].extElement}
			} else {
				protoVAL.extElements = nil
			}
		}
	case 241:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].fld
		}
	case 242:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = protoDollar[1].grp
		}
	case 243:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 244:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.extElement = nil
		}
	case 245:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, nil, protoDollar[6].b)
		}
	case 246:
		protoDollar = protoS[protopt-7 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(protoDollar[1].id.ToKeyword(), protoDollar[2].tid, protoDollar[3].id, protoDollar[4].b, protoDollar[5].i, protoDollar[6].cmpctOpts, protoDollar[7].b)
		}
	case 247:
		protoDollar = protoS[protopt-5 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, nil, protoDollar[5].b)
		}
	case 248:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.fld = ast.NewFieldNode(nil, protoDollar[1].tid, protoDollar[2].id, protoDollar[3].b, protoDollar[4].i, protoDollar[5].cmpctOpts, protoDollar[6].b)
		}
	case 249:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			protoVAL.svc = newNodeWithRunes(ast.NewServiceNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].b, protoDollar[4].svcElements, protoDollar[5].b), protoDollar[6].bs...)
		}
	case 250:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = prependRunes(toServiceElement, protoDollar[1].bs, nil)
		}
	case 251:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.svcElements = prependRunes(toServiceElement, protoDollar[1].bs, protoDollar[2].svcElements)
		}
	case 252:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.svcElements = append(protoDollar[1].svcElements, protoDollar[2].svcElements...)
		}
	case 253:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = protoDollar[1].svcElements
		}
	case 254:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = toElements[ast.ServiceElement](toServiceElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 255:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = toElements[ast.ServiceElement](toServiceElement, protoDollar[1].mtd.Node, protoDollar[1].mtd.Runes)
		}
	case 256:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.svcElements = nil
		}
	case 257:
		protoDollar = protoS[protopt-6 : protopt+1]
		{
			semi, extra := protolex.(*protoLex).requireSemicolon(protoDollar[6].bs)
			protoVAL.mtd = newNodeWithRunes(ast.NewRPCNode(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, semi), extra...)
		}
	case 258:
		protoDollar = protoS[protopt-9 : protopt+1]
		{
			protoVAL.mtd = newNodeWithRunes(ast.NewRPCNodeWithBody(protoDollar[1].id.ToKeyword(), protoDollar[2].id, protoDollar[3].mtdMsgType, protoDollar[4].id.ToKeyword(), protoDollar[5].mtdMsgType, protoDollar[6].b, protoDollar[7].mtdElements, protoDollar[8].b), protoDollar[9].bs...)
		}
	case 259:
		protoDollar = protoS[protopt-4 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, protoDollar[2].id.ToKeyword(), protoDollar[3].tid, protoDollar[4].b)
		}
	case 260:
		protoDollar = protoS[protopt-3 : protopt+1]
		{
			protoVAL.mtdMsgType = ast.NewRPCTypeNode(protoDollar[1].b, nil, protoDollar[2].tid, protoDollar[3].b)
		}
	case 261:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = prependRunes(toMethodElement, protoDollar[1].bs, nil)
		}
	case 262:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.mtdElements = prependRunes(toMethodElement, protoDollar[1].bs, protoDollar[2].mtdElements)
		}
	case 263:
		protoDollar = protoS[protopt-2 : protopt+1]
		{
			protoVAL.mtdElements = append(protoDollar[1].mtdElements, protoDollar[2].mtdElements...)
		}
	case 264:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = protoDollar[1].mtdElements
		}
	case 265:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = toElements[ast.RPCElement](toMethodElement, protoDollar[1].opt.Node, protoDollar[1].opt.Runes)
		}
	case 266:
		protoDollar = protoS[protopt-1 : protopt+1]
		{
			protoVAL.mtdElements = nil
		}
	}
	goto protostack /* stack new state and value */
}
