/*
Copyright © 2020-2021 The k3d Author(s)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
package registry

import (
	log "github.com/sirupsen/logrus"
	"github.com/spf13/cobra"
)

// NewCmdRegistry returns a new cobra command
func NewCmdRegistry() *cobra.Command {

	// create new cobra command
	cmd := &cobra.Command{
		Use:     "registry",
		Aliases: []string{"registries", "reg"},
		Short:   "Manage registry/registries",
		Long:    `Manage registry/registries`,
		Run: func(cmd *cobra.Command, args []string) {
			if err := cmd.Help(); err != nil {
				log.Errorln("Couldn't get help text")
				log.Fatalln(err)
			}
		},
	}

	// add subcommands
	cmd.AddCommand(NewCmdRegistryCreate())
	cmd.AddCommand(NewCmdRegistryStart())
	cmd.AddCommand(NewCmdRegistryStop())
	cmd.AddCommand(NewCmdRegistryDelete())
	cmd.AddCommand(NewCmdRegistryList())
	// cmd.AddCommand(NewCmdRegistryConnect()) // TODO: registry connect requires reload capabilities for containerd config

	// add flags

	// done
	return cmd
}
