package shell

// Pwsh is the PowerShell shell integration.
var Pwsh = Shell(`# Put the line below in your PowerShell profile (Microsoft.PowerShell_profile.ps1):
#
#   Invoke-Expression (&jump shell pwsh | Out-String)
#
# You can locate your profile by typing $PROFILE in PowerShell.
#
# The following lines are autogenerated:

function {{.Bind}}
{
    $Path = $(jump cd $Args);
    if (Test-Path $Path) {
        Set-Location $Path
    }
}

function Set-Location
{
    [CmdletBinding()]
    param(
        [Parameter(Position=0)]
        [System.Object]
        ${Path})

    begin
    {
        try {
            $outBuffer = $null
            if ($PSBoundParameters.TryGetValue('OutBuffer', [ref]$outBuffer)) {
                $PSBoundParameters['OutBuffer'] = 1
            }

            $wrappedCmd = $ExecutionContext.InvokeCommand.GetCommand('Microsoft.PowerShell.Management\Set-Location', [System.Management.Automation.CommandTypes]::Function)
            $scriptCmd = {& $wrappedCmd @PSBoundParameters }

            $steppablePipeline = $scriptCmd.GetSteppablePipeline()
            $steppablePipeline.Begin($PSCmdlet)
        } catch {
            throw
        }
    }

    process
    {
        try {
            $steppablePipeline.Process($_)
            jump chdir
        } catch {
            throw
        }
    }

    end
    {
        try {
            $steppablePipeline.End()
        } catch {
            throw
        }
    }
    <#

    .ForwardHelpTargetName Set-Location
    .ForwardHelpCategory Function

    #>
}

function Push-Location
{
    [CmdletBinding()]
    param(
        [Parameter(Position=0)]
        [System.Object]
        ${Path})

    begin
    {
        try {
            $outBuffer = $null
            if ($PSBoundParameters.TryGetValue('OutBuffer', [ref]$outBuffer)) {
                $PSBoundParameters['OutBuffer'] = 1
            }

            $wrappedCmd = $ExecutionContext.InvokeCommand.GetCommand('Microsoft.PowerShell.Management\Push-Location', [System.Management.Automation.CommandTypes]::Function)
            $scriptCmd = {& $wrappedCmd @PSBoundParameters }

            $steppablePipeline = $scriptCmd.GetSteppablePipeline()
            $steppablePipeline.Begin($PSCmdlet)
        } catch {
            throw
        }
    }

    process
    {
        try {
            $steppablePipeline.Process($_)
            jump chdir
        } catch {
            throw
        }
    }

    end
    {
        try {
            $steppablePipeline.End()
        } catch {
            throw
        }
    }
    <#

    .ForwardHelpTargetName Push-Location
    .ForwardHelpCategory Function

    #>
}

if (Get-Command -Name Register-ArgumentCompleter -ErrorAction Ignore) {
    Register-ArgumentCompleter -CommandName '{{.Bind}}' -ScriptBlock {
        param ($commandName, $wordToComplete, $commandAst, $fakeBoundParameter)

        $wordToComplete = "$wordToComplete"
        if ($wordToComplete.StartsWith('{{.Bind}} ')) {
            $wordToComplete = "$wordToComplete".Substring('{{.Bind}} '.Length)
        }

        jump hint $wordToComplete | ForEach-Object {
            if ($_.Contains(' ')) { "'" + $_ + "'" } else { $_ }
        }
    }
}
`)
