package shell

// Fish is the fish shell integration.
var Fish = Shell(`# Put the line below in ~/.config/fish/config.fish:
#
#   status --is-interactive; and source (jump shell fish | psub)
#
# The following lines are autogenerated:

function __jump_add --on-variable PWD
  status --is-command-substitution; and return
  jump chdir
end

function __jump_hint
  set -l term (string replace -r '^{{.Bind}} ' '' -- (commandline -cp))
  jump hint "$term"
end

function {{.Bind}}
  set -l dir (jump cd "$argv")
  test -d "$dir"; and cd "$dir"
end

complete --command {{.Bind}} --exclusive --arguments '(__jump_hint)'
`)
