{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='endpoint', url='', help='"Endpoint represents a single logical \\"backend\\" implementing a service."'),
  '#conditions':: d.obj(help='"EndpointConditions represents the current condition of an endpoint."'),
  conditions: {
    '#withReady':: d.fn(help='"ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready. For compatibility reasons, ready should never be \\"true\\" for terminating endpoints, except when the normal readiness behavior is being explicitly overridden, for example when the associated Service has set the publishNotReadyAddresses flag."', args=[d.arg(name='ready', type=d.T.boolean)]),
    withReady(ready): { conditions+: { ready: ready } },
    '#withServing':: d.fn(help='"serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition."', args=[d.arg(name='serving', type=d.T.boolean)]),
    withServing(serving): { conditions+: { serving: serving } },
    '#withTerminating':: d.fn(help='"terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating."', args=[d.arg(name='terminating', type=d.T.boolean)]),
    withTerminating(terminating): { conditions+: { terminating: terminating } },
  },
  '#hints':: d.obj(help='"EndpointHints provides hints describing how an endpoint should be consumed."'),
  hints: {
    '#withForZones':: d.fn(help='"forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing."', args=[d.arg(name='forZones', type=d.T.array)]),
    withForZones(forZones): { hints+: { forZones: if std.isArray(v=forZones) then forZones else [forZones] } },
    '#withForZonesMixin':: d.fn(help='"forZones indicates the zone(s) this endpoint should be consumed by to enable topology aware routing."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='forZones', type=d.T.array)]),
    withForZonesMixin(forZones): { hints+: { forZones+: if std.isArray(v=forZones) then forZones else [forZones] } },
  },
  '#targetRef':: d.obj(help='"ObjectReference contains enough information to let you inspect or modify the referred object."'),
  targetRef: {
    '#withApiVersion':: d.fn(help='"API version of the referent."', args=[d.arg(name='apiVersion', type=d.T.string)]),
    withApiVersion(apiVersion): { targetRef+: { apiVersion: apiVersion } },
    '#withFieldPath':: d.fn(help='"If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \\"spec.containers{name}\\" (where \\"name\\" refers to the name of the container that triggered the event) or if no container name is specified \\"spec.containers[2]\\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object."', args=[d.arg(name='fieldPath', type=d.T.string)]),
    withFieldPath(fieldPath): { targetRef+: { fieldPath: fieldPath } },
    '#withKind':: d.fn(help='"Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"', args=[d.arg(name='kind', type=d.T.string)]),
    withKind(kind): { targetRef+: { kind: kind } },
    '#withName':: d.fn(help='"Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { targetRef+: { name: name } },
    '#withNamespace':: d.fn(help='"Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/"', args=[d.arg(name='namespace', type=d.T.string)]),
    withNamespace(namespace): { targetRef+: { namespace: namespace } },
    '#withResourceVersion':: d.fn(help='"Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
    withResourceVersion(resourceVersion): { targetRef+: { resourceVersion: resourceVersion } },
    '#withUid':: d.fn(help='"UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids"', args=[d.arg(name='uid', type=d.T.string)]),
    withUid(uid): { targetRef+: { uid: uid } },
  },
  '#withAddresses':: d.fn(help='"addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267"', args=[d.arg(name='addresses', type=d.T.array)]),
  withAddresses(addresses): { addresses: if std.isArray(v=addresses) then addresses else [addresses] },
  '#withAddressesMixin':: d.fn(help='"addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100. These are all assumed to be fungible and clients may choose to only use the first element. Refer to: https://issue.k8s.io/106267"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='addresses', type=d.T.array)]),
  withAddressesMixin(addresses): { addresses+: if std.isArray(v=addresses) then addresses else [addresses] },
  '#withDeprecatedTopology':: d.fn(help='"deprecatedTopology contains topology information part of the v1beta1 API. This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24).  While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead."', args=[d.arg(name='deprecatedTopology', type=d.T.object)]),
  withDeprecatedTopology(deprecatedTopology): { deprecatedTopology: deprecatedTopology },
  '#withDeprecatedTopologyMixin':: d.fn(help='"deprecatedTopology contains topology information part of the v1beta1 API. This field is deprecated, and will be removed when the v1beta1 API is removed (no sooner than kubernetes v1.24).  While this field can hold values, it is not writable through the v1 API, and any attempts to write to it will be silently ignored. Topology information can be found in the zone and nodeName fields instead."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='deprecatedTopology', type=d.T.object)]),
  withDeprecatedTopologyMixin(deprecatedTopology): { deprecatedTopology+: deprecatedTopology },
  '#withHostname':: d.fn(help='"hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation."', args=[d.arg(name='hostname', type=d.T.string)]),
  withHostname(hostname): { hostname: hostname },
  '#withNodeName':: d.fn(help='"nodeName represents the name of the Node hosting this endpoint. This can be used to determine endpoints local to a Node."', args=[d.arg(name='nodeName', type=d.T.string)]),
  withNodeName(nodeName): { nodeName: nodeName },
  '#withZone':: d.fn(help='"zone is the name of the Zone this endpoint exists in."', args=[d.arg(name='zone', type=d.T.string)]),
  withZone(zone): { zone: zone },
  '#mixin': 'ignore',
  mixin: self,
}
