{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='scaleIOPersistentVolumeSource', url='', help='"ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume"'),
  '#secretRef':: d.obj(help='"SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace"'),
  secretRef: {
    '#withName':: d.fn(help='"name is unique within a namespace to reference a secret resource."', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { secretRef+: { name: name } },
    '#withNamespace':: d.fn(help='"namespace defines the space within which the secret name must be unique."', args=[d.arg(name='namespace', type=d.T.string)]),
    withNamespace(namespace): { secretRef+: { namespace: namespace } },
  },
  '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Default is \\"xfs\\', args=[d.arg(name='fsType', type=d.T.string)]),
  withFsType(fsType): { fsType: fsType },
  '#withGateway':: d.fn(help='"gateway is the host address of the ScaleIO API Gateway."', args=[d.arg(name='gateway', type=d.T.string)]),
  withGateway(gateway): { gateway: gateway },
  '#withProtectionDomain':: d.fn(help='"protectionDomain is the name of the ScaleIO Protection Domain for the configured storage."', args=[d.arg(name='protectionDomain', type=d.T.string)]),
  withProtectionDomain(protectionDomain): { protectionDomain: protectionDomain },
  '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
  withReadOnly(readOnly): { readOnly: readOnly },
  '#withSslEnabled':: d.fn(help='"sslEnabled is the flag to enable/disable SSL communication with Gateway, default false"', args=[d.arg(name='sslEnabled', type=d.T.boolean)]),
  withSslEnabled(sslEnabled): { sslEnabled: sslEnabled },
  '#withStorageMode':: d.fn(help='"storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned."', args=[d.arg(name='storageMode', type=d.T.string)]),
  withStorageMode(storageMode): { storageMode: storageMode },
  '#withStoragePool':: d.fn(help='"storagePool is the ScaleIO Storage Pool associated with the protection domain."', args=[d.arg(name='storagePool', type=d.T.string)]),
  withStoragePool(storagePool): { storagePool: storagePool },
  '#withSystem':: d.fn(help='"system is the name of the storage system as configured in ScaleIO."', args=[d.arg(name='system', type=d.T.string)]),
  withSystem(system): { system: system },
  '#withVolumeName':: d.fn(help='"volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source."', args=[d.arg(name='volumeName', type=d.T.string)]),
  withVolumeName(volumeName): { volumeName: volumeName },
  '#mixin': 'ignore',
  mixin: self,
}
