{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='persistentVolumeClaimStatus', url='', help='"PersistentVolumeClaimStatus is the current status of a persistent volume claim."'),
  '#modifyVolumeStatus':: d.obj(help='"ModifyVolumeStatus represents the status object of ControllerModifyVolume operation"'),
  modifyVolumeStatus: {
    '#withTargetVolumeAttributesClassName':: d.fn(help='"targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled"', args=[d.arg(name='targetVolumeAttributesClassName', type=d.T.string)]),
    withTargetVolumeAttributesClassName(targetVolumeAttributesClassName): { modifyVolumeStatus+: { targetVolumeAttributesClassName: targetVolumeAttributesClassName } },
  },
  '#withAccessModes':: d.fn(help='"accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1"', args=[d.arg(name='accessModes', type=d.T.array)]),
  withAccessModes(accessModes): { accessModes: if std.isArray(v=accessModes) then accessModes else [accessModes] },
  '#withAccessModesMixin':: d.fn(help='"accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='accessModes', type=d.T.array)]),
  withAccessModesMixin(accessModes): { accessModes+: if std.isArray(v=accessModes) then accessModes else [accessModes] },
  '#withAllocatedResourceStatuses':: d.fn(help="\"allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:\\n\\t* Un-prefixed keys:\\n\\t\\t- storage - the capacity of the volume.\\n\\t* Custom resources must use implementation-defined prefixed names such as \\\"example.com/my-custom-resource\\\"\\nApart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.\\n\\nClaimResourceStatus can be in any of following states:\\n\\t- ControllerResizeInProgress:\\n\\t\\tState set when resize controller starts resizing the volume in control-plane.\\n\\t- ControllerResizeFailed:\\n\\t\\tState set when resize has failed in resize controller with a terminal error.\\n\\t- NodeResizePending:\\n\\t\\tState set when resize controller has finished resizing the volume but further resizing of\\n\\t\\tvolume is needed on the node.\\n\\t- NodeResizeInProgress:\\n\\t\\tState set when kubelet starts resizing the volume.\\n\\t- NodeResizeFailed:\\n\\t\\tState set when resizing has failed in kubelet with a terminal error. Transient errors don't set\\n\\t\\tNodeResizeFailed.\\nFor example: if expanding a PVC for more capacity - this field can be one of the following states:\\n\\t- pvc.status.allocatedResourceStatus['storage'] = \\\"ControllerResizeInProgress\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"ControllerResizeFailed\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"NodeResizePending\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"NodeResizeInProgress\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"NodeResizeFailed\\\"\\nWhen this field is not set, it means that no resize operation is in progress for the given PVC.\\n\\nA controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.\\n\\nThis is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.\"", args=[d.arg(name='allocatedResourceStatuses', type=d.T.object)]),
  withAllocatedResourceStatuses(allocatedResourceStatuses): { allocatedResourceStatuses: allocatedResourceStatuses },
  '#withAllocatedResourceStatusesMixin':: d.fn(help="\"allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:\\n\\t* Un-prefixed keys:\\n\\t\\t- storage - the capacity of the volume.\\n\\t* Custom resources must use implementation-defined prefixed names such as \\\"example.com/my-custom-resource\\\"\\nApart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.\\n\\nClaimResourceStatus can be in any of following states:\\n\\t- ControllerResizeInProgress:\\n\\t\\tState set when resize controller starts resizing the volume in control-plane.\\n\\t- ControllerResizeFailed:\\n\\t\\tState set when resize has failed in resize controller with a terminal error.\\n\\t- NodeResizePending:\\n\\t\\tState set when resize controller has finished resizing the volume but further resizing of\\n\\t\\tvolume is needed on the node.\\n\\t- NodeResizeInProgress:\\n\\t\\tState set when kubelet starts resizing the volume.\\n\\t- NodeResizeFailed:\\n\\t\\tState set when resizing has failed in kubelet with a terminal error. Transient errors don't set\\n\\t\\tNodeResizeFailed.\\nFor example: if expanding a PVC for more capacity - this field can be one of the following states:\\n\\t- pvc.status.allocatedResourceStatus['storage'] = \\\"ControllerResizeInProgress\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"ControllerResizeFailed\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"NodeResizePending\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"NodeResizeInProgress\\\"\\n     - pvc.status.allocatedResourceStatus['storage'] = \\\"NodeResizeFailed\\\"\\nWhen this field is not set, it means that no resize operation is in progress for the given PVC.\\n\\nA controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.\\n\\nThis is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='allocatedResourceStatuses', type=d.T.object)]),
  withAllocatedResourceStatusesMixin(allocatedResourceStatuses): { allocatedResourceStatuses+: allocatedResourceStatuses },
  '#withAllocatedResources':: d.fn(help='"allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:\\n\\t* Un-prefixed keys:\\n\\t\\t- storage - the capacity of the volume.\\n\\t* Custom resources must use implementation-defined prefixed names such as \\"example.com/my-custom-resource\\"\\nApart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.\\n\\nCapacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.\\n\\nA controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.\\n\\nThis is an alpha field and requires enabling RecoverVolumeExpansionFailure feature."', args=[d.arg(name='allocatedResources', type=d.T.object)]),
  withAllocatedResources(allocatedResources): { allocatedResources: allocatedResources },
  '#withAllocatedResourcesMixin':: d.fn(help='"allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:\\n\\t* Un-prefixed keys:\\n\\t\\t- storage - the capacity of the volume.\\n\\t* Custom resources must use implementation-defined prefixed names such as \\"example.com/my-custom-resource\\"\\nApart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.\\n\\nCapacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.\\n\\nA controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.\\n\\nThis is an alpha field and requires enabling RecoverVolumeExpansionFailure feature."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='allocatedResources', type=d.T.object)]),
  withAllocatedResourcesMixin(allocatedResources): { allocatedResources+: allocatedResources },
  '#withCapacity':: d.fn(help='"capacity represents the actual resources of the underlying volume."', args=[d.arg(name='capacity', type=d.T.object)]),
  withCapacity(capacity): { capacity: capacity },
  '#withCapacityMixin':: d.fn(help='"capacity represents the actual resources of the underlying volume."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='capacity', type=d.T.object)]),
  withCapacityMixin(capacity): { capacity+: capacity },
  '#withConditions':: d.fn(help="\"conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.\"", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditions(conditions): { conditions: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withConditionsMixin':: d.fn(help="\"conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditionsMixin(conditions): { conditions+: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withCurrentVolumeAttributesClassName':: d.fn(help='"currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is an alpha field and requires enabling VolumeAttributesClass feature."', args=[d.arg(name='currentVolumeAttributesClassName', type=d.T.string)]),
  withCurrentVolumeAttributesClassName(currentVolumeAttributesClassName): { currentVolumeAttributesClassName: currentVolumeAttributesClassName },
  '#withPhase':: d.fn(help='"phase represents the current phase of PersistentVolumeClaim."', args=[d.arg(name='phase', type=d.T.string)]),
  withPhase(phase): { phase: phase },
  '#mixin': 'ignore',
  mixin: self,
}
