{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='limitRangeItem', url='', help='"LimitRangeItem defines a min/max usage limit for any resource that matches on kind."'),
  '#withDefault':: d.fn(help='"Default resource requirement limit value by resource name if resource limit is omitted."', args=[d.arg(name='default', type=d.T.object)]),
  withDefault(default): { default: default },
  '#withDefaultMixin':: d.fn(help='"Default resource requirement limit value by resource name if resource limit is omitted."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='default', type=d.T.object)]),
  withDefaultMixin(default): { default+: default },
  '#withDefaultRequest':: d.fn(help='"DefaultRequest is the default resource requirement request value by resource name if resource request is omitted."', args=[d.arg(name='defaultRequest', type=d.T.object)]),
  withDefaultRequest(defaultRequest): { defaultRequest: defaultRequest },
  '#withDefaultRequestMixin':: d.fn(help='"DefaultRequest is the default resource requirement request value by resource name if resource request is omitted."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='defaultRequest', type=d.T.object)]),
  withDefaultRequestMixin(defaultRequest): { defaultRequest+: defaultRequest },
  '#withMax':: d.fn(help='"Max usage constraints on this kind by resource name."', args=[d.arg(name='max', type=d.T.object)]),
  withMax(max): { max: max },
  '#withMaxLimitRequestRatio':: d.fn(help='"MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource."', args=[d.arg(name='maxLimitRequestRatio', type=d.T.object)]),
  withMaxLimitRequestRatio(maxLimitRequestRatio): { maxLimitRequestRatio: maxLimitRequestRatio },
  '#withMaxLimitRequestRatioMixin':: d.fn(help='"MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='maxLimitRequestRatio', type=d.T.object)]),
  withMaxLimitRequestRatioMixin(maxLimitRequestRatio): { maxLimitRequestRatio+: maxLimitRequestRatio },
  '#withMaxMixin':: d.fn(help='"Max usage constraints on this kind by resource name."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='max', type=d.T.object)]),
  withMaxMixin(max): { max+: max },
  '#withMin':: d.fn(help='"Min usage constraints on this kind by resource name."', args=[d.arg(name='min', type=d.T.object)]),
  withMin(min): { min: min },
  '#withMinMixin':: d.fn(help='"Min usage constraints on this kind by resource name."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='min', type=d.T.object)]),
  withMinMixin(min): { min+: min },
  '#withType':: d.fn(help='"Type of resource that this limit applies to."', args=[d.arg(name='type', type=d.T.string)]),
  withType(type): { type: type },
  '#mixin': 'ignore',
  mixin: self,
}
