// Code generated by "go generate robpike.io/ivy/parse"; DO NOT EDIT.

package parse

var helpLines = []string{
	"Ivy is an interpreter for an APL-like language. It is a plaything and a work in",
	"progress.",
	"",
	"Unlike APL, the input is ASCII and the results are exact (but see",
	"the next paragraph).  It uses exact rational arithmetic so it can",
	"handle arbitrary precision. Values to be input may be integers (3,",
	"-1), rationals (1/3, -45/67) or floating point values (1e3, -1.5",
	"(representing 1000 and -3/2)).",
	"",
	"Some functions such as sqrt are irrational. When ivy evaluates an",
	"irrational function, the result is stored in a high-precision",
	"floating-point number (default 256 bits of mantissa). Thus when",
	"using irrational functions, the values have high precision but are",
	"not exact.",
	"",
	"Unlike in most other languages, operators always have the same",
	"precedence and expressions are evaluated in right-associative order.",
	"That is, unary operators apply to everything to the right, and",
	"binary operators apply to the operand immediately to the left and",
	"to everything to the right.  Thus, 3*4+5 is 27 (it groups as 3*(4+5))",
	"and iota 3+2 is 1 2 3 4 5 while 3+iota 2 is 4 5. A vector is a",
	"single operand, so 1 2 3 + 3 + 3 4 5 is (1 2 3) + 3 + (3 4 5), or",
	"7 9 11.",
	"",
	"As a special but important case, note that 1/3, with no intervening",
	"spaces, is a single rational number, not the expression 1 divided",
	"by 3. This can affect precedence: 3/6*4 is 2 while 3 / 6*4 is 1/8",
	"since the spacing turns the / into a division operator. Use parentheses",
	"or spaces to disambiguate: 3/(6*4) or 3 /6*4.",
	"",
	"Ivy has complex numbers, which are constructed using the unary or",
	"binary j operator. As with rationals, the token 1j2 (the representation",
	"of 1+2i) is a single token. The individual parts can be rational,",
	"so 1/2j-3/2 is the complex number 0.5-1.5i and scans as a single",
	"value.",
	"",
	"Indexing uses [] notation: x[1], x[1; 2], and so on. Indexing by a",
	"vector selects multiple elements: x[1 2] creates a new item from",
	"x[1] and x[2]. An empty index slot is a shorthand for all the",
	"elements along that dimension, so x[] is equivalent to x, and x[;3]",
	"gives the third column of two-dimensional array x.",
	"",
	"Only a subset of APL's functionality is implemented, but all numerical",
	"operations are supported.",
	"",
	"Semicolons separate multiple statements on a line. Variables are",
	"alphanumeric and are assigned with the = operator. Assignment is",
	"an expression.",
	"",
	"After each successful expression evaluation, the result is stored",
	"in the variable called _ (underscore) so it can be used in the next",
	"expression.",
	"",
	"The APL operators, adapted from",
	"https://en.wikipedia.org/wiki/APL_syntax_and_symbols, and their",
	"correspondence are listed here. The correspondence is incomplete",
	"and inexact.",
	"",
	"Unary operators",
	"",
	"\tName              APL   Ivy     Meaning",
	"\tRoll              ?B    ?       One integer selected randomly from the first B integers",
	"\tCeiling           ⌈B    ceil    Least integer greater than or equal to B",
	"\t                                If B is complex, the complex ceiling, as defined by McDonnell",
	"\tFloor             ⌊B    floor   Greatest integer less than or equal to B",
	"\t                                If B is complex, the complex floor, as defined by McDonnell",
	"\tShape             ⍴B    rho     Vector of number of components in each dimension of B",
	"\tCount             ≢B    count   Scalar number of elements at top level of B",
	"\tFlatten           ∊B    flatten Vector of all the scalar elements within B",
	"\tNot               ∼B    not     Logical: not 1 is 0, not 0 is 1",
	"\tAbsolute value    ∣B    abs     Magnitude of B",
	"\tIndex generator   ⍳B    iota    Vector of the first B integers",
	"\t                                If B is a vector, matrix of coordinates",
	"\tUnique            ∪B    unique  Remove all duplicate elements from B",
	"\tEnclose           ⊂B    box     Wrap B in one level of nesting",
	"\tDisclose          ⊃B    first   First element of B in ravel order",
	"\tSplit             ↓B    split   Create vector of nested elements from matrix B; inverse of mix",
	"\tMix               ↑B    mix     Create matrix from elements of vector B; inverse of split",
	"\tExponential       ⋆B    **      e to the B power",
	"\tNegation          −B    -       Change sign of B",
	"\tIdentity          +B    +       No change to B",
	"\tSignum            ×B    sgn     -1 if B<0; 0 if B=0; 1 if B>0. More generally: B/abs B if B!=0",
	"\tReciprocal        ÷B    /       1 divided by B",
	"\tRavel             ,B    ,       Reshapes B into a vector",
	"\tMatrix inverse    ⌹B    inv     Inverse of B; for vector (conj v)/v+.*conj v",
	"\tPi times          ○B            Multiply by π",
	"\tLogarithm         ⍟B    log     Natural logarithm of B",
	"\tReversal          ⌽B    rot     Reverse elements of B along last axis",
	"\tReversal          ⊖B    flip    Reverse elements of B along first axis",
	"\tGrade up          ⍋B    up      Indices of B which will arrange B in ascending order",
	"\tGrade down        ⍒B    down    Indices of B which will arrange B in descending order",
	"\tExecute           ⍎B    ivy     Execute an APL (ivy) expression",
	"\tMonadic format    ⍕B    text    A character representation of B",
	"\tMonadic transpose ⍉B    transp  Reverse the axes of B",
	"\tFactorial         !B    !       Product of integers 1 to B",
	"\tBitwise not             ^       Bitwise complement of B (integer only)",
	"\tSquare root       B⋆.5  sqrt    Square root of B.",
	"\tSine                    sin     sin(A); APL uses binary ○ (see below)",
	"\tCosine                  cos     cos(A); ditto",
	"\tTangent                 tan     tan(A); ditto",
	"\tArcsine                 asin    arcsin(B)",
	"\tArccosine               acos    arccos(B)",
	"\tArctangent              atan    arctan(B)",
	"\tHyperbolic sine         sinh    sinh(B)",
	"\tHyperbolic cosine       cosh    cosh(B)",
	"\tHyperbolic tangent      tanh    tanh(B)",
	"\tHyperbolic arcsine      asinh   arcsinh(B)",
	"\tHyperbolic arccosine    acosh   arccosh(B)",
	"\tHyperbolic arctangent   atanh   arctanh(B)",
	"\tRotation by 90°         j       Multiplication by sqrt(-1)",
	"\tReal part               real    Real component of the value",
	"\tImaginary part          imag    Imaginary component of the value",
	"\tPhase                   phase   Phase of the value in the complex plane (-π to π)",
	"\tConjugate         +B    conj    Complex conjugate of the value",
	"\tSystem functions  ⎕     sys     Argument is a string; run \"sys 'help'\" for details",
	"",
	"Binary operators",
	"",
	"\tName                  APL   Ivy       Meaning",
	"\tAdd                   A+B   +         Sum of A and B",
	"\tSubtract              A−B   -         A minus B",
	"\tMultiply              A×B   *         A multiplied by B",
	"\tDivide                A÷B   /         A divided by B (exact rational division)",
	"\t                            div       A divided by B (Euclidean)",
	"\t                            idiv      A divided by B (Go)",
	"\tExponentiation        A⋆B   **        A raised to the B power",
	"\tCircle                A○B             Trigonometric functions of B selected by A",
	"\t                                      A=1: sin(B) A=2: cos(B) A=3: tan(B); ¯A for inverse",
	"\t                            sin       sin(B); ivy uses traditional name.",
	"\t                            cos       cos(B); ivy uses traditional name.",
	"\t                            tan       tan(B); ivy uses traditional name.",
	"\tDeal                  A?B   ?         A distinct integers selected randomly from the first B integers",
	"\tMembership            A∈B   in        1 for elements of A present in B; 0 where not.",
	"\tIntersection          A∩B   intersect A with all elements that are also in B removed",
	"\tUnion                 A∪B   union     A followed by all members of B not already in A",
	"\tMaximum               A⌈B   max       The greater value of A or B",
	"\tMinimum               A⌊B   min       The smaller value of A or B",
	"\tReshape               A⍴B   rho       Array of shape A with data B",
	"\tTake                  A↑B   take      Select the first (or last) A elements of B according to sgn A",
	"\tDrop                  A↓B   drop      Remove the first (or last) A elements of B according to sgn A",
	"\tDecode                A⊥B   decode    Value of a polynomial whose coefficients are B at A",
	"\t                                      'T' decode B creates a seconds value from the time vector B",
	"\tEncode                A⊤B   encode    Base-A representation of the value of B",
	"\t                                      'T' encode B creates a time vector from the seconds value B",
	"\tResidue               A∣B              B modulo A",
	"\t                            mod       A modulo B (Euclidean)",
	"\t                            imod      A modulo B (Go)",
	"\tCatenation            A,B   ,         Elements of B appended to the elements of A along last axis",
	"\tCatenation            A,B   ,%        Elements of B appended to the elements of A along first axis",
	"\tExpansion             A\\B   fill      Insert zeros (or blanks) in B corresponding to zeros in A",
	"\t                                      In ivy: abs(A) gives count, A <= 0 inserts zero (or blank)",
	"\tCompression           A/B   sel       Select elements in B corresponding to ones in A",
	"\t                                      In ivy: abs(A) gives count, A <= 0 inserts zero",
	"\tIndex of              A⍳B   iota      The location (index) of B in A; 1+⌈/⍳⍴A if not found",
	"\t                                      In ivy: origin-1 if not found (i.e. 0 if one-indexed)",
	"\tMatrix divide         A⌹B   mdiv      Solution to system of linear equations Ax = B",
	"\t                                      For real vectors, the magnitude of A projected on B",
	"\tRotation              A⌽B   rot       The elements of B are rotated A positions left",
	"\tRotation              A⊖B   flip      The elements of B are rotated A positions along the first axis",
	"\tLogarithm             A⍟B   log       Logarithm of B to base A",
	"\tDyadic format         A⍕B   text      Format B into a character matrix according to A",
	"\t                                      A is the textual format (see format special command);",
	"\t                                      otherwise result depends on length of A:",
	"\t                                      1 gives decimal count, 2 gives width and decimal count,",
	"\t                                      3 gives width, decimal count, and style ('d', 'e', 'f', etc.).",
	"\t                                      'T' text B formats seconds value B as a Unix date",
	"\tGeneral transpose     A⍉B   transp    The axes of B are ordered by A",
	"\tCombinations          A!B   !         Number of combinations of B taken A at a time",
	"\tLess than             A<B   <         Comparison: 1 if true, 0 if false",
	"\tLess than or equal    A≤B   <=        Comparison: 1 if true, 0 if false",
	"\tEqual                 A=B   ==        Comparison: 1 if true, 0 if false",
	"\tGreater than or equal A≥B   >=        Comparison: 1 if true, 0 if false",
	"\tGreater than          A>B   >         Comparison: 1 if true, 0 if false",
	"\tNot equal             A≠B   !=        Comparison: 1 if true, 0 if false",
	"\tOr                    A∨B   or        Logic: 0 if A and B are 0; 1 otherwise",
	"\tAnd                   A∧B   and       Logic: 1 if A and B are 1; 0 otherwise",
	"\tNor                   A⍱B   nor       Logic: 1 if both A and B are 0; otherwise 0",
	"\tNand                  A⍲B   nand      Logic: 0 if both A and B are 1; otherwise 1",
	"\tXor                         xor       Logic: 1 if A != B; otherwise 0",
	"\tBitwise and                 &         Bitwise A and B (integer only)",
	"\tBitwise or                  |         Bitwise A or B (integer only)",
	"\tBitwise xor                 ^         Bitwise A exclusive or B (integer only)",
	"\tLeft shift                  <<        A shifted left B bits (integer only)",
	"\tRight Shift                 >>        A shifted right B bits (integer only)",
	"\tComplex construction        j         The complex number A+Bi",
	"",
	"Operators and axis indicator",
	"",
	"\tName                APL  Ivy  APL Example  Ivy Example  Meaning (of example)",
	"\tReduce (last axis)  /    /    +/B          +/B          Sum across B",
	"\tReduce (first axis) ⌿    /%   +⌿B                       Sum down B",
	"\tScan (last axis)    \\    \\    +\\B          +\\B          Running sum across B",
	"\tScan (first axis)   ⍀    \\%   +⍀B                       Running sum down B",
	"\tInner product       .    .    A+.×B        A +.* B      Matrix product of A and B",
	"\tOuter product       ∘.   o.   A∘.×B        A o.* B      Outer product of A and B",
	"\t                                                       (lower case o; may need preceding space)",
	"",
	"Type-converting operations",
	"",
	"\tName              APL   Ivy     Meaning",
	"\tCode                    code B  The integer Unicode value of char B",
	"\tChar                    char B  The character with integer Unicode value B",
	"\tFloat                   float B The floating-point representation of B;",
	"\t                                for complex numbers, the result is",
	"\t                                (float A)j(float B)",
	"",
	"# Pre-defined constants",
	"",
	"The constants e (base of natural logarithms) and pi (π) are pre-defined to high",
	"precision, about 3000 decimal digits truncated according to the floating point",
	"precision setting.",
	"",
	"# Character data",
	"",
	"Strings are vectors of \"chars\", which are Unicode code points (not bytes).",
	"Syntactically, string literals are very similar to those in Go, with back-quoted",
	"raw strings and double-quoted interpreted strings. Unlike Go, single-quoted strings",
	"are equivalent to double-quoted, a nod to APL syntax. A string with a single char",
	"is just a singleton char value; all others are vectors. Thus “, \"\", and ” are",
	"empty vectors, `a`, \"a\", and 'a' are equivalent representations of a single char,",
	"and `ab`, `a` `b`, \"ab\", \"a\" \"b\", 'ab', and 'a' 'b' are equivalent representations",
	"of a two-char vector.",
	"",
	"Unlike in Go, a string in ivy comprises code points, not bytes; as such it can",
	"contain only valid Unicode values. Thus in ivy \"\\x80\" is illegal, although it is",
	"a legal one-byte string in Go.",
	"",
	"Strings can be printed. If a vector contains only chars, it is printed without",
	"spaces between them.",
	"",
	"Chars have restricted operations. Printing, comparison, indexing and so on are",
	"legal but arithmetic is not, and chars cannot be converted automatically into other",
	"singleton values (ints, floats, and so on). The unary operators char and code",
	"enable transcoding between integer and char values.",
	"",
	"# User-defined operators",
	"",
	"Users can define unary and binary operators, which then behave just like",
	"built-in operators. Both a unary and a binary operator may be defined for the",
	"same name.",
	"",
	"The syntax of a definition is the 'op' keyword, the operator and formal",
	"arguments, an equals sign, and then the body. The names of the operator and its",
	"arguments must be identifiers.  For unary operators, write \"op name arg\"; for",
	"binary write \"op leftarg name rightarg\". The final expression in the body is the",
	"return value. Operators may have recursive definitions; see the paragraph",
	"about conditional execution for an example.",
	"",
	"The body may be a single line (possibly containing semicolons) on the same line",
	"as the 'op', or it can be multiple lines. For a multiline entry, there is a",
	"newline after the '=' and the definition ends at the first blank line (ignoring",
	"spaces).",
	"",
	"Conditional execution is done with the \":\" binary conditional return operator,",
	"which is valid only within the code for a user-defined operator. The left",
	"operand must be a scalar. If it is non-zero, the right operand is returned as",
	"the value of the function. Otherwise, execution continues normally. The \":\"",
	"operator has a lower precedence than any other operator; in effect it breaks",
	"the line into two separate expressions.",
	"",
	"Example: average of a vector (unary):",
	"",
	"\top avg x = (+/x)/rho x",
	"\tavg iota 11",
	"\tresult: 6",
	"",
	"Example: n largest entries in a vector (binary):",
	"",
	"\top n largest x = n take x[down x]",
	"\t3 largest 7 1 3 24 1 5 12 5 51",
	"\tresult: 51 24 12",
	"",
	"Example: multiline operator definition (binary):",
	"",
	"\top a sum b =",
	"\t\ta = a+b",
	"\t\ta",
	"",
	"\tiota 3 sum 4",
	"\tresult: 1 2 3 4 5 6 7",
	"",
	"Example: primes less than N (unary):",
	"",
	"\top primes N = (not T in T o.* T) sel T = 1 drop iota N",
	"\tprimes 50",
	"\tresult: 2 3 5 7 11 13 17 19 23 29 31 37 41 43 47",
	"",
	"Example: greatest common divisor (binary):",
	"",
	"\top a gcd b =",
	"\t\ta == b: a",
	"\t\ta > b: b gcd a-b",
	"\t\ta gcd b-a",
	"",
	"\t1562 gcd !11",
	"\tresult: 22",
	"",
	"On mobile platforms only, due to I/O restrictions, user-defined operators",
	"must be presented on a single line. Use semicolons to separate expressions:",
	"",
	"\top a gcd b = a == b: a; a > b: b gcd a-b; a gcd b-a",
	"",
	"To declare an operator but not define it, omit the equals sign and what follows.",
	"",
	"\top foo x",
	"\top bar x = foo x",
	"\top foo x = -x",
	"\tbar 3",
	"\tresult: -3",
	"\top foo x = /x",
	"\tbar 3",
	"\tresult: 1/3",
	"",
	"Within a user-defined operator body, identifiers are local to the invocation",
	"if they are assigned before being read, and global if read before being written.",
	"To write to a global without reading it first, insert an unused read.",
	"",
	"\ttotal = 0",
	"\tlast = 0",
	"\top save x =",
	"\t\ttotal = total + x  # total is global because total is read before written",
	"\t\tlast; last = x     # unused read makes last global",
	"",
	"\tsave 9; save 3",
	"\ttotal last",
	"\tresult: 12 3",
	"",
	"To remove the definition of a unary or binary user-defined operator,",
	"",
	"\topdelete foo x",
	"\topdelete a gcd b",
	"",
	"# Special commands",
	"",
	"Ivy accepts a number of special commands, introduced by a right paren",
	"at the beginning of the line. Most report the current value if a new value",
	"is not specified. For these commands, numbers are always read and printed",
	"base 10 and must be non-negative on input.",
	"",
	"\t) help",
	"\t\tDescribe the special commands. Run )help <topic> to learn more",
	"\t\tabout a topic, )help <op> to learn more about an operator.",
	"\t) base 0",
	"\t\tSet the number base for input and output. The commands ibase and",
	"\t\tobase control setting of the base for input and output alone,",
	"\t\trespectively.  Base 0 allows C-style input: decimal, with 037 being",
	"\t\toctal and 0x10 being hexadecimal. Bases above 16 are disallowed.",
	"\t\tTo output large integers and rationals, base must be one of",
	"\t\t0 2 8 10 16. Floats are always printed base 10.",
	"\t) cpu",
	"\t\tPrint the duration of the last interactive calculation.",
	"\t) debug name 0|1",
	"\t\tToggle or set the named debugging flag. With no argument, lists",
	"\t\tthe settings.",
	"\t) demo",
	"\t\tRun a line-by-line interactive demo. On mobile platforms,",
	"\t\tuse the Demo menu option instead.",
	"\t) format \"\"",
	"\t\tSet the format for printing values. If empty, the output is printed",
	"\t\tusing the output base. If non-empty, the format determines the",
	"\t\tbase used in printing. The format is in the style of golang.org/pkg/fmt.",
	"\t\tFor floating-point formats, flags and width are ignored.",
	"\t) get \"save.ivy\"",
	"\t\tRead input from the named file; return to interactive execution",
	"\t\tafterwards. If no file is specified, read from \"save.ivy\".",
	"\t\t(Unimplemented on mobile.)",
	"\t) maxbits 1e6",
	"\t\tTo avoid consuming too much memory, if an integer result would",
	"\t\trequire more than this many bits to store, abort the calculation.",
	"\t\tIf maxbits is 0, there is no limit; the default is 1e6.",
	"\t) maxdigits 1e4",
	"\t\tTo avoid overwhelming amounts of output, if an integer has more",
	"\t\tthan this many digits, print it using the defined floating-point",
	"\t\tformat. If maxdigits is 0, integers are always printed as integers.",
	"\t) maxstack 1e5",
	"\t\tTo avoid using too much stack, the number of nested active calls to",
	"\t\tuser-defined operators is limited to maxstack.",
	"\t) op X",
	"\t\tIf X is absent, list all user-defined operators. Otherwise,",
	"\t\tshow the definition of the user-defined operator X. Inside the",
	"\t\tdefinition, numbers are always shown base 10, ignoring the ibase",
	"\t\tand obase.",
	"\t) origin 1",
	"\t\tSet the origin for indexing a vector or matrix. Must be non-negative.",
	"\t) prec 256",
	"\t\tSet the precision (mantissa length) for floating-point values.",
	"\t\tThe value is in bits. The exponent always has 32 bits.",
	"\t) prompt \"\"",
	"\t\tSet the interactive prompt.",
	"\t) save \"save.ivy\"",
	"\t\tWrite definitions of user-defined operators and variables to the",
	"\t\tnamed file, as ivy textual source. If no file is specified, save to",
	"\t\t\"save.ivy\".",
	"\t\t(Unimplemented on mobile.)",
	"\t) seed 0",
	"\t\tSet the seed for the ? operator.",
	"\t) timezone \"Local\"",
	"\t\tSet the time zone to be used for display. If the argument is",
	"\t\tmissing, print the name and zone offset in seconds east.",
	"\t) var X",
	"\t\tIf X is absent, list all defined variables. Otherwise, show the",
	"\t\tdefinition of the variable X in a form that can be evaluated",
	"\t\tto recreate the value.",
}

type helpIndexPair struct {
	start, end int
}

var helpUnary = map[string]helpIndexPair{
	"?":       {61, 61},
	"ceil":    {62, 63},
	"floor":   {64, 65},
	"rho":     {66, 66},
	"count":   {67, 67},
	"flatten": {68, 68},
	"not":     {69, 69},
	"abs":     {70, 70},
	"iota":    {71, 72},
	"unique":  {73, 73},
	"box":     {74, 74},
	"first":   {75, 75},
	"split":   {76, 76},
	"mix":     {77, 77},
	"**":      {78, 78},
	"-":       {79, 79},
	"+":       {80, 80},
	"sgn":     {81, 81},
	"/":       {82, 82},
	",":       {83, 83},
	"inv":     {84, 84},
	"log":     {86, 86},
	"rot":     {87, 87},
	"flip":    {88, 88},
	"up":      {89, 89},
	"down":    {90, 90},
	"ivy":     {91, 91},
	"text":    {92, 92},
	"transp":  {93, 93},
	"!":       {94, 94},
	"^":       {95, 95},
	"sqrt":    {96, 96},
	"sin":     {97, 97},
	"cos":     {98, 98},
	"tan":     {99, 99},
	"asin":    {100, 100},
	"acos":    {101, 101},
	"atan":    {102, 102},
	"sinh":    {103, 103},
	"cosh":    {104, 104},
	"tanh":    {105, 105},
	"asinh":   {106, 106},
	"acosh":   {107, 107},
	"atanh":   {108, 108},
	"j":       {109, 109},
	"real":    {110, 110},
	"imag":    {111, 111},
	"phase":   {112, 112},
	"conj":    {113, 113},
	"sys":     {114, 114},
	"code":    {200, 200},
	"char":    {201, 201},
	"float":   {202, 204},
}

var helpBinary = map[string]helpIndexPair{
	"+":         {119, 119},
	"-":         {120, 120},
	"*":         {121, 121},
	"/":         {122, 124},
	"**":        {125, 125},
	"?":         {131, 131},
	"in":        {132, 132},
	"intersect": {133, 133},
	"union":     {134, 134},
	"max":       {135, 135},
	"min":       {136, 136},
	"rho":       {137, 137},
	"take":      {138, 138},
	"drop":      {139, 139},
	"decode":    {140, 141},
	"encode":    {142, 143},
	"mod":       {145, 146},
	",":         {147, 147},
	",%":        {148, 148},
	"fill":      {149, 150},
	"sel":       {151, 152},
	"iota":      {153, 154},
	"mdiv":      {155, 156},
	"rot":       {157, 157},
	"flip":      {158, 158},
	"log":       {159, 159},
	"text":      {160, 165},
	"transp":    {166, 166},
	"!":         {167, 167},
	"<":         {168, 168},
	"<=":        {169, 169},
	"==":        {170, 170},
	">=":        {171, 171},
	">":         {172, 172},
	"!=":        {173, 173},
	"or":        {174, 174},
	"and":       {175, 175},
	"nor":       {176, 176},
	"nand":      {177, 177},
	"xor":       {178, 178},
	"&":         {179, 179},
	"|":         {180, 180},
	"^":         {181, 181},
	"<<":        {182, 182},
	">>":        {183, 183},
	"j":         {184, 184},
}

var helpAxis = map[string]helpIndexPair{
	"/":   {189, 189},
	"/%":  {190, 190},
	"\\":  {191, 191},
	"\\%": {192, 192},
	".":   {193, 193},
	"o.":  {194, 194},
}
