// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        (unknown)
// source: pkg/apis/istio/v1alpha1/values_types.proto

package v1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Mode for the ingress controller.
type IngressControllerMode int32

const (
	// Unspecified Istio ingress controller.
	IngressControllerMode_UNSPECIFIED IngressControllerMode = 0
	// Selects all Ingress resources, with or without Istio annotation.
	IngressControllerMode_DEFAULT IngressControllerMode = 1
	// Selects only resources with istio annotation.
	IngressControllerMode_STRICT IngressControllerMode = 2
	// No ingress or sync.
	IngressControllerMode_OFF IngressControllerMode = 3
)

// Enum value maps for IngressControllerMode.
var (
	IngressControllerMode_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "DEFAULT",
		2: "STRICT",
		3: "OFF",
	}
	IngressControllerMode_value = map[string]int32{
		"UNSPECIFIED": 0,
		"DEFAULT":     1,
		"STRICT":      2,
		"OFF":         3,
	}
)

func (x IngressControllerMode) Enum() *IngressControllerMode {
	p := new(IngressControllerMode)
	*p = x
	return p
}

func (x IngressControllerMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngressControllerMode) Descriptor() protoreflect.EnumDescriptor {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[0].Descriptor()
}

func (IngressControllerMode) Type() protoreflect.EnumType {
	return &file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[0]
}

func (x IngressControllerMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngressControllerMode.Descriptor instead.
func (IngressControllerMode) EnumDescriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{0}
}

// Specifies which tracer to use.
type Tracer int32

const (
	Tracer_zipkin          Tracer = 0
	Tracer_lightstep       Tracer = 1
	Tracer_datadog         Tracer = 2
	Tracer_stackdriver     Tracer = 3
	Tracer_openCensusAgent Tracer = 4
	Tracer_none            Tracer = 5
)

// Enum value maps for Tracer.
var (
	Tracer_name = map[int32]string{
		0: "zipkin",
		1: "lightstep",
		2: "datadog",
		3: "stackdriver",
		4: "openCensusAgent",
		5: "none",
	}
	Tracer_value = map[string]int32{
		"zipkin":          0,
		"lightstep":       1,
		"datadog":         2,
		"stackdriver":     3,
		"openCensusAgent": 4,
		"none":            5,
	}
)

func (x Tracer) Enum() *Tracer {
	p := new(Tracer)
	*p = x
	return p
}

func (x Tracer) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tracer) Descriptor() protoreflect.EnumDescriptor {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[1].Descriptor()
}

func (Tracer) Type() protoreflect.EnumType {
	return &file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[1]
}

func (x Tracer) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tracer.Descriptor instead.
func (Tracer) EnumDescriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{1}
}

// Specifies the sidecar's default behavior when handling outbound traffic from the application.
type OutboundTrafficPolicyConfig_Mode int32

const (
	// Outbound traffic to unknown destinations will be allowed, in case there are no services or ServiceEntries for the destination port
	OutboundTrafficPolicyConfig_ALLOW_ANY OutboundTrafficPolicyConfig_Mode = 0
	// Restrict outbound traffic to services defined in the service registry as well as those defined through ServiceEntries
	OutboundTrafficPolicyConfig_REGISTRY_ONLY OutboundTrafficPolicyConfig_Mode = 1
)

// Enum value maps for OutboundTrafficPolicyConfig_Mode.
var (
	OutboundTrafficPolicyConfig_Mode_name = map[int32]string{
		0: "ALLOW_ANY",
		1: "REGISTRY_ONLY",
	}
	OutboundTrafficPolicyConfig_Mode_value = map[string]int32{
		"ALLOW_ANY":     0,
		"REGISTRY_ONLY": 1,
	}
)

func (x OutboundTrafficPolicyConfig_Mode) Enum() *OutboundTrafficPolicyConfig_Mode {
	p := new(OutboundTrafficPolicyConfig_Mode)
	*p = x
	return p
}

func (x OutboundTrafficPolicyConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutboundTrafficPolicyConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[2].Descriptor()
}

func (OutboundTrafficPolicyConfig_Mode) Type() protoreflect.EnumType {
	return &file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[2]
}

func (x OutboundTrafficPolicyConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutboundTrafficPolicyConfig_Mode.Descriptor instead.
func (OutboundTrafficPolicyConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{19, 0}
}

// Types of Access logs to export.
type TelemetryV2StackDriverConfig_AccessLogging int32

const (
	// No Logs.
	TelemetryV2StackDriverConfig_NONE TelemetryV2StackDriverConfig_AccessLogging = 0
	// All logs including both success and error logs.
	TelemetryV2StackDriverConfig_FULL TelemetryV2StackDriverConfig_AccessLogging = 1
	// All error logs. This is currently only available for outbound/client side
	// logs. A request is classified as error when `status>=400 or
	// response_flag != "-"`
	TelemetryV2StackDriverConfig_ERRORS_ONLY TelemetryV2StackDriverConfig_AccessLogging = 2
)

// Enum value maps for TelemetryV2StackDriverConfig_AccessLogging.
var (
	TelemetryV2StackDriverConfig_AccessLogging_name = map[int32]string{
		0: "NONE",
		1: "FULL",
		2: "ERRORS_ONLY",
	}
	TelemetryV2StackDriverConfig_AccessLogging_value = map[string]int32{
		"NONE":        0,
		"FULL":        1,
		"ERRORS_ONLY": 2,
	}
)

func (x TelemetryV2StackDriverConfig_AccessLogging) Enum() *TelemetryV2StackDriverConfig_AccessLogging {
	p := new(TelemetryV2StackDriverConfig_AccessLogging)
	*p = x
	return p
}

func (x TelemetryV2StackDriverConfig_AccessLogging) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TelemetryV2StackDriverConfig_AccessLogging) Descriptor() protoreflect.EnumDescriptor {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[3].Descriptor()
}

func (TelemetryV2StackDriverConfig_AccessLogging) Type() protoreflect.EnumType {
	return &file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes[3]
}

func (x TelemetryV2StackDriverConfig_AccessLogging) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TelemetryV2StackDriverConfig_AccessLogging.Descriptor instead.
func (TelemetryV2StackDriverConfig_AccessLogging) EnumDescriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{27, 0}
}

// ArchConfig specifies the pod scheduling target architecture(amd64, ppc64le, s390x, arm64)
// for all the Istio control plane components.
type ArchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sets pod scheduling weight for amd64 arch
	Amd64 uint32 `protobuf:"varint,1,opt,name=amd64,proto3" json:"amd64,omitempty"`
	// Sets pod scheduling weight for ppc64le arch.
	Ppc64Le uint32 `protobuf:"varint,2,opt,name=ppc64le,proto3" json:"ppc64le,omitempty"`
	// Sets pod scheduling weight for s390x arch.
	S390X uint32 `protobuf:"varint,3,opt,name=s390x,proto3" json:"s390x,omitempty"`
	// Sets pod scheduling weight for arm64 arch.
	Arm64 uint32 `protobuf:"varint,4,opt,name=arm64,proto3" json:"arm64,omitempty"`
}

func (x *ArchConfig) Reset() {
	*x = ArchConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchConfig) ProtoMessage() {}

func (x *ArchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchConfig.ProtoReflect.Descriptor instead.
func (*ArchConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{0}
}

func (x *ArchConfig) GetAmd64() uint32 {
	if x != nil {
		return x.Amd64
	}
	return 0
}

func (x *ArchConfig) GetPpc64Le() uint32 {
	if x != nil {
		return x.Ppc64Le
	}
	return 0
}

func (x *ArchConfig) GetS390X() uint32 {
	if x != nil {
		return x.S390X
	}
	return 0
}

func (x *ArchConfig) GetArm64() uint32 {
	if x != nil {
		return x.Arm64
	}
	return 0
}

// Configuration for CNI.
type CNIConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether CNI is enabled.
	Enabled           *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Hub               string                `protobuf:"bytes,2,opt,name=hub,proto3" json:"hub,omitempty"`
	Tag               *structpb.Value       `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
	Variant           string                `protobuf:"bytes,29,opt,name=variant,proto3" json:"variant,omitempty"`
	Image             string                `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	PullPolicy        string                `protobuf:"bytes,5,opt,name=pullPolicy,proto3" json:"pullPolicy,omitempty"`
	CniBinDir         string                `protobuf:"bytes,6,opt,name=cniBinDir,proto3" json:"cniBinDir,omitempty"`
	CniConfDir        string                `protobuf:"bytes,7,opt,name=cniConfDir,proto3" json:"cniConfDir,omitempty"`
	CniConfFileName   string                `protobuf:"bytes,8,opt,name=cniConfFileName,proto3" json:"cniConfFileName,omitempty"`
	ExcludeNamespaces []string              `protobuf:"bytes,9,rep,name=excludeNamespaces,proto3" json:"excludeNamespaces,omitempty"`
	// Deprecated: Do not use.
	PodAnnotations *structpb.Struct      `protobuf:"bytes,10,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	PspClusterRole string                `protobuf:"bytes,11,opt,name=psp_cluster_role,json=pspClusterRole,proto3" json:"psp_cluster_role,omitempty"`
	LogLevel       string                `protobuf:"bytes,12,opt,name=logLevel,proto3" json:"logLevel,omitempty"`
	Repair         *CNIRepairConfig      `protobuf:"bytes,13,opt,name=repair,proto3" json:"repair,omitempty"`
	Chained        *wrapperspb.BoolValue `protobuf:"bytes,14,opt,name=chained,proto3" json:"chained,omitempty"`
	Taint          *CNITaintConfig       `protobuf:"bytes,15,opt,name=taint,proto3" json:"taint,omitempty"`
	ResourceQuotas *ResourceQuotas       `protobuf:"bytes,16,opt,name=resource_quotas,json=resourceQuotas,proto3" json:"resource_quotas,omitempty"`
	Resources      *Resources            `protobuf:"bytes,17,opt,name=resources,proto3" json:"resources,omitempty"`
	Privileged     *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// The Container seccompProfile
	//
	// See: https://kubernetes.io/docs/tutorials/security/seccomp/
	SeccompProfile *structpb.Struct `protobuf:"bytes,19,opt,name=seccompProfile,proto3" json:"seccompProfile,omitempty"`
}

func (x *CNIConfig) Reset() {
	*x = CNIConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CNIConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CNIConfig) ProtoMessage() {}

func (x *CNIConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CNIConfig.ProtoReflect.Descriptor instead.
func (*CNIConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{1}
}

func (x *CNIConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *CNIConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *CNIConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *CNIConfig) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *CNIConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *CNIConfig) GetPullPolicy() string {
	if x != nil {
		return x.PullPolicy
	}
	return ""
}

func (x *CNIConfig) GetCniBinDir() string {
	if x != nil {
		return x.CniBinDir
	}
	return ""
}

func (x *CNIConfig) GetCniConfDir() string {
	if x != nil {
		return x.CniConfDir
	}
	return ""
}

func (x *CNIConfig) GetCniConfFileName() string {
	if x != nil {
		return x.CniConfFileName
	}
	return ""
}

func (x *CNIConfig) GetExcludeNamespaces() []string {
	if x != nil {
		return x.ExcludeNamespaces
	}
	return nil
}

// Deprecated: Do not use.
func (x *CNIConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

func (x *CNIConfig) GetPspClusterRole() string {
	if x != nil {
		return x.PspClusterRole
	}
	return ""
}

func (x *CNIConfig) GetLogLevel() string {
	if x != nil {
		return x.LogLevel
	}
	return ""
}

func (x *CNIConfig) GetRepair() *CNIRepairConfig {
	if x != nil {
		return x.Repair
	}
	return nil
}

func (x *CNIConfig) GetChained() *wrapperspb.BoolValue {
	if x != nil {
		return x.Chained
	}
	return nil
}

func (x *CNIConfig) GetTaint() *CNITaintConfig {
	if x != nil {
		return x.Taint
	}
	return nil
}

func (x *CNIConfig) GetResourceQuotas() *ResourceQuotas {
	if x != nil {
		return x.ResourceQuotas
	}
	return nil
}

func (x *CNIConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *CNIConfig) GetPrivileged() *wrapperspb.BoolValue {
	if x != nil {
		return x.Privileged
	}
	return nil
}

func (x *CNIConfig) GetSeccompProfile() *structpb.Struct {
	if x != nil {
		return x.SeccompProfile
	}
	return nil
}

type CNITaintConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether taint behavior is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *CNITaintConfig) Reset() {
	*x = CNITaintConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CNITaintConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CNITaintConfig) ProtoMessage() {}

func (x *CNITaintConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CNITaintConfig.ProtoReflect.Descriptor instead.
func (*CNITaintConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{2}
}

func (x *CNITaintConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

type CNIRepairConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether repair behavior is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Hub     string                `protobuf:"bytes,2,opt,name=hub,proto3" json:"hub,omitempty"`
	Tag     *structpb.Value       `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
	Image   string                `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Controls whether various repair behaviors are enabled.
	LabelPods bool `protobuf:"varint,5,opt,name=labelPods,proto3" json:"labelPods,omitempty"`
	// Deprecated: Do not use.
	CreateEvents        string `protobuf:"bytes,6,opt,name=createEvents,proto3" json:"createEvents,omitempty"`
	DeletePods          bool   `protobuf:"varint,7,opt,name=deletePods,proto3" json:"deletePods,omitempty"`
	BrokenPodLabelKey   string `protobuf:"bytes,8,opt,name=brokenPodLabelKey,proto3" json:"brokenPodLabelKey,omitempty"`
	BrokenPodLabelValue string `protobuf:"bytes,9,opt,name=brokenPodLabelValue,proto3" json:"brokenPodLabelValue,omitempty"`
	InitContainerName   string `protobuf:"bytes,10,opt,name=initContainerName,proto3" json:"initContainerName,omitempty"`
}

func (x *CNIRepairConfig) Reset() {
	*x = CNIRepairConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CNIRepairConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CNIRepairConfig) ProtoMessage() {}

func (x *CNIRepairConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CNIRepairConfig.ProtoReflect.Descriptor instead.
func (*CNIRepairConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{3}
}

func (x *CNIRepairConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *CNIRepairConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *CNIRepairConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *CNIRepairConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *CNIRepairConfig) GetLabelPods() bool {
	if x != nil {
		return x.LabelPods
	}
	return false
}

// Deprecated: Do not use.
func (x *CNIRepairConfig) GetCreateEvents() string {
	if x != nil {
		return x.CreateEvents
	}
	return ""
}

func (x *CNIRepairConfig) GetDeletePods() bool {
	if x != nil {
		return x.DeletePods
	}
	return false
}

func (x *CNIRepairConfig) GetBrokenPodLabelKey() string {
	if x != nil {
		return x.BrokenPodLabelKey
	}
	return ""
}

func (x *CNIRepairConfig) GetBrokenPodLabelValue() string {
	if x != nil {
		return x.BrokenPodLabelValue
	}
	return ""
}

func (x *CNIRepairConfig) GetInitContainerName() string {
	if x != nil {
		return x.InitContainerName
	}
	return ""
}

type ResourceQuotas struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether to create resource quotas or not for the CNI DaemonSet.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Pods    int64                 `protobuf:"varint,2,opt,name=pods,proto3" json:"pods,omitempty"`
}

func (x *ResourceQuotas) Reset() {
	*x = ResourceQuotas{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceQuotas) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceQuotas) ProtoMessage() {}

func (x *ResourceQuotas) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceQuotas.ProtoReflect.Descriptor instead.
func (*ResourceQuotas) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{4}
}

func (x *ResourceQuotas) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *ResourceQuotas) GetPods() int64 {
	if x != nil {
		return x.Pods
	}
	return 0
}

// Configuration for CPU target utilization for HorizontalPodAutoscaler target.
type CPUTargetUtilizationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// K8s utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	TargetAverageUtilization int32 `protobuf:"varint,1,opt,name=targetAverageUtilization,proto3" json:"targetAverageUtilization,omitempty"`
}

func (x *CPUTargetUtilizationConfig) Reset() {
	*x = CPUTargetUtilizationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CPUTargetUtilizationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CPUTargetUtilizationConfig) ProtoMessage() {}

func (x *CPUTargetUtilizationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CPUTargetUtilizationConfig.ProtoReflect.Descriptor instead.
func (*CPUTargetUtilizationConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{5}
}

func (x *CPUTargetUtilizationConfig) GetTargetAverageUtilization() int32 {
	if x != nil {
		return x.TargetAverageUtilization
	}
	return 0
}

// Mirrors Resources for unmarshaling.
type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Limits   map[string]string `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Requests map[string]string `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{6}
}

func (x *Resources) GetLimits() map[string]string {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *Resources) GetRequests() map[string]string {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Mirrors ServiceAccount for unmarshaling.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Annotations *structpb.Struct `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{7}
}

func (x *ServiceAccount) GetAnnotations() *structpb.Struct {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// DefaultPodDisruptionBudgetConfig specifies the default pod disruption budget configuration.
//
// See https://kubernetes.io/docs/concepts/workloads/pods/disruptions/
type DefaultPodDisruptionBudgetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether a PodDisruptionBudget with a default minAvailable value of 1 is created for each deployment.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *DefaultPodDisruptionBudgetConfig) Reset() {
	*x = DefaultPodDisruptionBudgetConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultPodDisruptionBudgetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultPodDisruptionBudgetConfig) ProtoMessage() {}

func (x *DefaultPodDisruptionBudgetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultPodDisruptionBudgetConfig.ProtoReflect.Descriptor instead.
func (*DefaultPodDisruptionBudgetConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{8}
}

func (x *DefaultPodDisruptionBudgetConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// DefaultResourcesConfig specifies the default k8s resources settings for all Istio control plane components.
type DefaultResourcesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// k8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	Requests *ResourcesRequestsConfig `protobuf:"bytes,1,opt,name=requests,proto3" json:"requests,omitempty"`
}

func (x *DefaultResourcesConfig) Reset() {
	*x = DefaultResourcesConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DefaultResourcesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultResourcesConfig) ProtoMessage() {}

func (x *DefaultResourcesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultResourcesConfig.ProtoReflect.Descriptor instead.
func (*DefaultResourcesConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{9}
}

func (x *DefaultResourcesConfig) GetRequests() *ResourcesRequestsConfig {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Configuration for an egress gateway.
type EgressGatewayConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether auto scaling with a HorizontalPodAutoscaler is enabled.
	AutoscaleEnabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=autoscaleEnabled,proto3" json:"autoscaleEnabled,omitempty"`
	// maxReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMax uint32 `protobuf:"varint,2,opt,name=autoscaleMax,proto3" json:"autoscaleMax,omitempty"`
	// minReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMin uint32 `protobuf:"varint,3,opt,name=autoscaleMin,proto3" json:"autoscaleMin,omitempty"`
	// K8s utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Do not use.
	Cpu           *CPUTargetUtilizationConfig `protobuf:"bytes,5,opt,name=cpu,proto3" json:"cpu,omitempty"`
	CustomService *wrapperspb.BoolValue       `protobuf:"bytes,6,opt,name=customService,proto3" json:"customService,omitempty"`
	// Controls whether an egress gateway is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Environment variables passed to the proxy container.
	Env    *structpb.Struct  `protobuf:"bytes,8,opt,name=env,proto3" json:"env,omitempty"`
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Name   string            `protobuf:"bytes,25,opt,name=name,proto3" json:"name,omitempty"`
	// K8s node selector.
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Do not use.
	NodeSelector *structpb.Struct `protobuf:"bytes,10,opt,name=nodeSelector,proto3" json:"nodeSelector,omitempty"`
	// K8s annotations for pods.
	//
	// See: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	//
	// Deprecated: Do not use.
	PodAnnotations *structpb.Struct `protobuf:"bytes,11,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	// Pod anti-affinity label selector.
	//
	// Specify the pod anti-affinity that allows you to constrain which nodes
	// your pod is eligible to be scheduled based on labels on pods that are
	// already running on the node rather than based on labels on nodes.
	// There are currently two types of anti-affinity:
	//
	//	"requiredDuringSchedulingIgnoredDuringExecution"
	//	"preferredDuringSchedulingIgnoredDuringExecution"
	//
	// which denote “hard” vs. “soft” requirements, you can define your values
	// in "podAntiAffinityLabelSelector" and "podAntiAffinityTermLabelSelector"
	// correspondingly.
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#affinity-and-anti-affinity
	//
	// Examples:
	// podAntiAffinityLabelSelector:
	//   - key: security
	//     operator: In
	//     values: S1,S2
	//     topologyKey: "kubernetes.io/hostname"
	//     This pod anti-affinity rule says that the pod requires not to be scheduled
	//     onto a node if that node is already running a pod with label having key
	//     “security” and value “S1”.
	//
	// Deprecated: Do not use.
	PodAntiAffinityLabelSelector []*structpb.Struct `protobuf:"bytes,12,rep,name=podAntiAffinityLabelSelector,proto3" json:"podAntiAffinityLabelSelector,omitempty"`
	// See PodAntiAffinityLabelSelector.
	//
	// Deprecated: Do not use.
	PodAntiAffinityTermLabelSelector []*structpb.Struct `protobuf:"bytes,13,rep,name=podAntiAffinityTermLabelSelector,proto3" json:"podAntiAffinityTermLabelSelector,omitempty"`
	// Ports Configuration for the egress gateway service.
	Ports []*PortsConfig `protobuf:"bytes,14,rep,name=ports,proto3" json:"ports,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Do not use.
	Resources *Resources `protobuf:"bytes,15,opt,name=resources,proto3" json:"resources,omitempty"`
	// Config for secret volume mounts.
	SecretVolumes []*SecretVolume `protobuf:"bytes,16,rep,name=secretVolumes,proto3" json:"secretVolumes,omitempty"`
	// Annotations to add to the egress gateway service.
	ServiceAnnotations *structpb.Struct `protobuf:"bytes,17,opt,name=serviceAnnotations,proto3" json:"serviceAnnotations,omitempty"`
	// Service type.
	//
	// See https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
	Type string `protobuf:"bytes,18,opt,name=type,proto3" json:"type,omitempty"`
	// Enables cross-cluster access using SNI matching.
	Zvpn *ZeroVPNConfig `protobuf:"bytes,19,opt,name=zvpn,proto3" json:"zvpn,omitempty"`
	// Deprecated: Do not use.
	Tolerations []*structpb.Struct `protobuf:"bytes,20,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Do not use.
	RollingMaxSurge *IntOrString `protobuf:"bytes,21,opt,name=rollingMaxSurge,proto3" json:"rollingMaxSurge,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Do not use.
	RollingMaxUnavailable *IntOrString          `protobuf:"bytes,22,opt,name=rollingMaxUnavailable,proto3" json:"rollingMaxUnavailable,omitempty"`
	ConfigVolumes         []*structpb.Struct    `protobuf:"bytes,23,rep,name=configVolumes,proto3" json:"configVolumes,omitempty"`
	AdditionalContainers  []*structpb.Struct    `protobuf:"bytes,24,rep,name=additionalContainers,proto3" json:"additionalContainers,omitempty"`
	RunAsRoot             *wrapperspb.BoolValue `protobuf:"bytes,26,opt,name=runAsRoot,proto3" json:"runAsRoot,omitempty"`
	// The injection template to use for the gateway. If not set, no injection will be performed.
	InjectionTemplate string          `protobuf:"bytes,27,opt,name=injectionTemplate,proto3" json:"injectionTemplate,omitempty"`
	ServiceAccount    *ServiceAccount `protobuf:"bytes,28,opt,name=serviceAccount,proto3" json:"serviceAccount,omitempty"`
}

func (x *EgressGatewayConfig) Reset() {
	*x = EgressGatewayConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EgressGatewayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressGatewayConfig) ProtoMessage() {}

func (x *EgressGatewayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressGatewayConfig.ProtoReflect.Descriptor instead.
func (*EgressGatewayConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{10}
}

func (x *EgressGatewayConfig) GetAutoscaleEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoscaleEnabled
	}
	return nil
}

func (x *EgressGatewayConfig) GetAutoscaleMax() uint32 {
	if x != nil {
		return x.AutoscaleMax
	}
	return 0
}

func (x *EgressGatewayConfig) GetAutoscaleMin() uint32 {
	if x != nil {
		return x.AutoscaleMin
	}
	return 0
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetCpu() *CPUTargetUtilizationConfig {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *EgressGatewayConfig) GetCustomService() *wrapperspb.BoolValue {
	if x != nil {
		return x.CustomService
	}
	return nil
}

func (x *EgressGatewayConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *EgressGatewayConfig) GetEnv() *structpb.Struct {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *EgressGatewayConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EgressGatewayConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetNodeSelector() *structpb.Struct {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetPodAntiAffinityLabelSelector() []*structpb.Struct {
	if x != nil {
		return x.PodAntiAffinityLabelSelector
	}
	return nil
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetPodAntiAffinityTermLabelSelector() []*structpb.Struct {
	if x != nil {
		return x.PodAntiAffinityTermLabelSelector
	}
	return nil
}

func (x *EgressGatewayConfig) GetPorts() []*PortsConfig {
	if x != nil {
		return x.Ports
	}
	return nil
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *EgressGatewayConfig) GetSecretVolumes() []*SecretVolume {
	if x != nil {
		return x.SecretVolumes
	}
	return nil
}

func (x *EgressGatewayConfig) GetServiceAnnotations() *structpb.Struct {
	if x != nil {
		return x.ServiceAnnotations
	}
	return nil
}

func (x *EgressGatewayConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *EgressGatewayConfig) GetZvpn() *ZeroVPNConfig {
	if x != nil {
		return x.Zvpn
	}
	return nil
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetTolerations() []*structpb.Struct {
	if x != nil {
		return x.Tolerations
	}
	return nil
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetRollingMaxSurge() *IntOrString {
	if x != nil {
		return x.RollingMaxSurge
	}
	return nil
}

// Deprecated: Do not use.
func (x *EgressGatewayConfig) GetRollingMaxUnavailable() *IntOrString {
	if x != nil {
		return x.RollingMaxUnavailable
	}
	return nil
}

func (x *EgressGatewayConfig) GetConfigVolumes() []*structpb.Struct {
	if x != nil {
		return x.ConfigVolumes
	}
	return nil
}

func (x *EgressGatewayConfig) GetAdditionalContainers() []*structpb.Struct {
	if x != nil {
		return x.AdditionalContainers
	}
	return nil
}

func (x *EgressGatewayConfig) GetRunAsRoot() *wrapperspb.BoolValue {
	if x != nil {
		return x.RunAsRoot
	}
	return nil
}

func (x *EgressGatewayConfig) GetInjectionTemplate() string {
	if x != nil {
		return x.InjectionTemplate
	}
	return ""
}

func (x *EgressGatewayConfig) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

// Configuration for gateways.
type GatewaysConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for an egress gateway.
	IstioEgressgateway *EgressGatewayConfig `protobuf:"bytes,1,opt,name=istio_egressgateway,json=istio-egressgateway,proto3" json:"istio_egressgateway,omitempty"`
	// Controls whether any gateways are enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Configuration for an ingress gateway.
	IstioIngressgateway *IngressGatewayConfig `protobuf:"bytes,4,opt,name=istio_ingressgateway,json=istio-ingressgateway,proto3" json:"istio_ingressgateway,omitempty"`
}

func (x *GatewaysConfig) Reset() {
	*x = GatewaysConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewaysConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewaysConfig) ProtoMessage() {}

func (x *GatewaysConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewaysConfig.ProtoReflect.Descriptor instead.
func (*GatewaysConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{11}
}

func (x *GatewaysConfig) GetIstioEgressgateway() *EgressGatewayConfig {
	if x != nil {
		return x.IstioEgressgateway
	}
	return nil
}

func (x *GatewaysConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *GatewaysConfig) GetIstioIngressgateway() *IngressGatewayConfig {
	if x != nil {
		return x.IstioIngressgateway
	}
	return nil
}

// Global Configuration for Istio components.
type GlobalConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies pod scheduling arch(amd64, ppc64le, s390x, arm64) and weight as follows:
	//
	//	0 - Never scheduled
	//	1 - Least preferred
	//	2 - No preference
	//	3 - Most preferred
	//
	// Deprecated: replaced by the affinity k8s settings which allows architecture nodeAffinity configuration of this behavior.
	//
	// Deprecated: Do not use.
	Arch *ArchConfig `protobuf:"bytes,1,opt,name=arch,proto3" json:"arch,omitempty"`
	// List of certSigners to allow "approve" action in the ClusterRole
	CertSigners         []string `protobuf:"bytes,68,rep,name=certSigners,proto3" json:"certSigners,omitempty"`
	ConfigRootNamespace string   `protobuf:"bytes,50,opt,name=configRootNamespace,proto3" json:"configRootNamespace,omitempty"`
	// Controls whether the server-side validation is enabled.
	ConfigValidation                *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=configValidation,proto3" json:"configValidation,omitempty"`
	DefaultConfigVisibilitySettings []string              `protobuf:"bytes,52,rep,name=defaultConfigVisibilitySettings,proto3" json:"defaultConfigVisibilitySettings,omitempty"`
	// Default k8s node selector for all the Istio control plane components
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Do not use.
	DefaultNodeSelector *structpb.Struct `protobuf:"bytes,6,opt,name=defaultNodeSelector,proto3" json:"defaultNodeSelector,omitempty"`
	// Specifies the default pod disruption budget configuration.
	//
	// Deprecated: Do not use.
	DefaultPodDisruptionBudget *DefaultPodDisruptionBudgetConfig `protobuf:"bytes,7,opt,name=defaultPodDisruptionBudget,proto3" json:"defaultPodDisruptionBudget,omitempty"`
	// Default k8s resources settings for all Istio control plane components.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Do not use.
	DefaultResources *DefaultResourcesConfig `protobuf:"bytes,9,opt,name=defaultResources,proto3" json:"defaultResources,omitempty"`
	// Deprecated: Do not use.
	DefaultTolerations []*structpb.Struct `protobuf:"bytes,55,rep,name=defaultTolerations,proto3" json:"defaultTolerations,omitempty"`
	// Specifies the docker hub for Istio images.
	Hub string `protobuf:"bytes,12,opt,name=hub,proto3" json:"hub,omitempty"`
	// Specifies the image pull policy for the Istio images. one of Always, Never, IfNotPresent.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated.
	//
	// More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
	ImagePullPolicy  string   `protobuf:"bytes,13,opt,name=imagePullPolicy,proto3" json:"imagePullPolicy,omitempty"` // ImagePullPolicy             v1.PullPolicy                 `json:"imagePullPolicy,omitempty"`
	ImagePullSecrets []string `protobuf:"bytes,37,rep,name=imagePullSecrets,proto3" json:"imagePullSecrets,omitempty"`
	// Specifies the default namespace for the Istio control plane components.
	IstioNamespace string                `protobuf:"bytes,14,opt,name=istioNamespace,proto3" json:"istioNamespace,omitempty"`
	LogAsJson      *wrapperspb.BoolValue `protobuf:"bytes,36,opt,name=logAsJson,proto3" json:"logAsJson,omitempty"`
	// Specifies the global logging level settings for the Istio control plane components.
	Logging *GlobalLoggingConfig `protobuf:"bytes,17,opt,name=logging,proto3" json:"logging,omitempty"`
	MeshID  string               `protobuf:"bytes,53,opt,name=meshID,proto3" json:"meshID,omitempty"`
	// Configure the mesh networks to be used by the Split Horizon EDS.
	//
	// The following example defines two networks with different endpoints association methods.
	// For `network1` all endpoints that their IP belongs to the provided CIDR range will be
	// mapped to network1. The gateway for this network example is specified by its public IP
	// address and port.
	// The second network, `network2`, in this example is defined differently with all endpoints
	// retrieved through the specified Multi-Cluster registry being mapped to network2. The
	// gateway is also defined differently with the name of the gateway service on the remote
	// cluster. The public IP for the gateway will be determined from that remote service (only
	// LoadBalancer gateway service type is currently supported, for a NodePort type gateway service,
	// it still need to be configured manually).
	//
	// meshNetworks:
	//
	//	network1:
	//	  endpoints:
	//	  - fromCidr: "192.168.0.1/24"
	//	  gateways:
	//	  - address: 1.1.1.1
	//	    port: 80
	//	network2:
	//	  endpoints:
	//	  - fromRegistry: reg1
	//	  gateways:
	//	  - registryServiceName: istio-ingressgateway.istio-system.svc.cluster.local
	//	    port: 443
	MeshNetworks *structpb.Struct `protobuf:"bytes,19,opt,name=meshNetworks,proto3" json:"meshNetworks,omitempty"`
	// Specifies the Configuration for Istio mesh across multiple clusters through Istio gateways.
	MultiCluster *MultiClusterConfig `protobuf:"bytes,22,opt,name=multiCluster,proto3" json:"multiCluster,omitempty"`
	Network      string              `protobuf:"bytes,39,opt,name=network,proto3" json:"network,omitempty"`
	// Custom DNS config for the pod to resolve names of services in other
	// clusters. Use this to add additional search domains, and other settings.
	// see https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#dns-config
	// This does not apply to gateway pods as they typically need a different
	// set of DNS settings than the normal application pods (e.g. in multicluster scenarios).
	PodDNSSearchNamespaces       []string              `protobuf:"bytes,43,rep,name=podDNSSearchNamespaces,proto3" json:"podDNSSearchNamespaces,omitempty"`
	OmitSidecarInjectorConfigMap *wrapperspb.BoolValue `protobuf:"bytes,38,opt,name=omitSidecarInjectorConfigMap,proto3" json:"omitSidecarInjectorConfigMap,omitempty"`
	// Controls whether to restrict the applications namespace the controller manages;
	// If set it to false, the controller watches all namespaces.
	OneNamespace           *wrapperspb.BoolValue `protobuf:"bytes,23,opt,name=oneNamespace,proto3" json:"oneNamespace,omitempty"`
	OperatorManageWebhooks *wrapperspb.BoolValue `protobuf:"bytes,41,opt,name=operatorManageWebhooks,proto3" json:"operatorManageWebhooks,omitempty"`
	// Specifies the k8s priorityClassName for the istio control plane components.
	//
	// See https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/#priorityclass
	//
	// Deprecated: Do not use.
	PriorityClassName string `protobuf:"bytes,27,opt,name=priorityClassName,proto3" json:"priorityClassName,omitempty"`
	// Specifies how proxies are configured within Istio.
	Proxy *ProxyConfig `protobuf:"bytes,28,opt,name=proxy,proto3" json:"proxy,omitempty"`
	// Specifies the Configuration for proxy_init container which sets the pods' networking to intercept the inbound/outbound traffic.
	ProxyInit *ProxyInitConfig `protobuf:"bytes,29,opt,name=proxy_init,proto3" json:"proxy_init,omitempty"`
	// Specifies the Configuration for the SecretDiscoveryService instead of using K8S secrets to mount the certificates.
	Sds *SDSConfig `protobuf:"bytes,30,opt,name=sds,proto3" json:"sds,omitempty"`
	// Specifies the tag for the Istio docker images.
	Tag     *structpb.Value `protobuf:"bytes,31,opt,name=tag,proto3" json:"tag,omitempty"`
	Variant string          `protobuf:"bytes,67,opt,name=variant,proto3" json:"variant,omitempty"`
	// Specifies the Configuration for each of the supported tracers.
	Tracer *TracerConfig `protobuf:"bytes,33,opt,name=tracer,proto3" json:"tracer,omitempty"`
	// Controls whether to use of Mesh Configuration Protocol to distribute configuration.
	UseMCP *wrapperspb.BoolValue `protobuf:"bytes,35,opt,name=useMCP,proto3" json:"useMCP,omitempty"`
	// Specifies the Istio control plane’s pilot Pod IP address or remote cluster DNS resolvable hostname.
	RemotePilotAddress string `protobuf:"bytes,48,opt,name=remotePilotAddress,proto3" json:"remotePilotAddress,omitempty"`
	// Specifies the configution of istiod
	Istiod *IstiodConfig `protobuf:"bytes,54,opt,name=istiod,proto3" json:"istiod,omitempty"`
	// Configure the Pilot certificate provider.
	// Currently, four providers are supported: "kubernetes", "istiod", "custom" and "none".
	PilotCertProvider string `protobuf:"bytes,56,opt,name=pilotCertProvider,proto3" json:"pilotCertProvider,omitempty"`
	// Configure the policy for validating JWT.
	// Currently, two options are supported: "third-party-jwt" and "first-party-jwt".
	JwtPolicy string `protobuf:"bytes,57,opt,name=jwtPolicy,proto3" json:"jwtPolicy,omitempty"`
	// Specifies the configuration for Security Token Service.
	Sts *STSConfig `protobuf:"bytes,58,opt,name=sts,proto3" json:"sts,omitempty"`
	// Configures the revision this control plane is a part of
	Revision string `protobuf:"bytes,59,opt,name=revision,proto3" json:"revision,omitempty"`
	// Controls whether the in-cluster MTLS key and certs are loaded from the secret volume mounts.
	MountMtlsCerts *wrapperspb.BoolValue `protobuf:"bytes,60,opt,name=mountMtlsCerts,proto3" json:"mountMtlsCerts,omitempty"`
	// The address of the CA for CSR.
	CaAddress string `protobuf:"bytes,61,opt,name=caAddress,proto3" json:"caAddress,omitempty"`
	// Controls whether one external istiod is enabled.
	ExternalIstiod *wrapperspb.BoolValue `protobuf:"bytes,62,opt,name=externalIstiod,proto3" json:"externalIstiod,omitempty"`
	// Controls whether a remote cluster is the config cluster for an external istiod
	ConfigCluster *wrapperspb.BoolValue `protobuf:"bytes,64,opt,name=configCluster,proto3" json:"configCluster,omitempty"`
	// The name of the CA for workloads.
	// For example, when caName=GkeWorkloadCertificate, GKE workload certificates
	// will be used as the certificates for workloads.
	// The default value is "" and when caName="", the CA will be configured by other
	// mechanisms (e.g., environmental variable CA_PROVIDER).
	CaName           string                `protobuf:"bytes,65,opt,name=caName,proto3" json:"caName,omitempty"`
	Autoscalingv2API *wrapperspb.BoolValue `protobuf:"bytes,66,opt,name=autoscalingv2API,proto3" json:"autoscalingv2API,omitempty"` // The next available key is 68
}

func (x *GlobalConfig) Reset() {
	*x = GlobalConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalConfig) ProtoMessage() {}

func (x *GlobalConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalConfig.ProtoReflect.Descriptor instead.
func (*GlobalConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{12}
}

// Deprecated: Do not use.
func (x *GlobalConfig) GetArch() *ArchConfig {
	if x != nil {
		return x.Arch
	}
	return nil
}

func (x *GlobalConfig) GetCertSigners() []string {
	if x != nil {
		return x.CertSigners
	}
	return nil
}

func (x *GlobalConfig) GetConfigRootNamespace() string {
	if x != nil {
		return x.ConfigRootNamespace
	}
	return ""
}

func (x *GlobalConfig) GetConfigValidation() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigValidation
	}
	return nil
}

func (x *GlobalConfig) GetDefaultConfigVisibilitySettings() []string {
	if x != nil {
		return x.DefaultConfigVisibilitySettings
	}
	return nil
}

// Deprecated: Do not use.
func (x *GlobalConfig) GetDefaultNodeSelector() *structpb.Struct {
	if x != nil {
		return x.DefaultNodeSelector
	}
	return nil
}

// Deprecated: Do not use.
func (x *GlobalConfig) GetDefaultPodDisruptionBudget() *DefaultPodDisruptionBudgetConfig {
	if x != nil {
		return x.DefaultPodDisruptionBudget
	}
	return nil
}

// Deprecated: Do not use.
func (x *GlobalConfig) GetDefaultResources() *DefaultResourcesConfig {
	if x != nil {
		return x.DefaultResources
	}
	return nil
}

// Deprecated: Do not use.
func (x *GlobalConfig) GetDefaultTolerations() []*structpb.Struct {
	if x != nil {
		return x.DefaultTolerations
	}
	return nil
}

func (x *GlobalConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *GlobalConfig) GetImagePullPolicy() string {
	if x != nil {
		return x.ImagePullPolicy
	}
	return ""
}

func (x *GlobalConfig) GetImagePullSecrets() []string {
	if x != nil {
		return x.ImagePullSecrets
	}
	return nil
}

func (x *GlobalConfig) GetIstioNamespace() string {
	if x != nil {
		return x.IstioNamespace
	}
	return ""
}

func (x *GlobalConfig) GetLogAsJson() *wrapperspb.BoolValue {
	if x != nil {
		return x.LogAsJson
	}
	return nil
}

func (x *GlobalConfig) GetLogging() *GlobalLoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *GlobalConfig) GetMeshID() string {
	if x != nil {
		return x.MeshID
	}
	return ""
}

func (x *GlobalConfig) GetMeshNetworks() *structpb.Struct {
	if x != nil {
		return x.MeshNetworks
	}
	return nil
}

func (x *GlobalConfig) GetMultiCluster() *MultiClusterConfig {
	if x != nil {
		return x.MultiCluster
	}
	return nil
}

func (x *GlobalConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *GlobalConfig) GetPodDNSSearchNamespaces() []string {
	if x != nil {
		return x.PodDNSSearchNamespaces
	}
	return nil
}

func (x *GlobalConfig) GetOmitSidecarInjectorConfigMap() *wrapperspb.BoolValue {
	if x != nil {
		return x.OmitSidecarInjectorConfigMap
	}
	return nil
}

func (x *GlobalConfig) GetOneNamespace() *wrapperspb.BoolValue {
	if x != nil {
		return x.OneNamespace
	}
	return nil
}

func (x *GlobalConfig) GetOperatorManageWebhooks() *wrapperspb.BoolValue {
	if x != nil {
		return x.OperatorManageWebhooks
	}
	return nil
}

// Deprecated: Do not use.
func (x *GlobalConfig) GetPriorityClassName() string {
	if x != nil {
		return x.PriorityClassName
	}
	return ""
}

func (x *GlobalConfig) GetProxy() *ProxyConfig {
	if x != nil {
		return x.Proxy
	}
	return nil
}

func (x *GlobalConfig) GetProxyInit() *ProxyInitConfig {
	if x != nil {
		return x.ProxyInit
	}
	return nil
}

func (x *GlobalConfig) GetSds() *SDSConfig {
	if x != nil {
		return x.Sds
	}
	return nil
}

func (x *GlobalConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *GlobalConfig) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *GlobalConfig) GetTracer() *TracerConfig {
	if x != nil {
		return x.Tracer
	}
	return nil
}

func (x *GlobalConfig) GetUseMCP() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseMCP
	}
	return nil
}

func (x *GlobalConfig) GetRemotePilotAddress() string {
	if x != nil {
		return x.RemotePilotAddress
	}
	return ""
}

func (x *GlobalConfig) GetIstiod() *IstiodConfig {
	if x != nil {
		return x.Istiod
	}
	return nil
}

func (x *GlobalConfig) GetPilotCertProvider() string {
	if x != nil {
		return x.PilotCertProvider
	}
	return ""
}

func (x *GlobalConfig) GetJwtPolicy() string {
	if x != nil {
		return x.JwtPolicy
	}
	return ""
}

func (x *GlobalConfig) GetSts() *STSConfig {
	if x != nil {
		return x.Sts
	}
	return nil
}

func (x *GlobalConfig) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *GlobalConfig) GetMountMtlsCerts() *wrapperspb.BoolValue {
	if x != nil {
		return x.MountMtlsCerts
	}
	return nil
}

func (x *GlobalConfig) GetCaAddress() string {
	if x != nil {
		return x.CaAddress
	}
	return ""
}

func (x *GlobalConfig) GetExternalIstiod() *wrapperspb.BoolValue {
	if x != nil {
		return x.ExternalIstiod
	}
	return nil
}

func (x *GlobalConfig) GetConfigCluster() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigCluster
	}
	return nil
}

func (x *GlobalConfig) GetCaName() string {
	if x != nil {
		return x.CaName
	}
	return ""
}

func (x *GlobalConfig) GetAutoscalingv2API() *wrapperspb.BoolValue {
	if x != nil {
		return x.Autoscalingv2API
	}
	return nil
}

// Configuration for Security Token Service (STS) server.
//
// See https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-16
type STSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServicePort uint32 `protobuf:"varint,1,opt,name=servicePort,proto3" json:"servicePort,omitempty"`
}

func (x *STSConfig) Reset() {
	*x = STSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *STSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*STSConfig) ProtoMessage() {}

func (x *STSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use STSConfig.ProtoReflect.Descriptor instead.
func (*STSConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{13}
}

func (x *STSConfig) GetServicePort() uint32 {
	if x != nil {
		return x.ServicePort
	}
	return 0
}

type IstiodConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If enabled, istiod will perform config analysis
	EnableAnalysis *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enableAnalysis,proto3" json:"enableAnalysis,omitempty"`
}

func (x *IstiodConfig) Reset() {
	*x = IstiodConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IstiodConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstiodConfig) ProtoMessage() {}

func (x *IstiodConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstiodConfig.ProtoReflect.Descriptor instead.
func (*IstiodConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{14}
}

func (x *IstiodConfig) GetEnableAnalysis() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableAnalysis
	}
	return nil
}

// GlobalLoggingConfig specifies the global logging level settings for the Istio control plane components.
type GlobalLoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Comma-separated minimum per-scope logging level of messages to output, in the form of <scope>:<level>,<scope>:<level>
	// The control plane has different scopes depending on component, but can configure default log level across all components
	// If empty, default scope and level will be used as configured in code
	Level string `protobuf:"bytes,1,opt,name=level,proto3" json:"level,omitempty"`
}

func (x *GlobalLoggingConfig) Reset() {
	*x = GlobalLoggingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalLoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalLoggingConfig) ProtoMessage() {}

func (x *GlobalLoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalLoggingConfig.ProtoReflect.Descriptor instead.
func (*GlobalLoggingConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{15}
}

func (x *GlobalLoggingConfig) GetLevel() string {
	if x != nil {
		return x.Level
	}
	return ""
}

// Configuration for an ingress gateway.
type IngressGatewayConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether auto scaling with a HorizontalPodAutoscaler is enabled.
	AutoscaleEnabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=autoscaleEnabled,proto3" json:"autoscaleEnabled,omitempty"`
	// maxReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMax uint32 `protobuf:"varint,2,opt,name=autoscaleMax,proto3" json:"autoscaleMax,omitempty"`
	// minReplicas setting for HorizontalPodAutoscaler.
	AutoscaleMin uint32 `protobuf:"varint,3,opt,name=autoscaleMin,proto3" json:"autoscaleMin,omitempty"`
	// K8s utilization setting for HorizontalPodAutoscaler target.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Do not use.
	Cpu           *CPUTargetUtilizationConfig `protobuf:"bytes,5,opt,name=cpu,proto3" json:"cpu,omitempty"`
	CustomService *wrapperspb.BoolValue       `protobuf:"bytes,6,opt,name=customService,proto3" json:"customService,omitempty"`
	// Controls whether an ingress gateway is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Environment variables passed to the proxy container.
	Env                      *structpb.Struct  `protobuf:"bytes,11,opt,name=env,proto3" json:"env,omitempty"`
	Labels                   map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	LoadBalancerIP           string            `protobuf:"bytes,16,opt,name=loadBalancerIP,proto3" json:"loadBalancerIP,omitempty"`
	LoadBalancerSourceRanges []string          `protobuf:"bytes,17,rep,name=loadBalancerSourceRanges,proto3" json:"loadBalancerSourceRanges,omitempty"`
	Name                     string            `protobuf:"bytes,44,opt,name=name,proto3" json:"name,omitempty"`
	// K8s node selector.
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Do not use.
	NodeSelector *structpb.Struct `protobuf:"bytes,19,opt,name=nodeSelector,proto3" json:"nodeSelector,omitempty"`
	// K8s annotations for pods.
	//
	// See: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	//
	// Deprecated: Do not use.
	PodAnnotations *structpb.Struct `protobuf:"bytes,20,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	// See EgressGatewayConfig.
	//
	// Deprecated: Do not use.
	PodAntiAffinityLabelSelector []*structpb.Struct `protobuf:"bytes,21,rep,name=podAntiAffinityLabelSelector,proto3" json:"podAntiAffinityLabelSelector,omitempty"`
	// See EgressGatewayConfig.
	//
	// Deprecated: Do not use.
	PodAntiAffinityTermLabelSelector []*structpb.Struct `protobuf:"bytes,22,rep,name=podAntiAffinityTermLabelSelector,proto3" json:"podAntiAffinityTermLabelSelector,omitempty"`
	// Port Configuration for the ingress gateway.
	Ports []*PortsConfig `protobuf:"bytes,23,rep,name=ports,proto3" json:"ports,omitempty"`
	// Number of replicas for the ingress gateway Deployment.
	//
	// Deprecated: Do not use.
	ReplicaCount uint32 `protobuf:"varint,24,opt,name=replicaCount,proto3" json:"replicaCount,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Do not use.
	Resources *structpb.Struct `protobuf:"bytes,25,opt,name=resources,proto3" json:"resources,omitempty"`
	// Config for secret volume mounts.
	SecretVolumes []*SecretVolume `protobuf:"bytes,27,rep,name=secretVolumes,proto3" json:"secretVolumes,omitempty"`
	// Annotations to add to the egress gateway service.
	ServiceAnnotations *structpb.Struct `protobuf:"bytes,28,opt,name=serviceAnnotations,proto3" json:"serviceAnnotations,omitempty"`
	// Service type.
	//
	// See https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
	Type string `protobuf:"bytes,29,opt,name=type,proto3" json:"type,omitempty"`
	// Enables cross-cluster access using SNI matching.
	Zvpn *IngressGatewayZvpnConfig `protobuf:"bytes,30,opt,name=zvpn,proto3" json:"zvpn,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Do not use.
	RollingMaxSurge *IntOrString `protobuf:"bytes,31,opt,name=rollingMaxSurge,proto3" json:"rollingMaxSurge,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Do not use.
	RollingMaxUnavailable *IntOrString `protobuf:"bytes,32,opt,name=rollingMaxUnavailable,proto3" json:"rollingMaxUnavailable,omitempty"`
	ExternalTrafficPolicy string       `protobuf:"bytes,34,opt,name=externalTrafficPolicy,proto3" json:"externalTrafficPolicy,omitempty"`
	// Deprecated: Do not use.
	Tolerations          []*structpb.Struct    `protobuf:"bytes,35,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	IngressPorts         []*structpb.Struct    `protobuf:"bytes,36,rep,name=ingressPorts,proto3" json:"ingressPorts,omitempty"`
	AdditionalContainers []*structpb.Struct    `protobuf:"bytes,37,rep,name=additionalContainers,proto3" json:"additionalContainers,omitempty"`
	ConfigVolumes        []*structpb.Struct    `protobuf:"bytes,38,rep,name=configVolumes,proto3" json:"configVolumes,omitempty"`
	RunAsRoot            *wrapperspb.BoolValue `protobuf:"bytes,45,opt,name=runAsRoot,proto3" json:"runAsRoot,omitempty"`
	// The injection template to use for the gateway. If not set, no injection will be performed.
	InjectionTemplate string          `protobuf:"bytes,46,opt,name=injectionTemplate,proto3" json:"injectionTemplate,omitempty"`
	ServiceAccount    *ServiceAccount `protobuf:"bytes,47,opt,name=serviceAccount,proto3" json:"serviceAccount,omitempty"`
}

func (x *IngressGatewayConfig) Reset() {
	*x = IngressGatewayConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngressGatewayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngressGatewayConfig) ProtoMessage() {}

func (x *IngressGatewayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngressGatewayConfig.ProtoReflect.Descriptor instead.
func (*IngressGatewayConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{16}
}

func (x *IngressGatewayConfig) GetAutoscaleEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoscaleEnabled
	}
	return nil
}

func (x *IngressGatewayConfig) GetAutoscaleMax() uint32 {
	if x != nil {
		return x.AutoscaleMax
	}
	return 0
}

func (x *IngressGatewayConfig) GetAutoscaleMin() uint32 {
	if x != nil {
		return x.AutoscaleMin
	}
	return 0
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetCpu() *CPUTargetUtilizationConfig {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *IngressGatewayConfig) GetCustomService() *wrapperspb.BoolValue {
	if x != nil {
		return x.CustomService
	}
	return nil
}

func (x *IngressGatewayConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *IngressGatewayConfig) GetEnv() *structpb.Struct {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *IngressGatewayConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *IngressGatewayConfig) GetLoadBalancerIP() string {
	if x != nil {
		return x.LoadBalancerIP
	}
	return ""
}

func (x *IngressGatewayConfig) GetLoadBalancerSourceRanges() []string {
	if x != nil {
		return x.LoadBalancerSourceRanges
	}
	return nil
}

func (x *IngressGatewayConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetNodeSelector() *structpb.Struct {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetPodAntiAffinityLabelSelector() []*structpb.Struct {
	if x != nil {
		return x.PodAntiAffinityLabelSelector
	}
	return nil
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetPodAntiAffinityTermLabelSelector() []*structpb.Struct {
	if x != nil {
		return x.PodAntiAffinityTermLabelSelector
	}
	return nil
}

func (x *IngressGatewayConfig) GetPorts() []*PortsConfig {
	if x != nil {
		return x.Ports
	}
	return nil
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetReplicaCount() uint32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetResources() *structpb.Struct {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *IngressGatewayConfig) GetSecretVolumes() []*SecretVolume {
	if x != nil {
		return x.SecretVolumes
	}
	return nil
}

func (x *IngressGatewayConfig) GetServiceAnnotations() *structpb.Struct {
	if x != nil {
		return x.ServiceAnnotations
	}
	return nil
}

func (x *IngressGatewayConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *IngressGatewayConfig) GetZvpn() *IngressGatewayZvpnConfig {
	if x != nil {
		return x.Zvpn
	}
	return nil
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetRollingMaxSurge() *IntOrString {
	if x != nil {
		return x.RollingMaxSurge
	}
	return nil
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetRollingMaxUnavailable() *IntOrString {
	if x != nil {
		return x.RollingMaxUnavailable
	}
	return nil
}

func (x *IngressGatewayConfig) GetExternalTrafficPolicy() string {
	if x != nil {
		return x.ExternalTrafficPolicy
	}
	return ""
}

// Deprecated: Do not use.
func (x *IngressGatewayConfig) GetTolerations() []*structpb.Struct {
	if x != nil {
		return x.Tolerations
	}
	return nil
}

func (x *IngressGatewayConfig) GetIngressPorts() []*structpb.Struct {
	if x != nil {
		return x.IngressPorts
	}
	return nil
}

func (x *IngressGatewayConfig) GetAdditionalContainers() []*structpb.Struct {
	if x != nil {
		return x.AdditionalContainers
	}
	return nil
}

func (x *IngressGatewayConfig) GetConfigVolumes() []*structpb.Struct {
	if x != nil {
		return x.ConfigVolumes
	}
	return nil
}

func (x *IngressGatewayConfig) GetRunAsRoot() *wrapperspb.BoolValue {
	if x != nil {
		return x.RunAsRoot
	}
	return nil
}

func (x *IngressGatewayConfig) GetInjectionTemplate() string {
	if x != nil {
		return x.InjectionTemplate
	}
	return ""
}

func (x *IngressGatewayConfig) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

// IngressGatewayZvpnConfig enables cross-cluster access using SNI matching.
type IngressGatewayZvpnConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether ZeroVPN is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Suffix  string                `protobuf:"bytes,2,opt,name=suffix,proto3" json:"suffix,omitempty"`
}

func (x *IngressGatewayZvpnConfig) Reset() {
	*x = IngressGatewayZvpnConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngressGatewayZvpnConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngressGatewayZvpnConfig) ProtoMessage() {}

func (x *IngressGatewayZvpnConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngressGatewayZvpnConfig.ProtoReflect.Descriptor instead.
func (*IngressGatewayZvpnConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{17}
}

func (x *IngressGatewayZvpnConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *IngressGatewayZvpnConfig) GetSuffix() string {
	if x != nil {
		return x.Suffix
	}
	return ""
}

// MultiClusterConfig specifies the Configuration for Istio mesh across multiple clusters through the istio gateways.
type MultiClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables the connection between two kubernetes clusters via their respective ingressgateway services.
	// Use if the pods in each cluster cannot directly talk to one another.
	Enabled            *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	ClusterName        string                `protobuf:"bytes,2,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	GlobalDomainSuffix string                `protobuf:"bytes,3,opt,name=globalDomainSuffix,proto3" json:"globalDomainSuffix,omitempty"`
	IncludeEnvoyFilter *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=includeEnvoyFilter,proto3" json:"includeEnvoyFilter,omitempty"`
}

func (x *MultiClusterConfig) Reset() {
	*x = MultiClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MultiClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiClusterConfig) ProtoMessage() {}

func (x *MultiClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiClusterConfig.ProtoReflect.Descriptor instead.
func (*MultiClusterConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{18}
}

func (x *MultiClusterConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *MultiClusterConfig) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *MultiClusterConfig) GetGlobalDomainSuffix() string {
	if x != nil {
		return x.GlobalDomainSuffix
	}
	return ""
}

func (x *MultiClusterConfig) GetIncludeEnvoyFilter() *wrapperspb.BoolValue {
	if x != nil {
		return x.IncludeEnvoyFilter
	}
	return nil
}

// OutboundTrafficPolicyConfig controls the default behavior of the sidecar for handling outbound traffic from the application.
type OutboundTrafficPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode OutboundTrafficPolicyConfig_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=v1alpha1.OutboundTrafficPolicyConfig_Mode" json:"mode,omitempty"`
}

func (x *OutboundTrafficPolicyConfig) Reset() {
	*x = OutboundTrafficPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundTrafficPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundTrafficPolicyConfig) ProtoMessage() {}

func (x *OutboundTrafficPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundTrafficPolicyConfig.ProtoReflect.Descriptor instead.
func (*OutboundTrafficPolicyConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{19}
}

func (x *OutboundTrafficPolicyConfig) GetMode() OutboundTrafficPolicyConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return OutboundTrafficPolicyConfig_ALLOW_ANY
}

// Configuration for Pilot.
type PilotConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether Pilot is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Controls whether a HorizontalPodAutoscaler is installed for Pilot.
	AutoscaleEnabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=autoscaleEnabled,proto3" json:"autoscaleEnabled,omitempty"`
	// Minimum number of replicas in the HorizontalPodAutoscaler for Pilot.
	AutoscaleMin uint32 `protobuf:"varint,3,opt,name=autoscaleMin,proto3" json:"autoscaleMin,omitempty"`
	// Maximum number of replicas in the HorizontalPodAutoscaler for Pilot.
	AutoscaleMax uint32 `protobuf:"varint,4,opt,name=autoscaleMax,proto3" json:"autoscaleMax,omitempty"`
	// Number of replicas in the Pilot Deployment.
	//
	// Deprecated: Do not use.
	ReplicaCount uint32 `protobuf:"varint,5,opt,name=replicaCount,proto3" json:"replicaCount,omitempty"`
	// Image name used for Pilot.
	//
	// This can be set either to image name if hub is also set, or can be set to the full hub:name string.
	//
	// Examples: custom-pilot, docker.io/someuser:custom-pilot
	Image string `protobuf:"bytes,6,opt,name=image,proto3" json:"image,omitempty"`
	// Trace sampling fraction.
	//
	// Used to set the fraction of time that traces are sampled. Higher values are more accurate but add CPU overhead.
	//
	// Allowed values: 0.0 to 1.0
	TraceSampling float64 `protobuf:"fixed64,8,opt,name=traceSampling,proto3" json:"traceSampling,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Do not use.
	Resources *Resources `protobuf:"bytes,9,opt,name=resources,proto3" json:"resources,omitempty"`
	// Namespace that the configuration management feature is installed into, if different from Pilot namespace.
	ConfigNamespace string `protobuf:"bytes,10,opt,name=configNamespace,proto3" json:"configNamespace,omitempty"`
	// Target CPU utilization used in HorizontalPodAutoscaler.
	//
	// See https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	//
	// Deprecated: Do not use.
	Cpu *CPUTargetUtilizationConfig `protobuf:"bytes,11,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// K8s node selector.
	//
	// See https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	//
	// Deprecated: Do not use.
	NodeSelector *structpb.Struct `protobuf:"bytes,12,opt,name=nodeSelector,proto3" json:"nodeSelector,omitempty"`
	// Maximum duration that a sidecar can be connected to a pilot.
	//
	// This setting balances out load across pilot instances, but adds some resource overhead.
	//
	// Examples: 300s, 30m, 1h
	KeepaliveMaxServerConnectionAge *durationpb.Duration `protobuf:"bytes,13,opt,name=keepaliveMaxServerConnectionAge,proto3" json:"keepaliveMaxServerConnectionAge,omitempty"`
	// Labels that are added to Pilot deployment and pods.
	//
	// See https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	DeploymentLabels *structpb.Struct `protobuf:"bytes,14,opt,name=deploymentLabels,proto3" json:"deploymentLabels,omitempty"`
	PodLabels        *structpb.Struct `protobuf:"bytes,36,opt,name=podLabels,proto3" json:"podLabels,omitempty"`
	// Configuration settings passed to Pilot as a ConfigMap.
	//
	// This controls whether the mesh config map, generated from values.yaml is generated.
	// If false, pilot wil use default values or user-supplied values, in that order of preference.
	ConfigMap *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=configMap,proto3" json:"configMap,omitempty"`
	// Controls whether Pilot is configured through the Mesh Control Protocol (MCP).
	//
	// If set to true, Pilot requires an MCP server (like Galley) to be installed.
	UseMCP *wrapperspb.BoolValue `protobuf:"bytes,20,opt,name=useMCP,proto3" json:"useMCP,omitempty"`
	// Environment variables passed to the Pilot container.
	//
	// Examples:
	// env:
	//
	//	ENV_VAR_1: value1
	//	ENV_VAR_2: value2
	Env *structpb.Struct `protobuf:"bytes,21,opt,name=env,proto3" json:"env,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Do not use.
	RollingMaxSurge *IntOrString `protobuf:"bytes,24,opt,name=rollingMaxSurge,proto3" json:"rollingMaxSurge,omitempty"`
	// K8s rolling update strategy
	//
	// Deprecated: Do not use.
	RollingMaxUnavailable *IntOrString `protobuf:"bytes,25,opt,name=rollingMaxUnavailable,proto3" json:"rollingMaxUnavailable,omitempty"`
	// Deprecated: Do not use.
	Tolerations []*structpb.Struct `protobuf:"bytes,26,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// if protocol sniffing is enabled for outbound
	EnableProtocolSniffingForOutbound *wrapperspb.BoolValue `protobuf:"bytes,28,opt,name=enableProtocolSniffingForOutbound,proto3" json:"enableProtocolSniffingForOutbound,omitempty"`
	// if protocol sniffing is enabled for inbound
	EnableProtocolSniffingForInbound *wrapperspb.BoolValue `protobuf:"bytes,29,opt,name=enableProtocolSniffingForInbound,proto3" json:"enableProtocolSniffingForInbound,omitempty"`
	// K8s annotations for pods.
	//
	// See: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	//
	// Deprecated: Do not use.
	PodAnnotations     *structpb.Struct `protobuf:"bytes,30,opt,name=podAnnotations,proto3" json:"podAnnotations,omitempty"`
	ServiceAnnotations *structpb.Struct `protobuf:"bytes,37,opt,name=serviceAnnotations,proto3" json:"serviceAnnotations,omitempty"`
	// ConfigSource describes a source of configuration data for networking
	// rules, and other Istio configuration artifacts. Multiple data sources
	// can be configured for a single control plane.
	ConfigSource            *PilotConfigSource `protobuf:"bytes,31,opt,name=configSource,proto3" json:"configSource,omitempty"`
	JwksResolverExtraRootCA string             `protobuf:"bytes,32,opt,name=jwksResolverExtraRootCA,proto3" json:"jwksResolverExtraRootCA,omitempty"`
	Plugins                 []string           `protobuf:"bytes,33,rep,name=plugins,proto3" json:"plugins,omitempty"`
	Hub                     string             `protobuf:"bytes,34,opt,name=hub,proto3" json:"hub,omitempty"`
	Tag                     *structpb.Value    `protobuf:"bytes,35,opt,name=tag,proto3" json:"tag,omitempty"`
	Variant                 string             `protobuf:"bytes,39,opt,name=variant,proto3" json:"variant,omitempty"`
	// The Container seccompProfile
	//
	// See: https://kubernetes.io/docs/tutorials/security/seccomp/
	SeccompProfile *structpb.Struct `protobuf:"bytes,38,opt,name=seccompProfile,proto3" json:"seccompProfile,omitempty"`
}

func (x *PilotConfig) Reset() {
	*x = PilotConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PilotConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotConfig) ProtoMessage() {}

func (x *PilotConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotConfig.ProtoReflect.Descriptor instead.
func (*PilotConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{20}
}

func (x *PilotConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *PilotConfig) GetAutoscaleEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoscaleEnabled
	}
	return nil
}

func (x *PilotConfig) GetAutoscaleMin() uint32 {
	if x != nil {
		return x.AutoscaleMin
	}
	return 0
}

func (x *PilotConfig) GetAutoscaleMax() uint32 {
	if x != nil {
		return x.AutoscaleMax
	}
	return 0
}

// Deprecated: Do not use.
func (x *PilotConfig) GetReplicaCount() uint32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

func (x *PilotConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *PilotConfig) GetTraceSampling() float64 {
	if x != nil {
		return x.TraceSampling
	}
	return 0
}

// Deprecated: Do not use.
func (x *PilotConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *PilotConfig) GetConfigNamespace() string {
	if x != nil {
		return x.ConfigNamespace
	}
	return ""
}

// Deprecated: Do not use.
func (x *PilotConfig) GetCpu() *CPUTargetUtilizationConfig {
	if x != nil {
		return x.Cpu
	}
	return nil
}

// Deprecated: Do not use.
func (x *PilotConfig) GetNodeSelector() *structpb.Struct {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

func (x *PilotConfig) GetKeepaliveMaxServerConnectionAge() *durationpb.Duration {
	if x != nil {
		return x.KeepaliveMaxServerConnectionAge
	}
	return nil
}

func (x *PilotConfig) GetDeploymentLabels() *structpb.Struct {
	if x != nil {
		return x.DeploymentLabels
	}
	return nil
}

func (x *PilotConfig) GetPodLabels() *structpb.Struct {
	if x != nil {
		return x.PodLabels
	}
	return nil
}

func (x *PilotConfig) GetConfigMap() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigMap
	}
	return nil
}

func (x *PilotConfig) GetUseMCP() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseMCP
	}
	return nil
}

func (x *PilotConfig) GetEnv() *structpb.Struct {
	if x != nil {
		return x.Env
	}
	return nil
}

// Deprecated: Do not use.
func (x *PilotConfig) GetRollingMaxSurge() *IntOrString {
	if x != nil {
		return x.RollingMaxSurge
	}
	return nil
}

// Deprecated: Do not use.
func (x *PilotConfig) GetRollingMaxUnavailable() *IntOrString {
	if x != nil {
		return x.RollingMaxUnavailable
	}
	return nil
}

// Deprecated: Do not use.
func (x *PilotConfig) GetTolerations() []*structpb.Struct {
	if x != nil {
		return x.Tolerations
	}
	return nil
}

func (x *PilotConfig) GetEnableProtocolSniffingForOutbound() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableProtocolSniffingForOutbound
	}
	return nil
}

func (x *PilotConfig) GetEnableProtocolSniffingForInbound() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableProtocolSniffingForInbound
	}
	return nil
}

// Deprecated: Do not use.
func (x *PilotConfig) GetPodAnnotations() *structpb.Struct {
	if x != nil {
		return x.PodAnnotations
	}
	return nil
}

func (x *PilotConfig) GetServiceAnnotations() *structpb.Struct {
	if x != nil {
		return x.ServiceAnnotations
	}
	return nil
}

func (x *PilotConfig) GetConfigSource() *PilotConfigSource {
	if x != nil {
		return x.ConfigSource
	}
	return nil
}

func (x *PilotConfig) GetJwksResolverExtraRootCA() string {
	if x != nil {
		return x.JwksResolverExtraRootCA
	}
	return ""
}

func (x *PilotConfig) GetPlugins() []string {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *PilotConfig) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *PilotConfig) GetTag() *structpb.Value {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *PilotConfig) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *PilotConfig) GetSeccompProfile() *structpb.Struct {
	if x != nil {
		return x.SeccompProfile
	}
	return nil
}

// Controls legacy k8s ingress. Only one pilot profile should enable ingress support.
type PilotIngressConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sets the type ingress service for Pilot.
	//
	// If empty, node-port is assumed.
	//
	// Allowed values: node-port, istio-ingressgateway, ingress
	IngressService        string                `protobuf:"bytes,1,opt,name=ingressService,proto3" json:"ingressService,omitempty"`
	IngressControllerMode IngressControllerMode `protobuf:"varint,2,opt,name=ingressControllerMode,proto3,enum=v1alpha1.IngressControllerMode" json:"ingressControllerMode,omitempty"`
	// If mode is STRICT, this value must be set on "kubernetes.io/ingress.class" annotation to activate.
	IngressClass string `protobuf:"bytes,3,opt,name=ingressClass,proto3" json:"ingressClass,omitempty"`
}

func (x *PilotIngressConfig) Reset() {
	*x = PilotIngressConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PilotIngressConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotIngressConfig) ProtoMessage() {}

func (x *PilotIngressConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotIngressConfig.ProtoReflect.Descriptor instead.
func (*PilotIngressConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{21}
}

func (x *PilotIngressConfig) GetIngressService() string {
	if x != nil {
		return x.IngressService
	}
	return ""
}

func (x *PilotIngressConfig) GetIngressControllerMode() IngressControllerMode {
	if x != nil {
		return x.IngressControllerMode
	}
	return IngressControllerMode_UNSPECIFIED
}

func (x *PilotIngressConfig) GetIngressClass() string {
	if x != nil {
		return x.IngressClass
	}
	return ""
}

// Controls whether Istio policy is applied to Pilot.
type PilotPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether Istio policy is applied to Pilot.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *PilotPolicyConfig) Reset() {
	*x = PilotPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PilotPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotPolicyConfig) ProtoMessage() {}

func (x *PilotPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotPolicyConfig.ProtoReflect.Descriptor instead.
func (*PilotPolicyConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{22}
}

func (x *PilotPolicyConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// Controls telemetry configuration
type TelemetryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether telemetry is exported for Pilot.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Use telemetry v2.
	V2 *TelemetryV2Config `protobuf:"bytes,3,opt,name=v2,proto3" json:"v2,omitempty"`
}

func (x *TelemetryConfig) Reset() {
	*x = TelemetryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryConfig) ProtoMessage() {}

func (x *TelemetryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryConfig.ProtoReflect.Descriptor instead.
func (*TelemetryConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{23}
}

func (x *TelemetryConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *TelemetryConfig) GetV2() *TelemetryV2Config {
	if x != nil {
		return x.V2
	}
	return nil
}

// Controls whether pilot will configure telemetry v2.
type TelemetryV2Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether pilot will configure telemetry v2.
	Enabled          *wrapperspb.BoolValue                   `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	MetadataExchange *TelemetryV2MetadataExchangeConfig      `protobuf:"bytes,4,opt,name=metadata_exchange,json=metadataExchange,proto3" json:"metadata_exchange,omitempty"`
	Prometheus       *TelemetryV2PrometheusConfig            `protobuf:"bytes,2,opt,name=prometheus,proto3" json:"prometheus,omitempty"`
	Stackdriver      *TelemetryV2StackDriverConfig           `protobuf:"bytes,3,opt,name=stackdriver,proto3" json:"stackdriver,omitempty"`
	AccessLogPolicy  *TelemetryV2AccessLogPolicyFilterConfig `protobuf:"bytes,5,opt,name=access_log_policy,json=accessLogPolicy,proto3" json:"access_log_policy,omitempty"`
}

func (x *TelemetryV2Config) Reset() {
	*x = TelemetryV2Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryV2Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2Config) ProtoMessage() {}

func (x *TelemetryV2Config) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2Config.ProtoReflect.Descriptor instead.
func (*TelemetryV2Config) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{24}
}

func (x *TelemetryV2Config) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *TelemetryV2Config) GetMetadataExchange() *TelemetryV2MetadataExchangeConfig {
	if x != nil {
		return x.MetadataExchange
	}
	return nil
}

func (x *TelemetryV2Config) GetPrometheus() *TelemetryV2PrometheusConfig {
	if x != nil {
		return x.Prometheus
	}
	return nil
}

func (x *TelemetryV2Config) GetStackdriver() *TelemetryV2StackDriverConfig {
	if x != nil {
		return x.Stackdriver
	}
	return nil
}

func (x *TelemetryV2Config) GetAccessLogPolicy() *TelemetryV2AccessLogPolicyFilterConfig {
	if x != nil {
		return x.AccessLogPolicy
	}
	return nil
}

type TelemetryV2MetadataExchangeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether enabled WebAssembly runtime for metadata exchange filter.
	WasmEnabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=wasmEnabled,proto3" json:"wasmEnabled,omitempty"`
}

func (x *TelemetryV2MetadataExchangeConfig) Reset() {
	*x = TelemetryV2MetadataExchangeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryV2MetadataExchangeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2MetadataExchangeConfig) ProtoMessage() {}

func (x *TelemetryV2MetadataExchangeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2MetadataExchangeConfig.ProtoReflect.Descriptor instead.
func (*TelemetryV2MetadataExchangeConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{25}
}

func (x *TelemetryV2MetadataExchangeConfig) GetWasmEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.WasmEnabled
	}
	return nil
}

// Conrols telemetry v2 prometheus settings.
type TelemetryV2PrometheusConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether stats envoyfilter would be enabled or not.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Controls whether enabled WebAssembly runtime for stats filter.
	WasmEnabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=wasmEnabled,proto3" json:"wasmEnabled,omitempty"`
	// Overrides default telemetry v2 filter configuration.
	ConfigOverride *TelemetryV2PrometheusConfig_ConfigOverride `protobuf:"bytes,3,opt,name=config_override,json=configOverride,proto3" json:"config_override,omitempty"`
}

func (x *TelemetryV2PrometheusConfig) Reset() {
	*x = TelemetryV2PrometheusConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryV2PrometheusConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2PrometheusConfig) ProtoMessage() {}

func (x *TelemetryV2PrometheusConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2PrometheusConfig.ProtoReflect.Descriptor instead.
func (*TelemetryV2PrometheusConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{26}
}

func (x *TelemetryV2PrometheusConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *TelemetryV2PrometheusConfig) GetWasmEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.WasmEnabled
	}
	return nil
}

func (x *TelemetryV2PrometheusConfig) GetConfigOverride() *TelemetryV2PrometheusConfig_ConfigOverride {
	if x != nil {
		return x.ConfigOverride
	}
	return nil
}

// Conrols telemetry v2 stackdriver settings.
type TelemetryV2StackDriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Deprecated: Do not use.
	Logging    *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=logging,proto3" json:"logging,omitempty"`
	Monitoring *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Deprecated: Do not use.
	Topology              *wrapperspb.BoolValue                      `protobuf:"bytes,4,opt,name=topology,proto3" json:"topology,omitempty"`
	DisableOutbound       *wrapperspb.BoolValue                      `protobuf:"bytes,6,opt,name=disableOutbound,proto3" json:"disableOutbound,omitempty"`
	ConfigOverride        *structpb.Struct                           `protobuf:"bytes,5,opt,name=configOverride,proto3" json:"configOverride,omitempty"`
	OutboundAccessLogging TelemetryV2StackDriverConfig_AccessLogging `protobuf:"varint,7,opt,name=outboundAccessLogging,proto3,enum=v1alpha1.TelemetryV2StackDriverConfig_AccessLogging" json:"outboundAccessLogging,omitempty"`
	InboundAccessLogging  TelemetryV2StackDriverConfig_AccessLogging `protobuf:"varint,8,opt,name=inboundAccessLogging,proto3,enum=v1alpha1.TelemetryV2StackDriverConfig_AccessLogging" json:"inboundAccessLogging,omitempty"`
}

func (x *TelemetryV2StackDriverConfig) Reset() {
	*x = TelemetryV2StackDriverConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryV2StackDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2StackDriverConfig) ProtoMessage() {}

func (x *TelemetryV2StackDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2StackDriverConfig.ProtoReflect.Descriptor instead.
func (*TelemetryV2StackDriverConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{27}
}

func (x *TelemetryV2StackDriverConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

// Deprecated: Do not use.
func (x *TelemetryV2StackDriverConfig) GetLogging() *wrapperspb.BoolValue {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *TelemetryV2StackDriverConfig) GetMonitoring() *wrapperspb.BoolValue {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

// Deprecated: Do not use.
func (x *TelemetryV2StackDriverConfig) GetTopology() *wrapperspb.BoolValue {
	if x != nil {
		return x.Topology
	}
	return nil
}

func (x *TelemetryV2StackDriverConfig) GetDisableOutbound() *wrapperspb.BoolValue {
	if x != nil {
		return x.DisableOutbound
	}
	return nil
}

func (x *TelemetryV2StackDriverConfig) GetConfigOverride() *structpb.Struct {
	if x != nil {
		return x.ConfigOverride
	}
	return nil
}

func (x *TelemetryV2StackDriverConfig) GetOutboundAccessLogging() TelemetryV2StackDriverConfig_AccessLogging {
	if x != nil {
		return x.OutboundAccessLogging
	}
	return TelemetryV2StackDriverConfig_NONE
}

func (x *TelemetryV2StackDriverConfig) GetInboundAccessLogging() TelemetryV2StackDriverConfig_AccessLogging {
	if x != nil {
		return x.InboundAccessLogging
	}
	return TelemetryV2StackDriverConfig_NONE
}

// Conrols telemetry v2 access log policy filter settings.
type TelemetryV2AccessLogPolicyFilterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled           *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	LogWindowDuration *durationpb.Duration  `protobuf:"bytes,2,opt,name=logWindowDuration,proto3" json:"logWindowDuration,omitempty"`
}

func (x *TelemetryV2AccessLogPolicyFilterConfig) Reset() {
	*x = TelemetryV2AccessLogPolicyFilterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryV2AccessLogPolicyFilterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2AccessLogPolicyFilterConfig) ProtoMessage() {}

func (x *TelemetryV2AccessLogPolicyFilterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2AccessLogPolicyFilterConfig.ProtoReflect.Descriptor instead.
func (*TelemetryV2AccessLogPolicyFilterConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{28}
}

func (x *TelemetryV2AccessLogPolicyFilterConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *TelemetryV2AccessLogPolicyFilterConfig) GetLogWindowDuration() *durationpb.Duration {
	if x != nil {
		return x.LogWindowDuration
	}
	return nil
}

// PilotConfigSource describes information about a configuration store inside a
// mesh. A single control plane instance can interact with one or more data
// sources.
type PilotConfigSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the source of configuration, if nothing is specified default is MCP.
	SubscribedResources []string `protobuf:"bytes,1,rep,name=subscribedResources,proto3" json:"subscribedResources,omitempty"`
}

func (x *PilotConfigSource) Reset() {
	*x = PilotConfigSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PilotConfigSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PilotConfigSource) ProtoMessage() {}

func (x *PilotConfigSource) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PilotConfigSource.ProtoReflect.Descriptor instead.
func (*PilotConfigSource) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{29}
}

func (x *PilotConfigSource) GetSubscribedResources() []string {
	if x != nil {
		return x.SubscribedResources
	}
	return nil
}

// Configuration for a port.
type PortsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Port name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Port number.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// NodePort number.
	NodePort int32 `protobuf:"varint,3,opt,name=nodePort,proto3" json:"nodePort,omitempty"`
	// Target port number.
	TargetPort int32 `protobuf:"varint,4,opt,name=targetPort,proto3" json:"targetPort,omitempty"`
	// Protocol name.
	Protocol string `protobuf:"bytes,5,opt,name=protocol,proto3" json:"protocol,omitempty"`
}

func (x *PortsConfig) Reset() {
	*x = PortsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PortsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortsConfig) ProtoMessage() {}

func (x *PortsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortsConfig.ProtoReflect.Descriptor instead.
func (*PortsConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{30}
}

func (x *PortsConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PortsConfig) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *PortsConfig) GetNodePort() int32 {
	if x != nil {
		return x.NodePort
	}
	return 0
}

func (x *PortsConfig) GetTargetPort() int32 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

func (x *PortsConfig) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

// Configuration for Proxy.
type ProxyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AutoInject string `protobuf:"bytes,4,opt,name=autoInject,proto3" json:"autoInject,omitempty"`
	// Domain for the cluster, default: "cluster.local".
	//
	// K8s allows this to be customized, see https://kubernetes.io/docs/tasks/administer-cluster/dns-custom-nameservers/
	ClusterDomain string `protobuf:"bytes,5,opt,name=clusterDomain,proto3" json:"clusterDomain,omitempty"`
	// Per Component log level for proxy, applies to gateways and sidecars.
	//
	// If a component level is not set, then the global "logLevel" will be used. If left empty, "misc:error" is used.
	ComponentLogLevel string `protobuf:"bytes,6,opt,name=componentLogLevel,proto3" json:"componentLogLevel,omitempty"`
	// Enables core dumps for newly injected sidecars.
	//
	// If set, newly injected sidecars will have core dumps enabled.
	EnableCoreDump *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=enableCoreDump,proto3" json:"enableCoreDump,omitempty"`
	// Specifies the Istio ingress ports not to capture.
	ExcludeInboundPorts string `protobuf:"bytes,12,opt,name=excludeInboundPorts,proto3" json:"excludeInboundPorts,omitempty"`
	// Lists the excluded IP ranges of Istio egress traffic that the sidecar captures.
	ExcludeIPRanges string `protobuf:"bytes,13,opt,name=excludeIPRanges,proto3" json:"excludeIPRanges,omitempty"`
	// Image name or path for the proxy, default: "proxyv2".
	//
	// If registry or tag are not specified, global.hub and global.tag are used.
	//
	// Examples: my-proxy (uses global.hub/tag), docker.io/myrepo/my-proxy:v1.0.0
	Image string `protobuf:"bytes,14,opt,name=image,proto3" json:"image,omitempty"`
	// Lists the IP ranges of Istio egress traffic that the sidecar captures.
	//
	// Example: "172.30.0.0/16,172.20.0.0/16"
	// This would only capture egress traffic on those two IP Ranges, all other outbound traffic would # be allowed by the sidecar."
	IncludeIPRanges string `protobuf:"bytes,16,opt,name=includeIPRanges,proto3" json:"includeIPRanges,omitempty"`
	// Log level for proxy, applies to gateways and sidecars. If left empty, "warning" is used. Expected values are: trace\|debug\|info\|warning\|error\|critical\|off
	LogLevel string `protobuf:"bytes,18,opt,name=logLevel,proto3" json:"logLevel,omitempty"`
	// Enables privileged securityContext for the istio-proxy container.
	//
	// See https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	Privileged *wrapperspb.BoolValue `protobuf:"bytes,19,opt,name=privileged,proto3" json:"privileged,omitempty"`
	// Sets the initial delay for readiness probes in seconds.
	ReadinessInitialDelaySeconds uint32 `protobuf:"varint,20,opt,name=readinessInitialDelaySeconds,proto3" json:"readinessInitialDelaySeconds,omitempty"`
	// Sets the interval between readiness probes in seconds.
	ReadinessPeriodSeconds uint32 `protobuf:"varint,21,opt,name=readinessPeriodSeconds,proto3" json:"readinessPeriodSeconds,omitempty"`
	// Sets the number of successive failed probes before indicating readiness failure.
	ReadinessFailureThreshold uint32 `protobuf:"varint,22,opt,name=readinessFailureThreshold,proto3" json:"readinessFailureThreshold,omitempty"`
	// Default port used for the Pilot agent's health checks.
	StatusPort uint32 `protobuf:"varint,23,opt,name=statusPort,proto3" json:"statusPort,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Do not use.
	Resources            *Resources       `protobuf:"bytes,24,opt,name=resources,proto3" json:"resources,omitempty"`
	Tracer               Tracer           `protobuf:"varint,25,opt,name=tracer,proto3,enum=v1alpha1.Tracer" json:"tracer,omitempty"`
	ExcludeOutboundPorts string           `protobuf:"bytes,28,opt,name=excludeOutboundPorts,proto3" json:"excludeOutboundPorts,omitempty"`
	Lifecycle            *structpb.Struct `protobuf:"bytes,36,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// Controls if sidecar is injected at the front of the container list and blocks the start of the other containers until the proxy is ready
	//
	// Deprecated: replaced by ProxyConfig setting which allows per-pod configuration of this behavior.
	//
	// Deprecated: Do not use.
	HoldApplicationUntilProxyStarts *wrapperspb.BoolValue `protobuf:"bytes,37,opt,name=holdApplicationUntilProxyStarts,proto3" json:"holdApplicationUntilProxyStarts,omitempty"`
	IncludeInboundPorts             string                `protobuf:"bytes,38,opt,name=includeInboundPorts,proto3" json:"includeInboundPorts,omitempty"`
	IncludeOutboundPorts            string                `protobuf:"bytes,39,opt,name=includeOutboundPorts,proto3" json:"includeOutboundPorts,omitempty"`
}

func (x *ProxyConfig) Reset() {
	*x = ProxyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig) ProtoMessage() {}

func (x *ProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig.ProtoReflect.Descriptor instead.
func (*ProxyConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{31}
}

func (x *ProxyConfig) GetAutoInject() string {
	if x != nil {
		return x.AutoInject
	}
	return ""
}

func (x *ProxyConfig) GetClusterDomain() string {
	if x != nil {
		return x.ClusterDomain
	}
	return ""
}

func (x *ProxyConfig) GetComponentLogLevel() string {
	if x != nil {
		return x.ComponentLogLevel
	}
	return ""
}

func (x *ProxyConfig) GetEnableCoreDump() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableCoreDump
	}
	return nil
}

func (x *ProxyConfig) GetExcludeInboundPorts() string {
	if x != nil {
		return x.ExcludeInboundPorts
	}
	return ""
}

func (x *ProxyConfig) GetExcludeIPRanges() string {
	if x != nil {
		return x.ExcludeIPRanges
	}
	return ""
}

func (x *ProxyConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *ProxyConfig) GetIncludeIPRanges() string {
	if x != nil {
		return x.IncludeIPRanges
	}
	return ""
}

func (x *ProxyConfig) GetLogLevel() string {
	if x != nil {
		return x.LogLevel
	}
	return ""
}

func (x *ProxyConfig) GetPrivileged() *wrapperspb.BoolValue {
	if x != nil {
		return x.Privileged
	}
	return nil
}

func (x *ProxyConfig) GetReadinessInitialDelaySeconds() uint32 {
	if x != nil {
		return x.ReadinessInitialDelaySeconds
	}
	return 0
}

func (x *ProxyConfig) GetReadinessPeriodSeconds() uint32 {
	if x != nil {
		return x.ReadinessPeriodSeconds
	}
	return 0
}

func (x *ProxyConfig) GetReadinessFailureThreshold() uint32 {
	if x != nil {
		return x.ReadinessFailureThreshold
	}
	return 0
}

func (x *ProxyConfig) GetStatusPort() uint32 {
	if x != nil {
		return x.StatusPort
	}
	return 0
}

// Deprecated: Do not use.
func (x *ProxyConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ProxyConfig) GetTracer() Tracer {
	if x != nil {
		return x.Tracer
	}
	return Tracer_zipkin
}

func (x *ProxyConfig) GetExcludeOutboundPorts() string {
	if x != nil {
		return x.ExcludeOutboundPorts
	}
	return ""
}

func (x *ProxyConfig) GetLifecycle() *structpb.Struct {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

// Deprecated: Do not use.
func (x *ProxyConfig) GetHoldApplicationUntilProxyStarts() *wrapperspb.BoolValue {
	if x != nil {
		return x.HoldApplicationUntilProxyStarts
	}
	return nil
}

func (x *ProxyConfig) GetIncludeInboundPorts() string {
	if x != nil {
		return x.IncludeInboundPorts
	}
	return ""
}

func (x *ProxyConfig) GetIncludeOutboundPorts() string {
	if x != nil {
		return x.IncludeOutboundPorts
	}
	return ""
}

// Configuration for proxy_init container which sets the pods' networking to intercept the inbound/outbound traffic.
type ProxyInitConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the image for the proxy_init container.
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// K8s resources settings.
	//
	// See https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	//
	// Deprecated: Do not use.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
}

func (x *ProxyInitConfig) Reset() {
	*x = ProxyInitConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProxyInitConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyInitConfig) ProtoMessage() {}

func (x *ProxyInitConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyInitConfig.ProtoReflect.Descriptor instead.
func (*ProxyInitConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{32}
}

func (x *ProxyInitConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

// Deprecated: Do not use.
func (x *ProxyInitConfig) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

// Configuration for K8s resource requests.
type ResourcesRequestsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cpu    string `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	Memory string `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
}

func (x *ResourcesRequestsConfig) Reset() {
	*x = ResourcesRequestsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcesRequestsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcesRequestsConfig) ProtoMessage() {}

func (x *ResourcesRequestsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcesRequestsConfig.ProtoReflect.Descriptor instead.
func (*ResourcesRequestsConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{33}
}

func (x *ResourcesRequestsConfig) GetCpu() string {
	if x != nil {
		return x.Cpu
	}
	return ""
}

func (x *ResourcesRequestsConfig) GetMemory() string {
	if x != nil {
		return x.Memory
	}
	return ""
}

// Configuration for the SecretDiscoveryService instead of using K8S secrets to mount the certificates.
type SDSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Do not use.
	Token *structpb.Struct `protobuf:"bytes,5,opt,name=token,proto3" json:"token,omitempty"`
}

func (x *SDSConfig) Reset() {
	*x = SDSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SDSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SDSConfig) ProtoMessage() {}

func (x *SDSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SDSConfig.ProtoReflect.Descriptor instead.
func (*SDSConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{34}
}

// Deprecated: Do not use.
func (x *SDSConfig) GetToken() *structpb.Struct {
	if x != nil {
		return x.Token
	}
	return nil
}

// Configuration for secret volume mounts.
//
// See https://kubernetes.io/docs/concepts/configuration/secret/#using-secrets.
type SecretVolume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MountPath  string `protobuf:"bytes,1,opt,name=mountPath,proto3" json:"mountPath,omitempty"`
	Name       string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	SecretName string `protobuf:"bytes,3,opt,name=secretName,proto3" json:"secretName,omitempty"`
}

func (x *SecretVolume) Reset() {
	*x = SecretVolume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretVolume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVolume) ProtoMessage() {}

func (x *SecretVolume) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVolume.ProtoReflect.Descriptor instead.
func (*SecretVolume) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{35}
}

func (x *SecretVolume) GetMountPath() string {
	if x != nil {
		return x.MountPath
	}
	return ""
}

func (x *SecretVolume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecretVolume) GetSecretName() string {
	if x != nil {
		return x.SecretName
	}
	return ""
}

// ServiceConfig is described in istio.io documentation.
type ServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Annotations  *structpb.Struct `protobuf:"bytes,1,opt,name=annotations,proto3" json:"annotations,omitempty"`
	ExternalPort uint32           `protobuf:"varint,2,opt,name=externalPort,proto3" json:"externalPort,omitempty"`
	Name         string           `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Type         string           `protobuf:"bytes,18,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ServiceConfig) Reset() {
	*x = ServiceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConfig) ProtoMessage() {}

func (x *ServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConfig.ProtoReflect.Descriptor instead.
func (*ServiceConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{36}
}

func (x *ServiceConfig) GetAnnotations() *structpb.Struct {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ServiceConfig) GetExternalPort() uint32 {
	if x != nil {
		return x.ExternalPort
	}
	return 0
}

func (x *ServiceConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// SidecarInjectorConfig is described in istio.io documentation.
type SidecarInjectorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables sidecar auto-injection in namespaces by default.
	EnableNamespacesByDefault *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enableNamespacesByDefault,proto3" json:"enableNamespacesByDefault,omitempty"`
	// Instructs Istio to not inject the sidecar on those pods, based on labels that are present in those pods.
	//
	// Annotations in the pods have higher precedence than the label selectors.
	// Order of evaluation: Pod Annotations → NeverInjectSelector → AlwaysInjectSelector → Default Policy.
	// See https://istio.io/docs/setup/kubernetes/additional-setup/sidecar-injection/#more-control-adding-exceptions
	NeverInjectSelector []*structpb.Struct `protobuf:"bytes,11,rep,name=neverInjectSelector,proto3" json:"neverInjectSelector,omitempty"`
	// See NeverInjectSelector.
	AlwaysInjectSelector []*structpb.Struct `protobuf:"bytes,12,rep,name=alwaysInjectSelector,proto3" json:"alwaysInjectSelector,omitempty"`
	// If true, webhook or istioctl injector will rewrite PodSpec for liveness health check to redirect request to sidecar. This makes liveness check work even when mTLS is enabled.
	RewriteAppHTTPProbe *wrapperspb.BoolValue `protobuf:"bytes,16,opt,name=rewriteAppHTTPProbe,proto3" json:"rewriteAppHTTPProbe,omitempty"`
	// injectedAnnotations are additional annotations that will be added to the pod spec after injection
	// This is primarily to support PSP annotations.
	InjectedAnnotations *structpb.Struct `protobuf:"bytes,19,opt,name=injectedAnnotations,proto3" json:"injectedAnnotations,omitempty"`
	// Enable objectSelector to filter out pods with no need for sidecar before calling istio-sidecar-injector.
	ObjectSelector *structpb.Struct `protobuf:"bytes,21,opt,name=objectSelector,proto3" json:"objectSelector,omitempty"`
	// Configure the injection url for sidecar injector webhook
	InjectionURL string `protobuf:"bytes,22,opt,name=injectionURL,proto3" json:"injectionURL,omitempty"`
	// Templates defines a set of custom injection templates that can be used. For example, defining:
	//
	// templates:
	//
	//	hello: |
	//	  metadata:
	//	    labels:
	//	      hello: world
	//
	// Then starting a pod with the `inject.istio.io/templates: hello` annotation, will result in the pod
	// being injected with the hello=world labels.
	// This is intended for advanced configuration only; most users should use the built in template
	Templates *structpb.Struct `protobuf:"bytes,23,opt,name=templates,proto3" json:"templates,omitempty"`
	// defaultTemplates: ["sidecar", "hello"]
	DefaultTemplates []string `protobuf:"bytes,24,rep,name=defaultTemplates,proto3" json:"defaultTemplates,omitempty"`
	// If enabled, the legacy webhook selection logic will be used. This relies on filtering of webhook
	// requests in Istiod, rather than at the webhook selection level.
	// This is option is intended for migration purposes only and will be removed in Istio 1.10.
	//
	// Deprecated: Do not use.
	UseLegacySelectors *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=useLegacySelectors,proto3" json:"useLegacySelectors,omitempty"`
}

func (x *SidecarInjectorConfig) Reset() {
	*x = SidecarInjectorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SidecarInjectorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SidecarInjectorConfig) ProtoMessage() {}

func (x *SidecarInjectorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SidecarInjectorConfig.ProtoReflect.Descriptor instead.
func (*SidecarInjectorConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{37}
}

func (x *SidecarInjectorConfig) GetEnableNamespacesByDefault() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableNamespacesByDefault
	}
	return nil
}

func (x *SidecarInjectorConfig) GetNeverInjectSelector() []*structpb.Struct {
	if x != nil {
		return x.NeverInjectSelector
	}
	return nil
}

func (x *SidecarInjectorConfig) GetAlwaysInjectSelector() []*structpb.Struct {
	if x != nil {
		return x.AlwaysInjectSelector
	}
	return nil
}

func (x *SidecarInjectorConfig) GetRewriteAppHTTPProbe() *wrapperspb.BoolValue {
	if x != nil {
		return x.RewriteAppHTTPProbe
	}
	return nil
}

func (x *SidecarInjectorConfig) GetInjectedAnnotations() *structpb.Struct {
	if x != nil {
		return x.InjectedAnnotations
	}
	return nil
}

func (x *SidecarInjectorConfig) GetObjectSelector() *structpb.Struct {
	if x != nil {
		return x.ObjectSelector
	}
	return nil
}

func (x *SidecarInjectorConfig) GetInjectionURL() string {
	if x != nil {
		return x.InjectionURL
	}
	return ""
}

func (x *SidecarInjectorConfig) GetTemplates() *structpb.Struct {
	if x != nil {
		return x.Templates
	}
	return nil
}

func (x *SidecarInjectorConfig) GetDefaultTemplates() []string {
	if x != nil {
		return x.DefaultTemplates
	}
	return nil
}

// Deprecated: Do not use.
func (x *SidecarInjectorConfig) GetUseLegacySelectors() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseLegacySelectors
	}
	return nil
}

// Configuration for each of the supported tracers.
type TracerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for the datadog tracing service.
	Datadog *TracerDatadogConfig `protobuf:"bytes,1,opt,name=datadog,proto3" json:"datadog,omitempty"`
	// Configuration for the lightstep tracing service.
	Lightstep *TracerLightStepConfig `protobuf:"bytes,2,opt,name=lightstep,proto3" json:"lightstep,omitempty"`
	// Configuration for the zipkin tracing service.
	Zipkin *TracerZipkinConfig `protobuf:"bytes,3,opt,name=zipkin,proto3" json:"zipkin,omitempty"`
	// Configuration for the stackdriver tracing service.
	Stackdriver *TracerStackdriverConfig `protobuf:"bytes,4,opt,name=stackdriver,proto3" json:"stackdriver,omitempty"`
}

func (x *TracerConfig) Reset() {
	*x = TracerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TracerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerConfig) ProtoMessage() {}

func (x *TracerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerConfig.ProtoReflect.Descriptor instead.
func (*TracerConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{38}
}

func (x *TracerConfig) GetDatadog() *TracerDatadogConfig {
	if x != nil {
		return x.Datadog
	}
	return nil
}

func (x *TracerConfig) GetLightstep() *TracerLightStepConfig {
	if x != nil {
		return x.Lightstep
	}
	return nil
}

func (x *TracerConfig) GetZipkin() *TracerZipkinConfig {
	if x != nil {
		return x.Zipkin
	}
	return nil
}

func (x *TracerConfig) GetStackdriver() *TracerStackdriverConfig {
	if x != nil {
		return x.Stackdriver
	}
	return nil
}

// Configuration for the datadog tracing service.
type TracerDatadogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address in host:port format for reporting trace data to the Datadog agent.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *TracerDatadogConfig) Reset() {
	*x = TracerDatadogConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TracerDatadogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerDatadogConfig) ProtoMessage() {}

func (x *TracerDatadogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerDatadogConfig.ProtoReflect.Descriptor instead.
func (*TracerDatadogConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{39}
}

func (x *TracerDatadogConfig) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// Configuration for the lightstep tracing service.
type TracerLightStepConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sets the lightstep satellite pool address in host:port format for reporting trace data.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Sets the lightstep access token.
	AccessToken string `protobuf:"bytes,2,opt,name=accessToken,proto3" json:"accessToken,omitempty"`
}

func (x *TracerLightStepConfig) Reset() {
	*x = TracerLightStepConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TracerLightStepConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerLightStepConfig) ProtoMessage() {}

func (x *TracerLightStepConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerLightStepConfig.ProtoReflect.Descriptor instead.
func (*TracerLightStepConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{40}
}

func (x *TracerLightStepConfig) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *TracerLightStepConfig) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

// Configuration for the zipkin tracing service.
type TracerZipkinConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of zipkin instance in host:port format for reporting trace data.
	//
	// Example: <zipkin-collector-service>.<zipkin-collector-namespace>:941
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *TracerZipkinConfig) Reset() {
	*x = TracerZipkinConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TracerZipkinConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerZipkinConfig) ProtoMessage() {}

func (x *TracerZipkinConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerZipkinConfig.ProtoReflect.Descriptor instead.
func (*TracerZipkinConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{41}
}

func (x *TracerZipkinConfig) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// Configuration for the stackdriver tracing service.
type TracerStackdriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// enables trace output to stdout.
	Debug *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// The global default max number of attributes per span.
	MaxNumberOfAttributes uint32 `protobuf:"varint,2,opt,name=maxNumberOfAttributes,proto3" json:"maxNumberOfAttributes,omitempty"`
	// The global default max number of annotation events per span.
	MaxNumberOfAnnotations uint32 `protobuf:"varint,3,opt,name=maxNumberOfAnnotations,proto3" json:"maxNumberOfAnnotations,omitempty"`
	// The global default max number of message events per span.
	MaxNumberOfMessageEvents uint32 `protobuf:"varint,4,opt,name=maxNumberOfMessageEvents,proto3" json:"maxNumberOfMessageEvents,omitempty"`
}

func (x *TracerStackdriverConfig) Reset() {
	*x = TracerStackdriverConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TracerStackdriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TracerStackdriverConfig) ProtoMessage() {}

func (x *TracerStackdriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TracerStackdriverConfig.ProtoReflect.Descriptor instead.
func (*TracerStackdriverConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{42}
}

func (x *TracerStackdriverConfig) GetDebug() *wrapperspb.BoolValue {
	if x != nil {
		return x.Debug
	}
	return nil
}

func (x *TracerStackdriverConfig) GetMaxNumberOfAttributes() uint32 {
	if x != nil {
		return x.MaxNumberOfAttributes
	}
	return 0
}

func (x *TracerStackdriverConfig) GetMaxNumberOfAnnotations() uint32 {
	if x != nil {
		return x.MaxNumberOfAnnotations
	}
	return 0
}

func (x *TracerStackdriverConfig) GetMaxNumberOfMessageEvents() uint32 {
	if x != nil {
		return x.MaxNumberOfMessageEvents
	}
	return 0
}

type BaseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For Helm2 use, adds the CRDs to templates.
	EnableCRDTemplates *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enableCRDTemplates,proto3" json:"enableCRDTemplates,omitempty"`
	// URL to use for validating webhook.
	ValidationURL string `protobuf:"bytes,2,opt,name=validationURL,proto3" json:"validationURL,omitempty"`
	// For istioctl usage to disable istio config crds in base
	EnableIstioConfigCRDs *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=enableIstioConfigCRDs,proto3" json:"enableIstioConfigCRDs,omitempty"`
	ValidateGateway       *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=validateGateway,proto3" json:"validateGateway,omitempty"`
}

func (x *BaseConfig) Reset() {
	*x = BaseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BaseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BaseConfig) ProtoMessage() {}

func (x *BaseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BaseConfig.ProtoReflect.Descriptor instead.
func (*BaseConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{43}
}

func (x *BaseConfig) GetEnableCRDTemplates() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableCRDTemplates
	}
	return nil
}

func (x *BaseConfig) GetValidationURL() string {
	if x != nil {
		return x.ValidationURL
	}
	return ""
}

func (x *BaseConfig) GetEnableIstioConfigCRDs() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableIstioConfigCRDs
	}
	return nil
}

func (x *BaseConfig) GetValidateGateway() *wrapperspb.BoolValue {
	if x != nil {
		return x.ValidateGateway
	}
	return nil
}

type IstiodRemoteConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL to use for sidecar injector webhook.
	InjectionURL string `protobuf:"bytes,1,opt,name=injectionURL,proto3" json:"injectionURL,omitempty"`
	// Path to use for the sidecar injector webhook service.
	InjectionPath string `protobuf:"bytes,2,opt,name=injectionPath,proto3" json:"injectionPath,omitempty"`
}

func (x *IstiodRemoteConfig) Reset() {
	*x = IstiodRemoteConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IstiodRemoteConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstiodRemoteConfig) ProtoMessage() {}

func (x *IstiodRemoteConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstiodRemoteConfig.ProtoReflect.Descriptor instead.
func (*IstiodRemoteConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{44}
}

func (x *IstiodRemoteConfig) GetInjectionURL() string {
	if x != nil {
		return x.InjectionURL
	}
	return ""
}

func (x *IstiodRemoteConfig) GetInjectionPath() string {
	if x != nil {
		return x.InjectionPath
	}
	return ""
}

type Values struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cni      *CNIConfig      `protobuf:"bytes,2,opt,name=cni,proto3" json:"cni,omitempty"`
	Gateways *GatewaysConfig `protobuf:"bytes,5,opt,name=gateways,proto3" json:"gateways,omitempty"`
	Global   *GlobalConfig   `protobuf:"bytes,6,opt,name=global,proto3" json:"global,omitempty"`
	Pilot    *PilotConfig    `protobuf:"bytes,10,opt,name=pilot,proto3" json:"pilot,omitempty"`
	// Controls whether telemetry is exported for Pilot.
	Telemetry              *TelemetryConfig       `protobuf:"bytes,23,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	SidecarInjectorWebhook *SidecarInjectorConfig `protobuf:"bytes,13,opt,name=sidecarInjectorWebhook,proto3" json:"sidecarInjectorWebhook,omitempty"`
	IstioCni               *CNIConfig             `protobuf:"bytes,19,opt,name=istio_cni,json=istioCni,proto3" json:"istio_cni,omitempty"`
	Revision               string                 `protobuf:"bytes,21,opt,name=revision,proto3" json:"revision,omitempty"`
	OwnerName              string                 `protobuf:"bytes,22,opt,name=ownerName,proto3" json:"ownerName,omitempty"`
	// TODO can this import the real mesh config API?
	MeshConfig      *structpb.Value     `protobuf:"bytes,36,opt,name=meshConfig,proto3" json:"meshConfig,omitempty"`
	Base            *BaseConfig         `protobuf:"bytes,37,opt,name=base,proto3" json:"base,omitempty"`
	IstiodRemote    *IstiodRemoteConfig `protobuf:"bytes,38,opt,name=istiodRemote,proto3" json:"istiodRemote,omitempty"`
	RevisionTags    []string            `protobuf:"bytes,39,rep,name=revisionTags,proto3" json:"revisionTags,omitempty"`
	DefaultRevision string              `protobuf:"bytes,40,opt,name=defaultRevision,proto3" json:"defaultRevision,omitempty"`
}

func (x *Values) Reset() {
	*x = Values{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Values) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Values) ProtoMessage() {}

func (x *Values) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Values.ProtoReflect.Descriptor instead.
func (*Values) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{45}
}

func (x *Values) GetCni() *CNIConfig {
	if x != nil {
		return x.Cni
	}
	return nil
}

func (x *Values) GetGateways() *GatewaysConfig {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *Values) GetGlobal() *GlobalConfig {
	if x != nil {
		return x.Global
	}
	return nil
}

func (x *Values) GetPilot() *PilotConfig {
	if x != nil {
		return x.Pilot
	}
	return nil
}

func (x *Values) GetTelemetry() *TelemetryConfig {
	if x != nil {
		return x.Telemetry
	}
	return nil
}

func (x *Values) GetSidecarInjectorWebhook() *SidecarInjectorConfig {
	if x != nil {
		return x.SidecarInjectorWebhook
	}
	return nil
}

func (x *Values) GetIstioCni() *CNIConfig {
	if x != nil {
		return x.IstioCni
	}
	return nil
}

func (x *Values) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *Values) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *Values) GetMeshConfig() *structpb.Value {
	if x != nil {
		return x.MeshConfig
	}
	return nil
}

func (x *Values) GetBase() *BaseConfig {
	if x != nil {
		return x.Base
	}
	return nil
}

func (x *Values) GetIstiodRemote() *IstiodRemoteConfig {
	if x != nil {
		return x.IstiodRemote
	}
	return nil
}

func (x *Values) GetRevisionTags() []string {
	if x != nil {
		return x.RevisionTags
	}
	return nil
}

func (x *Values) GetDefaultRevision() string {
	if x != nil {
		return x.DefaultRevision
	}
	return ""
}

// ZeroVPNConfig enables cross-cluster access using SNI matching.
type ZeroVPNConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether ZeroVPN is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Suffix  string                `protobuf:"bytes,2,opt,name=suffix,proto3" json:"suffix,omitempty"`
}

func (x *ZeroVPNConfig) Reset() {
	*x = ZeroVPNConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZeroVPNConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZeroVPNConfig) ProtoMessage() {}

func (x *ZeroVPNConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZeroVPNConfig.ProtoReflect.Descriptor instead.
func (*ZeroVPNConfig) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{46}
}

func (x *ZeroVPNConfig) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *ZeroVPNConfig) GetSuffix() string {
	if x != nil {
		return x.Suffix
	}
	return ""
}

// IntOrString is a type that can hold an int32 or a string.  When used in
// JSON or YAML marshalling and unmarshalling, it produces or consumes the
// inner type.  This allows you to have, for example, a JSON field that can
// accept a name or number.
// TODO: Rename to Int32OrString
//
// +protobuf=true
// +protobuf.options.(gogoproto.goproto_stringer)=false
// +k8s:openapi-gen=true
type IntOrString struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type   int64                   `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	IntVal *wrapperspb.Int32Value  `protobuf:"bytes,2,opt,name=intVal,proto3" json:"intVal,omitempty"`
	StrVal *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=strVal,proto3" json:"strVal,omitempty"`
}

func (x *IntOrString) Reset() {
	*x = IntOrString{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntOrString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntOrString) ProtoMessage() {}

func (x *IntOrString) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntOrString.ProtoReflect.Descriptor instead.
func (*IntOrString) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{47}
}

func (x *IntOrString) GetType() int64 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *IntOrString) GetIntVal() *wrapperspb.Int32Value {
	if x != nil {
		return x.IntVal
	}
	return nil
}

func (x *IntOrString) GetStrVal() *wrapperspb.StringValue {
	if x != nil {
		return x.StrVal
	}
	return nil
}

type TelemetryV2PrometheusConfig_ConfigOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Overrides default gateway telemetry v2 configuration.
	Gateway *structpb.Struct `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Overrides default inbound sidecar telemetry v2 configuration.
	InboundSidecar *structpb.Struct `protobuf:"bytes,2,opt,name=inboundSidecar,proto3" json:"inboundSidecar,omitempty"`
	// Overrides default outbound sidecar telemetry v2 configuration.
	OutboundSidecar *structpb.Struct `protobuf:"bytes,3,opt,name=outboundSidecar,proto3" json:"outboundSidecar,omitempty"`
}

func (x *TelemetryV2PrometheusConfig_ConfigOverride) Reset() {
	*x = TelemetryV2PrometheusConfig_ConfigOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TelemetryV2PrometheusConfig_ConfigOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TelemetryV2PrometheusConfig_ConfigOverride) ProtoMessage() {}

func (x *TelemetryV2PrometheusConfig_ConfigOverride) ProtoReflect() protoreflect.Message {
	mi := &file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TelemetryV2PrometheusConfig_ConfigOverride.ProtoReflect.Descriptor instead.
func (*TelemetryV2PrometheusConfig_ConfigOverride) Descriptor() ([]byte, []int) {
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP(), []int{26, 0}
}

func (x *TelemetryV2PrometheusConfig_ConfigOverride) GetGateway() *structpb.Struct {
	if x != nil {
		return x.Gateway
	}
	return nil
}

func (x *TelemetryV2PrometheusConfig_ConfigOverride) GetInboundSidecar() *structpb.Struct {
	if x != nil {
		return x.InboundSidecar
	}
	return nil
}

func (x *TelemetryV2PrometheusConfig_ConfigOverride) GetOutboundSidecar() *structpb.Struct {
	if x != nil {
		return x.OutboundSidecar
	}
	return nil
}

var File_pkg_apis_istio_v1alpha1_values_types_proto protoreflect.FileDescriptor

var file_pkg_apis_istio_v1alpha1_values_types_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x69, 0x73, 0x74, 0x69, 0x6f,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x68, 0x0a, 0x0a, 0x41, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a,
	0x05, 0x61, 0x6d, 0x64, 0x36, 0x34, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x61, 0x6d,
	0x64, 0x36, 0x34, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x70, 0x63, 0x36, 0x34, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x70, 0x70, 0x63, 0x36, 0x34, 0x6c, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x73, 0x33, 0x39, 0x30, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x73, 0x33,
	0x39, 0x30, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x72, 0x6d, 0x36, 0x34, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x05, 0x61, 0x72, 0x6d, 0x36, 0x34, 0x22, 0xfa, 0x06, 0x0a, 0x09, 0x43, 0x4e,
	0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x10, 0x0a,
	0x03, 0x68, 0x75, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x68, 0x75, 0x62, 0x12,
	0x28, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x75, 0x6c,
	0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70,
	0x75, 0x6c, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6e, 0x69,
	0x42, 0x69, 0x6e, 0x44, 0x69, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6e,
	0x69, 0x42, 0x69, 0x6e, 0x44, 0x69, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6e, 0x69, 0x43, 0x6f,
	0x6e, 0x66, 0x44, 0x69, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6e, 0x69,
	0x43, 0x6f, 0x6e, 0x66, 0x44, 0x69, 0x72, 0x12, 0x28, 0x0a, 0x0f, 0x63, 0x6e, 0x69, 0x43, 0x6f,
	0x6e, 0x66, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x63, 0x6e, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x2c, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12,
	0x43, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x73, 0x70, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x70, 0x73, 0x70, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x06, 0x72, 0x65,
	0x70, 0x61, 0x69, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x4e, 0x49, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x12, 0x34, 0x0a,
	0x07, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x05, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x4e,
	0x49, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x74, 0x61,
	0x69, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x12, 0x31, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0a, 0x70, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x12, 0x3f, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x46, 0x0a, 0x0e, 0x43, 0x4e, 0x49, 0x54, 0x61, 0x69,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x8d,
	0x03, 0x0a, 0x0f, 0x43, 0x4e, 0x49, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x68, 0x75, 0x62, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x68, 0x75, 0x62, 0x12, 0x28, 0x0a, 0x03, 0x74, 0x61,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x03, 0x74, 0x61, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x50, 0x6f, 0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x50, 0x6f, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x64, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x64, 0x73,
	0x12, 0x2c, 0x0a, 0x11, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x6f, 0x64, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x4b, 0x65, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x62, 0x72, 0x6f,
	0x6b, 0x65, 0x6e, 0x50, 0x6f, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4b, 0x65, 0x79, 0x12, 0x30,
	0x0a, 0x13, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x6f, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x72, 0x6f,
	0x6b, 0x65, 0x6e, 0x50, 0x6f, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x2c, 0x0a, 0x11, 0x69, 0x6e, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x69,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x5a,
	0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73,
	0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x64, 0x73, 0x22, 0x58, 0x0a, 0x1a, 0x43, 0x50,
	0x55, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x18, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfb, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x37, 0x0a, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x08, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x4b, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x58, 0x0a, 0x20, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f, 0x64, 0x44, 0x69, 0x73,
	0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x57, 0x0a, 0x16, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x22, 0x9d, 0x0d, 0x0a, 0x13, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x10, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x4d,
	0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x65, 0x4d, 0x61, 0x78, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x65, 0x4d, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x4d, 0x69, 0x6e, 0x12, 0x3a, 0x0a, 0x03, 0x63, 0x70,
	0x75, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x43, 0x50, 0x55, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x40, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x29,
	0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x12, 0x41, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x3f, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x43, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x1c, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x74,
	0x69, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1c, 0x70, 0x6f, 0x64, 0x41, 0x6e,
	0x74, 0x69, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x67, 0x0a, 0x20, 0x70, 0x6f, 0x64, 0x41, 0x6e,
	0x74, 0x69, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x54, 0x65, 0x72, 0x6d, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x20,
	0x70, 0x6f, 0x64, 0x41, 0x6e, 0x74, 0x69, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x54,
	0x65, 0x72, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x12, 0x2b, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x35, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x12, 0x47, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x2b, 0x0a, 0x04, 0x7a, 0x76, 0x70, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x5a, 0x65, 0x72, 0x6f, 0x56, 0x50, 0x4e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x7a, 0x76, 0x70, 0x6e, 0x12, 0x3d, 0x0a, 0x0b,
	0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b,
	0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x0f, 0x72,
	0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x4f, 0x72, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65,
	0x12, 0x4f, 0x0a, 0x15, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x55, 0x6e,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x4f, 0x72,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x15, 0x72, 0x6f, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x3d, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73,
	0x12, 0x4b, 0x0a, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x38, 0x0a,
	0x09, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x72, 0x75,
	0x6e, 0x41, 0x73, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x2c, 0x0a, 0x11, 0x69, 0x6e, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x1b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xeb, 0x01, 0x0a, 0x0e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x13, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x5f, 0x65,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x13, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x2d, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x52, 0x0a, 0x14,
	0x69, 0x73, 0x74, 0x69, 0x6f, 0x5f, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x69, 0x73, 0x74, 0x69,
	0x6f, 0x2d, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x22, 0x80, 0x12, 0x0a, 0x0c, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x2c, 0x0a, 0x04, 0x61, 0x72, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x61, 0x72, 0x63, 0x68, 0x12,
	0x20, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x44,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72,
	0x73, 0x12, 0x30, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x1f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x34,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x1f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4d, 0x0a, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x6e, 0x0a, 0x1a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50,
	0x6f, 0x64, 0x44, 0x69, 0x73, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x6f, 0x64, 0x44, 0x69,
	0x73, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x50, 0x6f, 0x64, 0x44, 0x69, 0x73, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x54, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x37, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x68, 0x75, 0x62, 0x12, 0x28, 0x0a, 0x0f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x75,
	0x6c, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x75, 0x6c, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x2a, 0x0a, 0x10, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x75, 0x6c, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x18, 0x25, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x50, 0x75, 0x6c, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x69,
	0x73, 0x74, 0x69, 0x6f, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x41, 0x73, 0x4a, 0x73, 0x6f, 0x6e,
	0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x41, 0x73, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x37, 0x0a,
	0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x49, 0x44,
	0x18, 0x35, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x49, 0x44, 0x12, 0x3b,
	0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x68, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0c, 0x6d,
	0x65, 0x73, 0x68, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x40, 0x0a, 0x0c, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x75, 0x6c,
	0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x18, 0x0a,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x27, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x36, 0x0a, 0x16, 0x70, 0x6f, 0x64, 0x44, 0x4e,
	0x53, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x18, 0x2b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x70, 0x6f, 0x64, 0x44, 0x4e, 0x53, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12,
	0x5e, 0x0a, 0x1c, 0x6f, 0x6d, 0x69, 0x74, 0x53, 0x69, 0x64, 0x65, 0x63, 0x61, 0x72, 0x49, 0x6e,
	0x6a, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x18,
	0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x1c, 0x6f, 0x6d, 0x69, 0x74, 0x53, 0x69, 0x64, 0x65, 0x63, 0x61, 0x72, 0x49, 0x6e,
	0x6a, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x12,
	0x3e, 0x0a, 0x0c, 0x6f, 0x6e, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x6f, 0x6e, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x52, 0x0a, 0x16, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x73, 0x12, 0x30, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x11, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x12, 0x39, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x69, 0x6e, 0x69, 0x74,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x49, 0x6e, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x12, 0x25, 0x0a,
	0x03, 0x73, 0x64, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x44, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x03, 0x73, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x1f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x18, 0x43, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x72, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x4d,
	0x43, 0x50, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x75, 0x73, 0x65, 0x4d, 0x43, 0x50, 0x12, 0x2e, 0x0a, 0x12,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x69, 0x6c, 0x6f, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x30, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x50, 0x69, 0x6c, 0x6f, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2e, 0x0a, 0x06,
	0x69, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x18, 0x36, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x12, 0x2c, 0x0a, 0x11,
	0x70, 0x69, 0x6c, 0x6f, 0x74, 0x43, 0x65, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x18, 0x38, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x69, 0x6c, 0x6f, 0x74, 0x43, 0x65,
	0x72, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x6a, 0x77,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x39, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6a,
	0x77, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x25, 0x0a, 0x03, 0x73, 0x74, 0x73, 0x18,
	0x3a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x53, 0x54, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x73, 0x74, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x3b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0e, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x74, 0x6c, 0x73, 0x43, 0x65, 0x72, 0x74, 0x73, 0x18, 0x3c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0e, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x74, 0x6c, 0x73, 0x43, 0x65, 0x72, 0x74, 0x73, 0x12,
	0x1c, 0x0a, 0x09, 0x63, 0x61, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x3d, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x61, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x42, 0x0a,
	0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x18,
	0x3e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x73, 0x74, 0x69, 0x6f,
	0x64, 0x12, 0x40, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x18, 0x40, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x41, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x10, 0x61,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x76, 0x32, 0x41, 0x50, 0x49, 0x18,
	0x42, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x76, 0x32,
	0x41, 0x50, 0x49, 0x22, 0x2d, 0x0a, 0x09, 0x53, 0x54, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x6f,
	0x72, 0x74, 0x22, 0x52, 0x0a, 0x0c, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x42, 0x0a, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0x2b, 0x0a, 0x13, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a,
	0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x22, 0xad, 0x0f, 0x0a, 0x14, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x10,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x65, 0x4d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x65, 0x4d, 0x61, 0x78, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x65, 0x4d, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x4d, 0x69, 0x6e, 0x12, 0x3a, 0x0a, 0x03,
	0x63, 0x70, 0x75, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x50, 0x55, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x40, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x29, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x12, 0x42, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x26, 0x0a, 0x0e, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49,
	0x50, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x50, 0x12, 0x3a, 0x0a, 0x18, 0x6c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x52, 0x18, 0x6c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x2c, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x43, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x70,
	0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a,
	0x1c, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x74, 0x69, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x15, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x1c, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x74, 0x69, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x67,
	0x0a, 0x20, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x74, 0x69, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x54, 0x65, 0x72, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x20, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x74, 0x69, 0x41, 0x66,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x54, 0x65, 0x72, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x2b, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x7a, 0x76, 0x70, 0x6e, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5a, 0x76, 0x70, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x7a, 0x76, 0x70, 0x6e, 0x12, 0x43, 0x0a, 0x0f, 0x72, 0x6f,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x18, 0x1f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49,
	0x6e, 0x74, 0x4f, 0x72, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f,
	0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x12,
	0x4f, 0x0a, 0x15, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x55, 0x6e, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x4f, 0x72, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x15, 0x72, 0x6f, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x4d, 0x61, 0x78, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x34, 0x0a, 0x15, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x22, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3d, 0x0a, 0x0b, 0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x23, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b, 0x0a, 0x0c, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x50, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x24, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x0c, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x72,
	0x74, 0x73, 0x12, 0x4b, 0x0a, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x25, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12,
	0x3d, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73,
	0x18, 0x26, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x38,
	0x0a, 0x09, 0x72, 0x75, 0x6e, 0x41, 0x73, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x2d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x72,
	0x75, 0x6e, 0x41, 0x73, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x2c, 0x0a, 0x11, 0x69, 0x6e, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x2e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x68, 0x0a, 0x18, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5a, 0x76, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x22, 0xe8, 0x01,
	0x0a, 0x12, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x12,
	0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x4a, 0x0a, 0x12,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x6e, 0x76,
	0x6f, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x87, 0x01, 0x0a, 0x1b, 0x4f, 0x75, 0x74,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x28, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x4e, 0x59, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x01, 0x22, 0xf0, 0x0d, 0x0a, 0x0b, 0x50, 0x69, 0x6c, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x46, 0x0a, 0x10, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x22, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x4d, 0x69, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x65, 0x4d, 0x69, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x65, 0x4d, 0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x65, 0x4d, 0x61, 0x78, 0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x63, 0x65, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x35, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x3a, 0x0a,
	0x03, 0x63, 0x70, 0x75, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x50, 0x55, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x55,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x3f, 0x0a, 0x0c, 0x6e, 0x6f, 0x64,
	0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x6e, 0x6f,
	0x64, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x63, 0x0a, 0x1f, 0x6b, 0x65,
	0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x67, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1f,
	0x6b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x4d, 0x61, 0x78, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x67, 0x65, 0x12,
	0x43, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x35, 0x0a, 0x09, 0x70, 0x6f, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x09, 0x70, 0x6f, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x38, 0x0a, 0x09, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4d, 0x61, 0x70, 0x12, 0x32, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x4d, 0x43, 0x50, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x75, 0x73, 0x65, 0x4d, 0x43, 0x50, 0x12, 0x29, 0x0a, 0x03, 0x65, 0x6e, 0x76,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x03, 0x65, 0x6e, 0x76, 0x12, 0x43, 0x0a, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d,
	0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x4f, 0x72, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x4d, 0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x12, 0x4f, 0x0a, 0x15, 0x72, 0x6f, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x4f, 0x72, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x15, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x78, 0x55,
	0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3d, 0x0a, 0x0b, 0x74, 0x6f,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x74, 0x6f,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x68, 0x0a, 0x21, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x6e, 0x69, 0x66, 0x66,
	0x69, 0x6e, 0x67, 0x46, 0x6f, 0x72, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x21, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x53, 0x6e, 0x69, 0x66, 0x66, 0x69, 0x6e, 0x67, 0x46, 0x6f, 0x72, 0x4f, 0x75, 0x74, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x12, 0x66, 0x0a, 0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x6e, 0x69, 0x66, 0x66, 0x69, 0x6e, 0x67, 0x46, 0x6f, 0x72,
	0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x6e, 0x69, 0x66, 0x66, 0x69, 0x6e,
	0x67, 0x46, 0x6f, 0x72, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x43, 0x0a, 0x0e, 0x70,
	0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0e, 0x70, 0x6f, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x47, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x69, 0x6c, 0x6f, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0c, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x17, 0x6a, 0x77,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x45, 0x78, 0x74, 0x72, 0x61, 0x52,
	0x6f, 0x6f, 0x74, 0x43, 0x41, 0x18, 0x20, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x6a, 0x77, 0x6b,
	0x73, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x45, 0x78, 0x74, 0x72, 0x61, 0x52, 0x6f,
	0x6f, 0x74, 0x43, 0x41, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x18,
	0x21, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x12, 0x10,
	0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x22, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x68, 0x75, 0x62,
	0x12, 0x28, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x18, 0x27, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x12, 0x50, 0x69, 0x6c, 0x6f, 0x74, 0x49,
	0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0e,
	0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x15, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x69,
	0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x15, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x69,
	0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22,
	0x49, 0x0a, 0x11, 0x50, 0x69, 0x6c, 0x6f, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x74, 0x0a, 0x0f, 0x54, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x12, 0x2b, 0x0a, 0x02, 0x76, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x02, 0x76, 0x32,
	0x22, 0x92, 0x03, 0x0a, 0x11, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56, 0x32,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x58, 0x0a, 0x11,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74,
	0x68, 0x65, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56,
	0x32, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x12, 0x48, 0x0a,
	0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x12, 0x5c, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c,
	0x6f, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x61, 0x0a, 0x21, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x79, 0x56, 0x32, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x78, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x0b, 0x77, 0x61,
	0x73, 0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x77, 0x61, 0x73,
	0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xba, 0x03, 0x0a, 0x1b, 0x54, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x50, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65,
	0x75, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3c,
	0x0a, 0x0b, 0x77, 0x61, 0x73, 0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0b, 0x77, 0x61, 0x73, 0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x0f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x50, 0x72, 0x6f, 0x6d,
	0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x1a, 0xc7, 0x01, 0x0a, 0x0e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x31,
	0x0a, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x12, 0x3f, 0x0a, 0x0e, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x69, 0x64, 0x65,
	0x63, 0x61, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0e, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x69, 0x64, 0x65, 0x63,
	0x61, 0x72, 0x12, 0x41, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x69,
	0x64, 0x65, 0x63, 0x61, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x69,
	0x64, 0x65, 0x63, 0x61, 0x72, 0x22, 0x99, 0x05, 0x0a, 0x1c, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x74, 0x72, 0x79, 0x56, 0x32, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x07,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x3a, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x12, 0x3a, 0x0a, 0x08, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x12, 0x44,
	0x0a, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x75, 0x74, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x12, 0x3f, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x6a, 0x0a, 0x15, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x52, 0x15, 0x6f, 0x75, 0x74, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x12, 0x68, 0x0a, 0x14, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x79, 0x56, 0x32, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x44, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x52, 0x14, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x22, 0x34, 0x0a, 0x0d, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x53, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10,
	0x02, 0x22, 0xa7, 0x01, 0x0a, 0x26, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x56,
	0x32, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x47, 0x0a, 0x11, 0x6c, 0x6f, 0x67, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6c, 0x6f, 0x67, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0x0a, 0x11, 0x50,
	0x69, 0x6c, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x30, 0x0a, 0x13, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x22, 0x8d, 0x01, 0x0a, 0x0b, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x22, 0xaf, 0x08, 0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x49, 0x6e, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x2c, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x42, 0x0a, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x72, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x12, 0x30, 0x0a, 0x13, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x0f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x50, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x50,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x28, 0x0a, 0x0f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x50, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x50,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x3a, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x12, 0x42,
	0x0a, 0x1c, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x1c, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x12, 0x36, 0x0a, 0x16, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x50,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x16, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x3c, 0x0a, 0x19, 0x72, 0x65,
	0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x19, 0x72,
	0x65, 0x61, 0x64, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x54,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x35, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x28, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x72, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x10, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x72, 0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x14, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74,
	0x73, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x35, 0x0a,
	0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x12, 0x68, 0x0a, 0x1f, 0x68, 0x6f, 0x6c, 0x64, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x74, 0x69, 0x6c, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x73, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1f, 0x68,
	0x6f, 0x6c, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e,
	0x74, 0x69, 0x6c, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x73, 0x12, 0x30,
	0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x50, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x26, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x73,
	0x12, 0x32, 0x0a, 0x14, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x75, 0x74, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x27, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x50,
	0x6f, 0x72, 0x74, 0x73, 0x22, 0x5e, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x49, 0x6e, 0x69,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x35, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x22, 0x43, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x10, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x70,
	0x75, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x22, 0x3e, 0x0a, 0x09, 0x53, 0x44, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x60, 0x0a, 0x0c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x0d,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0xba, 0x05, 0x0a, 0x15, 0x53, 0x69, 0x64, 0x65, 0x63, 0x61, 0x72,
	0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58,
	0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x73, 0x42, 0x79, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x42,
	0x79, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x49, 0x0a, 0x13, 0x6e, 0x65, 0x76, 0x65,
	0x72, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x13,
	0x6e, 0x65, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x12, 0x4b, 0x0a, 0x14, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x49, 0x6e, 0x6a,
	0x65, 0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x14, 0x61, 0x6c, 0x77, 0x61,
	0x79, 0x73, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x12, 0x4c, 0x0a, 0x13, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x41, 0x70, 0x70, 0x48, 0x54,
	0x54, 0x50, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x72, 0x65, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x41, 0x70, 0x70, 0x48, 0x54, 0x54, 0x50, 0x50, 0x72, 0x6f, 0x62, 0x65, 0x12, 0x49,
	0x0a, 0x13, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x13, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x0e, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x22, 0x0a, 0x0c, 0x69, 0x6e,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x52, 0x4c, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x52, 0x4c, 0x12, 0x35,
	0x0a, 0x09, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x09, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x12, 0x4e, 0x0a, 0x12, 0x75, 0x73, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x75,
	0x73, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x22, 0x81, 0x02, 0x0a, 0x0c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x37, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x64, 0x6f, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x64, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x64, 0x6f, 0x67, 0x12, 0x3d, 0x0a, 0x09, 0x6c,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x74, 0x65, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x72,
	0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x74, 0x65, 0x70, 0x12, 0x34, 0x0a, 0x06, 0x7a, 0x69,
	0x70, 0x6b, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x72, 0x5a, 0x69, 0x70, 0x6b,
	0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x7a, 0x69, 0x70, 0x6b, 0x69, 0x6e,
	0x12, 0x43, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x72, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x72, 0x22, 0x2f, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x63, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x64, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x53, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x63, 0x65, 0x72,
	0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x2e, 0x0a, 0x12, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x72, 0x5a, 0x69, 0x70, 0x6b, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xf5, 0x01, 0x0a, 0x17,
	0x54, 0x72, 0x61, 0x63, 0x65, 0x72, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x0a, 0x05, 0x64, 0x65, 0x62, 0x75, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x05, 0x64, 0x65, 0x62, 0x75, 0x67, 0x12, 0x34, 0x0a, 0x15, 0x6d, 0x61, 0x78,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x4f, 0x66, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x36, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x16, 0x6d, 0x61, 0x78, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x18, 0x6d, 0x61, 0x78, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x22, 0x96, 0x02, 0x0a, 0x0a, 0x42, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x4a, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x52, 0x44, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x52, 0x44, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x24,
	0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x52, 0x4c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x55, 0x52, 0x4c, 0x12, 0x50, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x73,
	0x74, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x52, 0x44, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x43, 0x52, 0x44, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x22, 0x5e, 0x0a, 0x12,
	0x49, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x22, 0x0a, 0x0c, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x52, 0x4c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x55, 0x52, 0x4c, 0x12, 0x24, 0x0a, 0x0d, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69,
	0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x22, 0xb2, 0x05, 0x0a,
	0x06, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x03, 0x63, 0x6e, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x4e, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x63, 0x6e, 0x69, 0x12, 0x34,
	0x0a, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x12, 0x2e, 0x0a, 0x06, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x12, 0x2b, 0x0a, 0x05, 0x70, 0x69, 0x6c, 0x6f, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50,
	0x69, 0x6c, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x70, 0x69, 0x6c, 0x6f,
	0x74, 0x12, 0x37, 0x0a, 0x09, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x18, 0x17,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x12, 0x57, 0x0a, 0x16, 0x73, 0x69,
	0x64, 0x65, 0x63, 0x61, 0x72, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x69, 0x64, 0x65, 0x63, 0x61, 0x72, 0x49, 0x6e, 0x6a,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73, 0x69, 0x64,
	0x65, 0x63, 0x61, 0x72, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x57, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x12, 0x30, 0x0a, 0x09, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x5f, 0x63, 0x6e, 0x69,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x43, 0x4e, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x69, 0x73, 0x74,
	0x69, 0x6f, 0x43, 0x6e, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x36, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x24, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x6d, 0x65, 0x73,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x04, 0x62, 0x61, 0x73, 0x65, 0x18,
	0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x42, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x62, 0x61, 0x73,
	0x65, 0x12, 0x40, 0x0a, 0x0c, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x64, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x61, 0x67, 0x73, 0x18, 0x27, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73, 0x12, 0x28, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x5d, 0x0a, 0x0d, 0x5a, 0x65, 0x72, 0x6f, 0x56, 0x50, 0x4e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78,
	0x22, 0x8c, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x4f, 0x72, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x12, 0x34, 0x0a, 0x06, 0x73, 0x74, 0x72,
	0x56, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x73, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x2a,
	0x4a, 0x0a, 0x15, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46,
	0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54,
	0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x03, 0x2a, 0x60, 0x0a, 0x06, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x72, 0x12, 0x0a, 0x0a, 0x06, 0x7a, 0x69, 0x70, 0x6b, 0x69, 0x6e, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x74, 0x65, 0x70, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x64, 0x6f, 0x67, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x10, 0x03, 0x12, 0x13,
	0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x6e, 0x43, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x6e, 0x6f, 0x6e, 0x65, 0x10, 0x05, 0x42, 0x31, 0x5a,
	0x2f, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x2e, 0x69, 0x6f, 0x2f, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescOnce sync.Once
	file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescData = file_pkg_apis_istio_v1alpha1_values_types_proto_rawDesc
)

func file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescGZIP() []byte {
	file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescOnce.Do(func() {
		file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescData)
	})
	return file_pkg_apis_istio_v1alpha1_values_types_proto_rawDescData
}

var file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes = make([]protoimpl.MessageInfo, 53)
var file_pkg_apis_istio_v1alpha1_values_types_proto_goTypes = []interface{}{
	(IngressControllerMode)(0),                         // 0: v1alpha1.ingressControllerMode
	(Tracer)(0),                                        // 1: v1alpha1.tracer
	(OutboundTrafficPolicyConfig_Mode)(0),              // 2: v1alpha1.OutboundTrafficPolicyConfig.Mode
	(TelemetryV2StackDriverConfig_AccessLogging)(0),    // 3: v1alpha1.TelemetryV2StackDriverConfig.AccessLogging
	(*ArchConfig)(nil),                                 // 4: v1alpha1.ArchConfig
	(*CNIConfig)(nil),                                  // 5: v1alpha1.CNIConfig
	(*CNITaintConfig)(nil),                             // 6: v1alpha1.CNITaintConfig
	(*CNIRepairConfig)(nil),                            // 7: v1alpha1.CNIRepairConfig
	(*ResourceQuotas)(nil),                             // 8: v1alpha1.ResourceQuotas
	(*CPUTargetUtilizationConfig)(nil),                 // 9: v1alpha1.CPUTargetUtilizationConfig
	(*Resources)(nil),                                  // 10: v1alpha1.Resources
	(*ServiceAccount)(nil),                             // 11: v1alpha1.ServiceAccount
	(*DefaultPodDisruptionBudgetConfig)(nil),           // 12: v1alpha1.DefaultPodDisruptionBudgetConfig
	(*DefaultResourcesConfig)(nil),                     // 13: v1alpha1.DefaultResourcesConfig
	(*EgressGatewayConfig)(nil),                        // 14: v1alpha1.EgressGatewayConfig
	(*GatewaysConfig)(nil),                             // 15: v1alpha1.GatewaysConfig
	(*GlobalConfig)(nil),                               // 16: v1alpha1.GlobalConfig
	(*STSConfig)(nil),                                  // 17: v1alpha1.STSConfig
	(*IstiodConfig)(nil),                               // 18: v1alpha1.IstiodConfig
	(*GlobalLoggingConfig)(nil),                        // 19: v1alpha1.GlobalLoggingConfig
	(*IngressGatewayConfig)(nil),                       // 20: v1alpha1.IngressGatewayConfig
	(*IngressGatewayZvpnConfig)(nil),                   // 21: v1alpha1.IngressGatewayZvpnConfig
	(*MultiClusterConfig)(nil),                         // 22: v1alpha1.MultiClusterConfig
	(*OutboundTrafficPolicyConfig)(nil),                // 23: v1alpha1.OutboundTrafficPolicyConfig
	(*PilotConfig)(nil),                                // 24: v1alpha1.PilotConfig
	(*PilotIngressConfig)(nil),                         // 25: v1alpha1.PilotIngressConfig
	(*PilotPolicyConfig)(nil),                          // 26: v1alpha1.PilotPolicyConfig
	(*TelemetryConfig)(nil),                            // 27: v1alpha1.TelemetryConfig
	(*TelemetryV2Config)(nil),                          // 28: v1alpha1.TelemetryV2Config
	(*TelemetryV2MetadataExchangeConfig)(nil),          // 29: v1alpha1.TelemetryV2MetadataExchangeConfig
	(*TelemetryV2PrometheusConfig)(nil),                // 30: v1alpha1.TelemetryV2PrometheusConfig
	(*TelemetryV2StackDriverConfig)(nil),               // 31: v1alpha1.TelemetryV2StackDriverConfig
	(*TelemetryV2AccessLogPolicyFilterConfig)(nil),     // 32: v1alpha1.TelemetryV2AccessLogPolicyFilterConfig
	(*PilotConfigSource)(nil),                          // 33: v1alpha1.PilotConfigSource
	(*PortsConfig)(nil),                                // 34: v1alpha1.PortsConfig
	(*ProxyConfig)(nil),                                // 35: v1alpha1.ProxyConfig
	(*ProxyInitConfig)(nil),                            // 36: v1alpha1.ProxyInitConfig
	(*ResourcesRequestsConfig)(nil),                    // 37: v1alpha1.ResourcesRequestsConfig
	(*SDSConfig)(nil),                                  // 38: v1alpha1.SDSConfig
	(*SecretVolume)(nil),                               // 39: v1alpha1.SecretVolume
	(*ServiceConfig)(nil),                              // 40: v1alpha1.ServiceConfig
	(*SidecarInjectorConfig)(nil),                      // 41: v1alpha1.SidecarInjectorConfig
	(*TracerConfig)(nil),                               // 42: v1alpha1.TracerConfig
	(*TracerDatadogConfig)(nil),                        // 43: v1alpha1.TracerDatadogConfig
	(*TracerLightStepConfig)(nil),                      // 44: v1alpha1.TracerLightStepConfig
	(*TracerZipkinConfig)(nil),                         // 45: v1alpha1.TracerZipkinConfig
	(*TracerStackdriverConfig)(nil),                    // 46: v1alpha1.TracerStackdriverConfig
	(*BaseConfig)(nil),                                 // 47: v1alpha1.BaseConfig
	(*IstiodRemoteConfig)(nil),                         // 48: v1alpha1.IstiodRemoteConfig
	(*Values)(nil),                                     // 49: v1alpha1.Values
	(*ZeroVPNConfig)(nil),                              // 50: v1alpha1.ZeroVPNConfig
	(*IntOrString)(nil),                                // 51: v1alpha1.IntOrString
	nil,                                                // 52: v1alpha1.Resources.LimitsEntry
	nil,                                                // 53: v1alpha1.Resources.RequestsEntry
	nil,                                                // 54: v1alpha1.EgressGatewayConfig.LabelsEntry
	nil,                                                // 55: v1alpha1.IngressGatewayConfig.LabelsEntry
	(*TelemetryV2PrometheusConfig_ConfigOverride)(nil), // 56: v1alpha1.TelemetryV2PrometheusConfig.ConfigOverride
	(*wrapperspb.BoolValue)(nil),                       // 57: google.protobuf.BoolValue
	(*structpb.Value)(nil),                             // 58: google.protobuf.Value
	(*structpb.Struct)(nil),                            // 59: google.protobuf.Struct
	(*durationpb.Duration)(nil),                        // 60: google.protobuf.Duration
	(*wrapperspb.Int32Value)(nil),                      // 61: google.protobuf.Int32Value
	(*wrapperspb.StringValue)(nil),                     // 62: google.protobuf.StringValue
}
var file_pkg_apis_istio_v1alpha1_values_types_proto_depIdxs = []int32{
	57,  // 0: v1alpha1.CNIConfig.enabled:type_name -> google.protobuf.BoolValue
	58,  // 1: v1alpha1.CNIConfig.tag:type_name -> google.protobuf.Value
	59,  // 2: v1alpha1.CNIConfig.podAnnotations:type_name -> google.protobuf.Struct
	7,   // 3: v1alpha1.CNIConfig.repair:type_name -> v1alpha1.CNIRepairConfig
	57,  // 4: v1alpha1.CNIConfig.chained:type_name -> google.protobuf.BoolValue
	6,   // 5: v1alpha1.CNIConfig.taint:type_name -> v1alpha1.CNITaintConfig
	8,   // 6: v1alpha1.CNIConfig.resource_quotas:type_name -> v1alpha1.ResourceQuotas
	10,  // 7: v1alpha1.CNIConfig.resources:type_name -> v1alpha1.Resources
	57,  // 8: v1alpha1.CNIConfig.privileged:type_name -> google.protobuf.BoolValue
	59,  // 9: v1alpha1.CNIConfig.seccompProfile:type_name -> google.protobuf.Struct
	57,  // 10: v1alpha1.CNITaintConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 11: v1alpha1.CNIRepairConfig.enabled:type_name -> google.protobuf.BoolValue
	58,  // 12: v1alpha1.CNIRepairConfig.tag:type_name -> google.protobuf.Value
	57,  // 13: v1alpha1.ResourceQuotas.enabled:type_name -> google.protobuf.BoolValue
	52,  // 14: v1alpha1.Resources.limits:type_name -> v1alpha1.Resources.LimitsEntry
	53,  // 15: v1alpha1.Resources.requests:type_name -> v1alpha1.Resources.RequestsEntry
	59,  // 16: v1alpha1.ServiceAccount.annotations:type_name -> google.protobuf.Struct
	57,  // 17: v1alpha1.DefaultPodDisruptionBudgetConfig.enabled:type_name -> google.protobuf.BoolValue
	37,  // 18: v1alpha1.DefaultResourcesConfig.requests:type_name -> v1alpha1.ResourcesRequestsConfig
	57,  // 19: v1alpha1.EgressGatewayConfig.autoscaleEnabled:type_name -> google.protobuf.BoolValue
	9,   // 20: v1alpha1.EgressGatewayConfig.cpu:type_name -> v1alpha1.CPUTargetUtilizationConfig
	57,  // 21: v1alpha1.EgressGatewayConfig.customService:type_name -> google.protobuf.BoolValue
	57,  // 22: v1alpha1.EgressGatewayConfig.enabled:type_name -> google.protobuf.BoolValue
	59,  // 23: v1alpha1.EgressGatewayConfig.env:type_name -> google.protobuf.Struct
	54,  // 24: v1alpha1.EgressGatewayConfig.labels:type_name -> v1alpha1.EgressGatewayConfig.LabelsEntry
	59,  // 25: v1alpha1.EgressGatewayConfig.nodeSelector:type_name -> google.protobuf.Struct
	59,  // 26: v1alpha1.EgressGatewayConfig.podAnnotations:type_name -> google.protobuf.Struct
	59,  // 27: v1alpha1.EgressGatewayConfig.podAntiAffinityLabelSelector:type_name -> google.protobuf.Struct
	59,  // 28: v1alpha1.EgressGatewayConfig.podAntiAffinityTermLabelSelector:type_name -> google.protobuf.Struct
	34,  // 29: v1alpha1.EgressGatewayConfig.ports:type_name -> v1alpha1.PortsConfig
	10,  // 30: v1alpha1.EgressGatewayConfig.resources:type_name -> v1alpha1.Resources
	39,  // 31: v1alpha1.EgressGatewayConfig.secretVolumes:type_name -> v1alpha1.SecretVolume
	59,  // 32: v1alpha1.EgressGatewayConfig.serviceAnnotations:type_name -> google.protobuf.Struct
	50,  // 33: v1alpha1.EgressGatewayConfig.zvpn:type_name -> v1alpha1.ZeroVPNConfig
	59,  // 34: v1alpha1.EgressGatewayConfig.tolerations:type_name -> google.protobuf.Struct
	51,  // 35: v1alpha1.EgressGatewayConfig.rollingMaxSurge:type_name -> v1alpha1.IntOrString
	51,  // 36: v1alpha1.EgressGatewayConfig.rollingMaxUnavailable:type_name -> v1alpha1.IntOrString
	59,  // 37: v1alpha1.EgressGatewayConfig.configVolumes:type_name -> google.protobuf.Struct
	59,  // 38: v1alpha1.EgressGatewayConfig.additionalContainers:type_name -> google.protobuf.Struct
	57,  // 39: v1alpha1.EgressGatewayConfig.runAsRoot:type_name -> google.protobuf.BoolValue
	11,  // 40: v1alpha1.EgressGatewayConfig.serviceAccount:type_name -> v1alpha1.ServiceAccount
	14,  // 41: v1alpha1.GatewaysConfig.istio_egressgateway:type_name -> v1alpha1.EgressGatewayConfig
	57,  // 42: v1alpha1.GatewaysConfig.enabled:type_name -> google.protobuf.BoolValue
	20,  // 43: v1alpha1.GatewaysConfig.istio_ingressgateway:type_name -> v1alpha1.IngressGatewayConfig
	4,   // 44: v1alpha1.GlobalConfig.arch:type_name -> v1alpha1.ArchConfig
	57,  // 45: v1alpha1.GlobalConfig.configValidation:type_name -> google.protobuf.BoolValue
	59,  // 46: v1alpha1.GlobalConfig.defaultNodeSelector:type_name -> google.protobuf.Struct
	12,  // 47: v1alpha1.GlobalConfig.defaultPodDisruptionBudget:type_name -> v1alpha1.DefaultPodDisruptionBudgetConfig
	13,  // 48: v1alpha1.GlobalConfig.defaultResources:type_name -> v1alpha1.DefaultResourcesConfig
	59,  // 49: v1alpha1.GlobalConfig.defaultTolerations:type_name -> google.protobuf.Struct
	57,  // 50: v1alpha1.GlobalConfig.logAsJson:type_name -> google.protobuf.BoolValue
	19,  // 51: v1alpha1.GlobalConfig.logging:type_name -> v1alpha1.GlobalLoggingConfig
	59,  // 52: v1alpha1.GlobalConfig.meshNetworks:type_name -> google.protobuf.Struct
	22,  // 53: v1alpha1.GlobalConfig.multiCluster:type_name -> v1alpha1.MultiClusterConfig
	57,  // 54: v1alpha1.GlobalConfig.omitSidecarInjectorConfigMap:type_name -> google.protobuf.BoolValue
	57,  // 55: v1alpha1.GlobalConfig.oneNamespace:type_name -> google.protobuf.BoolValue
	57,  // 56: v1alpha1.GlobalConfig.operatorManageWebhooks:type_name -> google.protobuf.BoolValue
	35,  // 57: v1alpha1.GlobalConfig.proxy:type_name -> v1alpha1.ProxyConfig
	36,  // 58: v1alpha1.GlobalConfig.proxy_init:type_name -> v1alpha1.ProxyInitConfig
	38,  // 59: v1alpha1.GlobalConfig.sds:type_name -> v1alpha1.SDSConfig
	58,  // 60: v1alpha1.GlobalConfig.tag:type_name -> google.protobuf.Value
	42,  // 61: v1alpha1.GlobalConfig.tracer:type_name -> v1alpha1.TracerConfig
	57,  // 62: v1alpha1.GlobalConfig.useMCP:type_name -> google.protobuf.BoolValue
	18,  // 63: v1alpha1.GlobalConfig.istiod:type_name -> v1alpha1.IstiodConfig
	17,  // 64: v1alpha1.GlobalConfig.sts:type_name -> v1alpha1.STSConfig
	57,  // 65: v1alpha1.GlobalConfig.mountMtlsCerts:type_name -> google.protobuf.BoolValue
	57,  // 66: v1alpha1.GlobalConfig.externalIstiod:type_name -> google.protobuf.BoolValue
	57,  // 67: v1alpha1.GlobalConfig.configCluster:type_name -> google.protobuf.BoolValue
	57,  // 68: v1alpha1.GlobalConfig.autoscalingv2API:type_name -> google.protobuf.BoolValue
	57,  // 69: v1alpha1.IstiodConfig.enableAnalysis:type_name -> google.protobuf.BoolValue
	57,  // 70: v1alpha1.IngressGatewayConfig.autoscaleEnabled:type_name -> google.protobuf.BoolValue
	9,   // 71: v1alpha1.IngressGatewayConfig.cpu:type_name -> v1alpha1.CPUTargetUtilizationConfig
	57,  // 72: v1alpha1.IngressGatewayConfig.customService:type_name -> google.protobuf.BoolValue
	57,  // 73: v1alpha1.IngressGatewayConfig.enabled:type_name -> google.protobuf.BoolValue
	59,  // 74: v1alpha1.IngressGatewayConfig.env:type_name -> google.protobuf.Struct
	55,  // 75: v1alpha1.IngressGatewayConfig.labels:type_name -> v1alpha1.IngressGatewayConfig.LabelsEntry
	59,  // 76: v1alpha1.IngressGatewayConfig.nodeSelector:type_name -> google.protobuf.Struct
	59,  // 77: v1alpha1.IngressGatewayConfig.podAnnotations:type_name -> google.protobuf.Struct
	59,  // 78: v1alpha1.IngressGatewayConfig.podAntiAffinityLabelSelector:type_name -> google.protobuf.Struct
	59,  // 79: v1alpha1.IngressGatewayConfig.podAntiAffinityTermLabelSelector:type_name -> google.protobuf.Struct
	34,  // 80: v1alpha1.IngressGatewayConfig.ports:type_name -> v1alpha1.PortsConfig
	59,  // 81: v1alpha1.IngressGatewayConfig.resources:type_name -> google.protobuf.Struct
	39,  // 82: v1alpha1.IngressGatewayConfig.secretVolumes:type_name -> v1alpha1.SecretVolume
	59,  // 83: v1alpha1.IngressGatewayConfig.serviceAnnotations:type_name -> google.protobuf.Struct
	21,  // 84: v1alpha1.IngressGatewayConfig.zvpn:type_name -> v1alpha1.IngressGatewayZvpnConfig
	51,  // 85: v1alpha1.IngressGatewayConfig.rollingMaxSurge:type_name -> v1alpha1.IntOrString
	51,  // 86: v1alpha1.IngressGatewayConfig.rollingMaxUnavailable:type_name -> v1alpha1.IntOrString
	59,  // 87: v1alpha1.IngressGatewayConfig.tolerations:type_name -> google.protobuf.Struct
	59,  // 88: v1alpha1.IngressGatewayConfig.ingressPorts:type_name -> google.protobuf.Struct
	59,  // 89: v1alpha1.IngressGatewayConfig.additionalContainers:type_name -> google.protobuf.Struct
	59,  // 90: v1alpha1.IngressGatewayConfig.configVolumes:type_name -> google.protobuf.Struct
	57,  // 91: v1alpha1.IngressGatewayConfig.runAsRoot:type_name -> google.protobuf.BoolValue
	11,  // 92: v1alpha1.IngressGatewayConfig.serviceAccount:type_name -> v1alpha1.ServiceAccount
	57,  // 93: v1alpha1.IngressGatewayZvpnConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 94: v1alpha1.MultiClusterConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 95: v1alpha1.MultiClusterConfig.includeEnvoyFilter:type_name -> google.protobuf.BoolValue
	2,   // 96: v1alpha1.OutboundTrafficPolicyConfig.mode:type_name -> v1alpha1.OutboundTrafficPolicyConfig.Mode
	57,  // 97: v1alpha1.PilotConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 98: v1alpha1.PilotConfig.autoscaleEnabled:type_name -> google.protobuf.BoolValue
	10,  // 99: v1alpha1.PilotConfig.resources:type_name -> v1alpha1.Resources
	9,   // 100: v1alpha1.PilotConfig.cpu:type_name -> v1alpha1.CPUTargetUtilizationConfig
	59,  // 101: v1alpha1.PilotConfig.nodeSelector:type_name -> google.protobuf.Struct
	60,  // 102: v1alpha1.PilotConfig.keepaliveMaxServerConnectionAge:type_name -> google.protobuf.Duration
	59,  // 103: v1alpha1.PilotConfig.deploymentLabels:type_name -> google.protobuf.Struct
	59,  // 104: v1alpha1.PilotConfig.podLabels:type_name -> google.protobuf.Struct
	57,  // 105: v1alpha1.PilotConfig.configMap:type_name -> google.protobuf.BoolValue
	57,  // 106: v1alpha1.PilotConfig.useMCP:type_name -> google.protobuf.BoolValue
	59,  // 107: v1alpha1.PilotConfig.env:type_name -> google.protobuf.Struct
	51,  // 108: v1alpha1.PilotConfig.rollingMaxSurge:type_name -> v1alpha1.IntOrString
	51,  // 109: v1alpha1.PilotConfig.rollingMaxUnavailable:type_name -> v1alpha1.IntOrString
	59,  // 110: v1alpha1.PilotConfig.tolerations:type_name -> google.protobuf.Struct
	57,  // 111: v1alpha1.PilotConfig.enableProtocolSniffingForOutbound:type_name -> google.protobuf.BoolValue
	57,  // 112: v1alpha1.PilotConfig.enableProtocolSniffingForInbound:type_name -> google.protobuf.BoolValue
	59,  // 113: v1alpha1.PilotConfig.podAnnotations:type_name -> google.protobuf.Struct
	59,  // 114: v1alpha1.PilotConfig.serviceAnnotations:type_name -> google.protobuf.Struct
	33,  // 115: v1alpha1.PilotConfig.configSource:type_name -> v1alpha1.PilotConfigSource
	58,  // 116: v1alpha1.PilotConfig.tag:type_name -> google.protobuf.Value
	59,  // 117: v1alpha1.PilotConfig.seccompProfile:type_name -> google.protobuf.Struct
	0,   // 118: v1alpha1.PilotIngressConfig.ingressControllerMode:type_name -> v1alpha1.ingressControllerMode
	57,  // 119: v1alpha1.PilotPolicyConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 120: v1alpha1.TelemetryConfig.enabled:type_name -> google.protobuf.BoolValue
	28,  // 121: v1alpha1.TelemetryConfig.v2:type_name -> v1alpha1.TelemetryV2Config
	57,  // 122: v1alpha1.TelemetryV2Config.enabled:type_name -> google.protobuf.BoolValue
	29,  // 123: v1alpha1.TelemetryV2Config.metadata_exchange:type_name -> v1alpha1.TelemetryV2MetadataExchangeConfig
	30,  // 124: v1alpha1.TelemetryV2Config.prometheus:type_name -> v1alpha1.TelemetryV2PrometheusConfig
	31,  // 125: v1alpha1.TelemetryV2Config.stackdriver:type_name -> v1alpha1.TelemetryV2StackDriverConfig
	32,  // 126: v1alpha1.TelemetryV2Config.access_log_policy:type_name -> v1alpha1.TelemetryV2AccessLogPolicyFilterConfig
	57,  // 127: v1alpha1.TelemetryV2MetadataExchangeConfig.wasmEnabled:type_name -> google.protobuf.BoolValue
	57,  // 128: v1alpha1.TelemetryV2PrometheusConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 129: v1alpha1.TelemetryV2PrometheusConfig.wasmEnabled:type_name -> google.protobuf.BoolValue
	56,  // 130: v1alpha1.TelemetryV2PrometheusConfig.config_override:type_name -> v1alpha1.TelemetryV2PrometheusConfig.ConfigOverride
	57,  // 131: v1alpha1.TelemetryV2StackDriverConfig.enabled:type_name -> google.protobuf.BoolValue
	57,  // 132: v1alpha1.TelemetryV2StackDriverConfig.logging:type_name -> google.protobuf.BoolValue
	57,  // 133: v1alpha1.TelemetryV2StackDriverConfig.monitoring:type_name -> google.protobuf.BoolValue
	57,  // 134: v1alpha1.TelemetryV2StackDriverConfig.topology:type_name -> google.protobuf.BoolValue
	57,  // 135: v1alpha1.TelemetryV2StackDriverConfig.disableOutbound:type_name -> google.protobuf.BoolValue
	59,  // 136: v1alpha1.TelemetryV2StackDriverConfig.configOverride:type_name -> google.protobuf.Struct
	3,   // 137: v1alpha1.TelemetryV2StackDriverConfig.outboundAccessLogging:type_name -> v1alpha1.TelemetryV2StackDriverConfig.AccessLogging
	3,   // 138: v1alpha1.TelemetryV2StackDriverConfig.inboundAccessLogging:type_name -> v1alpha1.TelemetryV2StackDriverConfig.AccessLogging
	57,  // 139: v1alpha1.TelemetryV2AccessLogPolicyFilterConfig.enabled:type_name -> google.protobuf.BoolValue
	60,  // 140: v1alpha1.TelemetryV2AccessLogPolicyFilterConfig.logWindowDuration:type_name -> google.protobuf.Duration
	57,  // 141: v1alpha1.ProxyConfig.enableCoreDump:type_name -> google.protobuf.BoolValue
	57,  // 142: v1alpha1.ProxyConfig.privileged:type_name -> google.protobuf.BoolValue
	10,  // 143: v1alpha1.ProxyConfig.resources:type_name -> v1alpha1.Resources
	1,   // 144: v1alpha1.ProxyConfig.tracer:type_name -> v1alpha1.tracer
	59,  // 145: v1alpha1.ProxyConfig.lifecycle:type_name -> google.protobuf.Struct
	57,  // 146: v1alpha1.ProxyConfig.holdApplicationUntilProxyStarts:type_name -> google.protobuf.BoolValue
	10,  // 147: v1alpha1.ProxyInitConfig.resources:type_name -> v1alpha1.Resources
	59,  // 148: v1alpha1.SDSConfig.token:type_name -> google.protobuf.Struct
	59,  // 149: v1alpha1.ServiceConfig.annotations:type_name -> google.protobuf.Struct
	57,  // 150: v1alpha1.SidecarInjectorConfig.enableNamespacesByDefault:type_name -> google.protobuf.BoolValue
	59,  // 151: v1alpha1.SidecarInjectorConfig.neverInjectSelector:type_name -> google.protobuf.Struct
	59,  // 152: v1alpha1.SidecarInjectorConfig.alwaysInjectSelector:type_name -> google.protobuf.Struct
	57,  // 153: v1alpha1.SidecarInjectorConfig.rewriteAppHTTPProbe:type_name -> google.protobuf.BoolValue
	59,  // 154: v1alpha1.SidecarInjectorConfig.injectedAnnotations:type_name -> google.protobuf.Struct
	59,  // 155: v1alpha1.SidecarInjectorConfig.objectSelector:type_name -> google.protobuf.Struct
	59,  // 156: v1alpha1.SidecarInjectorConfig.templates:type_name -> google.protobuf.Struct
	57,  // 157: v1alpha1.SidecarInjectorConfig.useLegacySelectors:type_name -> google.protobuf.BoolValue
	43,  // 158: v1alpha1.TracerConfig.datadog:type_name -> v1alpha1.TracerDatadogConfig
	44,  // 159: v1alpha1.TracerConfig.lightstep:type_name -> v1alpha1.TracerLightStepConfig
	45,  // 160: v1alpha1.TracerConfig.zipkin:type_name -> v1alpha1.TracerZipkinConfig
	46,  // 161: v1alpha1.TracerConfig.stackdriver:type_name -> v1alpha1.TracerStackdriverConfig
	57,  // 162: v1alpha1.TracerStackdriverConfig.debug:type_name -> google.protobuf.BoolValue
	57,  // 163: v1alpha1.BaseConfig.enableCRDTemplates:type_name -> google.protobuf.BoolValue
	57,  // 164: v1alpha1.BaseConfig.enableIstioConfigCRDs:type_name -> google.protobuf.BoolValue
	57,  // 165: v1alpha1.BaseConfig.validateGateway:type_name -> google.protobuf.BoolValue
	5,   // 166: v1alpha1.Values.cni:type_name -> v1alpha1.CNIConfig
	15,  // 167: v1alpha1.Values.gateways:type_name -> v1alpha1.GatewaysConfig
	16,  // 168: v1alpha1.Values.global:type_name -> v1alpha1.GlobalConfig
	24,  // 169: v1alpha1.Values.pilot:type_name -> v1alpha1.PilotConfig
	27,  // 170: v1alpha1.Values.telemetry:type_name -> v1alpha1.TelemetryConfig
	41,  // 171: v1alpha1.Values.sidecarInjectorWebhook:type_name -> v1alpha1.SidecarInjectorConfig
	5,   // 172: v1alpha1.Values.istio_cni:type_name -> v1alpha1.CNIConfig
	58,  // 173: v1alpha1.Values.meshConfig:type_name -> google.protobuf.Value
	47,  // 174: v1alpha1.Values.base:type_name -> v1alpha1.BaseConfig
	48,  // 175: v1alpha1.Values.istiodRemote:type_name -> v1alpha1.IstiodRemoteConfig
	57,  // 176: v1alpha1.ZeroVPNConfig.enabled:type_name -> google.protobuf.BoolValue
	61,  // 177: v1alpha1.IntOrString.intVal:type_name -> google.protobuf.Int32Value
	62,  // 178: v1alpha1.IntOrString.strVal:type_name -> google.protobuf.StringValue
	59,  // 179: v1alpha1.TelemetryV2PrometheusConfig.ConfigOverride.gateway:type_name -> google.protobuf.Struct
	59,  // 180: v1alpha1.TelemetryV2PrometheusConfig.ConfigOverride.inboundSidecar:type_name -> google.protobuf.Struct
	59,  // 181: v1alpha1.TelemetryV2PrometheusConfig.ConfigOverride.outboundSidecar:type_name -> google.protobuf.Struct
	182, // [182:182] is the sub-list for method output_type
	182, // [182:182] is the sub-list for method input_type
	182, // [182:182] is the sub-list for extension type_name
	182, // [182:182] is the sub-list for extension extendee
	0,   // [0:182] is the sub-list for field type_name
}

func init() { file_pkg_apis_istio_v1alpha1_values_types_proto_init() }
func file_pkg_apis_istio_v1alpha1_values_types_proto_init() {
	if File_pkg_apis_istio_v1alpha1_values_types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CNIConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CNITaintConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CNIRepairConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceQuotas); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CPUTargetUtilizationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultPodDisruptionBudgetConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DefaultResourcesConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EgressGatewayConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewaysConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GlobalConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*STSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IstiodConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GlobalLoggingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngressGatewayConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngressGatewayZvpnConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MultiClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundTrafficPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PilotConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PilotIngressConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PilotPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryV2Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryV2MetadataExchangeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryV2PrometheusConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryV2StackDriverConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryV2AccessLogPolicyFilterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PilotConfigSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PortsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProxyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProxyInitConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcesRequestsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SDSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretVolume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SidecarInjectorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TracerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TracerDatadogConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TracerLightStepConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TracerZipkinConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TracerStackdriverConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BaseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IstiodRemoteConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Values); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ZeroVPNConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntOrString); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TelemetryV2PrometheusConfig_ConfigOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pkg_apis_istio_v1alpha1_values_types_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   53,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pkg_apis_istio_v1alpha1_values_types_proto_goTypes,
		DependencyIndexes: file_pkg_apis_istio_v1alpha1_values_types_proto_depIdxs,
		EnumInfos:         file_pkg_apis_istio_v1alpha1_values_types_proto_enumTypes,
		MessageInfos:      file_pkg_apis_istio_v1alpha1_values_types_proto_msgTypes,
	}.Build()
	File_pkg_apis_istio_v1alpha1_values_types_proto = out.File
	file_pkg_apis_istio_v1alpha1_values_types_proto_rawDesc = nil
	file_pkg_apis_istio_v1alpha1_values_types_proto_goTypes = nil
	file_pkg_apis_istio_v1alpha1_values_types_proto_depIdxs = nil
}
