// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by pilot/pkg/config/kube/crdclient/gen/types.go.tmpl DO NOT EDIT!

package crdclient

// This file contains Go definitions for Custom Resource Definition kinds
// to adhere to the idiomatic use of k8s API machinery.
// These definitions are synthesized from Istio configuration type descriptors
// as declared in the Istio config model.

import (
	"context"
	"fmt"

	admissionregistrationv1 "k8s.io/api/admissionregistration/v1"
	appsv1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	extensionsv1beta1 "k8s.io/api/extensions/v1beta1"
	apiextensionsv1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/types"
	gatewayv1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
	gatewayv1beta1 "sigs.k8s.io/gateway-api/apis/v1beta1"
	gatewayapiclient "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned"

	extensionsv1alpha1 "istio.io/api/extensions/v1alpha1"
	metav1alpha1 "istio.io/api/meta/v1alpha1"
	networkingv1alpha3 "istio.io/api/networking/v1alpha3"
	networkingv1beta1 "istio.io/api/networking/v1beta1"
	securityv1beta1 "istio.io/api/security/v1beta1"
	telemetryv1alpha1 "istio.io/api/telemetry/v1alpha1"
	clientextensionsv1alpha1 "istio.io/client-go/pkg/apis/extensions/v1alpha1"
	clientnetworkingv1alpha3 "istio.io/client-go/pkg/apis/networking/v1alpha3"
	clientnetworkingv1beta1 "istio.io/client-go/pkg/apis/networking/v1beta1"
	clientsecurityv1beta1 "istio.io/client-go/pkg/apis/security/v1beta1"
	clienttelemetryv1alpha1 "istio.io/client-go/pkg/apis/telemetry/v1alpha1"
	versionedclient "istio.io/client-go/pkg/clientset/versioned"
	"istio.io/istio/pkg/config"
	"istio.io/istio/pkg/config/schema/collections"
)

func create(ic versionedclient.Interface, sc gatewayapiclient.Interface, cfg config.Config, objMeta metav1.ObjectMeta) (metav1.Object, error) {
	switch cfg.GroupVersionKind {
	case collections.IstioExtensionsV1Alpha1Wasmplugins.Resource().GroupVersionKind():
		return ic.ExtensionsV1alpha1().WasmPlugins(cfg.Namespace).Create(context.TODO(), &clientextensionsv1alpha1.WasmPlugin{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*extensionsv1alpha1.WasmPlugin)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().DestinationRules(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.DestinationRule{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.DestinationRule)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().EnvoyFilters(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.EnvoyFilter{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.EnvoyFilter)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Gateways(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.Gateway{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.Gateway)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().ServiceEntries(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.ServiceEntry{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.ServiceEntry)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Sidecars(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.Sidecar{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.Sidecar)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().VirtualServices(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.VirtualService{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.VirtualService)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Workloadentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadEntries(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.WorkloadEntry{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.WorkloadEntry)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Alpha3Workloadgroups.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadGroups(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1alpha3.WorkloadGroup{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.WorkloadGroup)),
		}, metav1.CreateOptions{})
	case collections.IstioNetworkingV1Beta1Proxyconfigs.Resource().GroupVersionKind():
		return ic.NetworkingV1beta1().ProxyConfigs(cfg.Namespace).Create(context.TODO(), &clientnetworkingv1beta1.ProxyConfig{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1beta1.ProxyConfig)),
		}, metav1.CreateOptions{})
	case collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().AuthorizationPolicies(cfg.Namespace).Create(context.TODO(), &clientsecurityv1beta1.AuthorizationPolicy{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*securityv1beta1.AuthorizationPolicy)),
		}, metav1.CreateOptions{})
	case collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().PeerAuthentications(cfg.Namespace).Create(context.TODO(), &clientsecurityv1beta1.PeerAuthentication{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*securityv1beta1.PeerAuthentication)),
		}, metav1.CreateOptions{})
	case collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().RequestAuthentications(cfg.Namespace).Create(context.TODO(), &clientsecurityv1beta1.RequestAuthentication{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*securityv1beta1.RequestAuthentication)),
		}, metav1.CreateOptions{})
	case collections.IstioTelemetryV1Alpha1Telemetries.Resource().GroupVersionKind():
		return ic.TelemetryV1alpha1().Telemetries(cfg.Namespace).Create(context.TODO(), &clienttelemetryv1alpha1.Telemetry{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*telemetryv1alpha1.Telemetry)),
		}, metav1.CreateOptions{})
	case collections.K8SGatewayApiV1Alpha2Referencegrants.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().ReferenceGrants(cfg.Namespace).Create(context.TODO(), &gatewayv1alpha2.ReferenceGrant{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}, metav1.CreateOptions{})
	case collections.K8SGatewayApiV1Alpha2Referencepolicies.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().ReferencePolicies(cfg.Namespace).Create(context.TODO(), &gatewayv1alpha2.ReferencePolicy{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}, metav1.CreateOptions{})
	case collections.K8SGatewayApiV1Alpha2Tcproutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TCPRoutes(cfg.Namespace).Create(context.TODO(), &gatewayv1alpha2.TCPRoute{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.TCPRouteSpec)),
		}, metav1.CreateOptions{})
	case collections.K8SGatewayApiV1Alpha2Tlsroutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TLSRoutes(cfg.Namespace).Create(context.TODO(), &gatewayv1alpha2.TLSRoute{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.TLSRouteSpec)),
		}, metav1.CreateOptions{})
	case collections.K8SGatewayApiV1Beta1Gatewayclasses.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().GatewayClasses().Create(context.TODO(), &gatewayv1beta1.GatewayClass{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1beta1.GatewayClassSpec)),
		}, metav1.CreateOptions{})
	case collections.K8SGatewayApiV1Beta1Gateways.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().Gateways(cfg.Namespace).Create(context.TODO(), &gatewayv1beta1.Gateway{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1beta1.GatewaySpec)),
		}, metav1.CreateOptions{})
	case collections.K8SGatewayApiV1Beta1Httproutes.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().HTTPRoutes(cfg.Namespace).Create(context.TODO(), &gatewayv1beta1.HTTPRoute{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1beta1.HTTPRouteSpec)),
		}, metav1.CreateOptions{})
	default:
		return nil, fmt.Errorf("unsupported type: %v", cfg.GroupVersionKind)
	}
}

func update(ic versionedclient.Interface, sc gatewayapiclient.Interface, cfg config.Config, objMeta metav1.ObjectMeta) (metav1.Object, error) {
	switch cfg.GroupVersionKind {
	case collections.IstioExtensionsV1Alpha1Wasmplugins.Resource().GroupVersionKind():
		return ic.ExtensionsV1alpha1().WasmPlugins(cfg.Namespace).Update(context.TODO(), &clientextensionsv1alpha1.WasmPlugin{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*extensionsv1alpha1.WasmPlugin)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().DestinationRules(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.DestinationRule{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.DestinationRule)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().EnvoyFilters(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.EnvoyFilter{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.EnvoyFilter)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Gateways(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.Gateway{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.Gateway)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().ServiceEntries(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.ServiceEntry{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.ServiceEntry)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Sidecars(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.Sidecar{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.Sidecar)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().VirtualServices(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.VirtualService{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.VirtualService)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Workloadentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadEntries(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.WorkloadEntry{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.WorkloadEntry)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Alpha3Workloadgroups.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadGroups(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1alpha3.WorkloadGroup{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1alpha3.WorkloadGroup)),
		}, metav1.UpdateOptions{})
	case collections.IstioNetworkingV1Beta1Proxyconfigs.Resource().GroupVersionKind():
		return ic.NetworkingV1beta1().ProxyConfigs(cfg.Namespace).Update(context.TODO(), &clientnetworkingv1beta1.ProxyConfig{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*networkingv1beta1.ProxyConfig)),
		}, metav1.UpdateOptions{})
	case collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().AuthorizationPolicies(cfg.Namespace).Update(context.TODO(), &clientsecurityv1beta1.AuthorizationPolicy{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*securityv1beta1.AuthorizationPolicy)),
		}, metav1.UpdateOptions{})
	case collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().PeerAuthentications(cfg.Namespace).Update(context.TODO(), &clientsecurityv1beta1.PeerAuthentication{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*securityv1beta1.PeerAuthentication)),
		}, metav1.UpdateOptions{})
	case collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().RequestAuthentications(cfg.Namespace).Update(context.TODO(), &clientsecurityv1beta1.RequestAuthentication{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*securityv1beta1.RequestAuthentication)),
		}, metav1.UpdateOptions{})
	case collections.IstioTelemetryV1Alpha1Telemetries.Resource().GroupVersionKind():
		return ic.TelemetryV1alpha1().Telemetries(cfg.Namespace).Update(context.TODO(), &clienttelemetryv1alpha1.Telemetry{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*telemetryv1alpha1.Telemetry)),
		}, metav1.UpdateOptions{})
	case collections.K8SGatewayApiV1Alpha2Referencegrants.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().ReferenceGrants(cfg.Namespace).Update(context.TODO(), &gatewayv1alpha2.ReferenceGrant{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}, metav1.UpdateOptions{})
	case collections.K8SGatewayApiV1Alpha2Referencepolicies.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().ReferencePolicies(cfg.Namespace).Update(context.TODO(), &gatewayv1alpha2.ReferencePolicy{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}, metav1.UpdateOptions{})
	case collections.K8SGatewayApiV1Alpha2Tcproutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TCPRoutes(cfg.Namespace).Update(context.TODO(), &gatewayv1alpha2.TCPRoute{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.TCPRouteSpec)),
		}, metav1.UpdateOptions{})
	case collections.K8SGatewayApiV1Alpha2Tlsroutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TLSRoutes(cfg.Namespace).Update(context.TODO(), &gatewayv1alpha2.TLSRoute{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1alpha2.TLSRouteSpec)),
		}, metav1.UpdateOptions{})
	case collections.K8SGatewayApiV1Beta1Gatewayclasses.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().GatewayClasses().Update(context.TODO(), &gatewayv1beta1.GatewayClass{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1beta1.GatewayClassSpec)),
		}, metav1.UpdateOptions{})
	case collections.K8SGatewayApiV1Beta1Gateways.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().Gateways(cfg.Namespace).Update(context.TODO(), &gatewayv1beta1.Gateway{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1beta1.GatewaySpec)),
		}, metav1.UpdateOptions{})
	case collections.K8SGatewayApiV1Beta1Httproutes.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().HTTPRoutes(cfg.Namespace).Update(context.TODO(), &gatewayv1beta1.HTTPRoute{
			ObjectMeta: objMeta,
			Spec:       *(cfg.Spec.(*gatewayv1beta1.HTTPRouteSpec)),
		}, metav1.UpdateOptions{})
	default:
		return nil, fmt.Errorf("unsupported type: %v", cfg.GroupVersionKind)
	}
}

func updateStatus(ic versionedclient.Interface, sc gatewayapiclient.Interface, cfg config.Config, objMeta metav1.ObjectMeta) (metav1.Object, error) {
	switch cfg.GroupVersionKind {

	case collections.IstioExtensionsV1Alpha1Wasmplugins.Resource().GroupVersionKind():
		return ic.ExtensionsV1alpha1().WasmPlugins(cfg.Namespace).UpdateStatus(context.TODO(), &clientextensionsv1alpha1.WasmPlugin{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().DestinationRules(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.DestinationRule{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().EnvoyFilters(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.EnvoyFilter{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Gateways(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.Gateway{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().ServiceEntries(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.ServiceEntry{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Sidecars(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.Sidecar{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().VirtualServices(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.VirtualService{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Workloadentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadEntries(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.WorkloadEntry{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Alpha3Workloadgroups.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadGroups(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1alpha3.WorkloadGroup{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioNetworkingV1Beta1Proxyconfigs.Resource().GroupVersionKind():
		return ic.NetworkingV1beta1().ProxyConfigs(cfg.Namespace).UpdateStatus(context.TODO(), &clientnetworkingv1beta1.ProxyConfig{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().AuthorizationPolicies(cfg.Namespace).UpdateStatus(context.TODO(), &clientsecurityv1beta1.AuthorizationPolicy{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().PeerAuthentications(cfg.Namespace).UpdateStatus(context.TODO(), &clientsecurityv1beta1.PeerAuthentication{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().RequestAuthentications(cfg.Namespace).UpdateStatus(context.TODO(), &clientsecurityv1beta1.RequestAuthentication{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.IstioTelemetryV1Alpha1Telemetries.Resource().GroupVersionKind():
		return ic.TelemetryV1alpha1().Telemetries(cfg.Namespace).UpdateStatus(context.TODO(), &clienttelemetryv1alpha1.Telemetry{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*metav1alpha1.IstioStatus)),
		}, metav1.UpdateOptions{})

	case collections.K8SGatewayApiV1Alpha2Tcproutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TCPRoutes(cfg.Namespace).UpdateStatus(context.TODO(), &gatewayv1alpha2.TCPRoute{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*gatewayv1alpha2.TCPRouteStatus)),
		}, metav1.UpdateOptions{})

	case collections.K8SGatewayApiV1Alpha2Tlsroutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TLSRoutes(cfg.Namespace).UpdateStatus(context.TODO(), &gatewayv1alpha2.TLSRoute{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*gatewayv1alpha2.TLSRouteStatus)),
		}, metav1.UpdateOptions{})

	case collections.K8SGatewayApiV1Beta1Gatewayclasses.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().GatewayClasses().UpdateStatus(context.TODO(), &gatewayv1beta1.GatewayClass{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*gatewayv1beta1.GatewayClassStatus)),
		}, metav1.UpdateOptions{})

	case collections.K8SGatewayApiV1Beta1Gateways.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().Gateways(cfg.Namespace).UpdateStatus(context.TODO(), &gatewayv1beta1.Gateway{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*gatewayv1beta1.GatewayStatus)),
		}, metav1.UpdateOptions{})

	case collections.K8SGatewayApiV1Beta1Httproutes.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().HTTPRoutes(cfg.Namespace).UpdateStatus(context.TODO(), &gatewayv1beta1.HTTPRoute{
			ObjectMeta: objMeta,
			Status:     *(cfg.Status.(*gatewayv1beta1.HTTPRouteStatus)),
		}, metav1.UpdateOptions{})
	default:
		return nil, fmt.Errorf("unsupported type: %v", cfg.GroupVersionKind)
	}
}

func patch(ic versionedclient.Interface, sc gatewayapiclient.Interface, orig config.Config, origMeta metav1.ObjectMeta, mod config.Config, modMeta metav1.ObjectMeta, typ types.PatchType) (metav1.Object, error) {
	if orig.GroupVersionKind != mod.GroupVersionKind {
		return nil, fmt.Errorf("gvk mismatch: %v, modified: %v", orig.GroupVersionKind, mod.GroupVersionKind)
	}
	// TODO support setting field manager
	switch orig.GroupVersionKind {
	case collections.IstioExtensionsV1Alpha1Wasmplugins.Resource().GroupVersionKind():
		oldRes := &clientextensionsv1alpha1.WasmPlugin{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*extensionsv1alpha1.WasmPlugin)),
		}
		modRes := &clientextensionsv1alpha1.WasmPlugin{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*extensionsv1alpha1.WasmPlugin)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.ExtensionsV1alpha1().WasmPlugins(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.DestinationRule{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.DestinationRule)),
		}
		modRes := &clientnetworkingv1alpha3.DestinationRule{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.DestinationRule)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().DestinationRules(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.EnvoyFilter{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.EnvoyFilter)),
		}
		modRes := &clientnetworkingv1alpha3.EnvoyFilter{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.EnvoyFilter)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().EnvoyFilters(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.Gateway{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.Gateway)),
		}
		modRes := &clientnetworkingv1alpha3.Gateway{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.Gateway)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().Gateways(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.ServiceEntry{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.ServiceEntry)),
		}
		modRes := &clientnetworkingv1alpha3.ServiceEntry{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.ServiceEntry)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().ServiceEntries(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.Sidecar{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.Sidecar)),
		}
		modRes := &clientnetworkingv1alpha3.Sidecar{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.Sidecar)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().Sidecars(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.VirtualService{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.VirtualService)),
		}
		modRes := &clientnetworkingv1alpha3.VirtualService{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.VirtualService)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().VirtualServices(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Workloadentries.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.WorkloadEntry{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.WorkloadEntry)),
		}
		modRes := &clientnetworkingv1alpha3.WorkloadEntry{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.WorkloadEntry)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().WorkloadEntries(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Alpha3Workloadgroups.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1alpha3.WorkloadGroup{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1alpha3.WorkloadGroup)),
		}
		modRes := &clientnetworkingv1alpha3.WorkloadGroup{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1alpha3.WorkloadGroup)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1alpha3().WorkloadGroups(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioNetworkingV1Beta1Proxyconfigs.Resource().GroupVersionKind():
		oldRes := &clientnetworkingv1beta1.ProxyConfig{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*networkingv1beta1.ProxyConfig)),
		}
		modRes := &clientnetworkingv1beta1.ProxyConfig{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*networkingv1beta1.ProxyConfig)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.NetworkingV1beta1().ProxyConfigs(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind():
		oldRes := &clientsecurityv1beta1.AuthorizationPolicy{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*securityv1beta1.AuthorizationPolicy)),
		}
		modRes := &clientsecurityv1beta1.AuthorizationPolicy{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*securityv1beta1.AuthorizationPolicy)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.SecurityV1beta1().AuthorizationPolicies(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind():
		oldRes := &clientsecurityv1beta1.PeerAuthentication{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*securityv1beta1.PeerAuthentication)),
		}
		modRes := &clientsecurityv1beta1.PeerAuthentication{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*securityv1beta1.PeerAuthentication)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.SecurityV1beta1().PeerAuthentications(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind():
		oldRes := &clientsecurityv1beta1.RequestAuthentication{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*securityv1beta1.RequestAuthentication)),
		}
		modRes := &clientsecurityv1beta1.RequestAuthentication{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*securityv1beta1.RequestAuthentication)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.SecurityV1beta1().RequestAuthentications(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.IstioTelemetryV1Alpha1Telemetries.Resource().GroupVersionKind():
		oldRes := &clienttelemetryv1alpha1.Telemetry{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*telemetryv1alpha1.Telemetry)),
		}
		modRes := &clienttelemetryv1alpha1.Telemetry{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*telemetryv1alpha1.Telemetry)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return ic.TelemetryV1alpha1().Telemetries(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.K8SGatewayApiV1Alpha2Referencegrants.Resource().GroupVersionKind():
		oldRes := &gatewayv1alpha2.ReferenceGrant{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}
		modRes := &gatewayv1alpha2.ReferenceGrant{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return sc.GatewayV1alpha2().ReferenceGrants(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.K8SGatewayApiV1Alpha2Referencepolicies.Resource().GroupVersionKind():
		oldRes := &gatewayv1alpha2.ReferencePolicy{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}
		modRes := &gatewayv1alpha2.ReferencePolicy{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*gatewayv1alpha2.ReferenceGrantSpec)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return sc.GatewayV1alpha2().ReferencePolicies(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.K8SGatewayApiV1Alpha2Tcproutes.Resource().GroupVersionKind():
		oldRes := &gatewayv1alpha2.TCPRoute{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*gatewayv1alpha2.TCPRouteSpec)),
		}
		modRes := &gatewayv1alpha2.TCPRoute{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*gatewayv1alpha2.TCPRouteSpec)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return sc.GatewayV1alpha2().TCPRoutes(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.K8SGatewayApiV1Alpha2Tlsroutes.Resource().GroupVersionKind():
		oldRes := &gatewayv1alpha2.TLSRoute{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*gatewayv1alpha2.TLSRouteSpec)),
		}
		modRes := &gatewayv1alpha2.TLSRoute{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*gatewayv1alpha2.TLSRouteSpec)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return sc.GatewayV1alpha2().TLSRoutes(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.K8SGatewayApiV1Beta1Gatewayclasses.Resource().GroupVersionKind():
		oldRes := &gatewayv1beta1.GatewayClass{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*gatewayv1beta1.GatewayClassSpec)),
		}
		modRes := &gatewayv1beta1.GatewayClass{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*gatewayv1beta1.GatewayClassSpec)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return sc.GatewayV1beta1().GatewayClasses().
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.K8SGatewayApiV1Beta1Gateways.Resource().GroupVersionKind():
		oldRes := &gatewayv1beta1.Gateway{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*gatewayv1beta1.GatewaySpec)),
		}
		modRes := &gatewayv1beta1.Gateway{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*gatewayv1beta1.GatewaySpec)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return sc.GatewayV1beta1().Gateways(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	case collections.K8SGatewayApiV1Beta1Httproutes.Resource().GroupVersionKind():
		oldRes := &gatewayv1beta1.HTTPRoute{
			ObjectMeta: origMeta,
			Spec:       *(orig.Spec.(*gatewayv1beta1.HTTPRouteSpec)),
		}
		modRes := &gatewayv1beta1.HTTPRoute{
			ObjectMeta: modMeta,
			Spec:       *(mod.Spec.(*gatewayv1beta1.HTTPRouteSpec)),
		}
		patchBytes, err := genPatchBytes(oldRes, modRes, typ)
		if err != nil {
			return nil, err
		}
		return sc.GatewayV1beta1().HTTPRoutes(orig.Namespace).
			Patch(context.TODO(), orig.Name, typ, patchBytes, metav1.PatchOptions{FieldManager: "pilot-discovery"})
	default:
		return nil, fmt.Errorf("unsupported type: %v", orig.GroupVersionKind)
	}
}

func delete(ic versionedclient.Interface, sc gatewayapiclient.Interface, typ config.GroupVersionKind, name, namespace string, resourceVersion *string) error {
	var deleteOptions metav1.DeleteOptions
	if resourceVersion != nil {
		deleteOptions.Preconditions = &metav1.Preconditions{ResourceVersion: resourceVersion}
	}
	switch typ {
	case collections.IstioExtensionsV1Alpha1Wasmplugins.Resource().GroupVersionKind():
		return ic.ExtensionsV1alpha1().WasmPlugins(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().DestinationRules(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().EnvoyFilters(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Gateways(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().ServiceEntries(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().Sidecars(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().VirtualServices(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Workloadentries.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadEntries(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Alpha3Workloadgroups.Resource().GroupVersionKind():
		return ic.NetworkingV1alpha3().WorkloadGroups(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioNetworkingV1Beta1Proxyconfigs.Resource().GroupVersionKind():
		return ic.NetworkingV1beta1().ProxyConfigs(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().AuthorizationPolicies(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().PeerAuthentications(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind():
		return ic.SecurityV1beta1().RequestAuthentications(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.IstioTelemetryV1Alpha1Telemetries.Resource().GroupVersionKind():
		return ic.TelemetryV1alpha1().Telemetries(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.K8SGatewayApiV1Alpha2Referencegrants.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().ReferenceGrants(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.K8SGatewayApiV1Alpha2Referencepolicies.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().ReferencePolicies(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.K8SGatewayApiV1Alpha2Tcproutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TCPRoutes(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.K8SGatewayApiV1Alpha2Tlsroutes.Resource().GroupVersionKind():
		return sc.GatewayV1alpha2().TLSRoutes(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.K8SGatewayApiV1Beta1Gatewayclasses.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().GatewayClasses().Delete(context.TODO(), name, deleteOptions)
	case collections.K8SGatewayApiV1Beta1Gateways.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().Gateways(namespace).Delete(context.TODO(), name, deleteOptions)
	case collections.K8SGatewayApiV1Beta1Httproutes.Resource().GroupVersionKind():
		return sc.GatewayV1beta1().HTTPRoutes(namespace).Delete(context.TODO(), name, deleteOptions)
	default:
		return fmt.Errorf("unsupported type: %v", typ)
	}
}

var translationMap = map[config.GroupVersionKind]func(r runtime.Object) config.Config{
	collections.IstioExtensionsV1Alpha1Wasmplugins.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientextensionsv1alpha1.WasmPlugin)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioExtensionsV1Alpha1Wasmplugins.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.DestinationRule)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.EnvoyFilter)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.Gateway)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.ServiceEntry)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.Sidecar)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.VirtualService)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Workloadentries.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.WorkloadEntry)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Workloadentries.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Alpha3Workloadgroups.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1alpha3.WorkloadGroup)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Alpha3Workloadgroups.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioNetworkingV1Beta1Proxyconfigs.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientnetworkingv1beta1.ProxyConfig)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioNetworkingV1Beta1Proxyconfigs.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientsecurityv1beta1.AuthorizationPolicy)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientsecurityv1beta1.PeerAuthentication)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clientsecurityv1beta1.RequestAuthentication)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.IstioTelemetryV1Alpha1Telemetries.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*clienttelemetryv1alpha1.Telemetry)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.IstioTelemetryV1Alpha1Telemetries.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.K8SGatewayApiV1Alpha2Referencegrants.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*gatewayv1alpha2.ReferenceGrant)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SGatewayApiV1Alpha2Referencegrants.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SGatewayApiV1Alpha2Referencepolicies.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*gatewayv1alpha2.ReferencePolicy)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SGatewayApiV1Alpha2Referencepolicies.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SGatewayApiV1Alpha2Tcproutes.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*gatewayv1alpha2.TCPRoute)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SGatewayApiV1Alpha2Tcproutes.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.K8SGatewayApiV1Alpha2Tlsroutes.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*gatewayv1alpha2.TLSRoute)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SGatewayApiV1Alpha2Tlsroutes.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.K8SGatewayApiV1Beta1Gatewayclasses.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*gatewayv1beta1.GatewayClass)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SGatewayApiV1Beta1Gatewayclasses.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.K8SGatewayApiV1Beta1Gateways.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*gatewayv1beta1.Gateway)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SGatewayApiV1Beta1Gateways.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.K8SGatewayApiV1Beta1Httproutes.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*gatewayv1beta1.HTTPRoute)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SGatewayApiV1Beta1Httproutes.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
	collections.K8SAdmissionregistrationK8SIoV1Mutatingwebhookconfigurations.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*admissionregistrationv1.MutatingWebhookConfiguration)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SAdmissionregistrationK8SIoV1Mutatingwebhookconfigurations.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: obj,
		}
	},
	collections.K8SApiextensionsK8SIoV1Customresourcedefinitions.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*apiextensionsv1.CustomResourceDefinition)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SApiextensionsK8SIoV1Customresourcedefinitions.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SAppsV1Deployments.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*appsv1.Deployment)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SAppsV1Deployments.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SCoreV1Configmaps.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*corev1.ConfigMap)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SCoreV1Configmaps.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: obj,
		}
	},
	collections.K8SCoreV1Endpoints.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*corev1.Endpoints)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SCoreV1Endpoints.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: obj,
		}
	},
	collections.K8SCoreV1Namespaces.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*corev1.Namespace)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SCoreV1Namespaces.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SCoreV1Nodes.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*corev1.Node)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SCoreV1Nodes.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SCoreV1Pods.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*corev1.Pod)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SCoreV1Pods.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SCoreV1Secrets.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*corev1.Secret)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SCoreV1Secrets.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: obj,
		}
	},
	collections.K8SCoreV1Services.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*corev1.Service)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SCoreV1Services.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec: &obj.Spec,
		}
	},
	collections.K8SExtensionsV1Beta1Ingresses.Resource().GroupVersionKind(): func(r runtime.Object) config.Config {
		obj := r.(*extensionsv1beta1.Ingress)
		return config.Config{
			Meta: config.Meta{
				GroupVersionKind:  collections.K8SExtensionsV1Beta1Ingresses.Resource().GroupVersionKind(),
				Name:              obj.Name,
				Namespace:         obj.Namespace,
				Labels:            obj.Labels,
				Annotations:       obj.Annotations,
				ResourceVersion:   obj.ResourceVersion,
				CreationTimestamp: obj.CreationTimestamp.Time,
				OwnerReferences:   obj.OwnerReferences,
				UID:               string(obj.UID),
				Generation:        obj.Generation,
			},
			Spec:   &obj.Spec,
			Status: &obj.Status,
		}
	},
}
