// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/servicecontrol/template/servicecontrolreport/template_handler_service.proto

/*
	Package servicecontrolreport is a generated protocol buffer package.

	The `servicecontrolreport` template is used by the [Google Service Control](https://istio.io/docs/reference/config/policy-and-telemetry/adapters/servicecontrol/)
	adapter.

	Example config:

	```yaml
	apiVersion: "config.istio.io/v1alpha2"
	kind: servicecontrolreport
	metadata:
	  name: report
	  namespace: istio-system
	spec:
	  api_version : api.version | ""
	  api_operation : api.operation | ""
	  api_protocol : api.protocol | ""
	  api_service : api.service | ""
	  api_key : api.key | ""
	  request_time : request.time
	  request_method : request.method
	  request_path : request.path
	  request_bytes: request.size
	  response_time : response.time
	  response_code : response.code | 520
	  response_bytes : response.size | 0
	  response_latency : response.duration | "0ms"
	```

	A template used by Google Service Control (servicecontrol) adapter. The adapter
	generates metrics and logentry for each request based on the data point
	defined by this template.

	It is generated from these files:
		mixer/adapter/servicecontrol/template/servicecontrolreport/template_handler_service.proto

	It has these top-level messages:
		HandleServicecontrolReportRequest
		InstanceMsg
		Type
		InstanceParam
*/
package servicecontrolreport

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "istio.io/api/mixer/adapter/model/v1beta1"
import google_protobuf1 "github.com/gogo/protobuf/types"
import istio_mixer_adapter_model_v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
import istio_policy_v1beta1 "istio.io/api/policy/v1beta1"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleServicecontrolReport method.
type HandleServicecontrolReportRequest struct {
	// 'servicecontrolreport' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleServicecontrolReportRequest) Reset()      { *m = HandleServicecontrolReportRequest{} }
func (*HandleServicecontrolReportRequest) ProtoMessage() {}
func (*HandleServicecontrolReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{0}
}

// Contains instance payload for 'servicecontrolreport' template. This is passed to infrastructure backends during request-time
// through HandleServicecontrolReportService.HandleServicecontrolReport.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name            string                          `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	ApiVersion      string                          `protobuf:"bytes,1,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	ApiOperation    string                          `protobuf:"bytes,2,opt,name=api_operation,json=apiOperation,proto3" json:"api_operation,omitempty"`
	ApiProtocol     string                          `protobuf:"bytes,3,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
	ApiService      string                          `protobuf:"bytes,4,opt,name=api_service,json=apiService,proto3" json:"api_service,omitempty"`
	ApiKey          string                          `protobuf:"bytes,5,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	RequestTime     *istio_policy_v1beta1.TimeStamp `protobuf:"bytes,6,opt,name=request_time,json=requestTime" json:"request_time,omitempty"`
	RequestMethod   string                          `protobuf:"bytes,7,opt,name=request_method,json=requestMethod,proto3" json:"request_method,omitempty"`
	RequestPath     string                          `protobuf:"bytes,8,opt,name=request_path,json=requestPath,proto3" json:"request_path,omitempty"`
	RequestBytes    int64                           `protobuf:"varint,9,opt,name=request_bytes,json=requestBytes,proto3" json:"request_bytes,omitempty"`
	ResponseTime    *istio_policy_v1beta1.TimeStamp `protobuf:"bytes,10,opt,name=response_time,json=responseTime" json:"response_time,omitempty"`
	ResponseCode    int64                           `protobuf:"varint,11,opt,name=response_code,json=responseCode,proto3" json:"response_code,omitempty"`
	ResponseBytes   int64                           `protobuf:"varint,12,opt,name=response_bytes,json=responseBytes,proto3" json:"response_bytes,omitempty"`
	ResponseLatency *istio_policy_v1beta1.Duration  `protobuf:"bytes,13,opt,name=response_latency,json=responseLatency" json:"response_latency,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{1}
}

// Contains inferred type information about specific instance of 'servicecontrolreport' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
}

func (m *Type) Reset()                    { *m = Type{} }
func (*Type) ProtoMessage()               {}
func (*Type) Descriptor() ([]byte, []int) { return fileDescriptorTemplateHandlerService, []int{2} }

// Represents instance configuration schema for 'servicecontrolreport' template.
type InstanceParam struct {
	ApiVersion      string `protobuf:"bytes,1,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	ApiOperation    string `protobuf:"bytes,2,opt,name=api_operation,json=apiOperation,proto3" json:"api_operation,omitempty"`
	ApiProtocol     string `protobuf:"bytes,3,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
	ApiService      string `protobuf:"bytes,4,opt,name=api_service,json=apiService,proto3" json:"api_service,omitempty"`
	ApiKey          string `protobuf:"bytes,5,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	RequestTime     string `protobuf:"bytes,6,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	RequestMethod   string `protobuf:"bytes,7,opt,name=request_method,json=requestMethod,proto3" json:"request_method,omitempty"`
	RequestPath     string `protobuf:"bytes,8,opt,name=request_path,json=requestPath,proto3" json:"request_path,omitempty"`
	RequestBytes    string `protobuf:"bytes,9,opt,name=request_bytes,json=requestBytes,proto3" json:"request_bytes,omitempty"`
	ResponseTime    string `protobuf:"bytes,10,opt,name=response_time,json=responseTime,proto3" json:"response_time,omitempty"`
	ResponseCode    string `protobuf:"bytes,11,opt,name=response_code,json=responseCode,proto3" json:"response_code,omitempty"`
	ResponseBytes   string `protobuf:"bytes,12,opt,name=response_bytes,json=responseBytes,proto3" json:"response_bytes,omitempty"`
	ResponseLatency string `protobuf:"bytes,13,opt,name=response_latency,json=responseLatency,proto3" json:"response_latency,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{3}
}

func init() {
	proto.RegisterType((*HandleServicecontrolReportRequest)(nil), "servicecontrolreport.HandleServicecontrolReportRequest")
	proto.RegisterType((*InstanceMsg)(nil), "servicecontrolreport.InstanceMsg")
	proto.RegisterType((*Type)(nil), "servicecontrolreport.Type")
	proto.RegisterType((*InstanceParam)(nil), "servicecontrolreport.InstanceParam")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HandleServicecontrolReportService service

type HandleServicecontrolReportServiceClient interface {
	// HandleServicecontrolReport is called by Mixer at request-time to deliver 'servicecontrolreport' instances to the backend.
	HandleServicecontrolReport(ctx context.Context, in *HandleServicecontrolReportRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

type handleServicecontrolReportServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleServicecontrolReportServiceClient(cc *grpc.ClientConn) HandleServicecontrolReportServiceClient {
	return &handleServicecontrolReportServiceClient{cc}
}

func (c *handleServicecontrolReportServiceClient) HandleServicecontrolReport(ctx context.Context, in *HandleServicecontrolReportRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error) {
	out := new(istio_mixer_adapter_model_v1beta11.ReportResult)
	err := grpc.Invoke(ctx, "/servicecontrolreport.HandleServicecontrolReportService/HandleServicecontrolReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HandleServicecontrolReportService service

type HandleServicecontrolReportServiceServer interface {
	// HandleServicecontrolReport is called by Mixer at request-time to deliver 'servicecontrolreport' instances to the backend.
	HandleServicecontrolReport(context.Context, *HandleServicecontrolReportRequest) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

func RegisterHandleServicecontrolReportServiceServer(s *grpc.Server, srv HandleServicecontrolReportServiceServer) {
	s.RegisterService(&_HandleServicecontrolReportService_serviceDesc, srv)
}

func _HandleServicecontrolReportService_HandleServicecontrolReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleServicecontrolReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleServicecontrolReportServiceServer).HandleServicecontrolReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/servicecontrolreport.HandleServicecontrolReportService/HandleServicecontrolReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleServicecontrolReportServiceServer).HandleServicecontrolReport(ctx, req.(*HandleServicecontrolReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleServicecontrolReportService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "servicecontrolreport.HandleServicecontrolReportService",
	HandlerType: (*HandleServicecontrolReportServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleServicecontrolReport",
			Handler:    _HandleServicecontrolReportService_HandleServicecontrolReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/adapter/servicecontrol/template/servicecontrolreport/template_handler_service.proto",
}

func (m *HandleServicecontrolReportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleServicecontrolReportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AdapterConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.DedupId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i += copy(dAtA[i:], m.DedupId)
	}
	return i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ApiVersion) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiVersion)))
		i += copy(dAtA[i:], m.ApiVersion)
	}
	if len(m.ApiOperation) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiOperation)))
		i += copy(dAtA[i:], m.ApiOperation)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	if len(m.ApiService) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiService)))
		i += copy(dAtA[i:], m.ApiService)
	}
	if len(m.ApiKey) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiKey)))
		i += copy(dAtA[i:], m.ApiKey)
	}
	if m.RequestTime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.RequestTime.Size()))
		n2, err := m.RequestTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.RequestMethod) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.RequestMethod)))
		i += copy(dAtA[i:], m.RequestMethod)
	}
	if len(m.RequestPath) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.RequestPath)))
		i += copy(dAtA[i:], m.RequestPath)
	}
	if m.RequestBytes != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.RequestBytes))
	}
	if m.ResponseTime != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.ResponseTime.Size()))
		n3, err := m.ResponseTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ResponseCode != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.ResponseCode))
	}
	if m.ResponseBytes != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.ResponseBytes))
	}
	if m.ResponseLatency != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.ResponseLatency.Size()))
		n4, err := m.ResponseLatency.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0xe4
		i++
		dAtA[i] = 0x93
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ApiVersion) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiVersion)))
		i += copy(dAtA[i:], m.ApiVersion)
	}
	if len(m.ApiOperation) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiOperation)))
		i += copy(dAtA[i:], m.ApiOperation)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	if len(m.ApiService) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiService)))
		i += copy(dAtA[i:], m.ApiService)
	}
	if len(m.ApiKey) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiKey)))
		i += copy(dAtA[i:], m.ApiKey)
	}
	if len(m.RequestTime) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.RequestTime)))
		i += copy(dAtA[i:], m.RequestTime)
	}
	if len(m.RequestMethod) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.RequestMethod)))
		i += copy(dAtA[i:], m.RequestMethod)
	}
	if len(m.RequestPath) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.RequestPath)))
		i += copy(dAtA[i:], m.RequestPath)
	}
	if len(m.RequestBytes) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.RequestBytes)))
		i += copy(dAtA[i:], m.RequestBytes)
	}
	if len(m.ResponseTime) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ResponseTime)))
		i += copy(dAtA[i:], m.ResponseTime)
	}
	if len(m.ResponseCode) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ResponseCode)))
		i += copy(dAtA[i:], m.ResponseCode)
	}
	if len(m.ResponseBytes) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ResponseBytes)))
		i += copy(dAtA[i:], m.ResponseBytes)
	}
	if len(m.ResponseLatency) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ResponseLatency)))
		i += copy(dAtA[i:], m.ResponseLatency)
	}
	return i, nil
}

func encodeVarintTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HandleServicecontrolReportRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTemplateHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	var l int
	_ = l
	l = len(m.ApiVersion)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiOperation)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiService)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiKey)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.RequestTime != nil {
		l = m.RequestTime.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.RequestMethod)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.RequestPath)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.RequestBytes != 0 {
		n += 1 + sovTemplateHandlerService(uint64(m.RequestBytes))
	}
	if m.ResponseTime != nil {
		l = m.ResponseTime.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if m.ResponseCode != 0 {
		n += 1 + sovTemplateHandlerService(uint64(m.ResponseCode))
	}
	if m.ResponseBytes != 0 {
		n += 1 + sovTemplateHandlerService(uint64(m.ResponseBytes))
	}
	if m.ResponseLatency != nil {
		l = m.ResponseLatency.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *InstanceParam) Size() (n int) {
	var l int
	_ = l
	l = len(m.ApiVersion)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiOperation)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiService)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiKey)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.RequestTime)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.RequestMethod)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.RequestPath)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.RequestBytes)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ResponseTime)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ResponseCode)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ResponseBytes)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ResponseLatency)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func sovTemplateHandlerService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTemplateHandlerService(x uint64) (n int) {
	return sovTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleServicecontrolReportRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HandleServicecontrolReportRequest{`,
		`Instances:` + strings.Replace(fmt.Sprintf("%v", this.Instances), "InstanceMsg", "InstanceMsg", 1) + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "google_protobuf1.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceMsg{`,
		`ApiVersion:` + fmt.Sprintf("%v", this.ApiVersion) + `,`,
		`ApiOperation:` + fmt.Sprintf("%v", this.ApiOperation) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`ApiService:` + fmt.Sprintf("%v", this.ApiService) + `,`,
		`ApiKey:` + fmt.Sprintf("%v", this.ApiKey) + `,`,
		`RequestTime:` + strings.Replace(fmt.Sprintf("%v", this.RequestTime), "TimeStamp", "istio_policy_v1beta1.TimeStamp", 1) + `,`,
		`RequestMethod:` + fmt.Sprintf("%v", this.RequestMethod) + `,`,
		`RequestPath:` + fmt.Sprintf("%v", this.RequestPath) + `,`,
		`RequestBytes:` + fmt.Sprintf("%v", this.RequestBytes) + `,`,
		`ResponseTime:` + strings.Replace(fmt.Sprintf("%v", this.ResponseTime), "TimeStamp", "istio_policy_v1beta1.TimeStamp", 1) + `,`,
		`ResponseCode:` + fmt.Sprintf("%v", this.ResponseCode) + `,`,
		`ResponseBytes:` + fmt.Sprintf("%v", this.ResponseBytes) + `,`,
		`ResponseLatency:` + strings.Replace(fmt.Sprintf("%v", this.ResponseLatency), "Duration", "istio_policy_v1beta1.Duration", 1) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Type{`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceParam{`,
		`ApiVersion:` + fmt.Sprintf("%v", this.ApiVersion) + `,`,
		`ApiOperation:` + fmt.Sprintf("%v", this.ApiOperation) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`ApiService:` + fmt.Sprintf("%v", this.ApiService) + `,`,
		`ApiKey:` + fmt.Sprintf("%v", this.ApiKey) + `,`,
		`RequestTime:` + fmt.Sprintf("%v", this.RequestTime) + `,`,
		`RequestMethod:` + fmt.Sprintf("%v", this.RequestMethod) + `,`,
		`RequestPath:` + fmt.Sprintf("%v", this.RequestPath) + `,`,
		`RequestBytes:` + fmt.Sprintf("%v", this.RequestBytes) + `,`,
		`ResponseTime:` + fmt.Sprintf("%v", this.ResponseTime) + `,`,
		`ResponseCode:` + fmt.Sprintf("%v", this.ResponseCode) + `,`,
		`ResponseBytes:` + fmt.Sprintf("%v", this.ResponseBytes) + `,`,
		`ResponseLatency:` + fmt.Sprintf("%v", this.ResponseLatency) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleServicecontrolReportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleServicecontrolReportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleServicecontrolReportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &google_protobuf1.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiOperation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiOperation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestTime == nil {
				m.RequestTime = &istio_policy_v1beta1.TimeStamp{}
			}
			if err := m.RequestTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestMethod", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestMethod = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestBytes", wireType)
			}
			m.RequestBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseTime == nil {
				m.ResponseTime = &istio_policy_v1beta1.TimeStamp{}
			}
			if err := m.ResponseTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseCode", wireType)
			}
			m.ResponseCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseCode |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseBytes", wireType)
			}
			m.ResponseBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseLatency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseLatency == nil {
				m.ResponseLatency = &istio_policy_v1beta1.Duration{}
			}
			if err := m.ResponseLatency.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiOperation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiOperation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestMethod", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestMethod = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestBytes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestBytes = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseBytes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseBytes = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseLatency", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseLatency = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/adapter/servicecontrol/template/servicecontrolreport/template_handler_service.proto", fileDescriptorTemplateHandlerService)
}

var fileDescriptorTemplateHandlerService = []byte{
	// 734 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x55, 0xb1, 0x6f, 0xd3, 0x4c,
	0x14, 0x8f, 0x93, 0x7c, 0x69, 0x7d, 0x49, 0xfa, 0x7d, 0xb2, 0xfa, 0x09, 0x37, 0x83, 0x9b, 0xa4,
	0x42, 0x0a, 0x12, 0xb2, 0xd5, 0x32, 0x30, 0x30, 0x20, 0xda, 0x0e, 0x54, 0x50, 0x11, 0xb9, 0x15,
	0x12, 0x53, 0x74, 0xb1, 0x5f, 0x93, 0x13, 0xb6, 0xef, 0xb0, 0x2f, 0x55, 0xbd, 0x21, 0x06, 0x66,
	0xa4, 0xfe, 0x13, 0x0c, 0x48, 0xfc, 0x03, 0xfd, 0x03, 0x2a, 0xa6, 0x8a, 0x05, 0x16, 0xa4, 0x26,
	0x74, 0x60, 0xec, 0xc8, 0x88, 0x7c, 0x3e, 0x87, 0xb6, 0xb8, 0xa5, 0x13, 0x12, 0x5b, 0xee, 0xdd,
	0xef, 0xf7, 0xde, 0xef, 0xbd, 0xfb, 0xe5, 0x19, 0x3d, 0xf3, 0xc9, 0x1e, 0x84, 0x16, 0x76, 0x31,
	0xe3, 0x10, 0x5a, 0x11, 0x84, 0xbb, 0xc4, 0x01, 0x87, 0x06, 0x3c, 0xa4, 0x9e, 0xc5, 0xc1, 0x67,
	0x1e, 0xe6, 0x70, 0x21, 0x1e, 0x02, 0xa3, 0x21, 0x9f, 0xde, 0xf6, 0x86, 0x38, 0x70, 0x3d, 0x08,
	0x7b, 0x12, 0x65, 0xb2, 0x90, 0x72, 0xaa, 0xcd, 0xe7, 0x91, 0x1a, 0xf3, 0x03, 0x3a, 0xa0, 0x02,
	0x60, 0x25, 0xbf, 0x52, 0x6c, 0xe3, 0xf6, 0x79, 0x19, 0x3e, 0x75, 0xc1, 0xb3, 0x76, 0x97, 0xfb,
	0xc0, 0xf1, 0xb2, 0x05, 0x7b, 0x1c, 0x82, 0x88, 0xd0, 0x20, 0x92, 0xe8, 0x85, 0x01, 0xa5, 0x03,
	0x0f, 0x2c, 0x71, 0xea, 0x8f, 0x76, 0x2c, 0x1c, 0xc4, 0xf2, 0xaa, 0x73, 0x55, 0xa2, 0x54, 0x42,
	0x96, 0x84, 0x51, 0x8f, 0x38, 0xf1, 0xf4, 0x92, 0xc7, 0x4c, 0x2a, 0x6f, 0x1f, 0x28, 0xa8, 0xf5,
	0x50, 0xf4, 0xb4, 0x75, 0xae, 0x05, 0x5b, 0xf0, 0x6d, 0x78, 0x31, 0x82, 0x88, 0x6b, 0xf7, 0x91,
	0x4a, 0x82, 0x88, 0xe3, 0xc0, 0x81, 0x48, 0x57, 0x9a, 0xa5, 0x4e, 0x75, 0xa5, 0x65, 0xe6, 0xf5,
	0x6c, 0x6e, 0x48, 0xd8, 0x66, 0x34, 0xb0, 0x7f, 0x72, 0xb4, 0x7b, 0x68, 0x4e, 0xea, 0xec, 0x39,
	0x34, 0xd8, 0x21, 0x03, 0xbd, 0xd8, 0x54, 0x3a, 0xd5, 0x95, 0x79, 0x33, 0xed, 0xcf, 0xcc, 0xfa,
	0x33, 0x1f, 0x04, 0xb1, 0x5d, 0x97, 0xd8, 0x35, 0x01, 0xd5, 0x16, 0xd0, 0xac, 0x0b, 0xee, 0x88,
	0xf5, 0x88, 0xab, 0x97, 0x9a, 0x4a, 0x47, 0xb5, 0x67, 0xc4, 0x79, 0xc3, 0x6d, 0x7f, 0x2a, 0xa3,
	0xea, 0x99, 0x92, 0xda, 0x22, 0xaa, 0x62, 0x46, 0x7a, 0xbb, 0x10, 0x26, 0x43, 0xd4, 0x15, 0x81,
	0x46, 0x98, 0x91, 0xa7, 0x69, 0x44, 0x5b, 0x42, 0xf5, 0x04, 0x40, 0x19, 0x84, 0x98, 0x27, 0x90,
	0xa2, 0x80, 0xd4, 0x30, 0x23, 0x4f, 0xb2, 0x98, 0xd6, 0x42, 0xc9, 0xb9, 0x27, 0x34, 0x39, 0xd4,
	0x93, 0x45, 0x93, 0xcc, 0x5d, 0x19, 0xca, 0x0a, 0xc9, 0x19, 0xe8, 0xe5, 0x69, 0x21, 0x39, 0x46,
	0xed, 0x06, 0x9a, 0x49, 0x00, 0xcf, 0x21, 0xd6, 0xff, 0x11, 0x97, 0x15, 0xcc, 0xc8, 0x23, 0x88,
	0xb5, 0x55, 0x54, 0x0b, 0xd3, 0xb1, 0xf6, 0x38, 0xf1, 0x41, 0xaf, 0x88, 0x41, 0x2c, 0x9a, 0x24,
	0xe2, 0x84, 0x9a, 0xe9, 0x4b, 0x99, 0xf2, 0xa5, 0xcc, 0x6d, 0xe2, 0xc3, 0x16, 0xc7, 0x3e, 0xb3,
	0xab, 0x92, 0x94, 0x44, 0xb4, 0x9b, 0x68, 0x2e, 0xcb, 0xe1, 0x03, 0x1f, 0x52, 0x57, 0x9f, 0x11,
	0x35, 0xea, 0x32, 0xba, 0x29, 0x82, 0x49, 0x1f, 0x19, 0x8c, 0x61, 0x3e, 0xd4, 0x67, 0xd3, 0x3e,
	0x64, 0xac, 0x8b, 0xf9, 0x30, 0x99, 0x47, 0x06, 0xe9, 0xc7, 0x1c, 0x22, 0x5d, 0x6d, 0x2a, 0x9d,
	0x92, 0x9d, 0xf1, 0x56, 0x93, 0x98, 0xb6, 0x9e, 0x80, 0x22, 0x46, 0x83, 0x08, 0x52, 0xcd, 0xe8,
	0x7a, 0x9a, 0x6b, 0x19, 0x4b, 0x88, 0x5e, 0x3a, 0x93, 0xc5, 0xa1, 0x2e, 0xe8, 0xd5, 0xac, 0x54,
	0x1a, 0x5c, 0xa3, 0xae, 0xec, 0x4c, 0x82, 0x52, 0x41, 0x35, 0x81, 0x9a, 0x52, 0x53, 0x45, 0x1b,
	0xe8, 0xbf, 0x29, 0x2c, 0xf9, 0x5f, 0x06, 0x4e, 0xac, 0xd7, 0x85, 0x28, 0x23, 0x5f, 0xd4, 0xfa,
	0x28, 0x7d, 0x5b, 0xfb, 0xdf, 0x8c, 0xf7, 0x38, 0xa5, 0x69, 0xff, 0xa3, 0x72, 0x80, 0x7d, 0xd0,
	0xdf, 0x7f, 0x38, 0x68, 0x8b, 0xf9, 0x88, 0x63, 0xbb, 0x82, 0xca, 0xdb, 0x31, 0x83, 0xf6, 0x71,
	0x09, 0xd5, 0x33, 0x87, 0x75, 0x71, 0x88, 0xfd, 0xbf, 0xc1, 0x63, 0xad, 0x1c, 0x8f, 0xa9, 0x7f,
	0xd4, 0x42, 0xea, 0x05, 0x0b, 0x2d, 0xe5, 0x59, 0x48, 0xbd, 0x8e, 0x43, 0xd4, 0x6b, 0x39, 0x44,
	0xbd, 0xe8, 0x90, 0x5b, 0x97, 0x38, 0x44, 0xfd, 0xc5, 0x01, 0x2b, 0xef, 0xae, 0xdc, 0x81, 0xd9,
	0xb0, 0x5f, 0x2b, 0xa8, 0x71, 0x39, 0x4a, 0xbb, 0x9b, 0xbf, 0x0f, 0x7f, 0xbb, 0x5b, 0x1b, 0x96,
	0x34, 0xac, 0xd8, 0xe6, 0xa6, 0xdc, 0x7c, 0xa6, 0xd8, 0xe6, 0x53, 0xf7, 0x66, 0x8c, 0x68, 0xe4,
	0xf1, 0xd5, 0xee, 0xe1, 0xd8, 0x28, 0x1c, 0x8d, 0x8d, 0xc2, 0xe7, 0xb1, 0x51, 0x38, 0x1d, 0x1b,
	0x85, 0x97, 0x13, 0x43, 0x79, 0x3b, 0x31, 0x0a, 0x87, 0x13, 0x43, 0x39, 0x9a, 0x18, 0xca, 0xf1,
	0xc4, 0x50, 0xbe, 0x4d, 0x8c, 0xc2, 0xe9, 0xc4, 0x50, 0xde, 0x7c, 0x35, 0x0a, 0xdf, 0x3f, 0x9e,
	0xec, 0x17, 0x95, 0x57, 0x5f, 0x4e, 0xf6, 0x8b, 0xb9, 0x1f, 0xaa, 0x7e, 0x45, 0xb8, 0xf0, 0xce,
	0x8f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x51, 0x8c, 0x78, 0xbe, 0x22, 0x07, 0x00, 0x00,
}
