amends "../../pkl/Symbolicator.pkl"

// MIT License
//
// Copyright (c) 2024 blacktop
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

target = "com.apple.kernel"

total = 4575

version {
    max = "24.0.0"
    min = "24.0.0"
}

signatures {
    new {
        args = 1
        anchors {
            new {
                string = "dtrace: fbt: No return probe for %s, walked to next routine at 0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fbt_provide_probe"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Kernel stack memory corruption detected @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "stack_protector.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__stack_chk_fail"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "kdp_packet bad len %lu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp_packet bad len pkt %lu hdr %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp_packet reply recvd req %x seq %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kdp_packet bad request %x len %d seq %x key %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_packet"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "A trap was already set at that address, not setting new breakpoint\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_set_breakpoint_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_remove_all_breakpoints: found extant breakpoints, removing them.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_remove_all_breakpoints"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_unknown request %x len %d seq %x key %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_unknown"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "stackshot_maxsz"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-panic_on_exception_triage"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-show_pointers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-no_slto_panic"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kernel_bootstrap: result = %08X @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kernel_bootstrap_thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "kernel_bootstrap"
        prototype = ""
        caller = "machine_startup"
    }
    new {
        args = 1
        anchors {
            new {
                string = "stackshot_tries"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "stackshot_push_duration_and_latency"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "stackshot_in_flags"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kcdata_add_uint64_with_description"
            }
            new {
                string = "stackshot_in_pid"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kcdata_add_uint32_with_description"
            }
            new {
                string = "system_state_flags"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "stackshot_pagetable_mask"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kcdata_add_uint32_with_description"
            }
            new {
                string = "stackshot_size_estimate"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kcdata_add_uint32_with_description"
            }
            new {
                string = "stackshot_size_estimate_adj"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kcdata_add_uint32_with_description"
            }
            new {
                string = "stackshot_tasks_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "stackshot_threads_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_stackshot_kcdata_format"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "_panicd_ip"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "_router_ip"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "panicd_port"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "_panicd_corename"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_register_send_receive"
        prototype = ""
        caller = "kdp_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_ip_addr"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_set_interface"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "octet"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s%c%s%c%s%c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unable to create core header packet.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dumpinfo does not fit into KDP packet.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
        }
        symbol = "create_panic_header"
        prototype = ""
        caller = "kdp_send_crashdump_pkt"
    }
    new {
        args = 2
        anchors {
            new {
                string = "Cannot contact panic server, timing out.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "TX retry #%d "
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Unable to get panic header.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Protocol features: 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Panic server returned error %d, retrying\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "RX retry "
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "\nTotal number of packets transmitted: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Avg. superblock transfer abstime 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Minimum superblock transfer abstime: 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Maximum superblock transfer abstime: 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_send_crashdump_pkt"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "kdp_set_dump_info: Skipping invalid panicd port %d (using %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
        }
        symbol = "kdp_set_dump_info"
        prototype = ""
        caller = "kdp_dumpinfo"
    }
    new {
        args = 0
        anchors {
            new {
                string = "System dump aborted.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
            new {
                string = "Entering system dump routine\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Error: No transport device registered for kernel crashdump\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "A dump server was not specified in the boot-args, terminating kernel core dump.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp_panic_dump: unexpected pending input packet"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdp_panic"
            }
            new {
                string = "paniclog"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "systemlog"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s-%s-%d.%d.%d.%d-%x%s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "inet_aton() failed interpreting %s as a panic server IP\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
            new {
                string = "Attempting connection to panic server configured at IP %s, port %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Resolved %s's (or proxy's) link level address\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
            new {
                string = "inet_aton() failed interpreting %s as an IP\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
            new {
                string = "Routing through specified router IP %s (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Transmitting packets to link level address: %02x:%02x:%02x:%02x:%02x:%02x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
            new {
                string = "Kernel map size is %llu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
            new {
                string = "Sending write request for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf"
            }
            new {
                string = "Transmitting panic log, please wait: "
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf_unbuffered"
            }
            new {
                string = "Please file a bug report on this panic, if possible.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Transmitting system log, please wait: "
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdb_printf_unbuffered"
            }
            new {
                string = "custom"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_panic_dump"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "; UUID="
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "; stext="
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Serial requested, consistent debug disabled or debug boot arg not present, configuring debugging over serial\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Initializing serial KDP\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "kdp_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_poll"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdp_panic"
            }
            new {
                string = "kdp_poll: no debugger device\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_poll"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_raise_exception with NULL state\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s exception (%x,%x,%x)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kdp_raise_exception"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdp_panic"
            }
            new {
                string = "Debugger re-entry scheduled in %d milliseconds\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Using serial KDP.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\nWaiting for remote debugger connection.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Options.....    Type\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "------------    ----\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "continue....    'c'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "reboot......    'r'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Continuing...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Rebooting...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Connected to remote debugger.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp: exception ack timeout\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kdp_send: no input packet"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdp_panic"
            }
            new {
                string = "kdp: bad sequence %d (want %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_raise_exception"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_reply: no input packet"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdp_panic"
            }
            new {
                string = "kdp_send: packet too large (%d > %u)"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kdp_panic"
            }
        }
        symbol = "kdp_reply"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: cannot exclude region starting at %p with size %zu (zero or overflowing size) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: cannot exclude region starting at %p with size %zu (not page aligned) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kdp_core_exclude_region"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_core_handle_new_encryption_key failed to re-initialize encryption stage. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kdp_core_handle_new_encryption_key failed to read the existing corefile header. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kdp_core_handle_new_encryption_key failed to update the existing corefile header. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp_core_handle_new_encryption_key failed to write the corefile header. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp_core_handle_new_encryption_key failed to write the next public key. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp_core_handle_new_encryption_key failed to zero-out the public key region. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_core_handle_new_encryption_key"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_core_polled_io_polled_file_available failed to read corefile header. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kdp_core_polled_io_polled_file_available failed to read the public key. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_core_polled_io_polled_file_available"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "KDPCoreStageInit"
                segment = "__TEXT"
                section = "__cstring"
                caller = "lck_grp_init_flags"
            }
            new {
                string = "apple_encrypted_archive interface registration callback is already set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "compression interface registration callback is already set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kdp_core_init"
        prototype = ""
        caller = "kdp_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(kern_dump_update_header) outproc(KDP_SEEK, NULL, %lu, %p) foffset = 0x%llx returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(kern_dump_update_header) outproc(KDP_DATA, NULL, %lu, %p) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_dump_update_header) outproc data flush returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_dump_update_header) outproc explicit flush returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "kern_dump_update_header"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "outproc(KDP_WRQ, NULL, 0, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(do_kern_dump write public key) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(do_kern_dump seek begin) outproc(KDP_SEEK, NULL, %lu, %p) foffset = 0x%llx returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Writing local cores...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Transmitting kernel state, please wait:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(do_kern_dump seek logfile) outproc(KDP_SEEK, NULL, %lu, %p) foffset = 0x%llx returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(do_kern_dump paniclog) outproc(KDP_DATA, NULL, %lu, %p) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(do_kern_dump coredump log) outproc(KDP_DATA, NULL, %lu, %p) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(do_kern_dump close) outproc(KDP_EOF, NULL, 0, 0) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "We were in the middle of initializing LZ4 stage. Cannot write a coredump to disk\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LZ4 stage is not yet initialized. Cannot write a coredump to disk\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "We were in the middle of initializing encryption. Marking it as unavailable\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "We were in the middle of initializing the disk stage. Cannot write a coredump to disk\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Corefile is not yet initialized. Cannot write a coredump to disk\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Zlib stage is not initialized. Cannot write a coredump to the network\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Zlib stage is not initialized. Cannot write a coredump to shared memory\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_dump_write_public_key) outproc(KDP_SEEK, NULL, %lu, %p) foffset = 0x%llx returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_dump_write_public_key) outproc(KDP_DATA, NULL, %llu, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_dump_write_public_key) outproc data flush returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_dump_write_public_key) outproc explicit flush returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "\nBeginning dump of panic region of size 0x%zx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Skipping panic region dump\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Failed to write panic region to file, kdp_coreoutput(outstate, %zu, %p) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to flush panic region data : kdp_core_output(%p, 0, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "panic_region"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to record panic region in corefile header, kern_dump_record_file returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Recorded panic region in corefile at offset 0x%llx, compressed to %llu bytes\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Failed to seek to panic region file offset 0x%llx, kern_dump_seek_to_next_file returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "do_kern_dump"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "(kdp_core_init_encryption_stage) Failed to initialize the encryption stage. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kdp_core_init_encryption_stage"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: skipping kernel because excluded regions list is locked\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "kern_dump_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kern_dump_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "save_summary: pmap traversal failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "kern_dump_save_summary"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "save_seg_desc: pmap traversal failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "kern_dump_save_segment_data_0"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "save_seg_data: pmap traversal failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "kern_dump_save_segment_data"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: context allocation failure\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "user_dump_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: no task is set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: skipping inactive task\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: skipping locked task\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: skipping task with locked vm map\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "user_dump_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "user_dump_save_summary"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "user_dump_save_summary"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "user_dump_save_seg_descriptions"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "user_dump_save_seg_descriptions"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "user_dump_save_segment_data"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "user_dump_save_segment_data"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "panic context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "user_dump_save_note_descriptions"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AEA kext returned an error while calculating state size."
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Failed to allocate memory (%zu bytes) for the AEA stage. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "WARNING: Coredump encryption failed to initialize. aea_initialize_state() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "aea_stage_initialize"
        prototype = ""
        caller = "kdp_core_init_encryption_stage"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(aea_stage_reset) aea_close() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "aea_stage_reset"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(aea_stage_outproc) aea_close() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(aea_stage_outproc) aea_open() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(aea_stage_outproc) aea_write() returned %zd\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "aea_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "(aea_write_callback) next stage outproc returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "aea_write_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "(aea_read_callback) next stage read proc returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "aea_read_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(aea_availability_callback) Failed to handle availability of encryption. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "aea_availability_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "buffer_stage_initialize failed to allocate memory. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "buffer_stage_initialize"
        prototype = ""
        caller = "kdp_core_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "buffer_stage_outproc (during forwarding) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "buffer_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "(disk_stage_write) disk_stage_read (during seek) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(disk_stage_write) IOPolledFileSeek(0x%llx) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(disk_stage_write) disk_stage_read (during final chunk seek) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(disk_stage_write) IOPolledFileWrite(gIOPolledCoreFileVars, %p, 0x%llx, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(disk_stage_write) IOPolledFileWrite (during final flush) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "disk_stage_write"
        prototype = ""
        caller = "aea_write_callback"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(disk_stage_read) IOPolledFileWrite (during seek) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(disk_stage_read) IOPolledFileSeek(0x%llx) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(disk_stage_read) Kickstarting IOPolledFileRead(0) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "disk_stage_read"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "IOPolledFileSeek(gIOPolledCoreFileVars, 0) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "IOPolledFilePollersOpen returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IOPolledFileWrite (during seek) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IOPolledFileSeek(0x%llx) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "IOPolledFileWrite(gIOPolledCoreFileVars, %p, 0x%llx, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IOPolledFileFlush() returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IOPolledFileWrite (during EOF) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IOPolledFilePollersClose (during EOF) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "disk_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(%s) Failed to handle availability of LZ4. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "lz4_stage_registration_callback"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lz4_stage_registration_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "kdp_send_crashdump_data returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "net_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "progress_notify_stage_initialize failed to allocate memory. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "progress_notify_stage_initialize"
        prototype = ""
        caller = "kdp_core_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s (during forwarding) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "progress_notify_stage_outproc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "progress_notify_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "handshake structure not initialized\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Waiting for hardware shared memory debugger, handshake structure is at virt: %p, phys %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "panic_spin_shmcon"
        prototype = ""
        caller = "handle_debugger_trap"
    }
    new {
        args = 2
        anchors {
            new {
                string = "EOF Flush: Detected stale/invalid seq num. Expected: %d, received %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Setting coredump status as done!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "shmem_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Detected remote error, terminating...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Detected stale/invalid seq num. Expected: %d, received %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Kernel timed out waiting for hardware debugger to update handshake structure."
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "No contact in %d seconds\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "shmem_dbg_process_buffers"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_core zlib memory 0x%lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "zlib_stage_initialize failed to allocate memory. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "zlib_stage_initialize"
        prototype = ""
        caller = "kdp_core_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ZERR %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "zlib_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s failed to allocate memory. Error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "memory_backing_aware_buffer_stage_initialize"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "memory_backing_aware_buffer_stage_initialize"
        prototype = ""
        caller = "kdp_core_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s (passing along request) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s kvtophys() for address %p returned NULL\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s next stage output failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "memory_backing_aware_buffer_stage_outproc"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "secure_core: Unable to seek to the start of file: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Failed to dump coprocessor cores\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to dump userspace process cores\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "kern_do_coredump"
        prototype = ""
        caller = "do_kern_dump"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Registered coredump handler for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "kern_register_coredump_helper_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\nBeginning coredump of %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "coredump_init returned KERN_NODE_DOWN, skipping this core\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : coredump_init failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(%s) : save_note_note_summary failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : get_summary failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Skipping coredump\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(%s) : header size not populated after coredump_get_summary\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(%s) : save_segment_descriptions failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : save_segment_descriptions returned without all segment descriptions written, %llu of %llu remaining\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "main bin spec"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern ver str"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : coredump_save_note_description returned %d while writing binary info LC_NOTE description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : kcc_coredump_save_note_descriptions failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : save_note_descriptions returned without all note descriptions written, %llu of %llu remaining\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : save_thread_state failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "(%s) : save_thread_state returned without all thread descriptions written, %llu of %llu remaining\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_coredump_routine) : failed to write zero fill padding (%llu bytes remaining) : kdp_core_output(%p, %llu, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "coredump_save_segment_data failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_coredump_routine) : save_segment_data returned without all segment data written, %llu of %llu remaining\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : kcc_coredump_save_sw_vers_detail_cb failed with 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : kcc_coredump_save_sw_vers failed with 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : kcc_coredump_save_note_data failed with 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(%s) : kcc_coredump_save_note_data returned without all note data written, %llu of %llu remaining\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(kern_coredump_routine) : failed to flush final core data : kdp_core_output(%p, 0, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Done\nCoredump complete of %s, dumped %llu segments (%llu bytes), %llu threads (%llu bytes) overall uncompressed file length %llu bytes."
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "\nCore dump took %llu cycles\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "\n(kern_coredump_routine) : kern_dump_record_file failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " Compressed file length is %llu bytes\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "kern_coredump_routine"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s(0x%llx, 0x%llx, %p) : called with invalid addresses : start 0x%llx >= end 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(0x%llx, 0x%llx, %p) : coredump_save_segment_descriptions() called too many times, %llu segment descriptions already recorded\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(0x%llx, 0x%llx, %p) : ran out of space to save commands with %llu of %llu remaining\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s(0x%llx, 0x%llx, %p) : failed to write segment %llu of %llu. kdp_core_output(%p, %lu, %p) returned error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(0x%llx, 0x%llx, %p) : called with invalid addresses for 32-bit : start 0x%llx, end 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s(0x%llx, 0x%llx, %p) : failed to write segment %llu of %llu : kdp_core_output(%p, %lu, %p) returned  error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "coredump_save_segment_descriptions"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s() called with invalid data_owner\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s() called too many times, %llu note descriptions already recorded\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s() : failed to write note %llu of %llu : kdp_core_output() returned  error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "coredump_save_note_description"
        prototype = ""
        caller = "kern_coredump_routine"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s() : found %d expected LC_THREAD (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s() : ran out of space to save threads with %llu of %llu remaining\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s() : failed to write thread data : kdp_core_output() returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
        }
        symbol = "coredump_save_thread_state"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s() : failed to write main bin spec structure : coredump_save_note_data() returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "coredump_save_sw_vers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "coredump_save_sw_vers"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s(%p, %llu, %p) : called with invalid length %llu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s() : failed to write legacy bin spec version : coredump_save_note_data() returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s() : failed to write sw_vers string : coredump_save_note_data() returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "%s() : failed to write zero fill padding : kdp_core_output(%p, %llu, NULL) returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "coredump_save_sw_vers_legacy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Skipping userspace coredump, coredump list is locked\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kern_coredump_log"
            }
            new {
                string = "Failed to seek to beginning of next core\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kern_do_auxiliary_coredump"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipc_entry_dealloc() @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_entry_dealloc"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "corrupt hi_mod: %d, obase: %p, ocount: %d\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_entry_grow_table"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipc_eventlink_wait_block @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ipc_eventlink.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipc_eventlink_signal_wait_until_trap_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "BUG in process %s[%d]: attempt to acquire an additional legacy external boost assertion without holding an existing legacy external assertion. (%d total, %d external, %d legacy-external)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ipc_importance_task_hold_legacy_external_assertion"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "BUG in process %s[%d]: over-released legacy external boost assertions (%d total, %d external, %d legacy-external)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ipc_importance_task_drop_legacy_external_assertion"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "disabling imp_receiver on task with pending importance boosts! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_importance_task_mark_receiver"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "disabling de-nap on task with pending de-nap boosts! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_importance_task_mark_denap_receiver"
        prototype = ""
        caller = "proc_set_task_spawnpolicy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "iit unexpected zero refs: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "iit_over_release_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Importance for "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pid %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (%d of %d boosts) %s from "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "donated"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "linked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipc_importance_extract_content"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid ipc_control_port_options boot-arg: pinned control port cannot be enabled without immovability enforcement. Ignoring 1p pinning boot-arg."
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "Invalid ipc_control_port_options boot-arg: pinned control port cannot be enabled without immovability enforcement. Ignoring 3p pinning boot-arg."
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "ipc_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "size too large for the fast kmsg zone (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "non-zero aux size for kmsg type IKM_TYPE_KDATA_OOL. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_kmsg_alloc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "IPC kmsg header signature mismatch: kmsg=%p, hdr=%p, id=%d, sig=0x%08x (expected 0x%08x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ikm_signature_check_panic"
        prototype = ""
        caller = "ipc_kmsg_validate_signature"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid descriptor type (%p: %d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ipc_kmsg_descriptor_invalid_type_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "Inconsistent OOL/copyout size on %p: expected %d, got %lld @%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_kmsg_copyout_descriptors"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipc_mqueue_send @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_mqueue_send_locked"
        prototype = ""
        caller = "ipc_kmsg_send"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unknown waitq type (%p/0x%x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ipc_mqueue_receive_on_thread: sleep walking @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_mqueue_receive_on_thread_and_unlock"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipc_object_copyin_from_kernel: strange rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_object_copyin_from_kernel"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipc_object_destroy: strange rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_object_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipc_object_destroy_dest: strange rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_object_destroy_dest"
        prototype = ""
        caller = "ipc_kmsg_clean_header"
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipc_object_copyout_dest: strange rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_object_copyout_dest"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipc object %p is neither a port or a port-set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_object_validate_preflight_panic"
        prototype = ""
        caller = "ipc_object_lock_allow_invalid"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Using inactive port %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ipc_port_inactive_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "send right"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "send-once right"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "port %p %s count overflow (delta: %d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ipc_right_delta_overflow_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipc_port_destroy: invalid state @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_port_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to free an active port. port %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_port_finalize"
        prototype = ""
        caller = "ipc_object_free"
    }
    new {
        args = 1
        anchors {
            new {
                string = "found receive right in space %p for port %p owned by space %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ipc_port_translate_receive_panic"
        prototype = ""
        caller = "ipc_port_translate_receive"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipc_right_terminate: strange type - 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_right_terminate"
        prototype = ""
        caller = "ipc_space_terminate"
    }
    new {
        args = 3
        anchors {
            new {
                string = "ipc_right_destroy: strange type @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_right_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "ipc_right_delta: strange right %d for 0x%x (%p) in space:%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_right_delta"
        prototype = ""
        caller = "mach_port_mod_refs"
    }
    new {
        args = 3
        anchors {
            new {
                string = "ipc_right_copyin_check: strange rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_right_copyin_check_reply"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipc_right_copyout: Copyout kobject/kolabel as receive right @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Service port name = 0x%x doesnt match the stored launchd port name = 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ipc_right_copyout: strange rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_right_copyout"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "voucher recipe underfow @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mach_voucher_extract_all_attr_recipes"
        prototype = ""
        caller = "_Xmach_voucher_extract_all_attr_recipes"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Cannot grow ipc space beyond IVAC_ENTRIES_MAX. Some process is leaking vouchers @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Failed to grow ivac table to size %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ivace_reference_by_value"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "mach_port_get_refs: strange rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mach_port.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mach_port_get_refs"
        prototype = ""
        caller = "_Xmach_port_get_refs"
    }
    new {
        args = 2
        anchors {
            new {
                string = "com.apple.UNCUserNotificationAgent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.syncservices.uihandler"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.syncservices.ConflictResolver"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.syncservices.SyncServer"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mach_port_construct"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.developer.arcade-operations"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "arcade_prepare"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.arcade.fpsd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "arcade: received register request"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "arcade_register_new_upcall"
        prototype = ""
        caller = "_Xarcade_register_new_upcall"
    }
    new {
        args = 0
        anchors {
            new {
                string = "arcade_upcall_refresh(get fairplayd) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "arcade.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "arcade: subscription validation upcall returned %#x"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "arcade: unable to make subscription upcall, error %#x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "arcade_ast"
        prototype = ""
        caller = "ast_taken_user"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ast.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ast_taken_user"
        prototype = ""
        caller = "user_take_ast"
    }
    new {
        args = 0
        anchors {
            new {
                string = "backtrace: unknown packing format %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "backtrace.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "backtrace_internal"
        prototype = ""
        caller = "backtrace"
    }
    new {
        args = 0
        anchors {
            new {
                string = "unable to allocate initial VA: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__btlib_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "couldn't find stack %p in library %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__btlib_remove_notfound_panic"
        prototype = ""
        caller = "__btlib_remove_locked"
    }
    new {
        args = 0
        anchors {
            new {
                string = "clock_initialize_calendar"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s WARNING: UTC time is less then sys time, (%lu s %d u) UTC (%lu s %d u) sys\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "clock_initialize_calendar"
        prototype = ""
        caller = "IOKitInitializeTime"
    }
    new {
        args = 0
        anchors {
            new {
                string = "clock_alarm_deliver @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "clock_oldops.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "alarm_done"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Per-coalition ledgers"
                segment = "__TEXT"
                section = "__cstring"
                caller = "ledger_template_create"
            }
            new {
                string = "couldn't create coalition ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "couldn't create entries for coaliton ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Coalition task ledgers"
                segment = "__TEXT"
                section = "__cstring"
                caller = "ledger_template_copy"
            }
            new {
                string = "couldn't create coalition task ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "init_coalition_ledgers"
        prototype = ""
        caller = "coalitions_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "failed to adopt task %p into default coalition: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "coalitions_adopt_init_task"
        prototype = ""
        caller = "task_create_internal"
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to adopt task %p into corpse coalition: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "created task is not a member of a resource coalition @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "task_create_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "deallocating task %p was not a member of a resource coalition @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "task_release_coalitions"
        prototype = ""
        caller = "task_deallocate_internal"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: could not create init %s coalition: kr:%d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: could not create corpse %s coalition: kr:%d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "coalitions_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "unknown coalition policy: %d %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "jetsam_coalition_set_policy"
        prototype = ""
        caller = "sys_coalition_policy_set"
    }
    new {
        args = 0
        anchors {
            new {
                string = "unknown coalition policy: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "jetsam_coalition_get_policy"
        prototype = ""
        caller = "sys_coalition_policy_get"
    }
    new {
        args = 0
        anchors {
            new {
                string = "i_coal_resource_adopt_task"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "i_coal_resource_adopt_task"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "i_coal_resource_remove_task"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "i_coal_resource_remove_task"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: task %p attempting to set role %d in coalition %p to which it does not belong! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: invalid role(%d) for task @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "i_coal_jetsam_set_taskrole"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "WARNING: more than %d pids in coalition %llu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "coalition_get_sort_list"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "table %p ran out of compact IDs @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "compact_id.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "compact_id_get_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "daemon.core-analytics-events"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "telemetry_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unknown CA event type: %s. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "core_analytics.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "core_analytics_event_size"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d Assertion failed: %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "Assert"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "register_additional_panic_data_buffer called with buffer already registered @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "register_additional_panic_data_buffer called with invalid producer_name @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "register_additional_panic_data_buffer called with invalid buffer pointer @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "register_additional_panic_data_buffer called with invalid length @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "register_additional_panic_data_buffer"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "/var/tmp/panic.trace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "panic_trap_to_debugger"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Kernel UUID: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "ECC Corrections:%u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Compressor Info: %u%% of compressed pages limit (%s) and %u%% of segments limit (%s) with %d swapfiles and %s swap space\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Debugger message: %.1200s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Device: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Not set yet"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Hardware Model: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "ECID: %02X%02X%02X%02X%02X%02X%02X%02X\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AppleHWAccess Thread: 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "AppleHWAccess last access: no access data, this is unexpected.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "AppleHWAccess last access: %s of size %u at address 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Boot args: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Memory ID: 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "OS release type: %.256s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "OS version: %.256s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Kernel version: %.512s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Fileset Kernelcache UUID: "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "KernelCache UUID: "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Boot session UUID: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Boot session UUID not yet initialized\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "iBoot version: %.128s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "secure boot?: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "roots installed: %lld\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "%s data: "
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Paniclog version: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Total cpu_usage: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Thread task pri cpu_usage\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "task->map"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task->map->pmap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Panicked task %p: %lld pages, %d threads: "
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Panicked task %p: %d threads: "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pid %d: %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "unknown task"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Panicked thread: %p, backtrace: 0x%llx, tid: %llu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Could not print panicked thread backtrace:frame pointer outside kernel vm.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "%.14s (%.14s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!! debugger synchronization failed, no stackshot !!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!! panicked during stackshot, skipping panic stackshot !!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\n** Stackshot Succeeded ** Bytes Traced %d (Uncompressed %d) **\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\n** Stackshot Succeeded ** Bytes Traced %d **\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\n** Stackshot Incomplete ** Bytes Filled %llu **\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\n!! Stackshot Failed !! Bytes Traced %d, err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\n!! Stackshot Failed !!\nkcdata_memory_static_init returned %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "CORE %u is offline, skipping\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CORE %u recently retired instr at 0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "TPIDRx_ELy = {1: 0x%016llx  0: 0x%016llx  0ro: 0x%016llx }\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "CORE %u PVH locks held: "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "None\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%u - "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%u, %u - "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "First lock was acquired at PC=0x%016llx, LR=0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CORE %u is the one that panicked. Check the full backtrace for details.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CORE %u: PC=0x%016llx, LR=0x%016llx, FP=0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s\t  Could not read LR from frame at 0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s\t  Could not read FP from frame at 0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "%s\t  lr: 0x%016llx  fp: 0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Backtrace continues...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
        }
        symbol = "SavePanicInfo"
        prototype = ""
        caller = "handle_debugger_trap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "KernelCache slide: 0x%016lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "KernelCache base:  %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Kernel text exec slide: 0x%016lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Kernel text exec base:  0x%016lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "panic_display_kernel_aslr"
        prototype = ""
        caller = "SavePanicInfo"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Couldn't obtain preoslog region: result = %d, preoslog_pa = %p, preoslog_size = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "sysctl_debug_get_preoslog"
        prototype = ""
        caller = "sysctl_kern_debug_get_preoslog"
    }
    new {
        args = 0
        anchors {
            new {
                string = "/arm-io/wdt"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "awl-scratch-supported"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "set_awl_scratch_exists_flag_and_subscribe_for_pm"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Nested panic detected - entry count: %d panic_caller: 0x%016lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Nested panic string:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "\n<end nested panic string>\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Nested panic count exceeds limit %d, machine will reset or spin\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "\nNested panic stall. Stage 1 bailout. Please go to https://panic.apple.com to report this panic\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "\nIn Nested panic stall. Stage 2 bailout. Please go to https://panic.apple.com to report this panic\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
        }
        symbol = "check_and_handle_nested_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "skipping local kernel core because core file could not be opened prior to panic (mode : 0x%x, error : 0x%x)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "skipping local kernel core because the PPL is not in KERNEL state\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Original panic string:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_debugger_log"
            }
        }
        symbol = "handle_debugger_trap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "daemon.mcc_error-events"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mcc_logging_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Count of %u on ecc event is too large. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ecc_logging.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ecc_log_record_event"
        prototype = ""
        caller = "generic_platform_error_handler"
    }
    new {
        args = 0
        anchors {
            new {
                string = "cannot translate task id token from a kernel thread @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "energy_perf.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "task_id_token_to_energy_id"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mach_exception_raise_identity_protected() must be code64 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mach_exception_raise_state_identity_protected() must be code64 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bad exception behavior! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "exception_deliver"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "called exception_triage when it was forbidden by the boot environment @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "exception_triage_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "DEBUG4K thread %p task %p map %p exception %d codes 0x%llx 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pac_exception_triage"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: process %s[%d] hit a pac violation\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "exception_triage"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "attempted to set invalid special port %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "host.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kernel_set_special_port"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.xpc.launchd.event-monitor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "host_set_special_port"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.developer.driverkit.family.hid.eventservice"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "host_get_special_port_from_user"
        prototype = ""
        caller = "_Xhost_get_special_port_from_user"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.set-atm-diagnostic-flag"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "host_set_atm_diagnostic_flag"
        prototype = ""
        caller = "_Xhost_set_atm_diagnostic_flag"
    }
    new {
        args = 0
        anchors {
            new {
                string = "port %p is an invalid host port @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "host_port_copy_send"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "trying to register kobject(%d) twice @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_kobject_register_startup"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "the msgh_ids in mig_e[] aren't valid! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mig subsystem %d (%p) replies are too large (%d > %d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "message id = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "multiple entries with the same msgh_id @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "the mig dispatch table is too small @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kroutine must have precise size %d %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mig_table_max_displ = %d mach_kobj_count = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "mig_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipc_kobject_server: strange destination rights @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_kobject_server"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: unexpected kotype of port %p: want %d, got %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ipc_kobject_enable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipc_kobject_enable"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "trying to destroy an permanent port %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_kobject_destroy"
        prototype = ""
        caller = "ipc_port_destroy"
    }
    new {
        args = 2
        anchors {
            new {
                string = "ipc_kobject_label_check: attempted receive right copyout for labeled kobject @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "subst-once port %p was consumed twice @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "unexpected label: %llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_kobject_label_check"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "port %p: invalid kobject type, got %d wanted %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "port %p: invalid kobject, got %p wanted %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ipc_kobject_require_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unexpected make-send count: %p[%d], %d, %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ipc_kobject_dealloc_bad_mscount_panic"
        prototype = ""
        caller = "ipc_kobject_dealloc_port_and_unlock"
    }
    new {
        args = 0
        anchors {
            new {
                string = "unexpected send right count: %p[%d], %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ipc_kobject_dealloc_bad_srights_panic"
        prototype = ""
        caller = "ipc_kobject_dealloc_port_and_unlock"
    }
    new {
        args = 2
        anchors {
            new {
                string = "mach_msg_rpc_from_kernel @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kernel_mach_msg_rpc @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kernel_mach_msg_rpc_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mach_task_self() name changed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "task_self_trap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "userspace has control access to a kernel map %p through task %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "convert_port_to_map_with_flavor"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "strange thread flavor @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "convert_port_to_thread_with_flavor_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.private.set-exception-port"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Allowing set_exception_ports from [%s] on [%s] for entitled process/debugger\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "com.apple.security.only-one-exception-port"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Disallowing set_exception_ports from [%s] on [%s] due to only_one_exception_port policy\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "set_exception_ports_validation"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s.%u"
                segment = "__TEXT"
                section = "__cstring"
                caller = "scnprintf"
            }
        }
        symbol = "kalloc_zone_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "kalloc_type_view_copy: Insufficient space in scratch buffer @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kalloc_type_view_copy"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "__text"
                segment = "__TEXT"
                section = "__cstring"
                caller = "getsectbynamefromheader"
            }
            new {
                string = "kalloc_type_view_parse: couldn't find kext @ offset:%lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kalloc_type_view_parse: No support for non-split seg KCs @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kalloc_type_view_parse"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kalloc_type_apply_policy: assigned %u zones wasted %u zones\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kalloc_type_distribute_budget"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kalloc.type%u.%zu"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kalloc.%zu"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kalloc_type_create_zone_for_size"
        prototype = ""
        caller = "kalloc_type_create_zones_fixed"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kt_var_heaps is too small @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kalloc_type_view_init_var"
        prototype = ""
        caller = "kalloc_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kalloc_heap_startup_init: invalid KHEAP_ID: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kheap_startup_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "KT_NOSHARED used w/o private accounting for view %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kalloc_type_assign_zone_fixed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Size\ttotal_sig\tunique_signatures\tzones\tzones_sig\tzones_type\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%u\t%u\t%u\t%u\t%u\t%u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kalloc_type_create_zones_fixed"
        prototype = ""
        caller = "kalloc_type_view_init_fixed"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kalloc_data_require failed: address %p in [%s%s] @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kalloc_data_require failed: address %p in [%s%s], size too large %zd > %zd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kalloc_data_require failed: address %p not in zone native map @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kalloc_data_require_panic"
        prototype = ""
        caller = "kalloc_data_require"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kfree: addr %p trying to free with nonsensical size %zd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kfree_size_invalid_panic"
        prototype = ""
        caller = "kfree_ext"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kfree: addr %p, size %zd (offs:%zd) found in zone '%s%s' with elem_size %zd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kfree: addr %p, size %zd (offs:%zd) not found in any zone @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kfree_size_confusion_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "kfree: addr %p found in kalloc type zone '%s'but being freed to %s heap @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kfree: addr %p, size %zd found in regular zone '%s%s' @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kfree: addr %p, size %zd found in heap %s* instead of %s* @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kfree_heap_confusion_panic"
        prototype = ""
        caller = "kfree_zone"
    }
    new {
        args = 0
        anchors {
            new {
                string = "krealloc: addr %p trying to free with nonsensical size %zd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "krealloc_size_invalid_panic"
        prototype = ""
        caller = "krealloc_ext"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kern_apfs_reflock_t %p was already destroyed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kern_apfs_reflock_t %p was allocated. kern_apfs_reflock_free should be called instead of kern_apfs_reflock_destroy @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kern_apfs_reflock_t %p: destroying a reflock currently locked by ctid %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kern_apfs_reflock_t %p: destroying a reflock with threads currently waiting or in the process of waiting @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kern_apfs_reflock_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "kern_apfs_reflock_t %p was not allocated. kern_apfs_reflock_destroy should be called instead of kern_apfs_reflock_free @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kern_apfs_reflock_t %p is already in the process of being freed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kern_apfs_reflock_t %p: freeing a reflock currently locked by ctid %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kern_apfs_reflock_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Cannot use KERN_APFS_REFLOCK_IN_FORCE and KERN_APFS_REFLOCK_IN_LOCK_IF_FIRST together @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kern_apfs_reflock: too many refs for %p thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kern_apfs_reflock_try_get_ref"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Cannot use KERN_APFS_REFLOCK_IN_FORCE and KERN_APFS_REFLOCK_IN_LOCK_IF_LAST together @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kern_apfs_reflock: over releasing reflock %p thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kern_apfs_reflock_try_put_ref"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to lock a reflock owned by the same thread %p, reflock %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kern_apfs_reflock_try_lock"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "kern_apfs_reflock: kern_apfs_rl_waiters are 0 when trying to wait reflock %p thread %p. Probably a try* function with a positive will_wait wasn't called before waiting. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Trying to wait on a reflock owned by the same thread %p, reflock %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kern_apfs_reflock_wait_for_unlock"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unlocking swiref_t %p from thread ctid %u owned by ctid %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kern_apfs_reflock_unlock"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Attempt to create a ledger template with more than MAX_LEDGER_ENTRIES. MAX_LEDGER_ENTRIES=%lu, old_cnt=%u, new_cnt=%u\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ledger_entry_add_with_flags"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "ledger_entry_check_new_balance(%p,%d): negative ledger %p credit:%lld debit:0 balance:%lld @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ledger_entry_check_new_balance(%p,%d): negative ledger %p credit:%lld debit:%lld balance:%lld @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ledger_entry_check_new_balance"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Compatibility APIs"
                segment = "__TEXT"
                section = "__cstring"
                caller = "lck_grp_init_flags"
            }
        }
        symbol = "lck_group_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "lck_debug_state: feature %d imbalance @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "lock_group.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lck_grp_disable_feature"
        prototype = ""
        caller = "lockstat_disable"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Mutex to destroy still has waiters: %p: <0x%06x 0x%02x 0x%08x 0x%08x/%p 0x%04x 0x%04x> @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lck_mtx_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "lck_mtx_assert(): invalid arg (%u) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "lck_mtx_assert"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid/destroyed mutex %p: <0x%06x 0x%02x 0x%08x 0x%08x/%p 0x%04x 0x%04x> @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__lck_mtx_invalid_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Mutex interlock[%p] timeout after %llu ticks; current owner: %p, <0x%06x 0x%02x 0x%08x 0x%08x 0x%04x 0x%04x>, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lck_mtx_ilk_timeout_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Mutex %p is held as a full-mutex (spin-always lock attempted) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__lck_mtx_lock_is_sleepable_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Mutex %p is unexpectedly not owned by thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__lck_mtx_not_owned_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Mutex %p is unexpectedly owned by thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__lck_mtx_owned_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid/destroyed ptr spinlock %p: <%p %d 0x%04x> @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__hw_lck_ptr_invalid_panic"
        prototype = ""
        caller = "__smr_shash_rehash_with_target"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Ptr spinlock[%p] timeout after %llu ticks; ptr_value: %p, mcs_tail: 0x%04x, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hw_lck_ptr_timeout_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Releasing non-exclusive RW lock without a reader refcount! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "lck_rw_done"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "lck_rw_unlock(): Invalid RW lock type: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "lck_rw_unlock"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s was called with an invalid blocking type @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kdp_rwlck_find_owner"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_rwlck_find_owner"
        prototype = ""
        caller = "stackshot_thread_wait_owner_info"
    }
    new {
        args = 0
        anchors {
            new {
                string = "rw lock count underflow for thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__lck_rw_lock_count_dec_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid HW ticket lock %p <0x%08x> @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__hw_lck_ticket_invalid_panic"
        prototype = ""
        caller = "hw_lck_ticket_destroy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid ticket lock %p <0x%08x 0x%08x 0x%08x 0x%08x> @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__lck_ticket_invalid_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Ticket spinlock[%p] timeout after %llu ticks; cticket: 0x%x, nticket: 0x%x, waiting for 0x%x, current owner: %p (on CPU %d), start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lck_ticket_timeout_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Ticket spinlock[%p] timeout after %llu ticks; cticket: 0x%x, nticket: 0x%x, valid: %d, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Ticket spinlock[%p] timeout after %llu ticks; cticket: 0x%x, nticket: 0x%x, waiting for 0x%x, valid: %d, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hw_lck_ticket_timeout_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Ticket lock %p is unexpectedly not owned by thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__lck_ticket_not_owned_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Ticket lock %p is unexpectedly owned by thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__lck_ticket_owned_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Spinlock[%p] timeout after %llu ticks; current owner: %p, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Spinlock[%p] timeout after %llu ticks; current owner: %p (on cpu %d), start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hw_spin_timeout_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Spinlock[%p] timeout after %llu ticks; current value: 0x%08x, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hw_lock_bit_timeout_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "wait_while_equals32[%p] timeout after %llu ticks; current value: 0x%08x, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hw_wait_while_equals32_panic"
        prototype = ""
        caller = "ml_wait_for_cpu_signal_to_enable"
    }
    new {
        args = 0
        anchors {
            new {
                string = "wait_while_equals64[%p] timeout after %llu ticks; current value: 0x%016llx, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hw_wait_while_equals64_panic"
        prototype = ""
        caller = "_mpsc_queue_wait_for_enqueuer"
    }
    new {
        args = 0
        anchors {
            new {
                string = "hwlock: thread %p is trying to lock %p recursively @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "hw_lock_lock_contended"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Attempt to take no-preempt lock %p in preemptible context @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__lck_require_preemption_disabled_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Gate used is invalid. gate %p data %lx turnstile %p refs %d flags %x  @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "gate_verify_tag_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Gate used was destroyed. gate %p data %lx turnstile %p refs %d flags %x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "gate_verify_destroy_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to destroy a gate that was allocated by gate_alloc_init(). gate_free() should be used instead, gate %p thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gate_destroy_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to destroy a gate owned by %p. Gate %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gate_destroy_owned_panic"
        prototype = ""
        caller = "gate_destroy_internal"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to destroy a gate with waiters. Gate %p data %lx turnstile %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gate_destroy_waiter_panic"
        prototype = ""
        caller = "gate_destroy_internal"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to free a gate that was not allocated by gate_alloc_init(), gate %p thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gate_free_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to close a gate already closed gate %p holder %p current_thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gate_already_owned_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to open a gate %p owned by %p from current_thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Trying to handoff a gate %p owned by %p from current_thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gate_not_owned_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to wait on a not closed gate %p from current_thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Trying to steal a not closed gate %p from current_thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gate_not_closed_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Too many refs taken on gate. gate %p data %lx turnstile %p refs %d flags %x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "gate_too_many_refs_panic"
        prototype = ""
        caller = "gate_wait"
    }
    new {
        args = 1
        anchors {
            new {
                string = "invalid %s flag %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "gate_assert"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "gate_assert"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Invalid size %d for ml_io_read(%p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Read from IO vaddr 0x%lx paddr 0x%lx took %llu ns, result: 0x%llx (start: %llu, end: %llu), ceiling: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ml_io_read"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Invalid size %d for ml_io_write(%p, 0x%llx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Write to IO vaddr %p paddr %p val 0x%llx took %llu ns, (start: %llu, end: %llu), ceiling: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ml_io_write"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "can't allocate cpu_callback_chain_elem @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cpu_event_register_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unfortunately, cpu_event_unregister_callback is unimplemented. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZN11IOPCIBridge19setDevicePowerStateEP11IOPCIDevicem.cold.1"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ml-timeout-"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/machine-timeouts"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/chosen/machine-timeouts"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: unexpected machine timeout data_size %u for /machine-timeouts/%s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: unexpected machine timeout data_size %u for /chosen/machine-timeouts/%s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: unexpected machine timeout data_size %u for /machine-timeouts/%s-scale @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: unexpected machine timeout data_size %u for /chosen/machine-timeouts/%s-scale @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: unexpected machine timeout data_size %u for /machine-timeouts/global-scale @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: unexpected machine timeout data_size %u for /chosen/machine-timeouts/global-scale @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ml-timeout-global-scale"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "machine_timeout_init_with_suffix"
        prototype = ""
        caller = "machine_timeout_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "daemon.deferred-deallocation"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "thread_deallocate_daemon_init: creating daemon failed (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_deallocate_daemon_init"
        prototype = ""
        caller = "thread_daemon_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "mpsc_queue[%p]: use after cancelation @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "_mpsc_daemon_queue_enqueue"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Waiting for DSMOS...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dsmos_page_transform"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "0123456789abcdef0123456789ABCDEF"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__doprnt_0"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected boot pset cluster type %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "processor_bootstrap"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "processor_boot() missing for cpu %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "cpu %d failed to %s, waited %d seconds\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s>cpu %d still in shutdown @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s>cpu %d not online @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "processor_wait_for_start"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "processor %d already booted @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "processor_boot"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "recount: unexpected rollup request from %d to %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "recount_rollup"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sched_clutch_bucket_group_interactive_pri"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sched_edge_init"
        prototype = ""
        caller = "sched_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Unexpected sched_bucket passed to sched_edge_cluster_cumulative_count_decr() @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "sched_clutch thread count underflowed! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sched_clutch_thread_remove"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected sched_bucket passed to sched_edge_cluster_cumulative_count_incr() @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "sched_clutch thread count overflowed! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sched_clutch_processor_enqueue"
        prototype = ""
        caller = "thread_setrun"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Scheduler: Default of %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "sched_pri_decay_limit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern.sched_pri_decay_limit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Setting scheduler priority decay band limit %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "sched_debug"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Scheduler: Debug flags 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "sched_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "standard timeslicing quantum is %d us\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "standard background quantum is %d us\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "sched_decay_penalty"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Overriding scheduler decay penalty %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "sched_decay_usage_age_factor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Overriding scheduler decay usage age factor %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "sched_timeshare_init"
        prototype = ""
        caller = "sched_edge_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Invalid attempt to wait while running the idle thread @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_mark_wait_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "assert_wait"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "assert_wait"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "assert_wait_timeout"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "assert_wait_timeout"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "assert_wait_timeout_with_leeway"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "assert_wait_timeout_with_leeway"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "assert_wait_deadline"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "assert_wait_deadline"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "assert_wait_deadline_with_leeway"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "assert_wait_deadline_with_leeway"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "thread_wakeup_prim"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "thread_wakeup_prim"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "Non-monotonic time: dispatch at 0x%llx, runnable at 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_dispatch"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unrecognized scheduler IPI event type %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sched_ipi_policy"
        prototype = ""
        caller = "sched_edge_ipi_policy"
    }
    new {
        args = 1
        anchors {
            new {
                string = "idle_thread_create failed: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "idle #%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "idle_thread_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sched_startup @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sched_startup"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "sched_maintenance_thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "sched_init_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sched_cpu_init_completed called twice! %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "failed to create sched_update_powered_cores thread @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "sched_update_powered_cores"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "sched_cpu_init_completed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Attempting to sleep before all CPUS are registered @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sched_override_available_cores_for_sleep"
        prototype = ""
        caller = "__Z16IOCPUSleepKernelv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "unknown mode %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sched_processor_change_mode_locked"
        prototype = ""
        caller = "processor_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "shutting down the last available core! online: 0x%llx rec: 0x%llxx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sched_mark_processor_offline"
        prototype = ""
        caller = "processor_offline"
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread_invoke: preemption_level %d, possible cause: %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "unlocking an unlocked mutex or spinlock"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "blocking while holding a spinlock, or within interrupt context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Non-monotonic time: invoke at 0x%llx, runnable at 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Invalid attempt to context switch an offline processor @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_invoke"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "no last resort cpu found! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_setrun"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s>calling sched_update_powered_cores to suspend powerdown\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "suspend_cluster_powerdown_locked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "suspend_cluster_powerdown_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s>calling sched_update_powered_cores to resume powerdown\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "resume_cluster_powerdown_locked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "resume_cluster_powerdown() called with pcs.pcs_powerdown_suspend_count=%d\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "resume_cluster_powerdown_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "recommended core failsafe kicked in for %lld ms likely due to %s[%d] thread 0x%llx spending %lld ms on cpu at realtime priority - new recommendation: 0x%llx -> 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sched_timeshare_maintenance_continue"
        prototype = ""
        caller = "sched_init_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s> no last resort cpu found: 0x%llx 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "sched_update_recommended_cores_locked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sched_update_recommended_cores_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid SFI class 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Duplicate SFI registration for class 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sfi_class_register"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Gap in registered SFI classes @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sfi_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid queue linkage: elt:%p next:%p next->prev:%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__smr_linkage_invalid"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid queue tail (element past end): elt:%p elt->next:%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Invalid queue tail (early end): elt:%p tail:%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__smr_tail_invalid"
        prototype = ""
        caller = "smr_mark_active_trackers_stalled"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unable to find item %p (linkage %p) in %p (traits %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__smr_shash_missing_elt_panic"
        prototype = ""
        caller = "__smr_shash_entered_mut_begin"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kernel_stack_pages"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "stack_init: stack size %p not a multiple of page size %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "stack.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "stack_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Section %s,%s missing @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Section %s,%s has invalid size @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kernel_startup_bootstrap"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "chosen"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unexpected tunable size %u in DT entry %s/%s/%s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kernel_startup_tunable_dt_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s[%d, rank %d]: %p(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kernel_startup_initialize_upto"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: reached phase %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "kernel_startup_initialize_upto"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kern.serverperfmode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "scale_setup"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "load_context @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "load_context"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "NULL continuation passed to %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "thread_handoff_parameter"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "syscall_subr.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "thread_handoff_parameter"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kern_invalid mach trap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kern_invalid"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Warning: max_task_pmem %d below minimum.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Limiting task physical memory footprint to %d MB\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Limiting task physical memory warning to %d%%\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "hwm_user_cores"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task_wakeups_monitor_rate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task_wakeups_monitor_interval"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task_wakeups_monitor_ustackshots_trigger_pct"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task_iomon_limit_mb"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task_iomon_interval_secs"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "io_telemetry_limit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task_init @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "task_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Per-task ledger"
                segment = "__TEXT"
                section = "__cstring"
                caller = "ledger_template_create"
            }
            new {
                string = "couldn't create task ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "tkm_private"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tkm_shared"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "phys_mem"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "wired_mem"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "conclave_mem"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "iokit_mapped"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mappings"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "alternate_accounting"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "alternate_accounting_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "page_table"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "phys_footprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "internal_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "reusable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "external"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "purgeable_volatile"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "purgeable_nonvolatile"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "purgeable_volatile_compress"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "purgeable_nonvolatile_compress"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tagged_nofootprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tagged_footprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tagged_nofootprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tagged_footprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "network_volatile"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "network_nonvolatile"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "network_volatile_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "network_nonvolatile_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "media_nofootprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "media_footprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "media_nofootprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "media_footprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "graphics_nofootprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "graphics_footprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "graphics_nofootprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "graphics_footprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "neural_nofootprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "neural_footprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "neural_nofootprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "neural_footprint_compressed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "neural_nofootprint_total"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "platform_idle_wakeups"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "interrupt_wakeups"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "couldn't create entries for task ledger template for SFI class 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "cpu_time_billed_to_me"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cpu_time_billed_to_others"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "physical_writes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "logical_writes_to_external"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fs_metadata_writes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "energy_billed_to_me"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "energy_billed_to_others"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "memorystatus_dirty_time"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "swapins"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "couldn't create entries for task ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "init_task_ledgers"
        prototype = ""
        caller = "coalitions_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "task_deallocate(%p): volatile_objects=%d nonvolatile_objects=%d owned=%d\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "task_deallocate_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Failed to send exception EXC_CORPSE_NOTIFY. error code: %d for pid %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "task_deliver_crash_notification"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "warning: %s(%d) failed to copyout suspension token for pid %d with error: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "task_suspend"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "warning: %s(%d) performed out-of-band resume on pid %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "task_resume"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "couldn't take coredump of %s[%d]: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "coredump of %s[%d] taken in %d secs %d microsecs\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "process %s[%d] crossed memory high watermark (%d MB); EXC_RESOURCE suppressed by a boot-arg.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "process %s [%d] crossed memory %s (%d MB); EXC_RESOURCE \n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "high watermark"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "diagnostics limit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "process %s[%d] crossed memory high watermark (%d MB); EXC_RESOURCE suppressed due to audio playback.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "PROC_CROSSED_HIGH_WATERMARK__SEND_EXC_RESOURCE_AND_SUSPEND"
        prototype = ""
        caller = "task_footprint_exceeded"
    }
    new {
        args = 0
        anchors {
            new {
                string = "FATAL "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "send_resource_violation(CPU wakes, ...): error %#x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "process %s[%d] caught waking the CPU %llu times over ~%llu seconds, averaging %llu wakes / second and violating a %slimit of %llu wakes over %llu seconds.\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "SENDING_NOTIFICATION__THIS_PROCESS_IS_CAUSING_TOO_MANY_WAKEUPS"
        prototype = ""
        caller = "task_wakeups_rate_exceeded"
    }
    new {
        args = 0
        anchors {
            new {
                string = "send_resource_violation(disk_writes, ...): error %#x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "process [%d] caught causing excessive I/O (flavor: %d). Task I/O: %lld MB. [Limit : %lld MB per %lld secs]\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "SENDING_NOTIFICATION__THIS_PROCESS_IS_CAUSING_TOO_MUCH_IO"
        prototype = ""
        caller = "task_io_rate_exceeded"
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.private.skip.pac.exception"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.pac.exception"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "task_set_pac_exception_fatal_flag"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.security.fatal-exceptions"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "task_set_jit_exception_fatal_flag"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "proc_ro->task backref mismatch: t=%p, ro=%p, proc_ro_task(ro)=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "panic_proc_ro_task_backref_mismatch"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unknown tier %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "proc_tier_to_iopol"
        prototype = ""
        caller = "thread_get_requested_policy_spinlocked"
    }
    new {
        args = 0
        anchors {
            new {
                string = "max_cpumon_percentage"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern.max_cpumon_percentage"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "max_cpumon_interval"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern.max_cpumon_interval"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "task_policy_suppression_flags"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "proc_init_cpumon_params"
        prototype = ""
        caller = "task_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Attempting to set task policy on kernel_task @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "task_policy_update_internal_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unknown task policy: %d %d %d %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "proc_set_task_policy_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "process %s[%d] denied attempt to escape CPU monitor (missing required entitlement).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "proc_set_task_ruse_cpu"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "threads"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "thread_zone_startup"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread_corpse_continue @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_corpse_continue"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Thread %p terminating with vm_faults disabled. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "depress timer failed to inactivate!thread: %p depress_timer_active: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "wait timer failed to inactivate!thread: %p, wait_timer_active: %d, wait_timer_armed: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_terminate_self"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "daemon.thread-stack"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "thread_daemon_init: thread_stack_daemon @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "daemon.thread-exception"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "thread_daemon_init: thread_exception_daemon @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "daemon.thread-backtrace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "thread_daemon_init: thread_backtrace_daemon @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_daemon_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "guard_exc_info %llx %llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "guard_ast"
        prototype = ""
        caller = "ast_taken_user"
    }
    new {
        args = 0
        anchors {
            new {
                string = "process %s[%d] thread %llu caught burning CPU! It used more than %d%% CPU over %u seconds\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "  (actual recent usage: %d%% over ~%llu seconds)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "  Thread lifetime cpu usage %d.%06ds, (%d.%06d user, %d.%06d sys)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "  Ledger balance: %lld; mabs credit: %lld; mabs debit: %lld\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "  mabs limit: %llu; mabs period: %llu ns; last refill: %llu ns%s.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = " [fatal violation]"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "send_resource_violation(CPU usage, ...): error %#x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "SENDING_NOTIFICATION__THIS_THREAD_IS_CONSUMING_TOO_MUCH_CPU"
        prototype = ""
        caller = "thread_cputime_callback"
    }
    new {
        args = 0
        anchors {
            new {
                string = "CPU usage monitor activated, but blocking thread limit exists @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_set_cpulimit"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread_terminate_continue @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_terminate_continue"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "thread_deallocate: thread not properly terminated @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_deallocate_complete"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Per-thread ledger"
                segment = "__TEXT"
                section = "__cstring"
                caller = "ledger_template_create"
            }
            new {
                string = "couldn't create thread ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "couldn't create cpu_time entry for thread ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 1
        anchors {
            new {
                string = "idle thread calling thread_terminate! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "thread_terminate @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_terminate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unsafe act_set_kperf operation @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "act_set_kperf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread_call_initialize failed (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_initialize"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "trying to cancel NULL func @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_func_cancel"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid thread call qos value: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_allocate_with_qos"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "(%p %p) Refcount negative: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(%p %p) freeing an uninitialized call @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(%p %p) freeing a running once call @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "(%p %p) thread_call_cancel_wait: can't wait on thread call whose storage I don't own @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(%p %p) unsafe thread_call_cancel_wait @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "thread_call_cancel_wait: deadlock waiting on self from inside call: %p to function %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_cancel_wait"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid timer flavor: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_delayed_timer"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unable to wake up idle thread for termination (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_dealloc_timer"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "_internal_call_allocate: thread_call_internal_queue empty @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_enter_delayed_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread_call_daemon"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "thread_call_daemon"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "cannot create new thread call thread %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "thread call %s #%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "snprintf"
            }
        }
        symbol = "thread_call_daemon_continue"
        prototype = ""
        caller = "thread_call_daemon"
    }
    new {
        args = 1
        anchors {
            new {
                string = "thread_terminate() returned? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(%p %p) call on pending_queue from wrong group %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pending call with NULL func: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "thread_call_thread: preemption_level %d, last callout %p(%p, %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kcall worker unable to assert wait %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "(%p %p) call finishing from wrong group: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(%p %p) thread_call_finish: detected over-released thread call @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_call_finish"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread_groups"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "io storage"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "perf_controller"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "thread_group_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread_group.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "sched_perfcontrol_thread_group_recommend() not supported on the Edge scheduler @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__sigwait_nocancel.cold.2"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unknown effective QoS: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "unknown requested QoS: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_update_qos_cpu_time_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Unrecognized QoS %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "thread_recompute_priority"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "unknown task policy: %d %d %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "proc_set_thread_policy_spinlocked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "timer_longterm_update_master() on non-boot cpu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "timer_call.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "timer_longterm_update"
        prototype = ""
        caller = "timer_longterm_callout"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Longterm timer threshold: %llu ms\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "timer_call_init"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Needs implementation for turnstile_recompute_priority @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "turnstile_recompute_priority_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ts_htable_buckets"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Turnstiles hash table memory allocation failed! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "turnstiles_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Missing type in flags (%x) for inheritor (%p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "turnstile_update_inheritor"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Inheritor flags not passed in turnstile_update_inheritor @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "turnstile_update_inheritor_priority_chain"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "turnstile_is_send_turnstile() called outside of kernel debugger context @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kdp_turnstile_traverse_inheritor_chain"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Couldn't allocate send right for ux_handler_port! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "host_set_exception_ports failed to set ux_handler! %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ux_handler_setup"
        prototype = ""
        caller = "bsdinit_task"
    }
    new {
        args = 0
        anchors {
            new {
                string = "wqsize"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "waitq_bootstrap"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "thread already waiting on %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Trying to assert_wait on a turnstile proxy that hasn't been donated one (waitq: %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "waitq_assert_wait64_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to clear_wait on a turnstile proxy that hasn't been donated one (waitq: %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "waitq_pull_thread_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "waitq(%p) lock timeout after %llu ticks; cpu=%d, cticket: 0x%x, nticket: 0x%x, waiting for 0x%x, start time: %llu, now: %llu, timeout: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "waitq_timeout_handler"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "WI%lld (pid %d)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kern_work_interval_create"
        prototype = ""
        caller = "work_interval_ctl"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone %p isn't in the zone_array @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_invalid_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "zone_submap_alloc_sequestered_va() of %u pages failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_fill_initially"
        prototype = ""
        caller = "fsevents_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Zone %s should be empty upon userspace reboot. Actual size: %lu. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_userspace_reboot_checks"
        prototype = ""
        caller = "exec_mach_imgact"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kalloc.%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "snprintf"
            }
        }
        symbol = "mach_memory_info_sample"
        prototype = ""
        caller = "mach_memory_info"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone_create: element size too large: %zd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ZC_NOCACHING"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ZC_NOGC"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ZC_DATA"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Fragmentation greater than 10%% with elem size %d zone %s%s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ZC_PGZ_USE_GUARDS"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "zone_create: invalid desired zone ID %d for %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone_create: ID %d (%s) must be permanent @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone_create: creating zone ID %d (%s) twice @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_create_ext"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "zdestroy: Zone %s%s isn't empty at zdestroy() time @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zdestroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zc_mag_size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_bootstrap"
        prototype = ""
        caller = "vm_mem_bootstrap"
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_page"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ksubmap[%s]: failed to make first entry (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ksubmap[%s]: failed to make last entry (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_submap_init"
        prototype = ""
        caller = "zone_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zsize"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NOTE: zonemap size reduced from 0x%lx to 0x%lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "zone_set_map_sizes"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm.permanent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm.permanent.percpu"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "zcc_magazine_zone"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone bound checks: address %p is a per-cpu allocation @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone bound checks: buffer %p of length %zd overflows object %p of size %zd in zone %p[%s%s] @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_element_bounds_check_panic"
        prototype = ""
        caller = "zone_element_bounds_check"
    }
    new {
        args = 1
        anchors {
            new {
                string = "zone_require failed: address not in a zone (addr: %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone_require failed: invalid zone index %d (addr: %p, expected: %s%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone_require failed: address in unexpected zone id %d (%s%s) (addr: %p, expected: %s%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_require_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "addr %p being freed to zone %s%s%s, isn't from zone map @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "metadata %p corresponding to addr %p being freed to zone %s%s%s, is marked as secondary per cpu page @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "metadata %p corresponding to addr %p being freed to zone %s%s%s, has chunk len greater than max @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "addr %p being freed to zone %s%s%s, isn't aligned to zone element size @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_invalid_element_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%p expected in zone %s%s[%d], but metadata has invalid zidx: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%p not in the expected zone %s%s[%d], but found in %s%s[%d] @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_page_metadata_index_confusion_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone element pointer validation failed (addr: %p, zone %s%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_invalid_element_addr_panic"
        prototype = ""
        caller = "zone_invalid_element_panic"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone bits allocator freelist is corrupt (%p <-> %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zba_chain_corruption_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zba_populate: out of bitmap space, likely due to memory leak in zone [%s%s] (%u%c, %d elements allocated) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zba_memory_exhausted"
        prototype = ""
        caller = "zba_grow"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone bits allocator head[%d:%d:%p] is corrupt @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zba_head_corruption_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "accounting mismatch (%s) for zone %s%s, meta %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_page_meta_accounting_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "metadata list corruption through element %p detected in zone %s%s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_page_metadata_list_corruption"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zfree_drop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: double free of %p to zone %s%s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_meta_double_free_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "zm_bitmap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_meta_find_and_clear_bit"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\n%5d: 0x%016lx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s%s]: element modified after free (off:%d, val:0x%016lx, sz:%d, ptr:%p)%s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zalloc_uaf_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "zalloc[%d]: zone map exhausted while allocating from zone [%s%s], likely due to memory leak in zone [%s%s] (%u%c, %d elements allocated) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_expand_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone map exhaustion: waited for %dms (pages: %ld, max: %ld, wanted: %d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZONE_MAP_EXHAUSTED_AND_WAITING_FOR_GC__"
        prototype = ""
        caller = "zone_expand_locked"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zalloc(Z_NOFAIL) can't be satisfied for zone %s%s (potential leak) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_nofail_panic"
        prototype = ""
        caller = "zalloc_item"
    }
    new {
        args = 1
        anchors {
            new {
                string = "zalloc_ro_mut failed: source (%p) not from same zone as dst (%p) (expected: %s, actual: %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zalloc_ro_mut failed: source (%p, phys %p) not from RO zone map (%p - %p), current stack (%p - %p) or const memory (phys %p - %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zalloc_ro_mut_validation_panic"
        prototype = ""
        caller = "zalloc_ro_mut"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone_require_ro failed: address not in a ro zone (addr: %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone_require_ro failed: element improperly aligned (addr: %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone_require_ro failed: invalid zone index %d (addr: %p, expected: %s%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zone_require_ro failed: address in unexpected zone id %d (%s%s) (addr: %p, expected: %s%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_id_require_ro_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zdestroy: Zone %s%s isn't destructible @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zdestroy: Zone %s%s in an invalid state for destruction @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "alloc_size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "page_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "z_elems_avail wrap-around"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "z_wired_cur wrap-around"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "zone_reclaim"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone metadata corruption: %s (meta %p, zone %s%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_metadata_corruption"
        prototype = ""
        caller = "zone_reclaim"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone_map_exhaustion: Zone mapped %lld of %lld, used %lld, capacity %lld [jetsam limit %d%%]\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "zone_map_exhaustion: Largest zone %s%s, size %lu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "zone_map_exhaustion: Picking VM map entries as the zone to target, size %lu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "zone_map_exhaustion: Nothing to do for the largest zone [%s%s]. Waking up memorystatus thread.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "zone_map_exhaustion: Call to memorystatus failed, victim pid: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "zone_gc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Zone info:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Zone map: %p - %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Metadata: %p - %p\n  Bitmaps : %p - %p\n  Extra   : %p - %p\n\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Probabilistic GZAlloc Report:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Zone    : <unknown>\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "wild deref, missing or invalid metadata"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "  Zone    : %s%s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "out-of-bounds (high confidence)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "use-after-free (medium confidence)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "  Element : [%p, %p) of size %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Access  : %d byte(s) past\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "  Metadata: zid:%d inl:%d cl:0x%x 0x%04x 0x%08x 0x%08x 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%-20s %10lu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Kernel Stacks"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%-20s %10llu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Kalloc.Large"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\n%-5s %10s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "%-5lld %10lld\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "addr belongs to"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_print_types_in_zone"
            }
            new {
                string = "addr is being freed to"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_print_types_in_zone"
            }
        }
        symbol = "panic_display_zalloc"
        prototype = ""
        caller = "SavePanicInfo"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Largest zones:\n%-28s %10s %10s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Zone Name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Cur Size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Free Size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%-8s%-20s %9u%c %9u%c\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "panic_display_largest_zones"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kalloc %s in zone, %s (%s):\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "type arrays"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "types"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\t%-50s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "panic_print_types_in_zone"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone_create: creating zone %s: flag %s and %s are incompatible @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_create_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "accounting mismatch (%s) for zone %s%s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "zone_accounting_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "swap_task_map @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "swap_task_map"
        prototype = ""
        caller = "exec_mach_imgact"
    }
    new {
        args = 0
        anchors {
            new {
                string = "tro %p points back to %p instead of %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__thread_ro_circularity_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mach_bridge_add_timestamp: thread_timestamp_calibration @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "remote_time.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bt_calibration_thread_start"
        prototype = ""
        caller = "mach_bridge_init_timestamp"
    }
    new {
        args = 0
        anchors {
            new {
                string = "rt_ini_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bt_calibration_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "socd buffer size is too small @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "socd_client.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "socd_client_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Too many lightweight corpse in flight: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Lightweight corpse enqueued for %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "Full corpse enqueued for %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "task_enqueue_exception_with_corpse"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "kcd_c_type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kcd_c_totalout"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kcd_c_totalin"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kcdata_init_compress_state: invalid compression type: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kcdata_init_compress"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid compression type 0x%llx in kcdata_do_compress @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "zlib kcdata compression ret = %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kcdata_do_compress"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid compression type 0x%llxin kcdata_finish_compression @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kcdata_finish"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "BANK subsystem is initialized\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Bank ledger"
                segment = "__TEXT"
                section = "__cstring"
                caller = "ledger_template_create"
            }
            new {
                string = "couldn't create bank ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "couldn't create cpu_time entry for bank ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "energy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "couldn't create energy entry for bank ledger template @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bank_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = " Bank Context for a pid %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " Bank Account linking holder pid %d with merchant pid %d, originator PID/persona: %d, %u and proximate PID/persona: %d, %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bank_extract_content"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Bogus bank type: %d passed in voucher_command @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bank_command"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Bogus bank type: %d passed in bank_get_preadopt_thread_group @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bank_get_preadopt_thread_group"
        prototype = ""
        caller = "ipc_kmsg_get_thread_group"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.persona.modify"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bank_get_value"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.personas.no.propagate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.persona.adopt.any"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bank_task_initialize"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Releasing a non zero ref bank account %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bank_release_value"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Bogus bank type: %d passed in bank_get_voucher_bank_account @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bank_get_voucher_bank_account"
        prototype = ""
        caller = "bank_get_bank_ledger_thread_group_and_persona"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kern.disable_atm"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-disable_atm"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "atm_diagnostic_config"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern.atm_diagnostic_config"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ATM subsystem is initialized\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "atm_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "IPC_PTHREAD_PRIORITY subsystem is initialized\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipc_pthread_priority_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipc_pthread_priority_release_value called for a persistent PTHPRIORITY value %x with sync value %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ipc_pthread_priority.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipc_pthread_priority_release_value"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vnode_pager_init: memory_object_change_attributes() failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_pager_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_pager_data_initialize @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_cs_core_entitlements_abort_0"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "compressor_segment"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_compressor_swap_trigger_thread: create failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_compressor_init"
        prototype = ""
        caller = "vm_pageout"
    }
    new {
        args = 0
        anchors {
            new {
                string = "c_seg %p has bad c_state = %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "c_seg %p requesting bad c_state = %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "c_seg_switch_state"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "hibernate_write_image encountered error 0x%x - %u, %u, %d, %d, %d, %d, %d, %d, %d, %d, %llu, %d, %d, %d\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_panic_hibernate_write_image_failed"
        prototype = ""
        caller = "hibernate_write_image"
    }
    new {
        args = 0
        anchors {
            new {
                string = "csegbufsz_experiment_property: Failed to wait for IONVRAM."
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "csegbufsize_experiment_property: Failed to remove %s from NVRAM."
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "erase_csegbufsz_experiment_property"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_compressor_segment_buffer_size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern.compressor_pool_multiplier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_compressor_set_size"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: moved %d/%d segments from MAJORQ to AGEQ in %lu.%09u seconds and %d breaks\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_compressor_process_major_segments"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_compressor_process_major_segments"
        prototype = ""
        caller = "vm_compressor_compact_and_swap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "VM_cswap_trigger"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "vm_compressor_swap_trigger_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "C_KDP passed to decompress page from outside of debugger context @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "c_decompress_page: c_segno %d >= c_segments_available %d, slot_ptr(%p), slot_data(%x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "c_decompress_page: c_segno %d is free, slot_ptr(%p), slot_data(%x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "c_decompress_page: c_indx %d >= c_nextslot %d, c_seg(%p), slot_ptr(%p), slot_data(%x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "c_decompress_page: c_size == 0, c_seg(%p), slot_ptr(%p), slot_data(%x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "decompression failure from physical region %llx+%05x: popcount mismatch (%d != %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "c_decompress_page"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "compressor_memory_object_init: bad request @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "compressor_memory_object_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "compressor_memory_object_map @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "os_reason_set_description_data.cold.3"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "compressor_memory_object_last_unmap @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "fourk_pager_data_return"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "compressor_memory_object_deallocate(): bad request @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "compressor_memory_object_deallocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "compressor_memory_object_data_request(): bad alignment @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "compressor_memory_object_data_request"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "compressor: data_request @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "compressor_memory_object_data_request"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "do a data_return() if slot for this page is empty @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "compressor_memory_object_data_initialize"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "compressor: data_return @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZN24AppleUSBXHCITransferRing21refreshDequeuePointerEv.cold.1"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: size 0x%llx overflow @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "compressor_memory_object_create"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "compressor_memory_object_create"
        prototype = ""
        caller = "vm_object_compressor_pager_create"
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_compressor_pager_put"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_compressor_pager_put: out of range @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_compressor_pager_put"
        prototype = ""
        caller = "vm_pageout_compress_page"
    }
    new {
        args = 2
        anchors {
            new {
                string = "vm_compressor_pager_get"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_compressor_pager_get"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_compressor_pager_state_clr"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_compressor_pager_state_clr"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_compressor_pager_state_get"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_compressor_pager_state_get"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_swapout_thread: create failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_swapout"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "vm_swapfile_create_thread: create failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_swapfile_create"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "vm_swapfile_gc_thread: create failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_swapfile_gc"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "VM Swap Subsystem is ON\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_compressor_swap_init"
        prototype = ""
        caller = "vm_compressor_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_swap_get: vnode_getwithref on swapfile failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_swap_get"
        prototype = ""
        caller = "c_seg_swapin"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_swap_put: vnode_getwithref on swapfile failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_swap_put"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_swap_reclaim: vnode_getwithref on swapfile failed.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_swap_reclaim"
        prototype = ""
        caller = "vm_swapfile_gc_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_swap_do_delayed_trim: vnode_getwithref on swapfile failed with %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_swap_do_delayed_trim"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_compressor_codec"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-vm_compressor_wk_sw"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-vm_compressor_wk_barriers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-vm_compressor_wk"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "-vm_compressor_hybrid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_compressor_algorithm_init"
        prototype = ""
        caller = "vm_compressor_init"
    }
    new {
        args = 4
        anchors {
            new {
                string = "WKDMC(%p, %p) error, code: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_compressor_algorithms.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "metacompressor"
        prototype = ""
        caller = "vm_compressor_put"
    }
    new {
        args = 0
        anchors {
            new {
                string = "device_pager_populate_object: list_req failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "device_pager_populate_object"
        prototype = ""
        caller = "__ZN18IOMemoryDescriptor19populateDevicePagerEPvP7_vm_mapyyyj"
    }
    new {
        args = 1
        anchors {
            new {
                string = "device_pager_init: memory_object_change_attributes() failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "device_pager_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "device_pager_data_initialize @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "persona_lookup_and_invalidate.cold.1"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "vm_object_update: unexpected error 0x%x from vm_fault_page()\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_update"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Ignoring \"vm_compressor\" boot arg %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kern.vm_compressor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\"vm_compressor_mode\" is %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_protect_privileged_from_untrusted"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_fault_init"
        prototype = ""
        caller = "vm_mem_bootstrap"
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_fault_page(): unexpected error %d from vm_compressor_pager_get()\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_fault_page"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_fault_unwire: failure @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_fault_unwire"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_fault_copy: unexpected error 0x%x from vm_fault_page()\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_fault_copy(2): unexpected error 0x%x from vm_fault_page()\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_fault_copy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp_lightweight_fault called from outside of debugger context @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kdp_lightweight_fault"
        prototype = ""
        caller = "kdp_find_phys"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Text page corruption detected for pid %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "revalidate_text_page"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: pmap %p vaddr 0x%llx prot 0x%x options 0x%x !cs_bypass @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "page marked to be NX, not letting it be mapped EXEC\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_fault: signed: %s validate: %s tainted: %s wpmapped: %s prot: 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "CODE SIGNING: process %d[%s]: rejecting invalid page at address 0x%llx from offset 0x%llx in file \"%s%s%s\" (cs_mtime:%lu.%ld %s mtime:%lu.%ld) (signed:%d validated:%d tainted:%d nx:%d wpmapped:%d dirty:%d depth:%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "<nil>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/.../"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_fault_enter: failed to allocate codesigning exit reason\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_fault_enter: failed to allocate buffer for codesigning exit reason\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_fault_enter: failed to allocate kcdata for codesigning exit reason\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "CODE SIGNING: tainted page %p phys 0x%x phystokv 0x%llx copied to %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "CODE SIGNING: process %d[%s]: rejecting invalid page (phys#0x%x) at address 0x%llx from offset 0x%llx in file \"%s%s%s\" (cs_mtime:%lu.%ld %s mtime:%lu.%ld) (signed:%d validated:%d tainted:%d nx:%dwpmapped:%d dirty:%d depth:%d)\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CODESIGNING: vm_fault_enter(0x%llx): *** INVALID PAGE ***\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "CODESIGNING: panicking on invalid page @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_fault_enter_prepare"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Write fault on compressor map, va: %p type: %u bounds: %p->%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s:%d should not zero-fill page at offset 0x%llx in external object %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: map %p va 0x%llx obj %p,%u saved %p,%u: unexpected CoW @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "object_is_contended @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_fault: unexpected error 0x%x from vm_fault_page()\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: pmap %p vaddr 0x%llx prot 0x%x options 0x%x m%p obj %p copyobj %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_fault_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "CODESIGNING: %s: page %p obj %p off 0x%llx was modified\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_page_validate_cs_fast"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_page_validate_cs_fast"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Bad compare and swap in setup! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vmtc_text_page_diagnose_setup"
        prototype = ""
        caller = "revalidate_text_page"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Bad compare and swap in diagnose! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vmtc_text_page_diagnose"
        prototype = ""
        caller = "revalidate_text_page"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_page_bootstrap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "zone_bootstrap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_object_bootstrap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_map_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kmem_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_fault_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IOKit IOMD setownership ENABLED\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IOKit IOMD setownership DISABLED\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_mem_bootstrap"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem_suballoc(map=%p, size=%zd) failed with %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_suballoc"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "%s: page_list too short @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: page_list too long @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kernel_memory_populate_object_and_unlock"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "realloc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kmem_%s(map=%p, addr=%p, size=%zd, flags=0x%x): invalid arguments passed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__kmem_invalid_arguments_panic"
        prototype = ""
        caller = "kmem_realloc_guard"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem_range_init: Can't scramble with multiple constraints @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_readjust_ranges"
        prototype = ""
        caller = "kmem_scramble_ranges"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem_ptr_range"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kmem_ptr_range_meta"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kmem_add_ptr_claims"
        prototype = ""
        caller = "kmem_add_extra_claims"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem_sprayqtn_range"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kmem_data_range"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kmem_add_extra_claims"
        prototype = ""
        caller = "kmem_scramble_ranges"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem_range_init: vm_map_locate_space failing for claim %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kmem_range_init: vm_map_find_space failing for claim %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_scramble_ranges"
        prototype = ""
        caller = "kmem_range_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem_init(0x%llx,0x%llx): vm_map_enter(0x%llx,0x%llx) error 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kmem_init"
        prototype = ""
        caller = "vm_mem_bootstrap"
    }
    new {
        args = 2
        anchors {
            new {
                string = "%s: %s range invalid min:%p <= base:%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: %s range invalid max:%p >= max packable:%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_packing_verify_range"
        prototype = ""
        caller = "zone_submap_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid vm range: [0x%llx, 0x%llx) wraps around @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__mach_vm_range_invalid"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "addr %p + size %llu overflows %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "addr %p + size %llu doesnt fit in one range (id: %u min: %p max: %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kmem_range_invalid_panic"
        prototype = ""
        caller = "kmem_addr_get_range"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Can't overwrite mappings (addr: %p) in kmem ptr ranges @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_range_invalid_for_overwrite"
        prototype = ""
        caller = "vm_map_locate_space_fixed"
    }
    new {
        args = 0
        anchors {
            new {
                string = "atomicity"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "objectness"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "left bound"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "right bound"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "guard"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kmem(map=%p, addr=%p, size=%zd, flags=0x%x): entry:%p %s mismatch guard(0x%08x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__kmem_entry_validate_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem(map=%p) no entry found at %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__kmem_entry_not_found_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "alloc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kmem_%s(%p, %zd, 0x%x): failed with %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__kmem_failed_panic"
        prototype = ""
        caller = "kmem_alloc_guard_internal"
    }
    new {
        args = 3
        anchors {
            new {
                string = "VM page %p should not have an error @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kernel_memory_populate_pmap_enter"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem(map=%p, flags=0x%x): invalid size %zd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__kmem_invalid_size_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kmem(map=%p) entry %p is a submap @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "is unexpectedly"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kmem(map=%p, flags=0x%x): entry %p %s for the %s object @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__kmem_entry_validate_object_panic"
        prototype = ""
        caller = "kmem_realloc_guard"
    }
    new {
        args = 1
        anchors {
            new {
                string = "kmem_realloc(map=%p, addr=%p, size=%zd, entry=%p): object %p has unexpected pager %p (%d,%d,%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__kmem_realloc_invalid_pager_panic"
        prototype = ""
        caller = "kmem_realloc_guard"
    }
    new {
        args = 1
        anchors {
            new {
                string = "kmem_realloc(map=%p, addr=%p, size=%zd, entry=%p): object %p has unexpected size %ld @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__kmem_realloc_invalid_object_size_panic"
        prototype = ""
        caller = "kmem_realloc_guard"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid sizeclass idx %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_invalid_size_idx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Metadata (%p) for addr (%p) not primary @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Metadata's (%p) sizeclass (%u != %u) changed during deletion @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Double free detected: Slot (%u) in meta (%p) for addr %p marked free @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_validate_slot_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid kmem ptr slot [%p:%p] for allocation [%p:%p] @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_invalid_slot_for_addr"
        prototype = ""
        caller = "kmem_addr_get_slot_idx"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%uth free slot not found for meta %p bitmap %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_slot_not_found"
        prototype = ""
        caller = "kmem_get_addr_from_meta"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid slot idx %u [0:%u] for meta %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Invalid size_idx (%u != %u) in meta %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "page_marker %u not primary in meta %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_invalid_meta_panic"
        prototype = ""
        caller = "kmem_get_addr_from_meta"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Entry (%p) already exists for addr (%p) being returned @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_slot_has_entry_panic"
        prototype = ""
        caller = "kmem_get_addr_from_meta"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Reading free chunks for meta %p where marker != KMEM_META_FREE @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_invalid_free_chunk_len"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid number of chunks %u\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_invalid_chunk_num"
        prototype = ""
        caller = "kmem_init_free_chunk"
    }
    new {
        args = 0
        anchors {
            new {
                string = "No more VA to allocate %u chunks in range %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_range_out_of_va"
        prototype = ""
        caller = "kmem_locate_space"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Reading free chunks for meta %p where marker != KMEM_META_PRIMARY @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kmem_invalid_chunk_len"
        prototype = ""
        caller = "kmem_free_slot"
    }
    new {
        args = 0
        anchors {
            new {
                string = "cambria_pagesize"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "VM map entries"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "VM map holes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "VM map copies"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "VM boostrap: %d maps, %d entries and %d holes available\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_memory_malloc_no_cow_mask"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_init"
        prototype = ""
        caller = "vm_mem_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "VM bootstrap done: %d maps, %d entries and %d holes left\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_kernel_boostraped"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected zone ID %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_relocate_early_elem"
        prototype = ""
        caller = "zone_metadata_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "zone_map_exhaustion: victim pid %d, vm region count: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "find_largest_process_vm_map_entries"
        prototype = ""
        caller = "zone_gc"
    }
    new {
        args = 1
        anchors {
            new {
                string = "failing"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "turning off execute"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_map_enter: pmap_nest(0x%llx,0x%llx) error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%d[%s] %s: map size 0x%llx over RLIMIT_AS 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%d[%s] %s: map size 0x%llx over RLIMIT_DATA 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_map_enter"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "VM_FLAGS_RETURN_DATA_ADDR not expected for submap. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_map_enter_mem_object: memory_entry->backing.copy unsupported type 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "invalid VM named entry %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_FLAGS_RETURN_DATA_ADDR not expected for raw memory object. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_enter_mem_object"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_protect(%p,0x%llx,0x%llx) new=0x%x wired=%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_protect"
        prototype = ""
        caller = ""
    }
    new {
        args = 5
        anchors {
            new {
                string = "%s:%d WindowServer VM Debugging panic: dst_addr 0x%llx copy %p head_addr 0x%llx head_copy %p\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_map_copy_overwrite"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_copy_overwrite"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Aborting corpse map due to system shutdown\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_map_fork"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_map_fork_share: pmap_nest failed! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_map_fork_share"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_fork"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: task %p: vm_map_exec(%p,%p,%p,0x%x,0x%x): ->\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: task %p: vm_map_exec(%p,%p,%p,0x%x,0x%x): <-\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Failed to reserve %s region in user map %p %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_exec"
        prototype = ""
        caller = "exec_mach_imgact"
    }
    new {
        args = 3
        anchors {
            new {
                string = "%s:%d(start=0x%llx, size=0x%llx) pgmask 0x%x: wraparound\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_map_range_physical_size"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "%d[%s] vm_remap(0x%llx,0x%llx) VM_PROT_COPY denied on permanent mapping prot 0x%x/0x%x developer %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_map_remap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "userspace has access to a kernel map %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "convert_port_entry_to_map"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%d[%s] vm_map_range_overflows addr 0x%llx size 0x%llx pgmask 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_map_range_overflows"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid range ID (%u) for map %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_range_invalid_panic"
        prototype = ""
        caller = "vm_map_locate_space_anywhere"
    }
    new {
        args = 2
        anchors {
            new {
                string = "vm_map_clip_unnest(0x%llx,0x%llx): bad nested entry: start=0x%llx end=0x%llx\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_clip_unnest"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_clip(%p): Attempting to clip an atomic VM map entry %p [0x%llx:0x%llx] at 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__vm_map_clip_atomic_entry_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mapHdr %p entry %p start 0x%llx end 0x%llx new start 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_vm_map_clip_start"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mapHdr %p entry %p start 0x%llx end 0x%llx new end 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_vm_map_clip_end"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_wire: re-lookup failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_wire_nested"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_wire: too many wirings @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "add_wire_counts"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_unwire: start not found @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_map_unwire: in_transition entry @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_map_unwire: entry is unwired @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_map_unwire: non-contiguous region @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_map_unwire: re-lookup failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_unwire_nested"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "%d[%s] removing permanent submap entry %p [0x%llx:0x%llx] prot 0x%x/0x%x -> KERN_PROT_FAILURE\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%d[%s] %s(0x%llx,0x%llx): code signing monitor disabled, allowing for permanent executable entry [0x%llx:0x%llx] prot 0x%x/0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d %d[%s] map %p entry %p [ 0x%llx - 0x%llx ] submap %d prot 0x%x/0x%x -> 0/0\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_map_delete"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_delete(%p,0x%llx,0x%llx): no map entry at 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__vm_map_delete_gap_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_delete(%p,0x%llx,0x%llx): Attempting to remove permanent VM map entry %p [0x%llx:0x%llx] @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__vm_map_delete_permanent_panic"
        prototype = ""
        caller = "vm_map_delete"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_delete(%p,0x%llx,0x%llx): failed unexpected with %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__vm_map_delete_failed_panic"
        prototype = ""
        caller = "vm_map_delete"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d WindowServer VM Debugging panic: address 0x%llx copy ptr %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d WindowServer VM Debugging panic: start 0x%llx end 0x%llx entry %p copy ptr %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d WindowServer VM Debugging panic: next %p entry %p copy ptr %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_copy_overwrite_nested"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_entry_copy_code_signing"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "removing execute access"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_entry_copy"
        prototype = ""
        caller = ""
    }
    new {
        args = 5
        anchors {
            new {
                string = "vm_map_copyout: wiring %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_copyout_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_map_remap_extract"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_remap_extract"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Found an existing entry %p [0x%llx, 0x%llx) in map %p instead of potential hole at address: 0x%llx. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__vm_map_store_find_space_holelist_corruption"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "VMSEL: INSERT FAILED: 0x%lx, 0x%lx, 0x%lx, 0x%lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_store_entry_link_rb"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "NO ENTRY TO DELETE @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_store_entry_unlink_rb"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Hole hint failed: Hole entry start: 0x%llx, entry start: 0x%llx, map hole start: 0x%llx, map hint start: 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Hole hint failed: Hole entry end: 0x%llx, entry start: 0x%llx, map hole start: 0x%llx, map hint start: 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "update_holes_on_entry_deletion"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Illegal action: h1: %p, s:0x%llx, e:0x%llx...h2:%p, s:0x%llx, e:0x%llx...h3:0x%p, s:0x%llx, e:0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "update_holes_on_entry_creation"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.memory.ownership_transfer"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.developer.memory.transfer-send"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.developer.memory.transfer-accept"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mach_memory_entry_ownership"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "unsupported type of mem_entry %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mach_memory_entry_map_size"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Shouldn't be using data address with a parent entry that is a submap. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mach_make_memory_entry_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm objects"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_object_bootstrap"
        prototype = ""
        caller = "vm_mem_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "VM_io_reprioritize_thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "Could not create io_reprioritize_thread @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_io_reprioritize_init"
        prototype = ""
        caller = "throttle_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to launch vm_object_reaper_thread kr=0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_object_reaper_thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "vm_object_reaper_init"
        prototype = ""
        caller = "vm_pageout"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_object_deallocate: losing a kernel_object @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_deallocate: losing retired_pages_object @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_deallocate: losing compressor_object @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_deallocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "object %p all_reusable: can't update pmap stats @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_reuse_pages"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_object_copy_slowly: unexpected error 0x%x from vm_fault_page()\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_copy_slowly"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "copy_strategically: bad strategy %d for object %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_copy_strategically"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_object_compressor_pager_create(): no pager for object %p size 0x%llx\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_compressor_pager_create: mismatch (pager: %p, pager_object: %p, orig_object: %p, orig_object size: 0x%llx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_compressor_pager_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_object_collapse() attempting to collapse purgeable object: %p(%d) %p(%d)\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_collapse"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_object_populate_with_private - %p not private @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_populate_with_private"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: external object %p has unsupported ledger_tag %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: object %p has unsupported ledger_tag %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_ledger_tag_ledgers"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s(%p): volatile=%d nonvolatile=%d owned=%d q=%p q_first=%p q_last=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_owned_objects_disown"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_owned_objects_disown"
        prototype = ""
        caller = "task_deallocate_internal"
    }
    new {
        args = 0
        anchors {
            new {
                string = "reservation without pageout? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "missing pager for copy object @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_pageout_initialize_page"
        prototype = ""
        caller = "vm_fault_page"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_pageout: no victim @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_pageout_scan"
        prototype = ""
        caller = "vm_pageout_continue"
    }
    new {
        args = 0
        anchors {
            new {
                string = "VM_pressure"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "vm_pressure_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_restricted_to_single_processor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Overriding vm_restricted_to_single_processor to %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "vm_set_restrictions"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "mapping deprecated VM_PAGER_DEFAULT to VM_PAGER_COMPRESSOR_WITH_SWAP\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "mapping deprecated VM_PAGER_FREEZER_DEFAULT to VM_PAGER_FREEZER_COMPRESSOR_NO_SWAP\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "unknown compressor mode - %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_config_init"
        prototype = ""
        caller = "vm_fault_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_pageout_garbage_collect: create failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_pageout_garbage_collect"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "vm_pageout_create_gc_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vmpgo_pcluster"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vmpgo_protect_realtime"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "VM_pageout_scan"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "vm_pageout: Unable to create external thread (%d)\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_pageout_external_iothread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "vm_pressure_thread: create failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_pageout"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vmcomp_threads"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vmpgoi_maxlaundry"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_pageout: Unable to create compressor thread no. %d (%d)\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_pageout_internal_start"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_object_upl_request: external object with non-zero paging offset @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_upl_request: contiguous object specified @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "need corner case for fictitious page @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_upl_request"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "Only %d of the %d sub-upls within the Vector UPL are alread mapped @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "TODO4K: vector UPL not implemented @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_upl_map: page missing @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_map_enter failed for a Vector UPL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vector_upl_get_submap was passed a NULL UPL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "getting sub-upl iostate when none exists @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_enter_upl_range"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "%d of the %d sub-upls within the Vector UPL is/are not mapped @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vector_upl_get_submap was passed a null UPL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_map_remove_upl_range"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "iopl_valid_data: NULL upl @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: vector upl @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: unsupported upl, flags = %x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: object == kernel or compressor @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: object %p purgable %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: missing expected page at offset %lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: busy page w/o absent @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: busy+absent page on page queue @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: %p is reusable @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "iopl_valid_data: %p already wired @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "iopl_valid_data"
        prototype = ""
        caller = "__ZN25IOGeneralMemoryDescriptor8completeEj"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_object_iopl_request: external object with non-zero paging offset @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_iopl_request: missing/bad page in kernel object @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_iopl_request: missing/bad page in compressor object @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_iopl_request: unexpected error 0x%x from vm_fault_page()\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_object_iopl_request: Wired page missing. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_object_iopl_request"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Deallocating non-empty Vectored UPL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "upl_deallocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Trying to remove sub-upl when none exists @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vector_upl_set_subupl was passed a NULL upl element @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vector_upl_set_subupl was passed a NULL upl @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vector_upl_set_subupl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vector_upl_set_pagelist was passed a NULL upl @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vector_upl_set_pagelist"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Vector UPL offset miscalculation @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vector_upl_subupl_byoffset"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "setting sub-upl iostate when none exists @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vector_upl_set_iostate was passed a NULL UPL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vector_upl_set_iostate"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "upl_set_referenced not %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "upl_set_referenced"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "IN Q: %d : %d : %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "AC Q: %d : %d : %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_countdirtypages"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "VM_compressor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_pageout_iothread_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "upl(%p) ext_ref_count @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "upl_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: Unrecognized page list type %hhu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "unified_page_list_iterator_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_pmap.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_batch_set_cache_attributes"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unmarked object on purgeable q @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "marked object not on purgeable q @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_purgeable_object_remove"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_purgeable_accounting(%p): unexpected old_state=%d\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_purgeable_accounting"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected reclaim action %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_deferred_reclamation_reclaim_memory"
        prototype = ""
        caller = "memstat_approaching_fg_band"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_reclaim"
                segment = "__TEXT"
                section = "__cstring"
                caller = "os_log_create"
            }
        }
        symbol = "vm_deferred_reclamation_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_reclaim: About to kill %p due to %d with subcode %lld\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_reclaim: Unable to deliver guard exception because task [%d] is already dead.\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "vm_reclaim: Skipping non fatal guard exception.\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "vm_reclaim: Unable to deliver guard exception because proc is gone & pid rolled over.\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "vm_reclaim: Unable to deliver guard exception because task does not have a proc.\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "vm_reclaim: Unable to deliver guard exception to %p: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "reclaim_kill_with_reason"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "VM_reclaim"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "reclaim_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_page_bg_mode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_page_bg_exclude_external"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_page_bg_target"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_page_bootstrap: WARNING -- strange page hash\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_page_buckets"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_page_bucket_locks"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap_startup"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_page_bootstrap: %d free pages, %d wired pages, (up to %d of which are delayed free)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_page_bootstrap complete"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "colors"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_page_bootstrap"
        prototype = ""
        caller = "vm_mem_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Filling vm_pages with pattern: 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "page_frame_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap_startup(): too many pages to support vm_page packing @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_startup() init/release time: %lld microsec\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "pmap_startup() delayed init/release of %d pages\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "VM_PAGE_PACK_PTR failed on &vm_pages[0] - %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VM_PAGE_PACK_PTR failed on &vm_pages[vm_pages_count-1] - %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_startup"
        prototype = ""
        caller = "vm_page_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm pages"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_page_module_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "vm_page_insert_internal: (page=%p,obj=%p,off=0x%llx,size=0x%llx) inserted at offset past object bounds @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_page_insert_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "panic: kdp_vm_page_lookup done outside of kernel debugger @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kdp_vm_page_lookup"
        prototype = ""
        caller = "kdp_lightweight_fault"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d should not modify cpu->free_pages while hibernating @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_page_grab_options"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: page 0x%llx is referenced @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_page_grab_options"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_page_wire(%p): wire_count overflow @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_page_wire"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_page_reactivate_local: found vm_page_t(%p) with wrong cpuid @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vm_page_reactivate_local: count = %d, vm_page_local_count = %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_page_reactivate_local"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "could"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hibernate_page_list_setall"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "hibernate_lookup_paddr of %d failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "hibernate_free_range"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_page_queues_remove - bad page q_state (%p, %d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_page_queues_remove"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmap_steal_memory() size: 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_steal_memory() pmap_enter failed, map_addr=%#lx, phys_page=%u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_steal_memory_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm pages array"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_free_delayed_pages"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s(num=%d,low=%d): found %d pages at 0x%llx...scanned %d pages...  yielded %d times...  dumped run %d times... stole %d pages... stole %d compressed pages... wired count is %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_page_find_contiguous"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_page_find_contiguous: zone_gc called... wired count is %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "cpm_allocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_page_alloc_list(%zd, 0x%x) failed unexpectedly with %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__vm_page_alloc_list_failed_panic"
        prototype = ""
        caller = "vm_page_alloc_list"
    }
    new {
        args = 0
        anchors {
            new {
                string = "hibernate_consider_discard: private @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "hibernate_consider_discard"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "hibernate_discard_page(%p) laundry @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "hibernate_discard_page(%p) private @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "hibernate_discard_page(%p) fictitious @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "hibernate_discard_page"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region: -> get(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: get(%p) <- %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_get"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: -> vm_map(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: vm_map(%p) <- %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_vm_map"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region: -> set(%p, %p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: set(%p) <- old=%p new=%p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_set"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: -> lookup(root=%p,cpu=<%d,%d>,64bit=%d,pgshift=%d,reslide=%d,driverkit=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "shared_region: vm_shared_region_lastid wrapped @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "shared_region: lookup(root=%p,cpu=<%d,%d>,64bit=%d,pgshift=%d,reslide=%d,driverkit=%d) <- %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "shared_region: -> create(root=%p,cpu=<%d,%d>,64bit=%d,pgshift=%d,reslide=%d,driverkit=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: create: couldn't allocate map\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: create(root=%p,cpu=<%d,%d>,64bit=%d,reslide=%d,driverkit=%d,base=0x%llx,size=0x%llx) <- %p mem=(%p,%p) map=%p pmap=%p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: create(root=%p,cpu=<%d,%d>,64bit=%d,driverkit=%d,base=0x%llx,size=0x%llx) <- NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_lookup"
        prototype = ""
        caller = "vm_shared_region_enter"
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region: -> reference(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: reference(%p) <- %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_reference"
        prototype = ""
        caller = "shared_region_pager_setup"
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region: -> deallocate(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: deallocate(%p): ref now %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: deallocate(%p): armed timer\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: deallocate(%p) <-\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_deallocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region: -> start_address(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: start_address(%p) <- 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_start_address"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s(): shared_region_pager_match() failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): find_mapping_to_slide() failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): doesn't fully cover\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): mach_vm_map_kernel() failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_auth_remap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Failed to undo mappings because of NULL shared region.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "shared_region: mapping[%d]: address:0x%016llx size:0x%016llx offset:0x%016llx maxprot:0x%x prot:0x%x: undoing...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_shared_region_undo_mappings"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: region_slide(slide:0x%x start:0x%016llx size:0x%016llx) failed 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: map(%p) <- 0x%x \n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_map_file"
        prototype = ""
        caller = "_shared_region_map_and_slide"
    }
    new {
        args = 6
        anchors {
            new {
                string = "shared_region: -> enter(map=%p,task=%p,root=%p,cpu=<%d,%d>,64bit=%d,driverkit=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "shared_region: -> enter(map=%p,task=%p,root=%p,cpu=<%d,%d>,64bit=%d,reslide=%d,driverkit=%d): lookup failed !\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "shared_region: enter(%p,%p,%p,%d,%d,%d,%d,%d): nested vm_map_enter(0x%llx,0x%llx,%p) error 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "shared_region: enter(%p,%p,%p,%d,%d,%d,%d,%d) <- 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_shared_region_enter"
        prototype = ""
        caller = "vm_map_exec"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s:%d vm_map(0x%llx, 0x%llx) error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_shared_region_remove"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_shared_region_remove"
        prototype = ""
        caller = "shared_region_check_np"
    }
    new {
        args = 0
        anchors {
            new {
                string = "commpage text: ->init()\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "commpage text: init() <-\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ARM comm page text section %s,%s missing @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "__commpage_text"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_commpage_text_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "commpage: -> init()\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "commpage: init() <-\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_commpage_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 1
        anchors {
            new {
                string = "vm_shared_region_slide: -> slide %#x, entry_start %#llx, entry_size %#llx, slide_start %#llx, slide_size %#llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: no shared region?\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_shared_region_slide"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide: <- %d (no shared region)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "slide_info initialization failed with kr=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_shared_region_slide: <- %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Slide_info_size too small: %lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Slide_info_size too large: %lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "copyin of slide_info failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Too many auth/private sections for shared region!!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "No sliding bitmap entry for pageIndex: %d at entryIndex: %d amongst %d entries\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s bad slide_info_size: %lx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide_sanity_check_v2"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide_sanity_check_v3: s_info->page_size != PAGE_SIZE_FOR_SR_SL 0x%llx != 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide_sanity_check_v3: required_size != slide_info_size 0x%llx != 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide_sanity_check_v4"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide_sanity_check_v5: s_info->page_size != PAGE_SIZE_FOR_SR_SL 0x%llx != 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide_sanity_check_v5: required_size != slide_info_size 0x%llx != 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_shared_region_slide"
        prototype = ""
        caller = "vm_shared_region_map_file"
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: pivot(%p): armed timer\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_shared_region_pivot"
        prototype = ""
        caller = "shared_region_pivot"
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: -> reference_locked(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: reference_locked(%p) <- %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_reference_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: -> destroy(%p) (root=%p,cpu=<%d,%d>,64bit=%d,driverkit=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: destroy(%p) <-\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region: -> map(%p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: more than 1 non-zero slide value amount slide 1:0x%x slide 2:0x%x\n "
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: mapping[0]: address:0x%016llx size:0x%016llx offset/addr:0x%016llx maxprot:0x%x prot:0x%x fd==-1\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): for fd==-1 vm_map_enter() in kernel failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): for fd==-1 copyin() failed, errno=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): for fd==-1 vm_map_enter() in SR failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: mapping[%d]: address:0x%016llx size:0x%016llx offset:0x%016llx maxprot:0x%x prot:0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: mapping[%d]: address:0x%016llx size:0x%016llx offset:0x%016llx maxprot:0x%x prot:0x%x too many mappings to slide...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: mapping[%d]: address:0x%016llx size:0x%016llx offset:0x%016llx maxprot:0x%x prot:0x%x already mapped...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "shared_region: mapping[%d]: address:0x%016llx size:0x%016llx offset:0x%016llx maxprot:0x%x prot:0x%x failed 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vm_shared_region_map_file_setup"
        prototype = ""
        caller = "vm_shared_region_map_file"
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region: sr_cache_header.imagesTextCount >= UINT32_MAX @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vm_shared_region_map_file_final"
        prototype = ""
        caller = "vm_shared_region_map_file"
    }
    new {
        args = 2
        anchors {
            new {
                string = "No slide entry for this page in toc. PageIndex: %d Toc Count: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "No sliding bitmap entry for entryIndex: %d amongst %d entries\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_shared_region_slide() carry over: i=%d j=%d b=0x%x slide=0x%x old=0x%x new=0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_shared_region_slide_page() did not find page start in slide info: pageIndex=%u, count=%u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_shared_region_slide_page() out-of-bounds extras index: index=%u, count=%u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_shared_region_slide_page"
        prototype = ""
        caller = "shared_region_pager_data_request"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_shared_region_slide_page() offset overflow: pageIndex=%u, start_offset=%u, slide_amount=%u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "rebase_chain"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region_find_key() no key for region '%s' @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "shared_region_find_key"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region_key_alloc() inherited key mismatch @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "shared_region_key_alloc"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region_key_dealloc() Shared region ID '%s' not found @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "shared_region_key_dealloc"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "shared_region_pager_init: memory_object_change_attributes() failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "shared_region_pager_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region_pager_data_return: should never get called @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZN31IOAppleConvergedIPCRTIInterface21createRingSourceGatedE25AppleConvergedIPCRingTypejP18IOACIPCRingOptionsPP23IOAppleConvergedIPCRing.cold.1"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region_pager_data_initialize: should never get called @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "msgctl.cold.1"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "shared_region_pager_data_request: vm_fault_page() unexpected error 0x%x\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "shared_region_data_request(%p,0x%llx+0x%llx+0x%04llx): 0x%llx in sliding range [0x%llx:0x%llx]: SLIDE offset 0x%llx=(0x%llx+0x%llx+0x%llx+0x%04llx)[0x%016llx 0x%016llx] code_signed=%d cs_validated=%d cs_tainted=%d cs_nx=%d kr=0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "shared_region_pager_data_request"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s no object for file_control\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vm_map_with_linking"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_with_linking"
        prototype = ""
        caller = "map_with_linking_np"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s(): control NULL\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "dyld_pager_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dyld_pager_init: memory_object_change_attributes() failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dyld_pager_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dyld_pager_data_return: should never happen! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "compressor_memory_object_init.cold.1"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dyld_pager_data_initialize: should never happen @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_open_auth.cold.6"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dyld_pager_data_request: vm_fault_page() unexpected error 0x%x\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s(): Range not found for offset 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dyld_pager_data_request"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(): seg_info out of bounds\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): seg->size out of bounds\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(): seg->size too small\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(): seg->page_count out of bounds\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(): seg->page_count too small\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s(): No segment for user VA 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(): unknown pointer_format %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s(): out of range segInfo->page_start[overflowIndex]"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "fixupPage32"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dyld_pager_data_request"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s(): Invalid ptr auth key %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "signPointer"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "signPointer"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s out of range bind ordinal %u (max %u)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "fixupPage64"
        prototype = ""
        caller = "dyld_pager_data_request"
    }
    new {
        args = 1
        anchors {
            new {
                string = "swapfile_pager_init: memory_object_change_attributes() failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "swapfile_pager_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "swapfile_pager_data_return: should never get called @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sysctl_register_oid.cold.2"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "swapfile_pager_data_initialize: should never get called @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZN30AppleBCMWLANPCIeCompletionRing6commitEv"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "upl_abort_range: kernel_object being DUMPED @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "upl_abort_range"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "wire_count == 0, m = %p, obj = %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "upl_commit_range"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vm_allocate failed - %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kext_alloc"
        prototype = ""
        caller = "__ZN6OSKext25initWithPrelinkedInfoDictEP12OSDictionaryb7kc_kind"
    }
    new {
        args = 0
        anchors {
            new {
                string = "__RECEIPT_INFO"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__aux_kc_receipt"
                segment = "__TEXT"
                section = "__cstring"
                caller = "getsectbynamefromheader"
            }
        }
        symbol = "kext_receipt"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s is not supported on this kernel architecture (called from %s)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kmod_get_info"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kmod_get_info"
        prototype = ""
        caller = "_Xkmod_get_info"
    }
    new {
        args = 0
        anchors {
            new {
                string = "__memmove_chk object size check failed: dst %p, src %p, (%zu < %zu) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__memmove_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "__memset_chk object size check failed: dst %p, c %c, (%zu < %zu) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__memset_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "__strlcat_chk object size check failed: dst %p, src %p, (%zu < %zu) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__strlcat_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "__strlcpy_chk object size check failed: dst %p, src %p, (%zu < %zu) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__strlcpy_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "__strncpy_chk object size check failed: dst %p, src %p, (%zu < %zu) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__strncpy_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "__strncat_chk object size check failed: dst %p, src %p, (%zu < %zu + %zu + 1) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__strncat_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "__strcpy_chk object size check failed: dst %p, src %p, (%zu < %zu + 1) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__strcpy_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "__strcat_chk object size check failed: dst %p, src %p, (%zu < %zu + %zu + 1) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__strcat_chk"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kperf: unable to parse '%s' as action sampler\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "kperf: missing timer period in config\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "kperf: unable to parse '%s' as timer period\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "kperf: cannot enable sampling at boot: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kperf_kernel_configure"
        prototype = ""
        caller = "kperf_init_early"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kperf: pending AST to non-current thread @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "action.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kperf_ast_pend"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "HUH @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "callstack.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kperf_ucallstack_pend"
        prototype = ""
        caller = "kperf_sample"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kperf: failed to create PET thread %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pet.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kperf-pet-sampling"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "kppet_config"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kperf: timer fired at %llu, but sampling is disabled @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kperf: unknown sampling state 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kptimer_expire"
        prototype = ""
        caller = "kperf_timer_expire"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kptimer"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kptimer_set_count"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kpc_percpu_alloc failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kpc_common.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kpc_register_cpu"
        prototype = ""
        caller = "ml_processor_register"
    }
    new {
        args = 0
        anchors {
            new {
                string = "setting period %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "kpc_set_period"
        prototype = ""
        caller = "sysctl_kpc_set_period"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kpc: pm released counters\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kpc_release_pm_counters"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Serial keyboard started\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "serial_keyboard_init @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "serial_keyboard_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "serial_keyboard_poll: Shouldn't never ever get here... @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "serial_keyboard_poll"
        prototype = ""
        caller = "serial_keyboard_start"
    }
    new {
        args = 1
        anchors {
            new {
                string = "switch_to_old_console: unknown ops %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "kPEDisableScreen %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "kPEEnableScreen %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "PE_initialize_console"
        prototype = ""
        caller = "__ZN16IOPlatformExpert14setConsoleInfoEP8PE_Videoj"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Automatic NMI"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_serial_getc_0"
        prototype = ""
        caller = "serial_keyboard_poll"
    }
    new {
        args = 0
        anchors {
            new {
                string = "initialize_screen: b=%08llX, w=%08X, h=%08X, r=%08X, d=%08X\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "initialize_screen: No video - forcing serial mode\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "initialize_screen"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "meter"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vcattach"
        prototype = ""
        caller = "PE_init_iokit"
    }
    new {
        args = 0
        anchors {
            new {
                string = "telemetry_buffer_size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Telemetry: Allocation failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "telemetry_notification_leeway"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "telemetry: nonsensical telemetry_notification_leeway boot-arg %d changed to %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "telemetry_sample_rate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "telemetry_sample_all_tasks"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Telemetry: Sampling %stasks once per %u second%s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "telemetry_init_0"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 2
        anchors {
            new {
                string = "telemetry: disabling ustackshot on PMI\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "instructions"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cycles"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "telemetry: ustackshot every %llu %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "telemetry_pmi_setup"
        prototype = ""
        caller = "telemetry"
    }
    new {
        args = 0
        anchors {
            new {
                string = "bootprofile_buffer_size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bootprofile_interval_ms"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bootprofile_stackshot_flags"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bootprofile_proc_name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bootprofile_type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Boot profile: Allocation failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "Boot profile: Sampling %s once per %u ms at %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "all procs"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bootprofile_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Telemetry (MACF): Allocation failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "telemetry_macf_init_locked"
        prototype = ""
        caller = "telemetry_macf_mark_curthread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "cc_abort.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "cc_abort"
        prototype = ""
        caller = "cc_try_abort"
    }
    new {
        args = 0
        anchors {
            new {
                string = "random_cpu_init: kernel prng has not been installed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ml_processor_register"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%d]%s>pset_create(cluster_id=%d) returned pset %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "[%d]%s>cpu_id %p cluster_id %d cpu_number %d is type %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "ml_processor_register"
        prototype = ""
        caller = "__ZL15cpu_boot_threadPvi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ccdrbg_init() returned %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Early boot random cchkdf_expand %s failed with err %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Expected %u seed bytes from bootloader, but got %u. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bootseed_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "prngseed_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "entropy_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "early_random_init"
        prototype = ""
        caller = "early_random"
    }
    new {
        args = 0
        anchors {
            new {
                string = "read_erandom ccdrbg error %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "read_erandom_generate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "entropy-data"
                segment = "__TEXT"
                section = "__cstring"
                caller = "lck_grp_init_flags"
            }
        }
        symbol = "entropy_init"
        prototype = ""
        caller = "register_and_init_prng"
    }
    new {
        args = 1
        anchors {
            new {
                string = "apple_protect_pager_init: memory_object_change_attributes() failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "apple_protect_pager_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "apple_protect_pager_data_return: should never get called @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZN21AppleGPIOICController5startEP9IOService.cold.9"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "apple_protect_pager_data_initialize: should never get called @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__Z18IOPCIRangeOptimizeP10IOPCIRange.cold.1_0"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "apple_protect_pager_data_request: vm_fault_page() unexpected error 0x%x\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "apple_protect_data_request(%p,0x%llx+0x%llx+0x%04llx): out of crypto range [0x%llx:0x%llx]: COPY [0x%016llx 0x%016llx] code_signed=%d cs_validated=%d cs_tainted=%d cs_nx=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "apple_protect_data_request(%p,0x%llx+0x%llx+0x%04llx): in crypto range [0x%llx:0x%llx]: DECRYPT offset 0x%llx=(0x%llx-0x%llx+0x%llx+0x%llx+0x%04llx)[0x%016llx 0x%016llx] code_signed=%d cs_validated=%d cs_tainted=%d cs_nx=%d ret=0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "apple_protect_pager_data_request"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed pmap_enter, virt=%p, start_addr=%p, end_addr=%p, prot=%#x, flags=%#x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap_map"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_map"
        prototype = ""
        caller = "io_map"
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmap_map_bd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_map_bd_with_options"
        prototype = ""
        caller = "io_map"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: area too large, pa_start=%p, len=%p, prot=0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: insufficient pages, pa_start=%p, len=%p, prot=0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_map_high_window_bd"
        prototype = ""
        caller = "PE_consistent_debug_inherit"
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmap_asid_plru"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "arm_maxoffset"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap_panic_dev_wimg_on_managed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap-max-asids"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap-max-asids property is not a 32-bit integer @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap-max-asids 0x%x too large @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap-max-asids cannot be zero @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_bootstrap"
        prototype = ""
        caller = "arm_vm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Panic occurred while attempting to lock PAI %u (%p):\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "PAI is of type PVH_TYPE_NULL.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "PAI is of type PVH_TYPE_PTDP.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "PAI contains an IOMMU mapping, but the IOMMU state is invalid\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "<No Driver Supplied Name>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "PTEP (%p) is an IOMMU mapping (state: %p) mapped by %s (on behalf of %s)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Kernel"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "PTEP (%p) is a %s CPU mapping (pmap: %p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\nTotal number of PTEPs: %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
        }
        symbol = "pmap_panic_inspect_pai"
        prototype = ""
        caller = "SavePanicInfo"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: Passed in pmap doesn't own the page table to be deleted ptd=%p ptd->pmap=%p pmap=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_tte_deallocate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_tte_deallocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmap_set_ptov_ap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_set_ptov_ap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmap_protect_options() pmap %p start 0x%llx end 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_protect_options"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed pmap_enter_addr, pmap=%p, va=%#llx, pa=%llu, size=%u, prot=%#x, flags=%#x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap_map_block_addr"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_map_block_addr"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed with return code %d; pmap: 0x%016llx, v: 0x%016llx, wired: %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmap_change_wiring"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_change_wiring"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: failed to make forward progress from 0x%llx to 0x%llx at 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_nest"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_nest"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed to insert the shared page, kr=%d, pmap=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_insert_commpage"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_insert_commpage"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s(%p): attempt to pin static mapping for page 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s(%p): physical page 0x%llx belongs to PPL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s(%p): VA no longer mapped to physical page 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_pin_kernel_pages"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s(%p): physical page 0x%llx not pinned @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_unpin_kernel_pages"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: addr 0x%016llx doesn't have a valid kernel mapping @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: I/O filter entry found at 0x%016llx for %llu-byte wide register at va: 0x%016llx and pa: 0x%016llx, but I/O filter refused to write it. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: width %llu not supported @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_iofilter_protected_write"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "initialized PPL provisioning profile data\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_initialize_provisioning_profiles"
        prototype = ""
        caller = "csm_initialize_provisioning_profiles"
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: underflow on the max_profile_blob_size: %lu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: overflow on the profile_blob_size: %lu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: profile does not validate through CoreTrust: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: profile does not have any content: %p | %lu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: unable to create a CoreEntitlements context for the profile @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: fatal error while setting up profile entitlements: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: Anomaly, profile already exists in the tree: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_register_provisioning_profile_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: unregistering an unknown profile: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_unregister_provisioning_profile_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: associating an unknown profile: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: attempted association with unverified profile: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: overflow on reference count for profile: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_associate_provisioning_profile_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "PMAP_CS: attempted to associate NULL kernel entitlements: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_associate_kernel_entitlements_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmap_resolve_kernel_entitlements_internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = "validate_user_pmap"
            }
        }
        symbol = "pmap_resolve_kernel_entitlements_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: unable to gauge index size for entitlements acceleration: %p | %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: unable to accelerate entitlements: %p | %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: entitlements not marked as accelerated: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_accelerate_entitlements_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS [CoreEntitlements]: encountered an unrecoverable error @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "kernel_mach_msg_rpc.cold.3"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: CoreEntitlements allocating index without buffer @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: CoreEntitlements allocating index with mismatched size: %lu | %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_cs_alloc_index"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "PMAP_CS: magic number mismatch on acceleration buffer: %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_cs_free_index"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pai %d already locked down @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_static_allocations_done"
        prototype = ""
        caller = "arm_vm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: L%d TTE is already empty. Potential double unmap or memory stomper? pmap=%p ttep=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Found inconsistent state in soon to be deleted L%d table: %d valid, %d compressed, %d non-empty, refcnt=%d, L%d tte=%#llx, pmap=%p, bpte=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_tte_remove"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmap_tt_deallocate(): ptdp %p, count %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_tt_deallocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: no ptep? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_update_tt3e"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_update_tt3e"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "PMAP_CS: PNX bit not set for PTE: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "validate_debug_pte"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "PMAP_CS: cannot query for entitlements as pmap_cs is disabled @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: attempted to query kernel_pmap for entitlements @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "check_entitlement_pmap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "check_entitlement_pmap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: compilation service binary signed as a main binary @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "code_signature_validate_constraints"
        prototype = ""
        caller = "code_signature_validate"
    }
    new {
        args = 0
        anchors {
            new {
                string = "LOCALSPKEY"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_strcmp"
            }
            new {
                string = "PMAP_CS: failed to validate serialized local signing entitlements constraint: %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: failed acquiring unmanaged context for local signing entitlements: %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "validate_constraints_local_signing"
        prototype = ""
        caller = "code_signature_validate_constraints"
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: AppleInternalProfile field not a boolean type in provisioning profile @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "validate_constraints_profile_preflight"
        prototype = ""
        caller = "code_signature_validate_constraints"
    }
    new {
        args = 0
        anchors {
            new {
                string = "PMAP_CS: passed in a NULL address @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: address not within kernel memory: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: length causes an address overflow: %p + %lu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: address end not within kernel memory: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: address range spans through the read-only zone: %p through %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PMAP_CS: zero length data not allowed for: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_cs_assert_addr"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "free blob to add unaligned: (%p,%p)/%zu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "blob free count overflow (bin %d, %d/%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "blob page count overflow (bin %d, %d/%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_cs_blob_add_to_free_list"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: physical address is 0 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_alloc_page_for_kern"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_alloc_page_for_kern"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "%s: PVH entry at pai %d is locked down (%#lx), cannot remove @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ptep=%p does not match pvh=%p (%p), pai=0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ptep=%p (pai=0x%x) not in pvh=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: unexpected PV head %p, ptep=%p pmap=%p pvh=%p pai=0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_remove_pv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: %u addr 0x%llx is not page-aligned @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: %u length 0x%llx is not page-aligned @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: %u addr 0x%llx length 0x%llx wraps around @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: %u addr 0x%llx length 0x%llx overlaps physical memory @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "pmap_compute_io_rgns"
        prototype = ""
        caller = "pmap_data_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: io filter entry %u offset 0x%hx length 0x%hx crosses page boundary @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_compute_io_filters"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_compute_io_filters"
        prototype = ""
        caller = "pmap_data_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: io filter entry %u and %u overlap. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_load_io_filters"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pmap_load_io_filters"
        prototype = ""
        caller = "pmap_data_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: pmap array index %lu >= limit %lu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: pmap %p does not match array element %p at index %lu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: pmap %p is not in use @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "validate_user_pmap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed, no pages available? kr=%d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pmap_ppl_interface.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mapping_free_prime"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Returned from exception_triage()? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Trap with %d words of args? We only support 9. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mach_syscall"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 0
        anchors {
            new {
                string = "CTRR (MMU) Begin: %p End: %p, setting lockdown\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "rorgn_lockdown"
        prototype = ""
        caller = "machine_lockdown"
    }
    new {
        args = 0
        anchors {
            new {
                string = "/chosen/lock-regs"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "lock-regs: /chosen/lock-regs not found (your iBoot or EDT may be too old) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "amcc-ctrr-a"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ioa-ctrr-a"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "amcc_find_lock_group_data"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "map aperture_phys_addr[%u]/%#x failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Inconsistent memory config @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "rorgn_stash_range"
        prototype = ""
        caller = "machine_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "lock-regs: /chosen/lock-regs/%s not found @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "aperture-count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s %u exceeds maximum %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "aperture-size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: have %u apertures, but 0 size @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "plane-count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "plane-stride"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: plane-count (%u) > 1, but stride is 0/missing @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: aperture-size (%#x) is insufficent to cover plane-count (%#x) of plane-stride (%#x) bytes @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "aperture-phys-addr"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: missing required %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: aperture-phys-addr size (%#x) != (aperture-count (%#x) * PA size (%#zx) = %#lx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cache-status"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "master-lock"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_dt_get_lock_group"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s-reg-offset"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: missing property '%s' @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s-reg-mask"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s-reg-value"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_dt_get_lock_reg"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "lock-regs: /chosen/lock-regs/%s/%s not found @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "page-size-shift"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "lower-limit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "upper-limit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "write-disable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_dt_get_lock_type"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unknown CPU subtype... @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cpu_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "cpu_start() cpu: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "cpu_start"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "can't shutdown: PE_halt_restart returned %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ml_arm_sleep"
        prototype = ""
        caller = "PE_cpu_machine_quiesce"
    }
    new {
        args = 0
        anchors {
            new {
                string = "effective-production-status-ap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "cpu_machine_idle_init"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "cpu_control(%d,%p,%d) not implemented\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "_Xprocessor_control"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "CPU%d failed to shut down @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "CPU %d failed to reach ARM_CPU_ON_SLEEP_PATH: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cpu_exit_wait"
        prototype = ""
        caller = "processor_doshutdown"
    }
    new {
        args = 0
        anchors {
            new {
                string = "cpu_xcall_internal: invalid cpu_number %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "cpu_xcall_internal: cannot have null func/param: %p %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "cpu_xcall_internal: cpu %d not initialized @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cpu_xcall_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "CPU%u has failed to respond to cross-call after %llu nanoseconds (timeout = %llu ns) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "cpu_signal of self while signals are disabled @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cpu_signal_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = " vm_cache_geometry_colors: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "%s() - %u bytes %s cache (I:%u D:%u (%s)), %u-way assoc, %u bytes/line\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "do_cacheid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unified"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "separate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "do_cacheid"
        prototype = ""
        caller = "cpu_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "user_ts_jop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "diversify_user_jop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kernel_startup_bootstrap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "maxmem"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpret"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "immediate_NMI"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Unable to find 'chosen' DT node @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "dram-base"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Unable to find 'dram-base' entry in the 'chosen' DT node @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "dram-size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Unable to find 'dram-size' entry in the 'chosen' DT node @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "kprintf initialized\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "Serial mode specified: %08X\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "drain_uart_sync"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "WARNING: Forcing uart driver to output synchronously.printf()s/IOLogs will impact kernel performance.\nYou are advised to avoid using 'drain_uart_sync' boot-arg.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "WARNING: invalid serial boot-args : ON_DEMAND (0x%x) flag requires INPUT(0x%x). Ignoring ON_DEMAND.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "The cpumask=N boot arg cannot be used together with cpus=N, and the boot CPU must be enabled @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "aprr_jit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "icdsb"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "arm_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unexpected preemption count %u on boot cpu thread (should be %u) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "arm_cpu_init(): cpu %d online\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
        }
        symbol = "arm_init_cpu"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "phystokv_range"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "phystokv_range"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: illegal VA: %p; virt base 0x%llx, size 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ml_static_vtop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ml_static_vtop"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected /chosen/memory-map/TrustCache property size %u != %zu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unexpected location of TrustCache region: %#lx != %#lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "TrustCache region is in an unexpected place: %#lx > %#lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "EXTRADATA is in an unexpected place: %#lx > %#lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "AuxKC"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AuxKC-mach_header"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "auxkc_base (%p) not below segLOWEST (%p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "arm_vm_prot_init"
        prototype = ""
        caller = "arm_vm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unsupported memory configuration %lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "__PPLTEXT"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__PPLTRAMP"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__PPLDATA_CONST"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__PPLDATA"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__LAST"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__LASTDATA_CONST"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__hib_text"
                segment = "__TEXT"
                section = "__cstring"
                caller = "getsectbynamefromheader"
            }
            new {
                string = "__hib_const"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__HIBDATA"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "use_contiguous_hint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "segLOWESTAuxKC (%p) not equal to segLOWEST (%p). auxkc_mh: %p, auxkc_base: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "arm_vm_init"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: PTOV table limit exceeded; segment va = 0x%llx, size = 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "arm_vm_physmap_slide"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "arm_vm_physmap_slide"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: cpte=%#llx is not empty, vaddr=%#lx, pte=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "arm_vm_map"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "arm_vm_map"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ml_probe_read() unimplemented @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZL31IOShutdownNotificationsTimedOutPvS__0"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Not yet implemented. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "__ZN30AppleT8101PlatformErrorHandler16_handleDCSErrorsEv.cold.1"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s address error: passed in address (%#llx) not a kernel managed address @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s alignment error: tried accessing addresses spanning more than one page %#llx %#lx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "apply_func_phys"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ml_phys_read_data"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Invalid size %d for ml_phys_read_data @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Read from physical addr 0x%llx took %llu ns, result: 0x%016llx%016llx (start: %llu, end: %llu), ceiling: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ml_phys_read_data"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ml_phys_write_data"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Invalid size %d for ml_phys_write_data @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Write from physical addr 0x%llx took %llu ns, data: 0x%016llx%016llx (start: %llu, end: %llu), ceiling: %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ml_phys_write_data"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid spinlock %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Lock not owned %p = %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Lock not owned by current thread %p = %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Lock owned by current thread %p = %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "lck_spin_assert(): invalid arg (%u) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "lck_spin_assert"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s at pc 0x%016llx, lr 0x%016llx (saved state: %p%s)\n\t  x0:  0x%016llx x1:  0x%016llx  x2:  0x%016llx  x3:  0x%016llx\n\t  x4:  0x%016llx x5:  0x%016llx  x6:  0x%016llx  x7:  0x%016llx\n\t  x8:  0x%016llx x9:  0x%016llx  x10: 0x%016llx  x11: 0x%016llx\n\t  x12: 0x%016llx x13: 0x%016llx  x14: 0x%016llx  x15: 0x%016llx\n\t  x16: 0x%016llx x17: 0x%016llx  x18: 0x%016llx  x19: 0x%016llx\n\t  x20: 0x%016llx x21: 0x%016llx  x22: 0x%016llx  x23: 0x%016llx\n\t  x24: 0x%016llx x25: 0x%016llx  x26: 0x%016llx  x27: 0x%016llx\n\t  x28: 0x%016llx fp:  0x%016llx  lr:  0x%016llx  sp:  0x%016llx\n\t  pc:  0x%016llx cpsr: 0x%08x         esr: 0x%016llx  far: 0x%016llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " INVALID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "panic_with_thread_kernel_state"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Unexpected debugger trap while SP1 selected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Synchronous exception taken while SP1 selected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sleh_synchronous_sp1"
        prototype = ""
        caller = "fleh_synchronous_sp1"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Exception on 2-byte instruction, context=%p, esr=%#llx, far=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Exception on 2-byte instruction"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Invalid SVC_64 context @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Kernel instruction fetch abort"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unsupported Class %u event code. state=%p class=%u esr=%llu far=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Hardware Breakpoint Debug exception from kernel. Panic (by design)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Software Step Debug exception from kernel. Panic (by design)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Illegal instruction set exception. state=%p class=%u esr=%llu far=%p spsr=0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unexpected jitbox fault in the kernel, state=%p, esr=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "UC access exception from kernel, state=%p, esr=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unrecognized private exception, state=%p, esr=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "AMX exception from kernel, state=%p, esr=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unrecognized AMX exception, state=%p, esr=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "MSR/MRS trap (ESR 0x%llx) from 32-bit state @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "MSR/MRS trap (ESR 0x%llx) from kernel @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sleh_synchronous"
        prototype = ""
        caller = "_fleh_synchronous"
    }
    new {
        args = 0
        anchors {
            new {
                string = "attempt to set invalid recovery handler %p on kernel saved-state %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "panic_on_invalid_recovery_handler"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Invalid kernel stack pointer (probable overflow)."
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_with_thread_kernel_state"
            }
            new {
                string = "Invalid kernel stack pointer (probable corruption)."
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_with_thread_kernel_state"
            }
        }
        symbol = "sleh_invalid_stack"
        prototype = ""
        caller = "fleh_invalid_stack"
    }
    new {
        args = 3
        anchors {
            new {
                string = "Unexpected host abort from guest context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sleh_guest_synchronous"
        prototype = ""
        caller = "_fleh_guest_synchronous"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Undefined kernel instruction: pc=%p instr=%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_uncategorized"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Break 0x%04X instruction exception from kernel. Ptrauth failure with %s key resulted in 0x%016llx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "0x%016llx"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_strlen"
            }
            new {
                string = "0xFFFFFFFFFFFFFFFF"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_strlen"
            }
        }
        symbol = "ptrauth_handle_brk_trap"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "panic: corrupt list around element %p"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "panic: string operation caused an overflow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "xnu_hard_trap_handle_breakpoint"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "PC alignment exception from kernel."
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_with_thread_kernel_state"
            }
        }
        symbol = "handle_pc_align"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 1
        anchors {
            new {
                string = "SP alignment exception from kernel."
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_with_thread_kernel_state"
            }
        }
        symbol = "handle_sp_align"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Floating point exception from kernel"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unrecognized floating point exception, state=%p, esr=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_fp_trap"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 1
        anchors {
            new {
                string = "SW_STEP_DEBUG exception from kernel."
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_with_thread_kernel_state"
            }
            new {
                string = "SW_STEP_DEBUG exception thread DebugData is NULL."
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic_with_thread_kernel_state"
            }
        }
        symbol = "handle_sw_step_debug"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 1
        anchors {
            new {
                string = "User abort from non-interruptible context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vm_fault() KERN_FAILURE from user fault on thread %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_user_abort"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected residue @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unexpected atomic LDST size %llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unexpected SWP encoding, opc=%llu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_alignment_fault_from_user"
        prototype = ""
        caller = "handle_user_abort"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Unexpected page fault under dtrace_probe"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unexpected fault in kernel static region\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unaligned kernel data abort."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unclassified kernel abort (fault_code=0x%x)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "Kernel data abort."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "handle_kernel_abort"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 0
        anchors {
            new {
                string = "PAC failure (ESR 0x%llx) from 32-bit state @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "PAC failure from kernel with %s key while authing %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "PAC failure from kernel with %s key while returning"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "PAC failure from kernel with %s key"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "handle_pac_fail"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ESR (0x%llx) for instruction trapped from U32, but saved state is 64-bit. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ESR (0x%llx) for instruction trapped from U32, actually came from kernel? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_user_trapped_instruction32"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ESR (0x%llx) for SIMD trap from userland, actually came from kernel? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_simd_trap"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 2
        anchors {
            new {
                string = "vm_fault() KERN_FAILURE from guest fault on state %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_guest_abort"
        prototype = ""
        caller = "sleh_guest_synchronous"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unrecognized guest trap exception, state=%p, esr=%#llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "handle_guest_trap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: Invalid required state size %lu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "sched_perfcontrol_register_callbacks"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sched_perfcontrol_register_callbacks"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "siq_realtime_thread_mode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Invalid siq_realtime_thread_mode %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "siq_init"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalidate HMAC function already set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "set_invalidate_hmac_function"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalidate HMAC function wasn't set when needed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "machine_lockdown"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "certificate-production-status"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "spr_lockdown"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "slto_us"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tlto_us"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mtxspin"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "max_wfe_us"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ml_init_lock_timeout"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ml_cpu_down: cpu_signal of cpu %d failure %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "boot cpu powering down with nowhere for its timers to go @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ml_cpu_down"
        prototype = ""
        caller = "processor_offline"
    }
    new {
        args = 0
        anchors {
            new {
                string = "MACH Reboot\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CPU halted\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "halt_all_cpus"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "cpumask"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "die-cluster-id"
                segment = "__TEXT"
                section = "__cstring"
                caller = "ml_readprop"
            }
            new {
                string = "cluster-core-id"
                segment = "__TEXT"
                section = "__cstring"
                caller = "ml_readprop"
            }
            new {
                string = "unable to retrieve state for cpu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Wrong property size for %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "chip-revision"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "enable_skstb"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "enable_skstsct"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cluster_power"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ml_parse_cpu_topology"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "ml_static_protect(): %p < %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ml_static_protect(): WX request on %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ml_static_protect(): attempt to inject executable mapping on %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ml_static_protect"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Failed ml_static_mfree on %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ml_static_mfree"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "wfe_events_sec"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "wfe_timeout_configure"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid CPSR in user saved-state %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ml_panic_on_invalid_old_cpsr"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "attempt to set non-user CPSR %#010x on user saved-state %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ml_panic_on_invalid_new_cpsr"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Missing mandatory property '%s' @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ml_readprop"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.custom-x18-abi"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "machine_task_process_signature"
        prototype = ""
        caller = "process_signature"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unknown AMX feature ID bit has been set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "AMXIDR_EL1 doesn't advertise any known version of AMX @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "configure_misc_apple_regs"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Preemption count underflow @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "preemption_disable.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_enable_preemption_underflow"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Warning: clock is locked.  Can't get time\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mach_absolute_time: 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Epoch Time:        sec       usec\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Boot    : 0x%08x 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Sleep   : 0x%08x 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Wake    : 0x%08x 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "  Calendar: 0x%08x 0x%08x\n\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
        }
        symbol = "panic_display_times"
        prototype = ""
        caller = "SavePanicInfo"
    }
    new {
        args = 0
        anchors {
            new {
                string = "cpu_signal failed in DebuggerXCallEnter\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s>found CPU %d offline, debugger_sync=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "%s>Debugger synch pending on cpu %d\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Attempting to forcibly halt cpu %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cpu %d failed to halt with error %d: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "cpu %d halted with warning %d: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unable to obtain state for cpu %d with status %d: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cpu %d successfully halted\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Immediate halt requested on all cores\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "paniclog_append_noflush"
            }
            new {
                string = "Debugger synchronization timed out; timeout %llu nanoseconds\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "DebuggerXCallEnter"
        prototype = ""
        caller = "handle_debugger_trap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Resuming from debugger synchronization failed: waited %llu nanoseconds\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "DebuggerXCallReturn"
        prototype = ""
        caller = "handle_debugger_trap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s>found_mp_kdp_trap=true found_SIGPdebug=%s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "wait_while_mp_kdp_trap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "wait_while_mp_kdp_trap"
        prototype = ""
        caller = "processor_cpu_reinit"
    }
    new {
        args = 2
        anchors {
            new {
                string = "context switch with PAN disabled @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "machine_switch_context @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "machine_switch_context"
        prototype = ""
        caller = "thread_invoke"
    }
    new {
        args = 0
        anchors {
            new {
                string = "thread %p already has AMX saved state %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "machine_thread_amx_state_alloc"
        prototype = ""
        caller = "sleh_synchronous"
    }
    new {
        args = 2
        anchors {
            new {
                string = "stack handoff with PAN disabled @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "machine_stack_handoff"
        prototype = ""
        caller = "stack_handoff"
    }
    new {
        args = 0
        anchors {
            new {
                string = "arm_debug_set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "arm_debug_set"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rtclock timebase_callback: invalid constant %ld / %ld @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rtclock.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "timebase_callback"
        prototype = ""
        caller = "arm_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "kdp panic: %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kdp_panic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: should not have been invoked. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "_was_in_userspace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kdp_machdep.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_was_in_userspace"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "hib bank[%d]: 0x%llx (%d) end 0x%llx (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hibernate_page_list_allocate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "monotonic: invalid core counter read: %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mt_core_snap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mach_bridge_recv_timestamps"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mach_bridge_recv_timestamps"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mach_bridge_set_params"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mach_bridge_set_params"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sart %p: Invalid config for region %d size 0 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sart_set_registers"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "UAT PPL: Failed to acquire %p's lock because it has already been acquired by another thread. The IOUAT mutex should have prevented this scenario. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "uat_lock"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "UAT PPL %p (%s): ttbr_index <--> state_object mismatch: vaddr(%#llx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "UAT PPL %p (%s): address not page-aligned: vaddr(%#llx) PAGE_SIZE(%#llx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "UAT PPL %p (%s): size not a multiple of PAGE_SIZE: vaddr(%#llx) size(%#llx) PAGE_SIZE(%#llx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "UAT PPL %p (%s): region wraps round: vaddr(%#llx) size(%#llx) last_vaddr(%#llx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "UAT PPL %p (%s): region not wholly within permitted inclusive range: vaddr(%#llx) min_vaddr(%#llx) size(%#llx) last_vaddr(%#llx) max_vaddr(%#llx) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "uat_validate_vaddr"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "hmac-reg-base"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: hmac register base is zero @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_get_reg_base"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pmgr-reg-base"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: pmgr register base is zero @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_get_aes_reg_base"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "secure_hmac_get_aes_offset"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pmgr-aes-offset"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "secure_hmac_get_aes_offset"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed to initialize PPL state object: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "secure_hmac_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "secure_hmac_init"
        prototype = ""
        caller = "machine_lockdown"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: pmap_iommu_map failed: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "secure_hmac_hibernate_begin"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "secure_hmac_hibernate_begin"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: Only non-wired memory should be getting hashed during hibernation restore @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_reset"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: output_len should be %d but is %zu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_FINAL failed: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_final"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_FETCH_HIBSEG failed: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_FETCH_HIBSEG_INFO failed: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_fetch_hibseg_and_info"
        prototype = ""
        caller = "hibernate_write_image"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_COMPUTE_RORGN_HMAC failed: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "secure_hmac_compute_rorgn_hmac"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "secure_hmac_compute_rorgn_hmac"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_FETCH_RORGN_SHA failed: 0x%x\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_fetch_rorgn_sha"
        prototype = ""
        caller = "hibernate_write_image"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_FETCH_RORGN_HMAC failed: 0x%x\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_fetch_rorgn_hmac"
        prototype = ""
        caller = "hibernate_write_image"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: hmac_len should be %d but is %zu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_FINALIZE_IMAGE failed: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "secure_hmac_finalize_image"
        prototype = ""
        caller = "hibernate_write_image"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: PPL ioctl PPL_HIB_IOCTL_GET_IO_RANGES failed: 0x%x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "secure_hmac_get_io_ranges"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "secure_hmac_get_io_ranges"
        prototype = ""
        caller = "hibernate_page_list_allocate"
    }
    new {
        args = 0
        anchors {
            new {
                string = "apple-isa-vm-quota"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "hv_apple_isa_vm_quota"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "hv_vm"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "hv_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "3B878185-AA62-4E1F-9DC9-D6799CBB6EBB"
                segment = "__TEXT"
                section = "__cstring"
                caller = "uuid_parse"
            }
        }
        symbol = "hv_trap_vcpu_run"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected failure to free VA space we just allocated: %d! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mmap_jitbox_region"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "LLC_ERR_STS/ADR/INF=%#llx/%#llx/%#llx LSU_ERR_STS=%#llx FED_ERR_STS=%#llx MMU_ERR_STS=%#llx DPC_ERR_STS=%#llx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LLC dup tag multi-hit error by CPU %d: FAR=%#lx way_mask=%#x err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "way predictor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LLC %s multi-hit error: FAR=%#lx way_mask=%#x err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "L2 RAM addr out of range"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LLC %s error: FAR=%#lx err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unhandled %c-core error: %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s err (%s) %son %c-core: FAR=%#llx %s_ERR_STS=%#llx err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (UNKNOWN)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Normal completion)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Decode error)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Slave error)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Bus error)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Non-recoverable Uncorrected)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (AMX Uncorrected)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Recoverable Uncorrected)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Unavailable)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " (Reserved)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cpu%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cpu%d: LLC %s error%s from %s: FAR=%#lx addr=%#llx cmd=%#x(%s) err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "single-bit ECC counter overflow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "single-bit ECC"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LLC %s error: FAR=%#lx way=%#x syndrome=%#x err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "double-bit cache ECC overflow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "double-bit cache ECC"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LLC %s error: FAR=%#lx way=0x%x syndrome=%#x cmd=%#x(%s) err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Uncontained LLC AMX %s error: FAR=%#lx way=0x%x syndrome=%#x cmd=%#x(%s) err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unhandled recoverable LLC %s error: FAR=%#lx way=0x%x syndrome=%#x cmd=%#x(%s) err_sts: (%s) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "generic_platform_error_handler"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "l2-ecc-correctable-panic"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "init_generic_platform_error_handler"
        prototype = ""
        caller = "machine_startup"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(va=0x%#llx) "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "format_va"
        prototype = ""
        caller = "generic_platform_error_handler"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(va=%#llx) "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "format_va_or_tlb_set_way"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(PIO offset from this cluster: %#llx, info=%#llx AFID=%#llx%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "format_multiple_err_and_pio_addr"
        prototype = ""
        caller = "generic_platform_error_handler"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(multiple errors) "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "format_multiple_err"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(info=%#llx%s) "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "format_multiple_err_and_raw_info"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "[bti_telemetry] bti_telemetry_init\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "bti_telemetry_init"
        prototype = ""
        caller = "kernel_bootstrap"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpectedly found multiple concurrent drains! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unexpected duplicate splay entry! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Unexpectedly could not acquire telemetry lock (nested acquire will deadlock) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "[bti_telemetry] Unexpected BTI exception (pc=0x%08lx, BTYPE=%d)\n[bti_telemetry] \t<UUID: %s, offset: 0x%08lx>\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "drain_record_submission_buffer_thread_call"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "nfsvc_addsock:: nfsrv_check_exports_allow_address(myname) returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "nfssvc_addsock: socket buffer setting SO_SNDBUF to %llu error(s) %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "nfssvc_addsock: socket buffer setting SO_RCVBUF to %llu error(s) %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "nfssvc_addsock: socket timeout setting SO_RCVTIMEO error(s) %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "nfssvc_addsock: socket timeout setting SO_SNDTIMEO error(s) %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "nfssvc_addsock"
        prototype = ""
        caller = "nfssvc"
    }
    new {
        args = 0
        anchors {
            new {
                string = "NFS server: NULL reply from proc = %d error = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "mbuf siz=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Bad nfs svc reply @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "nfs_syscalls.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfssvc_nfsd"
        prototype = ""
        caller = "nfssvc"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Server header: gss_krb5_verify_mic_mbuf failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Server args: gss_krb5_verify_mic_mbuf failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: gss_krb5_unwrap_mbuf failes %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: Sequence number mismatch seqnum = %d nd->nd_gss_seqnum = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "reply_mbuf"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "reply_mbuf %p nmc_head %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfs_gss_svc_cred_get"
        prototype = ""
        caller = "nfsrv_getreq"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: %d: is running\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %d: Removing contex for %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "nfs_printf"
            }
        }
        symbol = "nfs_gss_svc_ctx_timer"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "gss_krb5_get_mic_mbuf failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfs_gss_svc_protect_reply"
        prototype = ""
        caller = "nfssvc_nfsd"
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfs_gss_svc_gssd_upcall: can't get gssd port, status %x (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfs_gss_svc_gssd_upcall: gssd port not valid\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Calling mach_gss_accept_sec_context\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "mach_gss_accept_sec_context returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "nfs_gss_svc_gssd_upcall failed: %x (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "nfs_gss_svc_gssd_upcall: bad context length (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Failed to make context from lucid_ctx_buffer\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfs_gss_svc_gssd_upcall: could not allocate %d bytes\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfs_gss_svc_ctx_init"
        prototype = ""
        caller = "nfsrv_null"
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfs_gss_mach_alloc_buffer: vm_map_round_page failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfs_gss_mach_alloc_buffer: vm_allocate failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfs_gss_mach_alloc_buffer: vm_map_unwire failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfs_gss_mach_alloc_buffer: vm_map_copyin failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfs_gss_mach_alloc_buffer"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "nfsrv_send"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfsrv_send\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfsrv_send"
        prototype = ""
        caller = "nfssvc_nfsd"
    }
    new {
        args = 1
        anchors {
            new {
                string = "nfsrv_rcv: mbuf_setnext failed %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "nfsrv_rcv: mbuf_setnext failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfsrv_rcv_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "nfs getstream @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "nfsrv_getstream: nfsrv_unprocessed_rpc_current (%u) has reached the max allowed consumption (%u)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "nfsrv_getstream: mbuf_setnext failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "nfsrv_getstream: mbuf_setnext failed 3, %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "nfsrv_getstream"
        prototype = ""
        caller = "nfsrv_rcv_locked"
    }
    new {
        args = 1
        anchors {
            new {
                string = "nfsrv cache @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "nfs_srvcache.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfsrv cache: reply alloc failed for nonidem request hit\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "nfsrv cache: reply copym failed for nonidem request hit\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "nfsrv cache: nam copym failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfsrv_getcache"
        prototype = ""
        caller = "nfssvc_nfsd"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%2.2x "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s    "
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfs_dump_mbuf"
        prototype = ""
        caller = "nfsrv_send"
    }
    new {
        args = 0
        anchors {
            new {
                string = "got NULL mbuf? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "nfs_subs.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfsm_chain_new_mbuf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfsrv_free_addrlist: invalid socket address (%u)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfsrv_free_addrlist: address not found (0)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfsrv_free_addrlist: address not found (1)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_nfsrv_free_addrlist"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfsrv_export: warning: nested exports: %s/%s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfsrv_export"
        prototype = ""
        caller = "nfssvc_export"
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfsrv_uc_dequeue_wait"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfsrv_uc_dequeue remove %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfsrv_uc_dequeue"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfsd_upcall_shutdown_stop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfsrv_uc_cleanup"
        prototype = ""
        caller = "nfsrv_cleanup"
    }
    new {
        args = 1
        anchors {
            new {
                string = "nfsd_upcall_shutdown_wait"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "nfsd: Could not start nfsd proxy up-call service. Falling back\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "nfsrv_uc_addsock"
        prototype = ""
        caller = "nfssvc_addsock"
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfsd_upcall_handler"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfsrv_uc_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nfsd up-call queue limit exceeded @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "nfs_upcall.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nfsrv_uc_proxy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s mbuf = %p offset = %d len = %d:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Count chars %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "printmbuf"
        prototype = ""
        caller = "nfs_gss_svc_cred_get"
    }
    new {
        args = 0
        anchors {
            new {
                string = "buffer"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "printgbuf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Token id does not match\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Bad flags %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "krb5_cfx_crypt_mbuf %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Encrypted token mismach\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "gss_krb5_cfx_unwrap_mbuf"
        prototype = ""
        caller = "gss_krb5_unwrap_mbuf"
    }
    new {
        args = 4
        anchors {
            new {
                string = "Bad mic TOK_ID %x %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Bad flags received %x exptect %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Bad mic filler %x @ %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "gss_krb5_cfx_verify_mic_mbuf"
        prototype = ""
        caller = "gss_krb5_verify_mic_mbuf"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: bad framing\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: invalid length\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: token to short"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "toklen = %d, length = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: Invalid mechanism\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: Invalid body\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: Invalid des mac\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "gss_krb5_3des_token_get"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: invalid version %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: Could not decode initiate\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Could not decode endtime\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Could not decode send_seq\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Could not decode recv_seq\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Could not decode mech protocol\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Could not decode rfc1964 sign and seal\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Could not decode rfc4121 acceptor_subkey"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Invalid mech protocol %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Could not decode key enctype\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: could not decode key length\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: etype = %d keylen = %d expected keylen = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: could not get memory for key\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: could get key value\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "gss_krb5_make_context"
        prototype = ""
        caller = "nfs_gss_svc_ctx_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "netboot: no suitable interface\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: using network interface '%s'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: socreate, error=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: SIFFLAGS, error=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: can't retrieve IP parameters\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: IP address %d.%d.%d.%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = " netmask %d.%d.%d.%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = " router %d.%d.%d.%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: inet_aifaddr failed, %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: adding default route %d.%d.%d.%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: default_route_add failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "dhcp-response"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: retrieving IP information from DHCP response\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: retrieving IP information from BOOTP response\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "rootpath"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot_info_init: rp0='%s' isn't a network path, ignoring\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netboot: NFS boot is deprecated\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "http:"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: HTTP URL %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: root path uses unrecognized format\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: nested image %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "bsdp-response"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: retrieving root path from BSDP response\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netboot: retrieving root path from BOOTP response\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "netboot_mountroot"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "netboot_setup: calling imageboot_mount_image\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "netboot_setup"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to register provider '%s': invalid arguments"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "<NULL>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to register provider '%s': invalid provider name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to register provider '%s': invalid provider ops"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "failed to register provider '%s': invalid provider attributes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to register provider '%s': invalid privilege attributes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to register provider '%s': need dtps_usermode() op for given privilege attributes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_register"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "attempt to unregister non-existent dtrace provider %p\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dtrace_unregister"
        prototype = ""
        caller = "fasttrap_pid_cleanup_cb"
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to register meta-provider: invalid name"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "failed to register meta-register %s: invalid ops"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to register meta-register %s: user-land meta-provider exists"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
        }
        symbol = "dtrace_meta_register"
        prototype = ""
        caller = "fasttrap_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "helper_init before dtrace_init @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "helper_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtracehelper"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtrace_init: failed to devfs_make_node for helper!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "helper_init: called twice! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "helper_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace_kernel_symbol_mode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "kernel_bootstrap_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace_init: failed to retrieve the hw.memsize, defaulted to %lld bytes\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "dtrace_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtrace_init: failed to devfs_make_node_clone for dtrace!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "dtrace_dof_mode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtrace_init: called twice! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dtrace_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace_postinit: Could not register mach_kernel modctl\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "illegal value (%lu) for dtrace_retain_max; setting to 1"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "BEGIN"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dof-data-%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to create anonymous state"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "unreadable DOF"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "truncated header"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "truncated DOF"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid DOF size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "oversized DOF"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "enabling probe %d (%s:%s:%s:%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_postinit"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(scope == DIFV_SCOPE_GLOBAL && size <= maxglobalsize) || (scope == DIFV_SCOPE_LOCAL && size <= maxlocalsize)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_canstore_remains"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "inprobe == 0 || id == dtrace_probeid_error"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_probe"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "id < (uint_t)vstate->dtvs_nglobals"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "id < (uint_t)vstate->dtvs_nlocals"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "id < (uint_t)vstate->dtvs_ntlocals"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_dif_emulate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace: panic action at probe %s:%s:%s:%s (ecb %p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dtrace_action_panic"
        prototype = ""
        caller = "dtrace_probe"
    }
    new {
        args = 0
        anchors {
            new {
                string = "attempt to unref non-existent string %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dtrace_strunref"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "state->dts_formats[ndx]->dtf_refcount < UINT64_MAX"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_ecb_create_enable"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fmt->dtf_refcount > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_ecb_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "returned value did not match expected generation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_lazy_dofs_process"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "helper"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ustack"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unmatched helpers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "misaligned section offset"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "provider section too small"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid provider name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid entry size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "misaligned entry size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid function name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "function name too long"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid probe name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid probe offset"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "is-enabled offsets with null section"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid is-enabled offset"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "zero probe and is-enabled offsets"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "zero probe offsets"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid args"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad native argument type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "native argument type too long"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad native argument index"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad translated argument type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "translated argument type too long"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_helper_slurp"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "DOF magic string mismatch"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF has invalid data model"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF encoding mismatch"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF version mismatch"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF uses unsupported instruction set"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF uses too many integer registers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF uses too many tuple registers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF has invalid ident byte set"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "DOF has invalid flag bits set"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid section header size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "truncated section headers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "misaligned section headers"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "misaligned section size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "illegal sections for enabling"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad section alignment"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "misaligned section"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "corrupt section header"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "non-terminating string table"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_dof_slurp"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Non loadable section with ECB description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "truncated ECB description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad alignment in ECB description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid probe section"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad alignment in probe description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "truncated probe description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "corrupt probe provider"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "corrupt probe module"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "corrupt probe function"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "corrupt probe name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_dof_ecbdesc"
        prototype = ""
        caller = "dtrace_dof_slurp"
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid DIFO header section"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad alignment in DIFO header"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad size in DIFO header"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "exceeds maximum size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad alignment"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "entry size mismatch"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "corrupt entry size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unrecognized DIFO subsection"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "missing DIF text"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cannot write to 0 address\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid branch target %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "dtrace_difo_err"
            }
            new {
                string = "backward branch to %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid integer ref %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid string ref %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "dtrace_difo_err"
            }
            new {
                string = "invalid ref type %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid val type %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "dtrace_difo_err"
            }
            new {
                string = "invalid key\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "expected 'ret' as last DIF instruction\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "dtrace_difo_err"
            }
            new {
                string = "bad return size\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unrecognized variable scope %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unrecognized variable type %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%d exceeds variable id limit\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "zero-sized variable\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "oversized by-ref static\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%d changed variable kind\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%d changed variable type flags\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%d changed variable type size\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_dof_difo"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace DIF object error: [%u]: "
                segment = "__TEXT"
                section = "__cstring"
                caller = "uprintf"
            }
        }
        symbol = "dtrace_difo_err"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "invalid action section"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "truncated action description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad alignment in action description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "section entry size exceeds total size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad entry size in action description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "actions exceed dtrace_actions_max"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bogus format string"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "empty format string"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_dof_actdesc"
        prototype = ""
        caller = "dtrace_dof_ecbdesc"
    }
    new {
        args = 0
        anchors {
            new {
                string = "illegal variable %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "illegal dynamic variable load\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "illegal dynamic variable store\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_difo_validate_helper"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace_open: couldn't acquire minor number %d. This usually means that too many DTrace clients are in use at the moment"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "dtrace_aggid_%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_state_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unloaded module '%s' had enabled probes"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
        }
        symbol = "dtrace_module_unloaded"
        prototype = ""
        caller = "_dtrace_close"
    }
    new {
        args = 0
        anchors {
            new {
                string = "security restrictions disallow DTRACEIOC_MODUUIDSLIST"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "dtrace_kernel_symbol_mode of %u disallows DTRACEIOC_MODUUIDSLIST"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to copyin dtmul_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtmul_count is not valid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed copyin of dtrace_module_uuids_list_t"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "failed copyout of dtrace_symbolsdesc_list_t"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtrace_kernel_symbol_mode of %u disallows DTRACEIOC_PROVMODSYMS"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to copyin dtmodsyms_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "Invalid dtmodsyms_count value"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Invalid module_symbols_size %ld"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "failed copyin of dtrace_module_symbols_t"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_dtrace_ioctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Non loadable option section"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad alignment in option description"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "zeroed option entry size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bad option entry size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "non-zero option string"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unset option"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rejected option"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_dof_options"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dstate->dtds_chunksize < (LONG_MAX - sizeof (dtrace_dynhash_t))"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(uintptr_t)start < limit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(uintptr_t)start >= (uintptr_t)base"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "limit <= (uintptr_t)base + size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(uintptr_t)dvar >= (uintptr_t)base && (uintptr_t)dvar <= (uintptr_t)base + size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_state_go"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to copyin dofiod_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dofiod_count is not valid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed copyin of dof_ioctl_data_t"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed copyout of dof_ioctl_data_t"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "lazy_dofs_add merged_dofs_count out of range"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "helper_ioctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace load module already exists '%s %u' is failing against '%s %u'"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "dtrace module load '%s %u' is failing "
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
        }
        symbol = "dtrace_module_loaded"
        prototype = ""
        caller = "dtrace_postinit"
    }
    new {
        args = 0
        anchors {
            new {
                string = "lockstat_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lockstat_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dtrace_proc_waitfor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_proc_waitfor"
        prototype = ""
        caller = "_dtrace_ioctl"
    }
    new {
        args = 0
        anchors {
            new {
                string = "attempt to remove non-existent invop handler @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "dtrace_subr.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dtrace_invop_remove"
        prototype = ""
        caller = "fbt_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "timer_call_cancel() failed to cancel a timer call: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dtrace_cpu_state_changed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vmem_alloc: failure after blist_resize! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vmem_alloc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "blist_meta_alloc: allocation too large @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "blst_meta_alloc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "blst_meta_free: freeing already free blocks (%d) %d/%d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "blst_meta_free: freeing unexpected range @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "blst_meta_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fbt_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IgnoreFBTBlacklist"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fbt_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "SDT: unable to find prelink info\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sdt_early_init"
        prototype = ""
        caller = "kernel_bootstrap_thread"
    }
    new {
        args = 0
        anchors {
            new {
                string = "SDT: No kernel symbols for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "__sdt"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sdt_load_machsect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sdt_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/dev/sdt couldn't create minor node"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to register sdt provider %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sdt_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Ignoring probes from unsupported provider %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Ignoring probe %s (no symbol name)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__sdt_provide_module"
        prototype = ""
        caller = "sdt_provide_module"
    }
    new {
        args = 0
        anchors {
            new {
                string = "systrace_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "systrace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "machtrace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mach_trap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "systrace_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "profile_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "profile_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "hrtime_t"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "profile_getargdesc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fasttrap_init: failed to allocate a major number!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Could not create fasttrap_cleanup_thread @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "fasttrap.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtrace_fasttrap_cleanup_thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
            new {
                string = "dtrace.fasttrap_probe_t[1]"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtrace.fasttrap_probe_t[2]"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dtrace.fasttrap_probe_t[3]"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fasttrap_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Failed to install fasttrap probe for pid %d: Process does not allow invalid code pages\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "Failed to install fasttrap probe for pid %d: Failed to re-acquire process\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
        }
        symbol = "fasttrap_pid_enable"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fasttrap_fork: sprlock(%d) returned a different proc\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "fasttrap_fork: failed to re-acquire proc\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fasttrap_fork"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to instantiate provider %s: name too long to accomodate pid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to instantiate provider %s: %s is an invalid name"
                segment = "__TEXT"
                section = "__cstring"
                caller = "cmn_err"
            }
            new {
                string = "failed to instantiate provider %s for process %u"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fasttrap_meta_provide"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "userland struct sigvec *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct sigaltstack *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct rusage *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland unsigned char *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct statfs *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland fhandle_t *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland void **"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct rlimit *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland const struct fhandle *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland sem_t *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct statfs64 *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland au_id_t *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct auditinfo_addr *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "au_asid_t"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct nxctl_init *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct ch_init *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct net_qos_param *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct timex *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "userland struct ntptimeval *"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "systrace_entry_setargdesc"
        prototype = ""
        caller = "systrace_getargdesc"
    }
    new {
        args = 0
        anchors {
            new {
                string = "random_init: failed to allocate a major number! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "randomdev.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "random"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "urandom"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "random_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "mdevadd: attempt to add overlapping memory device at %016llX-%016llX @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mdevadd: attempt to add more than %d memory devices @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mdevadd: attempt to explicitly add a bogus memory device: %08X @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mdevadd: attempt to explicitly add a previously defined memory device: %08X @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mdevadd: error - bdevsw_add() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ramdevice_init: error - cdevsw_add() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "mdevadd: devfs_make_node for block failed!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rmd%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mdevadd: devfs_make_node for character failed!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Added memory device md%x/rmd%x (%08X/%08X) at %016llX for %016llX\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "mdevadd"
        prototype = ""
        caller = "IOFindBSDRoot"
    }
    new {
        args = 1
        anchors {
            new {
                string = "ramstrategy: buf_map failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mdevstrategy: sink address %016llX not mapped @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mdevstrategy: source address %016llX not mapped @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mdevstrategy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kern.maxvnodes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bsd_startupearly"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "mbuf_pool"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bsd_mbuf_cluster_reserve"
        prototype = ""
        caller = "__startup_kmem_range_spec_mb_block_invoke_2"
    }
    new {
        args = 0
        anchors {
            new {
                string = "monotonic: cdevsw_add failed: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "monotonic: devfs_make_node failed for '%s' @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mt_dev_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Directory expected to have fg_vn_data @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "getattrlistbulk"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "buf_strategy: b_vp == NULL || vtype == VCHR | VBLK @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "buf_strategy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_flushdirtyblks"
                segment = "__TEXT"
                section = "__cstring"
                caller = "tsleep"
            }
        }
        symbol = "buf_flushdirtyblks_skipinfo"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "using %d buffer headers and %d cluster IO buffer headers\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Couldn't register buffer cache callout for vm pressure! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bufinit"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "buf_bdwrite"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bdwrite_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "buf_brelse: bad buffer = %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "brelse: bp @ %p has NULL b_iodone! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "brelse: Failed to create UPL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ubc_upl_unmap failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "brelse: UPL set for non VREG; vp=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "buf_brelse_shadow: bp_head on freelist %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "buf_brelse_shadow: bp not on list %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "buf_relse_shadow: b_shadow != NULL && b_shadow_ref == 0  bp(%p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "buf_relse_shadow: b_shadow == NULL && b_shadow_ref != 0  bp(%p) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "buf_brelse"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "buf_getblk"
                segment = "__TEXT"
                section = "__cstring"
                caller = "msleep"
            }
            new {
                string = "getblk: paging or unknown operation for incore busy buffer - %x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "buffer has UPL, but not marked BUSY: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "getblk: paging or unknown operation for incore buffer- %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bp already has UPL: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "getblk: VNOP_BLOCKMAP failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "getblk: paging or unknown operation - %x @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bgetvp_locked: not free @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "buf_getblk"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "allocbuf: buffer larger than MAXBSIZE requested @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "allocbuf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "buf_invalblkno"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "buf_invalblkno"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "buf_biowait"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "buf_biowait"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "biodone already @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "biodone: bp @ %p has NULL b_iodone! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "buf_biodone"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "alloc_io_buf (1)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "alloc_io_buf (2)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "alloc_io_buf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "free_io_buf: bp(%p) - bufstats.bufs_iobufinuse < 0 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "free_io_buf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "buf_reassign: NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "buf_reassign"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bremfree_locked: %p not on freelist @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bremfree: lost tail @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bremfree_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "getnewbuf: bp @ %p is LOCKED or BUSY! (flags 0x%x) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "getnewbuf"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "buf_acquire"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "buf_acquire_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "blaundry"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bcleanbuf_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%c(%u, %u)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_getname_printable"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "firmlink target for vnode %p does not have flag set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_getfirmlink"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Incorrect state for old nc_counter(%d), should be even @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cache_enter_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Incorrect state for old nc_counter(%d), should be odd @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cache_delete"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to resize the hash table.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "add_name_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 6
        anchors {
            new {
                string = "cluster_pagein: NULL upl passed in @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cluster_pagein_ext"
        prototype = ""
        caller = "cluster_pageout_0"
    }
    new {
        args = 5
        anchors {
            new {
                string = "cluster_push"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "cluster_push_err"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s(): Called with real buffer of size %d bytes which is greater than the maximum allowed size of %d bytes (the system PAGE_SIZE).\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s(): Called with real buffer and needs verification  @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s : Number of retries for syncing first or last page reached %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Vector UPLs should not take this code-path @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "BUSY bp found in cluster_io @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "buf_setupl failed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s(): cbp_head is not NULL. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cluster_io"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "cluster_wait_IO"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "cluster_wait_IO"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s length = %zu, verify_block_size = %zu @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "cluster_EOT"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "cluster_EOT"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "cluster_verify_thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "bsd_setthreadname"
            }
        }
        symbol = "cluster_verify_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ubc_upl_map_range returned error %d upl = %p, upl_offset = %d, size = %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "verify_in_flight underflow @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cluster_iodone_finish"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "ecount >= DRT_BITVECTOR_PAGES, cmap = %p, index = %d, bit = %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ecount <= 0, cmap = %p, index = %d, bit = %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vfs_drt_do_mark_pages"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vfs_drt: new cluster map mysteriously too small @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vfs_drt_alloc_map"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "cluster_write_copy: failed to get pagelist @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cluster_write_copy"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "cluster_push: failed to get pagelist @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cluster_push_now"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "encrypted blocks will hit UBC! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "cluster_read_copy: failed to get pagelist @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "cluster_read_copy"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "Failed to restore dirty state on failure @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vfs_drt: entry summary count > 0 but no bits set in map, cmap = %p, index = %d, count = %lld @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "sparse_cluster_push"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "operation %s not listed in %s.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vfs_opv_init: bad operation @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vfs_opv_init: operation vector without default routine. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vfs_opv_init"
        prototype = ""
        caller = "vfsinit"
    }
    new {
        args = 0
        anchors {
            new {
                string = "We need to keep going on a continued lookup, but for vp type %d (tag %d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "NAMEI_ROOTDIR is set but ni_rootdir is not\n @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "p->p_fd.fd_rdir is not set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rootvnode is not set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(1) invalid pre-increment usecount (%d) for rootdir vnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(1) usecount overflow for vnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(2) invalid pre-increment usecount (%d) for vnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(2) usecount overflow for vnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(3) Unexpected pre-decrement value (%d) of usecount for rootvnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(4) Unexpected pre-decrement value (%d) of usecount for rootvnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "namei"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "leaf should be empty @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "lookup"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "lookup_traverse_union: null parent name: .%s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "lookup_traverse_union"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "NULL vp with error == 0. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "lookup_compound_vnop_post_hook"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "NULL ni_vp in %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "lookup_handle_found_vnode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Incorrect termination of path in %s @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "lookup_handle_rsrc_fork"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lookup_handle_found_vnode"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dquot"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dqlookup: error %d looking up id %u at index %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "dqlookup: error looking up id %u at index %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dqget"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dqsync_orphans: dquot in use @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dqsync_orphans"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dqflush: stray dquot @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dqflush"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dqsync: NULL dq_qfile @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "dqsync: NULL qf_vp @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dqsync_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vnode_writedone: numoutput < 0 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_writedone"
        prototype = ""
        caller = "buf_biodone"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_drain_network"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_umount_preflight"
        prototype = ""
        caller = "vflush"
    }
    new {
        args = 0
        anchors {
            new {
                string = "mount_iterdrain"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "mount_iterdrain"
        prototype = ""
        caller = "dounmount"
    }
    new {
        args = 1
        anchors {
            new {
                string = "already in drain @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "mount_drain"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mount_refdrain: dangling vnode @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mount_refdrain"
        prototype = ""
        caller = "dounmount"
    }
    new {
        args = 1
        anchors {
            new {
                string = "vfsbusy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vfs_busy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vfs_mountroot: can't setup bdevvp\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "root_device"
                segment = "__TEXT"
                section = "__cstring"
                caller = "vfs_rootmountalloc_internal"
            }
            new {
                string = "%s() VFS_ROOT() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vfs_mountroot"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s_mountroot failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vfs_mountroot"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s : shuffling mount points : %s <-> / <-> %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Do not use a leading slash in outgoing_vol_new_path\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Incoming rootfs root vnode not found\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Outgoing rootfs path not found, abandoning / switch, error = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Outgoing rootfs path is not a directory, abandoning / switch\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "skipping preserved mountpoint because not found or error: %d: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "skipping preserved mountpoint because not a mountpoint: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "preserved new mount directory not found or error: %d: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "preserved new mount directory not directory: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "will preserve mountpoint across pivot: /%s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s : done shuffling mount points with error: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Incoming rootfs path not a directory\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Incoming rootfs root vnode does not have associated mount\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Incoming rootfs root vnode mount is busy\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Could not get rootvnode of incoming rootfs\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Incoming rootfs root vnode mount is is not a mountpoint\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Incoming rootfs is backed by a virtual device; cannot switch to it"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vfs_switch_root"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_get(rootvnode) failed with error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "attempting kernel mount for recovery volume... \n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Failed to mount recovery volume (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mounted recovery volume\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vfs_mount_recovery"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "bdevvp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bdevvp failed: vnode_ref @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bdevvp failed: fsync @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bdevvp failed: invalidateblks @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bdevvp failed: open @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bdevvp"
        prototype = ""
        caller = "vfs_mountroot"
    }
    new {
        args = 1
        anchors {
            new {
                string = "vnode_ref_ext: vp %p has no valid reference %d, %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_ref_ext: v_writecount @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_ref_ext: v_kusecount @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_ref_ext"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vnode_rele_ext: vp %p usecount -ve : %d.  v_tag = %d, v_type = %d, v_flag = %x. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vnode_rele_ext: vp %p writecount -ve : %d.  v_tag = %d, v_type = %d, v_flag = %x. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vnode_rele_ext: vp %p kusecount -ve : %d.  v_tag = %d, v_type = %d, v_flag = %x. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vnode_rele_ext: vp %p kusecount(%d) out of balance with usecount(%d).  v_tag = %d, v_type = %d, v_flag = %x. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_rele_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "vflush"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vflush"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vfs: bad selector 0x%.8x for old-style sysctl().  use the sysctl-by-fsid interface instead\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "smbfs"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vfs_sysctl_node"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vfs_unmountall(%ssystem) start\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Unmounting timed out\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "missed mount"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vfs_unmountall(%ssystem) end\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vfs_unmountall"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ioqueue_depth = %d,   ioscale = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vfs_init_io_attributes"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vnode getiocount"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vnode_getiocount"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_getiocount"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "NULL vnode passed to vnode_initialize @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_initialize"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "add_fsref: vp already has named reference @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "addfsref: vp on the free list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_addfsref"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "remove_fsref: no named reference @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_removefsref"
        prototype = ""
        caller = "null_reclaim"
    }
    new {
        args = 3
        anchors {
            new {
                string = "Open parameters, but not a regular file. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Mode for open, but not trying to open... @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_create: unknown vtype %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.kauth.vnode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vfsinit"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 3
        anchors {
            new {
                string = "NULL ndp @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_authorize_open_existing"
        prototype = ""
        caller = "vn_open_auth"
    }
    new {
        args = 4
        anchors {
            new {
                string = "NULL cn_ndp @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_authorize_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 5
        anchors {
            new {
                string = "Passed something other than NULL as reserved field! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_authorize_renamex_with_paths"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "reserved not NULL in vn_authorize_mkdir() @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_authorize_mkdir"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "Non-NULL reserved argument to vn_authorize_rmdir() @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_authorize_rmdir"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "(1) vnode attrs not complete for vnode_attr_authorize @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "(2) vnode attrs not complete for vnode_attr_authorize (2) vap->va_active = 0x%llx , vap->va_supported = 0x%llx @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_attr_authorize"
        prototype = ""
        caller = "vnode_attr_authorize_dir_clone"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vclean: cannot reclaim @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vclean"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "insmntque: vp not in mount vnode list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vp already in mount list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "insmntque: vp already in mount vnode list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "insmntque"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_reload with no iocount %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_iterate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unmount(%d) %s skipped\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "unmount(%d) %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Unmount of %s failed (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "unmount_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "new_vnode(%p): the vnode is VL_DEAD but not VBAD @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "new_vnode(%p): vp on list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "new_vnode(%p): free vnode still referenced @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "new_vnode(%p): vnode seems to be on mount list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "new_vnode(%p): vnode still hooked into the name cache @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "process_vp"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s : vp %p holdcount -ve: %d.  v_tag = %d, v_type = %d, v_flag = %x. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vnode_drop_internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_drop_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_put(%p): iocount < 1 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_put_internal_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vnode reclaim in progress @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_reclaim_internal: cleaned vnode isn't @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_reclaim_internal: clean vnode has pending I/O's @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_reclaim_internal: vparent not removed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_reclaim_internal: vname not removed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_reclaim_internal: vleases NOT empty @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "missing bdev @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "missing alias @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_reclaim_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vnode_drain: recursive drain @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode_drain_with_timeout"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vnode_drain"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_drain"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_create: vnode_resolver_create() err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: alias vnode (vid = %u) is in state of change (start) v_flags = 0x%x v_numoutput = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: alias vnode (vid = %u), is in state of change (end) v_flags = 0x%x v_numoutput = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "insmntque: vp on the free list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "new_vnode: vp (%p) on RAGE list not marked VLIST_RAGE @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vnode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%d desired, %ld numvnodes, %ld free, %ld dead, %ld async, %d rage\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "checkalias with VT_NON vp that shouldn't: %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_create_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "trigger_unmount_callback: unexpected match '%s'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "trigger_unmount_callback: trigger mnt changed! (%p != %p)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "unresolving: '%s', err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "trigger_unmount_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_trigger_unresolve: not currently resolved\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vnode_trigger_unresolve"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "VNODE_REF_FORCE didn't help... @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_resolver_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.vfs.file-leases"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_setlease"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "wait_for_lease_break"
                segment = "__TEXT"
                section = "__cstring"
                caller = "msleep"
            }
        }
        symbol = "wait_for_lease_break"
        prototype = ""
        caller = "vnode_breaklease"
    }
    new {
        args = 1
        anchors {
            new {
                string = "failed to locate mount-on path: %s "
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "kernel_mount"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: mount on %s failed, error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vfs_mount_at_path"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vfs_mount_at_path"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = ".quota.ops"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "group"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "enablequotas"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "attempt to unmount a system mount (%s), will return EBUSY\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "safedounmount"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dounmount: no coveredvp @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dounmount"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sync_thread failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "sync_thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "sync timed out: %d sec\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "sync_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.vfs.pivot-root"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "pivot_root"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "safe_getpath: failed to get the path for vp %p (%s) : err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "no-name"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "safe_getpath_new"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: %s: Bad dirent recived from directory %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vnode_readdir64"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_readdir64"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.vfs.snapshot.user"
                segment = "__TEXT"
                section = "__cstring"
                caller = "IOTaskHasEntitlement"
            }
            new {
                string = "com.apple.private.vfs.snapshot"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.developer.vfs.snapshot"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.apfs.arv.limited.snapshot"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fs_snapshot"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "/System/Library/AssetsV2/manifests/"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "graftdmg"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Volume mounted on a device with invalid major number. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s() VFS_ROOT returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "mount_common"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "webdav"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mount_common(): mount of %s filesystem failed with %d, but vnode list is not empty. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "mount_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.vfs.open-by-id"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "openbyid_np"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "No vp, but no compound remove? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "EKEEPLOOKING, but not a filesystem that supports compound VNOPs? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "unlinkat_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "EKEEPLOOKING without NAMEI_CONTLOOKUP on either ndp? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rename retry limit due to ERECYCLE reached\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "renameat_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "No error, but no compound rmdir? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rm AD"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rmdirat_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nspace.complete: gencount changed! (orig %llu cur %llu)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "nspace.complete: syncroot changed! (orig %llu cur %llu)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sysctl_nspace_complete"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nspacerq"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nspace_resolver_req_add"
        prototype = ""
        caller = "vfs_materialize_item"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.kernel.set-package-extensions"
                segment = "__TEXT"
                section = "__cstring"
                caller = "IOTaskHasEntitlement"
            }
        }
        symbol = "fsctl_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "EKEEPLOOKING from a filesystem that doesn't support compound VNOPs? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Haven't cleaned up adequately in vn_open_auth() @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Why am I trying to use VNOP_OPEN() on anything other than the root or a named stream? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "com.apple.private.security.file-unencrypt-access"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vn_open_auth_retry"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "EKEEPLOOKING, but we did a create? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "EKEEPLOOKING from filesystem that doesn't support compound vnops? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_open_auth"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Invalid knote filter on a vnode! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Should never have an EVFILT_READ except for reg or fifo. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "filt_vnode_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_flushnamedstream: err %d opening file\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vnode_flushnamedstream"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "getnamedstream"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vnode_getnamedstream"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "/var/run/.vfs_rsrc_streams_%p%x"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/var/run"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = ".vfs_rsrc_streams_%p%x"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "get_shadow_dir"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "get_xattrinfo: resource fork not last entry\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "get_xattrinfo"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "setxattr: VNOP_WRITE error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "setxattr: write_xattrinfo error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "setxattr: VNOP_TRUNCATE error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "setxattr: uiomove error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "default_setxattr_vfs"
        prototype = ""
        caller = "default_setxattr"
    }
    new {
        args = 1
        anchors {
            new {
                string = "removexattr: write_xattrinfo error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "default_removexattr"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vfs_fsadd: operation %s not listed in %s.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "vfs_fsadd: bad operation @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vfs_fsadd: operation vector without default routine. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vfs_fsadd"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_lookup_continue_needed(): cnp->cn_ndp is NULL @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vnode_lookup_continue_needed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "No dvp? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Want create, but no vap? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Don't want create, but have a vap? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Filesystem did a create, even though none was requested? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "VNOP_COMPOUND_OPEN"
        prototype = ""
        caller = ""
    }
    new {
        args = 5
        anchors {
            new {
                string = "Not batched, and no fvp? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "VNOP_COMPOUND_RENAME() returned %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "vn_rename"
        prototype = ""
        caller = "renameat_internal"
    }
    new {
        args = 0
        anchors {
            new {
                string = "No fvpp after compound rename? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "VNOP_COMPOUND_RENAME"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "Non-CREATE nameiop in vn_mkdir()? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_mkdir"
        prototype = ""
        caller = "vn_create"
    }
    new {
        args = 1
        anchors {
            new {
                string = "NULL vp, but not a compound VNOP? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Non-NULL vap, but not a compound VNOP? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "vn_rmdir"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "add_fsevent: event queue is full! dropping events (num dropped events: %d; num events outstanding: %d).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "add_fsevent: kfse_list head %p ; num_pending_rename %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "add_fsevent: zalloc sez: %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "add_fsevent: event_zone info: %d 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "add_fsevent: line %d: kfse recount %d but should be at least 1 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "add_fsevent: you can't pass me a NULL vnode ptr (type %d)! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "add_fsevent: was not able to add path %s to event %p. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "add_fsevent: funny looking string length: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "add_fsevent: bogus looking string (len %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "add_fsevent: unknown type %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "fsevents: watcher falling behind: %s (pid: %d) rd: %4d wr: %4d q_size: %4d flags: 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "add_fsevent"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "release_event_ref: bogus kfse refcount %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "release_event_ref"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fsevents: watcher %s (pid: %d) - Using /dev/fsevents directly is unsupported.  Migrate to FSEventsFramework\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "fsevents: too many watchers!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "com.apple.private.vfs.fsevents-watcher"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.vfs.fsevents-access-granted-watcher"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "add_watcher"
        prototype = ""
        caller = "fseventsioctl"
    }
    new {
        args = 0
        anchors {
            new {
                string = "fsevents: close: still have readers! (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "remove_watcher"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "fsevents_empty"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/.Spotlight-V100/"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/.MobileBackups/"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "/Backups.backupdb/"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fseventsf_read"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "fsevents: copy_out_kfse: asked to copy out an invalid event (kfse %p, refcount %d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "copy_out_kfse:2: empty/short path (%s)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "copy_out_kfse"
        prototype = ""
        caller = "fseventsf_read"
    }
    new {
        args = 0
        anchors {
            new {
                string = "unexpected unmount pending ack %d (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "fseventsf_ioctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "watcher-close"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fseventsf_drain"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kern.maxkfsevents"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fs-event-buf"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fsevents_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "cp_os_version: unable to parse osversion `%s'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "cp_os_version"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.dmc.set"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "disk_conditioner_set_info"
        prototype = ""
        caller = "fsctl_internal"
    }
    new {
        args = 0
        anchors {
            new {
                string = "dead_read: lock @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dead_read"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dead_write: lock @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dead_write"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dead_badop called @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dead_badop"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Couldn't make stdin, err %d.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "Couldn't make stdout, err %d.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Couldn't make stderr, err %d.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "devfs_fdesc_makelinks"
        prototype = ""
        caller = "devfs_fdesc_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "fdesc_allocvp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fdesc_allocvp"
        prototype = ""
        caller = "devfs_devfd_lookup"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid type for fdesc node! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "fdesc_open"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fifo_open with no fifoinfo @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "fifo_vnops.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fifocreatewait"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fifoor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fifoow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "fifo_open"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "spec_open"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "spec_open type @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_open"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "spec_read type @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_read"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "spec_write type @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_write"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "spec_ioctl @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_ioctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "iosched"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "io_throttle_window_tier1"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "io_throttle_window_tier2"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "io_throttle_window_tier3"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "throttle_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "throttle_lowpri_io"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "throttle_lowpri_io"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Illegal devno (%d) passed into throttle_info_disable_throttle() @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "throttle_info_disable_throttle"
        prototype = ""
        caller = "vfs_init_io_attributes"
    }
    new {
        args = 0
        anchors {
            new {
                string = "spec_strategy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Invalid value (%d) for si_devbsdunit for vnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "Invalid value (%d) for si_isssd for vnode %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_strategy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "negative open count (c, %u, %u) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "negative open count (b, %u, %u) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "spec_close: not special @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_close"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "spec_blktooff: not implemented for VBLK\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "spec_blktooff type @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_blktooff"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "spec_offtoblk: not implemented for VBLK\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "spec_offtoblk type @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "spec_offtoblk"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s : si_devbsdunit initialized to (%d), throttle_mask is (0x%llx), isssd is (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "spec_init_bsdunit"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "devfs_sinit: dev_add_entry failed "
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "devfs_sinit"
        prototype = ""
        caller = "devfs_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "devfs_remove: not ready for devices!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "devfs_remove"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "plane count wrapped around. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "devfs_free_plane"
        prototype = ""
        caller = "devfs_unmount"
    }
    new {
        args = 1
        anchors {
            new {
                string = "devfs_dntovn: DN_DELETE set on a devnode upon entry. @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "devfs_dntovn: cloning device with a vnode? @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "devfs_dntovn"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "devfs_rele_node: devnode without a refcount! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "devfs_rele_node"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "devfs_make_node: not ready for devices!\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "devfs_make_node_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "devfs_read(): bad file type %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "devfs_read"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "devfs_write(): bad file type %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "devfs_write"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "devfs_kernel_mount: kernel_mount failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "devfs_kernel_mount"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "oslog_stream"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "devfs_init"
        prototype = ""
        caller = "vfsinit"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d:%s: %s: unknown cmp_state %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "decmpfs_file_is_compressed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d:%s: %s: VNOP_VERIFY returned error = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: verify block size (%zu) is not power of 2, no verification will be done\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: upl size (%zu) is not a multiple of verify block size (%zu)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: FS block size (%u) is greater than PAGE_SIZE (%d) and is not power of 2, no verification will be done\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: FS block size (%u) is greater than verify block size (%zu), no verification will be done\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: unexpected pagein during decompress\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: Unexpected size fetch of decompressed data, l_uplSize = %d, l_did_read = %d, inval_size = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: Verification failed with error %d, uplPos = %lld, uplSize = %d, did_read = %d, valid_pages = %d, invalid_pages = %d, tail_page_valid = %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: ubc_upl_unmap error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "decmpfs_pagein_compressed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d:%s: %s: verify block size is not power of 2, no verification will be done\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: ubc_create_upl error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: ubc_upl_map kr=0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: ubc_upl_map mapped null\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: cmp_state == FILE_IS_CONVERTING\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: cmp_state == FILE_IS_COMPRESSED\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: cmp_state == FILE_IS_NOT_COMPRESSED\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: Verification failed with error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ubc_upl_unmap returned error %d (kern_return_t) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s:%d:%s: %s: uplOff %lld should never be negative\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: uplOff %lld too large\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: cluster_copy_upl_data err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "decmpfs_read_compressed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s:%d:%s: %s: decmpfs_fetch_compressed_header err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: decompressor err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "decmpfs_free_compressed_data"
        prototype = ""
        caller = "decmpfs_decompress_file"
    }
    new {
        args = 2
        anchors {
            new {
                string = "%s:%d:%s: %s: uio_addiov err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: VNOP_WRITE err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: file decompressed to %lld instead of %lld\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: VNOP_FSYNC err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: aborting decompress, err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: vnode_setsize err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: decmpfs_free_compressed_data err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: vnode_getattr err %d, num retries %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: vnode_setattr err %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: FSIOC_CAS_BSDFLAGS err: flags mismatc. actual (%x) expected (%x), num retries %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: FSIOC_CAS_BSDFLAGS err %d, num retries %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "decmpfs_decompress_file"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s:%d:%s: %s: invalid compression_magic 0x%08x, should be 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: compression_type %d out of range\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "decmpfs_fetch_compressed_header"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.AppleFSCompression.providesType%u"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: waiting for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: the kext with %s is no longer present\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s:%d:%s: %s: still waiting for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: we found %s, but the type still isn't registered\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d:%s: %s: tried to access a compressed file of unregistered type %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "_decmp_get_func"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "wait_for_decompress"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "wait_for_decompress"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bpfdraining"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Two threads blocked in a BPF close @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bpf buffer freed during read/write @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: bpf%d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%u closed by %s.%u dcount %llu fcount %llu ccount %llu"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpfclose"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bpf_read"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: bpf%d ERESTART to EINTR"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpfread"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bpfwrite"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpfwrite: resid %d error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf_movein_batch uiomove error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf_movein_batch bh_hdrlen %u too small"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf_movein_batch bh_caplen %u != bh_datalen %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf_movein_batch bh_hdrlen %u too large"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf_movein_batch bpf_movein error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpfwrite"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "BIOCFLUSH"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpfioctl"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpf%d BIOCSBLEN capped to %u from %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%d BIOCSBLEN bumped to %u from %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%d BIOCSBLEN %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%u cannot set BIOCSHDRCMPLT when BIOCSBATCHWRITE is set"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%u cannot set BIOCSETTC when BIOCSBATCHWRITE is set"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: ifnet not found for %s error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%u bd_write_size_max %u too big"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%u cannot set BIOCSBATCHWRITE when BIOCSHDRCMPLT is not set"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%u cannot set BIOCSBATCHWRITE when BIOCSETTC is set"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpfioctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bpfselect"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bpfselect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bpf_hdr_comp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpf_init: failed to allocate a major number"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpf_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bpf_growing"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpf%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpf_make_dev_t: malloc bpf_dtab failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpf_make_dev_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: %p refcnt <= 0 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: %p BPF_DETACHED not set @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bpf_release_d"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bpf_detachd: descriptor not in list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bpf_detachd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = " closed and"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpf_detachd: bpf%d %s disable input 0"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: bpf%d ifnet_set_promiscuous %s failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf%d%s detached from %s fcount %llu dcount %llu"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpf_detachd"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "bpf_setf"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bpf_setf"
        prototype = ""
        caller = "bpfioctl"
    }
    new {
        args = 1
        anchors {
            new {
                string = "bpf_setif"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpf%u attached to %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpf_setif"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bpf_setdlt"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bpf_setdlt: bpf%d bpf_attachd %s error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "bpf_setdlt: bpf%d ifpromisc %s error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bpf_setdlt"
        prototype = ""
        caller = "bpfioctl"
    }
    new {
        args = 1
        anchors {
            new {
                string = "SO_VALID_TC(tc)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bpf_set_packet_service_class"
        prototype = ""
        caller = "bpfwrite"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s:%d tlen %u > bpfp_total_length %lu bpfp_header_length %lu pth_frame_pre_length %u pre_adjust %u in_pkt_len %u out_pkt_len %u @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s:%d tlen %u > bpfp_total_length %lu bpfp_header_length %lu pth_frame_pre_length %u pre_adjust %u in_pkt_len %u out_pkt_len %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "bpf_tap_imp"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bpf_mcopy @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "buflet != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "addr != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "copy_bpf_packet_offset"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "x_cnt < nbpfilter"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sysctl_bpf_stats"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridgeattach"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "proto_register_plumber failed for PF_INET error=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "proto_register_plumber failed for PF_INET6 error=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: ifnet_clone_attach failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ether_family_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 2
        anchors {
            new {
                string = "is_promisc == list_is_promisc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: (%s): count %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_early_input"
        prototype = ""
        caller = "dlil_input_packet_list_common"
    }
    new {
        args = 0
        anchors {
            new {
                string = "mac_nat_entry_print2"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %.*s %s%s%s %p (%s, %s, %s)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "mac_nat_entry_print2"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "created"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bridge_create_mac_nat_entry_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bridge_mac_nat_arp_translate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: mbuf_copyback failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copyback uh_sum failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copyback dp_flags failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copyback lladdr failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copyback cksum=0 failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copyback cksum failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_mac_nat_translate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridge_pf"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: m_pullup failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_pf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = " frag"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Short IP packet %d < %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: bad IP version"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: bad IP header length %d < %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: IP total len %d < header len %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: invalid IP payload length %d > %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: short IPv6 packet %d < %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: bad IPv6 version"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: ip6_lasthdr() returned %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: invalid IPv6 payload length %d > %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: IPv%c proto %d ip %u pay %u opt %u pkt %u%s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_get_ip_proto"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "dst_ifp != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s bridge_send(%s) len %d op %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "bridge_enqueue"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "tso_hwassist"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: does%s support checksum 0x%x if_csum 0x%x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "tso_hwassist"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "gso_ip_tcp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s %s mss %d nsegs %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "gso_tcp"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "dst_ifp != NULL && src_ifp != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bridge_finalize_cksum"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bridge_compute_cksum"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] before 0x%x hwcap 0x%x sw_csum 0x%x did 0x%x after 0x%x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s -> %s] before 0x%x did 0x%x after 0x%x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_handle_checksum_op"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.kernel.bsd.net.if_bridge"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s invalid MTU for %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: ifnet_set_promiscuous(%s) failed %d, ignoring"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: ifnet_set_promiscuous(%s) failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: if_allmulti(%s) failed %d, ignoring"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: iflt_attach failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: bridge_attach_protocol failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_ioctl_add"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "inside"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "outside"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bridge_iff_input["
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bridge_iff_input]"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bcast_mcast "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bridge_ifp->if_bridge == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s from %s m 0x%llx data 0x%llx frame 0x%llx %s frmlen %lu"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: frame_ptr outside mbuf"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: short frame %lu < %lu"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_pullup(%lu) failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s %sfrom %s m 0x%llx data 0x%llx"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s bridge_host_filter failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s:  broadcast: %02x:%02x:%02x:%02x:%02x:%02x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s mcast for us"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_iff_input"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "bridge_forward"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "src_if == m->m_pkthdr.rcvif"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s m 0x%llx"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_forward"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridge_mac_nat_arp_input"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s %s ARP %s -> %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_mac_nat_input"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridge_rtnode_hash"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s EEXIST %02x:%02x:%02x:%02x:%02x:%02x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_rtnode_hash"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridge_iff_output"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bridge_member_output"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s from %s m 0x%llx data 0x%llx"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: ifp %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_iff_output"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bridge_iflinkevent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifnet_set_promiscuous (%s) failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: if_allmulti (%s) failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_iff_event"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "flushed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bridge_mac_nat_flush_entries_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bridge_iff_detached"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bridge_iff_detached"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bridge_attach_protocol"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifnet_attach_protocol(%s) failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_attach_protocol"
        prototype = ""
        caller = "bridge_ioctl_add"
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridge_proto_input"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s unexpected packet"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_proto_input"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridge_link_event"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bridge_link_event"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "bridge_detach_protocol"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_detach_flowswitch_nexus"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifnet_detach_protocol(%s) failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_delete_member"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "aged out"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bridge_mac_nat_age_entries_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bridge_cancel_delayed_call"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s call 0x%llx flags 0x%x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_cancel_delayed_call"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s (%d): ifnet_detach(%p) failed %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "bridge_clone_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(call->bdc_flags & BDCF_OUTSTANDING) == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(call->bdc_flags & BDCF_CANCELLING) == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s thread_call_free() failed for call %p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "bridge_cleanup_delayed_call"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bridge_cleanup_delayed_call"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "etypef == ETHER_TYPE_FLAG_ARP"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s from %s count %d head 0x%llx.0x%llx tail 0x%llx.0x%llx"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_input_list"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bridge_filter_checksum"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bridge_filter_checksum_list"
        prototype = ""
        caller = "bridge_input_list"
    }
    new {
        args = 2
        anchors {
            new {
                string = "bridge_broadcast_list"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s mcast for us in_m %p"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_broadcast_list"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "dst_if != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s (%s) append gso #segs %u bytes %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s (%s) append %d bytes op %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: %s (%s) bridge_transmit packets %u bytes %u error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bridge_enqueue_multi"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifmultiaddr"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "net_affinity"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "net_rxpoll"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "net_rtref"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "net_async"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_debug"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dlil_pending_thread_cnt == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern.skywalk_netagent_enable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kern.skywalk_netagent_disable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(!pe_enable_fsw_transport_netagent && !pe_disable_fsw_transport_netagent) || (pe_enable_fsw_transport_netagent ^ pe_disable_fsw_transport_netagent)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "SK: netagent is enabled via an override for this platform\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "SK: netagent is disabled via an override for this platform\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "SK: netagent is %s by default for this platform\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "disabled"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "if_attach_nx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "SK: netagent is force-enabled\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "SK: netagent is force-disabled\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "kprintf"
            }
            new {
                string = "ifnet"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_tcpstat"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_udpstat"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Waiting for all the create dlil kernel threads to get scheduled at least once.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: All the created dlil kernel threads have been scheduled at least once. Proceeding.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "if_low_power_event"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: no CPU clock available! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "pktsched_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pktsched.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "sc == MBUF_SC_UNSPEC || MBUF_VALID_SC(sc)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "flow != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_qflush_sc"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "%s[%s,%d]: ifp %s cmd 0x%08lx (%c%c [%lu] %c %lu) error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s[%s,%d]: ifp %s cmd 0x%08lx (%c%c [%lu] %c %lu) OK\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifioctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: promiscuous mode %s %s (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "ifnet_set_promiscuous"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: %s allmulti %s (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "if_allmulti"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: ifma=%p negative refcnt @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifma_remref"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifma_remref"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ifa %p attached to ifp is being freed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ifa_deallocated"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "intf_event_enqueue_nwk_wq_entry"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: eventhandler enqueuing event of type=intf_event event_code=%s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "intf_event_enqueue_nwk_wq_entry"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: Mismatch ifa_ifp=%p != ifp=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Attempt to attach an already attached ifa=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "if_attach_ifa_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: Link address ifa=%p not first @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Attempt to detach an unattached address ifa=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Mismatch ifa_ifp=%p, ifp=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Attempt to detach a stray address ifa=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "if_detach_ifa_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sa->sa_family == AF_LINK"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifconf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifnet_reset_order"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "if_ordered_count == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: count %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ifnet_reset_order"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "ifioctl_get_media"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: first ifnet_ioctl(%s, %08lx) error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s kalloc_data() failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s copyin() error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s converted extended media %08x to compat media %08x"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: %s copyout() error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ifioctl_get_media"
        prototype = ""
        caller = "ifioctl"
    }
    new {
        args = 1
        anchors {
            new {
                string = "if_output_netem_%s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifioctl_linkparams"
        prototype = ""
        caller = "ifioctl"
    }
    new {
        args = 2
        anchors {
            new {
                string = "ifioctl_ifreq"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "so->so_proto != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: interface name too long @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "if_clone_create"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s SIOCSIFMEDIA ignore IFM_OTHER"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "SIOCSIFESTTHROUGHPUT %s%s up: %u, down: %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "SIOCSIFRADIODETAILS %s%s technology: %u, channel: %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ifioctl_req: cmd SIOCSIFMANAGEMENT on %s not allowed for %s:%u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ifioctl_req: cmd SIOCSIFMANAGEMENT 0 not allowed on %s with subfamily management"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ifioctl_req: SIOCSATTACHPROTONULL ifnet_attach_protocol(%s) failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ifioctl_req: SIOCSATTACHPROTONULL ifnet_detach_protocol(%s) failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "SIOCSIFNOTRAFFICSHAPING %s %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ifioctl_ifreq"
        prototype = ""
        caller = "ifioctl"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: Freeing ifma=%p with outstanding anon req @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ifma=%p attached to ifma_ifp=%p is being freed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ifma %p cannot be freed @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: non-zero refcount ifma=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: non-zero reqcnt ifma=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: non-NULL ifma_ifp=%p for ifma=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: non-NULL ifma_ll=%p for ifma=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ifma_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "!anon || sa->sa_family == AF_UNSPEC || sa->sa_family == AF_LINK"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!anon"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifma->ifma_ll->ifma_ifp == ifp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_addmulti_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "(ifma->ifma_flags & IFMAF_ANONYMOUS) || ifma->ifma_anoncnt == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifma->ifma_reqcnt > 1"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_addmulti_doesexist"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifma->ifma_anoncnt == 1"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Mismatch ifma_ifp=%p != ifp=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Attempt to attach an already attached ifma=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ifma=%p unexpected IFMAF_ANONYMOUS @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Attempt to reattach a detached ifma=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifma->ifma_reqcnt == 1"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_attach_ifma"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: ifma %p has no debug structure @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifma_trace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifma_trace"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "!lastref || (!(ifma->ifma_debug & IFD_ATTACHED) && ifma->ifma_reqcnt == 0)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_delmulti_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: ifma=%p negative reqcnt @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ifma=%p missing IFMAF_ANONYMOUS @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ifma=%p negative anonreqcnt @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Mismatch ifma_ifp=%p, ifp=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Detaching ifma=%p with outstanding anon req @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: Attempt to detach an unattached address ifma=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ifma %p is already in trash list @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "if_detach_ifma"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "if_rtdel: error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "if_rtdel"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifnet_set_flowswitch_rx_callback"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_set_flowswitch_rx_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifnet_set_delegate_parent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_set_delegate_parent"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "((intptr_t)base + dlif_tcpstat_size) <= ((intptr_t)buf + dlif_tcpstat_bufsize)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "((intptr_t)base + dlif_udpstat_size) <= ((intptr_t)buf + dlif_udpstat_bufsize)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IS_P2ALIGNED(ifp->if_tcp_stat, sizeof(u_int64_t)) && IS_P2ALIGNED(ifp->if_udp_stat, sizeof(u_int64_t))"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_alloc_local_stats"
        prototype = ""
        caller = "dlil_if_acquire"
    }
    new {
        args = 0
        anchors {
            new {
                string = "dlil_attach_filter"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s filter attached\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: failed to attach %s (err=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dlil_attach_filter"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "plowat != 0 && phiwat != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "blowat != 0 && bhiwat != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ival >= IF_RXPOLL_INTERVALTIME_MIN"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: speed %llu bps, sample per %llu nsec, poll interval %llu nsec, pkts per poll %u, pkt limits [%u/%u], wreq limits [%u/%u], bytes limits [%u/%u]\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_rxpoll_update_params"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifp != NULL && p != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_rxpoll_get_params"
        prototype = ""
        caller = "ifnet_poll_params"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: restart interval set to %lu nsec\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: TBR disabled\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: TBR %s (rate %llu bps depth %u)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "reconfigured"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "idepth > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: TBR calculated tokens %lld filluptime %llu ns\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: TBR calculated tokens %lld infinite filluptime\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: TBR suspended (link is down)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifclassq_tbr_set"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "tail->m_flags & M_PKTHDR"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_enqueue"
        prototype = ""
        caller = "lo_pre_enqueue"
    }
    new {
        args = 2
        anchors {
            new {
                string = "ifp->if_output_dlil != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_eflags & IFEF_ENQUEUE_MULTI"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_output"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(pop & ones) == pop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(ptrdiff_t)(uth->uu_network_marks & pop) == pop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "net_thread_marks_pop"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(unpop & ones) == unpop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(ptrdiff_t)(uth->uu_network_marks & unpop) == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "net_thread_unmarks_pop"
        prototype = ""
        caller = "domain_unguard_release"
    }
    new {
        args = 0
        anchors {
            new {
                string = "IF_FULLY_ATTACHED(ifp)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_incr_iorefcnt"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifp->if_datamov > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Waking up drainers on %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_datamov_end"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Waiting for data path(s) to quiesce on %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_datamov_drain"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_drainers > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_datamov_drain"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: negative refcnt for ifp=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "dlil_if_free"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_if_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed to attach v1 protocol %d (err=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: attached v1 protocol %d (count = %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_attach_protocol"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: failed to attach v2 protocol %d (err=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: attached v2 protocol %d (count = %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_attach_protocol_v2"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: detached %s protocol %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_detach_protocol"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: flags mismatch (embryonic not set) ifp=%p"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifp->if_threads_pending == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Attempt to attach interface without family module - %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ifp->if_proto_hash == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LIST_EMPTY(&ifp->if_multiaddrs)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_allhostsinm == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_addrs[ifp->if_index - 1] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_output_sched_model == IFNET_SCHED_MODEL_NORMAL || ifp->if_output_sched_model == IFNET_SCHED_MODEL_DRIVER_MANAGED || ifp->if_output_sched_model == IFNET_SCHED_MODEL_FQ_CODEL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_flags == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_wtot == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_ifp == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "qhead(&dl_inp->dlth_pkts) == NULL && qempty(&dl_inp->dlth_pkts)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "qlimit(&dl_inp->dlth_pkts) == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!dl_inp->dlth_affinity"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_inp == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_thread == THREAD_NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_strategy == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_driver_thread == THREAD_NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_poller_thread == THREAD_NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_affinity_tag == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dl_inp->dlth_pkts_cnt == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "thfunc == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifp=%p couldn't get an input thread; err=%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifp->if_start_thread == THREAD_NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_start != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifp=%p couldn't get a start thread; err=%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifp->if_input_poll != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_input_ctl != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifp=%p couldn't get a poll thread; err=%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifp->if_desc.ifd_len == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: attached with %d suspended link-layer multicast membership(s)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ifp->if_agentids == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_agentcount == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s if_set_qosmarking_mode(%s) error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "IGMP_IFINFO(ifp) != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IGMP_IFINFO(ifp)->igi_ifp == ifp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "MLD_IFINFO(ifp) != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "MLD_IFINFO(ifp)->mli_ifp == ifp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_data_threshold == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Waiting for all kernel threads created for interface %s to get scheduled at least once.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: All kernel threads created for interface %s have been scheduled at least once. Proceeding.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: attached%s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = " (recycled)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s already has nexus attached\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s kern_nexus_ifattach %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ll_addr == NULL || ll_addr->sdl_alen == ifp->if_addrlen"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifa->ifa_debug == IFD_LINK"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_attach"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifp->if_flowhash != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp != NULL && (ifp->if_eflags & IFEF_TXSTART)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_disable_output"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "!(ifp->if_refflags & IFRF_EMBRYONIC)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: detaching\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ifnet_detach"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifindex2ifnet[ifp->if_index] == ifp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_detaching_cnt != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s %s tcp_kao_cnt %u not zero"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ifnet_detach"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "*ifp == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "((intptr_t)base + dlif_size) <= ((intptr_t)buf + dlif_bufsize)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: failed to allocate if local stats, error: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "dlil_if_acquire"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dlifp1 == NULL || (IS_P2ALIGNED(dlifp1, sizeof(u_int64_t)) && IS_P2ALIGNED(&ifp1->if_data, sizeof(u_int64_t)))"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_if_acquire"
        prototype = ""
        caller = "ifnet_allocate_extended"
    }
    new {
        args = 0
        anchors {
            new {
                string = "src_rt.ro_rt == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_cached_rtlookup_inet"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "lqm >= IFNET_LQM_MIN && lqm <= IFNET_LQM_MAX"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_lqm_update"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: Post DL_NODE_PRESENCE failed witherror %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "dlil_node_present"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_node_present"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "sa != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_node_absent"
        prototype = ""
        caller = "ifnet_notice_node_absence"
    }
    new {
        args = 1
        anchors {
            new {
                string = "sa != NULL && sdl != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "sa->sa_family == AF_INET6 && sdl->sdl_family == AF_LINK"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "sdl->sdl_len <= sizeof(*kev_sdl)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Post DL_NODE_PRESENCE failed with error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "dlil_node_present_v2"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_node_present_v2"
        prototype = ""
        caller = "ifnet_notice_node_presence_v2"
    }
    new {
        args = 0
        anchors {
            new {
                string = "modid != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_report_issues"
        prototype = ""
        caller = "ifnet_report_issues"
    }
    new {
        args = 1
        anchors {
            new {
                string = "cmd == SIOCSIFOPPORTUNISTIC || cmd == SIOCGIFOPPORTUNISTIC"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_getset_opportunistic"
        prototype = ""
        caller = "ifioctl_ifreq"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: throttling level set to %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_set_throttle"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "cmd == SIOCSIFLOG || cmd == SIOCGIFLOG"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_getset_log"
        prototype = ""
        caller = "ifioctl_ifreq"
    }
    new {
        args = 0
        anchors {
            new {
                string = "level >= IFNET_LOG_MIN && level <= IFNET_LOG_MAX"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "flags & IFNET_LOGF_MASK"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: logging level set to %d flags=0x%x arg=0x%x, category=%d subcategory=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "ifnet_set_log"
        prototype = ""
        caller = "ifnet_getset_log"
    }
    new {
        args = 0
        anchors {
            new {
                string = "NAT64 prefixes purged from Interface %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NAT64 prefixlen is incorrect %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "NAT64 prefix has interface/link local scope.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NAT64 prefix set to %s with prefixlen: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_set_nat64prefix"
        prototype = ""
        caller = "ifioctl_nat64prefix"
    }
    new {
        args = 0
        anchors {
            new {
                string = "skip attaching fsw to %s using legacy TX model\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: can't find netif for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s kern_nexus_ifattach device failed %d %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: not attaching flowswitch to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dlil_attach_flowswitch_nexus"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "%s: SIOCGIFDEVMTU failed for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: %s %d %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: can't determine MAX MTU for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: can't get pbufpool info for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: interface %s packet pool (rx %d * %d, tx %d * %d) can't support max mtu(%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_dlil_get_flowswitch_buffer_size"
        prototype = ""
        caller = "dlil_attach_flowswitch_nexus"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s can't get %s provider, error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s register %s provider failed, error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s alloc_provider_instance %s failed, %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dlil_create_provider_and_instance"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dlil_detach_flowswitch_nexus"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_detach_flowswitch_nexus"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "%s deregister_provider %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s kern_nexus_ifdetach device failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s free_provider_instance failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dlil_detach_nexus"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dlil_filter_event"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: eventhandler saw event type=net_filter_event_state event_code=0x%d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "dlil_filter_event"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "main_input"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s_input_poll"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s_input"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "inp->dlth_thread == THREAD_NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: couldn't create main input thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: couldn't create %s input thread"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "dlil_create_input_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "m_head != NULL || (m_tail == NULL && m_cnt == 0)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dlil_input_async"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s %s burst limit %u (sysctl: %u) exceeded. %u packets dropped [%u total in %u events]. new qlen %u "
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "dlil_input_async"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "overcommitted_qlen == target_qlen + dropped_pkts"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: qlen: %u -> %u, qsize: %llu -> %llu qlimit: %u (sysctl: %u) target_qlen: %u (if_rcvq_trim_pct: %u) pkts_to_drop: %u dropped_pkts: %u dropped_bytes %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dlil_trim_overcomitted_queue_locked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_trim_overcomitted_queue_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "inp->dlth_ifp == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_main_input_thread_func"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "wres != THREAD_INTERRUPTED"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!(inp->dlth_flags & (DLIL_INPUT_TERMINATE | DLIL_INPUT_RUNNING))"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!(inp->dlth_flags & DLIL_INPUT_TERMINATE)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_main_input_thread_cont"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "!(ifp->if_eflags & IFEF_RXPOLL) || !net_rxpoll || !(ifp->if_xflags & IFXF_LEGACY)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_poll_mode == IFNET_MODEL_INPUT_POLL_OFF || !(ifp->if_xflags & IFXF_LEGACY)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dlil_input_%s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_input_thread_func"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "(inp->dlth_flags & DLIL_INPUT_TERMINATE) != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: input thread terminated\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dlil_terminate_input_thread"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "dlil_input_sync"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s %s burst limit %u (sysctl: %u) exceeded. %u packets dropped [%u total in %u events]. new qlen %u \n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "dlil_input_sync"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: %s filter detached\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s filter detached\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "OSDecrementAtomic64(&net_api_stats.nas_iflt_attach_count) > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "OSDecrementAtomic64(&net_api_stats.nas_iflt_attach_os_count) > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to detach %s filter (err=%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dlil_detach_filter_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "m_head != NULL || (s == NULL && m_tail == NULL && !ext && poll)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "m_tail == NULL || ext"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "input_func != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: invalid mbuf %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: invalid input packet chain for %s, tail mbuf %p instead of %p\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: input packet count mismatch for %s, %d instead of %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "ifnet_input_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "IS_INTF_CLAT46(ifp)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "*proto_family == PF_INET"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_clat46"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "%s: frame header pointer 0x%llx out of range [0x%llx,0x%llx] for mbuf 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: partial cksum start offset %d is less than frame header length %d for mbuf 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: bad partial cksum value 0x%x (expected 0x%x) for mbuf 0x%llx [rx_start %d]\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "failed to restore"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "wake packet from %s len %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "dlil_input_packet_list_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "if_proto_count == tmp_ifproto_arr_idx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "proto != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_event_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "proto->detached"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_proto_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dlil_attach_protocol"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_attach_protocol"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifnet_start_%s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "skywalk_doorbell_%s_tx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!ifp->if_start_embryonic && !ifp->if_start_active"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_start_thread_func"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: starter thread terminated\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_start_thread_cont"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifp != NULL && (ifp->if_eflags & IFEF_RXPOLL) && (ifp->if_xflags & IFXF_LEGACY)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dlil_input_poll_%s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_rxpoll_input_thread_func"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "m != NULL || m_cnt == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] pkts avg %d max %d limits [%d/%d], wreq avg %d limits [%d/%d], bytes avg %d limits [%d/%d]\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: polling is now %s, pkts avg %d max %d limits [%d/%d], wreq avg %d limits [%d/%d], bytes avg %d limits [%d/%d]\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: error setting polling mode to %s (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "dlil_rxpoll_input_thread_cont"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifnet_poller_%s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!(ifp->if_poll_flags & (IF_POLLF_EMBRYONIC | IF_POLLF_RUNNING))"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_poll_thread_func"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: polling up to %d pkts, pkts avg %d max %d, wreq avg %d, bytes avg %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "m_tail != NULL && m_cnt > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: polled %d pkts, pkts avg %d max %d, wreq avg %d, bytes avg %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: no packets, pkts avg %d max %d, wreq avg %d, bytes avg %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: poller thread terminated\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_poll_thread_cont"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "TAILQ_FIRST(&ifnet_detaching_head) != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_detaching_cnt != 0 || ifp == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: flags mismatch (detaching not set) ifp=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifp->if_datamov == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_drainers == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_suspend == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LIST_EMPTY(&ifp->if_netns_tokens)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifnet_addrs[ifp->if_index - 1] == ifa"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_link.tqe_next == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_link.tqe_prev == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_ordered_link.tqe_next == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_ordered_link.tqe_prev == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: waiting for %s starter thread to terminate\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ifnet_start_thread_exit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s starter thread termination complete"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: waiting for %s poller thread to terminate\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: %s poller thread termination complete\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ifp->if_xflags & IFXF_LEGACY"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_na_ops == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ifp->if_na == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!ifp->if_fwd_cacheok"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!thread_call_isactive(ifp->if_dt_tcall)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: detached\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "qhead(&inp->dlth_pkts) == NULL && qempty(&inp->dlth_pkts)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!inp->dlth_affinity"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "inp->dlth_affinity_tag == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_detacher_thread_cont"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dlil_detach_netif_nexus"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_detach_netif_nexus"
        prototype = ""
        caller = "dlil_quiesce_and_detach_nexuses"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: dl_if %p has no debug structure @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "dlil_if_trace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "dlil_if_trace"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "OSDecrementAtomic64(&net_api_stats.nas_ifnet_alloc_count) > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "OSDecrementAtomic64(&net_api_stats.nas_ifnet_alloc_os_count) > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_dlil_if_release"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "WARNING: %s can't attach ip to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ether_attach_inet"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ether_attach_inet"
        prototype = ""
        caller = "vlan_attach_inet"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: can't handle af%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ether_inet_pre_output"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "WARNING: %s can't attach ipv6 to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ether_attach_inet6"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ether_attach_inet6"
        prototype = ""
        caller = "vlan_attach_inet6"
    }
    new {
        args = 0
        anchors {
            new {
                string = "lo_txstart"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: couldn't allocate loopback ifnet (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: couldn't attach loopback ifnet (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "loopattach"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "lo_attach_proto: ifnet_attach_protocol for %u returned=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "lo_attach_proto"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "lo_input"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lo_input"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(*m)->m_flags & M_PKTHDR"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lo_pre_output"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: mbuf_set_status() failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "lo_tx_compl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifp == lo_ifp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "lo_set_bpf_tap"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifvlan_release: bad signature @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifvlan_release: retain count is 0 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ifvlan_release"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifvlan_release"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vlan_parent_release: signature is bad @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vlan_parent_release: retain count is 0 @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "vlan_parent_release"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vlan_parent_release"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vlan_parent_wait"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vlan_parent_wait"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vlan_parent_create"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: siocgifdevmtu failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "vlan_config"
        prototype = ""
        caller = "vlan_ioctl"
    }
    new {
        args = 0
        anchors {
            new {
                string = "vlan_attach_protocol"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vlan_attach_protocol"
        prototype = ""
        caller = "vlan_config"
    }
    new {
        args = 2
        anchors {
            new {
                string = "(scan->m_pkthdr.csum_flags & CSUM_VLAN_TAG_VALID) != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tag != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vlan_input"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s tag %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "vlan_input"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "vlan_input_tag"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "vlan_input_packet_list"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s VLAN tag %d (dropped)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: packets %d bytes %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "vlan_input_tag"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vlan_parent_link_event"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vlan_event"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "feth_fake_tx_exp_policy_sysctl"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: if_fake_tx_exp_policy: %u -> %u (%d)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_fake_tx_exp_policy_sysctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.feth"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "feth_register_nexus_domain_provider"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: failed to register domain provider"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "if_fake_init"
        prototype = ""
        caller = "ether_family_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "fakeif->iff_retain_count == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fakeif->iff_rx_pp == S_pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fakeif->iff_tx_pp == S_pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "feth_free"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "feth_release"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fakeif->iff_doorbell_tcall == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "feth_if_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth shared pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s rx pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s tx pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: feth used as ifname prefix but logical link support in feth is disabled."
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: TSO mode requires global packet pool mode"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: multi-buflet not supported for split rx & tx pool"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: rx pp create failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: tx pp create failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: create_non_default_llinks failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: llink add failed, error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_clone_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_connected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: connected channel %p"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_connected"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_pre_disconnect"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: pre-disconnect channel %p"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_pre_disconnect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_disconnected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: disconnected channel %p"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_disconnected"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "fakeif->iff_tx_ring[ring_idx] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fakeif->iff_tx_ring[0] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fakeif->iff_rx_ring[0] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "feth_nx_ring_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: %s ring init"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_ring_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth threadcall"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: RX ring fini"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: TX ring fini"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: thread_call_cancel %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: *waiting for threadcall"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: ^threadcall done"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: thread_call_free %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_ring_fini"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "clock_timebase.denom != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "feth_packet_has_expired"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "feth_get_effective_expn_action"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s sent expiry notification on nexus port %u notif code %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Packet has %llu usec until expiration"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Unrecognized value %d for \"net.link.fake.tx_exp_policy\""
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_tx_expired_error"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "feth_tx_complete_error"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "feth_tx_complete_error"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "baddr != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bufcnt == kern_packet_get_buflet_count(dph)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "feth_copy_packet"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_clone_packet"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: packet clone err %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_clone_packet"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_sync_rx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "feth_nx_sync_rx"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "feth_nx_tx_doorbell"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: TX refill (sync) %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: TX refilled (sync)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: schedule async refill"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_tx_doorbell"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "feth_nx_tx_dequeue_driver_managed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: TX refill ring %d (%s) %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: %s: TX refilled ring %d (%s)"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "feth_nx_tx_dequeue_driver_managed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_capab_config"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "feth_nx_capab_config"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_intf_adv_config"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s enable %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_intf_adv_config"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_notify_steering_info"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: notify_steering_info: qset_id 0x%llx, %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_notify_steering_info"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_tx_qset_notify"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s qset %p, idx %d, flags 0x%x"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s queue %p dequeue failed: err %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "feth_nx_tx_qset_notify"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "feth_nx_tx_queue_deliver_pkt_chain"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s -> %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_tx_queue_deliver_pkt_chain"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "feth_nx_queue_tx_push"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s queue %p"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "feth_nx_queue_tx_push"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.xnu.net.redirect"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "redirect_register_nexus_domain_provider"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_redirect_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "rd->rd_retain_count == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "redirect_free"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "redirect_release"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "redirect_max_mtu"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "redirect_max_mtu"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "redirect_clear_delegate_locked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "redirect_clear_delegate_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rd->rd_doorbell_tcall == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifp is NULL\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_if_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "redirect_demux"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: data is NULL\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_demux"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "redirect_attach_netif_nexus"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: create params not specified\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: copyin failed: error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: invalid type(0x%x) or len(0x%d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: functional type(0x%x) not supported\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: invalid ifc_name(%s) or unit(%d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: attach netif nexus failed: error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s packet pool make failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s register provider failed, error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s alloc net provider instance failed %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_clone_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "redirect_nx_connected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: connected channel %p\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_nx_connected"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "redirect_nx_pre_disconnect"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: pre-disconnect channel %p\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_nx_pre_disconnect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "redirect_nx_disconnected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: disconnected channel %p\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_nx_disconnected"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rd->rd_tx_ring[0] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rd->rd_rx_ring[0] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "redirect_nx_ring_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: %s ring init\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_nx_ring_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "redirect threadcall"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: RX ring fini\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: TX ring fini\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: thread_call_cancel %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: *waiting for threadcall\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: threadcall done\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s: thread_call_free %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "redirect_nx_ring_fini"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "multicast_list_program: ifnet_get_multicast_list(%s%d) failed, %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "multicast_list_program"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bond_clone_create"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: failed to add slow_proto multicast, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bond_clone_create"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifbond_release"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: removing multicast"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ifbond_release"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "bond_output"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: %s bytes %d, error=%d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bond_output"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bond_set_mtu"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bond_set_mtu"
        prototype = ""
        caller = "bond_ioctl"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifbond_wait"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifbond_wait"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bond_set_mtu_on_ports"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: SIOCSIFMTU %s failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bond_set_mtu_on_ports"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_timer_process_func"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: (timer) generating LINK event"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_timer_process_func"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bond_attach_protocol"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bond_attach_protocol"
        prototype = ""
        caller = "bond_add_interface"
    }
    new {
        args = 1
        anchors {
            new {
                string = "bond_input_packet_list"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: %s packets %d bytes %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bond_input_packet_list"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ifbond_list_find_moved_port"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bond_receive_la_marker_pdu"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: dropping short LACP frame %d < %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: m_pullup LACPDU failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: m_pullup LA_MARKER failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: %s: (receive) generating LINK event"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: simulating link status changed event"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: System %x:%x:%x:%x:%x:%x Port 0x%x moved from %s to %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "bond_input"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_receive_machine_current"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bondport_UpdateSelected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bondport_UpdateNTT"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Receive CURRENT"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] updateSelected UNSELECTED"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] updateNTT: Need To Transmit"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] recordPDU: LACP will maintain"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] recordPDU: LACP partner in sync"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] recordPDU: LACP partner in sync (ind)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_receive_machine_current"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bondport_set_selected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] SetSelected: %s (was %s)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_set_selected"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_assign_to_LAG"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Key 0x%04x: LAG Created (0x%04x,%x:%x:%x:%x:%x:%x,0x%04x)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_assign_to_LAG"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bondport_remove_from_LAG"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Removed from LAG (0x%04x,%x:%x:%x:%x:%x:%x,0x%04x)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Key 0x%04x: LAG Released (%04x,%x:%x:%x:%x:%x:%x,0x%04x)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_remove_from_LAG"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bondport_add_to_LAG"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Added to LAG (0x%04x,%x:%x:%x:%x:%x:%x0x%04x)"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_add_to_LAG"
        prototype = ""
        caller = "bondport_assign_to_LAG"
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_receive_machine_expired"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Receive EXPIRED"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_receive_machine_expired"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_receive_machine_defaulted"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Receive DEFAULTED"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_receive_machine_defaulted"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_receive_machine_lacp_disabled"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Receive LACP_DISABLED"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_receive_machine_lacp_disabled"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_receive_machine_initialize"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Receive INITIALIZE"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_receive_machine_initialize"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_mux_machine_detached"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bondport_DetachMuxFromAggregator"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Mux DETACHED"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Detached Mux From Aggregator"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_mux_machine_detached"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_mux_machine_attached"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "bondport_AttachMuxToAggregator"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Mux ATTACHED"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Attached Mux To Aggregator"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_mux_machine_attached"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bondport_mux_machine_collecting_distributing"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Mux COLLECTING_DISTRIBUTING"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_mux_machine_collecting_distributing"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bond_handle_event"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: (event) generating LINK event"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Link UP %d Mbit/s %s duplex"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Link DOWN"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Port speed %d differs from LAG %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bond_handle_event"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bondport_slow_proto_transmit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: (%s) failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_slow_proto_transmit"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "[%s] Transmit: failed to allocate packet buffer\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: [%s] Transmit Timer Already Set"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Transmit Timer Deadline %d secs"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Transmit Timer Complete"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: [%s] Transmit Packet %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_transmit_machine"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ifbond_selection"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: LAG PORT SPEED CHANGED from %d to %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ifbond_selection"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bondport_disable_distributing"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: [%s] Distribution Disabled"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bondport_disable_distributing"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "bond_set_mode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "bond_set_mode"
        prototype = ""
        caller = "bond_ioctl"
    }
    new {
        args = 1
        anchors {
            new {
                string = "bond_set_promisc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: ifnet_set_promiscuous(%s, %d): failed %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: %s: ifnet_set_promiscuous(%s, %d): succeeded"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: %s: multicast_list_program(%s) failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bond_ioctl"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "bond_if_detach"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: ifnet_detach failed, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "bond_clone_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "devtimer_set_absolute: uninitialized/freed timer\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "devtimer_set_absolute"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ndrvdomain == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ndrv_dominit"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rn_addmask: mask impossibly already in tree"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "rn_addmask"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Non-unique normal route, mask not entered"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "rn_addroute"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "rn_delete: couldn't find our annotation\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "rn_delete: couldn't find us\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
            new {
                string = "rn_delete: Orphaned Mask 0x%llx at 0x%llx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "rn_delete"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rn_init: radix functions require max_keylen be set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "radix_node"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rn_init"
        prototype = ""
        caller = "route_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "rte_debug"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rtentry"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "route_init"
        prototype = ""
        caller = "route_dinit"
    }
    new {
        args = 2
        anchors {
            new {
                string = "buf != NULL && buflen >= sizeof(*ss)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "buflen >= sa->sa_len"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "sdl->sdl_alen == size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: broken logic (sa_len %d < skip %d ) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "sa_trim"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rtm_scrub"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rtunref"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rtunref: on freed rte=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "rtunref"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "(p->rt_flags & RTF_DEAD) == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rtref"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rtref_audit: on freed rte=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "rtref"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "rt != ogwrt"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rt->rt_gwroute == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rt_set_gwroute"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "gwrt != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rt->rt_flags & (RTF_CLONING | RTF_PRCLONING)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rt_revalidate_gwroute"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "rt == gwrt && rt != hint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "route_to_gwroute"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "p_gw_saddr->sa_len <= sizeof(p_rt_ev->rt_ev_arg.rt_addr)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "route_event_enqueue_nwk_wq_entry"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: eventhandler enqueuing event of type=route_event event_code=%s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "route_event_enqueue_nwk_wq_entry"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sin6_get_embedded_ifscope"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IN6_IS_SCOPE_EMBED(&(SIN6(sa)->sin6_addr))"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sa_copy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rt %p invalid refcnt %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "!(rt->rt_flags & RTF_IFREF)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rt %p freed while in radix tree @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rt->rt_llinfo_free != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rtfree_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "rte_free: rte=%p refcnt=%d non-zero @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rte_free: rte=%p refcnt=%d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rte_free: double free rte=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rte_free: corrupted rte=%p @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "rte_free"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "SIN6(dst)->sin6_scope_id != IFSCOPE_NONE"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rtrequest delete @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rt->rt_flags & RTF_HOST"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "rtrequest: RTF_GATEWAY but no gateway @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "rtrequest_common_locked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(*ret_nrt)->rt_expire == 0 || (*ret_nrt)->rt_rmx.rmx_expire != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(*ret_nrt)->rt_expire != 0 || (*ret_nrt)->rt_rmx.rmx_expire == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: route already exists: %s->%s->%s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "rtrequest_common_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "!coarse || ifscope == IFSCOPE_NONE"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s unscoped search %p to %s->%s->%s ifa_ifp %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s %u return NULL\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s %u return %p to %s->%s->%s ifa_ifp %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "rt_lookup_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: invalid count argument (%d) @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "%s: ifp=%p negative route refcnt! @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "rte_if_ref"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "rt_key(rt)->sa_family == AF_INET"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "link#%u"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rt_str"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "evtag != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "eventhandler_deregister event_type=route_event"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "eventhandler_invoke(\"route_event\")"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "route_event_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "in->rt_expire == 0 || in->rt_rmx.rmx_expire != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "in->rt_expire != 0 || in->rt_rmx.rmx_expire == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rt_getmetrics"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "routedomain == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "route_dinit"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "out->rt_expire == 0 || out->rt_rmx.rmx_expire != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "out->rt_expire != 0 || out->rt_rmx.rmx_expire == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rt_setmetrics"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "so->so_pcb == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rts_attach"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "rp != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "rts_detach"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.netsrc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ctl_register failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netsrc_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "netsrc_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "%s: invalid family\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "netsrc_ctlsend"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "netsrc_ctlsend"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.xnu.net"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ntstat"
                segment = "__TEXT"
                section = "__cstring"
                caller = "os_log_create"
            }
            new {
                string = "com.apple.network.statistics"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nstat_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ntstat_userland_stats_open"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s - incorrect provider is supplied, %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ntstat_userland_stats_open"
        prototype = ""
        caller = "necp_stats_initialize"
    }
    new {
        args = 0
        anchors {
            new {
                string = "nstat_tcp_copy_descriptor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s - NSTAT_DEBUG_SOCKET <pid %d>: NSTAT: TCP - pid %d uid %d euuid %s persona id %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "nstat_tcp_copy_descriptor"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nstat_udp_copy_descriptor"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s - NSTAT_DEBUG_SOCKET <pid %d>: NSTAT: UDP - pid %d uid %d euuid %s persona id %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "nstat_udp_copy_descriptor"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nstat_userland_protocol_add_watcher"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nstat_userland_protocol_add_watcher"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nstat_generic_provider_add_watcher"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nstat_generic_provider_add_watcher"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nstat_generic_provider_reporting_allowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s - attempt to filter conn provider by effective pid/uuid, not supported"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "nstat_generic_provider_reporting_allowed"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "i == nkeyvals"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "i > 0 && i <= nkeyvals"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nstat_sysinfo_send_data"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "nstat_client_handle_query_request"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nstat_client_send"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nstat_flush_accumulated_msgs"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s - ctl_enqueuembuf failed: %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "nstat_flush_accumulated_msgs"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "nstat_client_cleanup_source"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "nstat_client_cleanup_source"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "tcp_progress_probe_enable_for_interface"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s - for interface index %u with flags %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s - *matched* interface index %d, enable: %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s - (%d) - nstat set tcp probe %d for interface index %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "ntstat_tcp_progress_enable"
        prototype = ""
        caller = "tcp_progress_probe_enable"
    }
    new {
        args = 0
        anchors {
            new {
                string = "gif_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "gif_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "gif_attach_proto_family can't attach interface\t\t\t    fam=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "gif_attach_proto_family"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "gif_clone_destroy: gif remove failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "gif_clone_destroy: ifnet_set_flags failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "gif_clone_destroy: ifnet_detach(%p) failed %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
        }
        symbol = "gif_clone_destroy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "gif_clone_create, ifnet_allocate failed - %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: unable to attach encap4\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: unable to attach encap6\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "gif_clone_create - ifnet_attach failed - %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "gif_clone_create"
        prototype = ""
        caller = "gif_init"
    }
    new {
        args = 0
        anchors {
            new {
                string = "gif_add_proto: request add_proto for gif%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "gif_add_proto"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "sftattach encap_attach_func failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "stfattach, ifnet_allocate failed - %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "stfattach: ifnet_attach returned error=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "stfattach"
        prototype = ""
        caller = "ip6_init_delayed"
    }
    new {
        args = 1
        anchors {
            new {
                string = "stf: IFF_DOWN\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "stf_pre_output"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "stf_attach_proto_family can't attach interface fam=%d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "stf_attach_inet6"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "stf_add_proto: stf already has a proto\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "stf_add_proto"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "defer encapsulated ESP matching"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: called PKTF_WAKE_PKT not set from %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copydata(ip) error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: unexpected IPv4 protocol %u from %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copydata(ip6_hdr) error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: mbuf_copydata(ip6_frag) error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: unexpected IPv6 protocol %u from %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: unexpected protocol family %d from %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "if_ports_used_match_mbuf"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "TAILQ_EMPTY(&net_port_entry_hash_table[i])"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: IOPMCopySleepWakeUUIDKey got bad value %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: SleepWakeUUID not set, don't update the port list for %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: current wakeuuid %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "if_ports_used_update_wakeuuid"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: SYSCTL_OUT(xnpigen) error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: SYSCTL_OUT(npi) error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "sysctl_net_port_info_list"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: ifnet_get_local_ports_extended() error %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "sysctl_get_ports_used"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "sysctl_get_ports_used"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "is_encapsulated_esp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: mbuf_copydata(ESP_HDR_SIZE) error %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "is_encapsulated_esp"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "wake packet match"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "wake packet no match"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "net_port_info_find_match"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "already notified wake packet"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "if_notify_wake_packet"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "if_notify_unattributed_wake_mbuf"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: mbuf_copydata() failed with error %d for wake uuid %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "if_notify_unattributed_wake_mbuf"
        prototype = ""
        caller = "if_ports_used_match_mbuf"
    }
    new {
        args = 0
        anchors {
            new {
                string = "if_notify_unattributed_wake_pkt"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: receive interface is NULL"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "if_notify_unattributed_wake_pkt"
        prototype = ""
        caller = "if_ports_used_match_pkt"
    }
    new {
        args = 0
        anchors {
            new {
                string = "if_set_low_power"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifp %s low_power mode %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ifnet_set_low_power_mode"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "if_low_power_evhdlr_callback"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: ifp %s event_code %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "if_low_power_evhdlr_callback"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "!(einit.flags & IFNET_INIT_LEGACY) || (ifp->if_pre_enqueue == NULL && ifp->if_start == NULL && ifp->if_output_ctl == NULL && ifp->if_input_poll == NULL && ifp->if_input_ctl == NULL)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!(einit.flags & IFNET_INIT_INPUT_POLL) || (ifp->if_input_poll != NULL && ifp->if_input_ctl != NULL)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!(einit.flags & IFNET_INIT_LEGACY)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(ifp->if_xflags & IFXF_LEGACY) == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_allocate_extended"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "err == 0 || *addresses == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "return_inuse_addrs == 1"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_get_address_list_family_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: already a cloner for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: if_clone_attach failed %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_clone_attach"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: no cloner for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ifnet_clone_detach"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_clone_detach"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: delegating to %s would cause a loop\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: is now delegating %s (type 0x%x, family %u, sub-family %u)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: is no longer delegating %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
        }
        symbol = "ifnet_set_delegate"
        prototype = ""
        caller = ""
    }
    new {
        args = 4
        anchors {
            new {
                string = "*used_frames_count <= frames_array_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ifnet_get_keepalive_offload_frames"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: set offload flags=0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "log"
            }
        }
        symbol = "ifnet_set_offload_common"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.net.utun_control"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_register_nexus"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_register_control - ctl_register failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_register_control - proto_register_plumber(PF_INET, IFNET_FAMILY_UTUN) failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_register_control - proto_register_plumber(PF_INET6, IFNET_FAMILY_UTUN) failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "utun_register_control"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 3
        anchors {
            new {
                string = "utun%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utunid%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_flowswitch_attach - ifnet_detach failed: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "utun_ctl_connect - utun_nexus_ifattach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_ctl_connect - utun_flowswitch_attach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_ctl_connect - ifnet_allocate failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_ctl_connect - ifnet_attach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_flowswitch_attach - flowswitch is NULL\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_flowswitch_attach - unable to find flowswitch nexus\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "utun_ctl_connect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_start"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_start: ctl_getenqueuepacketcount returned error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "utun_start: ifnet_disable_output returned error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "utun_start"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_data_move_drain"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->utun_pcb_drainers > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "utun_wait_data_move_drain"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pcb->utun_netif_rxring == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->utun_netif_txring == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "utun_netif_ring_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_netif_sync_tx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tx_offset >= UTUN_HEADER_SIZE(pcb)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_netif_sync_tx %s: unknown ip version %u vhl %u tx_offset %u len %u header_size %zu\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "utun_netif_sync_tx %s - mbuf_copyback(%zu) error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "utun_netif_sync_tx %s - mbuf_gethdr error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "utun_netif_sync_tx %s - 0 length packet\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "utun_netif_sync_tx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_netif_sync_rx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_netif_sync_rx %s: legacy packet length too short for header %zu < %zu\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "utun_netif_sync_rx %s: legacy packet length %zu > %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "utun_netif_sync_rx %s: packet length too short for header %u < %zu\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "utun_netif_sync_rx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_nexus_detach"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "utun_nexus_detach"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "utun_ctl_disconnect - ifnet_detach failed: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "utun_ctl_disconnect - ifnet_detach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "utun_ctl_disconnect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_ctl_send"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s - unexpected short mbuf pkt len %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s - ifnet_input failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "utun_ctl_send"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_ncd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_enable_channel"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "uuid_is_null(pcb->utun_kpipe_uuid)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "utun_enable_channel"
        prototype = ""
        caller = "utun_ctl_setopt"
    }
    new {
        args = 0
        anchors {
            new {
                string = "pcb->utun_kpipe_rxring == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->utun_kpipe_txring == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "utun_kpipe_ring_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_kpipe_sync_tx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "utun_kpipe_sync_tx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "utun_kpipe_sync_rx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "tx_baddr != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mb_cnt <= avail"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mb_cnt == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "utun_kpipe_sync_rx %s: invalid length %zu header_size %zu\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "utun_kpipe_sync_rx %s: unknown ip version %u vhl %u header_size %zu\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "utun_kpipe_sync_rx: ifnet_enable_output returned error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "utun_kpipe_sync_rx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "uuid_is_null(pcb->utun_kpipe_uuid) == !enabled"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "utun_disable_channel"
        prototype = ""
        caller = "utun_ctl_setopt"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.net.ipsec_control"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_register_nexus"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_register_control - ctl_register failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_register_control - proto_register_plumber(PF_INET, IFNET_FAMILY_IPSEC) failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_register_control - proto_register_plumber(PF_INET6, IFNET_FAMILY_IPSEC) failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ipsec_register_control"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipsec_inject_inbound_packet"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_inject_inbound_packet"
        prototype = ""
        caller = ""
    }
    new {
        args = 3
        anchors {
            new {
                string = "ipsec%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsecid%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s%d use_netif %d kpipe_count %d slot_size %u ring_size %u kpipe_tx_ring_size %u kpipe_rx_ring_size %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!ipsec_flag_isset(pcb, IPSEC_FLAGS_KPIPE_ALLOCATED)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_ncd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_nexus_ifattach"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_flowswitch_attach - ifnet_detach failed: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "ipsec_ctl_connect: creating interface %s (id %s)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_ctl_connect - kpipe requires netif: failed %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s failed to enable channels\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_ctl_connect - ipsec_nexus_ifattach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_ctl_connect - ipsec_flowswitch_attach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_ctl_connect - ifnet_allocate failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_ctl_connect - ifnet_attach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s failed to register kernel pipe nexus\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s pbufbool create failed, error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s enabling wmm mode\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_flowswitch_attach - flowswitch is NULL\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_flowswitch_attach - unable to find flowswitch nexus\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ipsec_ctl_connect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pcb->ipsec_kpipe_count != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_ipsec_nexus_pre_disconnect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipsec_data_move_drain"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->ipsec_pcb_drainers > 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_wait_data_move_drain"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipsec_kpipe_ring_init"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->ipsec_kpipe_rxring[ring_idx] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->ipsec_kpipe_txring[ring_idx] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s cannot find channel %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ipsec_kpipe_ring_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipsec_kpipe_sync_tx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_kpipe_sync_tx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ring_idx <= pcb->ipsec_kpipe_count"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "interface != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dph != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s ring %s index %d no room in rx_ring\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s ring %s index %d bad netif_txring 1\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s ring %s index %d bad netif_txring 2\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_kpipe_sync_rx %s: failed to allocate packet\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_kpipe_sync_rx %s: packet length %zu"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_kpipe_sync_rx %s: failed to encrypt packet"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_kpipe_sync_rx: ifnet_enable_output returned error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec encrypt kpipe pkt: source buffer shorter than ip header, %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec4 interface kpipe output error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec6 interface kpipe output error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "received unknown packet version: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "ipsec_kpipe_sync_rx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "pcb->ipsec_netif_rxring[0] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->ipsec_netif_txring[ring_idx] == NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_netif_ring_init"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "!found"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_netif_ring_fini"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipsec_netif_sync_tx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ring_idx < IPSEC_IF_MAX_RING_COUNT"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_netif_sync_tx %s - failed policy check\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_netif_sync_tx %s - ipsec_output error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_netif_sync_tx %s - mbuf_copyback(%zu) error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_netif_sync_tx %s - mbuf_gethdr error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_netif_sync_tx %s - 0 length packet\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_netif_sync_tx %s: no encrypted packet to send\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ipsec_netif_sync_tx"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipsec_netif_sync_rx"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fragment_chain != fragment_chain->m_nextpkt"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netif_ph != 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "kpipe_buf != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "netif_buf != NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_netif_sync_rx %s: legacy decrypted packet length cannot hold IP %zu < %zu\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_netif_sync_rx %s: legacy unknown ip version %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_netif_sync_rx %s: failed to fragment IPv4 packet of length %zu (%d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_netif_sync_rx %s: failed to fragment IPv6 packet of length %zu < %zu\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_netif_sync_rx %s: failed to fragment IPv6 packet of length %zu (%d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_netif_sync_rx %s: uknown legacy decrypted packet length %zu > %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_transform_kpipe_pkt_to_netif_pkt %s: kpipe buffer length %u > pcb ipsec slot size %u"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_transform_kpipe_pkt_to_netif_pkt %s - bad ip version %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_transform_kpipe_pkt_to_netif_pkt %s - netif buffer length %u too short\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "ipsec_transform_kpipe_pkt_to_netif_pkt %s: wake packet flag is set\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "ipsec_netif_sync_rx"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "ipsec_netif_tx_doorbell"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_netif_tx_doorbell"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "(flags & KERN_NEXUS_TXDOORBELLF_ASYNC_REFILL) == 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s ring %s tx refill failed %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: %s ring %s index %d bad netif_txring 3\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "ipsec_netif_tx_doorbell: ifnet_disable_output returned error %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ipsec_netif_tx_doorbell_one"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ipsec_nexus_detach"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_nexus_detach"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "ipsec_ctl_disconnect: detaching interface %s (id %s)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "ipsec_ctl_disconnect - ifnet_detach failed: %d @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "panic"
            }
            new {
                string = "dc->count >= 0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dc->count <= IPSEC_IF_MAX_RING_COUNT"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!uuid_is_null(pcb->ipsec_kpipe_uuid[i])"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "pcb->ipsec_kpipe_pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!pcb->ipsec_kpipe_pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ipsec_ctl_disconnect - ifnet_detach failed: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ipsec_ctl_disconnect"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "!result"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dc->pp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ipsec_free_channels"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: IPSEC_OPT_SLOT_SIZE %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: IPSEC_OPT_NETIF_RING_SIZE %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: IPSEC_OPT_TX_FSW_RING_SIZE %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "printf"
            }
            new {
                string = "%s: IPSEC_OPT_KPIPE_TX_RING_SIZE %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: IPSEC_OPT_KPIPE_RX_RING_SIZE %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s IPSEC_OPT_SET_DELEGATE_INTERFACE %s to %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s IPSEC_OPT_OUTPUT_TRAFFIC_CLASS %s svc %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s IPSEC_OPT_OUTPUT_DSCP_MAPPING %s DSCP %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "ipsec_ctl_setopt"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Only platform-signed binaries can open NECP sessions"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Process does not hold necessary entitlement to open NECP session"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_create_session"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Created NECP session, control unit %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_session_open"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.xnu.net.necp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp-data-trace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_init"
        prototype = ""
        caller = "bsd_init"
    }
    new {
        args = 1
        anchors {
            new {
                string = "euuid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RESULT - Loopback PASS <NO MATCH>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RESULT - DROP <NO CLIENT / MULTICAST>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_application_find_policy_match_internal"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "RESULT - Loopback PASS"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RESULT - Inactive Agent DROP"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "socket unscoped for PASS result"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "FLOW DIVERT <ROUTE RULE>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "socket unscoped for <NO MATCH>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RESULT - DROP <MISSING CLIENT>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy - INP UPDATE - RESULT - CACHED <MATCHED>: %p (BoundInterface %d Proto %d) Policy %d Result %d Parameter %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Marking socket in state %d as defunct\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy: <so %llx> (BoundInterface %d Proto %d) Policy %d Skip %d Result %d Parameter %d Filter %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_socket_find_policy_match"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_mark_packet_from_socket"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "START - MARK PACKET"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RESULT - MARK PACKET"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_mark_packet_from_socket"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_policy_apply_all"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Applied NECP policies"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_policy_delete"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Removed NECP policy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP Application Policies:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP Socket Policies:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_kernel_ip_output_policies_dump_all"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP IP Output Policies:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: \tApp Bucket: %d\n\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s:  ID Bucket: %d\n\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: \t%3d. Policy ID: %5d\tProcess: %10.10s\tOrder: %04d.%04d.%d\tMask: %llx\tResult: %s\n\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "necp_policy_apply_all"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Error applying socket kernel policy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_get_new_string_id"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to find a free route rule id.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Allocate route rule ID failed.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_kernel_socket_policy_add"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to find a free socket kernel policy ID.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Added kernel policy: socket, id=%d, mask=%llx\n\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_policy_apply"
        prototype = ""
        caller = "necp_policy_apply_all"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Failed to find a free service UUID.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Allocate uuid ID failed.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_get_new_uuid_id"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Failed to find a free aggregate route rule id.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_create_aggregate_route_rule"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Failed to find a free IP kernel policy ID.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_kernel_ip_output_policy_add"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Added kernel policy: ip output, id=%d, mask=%llx\n\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_kernel_ip_output_policy_add"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Pass (%X)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Skip (%u)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Drop (%X)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "SocketDivert (%d)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "SocketFilter (%d)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IPTunnel (%s%d)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "IPFilter"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "SocketScoped (%s%d)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ScopedDirect"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AllowUnentitled"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RouteRules (Only %s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RouteRules (%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!Cell "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!WiFi "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!Wired "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!Exp "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!Constrained "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!Companion "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "!VPN "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RouteRules (QoSMarking %s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RouteRules (Unknown)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "UseNetAgent (%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NetAgentScoped (%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "RemoveNetAgent (%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unknown %d (%d)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_get_result_description"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_delete_session"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Deleted NECP session"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_session_op_close"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Failed to validate policy result"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Route rules size overflowed, too large"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to get policy route rules"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to validate policy route rule"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to validate route rule; contained multiple default route rules"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Conditions size overflowed, too large"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to get policy conditions"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to validate policy condition"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to validate conditions; contained default and non-default conditions"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to validate conditions; did not contain application condition"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to validate conditions; kernel pid (0) condition allows only Pass/Skip result"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: necp_session_add_policy invalid input (%zu)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: necp_session_add_policy invalid output buffer (%zu)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: necp_session_add_policy tlv copyin error (%d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: necp_session_add_policy failed to add policy (%d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: necp_session_add_policy policy_id copyout error (%d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to get policy order: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to find policy result TLV: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to get policy result length: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Policy result length too large: %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to allocate a policy result buffer (size %d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to get policy result: %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Route rules length too large: %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to allocate a policy route rules array (size %d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Conditions length too large: %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to allocate a policy conditions array (size %d)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_session_add_policy"
        prototype = ""
        caller = "necp_session_action"
    }
    new {
        args = 1
        anchors {
            new {
                string = "necp_get_tlv_at_offset buffer is NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_get_tlv_at_offset tlv_value is NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: necp_get_tlv_at_offset buffer_length is too small for TLV (%u < %lu)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: necp_get_tlv_at_offset buffer_length is too small for TLV of length %u (%u < %lu)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: necp_get_tlv_at_offset out_buffer_length is too small for TLV value (%u < %u)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_get_tlv_at_offset"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_policy_result_is_valid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Policy result type %d, valid %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_policy_result_is_valid"
        prototype = ""
        caller = "necp_session_add_policy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_policy_route_rule_is_valid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Policy route rule type %d, valid %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_policy_route_rule_is_valid"
        prototype = ""
        caller = "necp_session_add_policy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_policy_condition_is_valid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Policy condition type %d, valid %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_policy_condition_is_valid"
        prototype = ""
        caller = "necp_session_add_policy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_policy_create"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Created NECP policy, order %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_policy_create"
        prototype = ""
        caller = "necp_session_add_policy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_session_dump_all"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Session does not hold the necessary entitlement to get Network Extension Policy information"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Gathering policies"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: necp_session_dump_all invalid output buffer (%zu)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to allocate tlv_buffer_pointers (%lu bytes)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to allocate tlv_buffer_lengths (%lu bytes)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Policy: process: %s, result: %s\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: Failed to allocate tlv_buffer (%u bytes)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: Failed to allocate cond_buffer (%u bytes)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: out_buffer_length too small (%lu < %lu)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to allocate result_buffer (%lu bytes)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: Failed to copy out result_buffer (%lu bytes)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_session_dump_all"
        prototype = ""
        caller = "necp_session_action"
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_get_new_domain_filter_id"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed to find a free filter ID.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_create_domain_filter"
        prototype = ""
        caller = "necp_session_add_domain_filter"
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.configd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.necp.drop_all_bypass"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "necp_check_drop_all_bypass_result"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.developer.networking.multicast"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "necp_check_restricted_multicast_drop"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Dropping unentitled multicast (SDK 0x%x, min 0x%x)\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "necp_check_restricted_multicast_drop"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "RESULT - DROP - (session order > drop-all order)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "SKIP (cleared saved skip)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Scope"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_APP_ID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_SIGNING_IDENTIFIER"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "<n/a>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_REAL_APP_ID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_PLATFORM_BINARY"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_EXACT_DOMAIN"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_DOMAIN"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_URL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_ACCOUNT_ID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_PID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_UID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_REAL_UID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_TRAFFIC_CLASS"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_AGENT_TYPE"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_CLIENT_FLAGS"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_LOCAL_EMPTY"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_REMOTE_EMPTY"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_IS_LOOPBACK"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NECP_KERNEL_CONDITION_DELEGATE_IS_PLATFORM_BINARY"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy <so %llx>: (Application %d Real Application %d BoundInterface %d Proto %d) Filter %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy <so %llx>: (Application %d Real Application %d BoundInterface %d Proto %d) Route Rule %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy <so %llx>: (Application %d Real Application %d BoundInterface %d Proto %d) %s Netagent %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy <so %llx>: (Application %d Real Application %d BoundInterface %d Proto %d) Remove Netagent %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy <so %llx>: (Application %d Real Application %d BoundInterface %d Proto %d) flow divert %u\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy <so %llx>: MATCHED SKIP POLICY (Application %d Real Application %d BoundInterface %d Proto %d) set skip_policy_id %d\n"
                segment = "__TEXT"
                section = "__os_log"
                caller = "_os_log_internal"
            }
        }
        symbol = "necp_socket_find_policy_match_with_info_locked"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "necp_socket_verify_netagents"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: DATA-TRACE: Socket Policy: <so %llx> Triggering inactive agent (%d), error %d\n"
                segment = "__TEXT"
                section = "__os_log"