amends "../../pkl/Symbolicator.pkl"

// MIT License
//
// Copyright (c) 2024 blacktop
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

target = "com.apple.driver.AppleMobileFileIntegrity"

total = 315

version {
    max = "24.0.0"
    min = "24.0.0"
}

signatures {
    new {
        args = 0
        anchors {
            new {
                string = "Failed to allocate vnode attr"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Failed to allocate vfs context\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Failed to get flags for file\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z19vnode_is_restrictedP5vnode"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ReadFileWrapper: failed to allocate vfs context\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN15ReadFileWrapperC2Ev"
        prototype = ""
        caller = "__ZN3ctulsERNS_16LogMessageBufferEi"
    }
    new {
        args = 1
        anchors {
            new {
                string = "ReadFileWrapper::open failed (errno %d) %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN15ReadFileWrapper4openEPKc"
        prototype = ""
        caller = "__ZN3ctulsERNS_16LogMessageBufferEi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ReadFileWrapper::fileSize error, no file\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "ReadFileWrapper::fileSize error failed to allocate vnode_attr\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "ReadFileWrapper::fileSize error failed to get file attributes (errno: %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "ReadFileWrapper::fileSize error, file too big %lld"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN15ReadFileWrapper8fileSizeEb"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ReadFileWrapper::readFile, file size error\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "ReadFileWrapper::readFile, buffer too small got: %zu expected %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "ReadFileWrapper::readFile, error reading file %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "ReadFileWrapper::readFile, stalled while reading\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN15ReadFileWrapper8readFileEPvmPm"
        prototype = ""
        caller = "__ZL16getExceptionListv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AppleMobileFileIntegrityUserClient"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__GLOBAL__sub_I_AppleIOP.cpp"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: unrecognized method selector %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "virtual IOReturn AppleMobileFileIntegrityUserClient::externalMethod(uint32_t, IOExternalMethodArguments *, IOExternalMethodDispatch *, OSObject *, void *)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient14externalMethodEjP25IOExternalMethodArgumentsP24IOExternalMethodDispatchP8OSObjectPv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.amfi.can-set-denylist"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: failure getting can set denylist entitlement for process %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: process %d not allowed to set denylist\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "copyPackedData failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Invalid denylist\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Entry count is too large, failing: %lld\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Unable to allocate %llu bytes\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Memory prepare failed: 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Invalid data length: %lld entries, %u bytes\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient11setDenylistEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: prepare failed: 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient32copyTrustCacheFromInputArgumentsEP25IOExternalMethodArgumentsPPvPy"
        prototype = ""
        caller = "__ZN34AppleMobileFileIntegrityUserClient14loadTrustCacheEP8OSObjectPvP25IOExternalMethodArguments"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: short input: %zu < %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: blob too large: %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: prepare failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: total length overflow: %zu != %zu + %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: data length overflow: %zu (= %zu + %zu)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: expected length overflow: %zu (total len %zu + %zu)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: short input data: %zu < %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient42copyTrustCacheAndManifestFromInputArgumentEP25IOExternalMethodArgumentsPPvPyS3_S4_S3_S4_"
        prototype = ""
        caller = "__ZN34AppleMobileFileIntegrityUserClient14loadTrustCacheEP8OSObjectPvP25IOExternalMethodArguments"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: PID %d is requesting a trust cache load\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "static IOReturn AppleMobileFileIntegrityUserClient::loadTrustCache(OSObject *, void *, IOExternalMethodArguments *)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Enforcement disabled, allowing trust cache load by process %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: copyTrustCacheFromInputArguments failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: copyTrustCacheAndManifestFromInputArgument failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: invalid load trust cache selector %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient14loadTrustCacheEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: only allowed process can modify the jit trust cache\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient24loadJitCodeDirectoryHashEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.amfi.can-load-cdhash"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: only allowed process can modify the compilation service trust cache\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient39loadCompilationServiceCodeDirectoryHashEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: Skipping entitlement check for macOS\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: Process %d is checking if a cdhash is in the trust cache\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: Returning IOReturn 0x%x to process %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient20isCdhashInTrustCacheEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.amfi.set-permissive"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: process not allowed to set permissive mode\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient19setPermissiveTCModeEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: armSecurityBootMode: invalid scalarInput\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: armSecurityBootMode: invalid scalarInputCount\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient19armSecurityBootModeEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.amfi.garbage-collect-profiles"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOCurrentTaskHasEntitlement"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient25garbageCollectXNUProfilesEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: completeSecurityBootMode: invalid scalarInput\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: completeSecurityBootMode: invalid scalarInputCount\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN34AppleMobileFileIntegrityUserClient24completeSecurityBootModeEP8OSObjectPvP25IOExternalMethodArguments"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"Failed to add encyclopedia to MetaEncyclopedia\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "MetaEncyclopedia.cpp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN16MetaEncyclopedia15addEncyclopediaEP28MetaEncyclopediaItemProtocol.cold.1"
        prototype = ""
        caller = "__ZN16MetaEncyclopedia15addEncyclopediaEP28MetaEncyclopediaItemProtocol"
    }
    new {
        args = 0
        anchors {
            new {
                string = "No Process"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN15ProcessAccessor4nameEv"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "is-init-proc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN15ProcessAccessor20resolveFactIfPresentE8CEBufferPb"
        prototype = ""
        caller = "__ZThn88_N15ProcessAccessor20resolveFactIfPresentE8CEBufferPb"
    }
    new {
        args = 0
        anchors {
            new {
                string = "trustedKeys"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSSymbol17withCStringNoCopyEPKc"
            }
            new {
                string = "SIVersion"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSSymbol17withCStringNoCopyEPKc"
            }
            new {
                string = "KeyType"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSSymbol17withCStringNoCopyEPKc"
            }
            new {
                string = "KeyData"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSSymbol17withCStringNoCopyEPKc"
            }
            new {
                string = "digestTypes"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSSymbol17withCStringNoCopyEPKc"
            }
        }
        symbol = "AGXG16P_InitFunc_40"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFILoadTrustedKeysFromNVRam: failed getting NVRAM\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: no nvram variable\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: xml %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
            new {
                string = "No trusted keys found\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "There is no trusted keys in NVRAM\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
            new {
                string = "<name>"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: key kKeyName is missing from entry: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: key kKeyPlatform is missing from entry: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: key kKeySIVersion is missing from entry: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: key kKeySID is missing from entry: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: key kKeyKeyType is missing from entry: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: key kKeyKeyData is missing from entry: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFILoadTrustedKeysFromNVRam: key kKeyDigestTypes is missing from entry: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
            new {
                string = "AMFITrustedKeys"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_AMFILoadTrustedKeysFromNVRam"
        prototype = ""
        caller = "_CMSSetupTrustedKeys"
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.private.set-launch-type.internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN16LaunchTypePolicy20appleInternalAllowedER11SystemFactsR15ProcessAccessor"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Caller provided a disallowed launch type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN16LaunchTypePolicy20disallowedLaunchTypeER23LaunchConstraintError_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: Unknown Launch Type: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z19policyForLaunchType16cs_launch_type_t"
        prototype = ""
        caller = "__ZN22LaunchConstraintPolicyC2ER15ProcessAccessorS1_S1_R11SystemFactsR11LaunchFacts"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: NVRAM service not available"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFIInMobileObliterationPhase"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "oblit-inprogress"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z29AMFIInMobileObliterationPhasePb"
        prototype = ""
        caller = "__Z42AMFIInitializeLocalSigningPublicKey_ThreadPvi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: not capturing mobile obliteration state\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN10SimpleEvalD0Ev"
        prototype = ""
        caller = "__Z29AMFIInMobileObliterationPhasePb"
    }
    new {
        args = 0
        anchors {
            new {
                string = "/arm-io/sep/iop-sep-nub/xART"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__img4_xnu_device_tree_available"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: calling %s without xART storage support\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "AMFIProtectedDataAvailable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z26AMFIProtectedDataAvailablev.cold.4"
        prototype = ""
        caller = "__Z26AMFIProtectedDataAvailablev"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: no chosen device tree node!\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "ux_handler_setup.cold.1"
        prototype = ""
        caller = "__Z26AMFIProtectedDataAvailablev"
    }
    new {
        args = 0
        anchors {
            new {
                string = "protected-data-access"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z26AMFIProtectedDataAvailablev"
        prototype = ""
        caller = "__Z42AMFIInitializeLocalSigningPublicKey_ThreadPvi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: no protected-data-access device tree node!\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN18IOAVVideoInterface28createAUPPacketAsyncOccurredEP20IOAVAsyncEventSource.cold.2_0"
        prototype = ""
        caller = "__Z26AMFIProtectedDataAvailablev"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: protected-data-access has unexpected size (%u)!\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__Z26AMFIProtectedDataAvailablev.cold.3"
        prototype = ""
        caller = "__Z26AMFIProtectedDataAvailablev"
    }
    new {
        args = 0
        anchors {
            new {
                string = "-restore"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: unable to obtain AKS services\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: disabling local signing due to AKS error: %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: unable to obtain local signing public key from AKS: %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: disabling local signing due to key length: %lu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: disabling local signing due to allow3rdParty = false\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: disabling local signing due to restore environment\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: disabling local signing due to no protected data access\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: disabling local signing due to failed MO query: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: disabling local signing due to mobile obliteration\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z42AMFIInitializeLocalSigningPublicKey_ThreadPvi"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: %s: platform shouldn\\'t require keeping local signing private key in daemon\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__Z29AMFIGetLocalSigningPrivateKeyPh.cold.1"
        prototype = ""
        caller = "__Z29AMFIGetLocalSigningPrivateKeyPh"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: local signing public key not available with daemon\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z28AMFIGetLocalSigningPublicKeyv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: unexpectedly failed to obtain AKS services\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN29AppleConvergedIPCRTIInterface5startEP9IOService.cold.2"
        prototype = ""
        caller = "__Z42AMFIInitializeLocalSigningPublicKey_ThreadPvi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Constraint not matched"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z21constraintIsSatisfiedRN3TLE12EncyclopediaEP14CEQueryContextR23LaunchConstraintError_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Setting up notifier for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s::%s CoreAnalyticsmatchingDict is null\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "initCoreAnalyticsService"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CoreAnalyticsHub"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN24AppleMobileFileIntegrity24initCoreAnalyticsServiceEv"
        prototype = ""
        caller = "__ZN24AppleMobileFileIntegrity5startEP9IOService"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Failed to cast CoreAnalyticsHub"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN24AppleMobileFileIntegrity26attachCoreAnalyticsServiceEPvP9IOServiceP10IONotifier"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "AMFI: '%s': disallowed value for entitlement: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': disallowed entitlement key: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
        }
        symbol = "__Z31entitlementAllowedByConstraintsPK24entitlement_constraint_tPKcP8OSObjectS3_"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: CC_Self: Unknown Constraint category: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z36selfRequirementForConstraintCategory20ConstraintCategory_tR14CEQueryContext"
        prototype = ""
        caller = "__Z26evaluateConstraintCategory20ConstraintCategory_t24LCConstraintIdentifier_tR16MetaEncyclopediaS2_S2_R23LaunchConstraintError_t"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: CC_Parent: Unknown Constraint category: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z38parentRequirementForConstraintCategory20ConstraintCategory_tR14CEQueryContext"
        prototype = ""
        caller = "__Z26evaluateConstraintCategory20ConstraintCategory_t24LCConstraintIdentifier_tR16MetaEncyclopediaS2_S2_R23LaunchConstraintError_t"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: CC_Responsible: Unknown Constraint category: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z43responsibleRequirementForConstraintCategory20ConstraintCategory_tR14CEQueryContext"
        prototype = ""
        caller = "__Z26evaluateConstraintCategory20ConstraintCategory_t24LCConstraintIdentifier_tR16MetaEncyclopediaS2_S2_R23LaunchConstraintError_t"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"Should not reach here, uncategorized constraint category: %d\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__Z29isConstraintCategoryEnforcing20ConstraintCategory_t.cold.1"
        prototype = ""
        caller = "__Z29isConstraintCategoryEnforcing20ConstraintCategory_t"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"Constraint array failed to validate\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL25contextForConstraintArrayPKhm.cold.2"
        prototype = ""
        caller = "__ZL25contextForConstraintArrayPKhm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "amfi-allows-trust-cache-load"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: amfi-allows-trust-cache-load has unexpected size (%u).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z20initTrustCacheAccessv"
        prototype = ""
        caller = "__ZL35_initializeAppleMobileFileIntegrityv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: unable to extract img4 module: 0x%02X | 0x%02X | %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "trustCacheIsDuplicateImg4"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL25trustCacheIsDuplicateImg4PKhm"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: Unknown hash type %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "slotHashSize"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN22AbstractCSBlobAccessor12slotHashSizeEv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "signing-identifier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "validation-category"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "entitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "team-identifier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "team-identifier-for-current-process"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "info-plist-hash"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "in-tc-with-constraint-category"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cdhash"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "platform-identifier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "is-main-binary"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN22AbstractCSBlobAccessor20resolveFactIfPresentE8CEBufferPb"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "AMFI: file (%s) contains an invalid launch constraint on in slot %d, ignoring\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: file (%s) failed to parse a launch constraint on in slot %d (%s), ignoring\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN22AbstractCSBlobAccessor12embeddedLWCREj"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "CSBlobAccessor.cpp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "ureadc.cold.1"
        prototype = ""
        caller = "__ZN22AbstractCSBlobAccessor12embeddedLWCREj"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: failed to allocate memory for synthesized entitlements dictionary\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z19checkDebuggerStatusPP14OSEntitlementsPjP7cs_blobb"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.security.get-movable-control-port"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z35macos_task_get_movable_control_portP5ucred"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "<no identity>"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSString17withCStringNoCopyEPKc"
            }
            new {
                string = "com.apple.system-task-ports.inspect"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.system-task-ports.inspect.safe"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.system-task-ports.read.safe"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "internal.com.apple.system-task-ports.control"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.security.cs.debugger.read.root"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macOSTaskPolicy: (%s) may not get the task %s port of (%s) (pid: %d): requester has com.apple.system-task-ports.control but (%s) is not root and (%s) is not get-task-allow\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macOSTaskPolicy: (%s) may not get the task %s port of (%s) (pid: %d): SIP is off but (%s) is not root, (%s) is not get-task-allow and (%s) is not a declared debugger(%s) is%s a declared read-only debugger\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macOSTaskPolicy: (%s) may not get the kernel task %s port: SIP is on and (%s) is not entitled\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "macOSTaskPolicy: (%s) may not get the task %s port of (%s) (pid: %d): the system is Apple Internal, (%s) is%s restricted, (%s) is not root and (%s) is%s a declared debugger(%s) is%s a declared read-only debugger\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macOSTaskPolicy%s: (%s) may not get the task %s port of (%s) (pid: %d): (%s) is not hardened and not restricted but (%s) is not root, (%s) is not get-task-allow, (%s) is not a declared debugger(%s) is%s a declared read-only debugger\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macOSTaskPolicy%s: (%s) may not get the task %s port of (%s) (pid: %d): (%s) is restricted\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macOSTaskPolicy%s: (%s) may not get the task %s port of (%s) (pid: %d): (%s) is hardened, (%s) %s get-task-allow, (%s) is%s a declared debugger(%s) is%s a declared read-only debugger\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "doesn't have"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macOSTaskPolicy: (%s) allowed to get the task %s port of (%s) (pid: %d) due to unrestricted debugging. This will not work on a customer build.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "macOSTaskPolicy: (%s) is allowed to get the task %s port of (%s) (pid: %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "com.apple.plockstat"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_strcmp"
            }
            new {
                string = "com.apple.dtrace"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z17macos_task_policyP5ucredP10proc_identj"
        prototype = ""
        caller = "__Z25macos_task_control_policyP5ucredP10proc_ident"
    }
    new {
        args = 0
        anchors {
            new {
                string = "macOSTaskPolicy: (%s) (pid: %d) not (yet) allowed to go invalid\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z31macos_proc_check_run_cs_invalidP4proc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "macOSTaskPolicy: (verbose) System State (Apple Internal: %d, SIP OFF: %d), Requester State (Root: %d, Entitled: %d, Safe: %d, Apple Debugger: %d, Root Debugger: %d, Third Party Debugger: %d), Target State (get-task-allow: %d, restricted: %d, not hardened: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL20_log_failure_verboseP24amfi_task_policy_state_t"
        prototype = ""
        caller = "__Z17macos_task_policyP5ucredP10proc_identj"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.amfi.tle_violation.v2"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSString17withCStringNoCopyEPKc"
            }
            new {
                string = "constraint_identifier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set constraint identifier in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "process_identifier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set process identifier in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "match_result"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set match result in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "error_code"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set error code in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "error_msg"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set error message in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "curr_validation_category"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set launching process validation category in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "curr_path"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set launching process path in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "launch_type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set launch type in the tle violation event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "fail_validation_category"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fail_path"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z39submitLaunchConstraintViolationAnalyticR23LaunchConstraintError_tR15ProcessAccessorS2_R11LaunchFacts"
        prototype = ""
        caller = "__ZN22LaunchConstraintPolicy13handleFailureER23LaunchConstraintError_tPPcPm"
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.tle.constraints.usage"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSString17withCStringNoCopyEPKc"
            }
            new {
                string = "validation_category"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set validation category in the tle usage event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "signing_identifier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set signing identifier in the tle usage event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "team_identifier"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set team identifier in the tle usage event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "constraint_type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to set constraint type in the tle usage event payload"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z40submitEnvironmentConstraintUsageAnalytic19TLEConstraintType_tR15ProcessAccessor"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: key_hash_len (%zu) is too small (required: %d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "supplementalGetPublicKeyHash"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z28supplementalGetPublicKeyHashPhm"
        prototype = ""
        caller = "__ZL15_policy_syscallP4prociy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: signature_len %zu is too small (required %zu)/n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: unable to obtain AKS services for checking unlock state, failing.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z29supplementalGenerateSignaturePhmS_m"
        prototype = ""
        caller = "__ZL15_policy_syscallP4prociy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: supplied signature is too small %zu expected larger than %lu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: invalid signature size expected: %zu actual: %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: failed to import public key: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: error verifying signature: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: signature is not valid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z27supplementalVerifySignaturePKhmPhmPb"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: entitlements present on supplemental signature for %s, linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: code directory must be in trustcache for %s linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: linked code directory not in trust cache for %s linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: signature verified by trustcache for %s linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "rosetta-tc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: supplemental code directory has no signature for %s linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Corrupt signature for %s linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: signature failed verification: %s linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: signature verified by supplemental signing key for %s linked to %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "rosetta-signed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z31supplementalVnodeCheckSignatureP5vnodeP5labelP7cs_blobS0_S4_Pj"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: unable to obtain AKS services for supplemental signing, failing.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: loaded supplemental signing public key (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: failed to get public key info (%x)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "_supplementalGetPublicKey_locked"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL25_supplementalGetPublicKeyPPhPmjPj"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "kern.hv_vmm_present"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Booted in a VM\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi_bring_up_mode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: bring-up mode enabled by boot-arg\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "void initDebugBootArgs()"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_enforce_tcc_hardening"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_enforce_launch_constraints"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_allow_3p_launch_constraints"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_enforce_cc_types"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "BATS_TESTPLAN_ID"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z25configurationSettingsInitv"
        prototype = ""
        caller = "__ZL35_initializeAppleMobileFileIntegrityv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: finished: %i %i\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: delaying developer mode latching...\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z28AMFILoadDevModeStatus_ThreadPvi"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: AMFICompleteSecurityBootMode | bootMode: %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z28AMFICompleteSecurityBootModej"
        prototype = ""
        caller = "__ZN34AppleMobileFileIntegrityUserClient24completeSecurityBootModeEP8OSObjectPvP25IOExternalMethodArguments"
    }
    new {
        args = 0
        anchors {
            new {
                string = "sep-endpoint,scrd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z28AMFIUpdateDeviceState_ThreadPvi"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: Unable to create a name matching for SCRD\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN30AppleT8110PlatformErrorHandler5startEP9IOService.cold.15"
        prototype = ""
        caller = "__Z28AMFIUpdateDeviceState_ThreadPvi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: Unable to match on SCRD endpoint\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "ipc_mqueue_send_locked.cold.5"
        prototype = ""
        caller = "__Z28AMFIUpdateDeviceState_ThreadPvi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: failed formatting for security boot mode: %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: failed to arm security boot mode: %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: armed security boot mode: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z19armSecurityBootModej"
        prototype = ""
        caller = "__ZN34AppleMobileFileIntegrityUserClient19armSecurityBootModeEP8OSObjectPvP25IOExternalMethodArguments"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: not booted with security-mode-change-enabled\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN32AppleOLYHALPortInterfacePCIeAMFM11enableGatedEb39AppleOLYHALPortInterfacePowerActionType.cold.3"
        prototype = ""
        caller = "__Z19turnOnDeveloperModev"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: Developer Mode is off (%i)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z20turnOffDeveloperModev"
        prototype = ""
        caller = "__ZN34AppleMobileFileIntegrityUserClient16armDeveloperModeEP8OSObjectPvP25IOExternalMethodArguments"
    }
    new {
        args = 0
        anchors {
            new {
                string = "osenvironment"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN21ConfigurationSettings17osEnvironmentNameEv"
        prototype = ""
        caller = "__ZN11SystemFacts20resolveFactIfPresentE8CEBufferPb"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: developer mode is force enabled on this platform\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: skipping PMGRAON latch due to bring-up mode\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL17loadDevModeStatusv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "OSEntitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "iokit.OSEntitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__GLOBAL__sub_I_OSEntitlements.cpp"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: failed to acquire unmanaged context: %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN14OSEntitlements24initWithValidationResultE18CEValidationResultP7cs_blobb"
        prototype = ""
        caller = "__ZN14OSEntitlements20withValidationResultE18CEValidationResultP7cs_blobb"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: Releasing transmuted blob for %s - %p %dx\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN14OSEntitlements10invalidateEv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: OSEntitlements::adjustContextWithMonitor NULL monitor\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "imageboot_read_file_internal.cold.1"
        prototype = ""
        caller = "__ZN14OSEntitlements24adjustContextWithMonitorEP14CEQueryContextPKvPKcj"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: DER entitlements validation anomaly in %s\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN14OSEntitlements27adjustContextWithoutMonitorEP7cs_blob.cold.3"
        prototype = ""
        caller = "__ZN14OSEntitlements27adjustContextWithoutMonitorEP7cs_blob"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: DER entitlements anomaly in %s\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN14OSEntitlements27adjustContextWithoutMonitorEP7cs_blob.cold.2"
        prototype = ""
        caller = "__ZN14OSEntitlements27adjustContextWithoutMonitorEP7cs_blob"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Couldn't build index for %s: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN14OSEntitlements27adjustContextWithoutMonitorEP7cs_blob"
        prototype = ""
        caller = "_amfi_OSEntitlements_adjustContextWithoutMonitor"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: couldn't size xml deserialization\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: couldn't size deserialize\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: couldn't serialize XML\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN14OSEntitlements10getXMLBlobEv"
        prototype = ""
        caller = "_amfi_OSEntitlements_get_xml_impl"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: XML is larger than uint32_t\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN14OSEntitlements10getXMLBlobEv.cold.2_1"
        prototype = ""
        caller = "__ZN14OSEntitlements10getXMLBlobEv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: XML serialization failed too late in the process\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "ipsec6_getpolicybysock.cold.3"
        prototype = ""
        caller = "__ZN14OSEntitlements10getXMLBlobEv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "amfi.osentitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_initializeOSEntitlementsSupport"
        prototype = ""
        caller = "_initializeCoreEntitlementsSupport"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"entitlements state %p points back to %p instead of %p\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL39__entitlements_failed_consistency_panicPK14OSEntitlementsPK19OSEntitlementsState"
        prototype = ""
        caller = "__ZN14OSEntitlements9get_stateEv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.MobileFileIntegrity"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "library_validation_failure"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_os_log_create"
            }
        }
        symbol = "__Z22initLibraryConstraintsv"
        prototype = ""
        caller = "__ZL35_initializeAppleMobileFileIntegrityv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: no registered daemon port\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: check_lv_denial server is dead\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: check_lv_denial server returned: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "int _checkLVDenialInDaemon(const char *, off_t, const uint8_t *, boolean_t *)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Bypassing Library Validation for installed root: '%s'."
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "Library Validation would have failed (but is disabled): Library '%s' (Team ID: %s, platform: %s) for process '%s(%d)' (Team ID: %s, platform: %s), reason: %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "Library Validation overridden for '%s' (Team ID: %s, platform: %s) for process '%s(%d)' (Team ID: %s, platform: %s), overridden failure: %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "Library Validation failed: Rejecting '%s' (Team ID: %s, platform: %s) for process '%s(%d)' (Team ID: %s, platform: %s), reason: %s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "library_validation_failure() could not copy out error msg '%s', error: %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "__ZL27_library_validation_failureR15ProcessAccessorR16FileGlobAccessorR11SystemFactsbPKcym"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "Library violates process' library load contraint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Library Load Constraint Rejection: Rejecting '%s' (Team ID: %s, platform: %s) for process '%s(%d)' (Team ID: %s, platform: %s), reason: %.*s"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "evaluateLibraryLoadConstraint() could not copy out error msg '%s', error: %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "__ZL29evaluateLibraryLoadConstraintR15ProcessAccessorR16FileGlobAccessorR11SystemFactsym"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "mapped file has wrong signer type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mapped file has no cdhash, completely unsigned? Code has to be at least ad-hoc signed."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "OOP-JIT signature not valid for mapping process"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Allowing mapping of adhoc non-platform code into adhoc non-platform code"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "mapped file has no Team ID and is not a platform binary (signed with custom identity or adhoc?)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mapping process has no Team ID and is not a platform binary"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mapping process is a platform binary, but mapped file is not"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "mapping process and mapped file (non-platform) have different Team IDs"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "not allowing mapping of development code into production process"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: required cs_blobs not available\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "_checkOOPJitLibraryValidation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s not allowed to map OOP-JIT %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: OOP-JIT %s is not meant for %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "_oopJITLibraryValidationEntitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: OOP-JIT previews allowed through %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: no alternative entitlements for OOP-JIT type: %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL18library_validationR15ProcessAccessorR16FileGlobAccessorR11SystemFactsym"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"Should not reach here proc: %d library: %d\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL47validationCategoriesAllowedTogether_macOSNativeR15ProcessAccessorR16FileGlobAccessor"
        prototype = ""
        caller = "__ZL35validationCategoriesAllowedTogetherR15ProcessAccessorR16FileGlobAccessor"
    }
    new {
        args = 1
        anchors {
            new {
                string = "\"Unknown validation category %d\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL35validationCategoriesAllowedTogetherR15ProcessAccessorR16FileGlobAccessor"
        prototype = ""
        caller = "__ZL18library_validationR15ProcessAccessorR16FileGlobAccessorR11SystemFactsym"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s called with NULL cred\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z15getEntitlementsP5ucred"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "copyEntitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z16copyEntitlementsP4proc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: Entitlement extraction failure in no entitlement check."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Entitlements present in no entitlement check. (length: %ld, ptr: %s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "non-NULL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z21noEntitlementsPresentP7cs_blob"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.system-task-ports.token.control"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN14OSEntitlements23queryEntitlementBooleanEPKc"
            }
            new {
                string = "com.apple.system-task-ports.token.corpse"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN14OSEntitlements23queryEntitlementBooleanEPKc"
            }
            new {
                string = "com.apple.system-task-ports.token.inspect"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN14OSEntitlements23queryEntitlementBooleanEPKc"
            }
        }
        symbol = "__ZL23_task_id_token_get_taskP5ucredP10proc_identj"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "\"CoreEntitlments has triggered a panic\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "Support.c"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_amfiPanic"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed CMSParseContentInfoSignedData: 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
            new {
                string = "failed CMSParseSignerInfos: 0x%08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "in-kernel code signature validation failed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
            new {
                string = "validation failed with: %08x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_CMSVerifySignedData"
        prototype = ""
        caller = "_CMSValidateSignedVnode"
    }
    new {
        args = 0
        anchors {
            new {
                string = "In kernel AMFI validation passed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
            new {
                string = "signer missing:\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_printf"
            }
        }
        symbol = "_validateSignerInfo"
        prototype = ""
        caller = "_CMSVerifySignedData"
    }
    new {
        args = 0
        anchors {
            new {
                string = "SIP is disabled, not checking launch constraints\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: Validation Category info: current %s (%d) parent %s (%d) responsible %s (%d) launch type %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z30_proc_check_launch_constraintsP4prociiPvmP22launch_constraint_dataPPcPm"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s called with NULL context\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi_query_context_to_object_impl"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_amfi_query_context_to_object_impl"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "amfi_OSEntitlements_queryEntitlementBooleanWithProc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_amfi_OSEntitlements_queryEntitlementBooleanWithProc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "amfi_OSEntitlements_queryEntitlementStringWithProc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_amfi_OSEntitlements_queryEntitlementStringWithProc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "amfi_OSEntitlements_copyEntitlementAsOSObjectWithProc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_amfi_OSEntitlements_queryEntitlementStringWithProc_0"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.amfi.can-set-exception-ports"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.login"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z30amfi_exc_action_label_populateP5labelP4proc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: unset cred in check_exception_send"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because SIP is disabled.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because it is handling itself.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because the process is unsigned.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because this is an Apple Internal system and the handler was set by a root process '%s' (%d).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because this is an Apple Internal system and unrestricted debugging is enabled.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because the process is not restricted.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because the process has the '%s' entitlement.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because the handler was set by master-entitled process '%s' (%d).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: allowing exception handler for '%s' (%d) because the handler was set by process '%s' (%d) with same team ID '%s'.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: disallowing exception handler for '%s' (pid: %d, team: '%s'), because the handler was set by non-eligible process '%s' (%d) with Team ID '%s' (%s).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "master-entitled"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z36amfi_exc_action_check_exception_sendP5labelP16exception_actionS0_"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "failed to construct an LWCR from the provided buffer (error: %d)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "No process found pid: %d pidversion: %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Constraint categories are not supported when matching against a running process (cc:%lld)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "No requirements in the provided constraint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Unexpected match result %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "_proc_satisfies_constraint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Requirement not satisfied: %.*s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z26_proc_satisfies_constraint13audit_token_tPvmP39amfi_interface_constraint_match_result_"
        prototype = ""
        caller = "__ZL15_policy_syscallP4prociy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AKSKernelServices"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: unable to get %s (0x%x)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "const kks_services_t *AKS_services()"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z12AKS_servicesv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.recoveryos_agent"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_strcmp"
            }
            new {
                string = "com.apple.RecoveryOS-Agent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.RecoveryDiagnose.recoverydiagnosed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN22LaunchConstraintPolicy20baseSystemExceptionsE20ConstraintCategory_t"
        prototype = ""
        caller = "__ZN22LaunchConstraintPolicy5applyEPvmPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unknown launch type"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Constraint category disallowed in spawn attr"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Caller provided an invalid constraint as a spawnattr"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Only platform code can set launch constraints on itself"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Only platform code can set launch constraints on its parent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Only platform code can set launch constraints on its responsible process"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN22LaunchConstraintPolicy5applyEPvmPPcPm"
        prototype = ""
        caller = "__Z30_proc_check_launch_constraintsP4prociiPvmP22launch_constraint_dataPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Only platform code can set launch constraints"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN22LaunchConstraintPolicy16spawnAttrAllowedER15ProcessAccessorS1_R23LaunchConstraintError_t"
        prototype = ""
        caller = "__ZN22LaunchConstraintPolicy5applyEPvmPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "No error message set"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Launch Constraint Violation (%senforcing), error info: c[%d]p[%d]m[%d]e[%d], (%.*s) launching proc[vc: %d pid: %d]: %s, launch type %d, failure proc [vc: %d pid: %d]: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Launch Constraint Violation, error info: c[%d]p[%d]m[%d]e[%d], (%.*s) launch type %d, failure proc [vc: %d]: %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Failed to allocate memory for the failure description\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN22LaunchConstraintPolicy13handleFailureER23LaunchConstraintError_tPPcPm"
        prototype = ""
        caller = "__ZN22LaunchConstraintPolicy5applyEPvmPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"Should have fatal failure description pointers when we are enforcing\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "LaunchConstraintPolicy.cpp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN22LaunchConstraintPolicy13handleFailureER23LaunchConstraintError_tPPcPm.cold.1"
        prototype = ""
        caller = "__ZN22LaunchConstraintPolicy13handleFailureER23LaunchConstraintError_tPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.amfid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: amfid is untrusted: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: failed getting amfid signing identity\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: failed getting amfid code signature\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: token idversion (%d) does not match proc (%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: token is untrusted: pid %d not found\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z14tokenIsTrusted13audit_token_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.sysdiagnosed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: only sysdiagnose can set the sysdiagnose launch type\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN27LaunchTypeSysdiagnosePolicy19launchTypeIsAllowedER11SystemFactsR15ProcessAccessorR23LaunchConstraintError_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Root installed sysdiagnose helper allowed: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "dzctl"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_strcmp"
            }
            new {
                string = "AMFI: Launch Constraint, allowing %s to be run by sysdiagnose\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Process was launched as a sysdiagnose helper unexpectedly"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN27LaunchTypeSysdiagnosePolicy21launchSatisfiesPolicyER11SystemFactsR15ProcessAccessorR16MetaEncyclopediaS5_S5_R23LaunchConstraintError_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "/product"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "udid-version"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unique-chip-id"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%08llX-%016llX"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: UDID enforcement enabled\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z19initUDIDEnforcementv"
        prototype = ""
        caller = "__Z23precookExemptionProfilev"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: Couldn't allocate space for the profile\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: Couldn't copy buffer for the profile\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "\"AMFI: While evaluating profile for %s got invalid profile from amfid\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "AMFI: %s not allowed with Universal Provisioning Profile"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: profile has successfully validated all entitlements\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: entitlements have been validated\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: profile has not succesfully validated all entitlements\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: profile validated the code signature\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: Couldn't copy buffer for the profile aux-sig\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: providing XNU monitor with auxiliary signature\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: XNU monitor refused profile: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z26validateAndRegisterProfileR21ProfileValidationData"
        prototype = ""
        caller = "__ZL22_vnode_check_signatureP5vnodeP5labeliP7cs_blobPjS5_ijPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: Invalid context occured, this shouldn\\'t happen\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN25AppleNubSynopsysOTGDevice5startEP9IOService.cold.1"
        prototype = ""
        caller = "__ZL9okOrPanic14der_vm_context"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: acquired profile with UUID: %.*s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "DeveloperCertificates"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\"Profile passed by amfid does not authorize the certificate\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "AppleInternalProfile"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Entitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\"Profile has invalid entitlements\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "\"Couldn\\'t create entitlements context\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "ProvisionsAllDevices"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: device allowed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ProvisionedDevices"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: device not allowed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: device is provisioned\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: requested usage of a development profile without developer mode being enabled\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: profile is not valid for the current platform"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL15validateProfileR21ProfileValidationData14der_vm_context8CEBuffer"
        prototype = ""
        caller = "__Z26validateAndRegisterProfileR21ProfileValidationData"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: Only launchd can set the application launch type\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN27LaunchTypeApplicationPolicy19launchTypeIsAllowedER11SystemFactsR15ProcessAccessorR23LaunchConstraintError_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "System process was launched as an application unexpectedly"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN27LaunchTypeApplicationPolicy21launchSatisfiesPolicyER11SystemFactsR15ProcessAccessorR16MetaEncyclopediaS5_S5_R23LaunchConstraintError_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "amfi_force_policy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_block_unsigned_code"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: You have used the amfi_block_unsigned_code boot-arg. This will be removed in a future release."
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi_force_cs_kill"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: you have used the amfi_force_cs_kill boot-arg. This will be removed in a future release."
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi_hsp_disable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_hsp_logging"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_allow_bni_as_platform"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_no_aot_tc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_allow_non_platform"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_prevent_old_entitled_platform_binaries"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_allow_only_tc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi_allow_only_tc_override"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "amfi-exec-req-tc"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZL35queryDeviceTreeKeyContainsNon0ValuePKc"
            }
            new {
                string = "override-platform-only-code"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZL35queryDeviceTreeKeyContainsNon0ValuePKc"
            }
            new {
                string = "amfi-exec-req-tc-overrideable"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZL35queryDeviceTreeKeyContainsNon0ValuePKc"
            }
        }
        symbol = "__Z28macOSPolicyConfigurationInitv"
        prototype = ""
        caller = "__Z25configurationSettingsInitv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "enable_qa_root_certs"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "engineering-use-only-unit"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZL35queryDeviceTreeKeyContainsNon0ValuePKc"
            }
            new {
                string = "AMFI: overridden qa certificates value only supported on engineering units.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: NVRAM service not available\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z32macOSPolicyConfigurationInitLatev"
        prototype = ""
        caller = "+[BYUtilities ssoFrameworkAvailable]"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.private.amfi.can-allow-non-platform"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__Z20proc_has_entitlementP4procPKc"
            }
        }
        symbol = "__ZL31amfiSysctlAllowOnlyPlatformCodeP10sysctl_oidPviP10sysctl_req"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Non-Fatal: failed to change validation category from %d to %d at %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z29setAndCheckValidationCategoryP7cs_blobjPKc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Checking in with amfid for DER %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Couldn't allocate buffer for XML entitlements\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Couldn't allocate buffer for DER entitlements\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Couldn't copy buffer for DER entitlements\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Couldn't transmute entitlements\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Couldn't find daemon.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: vm_allocate failed"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: vm_map_wire failed kr = %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: vm_map_unwire failed kr = %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
            new {
                string = "%s: vm_map_copyin failed kr = %d"
                segment = "__TEXT"
                section = "__os_log"
                caller = ""
            }
        }
        symbol = "__Z29transmuteEntitlementsInDaemonP7cs_blobPPKhPm"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"Couldn\\'t get XML entitlements, but was asked to transform them into DER\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN20AppleUSBVHCIFirmware17processInterruptsENS_14tInterruptMaskEb.cold.2"
        prototype = ""
        caller = "__Z29transmuteEntitlementsInDaemonP7cs_blobPPKhPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: returned entitlements are too big\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN17AppleSmartBattery18setChargeRateLimitEP8OSObject.cold.1"
        prototype = ""
        caller = "__Z29transmuteEntitlementsInDaemonP7cs_blobPPKhPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: %s: Failed to allocate memory for fatal error message, cannot produce a crash reason.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: Internal error when creating code signature validation error (buffer allocation failed)."
                segment = "__TEXT"
                section = "__cstring"
                caller = "_snprintf"
            }
            new {
                string = "When validating %s:\n  %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_snprintf"
            }
            new {
                string = "AMFI: %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z15fatal_error_fmtP8LazyPathPPcPmPKcz"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "vnode_isreg(vp)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_page_release.cold.12"
        prototype = ""
        caller = "__Z25_cred_label_update_execveP5ucredS0_P4procP5vnodexS4_P5labelS6_S6_PjPvmPi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "!vnode_isdir(vp)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_page_release.cold.11"
        prototype = ""
        caller = "__Z25_cred_label_update_execveP5ucredS0_P4procP5vnodexS4_P5labelS6_S6_PjPvmPi"
    }
    new {
        args = 1
        anchors {
            new {
                string = "AMFI: hook..execve() killing %s (pid %u): Attempt to execute completely unsigned code (must be at least ad-hoc signed).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: hook..execve() killing %s (pid %u): Attempt to execute a Legacy VPN Plugin.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: hook..execve() killing %s (pid %u): dyld signature cannot be verified. You either have a corrupt system image or are trying to run an unsigned application outside of a supported development configuration.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: hook..execve() killing %s (pid %u): %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "com.apple.security.cs.allow-in-chroot"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: hook..execve() hardened runtime not allowed in chroot"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: hook..execve() killing %s (pid %u): not allowed in chroot\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: process with pid %u is not CS_VALID, not honoring entitlements.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "com.apple.private.security.install"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.security.restricted-nvram-variables.heritable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.rootless.restricted-nvram-variables.heritable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.security.datavault.controller"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.rootless.datavault.controller"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.security.internal-installer-equivalent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.security.datavault.controller.internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.rootless.datavault.controller.internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z25_cred_label_update_execveP5ucredS0_P4procP5vnodexS4_P5labelS6_S6_PjPvmPi"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "\"Flag missing: \" \"get_task_allow\" \" met, but \" \"CS_GET_TASK_ALLOW\" \" missing: csflags %08x & %x %s\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__Z25_cred_label_update_execveP5ucredS0_P4procP5vnodexS4_P5labelS6_S6_PjPvmPi.cold.4"
        prototype = ""
        caller = "__Z25_cred_label_update_execveP5ucredS0_P4procP5vnodexS4_P5labelS6_S6_PjPvmPi"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFIEntitlementReleaseKey"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZL13symbolFromKeyP17__opaque_amfi_keyPKc"
            }
        }
        symbol = "__ZN24AppleMobileFileIntegrity25AMFIEntitlementReleaseKeyEP17__opaque_amfi_key"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFIGetQueryContext"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN24AppleMobileFileIntegrity19AMFIGetQueryContextEP4procPP14CEQueryContext"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: built %s %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "virtual bool AppleMobileFileIntegrity::start(IOService *)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Jul  1 2024"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "21:43:16"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN24AppleMobileFileIntegrity5startEP9IOService"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI failed to initialize. This would compromise system security.\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN24AppleMobileFileIntegrity5startEP9IOService.cold.1"
        prototype = ""
        caller = "__ZN24AppleMobileFileIntegrity5startEP9IOService"
    }
    new {
        args = 0
        anchors {
            new {
                string = "virtual void AppleMobileFileIntegrity::stop(IOService *)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\"Cannot unload AMFI - policy is not dynamic\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZN24AppleMobileFileIntegrity4stopEP9IOService"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI::%s passed invalid AMFIEntitlementKey %p\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL13symbolFromKeyP17__opaque_amfi_keyPKc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "amfi_unrestrict_task_for_pid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: unrestricted task_for_pid enabled by boot-arg\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi_dev_mode_policy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: developer mode internal policy disabled by boot-arg\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: library validation will not mark external binaries as platform\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi_unrestricted_local_signing"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: unrestricted AMFI local signing enabled by boot-arg\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi_ready_to_roll"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: practice a key roll\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "cs_enforcement_disable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: cs_enforcement disabled by boot-arg\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Apple Mobile File Integrity"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "model"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: queried model name from device tree: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "iPhone"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: disabling Swift Playgrounds JIT services on iPhone devices\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL35_initializeAppleMobileFileIntegrityv"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"can\\'t has cs_enforcement_disable\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL35_initializeAppleMobileFileIntegrityv.cold.4"
        prototype = ""
        caller = "__ZL35_initializeAppleMobileFileIntegrityv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: mac_policy_register failed: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "\"AMFI mac policy could not be registered!\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL35_initializeAppleMobileFileIntegrityv.cold.3"
        prototype = ""
        caller = "__ZL35_initializeAppleMobileFileIntegrityv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: no root device tree node!\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL35_initializeAppleMobileFileIntegrityv.cold.1"
        prototype = ""
        caller = "__ZL35_initializeAppleMobileFileIntegrityv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: no /model device tree node!\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL35_initializeAppleMobileFileIntegrityv.cold.2"
        prototype = ""
        caller = "__ZL35_initializeAppleMobileFileIntegrityv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: vnode_check_signature called with platform %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Using iOS Platform policy\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Allowing installed root as platform: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "com.apple.root.installed xattr disallowed on quarantined file: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "com.apple.mis.warning"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Respecting MIS launch warning: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: Invalid signature but permitting execution\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: Not from trust cache but marking as platform binary anyway (unless in 3rd party path).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s' passed old-school CT policy.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "ct-platform"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': unsuitable CT policy %#llx for this platform/device, rejecting signature.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "App Store Fast Path -> %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "fast-path-appstore"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "QA Hierarchy used -> %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "qa-path-appstore"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fast-path-local"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "oop-jit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.developer.web-browser-engine.webcontent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s disallowed without %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dynamic-codesigning"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s disallowed on non-platform process"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Internal Error: No code directory found (code_dir_: %p, length: %d)."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fatal error detected during local signing validation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Signature validation for dyld_sim failed. Your SDK may be damaged."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Check-fix enabled for binary '%s' with TeamID '%s', identifier '%s': broken signature treated as unsigned without privileges. This workaround will not work for software built on or after 10.12.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "The code contains a Team ID, but validating its signature failed.\nPlease check your system log."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.rootless.storage.cvms"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Hardened Runtime relaxation entitlements disallowed on System Extensions"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dyld_sim_cache"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: Rejecting signature, binary has platform identifier but is not in the trustcache\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "macos-platform"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macos-local"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "macos-oopjit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dyld_sim"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_strcmp"
            }
            new {
                string = "macos-dyld_sim"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s' passed old CMS code. (AMFITrustedKeys?)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "amfi-trusted-key"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: file %s matched magic path\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "magic-path"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "magic-path-entitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.InstallAssistant"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: check_broken_signature_with_teamid_fatal server is dead\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: check_broken_signature_with_teamid_fatal returned 0x%x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: no registered daemon port for check_broken_signature_with_teamid_fatal\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL22_vnode_check_signatureP5vnodeP5labeliP7cs_blobPjS5_ijPPcPm"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.security2"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with platform identifier %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dock.extra"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.automator.xpc.runner"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.speech"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.preference.desktopscreeneffect.remoteservice"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.ScreenSaver.Engine"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.quicklook.satellite"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.tccutil"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.screencapture"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with TCC entitlement %s"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with disable-library-validation entitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with tcc.allow and com.apple.security.get-task-allow entitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.audio.coreaudiod"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.private.tcc.manager entitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.createmobileaccount"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.private.tcc.allow entitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.atomicupdatetool"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.rootless.install entitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.locationd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.CommCenter"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.timed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.suggestd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.ScriptEditor2"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.hidutil_internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.coreservicesd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.ps"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.footprint"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.lsmp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.tailspin"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.taskinfo"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.top"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.sysmond"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.tailspind"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.securityd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.spindump"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.atos"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.heap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.leaks"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.malloc-history"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.sample"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.stringdups"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.symbols"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.SamplingTools.vmmap"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed without com.apple.system-task-ports.read"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.WorkflowKit.ShortcutsFileAccessHelper"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.printuitool"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.garageband10"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.private.icloud-account-access"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.uarpupdaterservice.display"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.security.get-task-allow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.Xcode.SetReponsibleProcessForUITesting"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.tcc.manager.set-responsible"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.private.tcc.manager.set-responsible"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.system-task-ports*"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.QuickTimePlayerX"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.configd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.PhotoBooth"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.FaceTime"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.iMovieApp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.DirectoryUtility"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.Automator"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.bootcampassistant.installd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.Preview"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.podcasts.PodcastContentService"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.preference.datetime.TimeZoneService"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed without the hardened runtime"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.containermanagerd"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.containermanagerd_system"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.AddressBook"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.dt.xctautomationsupport.LogArchiveCollector"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.aktool"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed on customer os"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.tpctl"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.installandsetup.ShoveService.System"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.otctl"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.installassistanttool"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.cpldiagnose"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.talagent"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.talagent.signature_update"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed without com.apple.private.talagent.signature_update entitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.instrumentbuilder"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed with com.apple.private.tcc.allow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.shortcuts.ShortcutsCommandLine"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.security.restricted-application-groups"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed without com.apple.private.security.restricted-application-groups"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed without correct com.apple.private.amfi.version-restriction entitlement version"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: Hash type is not SHA256 (%u) but %u."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: platformVersion %u is lower than expected version %u."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed due to OOP-JIT loader entitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed due to OOP-JIT runner entitlement"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL14postValidationP8LazyPathP7cs_blobjP12OSDictionaryhbjPKcPPcPm"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.private.amfi.version-restriction"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL29allowedWithVersionRestrictionP12OSDictionaryjPKc"
        prototype = ""
        caller = "__ZL14postValidationP8LazyPathP7cs_blobjP12OSDictionaryhbjPKcPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "%s: %s disallowed before amfid is available"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed because there was an error communicating with amfid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s disallowed because the cdhash amfid checked is not the same as the cdhash in the kernel"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: This version of %s is disallowed by system policy"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL19checkForBundleBlockP8LazyPathP7cs_blobjPKcPPcPm"
        prototype = ""
        caller = "__ZL14postValidationP8LazyPathP7cs_blobjP12OSDictionaryhbjPKcPPcPm"
    }
    new {
        args = 2
        anchors {
            new {
                string = "%s: Possible race detected. Rejecting.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL14_identityMatchPKcPKhS2_"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: '%s' has no cd?\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s' has short cd (%u)?\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s' has no CMS blob?\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s' has short cms (%u), bailing out.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s' is adhoc signed.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s' has zero length cms, but is not adhoc?\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s' does not pass CT evaluation, result: %#x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s': V2 hash agility validation failed, bailing out.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': V1 hash agility validation failed, bailing out.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': no hash agility data and first cd hash type (%d) does not match best cd hash type (%d).\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\"AMFI: \\'%s\\': Invalid first Code Directory should have been caught by xnu.\\n\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "AMFI: '%s': first code directory doesn't match the best code directory, but no hash agility data"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': local signing public key not initialized\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s' : locally signed jit is disabled by system configuration\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': locally signed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL18_validateCoreTrustP7cs_blobPKhPKcPbPyS5_R21ProfileValidationData"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "AMFI: '%s' has unknown CT digest type %#x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s' has unexpected digest type, actual %#x != expected %#x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s' has unexpected digest data len %zu (type %#x)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': cdhash mismatch: actual '%s' != expected '%s'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL27_validateCoreTrustV2AgilityhPKhjS0_mPKc"
        prototype = ""
        caller = "__ZL18_validateCoreTrustP7cs_blobPKhPKcPbPyS5_R21ProfileValidationData"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: '%s': agility data length %zu for V1 agility text is too big.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s': cannot allocate %zu bytes for V1 agility text, bailing out.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s': cannot unserialize hash agility V1 object: '%s'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "AMFI: '%s': hash agility v1 data not a dictionary, bailing out.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cdhashes"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': hash agility v1 cdhashes missing or not an array, bailing out.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: '%s': cdhash mismatch: '%s' does not match any in V1 agility array.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL27_validateCoreTrustV1AgilityPKhS0_mPKc"
        prototype = ""
        caller = "__ZL18_validateCoreTrustP7cs_blobPKhPKcPbPyS5_R21ProfileValidationData"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: %s: unable to find code directory\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "_checkForOOPJit"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL15_checkForOOPJitP7cs_blob"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"AMFI: %s: Anomaly, code directory is NULL\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL15_validateOOPJitP7cs_blobP14OSEntitlements.cold.1"
        prototype = ""
        caller = "__ZL15_validateOOPJitP7cs_blobP14OSEntitlements"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: %s: OOP-JIT signature represents main binary\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: OOP-JIT signature has entitlements\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s linkage size is too small\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: invalid OOP-JIT type\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: unsupported OOP-JIT type: %u\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: unable to obtain cs_blob on current_proc\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: oop-jit is disabled by system configuration\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: %s: unsatisfied entitlements for loading OOP-JIT signature\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL15_validateOOPJitP7cs_blobP14OSEntitlements"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"unexpected dyld_sim cs_flags from amfid: %#0x\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZL22_vnode_check_signatureP5vnodeP5labeliP7cs_blobPjS5_ijPPcPm.cold.5"
        prototype = ""
        caller = "__ZL22_vnode_check_signatureP5vnodeP5labeliP7cs_blobPjS5_ijPPcPm"
    }
    new {
        args = 2
        anchors {
            new {
                string = "%s: hash buffer too small: %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: error copying hash to user space %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.allow-cs-signing"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.allow-cs-signing.internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: unexpected cd hash buffer size: %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: signature buffer too small %zu expected %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: failed to copy in cdhash %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: failed to allocate memory for signature\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: signature buffer too large %zu expected less than or equal to %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: failed to copy in signature for verification %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: only an allowed process can copy local signing private key\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: null address for private key\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: private key size not accepted: %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: local signing private key not available: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: failed to copy out private key: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: null address for public key\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: public key size not accepted: %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: local signing public key not available\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: failed to copy out public key: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: only an allowed process can set local signing public key\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: error copying in public key %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.private.enable-swift-playgrounds-validation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: only an allowed process can authorize local signing\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: error copying in args: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: img4_object_addr expected but not provided\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: img4_object cannot have zero length\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: error copying in img4_object_addr: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: img4_manifest_addr expected but not provided\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: error copying in img4_manifest_addr: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: img4_aux_manifest_addr expected but not provided\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: error copying in img4_aux_manifest_addr: %d\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "%s: invalid error struct size: %zu\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Constraint size (%zu) exceeds maximum %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "error copying in constraint %d"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: error: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL15_policy_syscallP4prociy"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "com.apple.private.allow-bless"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__Z20proc_has_entitlementP4procPKc"
            }
        }
        symbol = "__ZL27hook_vnode_check_setextattrP5ucredP5vnodeP5labelPKcP3uio"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.security.allow-coredump"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AMFI: Denying core dump for pid %d (%s)"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZL16core_dump_policyP4proc"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"last entry has non-NULL next pointer\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
        }
        symbol = "__ZNK9IOSurface7releaseEi.cold.1_0"
        prototype = ""
        caller = "__ZN24AppleMobileFileIntegrity24loadJitCodeDirectoryHashEPKh"
    }
    new {
        args = 2
        anchors {
            new {
                string = "sip-enabled"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "apple-internal"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "developer-mode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "os-environment"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN11SystemFacts20resolveFactIfPresentE8CEBufferPb"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "AMFI: Error: expected light weight code requirement, but data is not valid: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z17getLWCRFromBufferPvmRN3TLE4LWCRE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "ConstraintUtilities.cpp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "vm_map_store_find_space.cold.2"
        prototype = ""
        caller = "__Z17getLWCRFromBufferPvmRN3TLE4LWCRE"
    }
    new {
        args = 0
        anchors {
            new {
                string = "PlatformHardening (check): (%d) (%d) (%0x) (%0x) (%s) (%s)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "PlatformHardening: %s is running in x86 32-bit mode, so max hardening flags are: %x\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "lookupFlagsForIdentity: data for %s is not a number\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z19platformHardenFlagsP8LazyPathiP7cs_blobP14OSEntitlementsbPj"
        prototype = ""
        caller = "__Z27platformHardenFlagsIfNeededP8LazyPathiP7cs_blobP14OSEntitlementsbPj"
    }
    new {
        args = 0
        anchors {
            new {
                string = "HardenedSystemPolicy: (%d) (%s) used MAP_JIT without CS_ENFORCEMENT\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "HardenedSystemPolicy: (%d) (%s) allowing translation jit region\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "HardenedSystemPolicy: (%d) (%s) used MAP_JIT with invalid proc_platform\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "HardenedSystemPolicy: rejected MAP_JIT for (%d) (%s) without com.apple.security.cs.allow-jit\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "HardenedSystemPolicy: (%d) (%s) (%s) mapped RWX memory without MAP_JIT\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "ENFORCING"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "NOT ENFORCING"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "HardenedSystemPolicy: (%d) (%s) (%s) mapped R_X memory\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z23hsp_proc_check_map_anonP4procP5ucredyyiiPi"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "dyldPolicy: (%d) (%s) in(%08llx) sip(%d) cs_restrict(%d) restrict_segment(%d) setugid(%d) lv(%d) forced_lv(%d) platform(%d) hardened(%d) arl(%d) aev(%d) gta(%d) sim(%d) ai(%d) fp(%d) request_sandbox(%d) is_mac_app_store(%d) is_ios_app(%d) unrestrict_task_for_pid(%d)\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z17logDyldPolicyDataP4procyP24amfi_dyld_policy_state_t"
        prototype = ""
        caller = "__Z31macos_dyld_policy_collect_stateP4procyP24amfi_dyld_policy_state_t"
    }
    new {
        args = 0
        anchors {
            new {
                string = "com.apple.security.amfi.test.mac-app-store-test"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dyldPolicy: AppleInternal and com.apple.security.amfi.test.mac_app_store_test, masquerading as app store\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z31macos_dyld_policy_collect_stateP4procyP24amfi_dyld_policy_state_t"
        prototype = ""
        caller = "__ZL27_check_dyld_policy_internalP4procyPy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "dyldPolicy: (%d) (%s) %s %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z22logDyldPolicyRejectionP4procPKcS2_z"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "relative path loading disallowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z25macos_dyld_policy_at_pathP4procP24amfi_dyld_policy_state_t"
        prototype = ""
        caller = "__ZL27_check_dyld_policy_internalP4procyPy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "embedded dyld variables disallowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z31macos_dyld_policy_embedded_varsP4procP24amfi_dyld_policy_state_t"
        prototype = ""
        caller = "__ZL27_check_dyld_policy_internalP4procyPy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "dyldPolicy: Allowing dyld path, print and custom shared cache env vars as we're AppleInternal and unrestrict_task_for_pid is set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "dyld enviroment variables disallowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "iOS process is set(g)uid"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "process is platform, restricted, and entitled but not signed with Library Validation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "process is platform, restricted, and entitled but does not use Library Validation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "process is restricted and does not use Library Validation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "process is hardened but not entitled"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "process is not hardened, restricted, and does not use Library Validation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z26macos_dyld_policy_env_varsP4procP24amfi_dyld_policy_state_t"
        prototype = ""
        caller = "__ZL27_check_dyld_policy_internalP4procyPy"
    }
    new {
        args = 1
        anchors {
            new {
                string = "fallback paths disallowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "process is restricted or hardened"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z32macos_dyld_policy_fallback_pathsP4procP24amfi_dyld_policy_state_t"
        prototype = ""
        caller = "__ZL27_check_dyld_policy_internalP4procyPy"
    }
    new {
        args = 1
        anchors {
            new {
                string = "dyldPolicy: Allowing dyld interposing for app '%s' as we're AppleInternal and unrestrict_task_for_pid is set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dyldPolicy: Allowing dyld interposing for app as we're AppleInternal and unrestrict_task_for_pid is set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Allowing library interposing for %s as AppleInternal and unrestrict_task_for_pid are set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Allowing library interposing as AppleInternal and unrestrict_task_for_pid are set\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Denying library interposing for pid %d with identity %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Denying library interposing\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Denying library interposing for iOS app\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z37macos_dyld_policy_library_interposingP4procP24amfi_dyld_policy_state_t"
        prototype = ""
        caller = "__ZL27_check_dyld_policy_internalP4procyPy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "/System/Library/Security/HardeningExceptions.plist"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "getExceptionList: file not found\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "getExceptionList: Failed to allocate %d bytes for exception list\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "getExceptionList: Failed to read exception list\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "getExceptionList: unserialize failure, %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "getExceptionList: list isn't a dictionary\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "\"getHardeningList: no memory to allocate even an empty hardening list\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "PlatformHardening.cpp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZL16getExceptionListv"
        prototype = ""
        caller = "__Z19platformHardenFlagsP8LazyPathiP7cs_blobP14OSEntitlementsbPj"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Forcing CS_RUNTIME for entitlement: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "com.apple.itunes.altool"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "com.apple.RealityComposer"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z27platformHardenFlagsIfNeededP8LazyPathiP7cs_blobP14OSEntitlementsbPj"
        prototype = ""
        caller = "__ZL22_vnode_check_signatureP5vnodeP5labeliP7cs_blobPjS5_ijPPcPm"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Failed to get path for vnode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN21AbstractVnodeAccessor4pathEPPKc"
        prototype = ""
        caller = ""
    }
    new {
        args = 2
        anchors {
            new {
                string = "on-system-volume"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "on-authorized-authapfs-volume"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "is-sip-protected"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN21AbstractVnodeAccessor20resolveFactIfPresentE8CEBufferPb"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "\"Couldn\\'t allocate memory for a denylist\" @%s:%d"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_panic"
            }
            new {
                string = "MISDenylist.cpp"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z18InitializeDenylistv.cold.1"
        prototype = ""
        caller = "__Z18InitializeDenylistv"
    }
    new {
        args = 1
        anchors {
            new {
                string = "Validation of denylist failed: not sorted"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__Z16ValidateDenylistP16MISDenylistEntrym"
        prototype = ""
        caller = "__ZN34AppleMobileFileIntegrityUserClient11setDenylistEP8OSObjectPvP25IOExternalMethodArguments"
    }
    new {
        args = 0
        anchors {
            new {
                string = "AMFI: Only launchd can set the system service launch type\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "__ZN27LaunchTypeApplicationPolicy19launchTypeIsAllowedER11SystemFactsR15ProcessAccessorR23LaunchConstraintError_t_0"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Root installed system service allowed: %s\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
            new {
                string = "Process was launched as a system service unexpectedly but met System Service constraints"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN29LaunchTypeSystemServicePolicy21launchSatisfiesPolicyER11SystemFactsR15ProcessAccessorR16MetaEncyclopediaS5_S5_R23LaunchConstraintError_t"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "( ((outSize != nullptr && *outSize > 0) && outBuffer != nullptr) || ((outSize == nullptr || *outSize == 0) && outBuffer == nullptr) )"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "transportContext"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "_acmService"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "command"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "acmService"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "AppleCredentialManager"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "serviceMatchingDict"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "service"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "performCommand"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "performCommandV2"
                segment = "__TEXT"
                section = "__cstring"
                caller = "__ZN8OSSymbol11withCStringEPKc"
            }
            new {
                string = "performCommandFunc"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "validateCommand"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "inSize >= sizeof(acm_command_t)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_ACMKernelTransport"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "!dataSize || data"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "commandSize"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "__os_warn_unused(__builtin_add_overflow((sizeof(acm_command_t)), (dataSize), (&cmdSize))) == 0 "
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "cmd = (acm_command_t *)({ size_t sizeVal = (cmdSize); void *ptr = acm_mem_alloc_data(sizeVal); acm_mem_alloc_info(\"<data>\", ptr, sizeVal, \"/AppleInternal/Library/BuildRoots/d8c9c115-356a-11ef-b3f4-e2437461156c/Library/Caches/com.apple.xbs/Sources/AppleCredentialManager_KernelLibs/common/LibCall.c\", 22, __func__); ptr; })"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: returning.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "_LibCall_BuildCommand"
        prototype = ""
        caller = "_ACMKernelTransport"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(data && dataLength && dataLength <= 4096) || (!data && !dataLength)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_LibCall_ACMKernelControl"
        prototype = ""
        caller = "_ACMKernControl"
    }
    new {
        args = 0
        anchors {
            new {
                string = "(keybagUuid && keybagUuidLength == 16) || (!keybagUuid && !keybagUuidLength)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "(data && dataLength && dataLength <= 128) || (!data && !dataLength)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_LibCall_ACMSetEnvironmentVariable"
        prototype = ""
        caller = "_ACMKernSetEnvironmentVariable"
    }
    new {
        args = 0
        anchors {
            new {
                string = "_allocatedMem.data >= size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_acm_mem_free_data"
        prototype = ""
        caller = "_ACMKernelTransport"
    }
    new {
        args = 0
        anchors {
            new {
                string = "acm_mem_alloc_info"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_acm_mem_alloc_info"
        prototype = ""
        caller = "_LibCall_BuildCommand"
    }
    new {
        args = 0
        anchors {
            new {
                string = "_allocatedMem.total >= size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "acm_mem_free_info"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_acm_mem_free_info"
        prototype = ""
        caller = "_ACMKernelTransport"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ACMKernControl"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: returning, err = %ld, code=%u.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "_ACMKernControl"
        prototype = ""
        caller = "__ZL17loadDevModeStatusv"
    }
    new {
        args = 0
        anchors {
            new {
                string = "ACMKernSetEnvironmentVariable"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "%s: %s: returning, err = %ld, var=%u.\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = "_IOLog"
            }
        }
        symbol = "_ACMKernSetEnvironmentVariable"
        prototype = ""
        caller = "__Z20turnOffDeveloperModev"
    }
    new {
        args = 0
        anchors {
            new {
                string = "loadFromCE"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LWCR: invalid version / compatible version fields"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LWCRs are not encoded correctly"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "This LWCR is not compatible with this runtime"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LWCRs constraint category cannot be less that zero"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "LWCRs 'requirements' field is not a dictionary"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE4LWCR10loadFromCEEP14CEQueryContext"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Got an unexpected type (not an integer, string or data) when trying to generate an In operation."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE14inDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "$and operator disallowed for active fact"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE15andDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE"
        prototype = ""
        caller = "____ZN3TLE21opArrayOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE_block_invoke"
    }
    new {
        args = 0
        anchors {
            new {
                string = "$or operator disallowed for active fact"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE14orDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE"
        prototype = ""
        caller = "____ZN3TLE21opArrayOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE_block_invoke"
    }
    new {
        args = 0
        anchors {
            new {
                string = "$optional only supports a single dependent operation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE22optionalOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE"
        prototype = ""
        caller = "____ZN3TLE21opArrayOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE_block_invoke"
    }
    new {
        args = 0
        anchors {
            new {
                string = "There should only be one operation to match a fact"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE18factOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE"
        prototype = ""
        caller = "____ZN3TLE8Executor29getDependentOpsFromDictionaryE14der_vm_contextRKNS_14FactDefinitionEbmPK8CEBuffer_block_invoke"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Got an unexpected type (not a dictionary) when trying to generate a query operation."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "$query deserialization failed since it has an invalid query definition"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE19queryOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Expected operator string in Array tuple"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE13keyForContextER14der_vm_context"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Non array element found in operator Array"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Incorrect number of elements in operator Array tuple"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unexpected operator in Array tuple"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unexpected type in Array tuple"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Array contains too many elements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "____ZN3TLE21opArrayOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE_block_invoke"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "The array of dependent operations is empty."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE21opArrayOpDeserializerERNS_8ExecutorER14der_vm_contextRKNS_14FactDefinitionE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Null query context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE8Executor19getOperationsFromCEEP14CEQueryContext"
        prototype = ""
        caller = "__Z21constraintIsSatisfiedRN3TLE12EncyclopediaEP14CEQueryContextR23LaunchConstraintError_t"
    }
    new {
        args = 0
        anchors {
            new {
                string = "Constraint is too deeply nested. Failing to avoid recursion overflow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Got an unexpected type (not a dictionary) when trying to generate dependent operations for evaluation."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "The dictionary of dependent operations is empty."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE8Executor29getDependentOpsFromDictionaryE14der_vm_contextRKNS_14FactDefinitionEbmPK8CEBuffer"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Unexpected key for parsing context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unexpected type of an fact declaration."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Unexpected type of an operation declaration."
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Fact not allowed in context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "____ZN3TLE8Executor29getDependentOpsFromDictionaryE14der_vm_contextRKNS_14FactDefinitionEbmPK8CEBuffer_block_invoke"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid fact type for this operation (expected a string)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE11BinaryStrOpI8CEBufferXtlNS_3$_7EEEE7ExecuteERNS_12EncyclopediaE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Invalid fact type for this operation (expected data)"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE12BinaryDataOpI8CEBufferXtlNS_3$_8EEEE7ExecuteERNS_12EncyclopediaE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "In Operation expected the Fact to be an integer, string or data"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE11InOperation7ExecuteERNS_12EncyclopediaE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Query Operation expected the Fact to be a CoreEntitlements dictionary"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Attempted to execute a non-iterable query"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__ZN3TLE14QueryOperation7ExecuteERNS_12EncyclopediaE"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Attempted to execute unknown CoreEntitlements operation"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "____ZN3TLE14QueryOperation7ExecuteERNS_12EncyclopediaE_block_invoke"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "CESerializeXML"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "critical failure during xml serialization, start != end"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "objectForActiveContext"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s]: subset validation failed, key not found in the superset '%.*s'\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s]: subset validation failed, key %.*s with value '%.*s' not allowed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s]: subset validation failed, bool value of key '%.*s' not allowed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s]: subset validation failed, integer value of key '%.*s' not allowed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s]: subset validation failed, string array of key '%.*s' not allowed\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s]: subset validation failed, type mismatch for key '%.*s' %lu != %lu \n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = ""
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "unhandled opcode"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_vm_execute_select_index"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_vm_execute_match_bool"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_vm_execute_string_value_allowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_vm_execute_string_prefix_value_allowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_vm_execute_select_longest_matching_key"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_vm_execute_integer_value_allowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_der_vm_execute_nocopy"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "der_vm_buffer_from_context"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "Failed during buffer decoding"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_der_vm_buffer_from_context"
        prototype = ""
        caller = "____ZL15validateProfileR21ProfileValidationData14der_vm_context8CEBuffer_block_invoke"
    }
    new {
        args = 0
        anchors {
            new {
                string = "manufacturingCallback"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CoreEntitlements: not a sequence"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z21manufacturingCallbackP24der_vm_iteration_context"
        prototype = ""
        caller = "_der_vm_iterate_nocopy"
    }
    new {
        args = 0
        anchors {
            new {
                string = "CEQueryContextToOSDictionary"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "__Z28CEQueryContextToOSDictionaryP14CEQueryContext"
        prototype = ""
        caller = ""
    }
    new {
        args = 1
        anchors {
            new {
                string = "invalid arguments passed in"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "xml-looking blob was passed in"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "entitlements blob does not have CCDER_ENTITLEMENTS coding"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "[%s]: entitlements blob has unexpected version %lld\n"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "entitlements blob does not have CCDER_ENTITLEMENTS_DICT as the second element"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "validate_V0"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "entitlements blob does not have CCDER_CONSTRUCTED_SET coding"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_CEValidateWithOptions"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "CEIndexSizeForContext"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "index size overflow"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_CEIndexSizeForContext"
        prototype = ""
        caller = "_CEBuildIndexForContext"
    }
    new {
        args = 0
        anchors {
            new {
                string = "CEBuildIndexForContext"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "runtime doesn't support acceleration"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_CEBuildIndexForContext"
        prototype = ""
        caller = "__ZN14OSEntitlements27adjustContextWithoutMonitorEP7cs_blob"
    }
    new {
        args = 0
        anchors {
            new {
                string = "copy_keys_to_accelerator_block_invoke"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "fatal error when decoding key/value pair"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "___copy_keys_to_accelerator_block_invoke"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "Not a CoreEntitlements error!"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_CEGetErrorString"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "recursivelyValidateEntitlements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "recursion limit reached"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "invalid tag or length"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "String contains an embedded NUL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "data element not allowed"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "encountered invalid tag"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "extra data at the end of element"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_validate_dictionary"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dictionary key / value decoding failure"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "key contains an embedded NUL"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dictionary keys are not sorted or not unique"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dictionary value verification failure"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "der_validate_array"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_recursivelyValidateEntitlements"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "der_vm_execute_match_string"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_der_vm_execute_match_string"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "der_vm_execute_match_string_prefix"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_der_vm_execute_match_string_prefix"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "string_value_allowed_iterate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_string_value_allowed_iterate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "string_prefix_allowed_iterate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_string_prefix_allowed_iterate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "integer_allowed_iterate"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_integer_allowed_iterate"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "der_decode_next"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "could not decode tag for next DER sub-sequence"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "could not decode size for next DER sub-sequence"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "sub-sequence size is larger than sequence size"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_der_decode_next"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "der_decode_key_value"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "key / value decoding failure"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "dictionary key is not a valid string"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unable to decode value tag for key-value pair"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "unable to decode value size for key-value pair"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "key-value pair contains extra elements"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "_der_decode_key_value"
        prototype = ""
        caller = ""
    }
    new {
        args = 0
        anchors {
            new {
                string = "CEDeserialize_block_invoke"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
            new {
                string = "CEDeserialization length mismatch"
                segment = "__TEXT"
                section = "__cstring"
                caller = ""
            }
        }
        symbol = "___CEDeserialize_block_invoke"
        prototype = ""
        caller = ""
    }
}