/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
)

// Linger please
var (
	_ _context.Context
)

type QueryApi interface {

	/*
	 * PostQuery Query InfluxDB
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostQueryRequest
	 */
	PostQuery(ctx _context.Context) ApiPostQueryRequest

	/*
	 * PostQueryExecute executes the request
	 * @return *os.File
	 */
	PostQueryExecute(r ApiPostQueryRequest) (*_nethttp.Response, error)

	/*
	 * PostQueryExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return *os.File
	 */
	PostQueryExecuteWithHttpInfo(r ApiPostQueryRequest) (*_nethttp.Response, *_nethttp.Response, error)
}

// QueryApiService QueryApi service
type QueryApiService service

type ApiPostQueryRequest struct {
	ctx            _context.Context
	ApiService     QueryApi
	zapTraceSpan   *string
	acceptEncoding *string
	contentType    *string
	org            *string
	orgID          *string
	query          *Query
}

func (r ApiPostQueryRequest) ZapTraceSpan(zapTraceSpan string) ApiPostQueryRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostQueryRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostQueryRequest) AcceptEncoding(acceptEncoding string) ApiPostQueryRequest {
	r.acceptEncoding = &acceptEncoding
	return r
}
func (r ApiPostQueryRequest) GetAcceptEncoding() *string {
	return r.acceptEncoding
}

func (r ApiPostQueryRequest) ContentType(contentType string) ApiPostQueryRequest {
	r.contentType = &contentType
	return r
}
func (r ApiPostQueryRequest) GetContentType() *string {
	return r.contentType
}

func (r ApiPostQueryRequest) Org(org string) ApiPostQueryRequest {
	r.org = &org
	return r
}
func (r ApiPostQueryRequest) GetOrg() *string {
	return r.org
}

func (r ApiPostQueryRequest) OrgID(orgID string) ApiPostQueryRequest {
	r.orgID = &orgID
	return r
}
func (r ApiPostQueryRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiPostQueryRequest) Query(query Query) ApiPostQueryRequest {
	r.query = &query
	return r
}
func (r ApiPostQueryRequest) GetQuery() *Query {
	return r.query
}

func (r ApiPostQueryRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.PostQueryExecute(r)
}

func (r ApiPostQueryRequest) ExecuteWithHttpInfo() (*_nethttp.Response, *_nethttp.Response, error) {
	return r.ApiService.PostQueryExecuteWithHttpInfo(r)
}

/*
 * PostQuery Query InfluxDB
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostQueryRequest
 */
func (a *QueryApiService) PostQuery(ctx _context.Context) ApiPostQueryRequest {
	return ApiPostQueryRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return *os.File
 */
func (a *QueryApiService) PostQueryExecute(r ApiPostQueryRequest) (*_nethttp.Response, error) {
	returnVal, _, err := a.PostQueryExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return *os.File
 */
func (a *QueryApiService) PostQueryExecuteWithHttpInfo(r ApiPostQueryRequest) (*_nethttp.Response, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  *_nethttp.Response
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryApiService.PostQuery")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.org != nil {
		localVarQueryParams.Add("org", parameterToString(*r.org, ""))
	}
	if r.orgID != nil {
		localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/csv", "application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	if r.acceptEncoding != nil {
		localVarHeaderParams["Accept-Encoding"] = parameterToString(*r.acceptEncoding, "")
	}
	if r.contentType != nil {
		localVarHeaderParams["Content-Type"] = parameterToString(*r.contentType, "")
	}
	// body params
	localVarPostBody = r.query
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	localVarReturnValue = localVarHTTPResponse

	return localVarReturnValue, localVarHTTPResponse, nil
}
