/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

type RemoteConnectionsApi interface {

	/*
	 * DeleteRemoteConnectionByID Delete a remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param remoteID
	 * @return ApiDeleteRemoteConnectionByIDRequest
	 */
	DeleteRemoteConnectionByID(ctx _context.Context, remoteID string) ApiDeleteRemoteConnectionByIDRequest

	/*
	 * DeleteRemoteConnectionByIDExecute executes the request
	 */
	DeleteRemoteConnectionByIDExecute(r ApiDeleteRemoteConnectionByIDRequest) error

	/*
	 * GetRemoteConnectionByID Retrieve a remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param remoteID
	 * @return ApiGetRemoteConnectionByIDRequest
	 */
	GetRemoteConnectionByID(ctx _context.Context, remoteID string) ApiGetRemoteConnectionByIDRequest

	/*
	 * GetRemoteConnectionByIDExecute executes the request
	 * @return RemoteConnection
	 */
	GetRemoteConnectionByIDExecute(r ApiGetRemoteConnectionByIDRequest) (RemoteConnection, error)

	/*
	 * GetRemoteConnections List all remote connections
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiGetRemoteConnectionsRequest
	 */
	GetRemoteConnections(ctx _context.Context) ApiGetRemoteConnectionsRequest

	/*
	 * GetRemoteConnectionsExecute executes the request
	 * @return RemoteConnections
	 */
	GetRemoteConnectionsExecute(r ApiGetRemoteConnectionsRequest) (RemoteConnections, error)

	/*
	 * PatchRemoteConnectionByID Update a remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param remoteID
	 * @return ApiPatchRemoteConnectionByIDRequest
	 */
	PatchRemoteConnectionByID(ctx _context.Context, remoteID string) ApiPatchRemoteConnectionByIDRequest

	/*
	 * PatchRemoteConnectionByIDExecute executes the request
	 * @return RemoteConnection
	 */
	PatchRemoteConnectionByIDExecute(r ApiPatchRemoteConnectionByIDRequest) (RemoteConnection, error)

	/*
	 * PostRemoteConnection Register a new remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiPostRemoteConnectionRequest
	 */
	PostRemoteConnection(ctx _context.Context) ApiPostRemoteConnectionRequest

	/*
	 * PostRemoteConnectionExecute executes the request
	 * @return RemoteConnection
	 */
	PostRemoteConnectionExecute(r ApiPostRemoteConnectionRequest) (RemoteConnection, error)

	/*
	 * PostValidateRemoteConnectionByID Validate a remote connection
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param remoteID
	 * @return ApiPostValidateRemoteConnectionByIDRequest
	 */
	PostValidateRemoteConnectionByID(ctx _context.Context, remoteID string) ApiPostValidateRemoteConnectionByIDRequest

	/*
	 * PostValidateRemoteConnectionByIDExecute executes the request
	 */
	PostValidateRemoteConnectionByIDExecute(r ApiPostValidateRemoteConnectionByIDRequest) error

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on OSS
	// servers.
	OnlyOSS() RemoteConnectionsApi

	// Sets additional descriptive text in the error message if any request in
	// this API fails, indicating that it is intended to be used only on cloud
	// servers.
	OnlyCloud() RemoteConnectionsApi
}

// RemoteConnectionsApiService RemoteConnectionsApi service
type RemoteConnectionsApiService service

func (a *RemoteConnectionsApiService) OnlyOSS() RemoteConnectionsApi {
	a.isOnlyOSS = true
	return a
}

func (a *RemoteConnectionsApiService) OnlyCloud() RemoteConnectionsApi {
	a.isOnlyCloud = true
	return a
}

type ApiDeleteRemoteConnectionByIDRequest struct {
	ctx          _context.Context
	ApiService   RemoteConnectionsApi
	remoteID     string
	zapTraceSpan *string
}

func (r ApiDeleteRemoteConnectionByIDRequest) RemoteID(remoteID string) ApiDeleteRemoteConnectionByIDRequest {
	r.remoteID = remoteID
	return r
}
func (r ApiDeleteRemoteConnectionByIDRequest) GetRemoteID() string {
	return r.remoteID
}

func (r ApiDeleteRemoteConnectionByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteRemoteConnectionByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteRemoteConnectionByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteRemoteConnectionByIDRequest) Execute() error {
	return r.ApiService.DeleteRemoteConnectionByIDExecute(r)
}

/*
 * DeleteRemoteConnectionByID Delete a remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param remoteID
 * @return ApiDeleteRemoteConnectionByIDRequest
 */
func (a *RemoteConnectionsApiService) DeleteRemoteConnectionByID(ctx _context.Context, remoteID string) ApiDeleteRemoteConnectionByIDRequest {
	return ApiDeleteRemoteConnectionByIDRequest{
		ApiService: a,
		ctx:        ctx,
		remoteID:   remoteID,
	}
}

/*
 * Execute executes the request
 */
func (a *RemoteConnectionsApiService) DeleteRemoteConnectionByIDExecute(r ApiDeleteRemoteConnectionByIDRequest) error {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.DeleteRemoteConnectionByID")
	if err != nil {
		return GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/remotes/{remoteID}"
	localVarPath = strings.Replace(localVarPath, "{"+"remoteID"+"}", _neturl.PathEscape(parameterToString(r.remoteID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return newErr
	}

	return nil
}

type ApiGetRemoteConnectionByIDRequest struct {
	ctx          _context.Context
	ApiService   RemoteConnectionsApi
	remoteID     string
	zapTraceSpan *string
}

func (r ApiGetRemoteConnectionByIDRequest) RemoteID(remoteID string) ApiGetRemoteConnectionByIDRequest {
	r.remoteID = remoteID
	return r
}
func (r ApiGetRemoteConnectionByIDRequest) GetRemoteID() string {
	return r.remoteID
}

func (r ApiGetRemoteConnectionByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiGetRemoteConnectionByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetRemoteConnectionByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetRemoteConnectionByIDRequest) Execute() (RemoteConnection, error) {
	return r.ApiService.GetRemoteConnectionByIDExecute(r)
}

/*
 * GetRemoteConnectionByID Retrieve a remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param remoteID
 * @return ApiGetRemoteConnectionByIDRequest
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionByID(ctx _context.Context, remoteID string) ApiGetRemoteConnectionByIDRequest {
	return ApiGetRemoteConnectionByIDRequest{
		ApiService: a,
		ctx:        ctx,
		remoteID:   remoteID,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionByIDExecute(r ApiGetRemoteConnectionByIDRequest) (RemoteConnection, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnection
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.GetRemoteConnectionByID")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/remotes/{remoteID}"
	localVarPath = strings.Replace(localVarPath, "{"+"remoteID"+"}", _neturl.PathEscape(parameterToString(r.remoteID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiGetRemoteConnectionsRequest struct {
	ctx          _context.Context
	ApiService   RemoteConnectionsApi
	orgID        *string
	zapTraceSpan *string
	name         *string
	remoteURL    *string
}

func (r ApiGetRemoteConnectionsRequest) OrgID(orgID string) ApiGetRemoteConnectionsRequest {
	r.orgID = &orgID
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiGetRemoteConnectionsRequest) ZapTraceSpan(zapTraceSpan string) ApiGetRemoteConnectionsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetRemoteConnectionsRequest) Name(name string) ApiGetRemoteConnectionsRequest {
	r.name = &name
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetName() *string {
	return r.name
}

func (r ApiGetRemoteConnectionsRequest) RemoteURL(remoteURL string) ApiGetRemoteConnectionsRequest {
	r.remoteURL = &remoteURL
	return r
}
func (r ApiGetRemoteConnectionsRequest) GetRemoteURL() *string {
	return r.remoteURL
}

func (r ApiGetRemoteConnectionsRequest) Execute() (RemoteConnections, error) {
	return r.ApiService.GetRemoteConnectionsExecute(r)
}

/*
 * GetRemoteConnections List all remote connections
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiGetRemoteConnectionsRequest
 */
func (a *RemoteConnectionsApiService) GetRemoteConnections(ctx _context.Context) ApiGetRemoteConnectionsRequest {
	return ApiGetRemoteConnectionsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnections
 */
func (a *RemoteConnectionsApiService) GetRemoteConnectionsExecute(r ApiGetRemoteConnectionsRequest) (RemoteConnections, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnections
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.GetRemoteConnections")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/remotes"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.orgID == nil {
		return localVarReturnValue, reportError("orgID is required and must be specified")
	}

	localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	if r.name != nil {
		localVarQueryParams.Add("name", parameterToString(*r.name, ""))
	}
	if r.remoteURL != nil {
		localVarQueryParams.Add("remoteURL", parameterToString(*r.remoteURL, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPatchRemoteConnectionByIDRequest struct {
	ctx                            _context.Context
	ApiService                     RemoteConnectionsApi
	remoteID                       string
	remoteConnenctionUpdateRequest *RemoteConnenctionUpdateRequest
	zapTraceSpan                   *string
	validate                       *bool
}

func (r ApiPatchRemoteConnectionByIDRequest) RemoteID(remoteID string) ApiPatchRemoteConnectionByIDRequest {
	r.remoteID = remoteID
	return r
}
func (r ApiPatchRemoteConnectionByIDRequest) GetRemoteID() string {
	return r.remoteID
}

func (r ApiPatchRemoteConnectionByIDRequest) RemoteConnenctionUpdateRequest(remoteConnenctionUpdateRequest RemoteConnenctionUpdateRequest) ApiPatchRemoteConnectionByIDRequest {
	r.remoteConnenctionUpdateRequest = &remoteConnenctionUpdateRequest
	return r
}
func (r ApiPatchRemoteConnectionByIDRequest) GetRemoteConnenctionUpdateRequest() *RemoteConnenctionUpdateRequest {
	return r.remoteConnenctionUpdateRequest
}

func (r ApiPatchRemoteConnectionByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPatchRemoteConnectionByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPatchRemoteConnectionByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPatchRemoteConnectionByIDRequest) Validate(validate bool) ApiPatchRemoteConnectionByIDRequest {
	r.validate = &validate
	return r
}
func (r ApiPatchRemoteConnectionByIDRequest) GetValidate() *bool {
	return r.validate
}

func (r ApiPatchRemoteConnectionByIDRequest) Execute() (RemoteConnection, error) {
	return r.ApiService.PatchRemoteConnectionByIDExecute(r)
}

/*
 * PatchRemoteConnectionByID Update a remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param remoteID
 * @return ApiPatchRemoteConnectionByIDRequest
 */
func (a *RemoteConnectionsApiService) PatchRemoteConnectionByID(ctx _context.Context, remoteID string) ApiPatchRemoteConnectionByIDRequest {
	return ApiPatchRemoteConnectionByIDRequest{
		ApiService: a,
		ctx:        ctx,
		remoteID:   remoteID,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) PatchRemoteConnectionByIDExecute(r ApiPatchRemoteConnectionByIDRequest) (RemoteConnection, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnection
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.PatchRemoteConnectionByID")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/remotes/{remoteID}"
	localVarPath = strings.Replace(localVarPath, "{"+"remoteID"+"}", _neturl.PathEscape(parameterToString(r.remoteID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.remoteConnenctionUpdateRequest == nil {
		return localVarReturnValue, reportError("remoteConnenctionUpdateRequest is required and must be specified")
	}

	if r.validate != nil {
		localVarQueryParams.Add("validate", parameterToString(*r.validate, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.remoteConnenctionUpdateRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPostRemoteConnectionRequest struct {
	ctx                             _context.Context
	ApiService                      RemoteConnectionsApi
	remoteConnectionCreationRequest *RemoteConnectionCreationRequest
	zapTraceSpan                    *string
	validate                        *bool
}

func (r ApiPostRemoteConnectionRequest) RemoteConnectionCreationRequest(remoteConnectionCreationRequest RemoteConnectionCreationRequest) ApiPostRemoteConnectionRequest {
	r.remoteConnectionCreationRequest = &remoteConnectionCreationRequest
	return r
}
func (r ApiPostRemoteConnectionRequest) GetRemoteConnectionCreationRequest() *RemoteConnectionCreationRequest {
	return r.remoteConnectionCreationRequest
}

func (r ApiPostRemoteConnectionRequest) ZapTraceSpan(zapTraceSpan string) ApiPostRemoteConnectionRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostRemoteConnectionRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostRemoteConnectionRequest) Validate(validate bool) ApiPostRemoteConnectionRequest {
	r.validate = &validate
	return r
}
func (r ApiPostRemoteConnectionRequest) GetValidate() *bool {
	return r.validate
}

func (r ApiPostRemoteConnectionRequest) Execute() (RemoteConnection, error) {
	return r.ApiService.PostRemoteConnectionExecute(r)
}

/*
 * PostRemoteConnection Register a new remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostRemoteConnectionRequest
 */
func (a *RemoteConnectionsApiService) PostRemoteConnection(ctx _context.Context) ApiPostRemoteConnectionRequest {
	return ApiPostRemoteConnectionRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return RemoteConnection
 */
func (a *RemoteConnectionsApiService) PostRemoteConnectionExecute(r ApiPostRemoteConnectionRequest) (RemoteConnection, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  RemoteConnection
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.PostRemoteConnection")
	if err != nil {
		return localVarReturnValue, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/remotes"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.remoteConnectionCreationRequest == nil {
		return localVarReturnValue, reportError("remoteConnectionCreationRequest is required and must be specified")
	}

	if r.validate != nil {
		localVarQueryParams.Add("validate", parameterToString(*r.validate, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.remoteConnectionCreationRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		return localVarReturnValue, _fmt.Errorf("%s%w", errorPrefix, err)
	}
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, err.Error()),
		}
		return localVarReturnValue, newErr
	}

	return localVarReturnValue, nil
}

type ApiPostValidateRemoteConnectionByIDRequest struct {
	ctx          _context.Context
	ApiService   RemoteConnectionsApi
	remoteID     string
	zapTraceSpan *string
}

func (r ApiPostValidateRemoteConnectionByIDRequest) RemoteID(remoteID string) ApiPostValidateRemoteConnectionByIDRequest {
	r.remoteID = remoteID
	return r
}
func (r ApiPostValidateRemoteConnectionByIDRequest) GetRemoteID() string {
	return r.remoteID
}

func (r ApiPostValidateRemoteConnectionByIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPostValidateRemoteConnectionByIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostValidateRemoteConnectionByIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostValidateRemoteConnectionByIDRequest) Execute() error {
	return r.ApiService.PostValidateRemoteConnectionByIDExecute(r)
}

/*
 * PostValidateRemoteConnectionByID Validate a remote connection
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param remoteID
 * @return ApiPostValidateRemoteConnectionByIDRequest
 */
func (a *RemoteConnectionsApiService) PostValidateRemoteConnectionByID(ctx _context.Context, remoteID string) ApiPostValidateRemoteConnectionByIDRequest {
	return ApiPostValidateRemoteConnectionByIDRequest{
		ApiService: a,
		ctx:        ctx,
		remoteID:   remoteID,
	}
}

/*
 * Execute executes the request
 */
func (a *RemoteConnectionsApiService) PostValidateRemoteConnectionByIDExecute(r ApiPostValidateRemoteConnectionByIDRequest) error {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemoteConnectionsApiService.PostValidateRemoteConnectionByID")
	if err != nil {
		return GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/remotes/{remoteID}/validate"
	localVarPath = strings.Replace(localVarPath, "{"+"remoteID"+"}", _neturl.PathEscape(parameterToString(r.remoteID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return err
	}

	var errorPrefix string
	if a.isOnlyOSS {
		errorPrefix = "InfluxDB OSS-only command failed: "
	} else if a.isOnlyCloud {
		errorPrefix = "InfluxDB Cloud-only command failed: "
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			return _fmt.Errorf("%s%w", errorPrefix, err)
		}
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: _fmt.Sprintf("%s%s", errorPrefix, localVarHTTPResponse.Status),
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return newErr
	}

	return nil
}
