# @improbable-eng/grpc-web-fake-transport
> Fake Transport for use with [@improbable-eng/grpc-web](https://github.com/improbable-eng/grpc-web).

## Usage

### With Service Stubs generated by ts-protoc-gen 
```typescript
import { FakeTransportBuilder } from '@improbable-eng/grpc-web-fake-transport';

const fakeTransport = new FakeTransportBuilder()
  .withMessages([ new PingResponse() ])
  .build();

const client = new PingServiceClient("https://example.com", {
  transport: fakeTransport
});

client.DoPing(/* ... */);
```

### With grpc-web
```typescript
import { grpc } from '@improbable-eng/grpc-web';
import { FakeTransportBuilder } from '@improbable-eng/grpc-web-fake-transport';

const fakeTransport = new FakeTransportBuilder()
  .withMessages([ new PingResponse() ])
  .build();

grpc.invoke(PingService.DoPing, {
  host: "https://example.com",
  transport: fakeTransport,
  /* ... */
});
```

Alternatively replace the Default Transport when initialising your tests:
```typescript
import { grpc } from "@improbable-eng/grpc-web";
import { NodeHttpTransport } from "@improbable-eng/grpc-web-fake-transport";

// Do this first, before you make any grpc requests!
grpc.setDefaultTransport(fakeTransport);
```  