package cmddatamodel

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"github.com/hofstadter-io/hof/cmd/hof/flags"
	"github.com/hofstadter-io/hof/lib/datamodel"
)

var historyLong = `list the snapshots for a data model`

func HistoryRun(args []string) (err error) {

	// you can safely comment this print out
	// fmt.Println("not implemented")

	err = datamodel.RunHistoryFromArgs(args, flags.DatamodelPflags)

	return err
}

var HistoryCmd = &cobra.Command{

	Use: "history",

	Aliases: []string{
		"hist",
		"h",
	},

	Short: "list the snapshots for a data model",

	Long: historyLong,

	Run: func(cmd *cobra.Command, args []string) {
		var err error

		// Argument Parsing

		err = HistoryRun(args)
		if err != nil {
			fmt.Println(err)
			os.Exit(1)
		}
	},
}

func init() {
	extra := func(cmd *cobra.Command) bool {

		return false
	}

	ohelp := HistoryCmd.HelpFunc()
	ousage := HistoryCmd.UsageFunc()
	help := func(cmd *cobra.Command, args []string) {
		if extra(cmd) {
			return
		}
		ohelp(cmd, args)
	}
	usage := func(cmd *cobra.Command) error {
		if extra(cmd) {
			return nil
		}
		return ousage(cmd)
	}

	HistoryCmd.SetHelpFunc(help)
	HistoryCmd.SetUsageFunc(usage)

}
