---
title: Contributing

keywords:
- contributor guide
- development setup
- adding and running tests
- debugging hof

separator: true
type: page
weight: 900
---


{{<lead>}}
Want to help make `hof` better? There are a lot of ways to contribute.
This section will help you get started and the best practices.
{{</lead>}}


### Where to get started

For small changes, typos, or new tests, you can often just open a small pull request.
For most other changes, we recommend you start by opening an issue or asking on Slack.
The GitHub issue templates have questions which can help guide you
and we're always happy to chat on Slack.

If you want help finding a task to work on, we can help you there too.

[The setup guide](/contributing/setup/) will help you get ready for development.

### How you can contribute

1. [Open an issue](https://github.com/hofstadter-io/hof/issues/new/choose) or [start a discussion](https://github.com/hofstadter-io/hof/discussions/new/choose),
   we appreciate your feedback
1. [The code & tests page](/contributing/code/) will help you get started with code contributions
1. [The documentation page](/contributing/docs/) will help you get started with docs contributions
1. [Create a generator](/the-walkthrough/) and share it with the community
1. Asking or answering questions on Slack & GitHub

