---
title: "Private Packages"
---

## Custom Hermit

Hermit has a configurable command-line entry point which can be useful if you need to use
a custom HTTP client in order to access your private packages or manifest
sources. See the
[hermit main package](https://github.com/cashapp/hermit/blob/master/cmd/hermit/main.go) for an
example of how this is used.

This can be used to specify a custom set of sources, and other configuration, for your org.

## Private Channel

If you ship your own version of Hermit you must choose a unique channel name
(typically your organization's name), eg. For Square this would be `square`.
If you don't choose a unique channel your users may end up using the public
Hermit accidentally, creating confusion.

## Installer Script

!!! note
    The Hermit installer **requires** the parent path component of its install URL to
    be the same as the channel name.


A custom `install.sh` can be generated by `cmd/geninstaller`:

```shell
geninstaller --dest=install.sh --dist-url=https://mycompany.com/mycompany/hermit-install.sh
```

## Private GitHub Releases

Private GitHub Releases can be accessed with
a [Personal Access Token](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token),
an [OAuth token](https://docs.github.com/en/github/extending-github/git-automation-with-oauth-tokens)
or a [GitHub App installation token](https://docs.github.com/en/developers/apps/building-github-apps/authenticating-with-github-apps).
This token must have the `repo` scope set at creation.

The environment variable `HERMIT_GITHUB_TOKEN` must be set to this a token.
