package shell

const (
	hookStartMarker = "# Generated by Hermit; START; DO NOT EDIT."
	hookEndMarker   = "# Generated by Hermit; END; DO NOT EDIT."
	commonHooks     = `
change_hermit_env() {
  CUR=${PWD}
  while [ "$CUR" != "/" ]; do
    if [ "${CUR}" -ef "${HERMIT_ENV}" ]; then return; fi
    if [ -f "${CUR}/bin/activate-hermit" ]; then
      if [ -n "${HERMIT_ENV+_}"  ]; then type _hermit_deactivate &>/dev/null && _hermit_deactivate; fi
      # shellcheck source=files/activate-hermit
      if [ "${CUR}" != "${DEACTIVATED_HERMIT}" ]; then
        . "${CUR}/bin/activate-hermit"
      fi
      return
    fi
    CUR="$(dirname "${CUR}")"
  done
  unset DEACTIVATED_HERMIT
  if [ -n "${HERMIT_ENV+_}"  ]; then type _hermit_deactivate &>/dev/null && _hermit_deactivate; fi
}
`
)
