package jarm

import (
	"testing"
)

func TestRandomGrease(t *testing.T) {
	for x := 0; x < 1024; x++ {
		g := RandomGrease()
		if len(g) != 2 {
			t.Fatalf("grease wrong length: %d", g)
		}
		g[0] |= 0xf0
		g[1] |= 0xf0
		if g[0] != 0xfa {
			t.Fatalf("grease[0] wrong low bit: %.2x", g[0])
		}
		if g[1] != 0xfa {
			t.Fatalf("grease[1] wrong low bit: %.2x", g[1])
		}
	}
}

func TestRawToJARM(t *testing.T) {
	raw := "c02f|0303|http/1.1|0000-ff01-000b-0023-0010,c02f|0303|http/1.1|0000-ff01-000b-0023-0010,|||,c02f|0303||0000-ff01-000b-0023,c02f|0303||0000-ff01-000b-0023,|||,c02f|0303|http/1.1|0000-ff01-000b-0023-0010,c02f|0303|http/1.1|0000-ff01-000b-0023-0010,c02f|0303|http/1.1|0000-ff01-000b-0023-0010,c02f|0303|http/1.1|0000-ff01-000b-0023-0010"
	exp := "29d29d00029d29d00029d29d29d29d8c9dac4e97f99c7a0e93e9d4d790df0a"
	fuz := RawHashToFuzzyHash(raw)
	if fuz != exp {
		t.Fatalf("fuzzy hash is wrong, got %s wanted %s", fuz, exp)
	}
}

func TestParseServerHello(t *testing.T) {
	details := JarmProbeOptions{Hostname: "console.rumble.run", Port: 443, Version: 772, Ciphers: "ALL", CipherOrder: "MIDDLE_OUT", Grease: "GREASE", ALPN: "ALPN", V13Mode: "1.3_Support", ExtensionOrder: "REVERSE"}
	hello := []byte{0x16, 0x3, 0x3, 0x0, 0x50, 0x2, 0x0, 0x0, 0x4c, 0x3, 0x3, 0x33, 0x1f, 0x11, 0x32, 0x3d, 0x4c, 0xb2, 0x2e, 0x19, 0x6c, 0x96, 0x61, 0xa2, 0xa8, 0x64, 0x3c, 0xb4, 0x8b, 0xe6, 0x56, 0x15, 0x22, 0xc, 0xd3, 0xbb, 0x3e, 0x19, 0x8e, 0x6, 0xa9, 0x6, 0xb1, 0x0, 0xc0, 0x2f, 0x0, 0x0, 0x24, 0x0, 0x0, 0x0, 0x0, 0xff, 0x1, 0x0, 0x1, 0x0, 0x0, 0xb, 0x0, 0x4, 0x3, 0x0, 0x1, 0x2, 0x0, 0x23, 0x0, 0x0, 0x0, 0x10, 0x0, 0xb, 0x0, 0x9, 0x8, 0x68, 0x74, 0x74, 0x70, 0x2f, 0x31, 0x2e, 0x31, 0x16, 0x3, 0x3, 0x12, 0xf1, 0xb, 0x0, 0x12, 0xed, 0x0, 0x12, 0xea, 0x0, 0x5, 0x82, 0x30, 0x82, 0x5, 0x7e,
		0x30, 0x82, 0x4, 0x66, 0xa0, 0x3, 0x2, 0x1, 0x2, 0x2, 0x10, 0x2, 0x47, 0x21, 0x4a, 0x72, 0xc5, 0x12, 0x84, 0xfc, 0x10, 0x55, 0xab, 0x80, 0x8f, 0xfe, 0xf1, 0x30, 0xd, 0x6, 0x9, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0xd, 0x1, 0x1, 0xb, 0x5, 0x0, 0x30, 0x46, 0x31, 0xb, 0x30, 0x9, 0x6, 0x3, 0x55, 0x4, 0x6, 0x13, 0x2, 0x55, 0x53, 0x31, 0xf, 0x30, 0xd, 0x6, 0x3, 0x55, 0x4, 0xa, 0x13, 0x6, 0x41, 0x6d, 0x61, 0x7a, 0x6f, 0x6e, 0x31, 0x15, 0x30, 0x13, 0x6, 0x3, 0x55, 0x4, 0xb, 0x13, 0xc, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x43, 0x41, 0x20, 0x31, 0x42, 0x31, 0xf, 0x30, 0xd, 0x6, 0x3, 0x55, 0x4,
		0x3, 0x13, 0x6, 0x41, 0x6d, 0x61, 0x7a, 0x6f, 0x6e, 0x30, 0x1e, 0x17, 0xd, 0x32, 0x30, 0x30, 0x37, 0x31, 0x34, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x17, 0xd, 0x32, 0x31, 0x30, 0x38, 0x31, 0x34, 0x31, 0x32, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x30, 0x1d, 0x31, 0x1b, 0x30, 0x19, 0x6, 0x3, 0x55, 0x4, 0x3, 0x13, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x2e, 0x72, 0x75, 0x6d, 0x62, 0x6c, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x30, 0x82, 0x1, 0x22, 0x30, 0xd, 0x6, 0x9, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0xd, 0x1, 0x1, 0x1, 0x5, 0x0, 0x3, 0x82, 0x1, 0xf, 0x0, 0x30, 0x82, 0x1, 0xa, 0x2, 0x82, 0x1, 0x1, 0x0, 0xb4, 0x79, 0xc9, 0xd8, 0xd6, 0x1f, 0x9c, 0x6e, 0xa1, 0x61, 0x58, 0xb5, 0x96, 0x68, 0xae, 0xbf, 0x37, 0xc4, 0x72, 0xd8, 0x7c, 0xa, 0x4f, 0xa8, 0x7a, 0x3a, 0xaf, 0x58, 0x44, 0x78, 0xe6, 0xe9, 0x3e, 0x54, 0xf6, 0x94, 0xaf, 0xd9, 0xaa, 0x91, 0xa0, 0x43, 0x10, 0x1, 0x90, 0x94, 0xd2, 0xfd, 0x56, 0xed, 0x7, 0xf1, 0xc8, 0xc9, 0x6f, 0x2a, 0xd3, 0xac, 0x7e, 0x20, 0xa8, 0x4a, 0xb6, 0xf0, 0x4b, 0x58, 0x3d, 0x0, 0x87, 0xa2, 0x5b, 0x6f, 0xd7, 0x5e, 0x51, 0x92, 0xbc, 0x4b, 0x15, 0x26, 0x67, 0xa, 0x84, 0x6b, 0xb8, 0xdd, 0xb7, 0x40, 0x42, 0x98, 0x50, 0x71, 0xce, 0x3e, 0xd, 0x67, 0x43, 0xe8, 0xa2, 0xc6, 0x2e, 0xd3, 0x5b, 0xc6, 0xf1, 0xda, 0xfb, 0x0, 0xea, 0x74, 0xc3, 0x99, 0xa8, 0x8d, 0x80, 0x5d, 0xa9, 0x38, 0x19, 0x14, 0xf0, 0xac, 0xe1, 0x54, 0xbe, 0x95, 0x3f, 0xdd, 0xf, 0x17, 0x56, 0xc4, 0x36, 0xf7, 0x3f, 0xfa, 0x7d, 0xa2, 0x1d, 0xb4, 0x4b, 0x98, 0xab, 0xe9, 0x55, 0x64, 0x74, 0x57, 0xf2, 0x7e, 0x3a, 0x64, 0x56, 0x57, 0x77, 0x9d, 0x7b, 0xd7, 0x12, 0x37, 0x4e, 0x45, 0xe5, 0x54, 0xe0, 0x92, 0xda, 0x53, 0xb3, 0xbd, 0xc, 0x98, 0x30, 0xf1, 0xa0, 0x6c, 0x24, 0x46, 0x0, 0x44, 0xf, 0xca, 0xf4, 0x32, 0x6c, 0xe0, 0x7a, 0x55, 0x16, 0x1d, 0xf9, 0x24, 0xef, 0x2f, 0x39, 0x27, 0x7f, 0x92, 0x2, 0xf8, 0xde, 0x90, 0x3f, 0xf3, 0x66, 0xd7, 0xf2, 0xb9, 0x15, 0x36, 0x9, 0x5f, 0x24, 0x66, 0x9f, 0x36, 0x9e, 0x19, 0x43, 0x26, 0xe0, 0x74, 0x45, 0x31, 0x9, 0x49, 0x5a, 0x19, 0xa2, 0xb5, 0xa, 0xbb, 0xa4, 0xa, 0x98, 0x63, 0xcb, 0x48, 0x21, 0xb, 0xd8, 0x12, 0xd6, 0x30, 0xd9, 0xdc, 0x95, 0x38, 0xce, 0xbc, 0x9, 0x21, 0x49, 0x49, 0x8e, 0xbb, 0x2, 0x3, 0x1, 0x0, 0x1, 0xa3, 0x82, 0x2, 0x8f, 0x30, 0x82, 0x2, 0x8b, 0x30, 0x1f, 0x6, 0x3, 0x55, 0x1d, 0x23, 0x4, 0x18, 0x30, 0x16, 0x80, 0x14, 0x59, 0xa4, 0x66, 0x6, 0x52, 0xa0, 0x7b, 0x95, 0x92, 0x3c, 0xa3, 0x94, 0x7, 0x27, 0x96, 0x74,
		0x5b, 0xf9, 0x3d, 0xd0, 0x30, 0x1d, 0x6, 0x3, 0x55, 0x1d, 0xe, 0x4, 0x16, 0x4, 0x14, 0x79, 0xdc, 0x51, 0xf, 0xdb, 0x2a, 0x96, 0x17, 0xc8, 0x80, 0x9c, 0xaa, 0xd8, 0x9f, 0x32, 0xa4, 0x0, 0xdd, 0x79, 0xb4, 0x30, 0x2d, 0x6, 0x3, 0x55, 0x1d, 0x11, 0x4, 0x26, 0x30, 0x24, 0x82, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x2e, 0x72, 0x75, 0x6d, 0x62, 0x6c, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x82, 0xe, 0x68, 0x75, 0x62, 0x2e, 0x72, 0x75, 0x6d, 0x62, 0x6c, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x30, 0xe, 0x6, 0x3, 0x55, 0x1d, 0xf, 0x1, 0x1, 0xff, 0x4, 0x4, 0x3, 0x2, 0x5, 0xa0, 0x30, 0x1d, 0x6, 0x3, 0x55, 0x1d, 0x25, 0x4, 0x16, 0x30, 0x14, 0x6, 0x8, 0x2b, 0x6, 0x1, 0x5, 0x5, 0x7, 0x3, 0x1, 0x6, 0x8, 0x2b, 0x6, 0x1, 0x5, 0x5, 0x7, 0x3, 0x2, 0x30, 0x3b, 0x6, 0x3, 0x55, 0x1d, 0x1f, 0x4, 0x34, 0x30, 0x32, 0x30, 0x30, 0xa0, 0x2e, 0xa0, 0x2c, 0x86, 0x2a, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x63, 0x72, 0x6c, 0x2e, 0x73, 0x63, 0x61, 0x31, 0x62, 0x2e, 0x61, 0x6d, 0x61, 0x7a, 0x6f, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x73, 0x63, 0x61, 0x31, 0x62, 0x2e, 0x63, 0x72, 0x6c, 0x30, 0x20, 0x6, 0x3, 0x55, 0x1d, 0x20, 0x4, 0x19, 0x30, 0x17, 0x30, 0xb, 0x6, 0x9, 0x60, 0x86, 0x48, 0x1, 0x86, 0xfd, 0x6c, 0x1, 0x2, 0x30, 0x8, 0x6, 0x6, 0x67, 0x81, 0xc, 0x1, 0x2, 0x1, 0x30, 0x75, 0x6, 0x8, 0x2b, 0x6, 0x1, 0x5, 0x5, 0x7, 0x1, 0x1, 0x4, 0x69, 0x30, 0x67, 0x30, 0x2d, 0x6, 0x8, 0x2b, 0x6, 0x1, 0x5, 0x5, 0x7, 0x30, 0x1, 0x86, 0x21, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x6f, 0x63, 0x73, 0x70, 0x2e, 0x73, 0x63, 0x61, 0x31, 0x62, 0x2e, 0x61, 0x6d, 0x61, 0x7a, 0x6f, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x30, 0x36, 0x6, 0x8, 0x2b, 0x6, 0x1, 0x5, 0x5, 0x7, 0x30, 0x2, 0x86, 0x2a, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x63, 0x72, 0x74, 0x2e, 0x73, 0x63, 0x61, 0x31, 0x62, 0x2e, 0x61, 0x6d, 0x61, 0x7a, 0x6f, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x73, 0x63, 0x61, 0x31, 0x62, 0x2e, 0x63, 0x72, 0x74, 0x30, 0xc, 0x6, 0x3, 0x55, 0x1d, 0x13, 0x1, 0x1, 0xff, 0x4, 0x2, 0x30, 0x0, 0x30, 0x82, 0x1, 0x5, 0x6, 0xa, 0x2b, 0x6, 0x1, 0x4, 0x1, 0xd6, 0x79, 0x2, 0x4, 0x2, 0x4, 0x81, 0xf6, 0x4, 0x81, 0xf3, 0x0, 0xf1, 0x0, 0x77, 0x0, 0xf6, 0x5c, 0x94, 0x2f, 0xd1, 0x77, 0x30, 0x22, 0x14, 0x54, 0x18, 0x8, 0x30, 0x94, 0x56, 0x8e, 0xe3, 0x4d, 0x13, 0x19, 0x33, 0xbf, 0xdf, 0xc, 0x2f, 0x20, 0xb, 0xcc, 0x4e, 0xf1, 0x64, 0xe3, 0x0, 0x0, 0x1, 0x73, 0x4a, 0xba, 0xae, 0x1f, 0x0, 0x0, 0x4, 0x3, 0x0, 0x48, 0x30, 0x46, 0x2, 0x21, 0x0, 0xbf, 0x25, 0x5d, 0xf6, 0xa2, 0x10, 0xc5, 0x43, 0x7d, 0x75, 0x83, 0x74, 0x1d, 0xa1, 0x8e, 0x8e, 0xfb, 0x3d, 0x1e, 0x25, 0x2a, 0x23, 0xf0, 0xd4, 0x99, 0xb8, 0xcc, 0x17, 0x37, 0xae, 0x66, 0xf6, 0x2, 0x21, 0x0, 0x9e, 0x39, 0x57, 0x62, 0xb3, 0x6a, 0xc, 0xe, 0xad, 0x95, 0xa8, 0xa6, 0x66, 0x8, 0x22, 0xf7, 0xc4, 0xf4, 0x7, 0x68, 0xd, 0x50, 0x34, 0xc6, 0x67, 0xfc, 0x1, 0x81, 0xda, 0xba, 0x12, 0x6c, 0x0, 0x76, 0x0, 0x5c, 0xdc, 0x43, 0x92, 0xfe, 0xe6, 0xab, 0x45, 0x44, 0xb1, 0x5e, 0x9a, 0xd4, 0x56, 0xe6, 0x10, 0x37, 0xfb, 0xd5, 0xfa, 0x47, 0xdc, 0xa1, 0x73, 0x94, 0xb2, 0x5e, 0xe6, 0xf6, 0xc7, 0xe, 0xca, 0x0, 0x0, 0x1, 0x73, 0x4a, 0xba, 0xae, 0x49, 0x0, 0x0, 0x4, 0x3, 0x0, 0x47, 0x30, 0x45, 0x2, 0x21, 0x0, 0x81, 0x77, 0x3c, 0x24, 0xa1, 0x27, 0xc5, 0xfa, 0xea, 0x36, 0xb4, 0xe7, 0xab, 0xcb, 0xc9, 0xc9, 0x10, 0xcb, 0xbb, 0x37, 0xa6, 0x45, 0x38, 0xe7, 0x77, 0xa1, 0x27, 0xa7, 0xd, 0x28, 0x5f, 0x89, 0x2, 0x20, 0x67, 0xf8, 0xac, 0x66, 0xf6, 0x4e, 0xc4, 0x77, 0x53, 0x93, 0xdf, 0x86, 0x84, 0xc, 0xfc, 0xfa, 0xa4, 0x32, 0x68, 0x7e, 0x31, 0x5, 0x29, 0x5d, 0xf3,
		0xa8, 0x3f, 0xb6, 0x2d, 0x80, 0x74, 0xd9, 0x30, 0xd, 0x6, 0x9, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0xd, 0x1, 0x1, 0xb, 0x5, 0x0, 0x3, 0x82, 0x1, 0x1, 0x0, 0x6d, 0x3c, 0x16, 0xdb, 0x1e, 0x60, 0x26, 0x42, 0x61, 0xc2, 0xec, 0x7b, 0xa2, 0x2f, 0x9e, 0x93, 0x57, 0x5b, 0xf3, 0x64, 0xe6, 0x7c, 0x4c, 0x7e, 0xf8, 0x36, 0xb5, 0xf7, 0x35, 0x9c, 0x7f, 0xf1, 0x20, 0xe9, 0x1, 0xcd, 0x1c, 0x8f, 0xb8, 0x1a, 0xc5, 0x56, 0x43, 0x71, 0xc5, 0xed, 0x38, 0x66, 0x5f, 0x40, 0x94, 0x0, 0x9c, 0xc4, 0x5, 0x91, 0xb4, 0x58, 0x13, 0xba, 0x6c, 0x32, 0xfd, 0x60, 0xd4, 0x6e, 0xdd, 0xf8, 0x85, 0x35, 0xbf, 0xbf, 0x50, 0xbf,
		0xd9, 0x33, 0xdd, 0xfb, 0x1e, 0xd7, 0xed, 0xf8, 0x6c, 0xdf, 0x6c, 0x64, 0x4a, 0xb3, 0x3c, 0xd2, 0xb3, 0xdf, 0xcc, 0xd5, 0xe6, 0x90, 0x92, 0x5e, 0x86, 0xe9, 0xbd, 0x90, 0x73, 0xe6, 0xa0, 0x31, 0x3, 0x49, 0x8c, 0x44, 0xa1, 0xc0, 0x5c, 0x63, 0xba, 0xfe, 0x79, 0x61, 0xcb, 0xca, 0xbd, 0x52, 0x99, 0xc8, 0x5f, 0x15, 0x96, 0x58, 0x47, 0xb7, 0x79, 0x5, 0x58, 0x37, 0x76, 0x37, 0x4e, 0x26, 0x27, 0xae, 0x73, 0x66, 0x84, 0x0, 0x56, 0x6a, 0x37, 0x77, 0x99, 0x81, 0x3d, 0x4e, 0x95, 0x88, 0x6b, 0x37, 0xd1, 0x23, 0x7e, 0x8e, 0x6a, 0xa3, 0x1c, 0x3e, 0x38, 0x1a, 0x3f, 0xd1, 0x5e, 0x6, 0x6c, 0x55, 0x47,
		0xa2, 0x34, 0x5d, 0x52, 0xee, 0x4d, 0x7c, 0x57, 0xe, 0xd, 0x7, 0xfa, 0x36, 0xe0, 0x5e, 0x8f, 0x4f, 0xce, 0xb1, 0xe1, 0x33, 0xb5, 0xb5, 0xf5, 0x9c, 0xc7, 0xa8, 0xbc, 0x76, 0xd5, 0x51, 0x3, 0x24, 0xa0, 0xeb, 0x61, 0x45, 0xbd, 0x5e, 0x36, 0x2f, 0x31, 0x57, 0x56, 0x0, 0xa0, 0x65, 0x3a, 0xab, 0x95,
		0x7c, 0x4a, 0xe0, 0xa6, 0x5a, 0x57, 0x7d}
	exp := "c02f|0303|http/1.1|0000-ff01-000b-0023-0010"

	ans, err := ParseServerHello(hello, details)
	if err != nil {
		t.Fatalf("parse hello error: %s", err)
	}

	if ans != exp {
		t.Fatalf("parse hello expected %s got %s", exp, ans)
	}
}
