---
layout: "docs"
page_title: "Token Authentication"
sidebar_title: "Token Authentication"
sidebar_current: "docs-internals-token"
description: |-
  Learn about the client token authentication in Vault.
---

# Token Authentication

The `token` auth method is built-in and is at the core of
client authentication. Other auth methods may be used to
authenticate a client, but they eventually result in the generation of a client
token managed by the `token` backend.

Every token has a number of properties:

* ID - The primary ID of a token is a randomly generated value
* Display Name - Optionally, a human readable display name
* Metadata - Metadata used for audit logging
* Number of Uses - Optionally, a restricted use count
* Parent ID - Optionally, a parent token which created this child token
* Policies - An associated list of ACL policies
* Source Path - The path at which the token was generated (e.g. `auth/github/login`)

The properties of a token are immutable once created. The exception to this
is the number of uses, which is decremented on each request. Each of these
properties enable Vault to do a number of interesting things.

Each token maintains the source path, or the login path, that was used
to create the token. This is used to allow source based revocation. For example,
if we believe our GitHub organization was compromised, we may want to revoke
all tokens generated via `auth/github/login`. This would be done by using the
`sys/revoke-prefix/` API with the `auth/github/` prefix. Revoking the
prefix will revoke all client tokens generated at that path, as well as all
dynamic secrets generated by those tokens. This provides a powerful "break glass"
procedure during a potential compromise.

If a token is created by another auth method, they do not have
a parent token. However, any tokens created by the `auth/token/create` API
have a parent token, namely the token used to make that request. By maintaining
this parent-child relationship, Vault models token trees. Child tokens can
be created with a subset of the parent policies, allowing for dropping of
privileges. When a token is revoked, the entire sub-tree of tokens is revoked
with it. This allows clients to safely generate child tokens and then revoke
them all along with the root.

Child tokens are very useful, especially when combined with limited use tokens.
When a token is created, its use count can be optionally specified. Providing
a use count of one makes a _one time token_. This means the token can be used
for a single request before being automatically revoked. This can be generalized
to any number of uses. Limited use tokens cannot be used to create sub-tokens,
but they can be a powerful way to allow extremely limited access to Vault.
